/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.businessrules.mapping.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.impl.RB;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class BusinessRuleMapping
extends BaseMapping
implements IBusinessRuleMapping {
    private IBusinessRuleFlowTable m_businessSourceTable;
    private List<IBusinessRuleFlowColumn> m_businessRuleColumns = new ArrayList<IBusinessRuleFlowColumn>();
    private boolean m_bIsReplacingColumn = false;

    public BusinessRuleMapping(String sID, IModel model) {
        super(sID, model);
        this.setType("BusinessRule");
    }

    @Override
    public String getType() {
        return "BusinessRule";
    }

    @Override
    public boolean isOrdinary() {
        return false;
    }

    @Override
    public IColumn[] getTargets() {
        return new IColumn[0];
    }

    @Override
    public int getTargetCount() {
        return this.m_businessRuleColumns.size();
    }

    @Override
    public void addTarget(IColumn column) {
    }

    @Override
    public void addTarget(int iTarget, IColumn column) {
    }

    @Override
    public void addTargetBusinessRuleColumn(IBusinessRuleFlowColumn column) {
        this.addTargetBusinessRuleColumn(this.m_businessRuleColumns.size(), column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTargetBusinessRuleColumn(int iTarget, IBusinessRuleFlowColumn column) {
        this.startCompoundUndoable();
        try {
            this.m_businessRuleColumns.add(iTarget, column);
            this.fireModelChangedEvent("Mapping:TargetColumnAdded", column);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddTargetUndoable(iTarget, column));
            }
            if (this.isAutoType()) {
                this.updateType();
            }
            String expText = "";
            ITextExpression expression = (ITextExpression)this.getExpression();
            if (expression == null) {
                expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                this.setExpression(expression);
                expText = this.getColumnExpression(column);
            } else {
                expText = expText + "::" + this.getColumnExpression(column);
            }
            expression.setText(expText, new IObject[0]);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private String getColumnExpression(IBusinessRuleFlowColumn column) {
        return column.getTable().getID() + '.' + column.getID();
    }

    @Override
    public void clearTargets() {
        IBusinessRuleFlowColumn[] targets = this.getTargetsOfBusinessRuleColumn();
        this.startCompoundUndoable();
        try {
            for (int i = 0; i < targets.length; ++i) {
                this.removeTargetBusinessRuleColumn(targets[i]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void replaceTargetColumn(IColumn oldColumn, IColumn newColumn) {
    }

    @Override
    public void removeTarget(IColumn column) {
    }

    @Override
    protected boolean isSourceAndTargetComplete() {
        return this.getSourceCount() == 1 && this.getTargetCount() == 1;
    }

    @Override
    protected boolean isExpressionNeeded() {
        return false;
    }

    @Override
    public boolean containsInTargets(IColumn column) {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public List<String> getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_businessRuleColumns.size() == 0 && this.isOrdinary()) {
            lReasons.add(RB.getStringResource("BusinessRuleMapping.ReasonIncomplete.MissingTarget.txt"));
        }
        return lReasons;
    }

    @Override
    public String getWarning() {
        IBusinessRuleFlowColumn brColumn = this.getTargetOfBusinessRuleColumn();
        IColumn sourceColumn = this.getSource();
        if (brColumn != null && sourceColumn != null && brColumn.getSASType() != sourceColumn.getType()) {
            return MessageFormat.format(RB.getStringResource("BusinessRuleMapping.Warning.OneToOne.TypeMismatch.txt"), sourceColumn.getName(), brColumn.getName());
        }
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return this.getWarning() != null;
    }

    @Override
    public List getWarnings() {
        ArrayList<String> lst = new ArrayList<String>();
        String warn = this.getWarning();
        if (warn != null) {
            lst.add(warn);
        }
        return lst;
    }

    @Override
    public boolean isDead() {
        return this.getSourceCount() == 0 || this.getTargetsOfBusinessRuleColumn().length == 0;
    }

    @Override
    protected void saveTargetsToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
    }

    @Override
    public void setBusinessRuleFlowTable(IBusinessRuleFlowTable table) {
        if (this.m_businessSourceTable == table) {
            return;
        }
        this.m_businessSourceTable = table;
        this.loadBusinessRuleColumns();
    }

    private IBusinessRuleFlowColumn findBRColumn(String text) {
        if (this.m_businessSourceTable != null && text != null && text.length() > 0) {
            for (IBusinessRuleFlowColumn c : this.m_businessSourceTable.getColumns()) {
                if (!ObjectComparator.isEqual(this.getColumnExpression(c), text)) continue;
                return c;
            }
        }
        return null;
    }

    private void loadBusinessRuleColumns() {
        for (IBusinessRuleFlowColumn c : this.getTargetsOfBusinessRuleColumn()) {
            this.removeTargetBusinessRuleColumn(c);
        }
        ITextExpression expression = (ITextExpression)this.getExpression();
        if (expression != null) {
            String[] columnSplit;
            String expText = expression.getTokenizedText();
            for (String c : columnSplit = expText.split("::")) {
                IBusinessRuleFlowColumn column = this.findBRColumn(c);
                if (column == null) continue;
                this.addTargetBusinessRuleColumn(column);
            }
        }
    }

    @Override
    protected void loadExpressionFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        super.loadExpressionFromOMR(omr, mdoFM);
        this.loadBusinessRuleColumns();
    }

    @Override
    public void dump(PrintStream strm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID());
        sb.append(":");
        sb.append("ONETOONE".equals(this.getType()) ? "1to1" : ("DERIVED".equals(this.getType()) ? "Derived" : this.getType()));
        sb.append(":");
        for (int iSource = 0; iSource < this.getSourceCount(); ++iSource) {
            IColumn source = this.getSources()[iSource];
            sb.append(source + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("->");
        for (int iTarget = 0; iTarget < this.m_businessRuleColumns.size(); ++iTarget) {
            IBusinessRuleFlowColumn target = this.m_businessRuleColumns.get(iTarget);
            sb.append(target.getName() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        strm.println(sb.toString());
    }

    @Override
    public boolean isMappingNeeded(boolean quoting, ITable sourceTable) {
        return true;
    }

    @Override
    public boolean isMappingRename(boolean quoting, ITable sourceTable) {
        return false;
    }

    @Override
    public IColumn getSource() {
        return this.getSourceCount() > 0 ? this.getSources()[0] : null;
    }

    @Override
    public IBusinessRuleFlowColumn getTargetOfBusinessRuleColumn() {
        return !this.m_businessRuleColumns.isEmpty() ? this.m_businessRuleColumns.get(0) : null;
    }

    @Override
    public IBusinessRuleFlowColumn[] getTargetsOfBusinessRuleColumn() {
        return this.m_businessRuleColumns.toArray(new IBusinessRuleFlowColumn[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetBusinessRuleColumn(IBusinessRuleFlowColumn column) {
        block10: {
            if (!this.m_businessRuleColumns.contains(column)) {
                return;
            }
            this.startCompoundUndoable();
            try {
                ITextExpression expression;
                int iTarget = this.m_businessRuleColumns.indexOf(column);
                List tableColumns = this.m_businessSourceTable.getColumns();
                for (int i = 0; i < tableColumns.size(); ++i) {
                    IBusinessRuleFlowColumn col = (IBusinessRuleFlowColumn)tableColumns.get(i);
                    if (!col.getName().equals(column.getName())) continue;
                    this.m_bIsReplacingColumn = true;
                    break;
                }
                this.m_businessRuleColumns.remove(iTarget);
                this.fireModelChangedEvent("Mapping:TargetColumnRemoved", column);
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new RemoveTargetUndoable(iTarget, column));
                }
                if (this.isAutoType()) {
                    this.updateType();
                }
                if ((expression = (ITextExpression)this.getExpression()) == null) break block10;
                String expText = this.getColumnExpression(column);
                try {
                    String existingText = expression.getText(null, false);
                    existingText = existingText.replaceAll(expText + "::", "");
                    if (existingText == null || existingText.length() == 0 || ObjectComparator.isEqual(existingText, "::")) {
                        this.setExpression(null);
                        break block10;
                    }
                    expression.setText(existingText, new IObject[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.m_bIsReplacingColumn = false;
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public boolean containsInTargets(IBusinessRuleFlowColumn column) {
        return this.m_businessRuleColumns.contains(column);
    }

    @Override
    public int indexInTargets(IBusinessRuleFlowColumn column) {
        return this.m_businessRuleColumns.indexOf(column);
    }

    public boolean getIsReplacingColumn() {
        return this.m_bIsReplacingColumn;
    }

    private class RemoveTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IBusinessRuleFlowColumn m_column;

        public RemoveTargetUndoable(int iTarget, IBusinessRuleFlowColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleMapping.this.addTargetBusinessRuleColumn(this.m_iTarget, this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleMapping.this.removeTargetBusinessRuleColumn(this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }

    private class AddTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IBusinessRuleFlowColumn m_column;

        public AddTargetUndoable(int iTarget, IBusinessRuleFlowColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleMapping.this.removeTargetBusinessRuleColumn(this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleMapping.this.addTargetBusinessRuleColumn(this.m_iTarget, this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }
}

