/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.businessrules;

import com.sas.etl.models.DISUsageVersion;
import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlow;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowVersion;
import com.sas.etl.models.data.businessrule.impl.BaseBusinessRuleFlow;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformModel;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionModel;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionModelListener;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionValueChangeListener;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DefaultMappingRules;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleMappingTablePort;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTargetTablePort;
import com.sas.etl.models.job.transforms.businessrules.RB;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMappingsContainer;
import com.sas.etl.models.job.transforms.businessrules.mapping.impl.BusinessRuleMapping;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.ITransformTemplate;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.models.FileLocation;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BusinessRuleTransformModel
extends AbstractMultiplePortTransformModel
implements IBusinessRuleMappingsContainer {
    private static final String PROPERTY_NAME_TYPE = "OUTPUT_TYPE";
    public static final String TRANSFORMATION_CLASS = "com.sas.etl.models.job.transforms.businessrules.BusinessRulesTransformModel";
    public static final String TRANSFORMATION_ROLE = "com.sas.etl.models.job.transforms.businessrules.BusinessRulesTransformModel";
    private static final String ARM_DISPLAY_NAME = "BusinessRule";
    public static final String BUSINESS_RULE_CHANGED = "BusinessRuleTransformModel:BusinessRuleChanged";
    public static final String BUSINESS_RULE_VERSION_CHANGED = "BusinessRuleTransformModel:BusinessRuleVersionChanged";
    public static final String DEBUG_CODE_LOCATION_CHANGED = "BusinessRuleTransformModel:DebugCodeLocationChanged";
    public static final String OPTION_NAME_DEBUG_CODE_LOCATION = "DEBUGCODEFILE";
    private static final String CM_NAME = "BusinessRule";
    private static final String PROPERTY_NAME_BUSINESSRULE_VERSION = "BusinessRuleVersion";
    private static final String PROPERTY_BR_FILE_REF = "BR_XML_FILE_REF";
    private static final String PROPERTY_BR_FILE_OPTS = "BR_FILE_OPTS";
    private static final String PROPERTY_BR_FILE_LRECL = "BR_FILE_LRECL";
    public static final String BR_FILE_REF_CHANGED = "BusinessRuleTransformModel:FileRefChanged";
    public static final String BR_FILE_REF_LRECL_CHANGED = "BusinessRuleTransformModel:FileRefLreclChanged";
    public static final String BR_FILE_REF_OPTS_CHANGED = "BusinessRuleTransformModel:FileRefOptionsChanged";
    private static final String DEFAULT_LRECL = "32767";
    private static final String OPTION_NAME_GENERATE_RULE_FIRED_TABLE = "GENERATE_RULE_FIRED_TABLE";
    public static final String GENERATE_RULE_FIRED_TABLE_CHANGED = "BusinessRuleTransformModel:GenerateRuleFiredTableChanged";
    private static final String OPTION_NAME_USE_SOURCE = "USE_SOURCE";
    public static final String USE_SOURCE_CHANGED = "BusinessRuleTransformModel:UsesourceChanged";
    private IBusinessRuleFlow m_br;
    public static final String PORT_NAME_MAPPING_TABLE = "MAPPING_TABLE";
    private IBusinessRuleFlowVersion _version;
    private static final String INPUTTABLEOPTIONS = "INPUTTABLEOPTIONS";
    private static final String OUTPUT_TABLE_OPTIONS_PREFIX = "OUTOPTIONS";
    private static final String OUTPUT_PREFIX = "OUTPUT";
    private RuleMappingList m_businessRuleMappings = new RuleMappingList(this);
    private String m_debugCodeLocation;
    private String m_brfileRef;
    private String m_brfileRefOpts;
    private String m_brfileRefLrecl;
    private boolean m_bIsGenerateRuleFiredTable = true;
    private boolean m_bUseSource = true;
    private String _ruleChangedMessage;

    public BusinessRuleTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setFileRef(CodeGenerationEnvironment.createWorkTableName8Char(2));
        this.setFileRefLrecl(DEFAULT_LRECL);
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
    }

    @Override
    public ITransformPort<? extends IDataObject> createPort(IModel model, String id, String partnerName) {
        BaseTransformPort port = null;
        IBusinessRuleFlowVersion version = this.getBusinessRuleVersion();
        if (version != null) {
            if (PORT_NAME_MAPPING_TABLE.equals(partnerName)) {
                port = new BusinessRuleMappingTablePort(id, model);
            } else {
                IBusinessRuleFlowTable table = version.findOutputTable(partnerName);
                if (table != null) {
                    port = new BusinessRuleTargetTablePort(id, model);
                    this.updateGeneratedTable(partnerName, port);
                }
            }
        }
        if (port == null) {
            port = new BaseTransformPort(id, this.getModel());
        }
        port.setPartnerName(partnerName);
        return port;
    }

    private void updateGeneratedTable(String partnerName, ITransformPort<?> port) {
        if (!PORT_NAME_MAPPING_TABLE.equals(partnerName)) {
            IBusinessRuleFlowVersion version = this.getBusinessRuleVersion();
            IBusinessRuleFlowTable table = version != null ? version.findOutputTable(partnerName) : null;
            ((BusinessRuleTargetTablePort)port).setBusinessRuleTable(table);
        }
    }

    private ITransformTemplate updateTemplateForVersion(boolean createTemplate, IBusinessRuleFlowVersion version, IPhysicalTable sourceTable, String containerId, IModel model, ITransformTemplate template) {
        ITransformPort<Object> inT;
        if (version == null) {
            return template;
        }
        if (template == null && createTemplate) {
            template = this.createTemplate(model.createIDForNewObject(containerId), model);
            this.setTemplate(template);
        } else if (template == null) {
            return template;
        }
        for (IBusinessRuleFlowTable input : version.getInputs()) {
            inT = template.findSourcePort(input.getID());
            if (inT == null) {
                inT = this.createPort(this.getModel(), model.createIDForNewObject(containerId), input.getID());
                template.addSourcePort(inT);
            }
            inT.setName(input.getName());
            inT.setDescription(input.getDescription());
            if (sourceTable == null) continue;
            inT.setObject(sourceTable);
        }
        for (IBusinessRuleFlowTable output : version.getOutputs()) {
            inT = template.findTargetPort(output.getID());
            if (inT == null) {
                inT = this.createPort(this.getModel(), model.createIDForNewObject(containerId), output.getID());
                template.addTargetPort(inT);
                IProperty type = model.getObjectFactory().createNewProperty(containerId);
                type.setPropertyName(PROPERTY_NAME_TYPE);
                type.setName(PROPERTY_NAME_TYPE);
                type.setDefaultValue(output.getType());
                type.setPropertyRole(PROPERTY_NAME_TYPE);
                inT.addProperty(type);
            }
            this.updateGeneratedTable(output.getID(), inT);
            inT.setName(output.getName());
            inT.setDescription(output.getDescription());
            if (inT.getObject() != null) continue;
            inT.setObject(output.createNewTable(sourceTable, model, containerId));
        }
        return template;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("BusinessRulesTransformModel.Name.txt");
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("BusinessRulesTransformModel.Name.txt");
    }

    @Override
    public String getAbsoluteName() {
        return "BusinessRule";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.etl.models.job.transforms.businessrules.BusinessRulesTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.etl.models.job.transforms.businessrules.BusinessRulesTransformModel";
    }

    public static String getTransformTypeID() {
        return "com.sas.etl.models.job.transforms.businessrules.BusinessRulesTransformModel";
    }

    @Override
    protected void addDefaultTemplate() throws MdException, RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataSource(ITransformPort port, IDataObject source) {
        this.startCompoundUndoable();
        try {
            super.addDataSource(port, source);
            if (source != null) {
                for (IColumn sourceColumn : ((IPhysicalTable)source).getColumns()) {
                    for (IPhysicalTable target : this.getTargetTables()) {
                        IColumn matchingTarget = target.getColumnWithMatchingName(sourceColumn.getName());
                        if (matchingTarget == null) continue;
                        matchingTarget.setType(sourceColumn.getType());
                        matchingTarget.setLength(sourceColumn.getLength());
                        matchingTarget.setDescription(sourceColumn.getDescription());
                        matchingTarget.setFormat(sourceColumn.getFormat());
                        matchingTarget.setInformat(sourceColumn.getInformat());
                    }
                }
                IBusinessRuleFlowTable brmSource = this.getSourceBusinessRuleTable();
                if (brmSource != null) {
                    IPhysicalTable src = (IPhysicalTable)source;
                    for (IBusinessRuleFlowColumn c : brmSource.getColumns()) {
                        IColumn sourceColumn = src.getColumnWithMatchingName(c.getName());
                        if (sourceColumn == null) continue;
                        this.mapColumns(new IColumn[]{sourceColumn}, new IBusinessRuleFlowColumn[]{c});
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            for (IBusinessRuleMapping m : this.getBusinessRuleMappings()) {
                this.removeMapping(m);
            }
            super.removeDataSource(source);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected boolean canSetTemplate(ITransformTemplate newTemplate) {
        return this.getTemplate() == null;
    }

    @Override
    protected void templateChangedRequested(ITransformTemplate newTemplate) {
        if (newTemplate == null) {
            return;
        }
        ITransformTemplate oldTemplate = this.getTemplate();
        if (newTemplate.findTargetPort(PORT_NAME_MAPPING_TABLE) == null) {
            this.createMappingPortAndTable(newTemplate);
        }
        if (oldTemplate == null) {
            this.updateTemplateForVersion(false, this.getBusinessRuleVersion(), this.getSourceTable(), this.getID(), this.getModel(), newTemplate);
            return;
        }
        for (ITransformPort<?> p : newTemplate.getTargetPorts()) {
            if (oldTemplate.findTargetPort(p.getPartnerName()) != null) continue;
            oldTemplate.addTargetPort(p);
        }
        if (oldTemplate.findTargetPort(PORT_NAME_MAPPING_TABLE) == null) {
            this.createMappingPortAndTable(oldTemplate);
        }
    }

    private void createMappingPortAndTable(ITransformTemplate template) {
        ITransformPort<? extends IDataObject> port = this.createPort(this.getModel(), this.createIDForNewObject(), PORT_NAME_MAPPING_TABLE);
        template.addTargetPort(0, port);
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public boolean isAddOutputAvailable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPortGeneratedTable(ITransformPort<IPhysicalTable> port) {
        IGeneratedTable<IGeneratedTableColumn> table;
        if (port != null && (table = port.getGeneratedTable()) != null) {
            this.startCompoundUndoable();
            try {
                IPhysicalTable pt = table.createNewTable(this.getSourceTable(), this.getModel(), this.getID());
                if (pt != null) {
                    port.setObject(pt);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings() || this._ruleChangedMessage != null || this.isNewerVersionAvailable() != null) {
            return true;
        }
        for (IBusinessRuleMapping brMapping : this.getBusinessRuleMappingList()) {
            if (!brMapping.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getWarnings() {
        String versionWarning;
        List warns = super.getWarnings();
        for (IBusinessRuleMapping brMapping : this.getBusinessRuleMappingList()) {
            warns.addAll(brMapping.getWarnings());
        }
        if (this._ruleChangedMessage != null) {
            warns.add(this._ruleChangedMessage);
        }
        if ((versionWarning = this.isNewerVersionAvailable()) != null) {
            warns.add(versionWarning);
        }
        return warns;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.m_br != null && this._version != null && this.isBusinessRuleMappingsComplete();
    }

    public boolean isBusinessRuleMappingsComplete() {
        IBusinessRuleFlowTable source = this.getSourceBusinessRuleTable();
        if (source != null) {
            for (IBusinessRuleFlowColumn c : source.getColumns()) {
                if (this.findTargetMapping(c) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_br == null) {
            lReasons.add(RB.getStringResource("BusinessRulesTransformModel.ReasonIncomplete.NoBusinessRulesSelected.txt"));
        }
        if (this.m_br != null && this._version == null) {
            lReasons.add(RB.getStringResource("BusinessRulesTransformModel.ReasonIncomplete.NoVersionSelected.txt"));
        }
        if (this.m_br != null && this._version != null) {
            lReasons.addAll(this.getReasonsBRMappingsIncomplete());
        }
        return lReasons;
    }

    public List getReasonsBRMappingsIncomplete() {
        ArrayList<String> reasons = new ArrayList<String>();
        IBusinessRuleFlowTable source = this.getSourceBusinessRuleTable();
        if (source != null) {
            for (IBusinessRuleFlowColumn c : source.getColumns()) {
                if (this.findTargetMapping(c) != null) continue;
                reasons.add(MessageFormat.format(RB.getStringResource("BusinessRulesTransformModel.TermMissingMaping.txt"), c.getName()));
            }
        }
        return reasons;
    }

    public String getFileRef() {
        return this.m_brfileRef;
    }

    public void setFileRef(String ref) {
        if (ObjectComparator.isEqual(this.m_brfileRef, ref, false)) {
            return;
        }
        String old = this.m_brfileRef;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBusinessRuleFileRefUndoable(this.m_brfileRef, old));
        }
        this.m_brfileRef = ref;
        this.fireModelChangedEvent(BR_FILE_REF_CHANGED, this.m_brfileRef, old);
    }

    public String getFileRefOptions() {
        return this.m_brfileRefOpts;
    }

    public void setFileRefOptions(String opts) {
        if (ObjectComparator.isEqual(this.m_brfileRefOpts, opts, false)) {
            return;
        }
        String old = this.m_brfileRefOpts;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBusinessRuleFileRefOptionsUndoable(this.m_brfileRefOpts, old));
        }
        this.m_brfileRefOpts = opts;
        this.fireModelChangedEvent(BR_FILE_REF_OPTS_CHANGED, this.m_brfileRefOpts, old);
    }

    public String getFileRefLrecl() {
        return this.m_brfileRefLrecl;
    }

    public void setFileRefLrecl(String lrecl) {
        if (ObjectComparator.isEqual(this.m_brfileRefLrecl, lrecl, false)) {
            return;
        }
        String old = this.m_brfileRefLrecl;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBusinessRuleFileRefLreclUndoable(this.m_brfileRefLrecl, old));
        }
        this.m_brfileRefLrecl = lrecl;
        this.fireModelChangedEvent(BR_FILE_REF_LRECL_CHANGED, this.m_brfileRefLrecl, old);
    }

    public IBusinessRuleFlowVersion getBusinessRuleVersion() {
        return this._version;
    }

    public void setBusinessRuleVersion(IBusinessRuleFlowVersion version) {
        this.setBusinessRuleVersion(version, true, this.getSourceTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBusinessRuleVersion(IBusinessRuleFlowVersion version, boolean setTemplate, IPhysicalTable sourceTable) {
        if (this._version == version) {
            return;
        }
        this.startCompoundUndoable();
        IBusinessRuleFlowVersion old = this._version;
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetBusinessRuleVersionUndoable(this._version, old));
            }
            this._version = version;
            this.updateTemplateForVersion(setTemplate, this._version, sourceTable, this.getID(), this.getModel(), this.getTemplate());
            this.m_businessRuleMappings.setSourceBusinessRuleTable(this.getSourceBusinessRuleTable());
        }
        finally {
            this.endCompoundUndoable();
        }
        this.fireModelChangedEvent(BUSINESS_RULE_VERSION_CHANGED, this._version, old);
    }

    public String getDebugCodeLocation() {
        return this.m_debugCodeLocation;
    }

    public void setDebugCodeLocation(String location) {
        if (ObjectComparator.isEqual(this.m_debugCodeLocation, location)) {
            return;
        }
        String old = this.m_debugCodeLocation;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDebugCodeLocationUndoable(this.m_debugCodeLocation, location));
        }
        this.m_debugCodeLocation = location;
        this.fireModelChangedEvent(DEBUG_CODE_LOCATION_CHANGED, location, old);
    }

    public IBusinessRuleFlow getBusinessRule() {
        return this.m_br;
    }

    public void setBusinessRule(IBusinessRuleFlow br) {
        this.setBusinessRule(br, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBusinessRule(IBusinessRuleFlow br, boolean setDefaultVersion) {
        if (this.m_br == br) {
            return;
        }
        this.startCompoundUndoable();
        IBusinessRuleFlow old = this.m_br;
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetBusinessRuleUndoable(this.m_br, br));
            }
            this.m_br = br;
            this.fireModelChangedEvent(BUSINESS_RULE_CHANGED, this.m_br, old);
            if (setDefaultVersion) {
                this.setBusinessRuleVersion(this.m_br != null ? this.m_br.getDefaultVersion() : null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public boolean isGenerateRuleFiredTable() {
        return this.m_bIsGenerateRuleFiredTable;
    }

    public void setGenerateRuleFiredTable(boolean bValue) {
        if (bValue == this.m_bIsGenerateRuleFiredTable) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIsGenerateRuleFiredTableUndoable(this.m_bIsGenerateRuleFiredTable, bValue));
        }
        this.m_bIsGenerateRuleFiredTable = bValue;
        this.fireModelChangedEvent(GENERATE_RULE_FIRED_TABLE_CHANGED, null);
    }

    public boolean isUseSource() {
        return this.m_bUseSource;
    }

    public void setUseSource(boolean bValue) {
        if (bValue == this.m_bUseSource) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIsGenerateRuleFiredTableUndoable(this.m_bUseSource, bValue));
        }
        this.m_bUseSource = bValue;
        this.fireModelChangedEvent(USE_SOURCE_CHANGED, null);
    }

    protected String booleanToYesNo(boolean bool) {
        return bool ? "YES" : "NO";
    }

    protected boolean yesNoToBoolean(String YesNo) {
        return YesNo.equalsIgnoreCase("YES");
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cBusinessRulesOptionModel(this.getModel(), this);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IBusinessRuleFlowVersion version;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole("BusinessRule");
        AssociationList lSourceSpecifications = mdoCM.getSourceSpecifications();
        lSourceSpecifications.clear();
        IBusinessRuleFlow flow = this.getBusinessRule();
        if (flow != null) {
            Transformation mdoFlow = (Transformation)omr.acquireOMRObject(flow);
            lSourceSpecifications.add(mdoFlow);
        }
        String strVersion = (version = this.getBusinessRuleVersion()) == null ? "" : version.getVersion().toString();
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_BUSINESSRULE_VERSION, strVersion);
        String debugLoc = this.getDebugCodeLocation();
        this.saveStringOptionToOMR(omr, OPTION_NAME_DEBUG_CODE_LOCATION, debugLoc != null ? debugLoc : "");
        this.saveBooleanOptionToOMR(omr, OPTION_NAME_GENERATE_RULE_FIRED_TABLE, this.isGenerateRuleFiredTable());
        this.saveBooleanOptionToOMR(omr, OPTION_NAME_USE_SOURCE, this.isUseSource());
        this.saveStringOptionToOMR(omr, PROPERTY_BR_FILE_REF, this.getFileRef());
        this.saveStringOptionToOMR(omr, PROPERTY_BR_FILE_LRECL, this.getFileRefLrecl());
        this.saveStringOptionToOMR(omr, PROPERTY_BR_FILE_OPTS, this.getFileRefOptions());
        this.m_businessRuleMappings.saveToOMR(omr, (List)mdoCM.getFeatureMaps());
        this.setChanged(false);
    }

    @Override
    protected void clearListsBeforeLoad() {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ClassifierMap mdoCM;
        super.clearListsBeforeLoad();
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lTransformations = mdoStep.getTransformations();
        if (!lTransformations.isEmpty()) {
            mdoCM = (ClassifierMap)lTransformations.get(0);
            this.setClassifierMapId(mdoCM.getFQID());
        }
        mdoCM = this.getClassifierMapObject(omr);
        AssociationList lSourceSpecs = mdoCM.getSourceSpecifications();
        IBusinessRuleFlow rule = null;
        for (int iSource = 0; iSource < lSourceSpecs.size(); ++iSource) {
            Object mdObject = lSourceSpecs.get(iSource);
            if (!(mdObject instanceof Transformation) || !"BusinessRuleFlow".equals(((Transformation)mdObject).getPublicType())) continue;
            try {
                rule = (IBusinessRuleFlow)omr.acquireObject((Root)mdObject);
                this.setBusinessRule(rule, false);
                continue;
            }
            catch (MdException e) {
                this.setBusinessRule(null, false);
            }
        }
        boolean changed = false;
        String ruleChangeMsg = null;
        String v = this.loadStringOptionFromOMR(omr, PROPERTY_NAME_BUSINESSRULE_VERSION, null);
        IBusinessRuleFlowVersion version = null;
        if (v != null && rule != null) {
            version = rule.findVersion(BaseBusinessRuleFlow.convertToUsageVersion(v));
            try {
                if (version != null) {
                    version.loadFromOMR();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
            if (version != null) {
                this.setBusinessRuleVersion(version, false, this.getSourceTable());
            } else if (this.getBusinessRule() != null) {
                AssociationList cmSrc;
                IPhysicalTable sourceTable = null;
                if (mdoCM != null && (cmSrc = mdoCM.getClassifierSources()) != null && cmSrc.size() > 0) {
                    sourceTable = (IPhysicalTable)omr.acquireObject((Root)cmSrc.get(0));
                }
                try {
                    this.m_br.getDefaultVersion().loadFromOMR();
                }
                catch (ServiceException e) {
                    throw new MdException((Throwable)e);
                }
                this.setBusinessRuleVersion(this.m_br.getDefaultVersion(), false, sourceTable);
                ModelLogger.getDefaultLogger().warn((Object)("Rule version " + v + " was not found. Using default version of rule."));
                changed = true;
                ruleChangeMsg = MessageFormat.format(RB.getStringResource("BusinessRulesTransformModel.ReasonIncomplete.VersionNotFound.fmt"), v);
            }
        } else {
            this.setBusinessRuleVersion(null);
        }
        super.loadFromOMR(omr);
        this.m_businessRuleMappings.loadFromOMR(omr, (List)mdoCM.getFeatureMaps());
        this.setDebugCodeLocation(this.loadStringOptionFromOMR(omr, OPTION_NAME_DEBUG_CODE_LOCATION, null));
        this.setGenerateRuleFiredTable(this.loadBooleanOptionFromOMR(omr, OPTION_NAME_GENERATE_RULE_FIRED_TABLE, true));
        this.setUseSource(this.loadBooleanOptionFromOMR(omr, OPTION_NAME_USE_SOURCE, true));
        this.setFileRef(this.loadStringOptionFromOMR(omr, PROPERTY_BR_FILE_REF, CodeGenerationEnvironment.createWorkTableName8Char(2)));
        this.setFileRefLrecl(this.loadStringOptionFromOMR(omr, PROPERTY_BR_FILE_LRECL, DEFAULT_LRECL));
        this.setFileRefOptions(this.loadStringOptionFromOMR(omr, PROPERTY_BR_FILE_OPTS, null));
        this.setChanged(changed);
        this.setRuleChanged(ruleChangeMsg);
    }

    public String isNewerVersionAvailable() {
        DISUsageVersion thisVer = this.getBusinessRuleVersion().getVersion();
        for (IBusinessRuleFlowVersion ver : this.getBusinessRule().getVersions()) {
            int isNewerVersionAvailable = thisVer.compareTo(ver.getVersion());
            if (isNewerVersionAvailable >= 0) continue;
            return RB.getStringResource("BusinessRulesTransformModel.Warning.NewerVersionAvailable.txt");
        }
        return null;
    }

    @Override
    public void setChanged(boolean changed) {
        super.setChanged(changed);
        this.setRuleChanged(null);
    }

    private void setRuleChanged(String msg) {
        this._ruleChangedMessage = msg;
    }

    @Override
    protected void loadMappingsFromOMR(OMRAdapter omr, ClassifierMap mdoCM) throws MdException, RemoteException {
        AssociationList lFMs = mdoCM.getFeatureMaps();
        for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
            FeatureMap mdoFM = (FeatureMap)lFMs.get(iFM);
            if ("BusinessRule".equals(mdoFM.getTransformRole())) continue;
            IMapping mapping = this.createMapping(omr, mdoFM);
            if (mapping.isDead()) {
                this.addToDeletedObjects(mapping);
                continue;
            }
            this.addMapping(mapping);
        }
    }

    @Override
    public ICodeSegment getAdditionalTransformationComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        IBusinessRuleFlowVersion version;
        IBusinessRuleFlow flow = this.getBusinessRule();
        codeSegment.genCommentLine("", "", "");
        codeSegment.addSourceCode(codeSegment.getCommentLine(RB.getStringResource("BusinessRulesTransformModel.BusinessFlowComment.label.txt"), "", ""));
        String flowValue = RB.getStringResource("BusinessRulesTransformModel.BusinessFlowCommentValue.None.txt");
        if (flow != null) {
            flowValue = flow.getName();
        }
        codeSegment.addSourceCode(codeSegment.getCommentLine("   ", flowValue, flow != null ? flow.getID() : ""));
        if (flow != null) {
            codeSegment.addSourceCode(codeSegment.getCommentLine("      " + flow.getFolder().getURLtoFolder(), "", ""));
        }
        String versionName = (version = this.getBusinessRuleVersion()) != null ? version.getVersion().toString() : RB.getStringResource("BusinessRulesTransformModel.BusinessFlowCommentValue.None.txt");
        codeSegment.addSourceCode(codeSegment.getCommentLine("   " + RB.getStringResource("BusinessRulesTransformModel.BusinessFlowVersionComment.label.txt"), "   " + versionName, ""));
        if (flow != null) {
            codeSegment.addSourceCode(codeSegment.getCommentLine("   " + RB.getStringResource("BusinessRulesTransformModel.BusinessFlowCommentProperties.label.txt"), "", ""));
            for (Map.Entry<String, String> prop : flow.getProperties().entrySet()) {
                codeSegment.addSourceCode(codeSegment.getCommentLine("      " + prop.getKey(), "   " + prop.getValue(), ""));
            }
        }
        return codeSegment;
    }

    @Override
    protected ICodeSegment getCodeForTransform(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.genTableDelete(codeSegment, Arrays.asList(this.getTargetTables()));
        IBusinessRuleFlowVersion flowVersion = this.getBusinessRuleVersion();
        StringBuffer fileOpts = new StringBuffer(this.getFileRefOptions() != null ? this.getFileRefOptions() : "");
        String lrecl = this.getFileRefLrecl();
        if (lrecl != null && lrecl.length() > 0) {
            fileOpts.append(" LRECL = ").append(lrecl);
        }
        if (!this.isUseSource()) {
            codeSegment.addSourceCode("%let etls_sourcevalue = %sysfunc(getoption(source));\n");
            codeSegment.addSourceCode("options NOSOURCE;\n\n");
        }
        codeSegment.addSourceCode(CodeSegment.getTempFilenameAndDSCodeForBRM(this, this.getFileRef(), flowVersion.getBRCode(), fileOpts.toString(), false));
        if (!this.isUseSource()) {
            codeSegment.addSourceCode("options &etls_sourcevalue;\n\n");
        }
        codeSegment.addSourceCode("%macro etls_businessRuleFlow;\n").indent();
        ITransformPort<? extends IDataObject> sourcePort = this.getSourcePorts().get(0);
        IPhysicalTable source = (IPhysicalTable)sourcePort.getObject();
        ITransformTableOptions sourceOpts = this.getTableOptionObject(source, true);
        String tableOptions = "";
        if (sourceOpts != null) {
            tableOptions = sourceOpts.getTableOptions(false, null);
        }
        codeSegment.addSourceCode("%let ").addSourceCode(INPUTTABLEOPTIONS).addSourceCode(" = %nrquote(").addSourceCode(codeSegment.getEscapedMacroValue(tableOptions)).addSourceCode(");\n");
        for (ITransformPort<? extends IDataObject> port : this.getTargetPorts()) {
            ITransformTableOptions iTransformTableOptions;
            codeSegment.addCommentLine("Output for " + port.getName());
            IPhysicalTable table = (IPhysicalTable)port.getObject();
            codeSegment.addSourceCode("%let ").addSourceCode(OUTPUT_PREFIX).addSourceCode(port.getPartnerName()).addSourceCode(" = ");
            if (table != null) {
                codeSegment.addSourceCode(table.getFullNameQuotedAsNeeded(codeSegment));
            }
            codeSegment.addSourceCode(";\n");
            codeSegment.addSourceCode("%let ").addSourceCode(OUTPUT_TABLE_OPTIONS_PREFIX).addSourceCode(port.getPartnerName()).addSourceCode(" = ");
            String outputTableOptions = "";
            if (table != null && (iTransformTableOptions = this.getTableOptionObject(table, false)) != null) {
                outputTableOptions = iTransformTableOptions.getTableOptions(false, null);
            }
            codeSegment.addSourceCode(outputTableOptions).addSourceCode(";\n");
        }
        codeSegment.addSourceCode("\n");
        ITransformPort<? extends IDataObject> mappingPort = this.findPortByPartnerName(PORT_NAME_MAPPING_TABLE, this.getTargetPorts());
        IPhysicalTable mappingTable = (IPhysicalTable)mappingPort.getObject();
        mappingTable.getDBMSType().create(codeSegment, mappingTable, false, true, true, false, "", this);
        codeSegment.addSourceCode("proc sql;\n").indent().addSourceCode("insert into ").addSourceCode(mappingTable.getFullNameQuotedAsNeeded(codeSegment, false)).indent();
        String inputTableName = source.getFullNameQuotedAsNeeded(codeSegment, false);
        codeSegment.addSourceCode("\n");
        for (IBusinessRuleMapping mapping : this.getBusinessRuleMappings()) {
            String informat;
            codeSegment.addSourceCode("values \n(");
            codeSegment.addSourceCode("'").addSourceCode(inputTableName).addSourceCode("',");
            IColumn sourceColumn = mapping.getSource();
            codeSegment.addSourceCode("'").addSourceCode(sourceColumn != null ? sourceColumn.getColumnName(codeSegment.isQuoting(), false) : "").addSourceCode("',").addSourceCode("'").addSourceCode(mapping.getTargetOfBusinessRuleColumn().getName()).addSourceCode("',").addSourceCode("'input',").addSourceCode("'").addSourceCode(sourcePort.getPartnerName()).addSourceCode("',\n");
            if (sourceColumn.getType() == 1) {
                codeSegment.addSourceCode("'N',");
            } else {
                codeSegment.addSourceCode("'C',");
            }
            StringBuffer lenStatement = new StringBuffer();
            lenStatement.append(sourceColumn.getLength());
            codeSegment.addSourceCode("'").addSourceCode(lenStatement.toString()).addSourceCode("', ");
            String format = sourceColumn.getValidFormat();
            if (format != null) {
                codeSegment.addSourceCode("'").addSourceCode(format).addSourceCode("', ");
            }
            if ((informat = sourceColumn.getValidInformat()) == null) continue;
            codeSegment.addSourceCode("'").addSourceCode(informat).addSourceCode("')\n");
        }
        for (ITransformPort iTransformPort : this.getTargetPorts()) {
            if (iTransformPort.getObject() == null || PORT_NAME_MAPPING_TABLE.equals(iTransformPort.getPartnerName())) continue;
            IPhysicalTable target = (IPhysicalTable)iTransformPort.getObject();
            String targetName = target.getFullNameQuotedAsNeeded(codeSegment, false);
            for (IColumn c : target.getColumns()) {
                String informat;
                codeSegment.addSourceCode("values \n(");
                if (codeSegment.isQuoting()) {
                    codeSegment.addSourceCode("'").addSourceCode(targetName).addSourceCode("',");
                } else {
                    codeSegment.addSourceCode("\"").addSourceCode(targetName).addSourceCode("\",");
                }
                String columnName = c.getColumnName(codeSegment.isQuoting(), false);
                codeSegment.addSourceCode("'").addSourceCode(columnName).addSourceCode("',").addSourceCode("'").addSourceCode(columnName).addSourceCode("',").addSourceCode("'output',").addSourceCode("'").addSourceCode(iTransformPort.getPartnerName()).addSourceCode("',\n");
                if (c.getType() == 1) {
                    codeSegment.addSourceCode("'N',");
                } else {
                    codeSegment.addSourceCode("'C',");
                }
                StringBuffer lenStatement = new StringBuffer();
                lenStatement.append(c.getLength());
                codeSegment.addSourceCode("'").addSourceCode(lenStatement.toString()).addSourceCode("', ");
                String format = c.getValidFormat();
                if (format != null) {
                    codeSegment.addSourceCode("'").addSourceCode(format).addSourceCode("', ");
                }
                if ((informat = c.getValidInformat()) == null) continue;
                codeSegment.addSourceCode("'").addSourceCode(informat).addSourceCode("')\n");
            }
        }
        codeSegment.unIndent().addSourceCode(";\n");
        codeSegment.unIndent().addSourceCode("quit;\n\n");
        codeSegment.addSourceCode("%brm_rule_flow(\n").indent().addSourceCode("inputtable=").addSourceCode(source.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(",\n").addSourceCode("mapping=").addSourceCode(mappingTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(",\n").addSourceCode("filelocation=").addSourceCode(this.getFileRef()).addSourceCode(",\n").addSourceCode("debugcodelocation=").addSourceCode(this.getDebugCodeLocation()).addSourceCode(",\n").addSourceCode("RuleFire=").addSourceCode(this.m_bIsGenerateRuleFiredTable ? "Y" : "N");
        codeSegment.addSourceCode("\n");
        codeSegment.unIndent().addSourceCode(");\n\n");
        codeSegment.unIndent().addSourceCode("%mend etls_businessRuleFlow;\n\n").addSourceCode("%etls_businessRuleFlow;\n\n");
        return codeSegment;
    }

    @Override
    public IBusinessRuleMapping getOrdinaryMappingsForTargetColumn(IBusinessRuleFlowColumn target) {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IBusinessRuleMapping mapping = (IBusinessRuleMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary() || !mapping.containsInTargets(target)) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public boolean isBusinessRuleMappingAllowed(IColumn[] aSources, IBusinessRuleFlowColumn[] aTargets) {
        if (aTargets.length == 0) {
            return false;
        }
        return !this.isTargetColumnMapped(aTargets[0]);
    }

    @Override
    public String getReasonMappingIsNotAllowed(IColumn[] aSources, IBusinessRuleFlowColumn[] aTargets) {
        if (this.isTargetColumnMapped(aTargets[0])) {
            return RB.getStringResource("BusinessRuleTransformModel.TargetAlreadyMapped.txt");
        }
        return null;
    }

    private boolean isTargetColumnMapped(IBusinessRuleFlowColumn target) {
        for (IBusinessRuleMapping mapping : this.m_businessRuleMappings.getMappings()) {
            if (!target.equals(mapping.getTargetOfBusinessRuleColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IBusinessRuleMapping addMapping(IColumn[] aSourceColumns, IBusinessRuleFlowColumn[] aTargetColumns) {
        String sType = "ONETOONE";
        return this.addMapping(aSourceColumns, aTargetColumns, sType, null);
    }

    @Override
    public IBusinessRuleMapping[] getBusinessRuleMappings() {
        List<IBusinessRuleMapping> lMappings = this.getBusinessRuleMappingList();
        return lMappings.toArray(new IBusinessRuleMapping[lMappings.size()]);
    }

    public List<IBusinessRuleMapping> getBusinessRuleMappingList() {
        return Arrays.asList(this.m_businessRuleMappings.getMappings());
    }

    @Override
    public int getSourceBusinessRuleTableCount() {
        return this.getSourceBusinessRuleTables().length;
    }

    @Override
    public IBusinessRuleFlowTable[] getSourceBusinessRuleTables() {
        List<Object> lst = new ArrayList();
        IBusinessRuleFlowVersion version = this.getBusinessRuleVersion();
        if (version != null) {
            lst = Arrays.asList(version.getInputs());
        }
        return lst.toArray(new IBusinessRuleFlowTable[lst.size()]);
    }

    public IBusinessRuleFlowTable getSourceBusinessRuleTable() {
        return this.getSourceBusinessRuleTableCount() > 0 ? this.getSourceBusinessRuleTables()[0] : null;
    }

    protected IBusinessRuleMapping createNewBusinessRuleMapping() {
        return new BusinessRuleMapping(this.createIDForNewObject(), this.getModel());
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        if (!this.getModel().isUndoing()) {
            if (!this.m_businessRuleMappings.contains(mapping) && mapping instanceof IBusinessRuleMapping) {
                this.m_businessRuleMappings.add(mapping);
                mapping.addNotifyListener(this);
            } else {
                super.addMapping(iMapping, mapping);
            }
        }
    }

    @Override
    protected boolean areExpressionsAllowed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessRuleMapping addMapping(IColumn[] aSourceColumns, IBusinessRuleFlowColumn[] aTargetColumns, String sType, IExpression oExpression) {
        this.startCompoundUndoable();
        try {
            IBusinessRuleMapping mapping = this.createNewBusinessRuleMapping();
            mapping.setName(aTargetColumns.length == 1 ? aTargetColumns[0].getName() : "BusinessRuleMapping");
            mapping.setType(sType);
            mapping.setExpression(oExpression);
            for (int iSourceColumn = 0; iSourceColumn < aSourceColumns.length; ++iSourceColumn) {
                mapping.addSource(aSourceColumns[iSourceColumn]);
            }
            for (int iTargetColumn = 0; iTargetColumn < aTargetColumns.length; ++iTargetColumn) {
                mapping.addTargetBusinessRuleColumn(aTargetColumns[iTargetColumn]);
            }
            if (mapping.isOrdinary() && mapping instanceof BaseMapping) {
                BaseMapping ordinary = (BaseMapping)((Object)mapping);
                ordinary.setAutoType(true);
                ordinary.setExpressionAllowed(this.areExpressionsAllowed());
            }
            this.addMapping(mapping);
            IBusinessRuleMapping iBusinessRuleMapping = mapping;
            return iBusinessRuleMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeMapping(IMapping mapping) {
        if (mapping instanceof BusinessRuleMapping && ((BusinessRuleMapping)mapping).getIsReplacingColumn()) {
            return;
        }
        if (!this.getModel().isUndoing()) {
            if (this.m_businessRuleMappings.contains(mapping) && mapping instanceof IBusinessRuleMapping) {
                this.m_businessRuleMappings.remove(mapping);
                mapping.removeNotifyListener(this);
            } else {
                super.removeMapping(mapping);
            }
        }
    }

    @Override
    public void mapAllBusinessRuleColumnsByName(ITable sourceTable, IBusinessRuleFlowTable inputTable) {
        boolean caseSensitive = sourceTable.isCaseSensitive();
        for (IColumn column : sourceTable.getColumns()) {
            for (IBusinessRuleFlowColumn brfColumn : inputTable.getColumns()) {
                boolean toMap = false;
                toMap = caseSensitive ? column.getName().equals(brfColumn.getName()) : column.getName().equalsIgnoreCase(brfColumn.getName());
                if (!toMap) continue;
                this.mapColumns(new IColumn[]{column}, new IBusinessRuleFlowColumn[]{brfColumn});
            }
        }
    }

    public void mapColumns(IColumn[] aSources, IBusinessRuleFlowColumn[] aTargets) {
        this.mapColumns(aSources, aTargets, DefaultMappingRules.getRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapColumns(IColumn[] aSources, IBusinessRuleFlowColumn[] aTargets, IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            IColumn[] aOneSource = new IColumn[1];
            IBusinessRuleFlowColumn[] aOneTarget = new IBusinessRuleFlowColumn[1];
            List lExcludedTargetColumns = this.getListOfColumnsExcludedFromMapping();
            ArrayList<IColumn> lSources = new ArrayList<IColumn>(Arrays.asList(aSources));
            lSources.removeAll(this.getSourceColumnsExcludedFromMapping());
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                IBusinessRuleFlowColumn tgt = aTargets[iTarget];
                if (lExcludedTargetColumns.contains(tgt)) continue;
                IBusinessRuleMapping mapping = this.findTargetMapping(tgt);
                aOneTarget[0] = tgt;
                boolean bUnmapped = mapping == null;
                for (int iSource = 0; iSource < lSources.size() && bUnmapped; ++iSource) {
                    IColumn src;
                    aOneSource[0] = src = (IColumn)lSources.get(iSource);
                    if (!this.isBusinessRuleMappingAllowed(aOneSource, aOneTarget)) continue;
                    this.addMapping(aOneSource, aOneTarget, "BusinessRule", null);
                    bUnmapped = false;
                    lSources.remove(src);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected void addSourceTable(int portIndex, IDataObject table) {
        super.addSourceTable(portIndex, table);
        IBusinessRuleFlowTable brTable = this.getSourceBusinessRuleTable();
        if (brTable != null) {
            this.mapAllBusinessRuleColumnsByName((ITable)table, brTable);
        }
    }

    private IBusinessRuleMapping findTargetMapping(IBusinessRuleFlowColumn colTarget) {
        for (IBusinessRuleMapping brMapping : this.getBusinessRuleMappingList()) {
            IBusinessRuleFlowColumn[] aTargets = brMapping.getTargetsOfBusinessRuleColumn();
            if (aTargets.length != 1 || aTargets[0] != colTarget) continue;
            return brMapping;
        }
        return null;
    }

    protected boolean validateBusinessRuleMapping() {
        return false;
    }

    @Override
    protected boolean doesMappingExistOnAllTargetTables() {
        return true;
    }

    void parentAddMapping(int iMapping, IMapping mapping) {
        super.addMapping(iMapping, mapping);
    }

    void parentRemoveMapping(IMapping mapping) {
        super.removeMapping(mapping);
    }

    private class RuleMappingList
    extends ModelList {
        private IFilter m_addFilter;

        public RuleMappingList(AbstractPersistableObject owner) {
            super(owner, new String[]{"MappingsContainer:BusinessRuleMappingAdded", "MappingsContainer:BusinessRuleMappingRemoved", "MappingsContainer:BusinessRuleMappingChanged"}, 2);
            this.m_addFilter = new ListFilter();
            this.setAssociationItemFilter(new LoadFilter());
        }

        private IDataTransform getTransform() {
            return (IDataTransform)((Object)this.getOwner());
        }

        @Override
        protected IPersistableObject createObjectFromOMRObject(OMRAdapter omr, Root mdoObject) throws MdException, RemoteException {
            return new BusinessRuleMapping(mdoObject.getFQID(), BusinessRuleTransformModel.this.getModel());
        }

        public IBusinessRuleMapping[] getMappings() {
            ArrayList<IBusinessRuleMapping> lst = new ArrayList<IBusinessRuleMapping>();
            for (Object obj : this.toArray(new IBusinessRuleMapping[this.size()])) {
                if (!(obj instanceof IBusinessRuleMapping)) continue;
                lst.add((IBusinessRuleMapping)obj);
            }
            return lst.toArray(new IBusinessRuleMapping[lst.size()]);
        }

        @Override
        protected void preLoad(Object obj) {
            ((IBusinessRuleMapping)obj).setBusinessRuleFlowTable(BusinessRuleTransformModel.this.getSourceBusinessRuleTable());
        }

        @Override
        protected void postAdd(int i, Object obj) {
            BusinessRuleTransformModel.this.parentAddMapping(i, (IBusinessRuleMapping)obj);
        }

        @Override
        protected void postRemove(Object obj) {
            BusinessRuleTransformModel.this.parentRemoveMapping((IBusinessRuleMapping)obj);
        }

        public void setSourceBusinessRuleTable(IBusinessRuleFlowTable table) {
            for (IBusinessRuleMapping mapping : this.getMappings()) {
                mapping.setBusinessRuleFlowTable(table);
            }
        }

        @Override
        public void add(int iObj, Object obj) {
            if (!this.m_addFilter.pass(obj)) {
                return;
            }
            super.add(iObj, obj);
        }

        private class LoadFilter
        implements IFilter {
            private LoadFilter() {
            }

            @Override
            public boolean pass(Object obj) {
                if (!(obj instanceof FeatureMap)) {
                    return false;
                }
                FeatureMap mapping = (FeatureMap)obj;
                try {
                    if ("BusinessRule".equals(mapping.getTransformRole())) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().debug((Object)e);
                }
                return false;
            }
        }

        private class ListFilter
        implements IFilter {
            private ListFilter() {
            }

            @Override
            public boolean pass(Object obj) {
                return obj instanceof BusinessRuleMapping;
            }
        }
    }

    private class cBusinessRulesOptionModel
    extends AbstractMultiplePortTransformOptionModel {
        public cBusinessRulesOptionModel(IModel model, BusinessRuleTransformModel owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cBusinessRulesOptionModel.class.getResource("res/Options_BusinessRules_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            BusinessRuleTransformModel tl = (BusinessRuleTransformModel)this.getOwner();
            String v = BusinessRuleTransformModel.this.getDebugCodeLocation();
            this.setOptionValue(BusinessRuleTransformModel.OPTION_NAME_DEBUG_CODE_LOCATION, (Object)(v != null ? new FileLocation(v) : null));
            this.setOptionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_LRECL, (Object)tl.getFileRefLrecl());
            this.setOptionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_REF, (Object)tl.getFileRef());
            this.setOptionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_OPTS, (Object)tl.getFileRefOptions());
            this.setOptionValue(BusinessRuleTransformModel.OPTION_NAME_GENERATE_RULE_FIRED_TABLE, (Object)tl.booleanToYesNo(tl.isGenerateRuleFiredTable()));
            this.setOptionValue(BusinessRuleTransformModel.OPTION_NAME_USE_SOURCE, (Object)tl.booleanToYesNo(tl.isUseSource()));
            IPromptDefinitionValue config = this.getPromptDefinitionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_REF);
            if (config != null && config.getDefaultValue() == null) {
                config.setDefaultValue(CodeGenerationEnvironment.createWorkTableName8Char(0));
            }
        }

        @Override
        protected IModelListener createModelListener() {
            return new cBusinessRulesModelListener((BusinessRuleTransformModel)this.getOwner());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new BusinessRuleTransformValueChangedListener((BusinessRuleTransformModel)this.getOwner(), this);
        }

        private class BusinessRuleTransformValueChangedListener
        extends AbstractMultiplePortTransformOptionValueChangeListener {
            public BusinessRuleTransformValueChangedListener(BusinessRuleTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (BusinessRuleTransformModel.OPTION_NAME_DEBUG_CODE_LOCATION.equals(optionName)) {
                        if (value != "") {
                            FileLocation l = (FileLocation)value;
                            ((BusinessRuleTransformModel)this.getOwner()).setDebugCodeLocation(l != null ? l.getFileLocation() : null);
                        } else {
                            ((BusinessRuleTransformModel)this.getOwner()).setDebugCodeLocation("");
                        }
                    } else if (BusinessRuleTransformModel.PROPERTY_BR_FILE_LRECL.equals(optionName)) {
                        BusinessRuleTransformModel.this.setFileRefLrecl(value.toString());
                    } else if (BusinessRuleTransformModel.PROPERTY_BR_FILE_OPTS.equals(optionName)) {
                        BusinessRuleTransformModel.this.setFileRefOptions(value.toString());
                    } else if (BusinessRuleTransformModel.PROPERTY_BR_FILE_REF.equals(optionName)) {
                        BusinessRuleTransformModel.this.setFileRef(value.toString());
                    } else if (BusinessRuleTransformModel.OPTION_NAME_GENERATE_RULE_FIRED_TABLE.equals(optionName)) {
                        BusinessRuleTransformModel.this.setGenerateRuleFiredTable(BusinessRuleTransformModel.this.yesNoToBoolean(value.toString()));
                    } else if (BusinessRuleTransformModel.OPTION_NAME_USE_SOURCE.equals(optionName)) {
                        BusinessRuleTransformModel.this.setUseSource(BusinessRuleTransformModel.this.yesNoToBoolean(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class cBusinessRulesModelListener
        extends AbstractMultiplePortTransformOptionModelListener {
            public cBusinessRulesModelListener(BusinessRuleTransformModel transform) {
                super(transform, (IPromptModel)cBusinessRulesOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(BusinessRuleTransformModel.DEBUG_CODE_LOCATION_CHANGED)) {
                        String v = BusinessRuleTransformModel.this.getDebugCodeLocation();
                        cBusinessRulesOptionModel.this.setOptionValue(BusinessRuleTransformModel.OPTION_NAME_DEBUG_CODE_LOCATION, (Object)(v != null ? new FileLocation(v) : null));
                    } else if (BusinessRuleTransformModel.BR_FILE_REF_CHANGED.equals(type)) {
                        cBusinessRulesOptionModel.this.setOptionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_REF, (Object)BusinessRuleTransformModel.this.getFileRef());
                    } else if (BusinessRuleTransformModel.BR_FILE_REF_LRECL_CHANGED.equals(type)) {
                        cBusinessRulesOptionModel.this.setOptionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_LRECL, (Object)BusinessRuleTransformModel.this.getFileRefLrecl());
                    } else if (BusinessRuleTransformModel.BR_FILE_REF_OPTS_CHANGED.equals(type)) {
                        cBusinessRulesOptionModel.this.setOptionValue(BusinessRuleTransformModel.PROPERTY_BR_FILE_OPTS, (Object)BusinessRuleTransformModel.this.getFileRefOptions());
                    } else if (type.equals(BusinessRuleTransformModel.GENERATE_RULE_FIRED_TABLE_CHANGED)) {
                        cBusinessRulesOptionModel.this.setOptionValue(BusinessRuleTransformModel.OPTION_NAME_GENERATE_RULE_FIRED_TABLE, (Object)BusinessRuleTransformModel.this.booleanToYesNo(BusinessRuleTransformModel.this.isGenerateRuleFiredTable()));
                    } else if (type.equals(BusinessRuleTransformModel.USE_SOURCE_CHANGED)) {
                        cBusinessRulesOptionModel.this.setOptionValue(BusinessRuleTransformModel.OPTION_NAME_USE_SOURCE, (Object)BusinessRuleTransformModel.this.booleanToYesNo(BusinessRuleTransformModel.this.isUseSource()));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }

    private class SetIsGenerateRuleFiredTableUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetIsGenerateRuleFiredTableUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setGenerateRuleFiredTable(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setGenerateRuleFiredTable(this.m_newValue);
        }
    }

    private class SetBusinessRuleFileRefLreclUndoable
    extends AbstractUndoableEdit {
        private String m_brOld;
        private String m_brNew;

        public SetBusinessRuleFileRefLreclUndoable(String brNew, String brOld) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setFileRefLrecl(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setFileRefLrecl(this.m_brNew);
        }
    }

    private class SetBusinessRuleFileRefOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_brOld;
        private String m_brNew;

        public SetBusinessRuleFileRefOptionsUndoable(String brNew, String brOld) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setFileRefOptions(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setFileRefOptions(this.m_brNew);
        }
    }

    private class SetBusinessRuleFileRefUndoable
    extends AbstractUndoableEdit {
        private String m_brOld;
        private String m_brNew;

        public SetBusinessRuleFileRefUndoable(String brNew, String brOld) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setFileRef(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setFileRef(this.m_brNew);
        }
    }

    private class SetDebugCodeLocationUndoable
    extends AbstractUndoableEdit {
        private String m_brOld;
        private String m_brNew;

        public SetDebugCodeLocationUndoable(String brOld, String brNew) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setDebugCodeLocation(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setDebugCodeLocation(this.m_brNew);
        }
    }

    private class SetBusinessRuleVersionUndoable
    extends AbstractUndoableEdit {
        private IBusinessRuleFlowVersion m_brOld;
        private IBusinessRuleFlowVersion m_brNew;

        public SetBusinessRuleVersionUndoable(IBusinessRuleFlowVersion brOld, IBusinessRuleFlowVersion brNew) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setBusinessRuleVersion(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setBusinessRuleVersion(this.m_brNew);
        }
    }

    private class SetBusinessRuleUndoable
    extends AbstractUndoableEdit {
        private IBusinessRuleFlow m_brOld;
        private IBusinessRuleFlow m_brNew;

        public SetBusinessRuleUndoable(IBusinessRuleFlow brOld, IBusinessRuleFlow brNew) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            BusinessRuleTransformModel.this.setBusinessRule(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            BusinessRuleTransformModel.this.setBusinessRule(this.m_brNew);
        }
    }
}

