/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.businessrules;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.data.impl.AbstractTable;
import com.sas.etl.models.job.transforms.businessrules.RB;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class BusinessRuleTargetTablePort<IPhysicalTable>
extends BaseTransformPort<IDataObject> {
    private IBusinessRuleFlowTable _brTable;

    public BusinessRuleTargetTablePort(String sID, IModel model) {
        super(sID, model);
        this.setOptional(false);
        this.setCanPropagateColumns(false);
    }

    public void setBusinessRuleTable(IBusinessRuleFlowTable brTable) {
        this._brTable = brTable;
        if (this._brTable != null) {
            this.setCanIncludeSourceColumns("OUTPUT".equals(brTable.getType()));
        }
        this.setGeneratedTable(this._brTable);
    }

    public IBusinessRuleFlowTable getBusinessRuleTable() {
        return this._brTable;
    }

    private IPhysicalTable getTable() {
        return (IPhysicalTable)this.getObject();
    }

    private IColumn[] getOtherColumns(IColumn[] sourceColumns) {
        ArrayList<IColumn> nonMatch = new ArrayList<IColumn>();
        if (this.canIncludeSourceColumns() && this.getTable() != null && sourceColumns != null) {
            for (IColumn column : this.getTable().getColumns()) {
                if (AbstractTable.getColumnWithMatchingName(sourceColumns, column.getColumnName(false), false) != null) continue;
                nonMatch.add(column);
            }
        }
        return nonMatch.toArray(new IColumn[nonMatch.size()]);
    }

    @Override
    public boolean isComplete(IColumn[] columns) {
        return super.isComplete() && this._brTable != null && this._brTable.isComplete(this.getOtherColumns(columns));
    }

    @Override
    public List getReasonsIncomplete(IColumn[] columns) {
        List lst = super.getReasonsIncomplete();
        if (this._brTable == null) {
            lst.add(MessageFormat.format(RB.getStringResource("BusinessRuleTargetTablePort.NoBusinessRuleTable.fmt"), this.getName()));
        }
        if (this._brTable != null) {
            lst.addAll(this._brTable.getReasonsIncomplete(this.getOtherColumns(columns)));
        }
        return lst;
    }
}

