/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class UserWrittenTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASUserExit";
    private static final String TRANSFORMATION_ROLE = "SASUserExit";
    private static final String ARM_DISPLAY_NAME = "UserWritten";

    public UserWrittenTransformModel(String id, IModel model) {
        super(id, model);
        this.setUseUserWrittenCode(true);
        this.setChanged(this.isNew());
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected int getMaximumDataTargetCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumDataSourceCount() {
        return Integer.MAX_VALUE;
    }

    protected int getMinimumDataSourceCount() {
        return 0;
    }

    protected int getMinimumDataTargetCount() {
        return 0;
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete();
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("UserWrittenTransformModel.Name.txt");
    }

    @Override
    public boolean isUsingUserWrittenCode() {
        return true;
    }

    @Override
    public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
        if (!bUseUserWrittenCode) {
            throw new IllegalArgumentException("cannot turn off user written code for the user written transform");
        }
        super.setUseUserWrittenCode(bUseUserWrittenCode);
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("UserWrittenTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return true;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptDefinitionValue pdv2;
        IPromptModel model = super.createOptionModel();
        IPromptDefinitionValue pdv = model.getPromptDefinitionValue("COLMACROVARS");
        if (pdv != null) {
            pdv.setHidden(false);
        }
        if ((pdv2 = model.getPromptDefinitionValue("FILEMACROVARS")) != null) {
            pdv2.setHidden(false);
        }
        return model;
    }
}

