/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.TERADATAType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.BaseLoaderModelListener;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.BaseLoaderTransformValueChangedListener;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TeradataTableLoaderTransformModel
extends TableLoaderTransformModel {
    public static final String USE_TPT_UTILITIES_CHANGED = "TeradataTableLoaderModel:TPTUtilitiesChanged";
    public static final String SUPPORT_RESTART_CHANGED = "TeradataTableLoaderModel:SupportRestartChanged";
    public static final String CHECKPOINT_ENABLED_CHANGED = "ITransform:CheckpointEnabledChanged";
    private static final String PROPERTY_NAME_TPT_UTILTIES = "TPTUtilities";
    private static final String ARM_DISPLAY_NAME = "Teradata Loader";
    private static final String TRANSFORMATION_CLASS = "TeradataTableLoader";
    private static final String TRANSFORMATION_ROLE = "TeradataTableLoader";
    private static final String REPLACE_FASTLOAD = "ReplaceFastLoad";
    private static final String REPLACE_MULTILOAD = "ReplaceMultiLoad";
    private static final String APPEND_MULTILOAD = "AppendMultiload";
    private static final String APPEND_TPUMP = "AppendTPump";
    private static final String UPSERT_MULTILOAD = "UpsertMultiload";
    private static final String BEST_RUNTIME_TECHNIQUE = "BestRuntimeTechnique";
    private static final String[] LOAD_TECHNIQUES = new String[]{"ReplaceFastLoad", "ReplaceMultiLoad", "AppendMultiload", "AppendTPump", "UpsertMultiload", "BestRuntimeTechnique"};
    private static final String TD_REPLACE_INSERT = "TDReplaceInsert";
    private static final String TD_APPEND_INSERT = "TDAppendInsert";
    private static final String TD_UPDATE_INSERT = "TDUpdateInsert";
    private static final String[] TD_LOAD_TECHNIQUES = new String[]{"TDReplaceInsert", "TDAppendInsert", "TDUpdateInsert"};
    private static final String FAIL_INFO_TABLE_NAME = "work.etls_failureInfo";
    private static final String KEY_LOAD_TYPE = "LoadType";
    private static final String VALUE_LOAD_TYPE_TPT = "TPT";
    private static final String VALUE_LOAD_TYPE_MULTILOAD = "Multiload";
    private static final String VALUE_LOAD_TYPE_FASTLOAD = "Fastload";
    private static final String OPTION_NAME_TPT = "TPT";
    private static final String OPTION_NAME_FASTLOAD = "FASTLOAD";
    private static final String OPTION_NAME_MULTILOAD = "MULTILOAD";
    private static final String OPTION_NAME_MULTISTMT = "MULTISTMT";
    private static final String OPTION_NAME_LOGINFILE = "SYS_MULTILOAD_LOGIN_FILE";
    private static final String OPTION_NAME_SCRIPTFILE = "ML_SCRIPTFILELOC";
    private static final String OPTION_NAME_CHECKPOINT = "CHECKPOINT";
    private static final String OPTION_NAME_ERRLIMIT = "ERRLIMIT";
    private static final String GLOBAL = "GLOBAL";
    private boolean m_bUseTPTUtilities;
    private boolean m_bDefaultTPTUtilities;
    private boolean m_bDefaultCustomRestartEnabled;
    private IDBMSType m_oPreviousSourceDBMSType;
    private boolean m_bIsPrevSourceAndTargetSameServer;

    public TeradataTableLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setDefaultLoadStyle(BEST_RUNTIME_TECHNIQUE);
        this.setDefaultCustomRestartEnabled(false);
        this.setDefaultTPTUtilities(true);
        this.setUseTPTUtilities(this.isDefaultTPTUtilities());
    }

    @Override
    protected String getDefaultDBIDirectExecValue() {
        return "DBIDIRECTEXEC";
    }

    @Override
    protected void postAddDataSource(IDataObject source) {
        super.postAddDataSource(source);
        IDBMSType newDBMSType = ((IPhysicalTable)source).getDBMSType();
        if (this.resetModelDueToSourceChange(newDBMSType)) {
            this.resetModelDefaults();
        }
        this.m_oPreviousSourceDBMSType = newDBMSType;
        this.m_bIsPrevSourceAndTargetSameServer = this.isSourceAndTargetSameDatabaseServer();
    }

    @Override
    protected void preRemoveDataSource(IDataObject source) {
        super.preRemoveDataSource(source);
        IPhysicalTable oOldSource = this.getSourceTable();
        this.m_oPreviousSourceDBMSType = oOldSource != null ? oOldSource.getDBMSType() : null;
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        this.m_bIsPrevSourceAndTargetSameServer = this.isSourceAndTargetSameDatabaseServer();
    }

    private boolean resetModelDueToSourceChange(IDBMSType sourceDBMSType) {
        if (this.m_oPreviousSourceDBMSType != null) {
            if (this.m_oPreviousSourceDBMSType instanceof TERADATAType) {
                if (!(sourceDBMSType instanceof TERADATAType)) {
                    return true;
                }
                if (this.m_bIsPrevSourceAndTargetSameServer != this.isSourceAndTargetSameDatabaseServer()) {
                    return true;
                }
            } else if (sourceDBMSType instanceof TERADATAType) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            boolean bUsingTPTUtilities = this.isUsingTPT();
            boolean bCustomRestartEnabled = this.isCustomRestartEnabled();
            boolean bUsingSameDatabase = this.isSourceAndTargetSameDatabaseServer();
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
            if (this.isSourceAndTargetSameDatabaseServer() != bUsingSameDatabase) {
                this.resetModelDefaults();
            } else {
                this.setUseTPTUtilities(bUsingTPTUtilities);
                this.setCheckpointEnabled(bCustomRestartEnabled);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        String sType;
        ModelEvent mdEv;
        IPhysicalTable source = null;
        IPhysicalTable target = null;
        if (this.getDataSourcesCount() == 1) {
            source = this.getSourceTable();
        }
        if (source != null && ev.getType() == 1 && (mdEv = ev.getModelEvent()) != null && mdEv.getModelObject() == source && ((sType = mdEv.getType()).equalsIgnoreCase("PhysicalTable:LibraryChanged") || sType.equalsIgnoreCase("PhysicalTable:LocationTypeChanged"))) {
            IDBMSType newDBMSType = source.getDBMSType();
            if (this.resetModelDueToSourceChange(newDBMSType)) {
                this.resetModelDefaults();
            }
            this.m_oPreviousSourceDBMSType = newDBMSType;
            this.m_bIsPrevSourceAndTargetSameServer = this.isSourceAndTargetSameDatabaseServer();
        }
        super.notify(ev);
        if (this.getDataTargetsCount() == 1) {
            target = (IPhysicalTable)this.getDataTargets()[0];
        }
        if (target != null && ev.getType() == 1 && (mdEv = ev.getModelEvent()) != null && mdEv.getModelObject() == target && (sType = mdEv.getType()).equalsIgnoreCase("PhysicalTable:LibraryChanged")) {
            this.m_bIsPrevSourceAndTargetSameServer = this.isSourceAndTargetSameDatabaseServer();
        }
    }

    @Override
    protected boolean isDBMSTypeChanged() {
        IPhysicalTable target;
        String sDBMSType = "";
        if (this.getDataTargetsCount() > 0 && (target = (IPhysicalTable)this.getDataTargets()[0]) != null) {
            sDBMSType = target.getDBMSType().getClass().getName();
        }
        return !sDBMSType.equals(this.m_sSaveDBMSType) || this.m_bIsPrevSourceAndTargetSameServer != this.isSourceAndTargetSameDatabaseServer();
    }

    @Override
    public void resetModelDefaults() {
        super.resetModelDefaults();
        this.setDefaultCustomRestartEnabled(this.isCustomRestartSupported());
        this.setDefaultTPTUtilities(this.isUsingTPTUtilitiesSupported(this.getLoadStyle()));
        this.updateLoadUtilities();
    }

    @Override
    public List getValidValuesIndexBefore() {
        List lValues = super.getValidValuesIndexBefore();
        boolean bCanRefresh = false;
        boolean bReplacingTable = false;
        IPhysicalTable target = this.getTargetTable();
        if (target != null) {
            bReplacingTable = this.isReplacingEntireTable();
            bCanRefresh = this.isIndexEnabled(this.getTargetTable());
        }
        if (bCanRefresh) {
            if (!bReplacingTable && this.getLoadStyle().equalsIgnoreCase(UPSERT_MULTILOAD)) {
                this.m_sDefaultIndexBefore = "OFF";
            } else if (this.getLoadStyle().equalsIgnoreCase(REPLACE_FASTLOAD)) {
                this.m_sDefaultIndexBefore = bReplacingTable ? "ASIS" : "OFF";
            }
        }
        return lValues;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cTeradataLoaderOptionModel(this.getModel(), this);
    }

    protected void setDefaultTPTUtilities(boolean value) {
        this.m_bDefaultTPTUtilities = value;
    }

    protected boolean isDefaultTPTUtilities() {
        return this.m_bDefaultTPTUtilities;
    }

    protected void setDefaultCustomRestartEnabled(boolean value) {
        this.m_bDefaultCustomRestartEnabled = value;
    }

    protected boolean isDefaultCustomRestartEnabled() {
        return this.m_bDefaultCustomRestartEnabled;
    }

    @Override
    public void addTransformTableOption(ITransformTableOptions optionSet) {
        if (this.isValidAsTargetTable(optionSet.getOptionTable()) && !optionSet.isAccessTypeInput()) {
            optionSet.setShowTransformSpecificOptions();
            optionSet.setGenerateTransformSpecificOptions(false);
        }
        super.addTransformTableOption(optionSet);
        this.updateLoadUtilities();
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ITransformTableOptions[] opts = super.getTableOptionObjects();
        for (int i = 0; i < opts.length; ++i) {
            if (!this.isValidAsTargetTable(opts[i].getOptionTable()) || opts[i].isAccessTypeInput()) continue;
            opts[i].setShowTransformSpecificOptions();
            opts[i].setGenerateTransformSpecificOptions(false);
        }
        return opts;
    }

    protected String getOptionValues(IPromptDefinitionValue[] definitions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer tpt = new StringBuffer();
        if (definitions != null && definitions.length > 0) {
            try {
                tpt.append(definitions[0].getModel().getOptionsString(null, null, false, false, false, false, definitions));
            }
            catch (ServerConnectionException e) {
                throw new ServerException(e);
            }
            catch (ServiceException e) {
                throw new ServerException(e);
            }
        }
        return tpt.toString();
    }

    protected ITransformTableOptions getTargetOptions() {
        return this.getTargetTable() != null ? this.getTableOptionObject(this.getTargetTable(), false) : null;
    }

    protected IPromptDefinitionValue[] getTPTOptions() {
        return this.getLoadTypeOptions("TPT");
    }

    protected IPromptDefinitionValue[] getTPumpOptions() {
        ITransformTableOptions targetOptions = this.getTargetOptions();
        IPromptDefinitionValue multStmtOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_MULTISTMT);
        return new IPromptDefinitionValue[]{multStmtOption};
    }

    protected IPromptDefinitionValue[] getFastloadOptions() {
        return this.getLoadTypeOptions(VALUE_LOAD_TYPE_FASTLOAD);
    }

    protected IPromptDefinitionValue[] getMultiloadOptions() {
        IPromptDefinitionValue[] mlOpts = this.getLoadTypeOptions(VALUE_LOAD_TYPE_MULTILOAD);
        ArrayList<IPromptDefinitionValue> mlList = new ArrayList<IPromptDefinitionValue>();
        if (mlOpts != null) {
            for (int i = 0; i < mlOpts.length; ++i) {
                if (mlOpts[i].getName().equals(OPTION_NAME_SCRIPTFILE) || mlOpts[i].getName().equals(OPTION_NAME_LOGINFILE) || mlOpts[i].getName().equals(OPTION_NAME_CHECKPOINT)) continue;
                mlList.add(mlOpts[i]);
            }
        }
        return mlList.toArray(new IPromptDefinitionValue[mlList.size()]);
    }

    protected StringBuffer genMultiloadFileOptions() {
        StringBuffer sFileOptions = new StringBuffer();
        IPromptDefinitionValue[] mlOpts = this.getLoadTypeOptions(VALUE_LOAD_TYPE_MULTILOAD);
        ArrayList<IPromptDefinitionValue> fileOpts = new ArrayList<IPromptDefinitionValue>();
        if (mlOpts != null) {
            for (int i = 0; i < mlOpts.length; ++i) {
                if (!mlOpts[i].getName().equals(OPTION_NAME_SCRIPTFILE) && !mlOpts[i].getName().equals(OPTION_NAME_LOGINFILE)) continue;
                fileOpts.add(mlOpts[i]);
            }
        }
        try {
            if (fileOpts != null && fileOpts.size() > 0) {
                IPromptDefinitionValue[] fOpts = fileOpts.toArray(new IPromptDefinitionValue[fileOpts.size()]);
                sFileOptions = fOpts[0].getModel().getOptionsString(null, null, true, true, false, false, fOpts);
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"CodegenException", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerException", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"BadServerDefinitionException", (Throwable)e);
        }
        return sFileOptions;
    }

    protected String genCheckpointOption(boolean bFastload) {
        PhysicalTablePromptModelCollection model;
        IPromptDefinitionValue[] options = null;
        StringBuffer sCheckpoint = new StringBuffer();
        ITransformTableOptions targetOpts = this.getTargetOptions();
        if (targetOpts != null && (model = targetOpts.getOptionModel()) != null) {
            options = model.getDefinitions();
            for (int i = 0; i < options.length; ++i) {
                Object val;
                String optName = options[i].getName();
                if (!optName.equals(OPTION_NAME_CHECKPOINT)) continue;
                if (!options[i].isValueSet() || (val = options[i].getValue()) == null) break;
                if (!this.isUsingTPT() && !bFastload) {
                    sCheckpoint.append(" ML_");
                    sCheckpoint.append(options[i].getName());
                } else {
                    sCheckpoint.append(" ");
                    sCheckpoint.append(options[i].getName());
                }
                sCheckpoint.append(" = ");
                sCheckpoint.append(options[i].getValue());
                sCheckpoint.append(" ");
                break;
            }
        }
        return sCheckpoint.toString();
    }

    protected IPromptDefinitionValue[] getLoadTypeOptions(String type) {
        PhysicalTablePromptModelCollection model;
        IPromptDefinitionValue[] options = null;
        ITransformTableOptions targetOpts = this.getTargetOptions();
        if (targetOpts != null && (model = targetOpts.getOptionModel()) != null) {
            options = model.getPromptDefinitionsWithUserInfo(KEY_LOAD_TYPE, type);
        }
        return options;
    }

    @Override
    public String getDefaultLoadStyle() {
        return this.isSourceAndTargetSameDatabaseServer() ? TD_APPEND_INSERT : BEST_RUNTIME_TECHNIQUE;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("TeradataTableLoaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("TeradataTableLoaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public static String getTransformTypeID() {
        return "TeradataTableLoader";
    }

    @Override
    protected String getTransformClass() {
        return "TeradataTableLoader";
    }

    @Override
    protected String getTransformRole() {
        return "TeradataTableLoader";
    }

    @Override
    public boolean isValidateAvailable() {
        return this.isSourceAndTargetSameDatabaseServer();
    }

    public boolean isValidAsTargetTable(IDataObject target) {
        if (target == null) {
            return false;
        }
        String type = ((IPhysicalTable)target).getDBMSType().getConnectionType();
        boolean notOtherTeradata = type != "ODBC" && type != "OLEDB";
        return target instanceof IPhysicalTable && ((IPhysicalTable)target).getDBMSType() instanceof TERADATAType && notOtherTeradata;
    }

    private List getTeradataLoadTechniques() {
        return Arrays.asList(TD_LOAD_TECHNIQUES);
    }

    private List getRegularLoadTechniques() {
        return Arrays.asList(LOAD_TECHNIQUES);
    }

    @Override
    public List getLoadTechniques() {
        return this.isSourceAndTargetSameDatabaseServer() ? this.getTeradataLoadTechniques() : this.getRegularLoadTechniques();
    }

    @Override
    public String getModifyType() {
        String sLoadStyle = this.getLoadStyle();
        if (UPSERT_MULTILOAD.equals(sLoadStyle) || TD_UPDATE_INSERT.equals(sLoadStyle)) {
            return "ModifyByColumn";
        }
        return "";
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        IPhysicalTable target = this.getTargetTable();
        return target != null && target.getDBMSType() instanceof TERADATAType && ((TERADATAType)target.getDBMSType()).getKeyMatchingPrimaryIndex(target) != null;
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        IPhysicalTable target = this.getTargetTable();
        if (target != null && target.getDBMSType() instanceof TERADATAType && ((TERADATAType)target.getDBMSType()).getKeyMatchingPrimaryIndex(target) != null) {
            IKey key = ((TERADATAType)target.getDBMSType()).getKeyMatchingPrimaryIndex(target);
            warnings.add(MessageFormat.format(RB.getStringResource("TeradataTableLoaderTransformModel.PrimaryKeyIndex.Warning.txt"), key.getName()));
        }
        return warnings;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isValidAsTargetTable(this.getTargetTable());
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (!this.isValidAsTargetTable(this.getTargetTable())) {
            reasons.add(RB.getStringResource("TeradataTableLoaderTransformModel.TargetNotTeradata.txt"));
        }
        return reasons;
    }

    @Override
    public boolean isReplaceTypeEnabled(IPhysicalTable dataTable) {
        String loadStyle;
        boolean enabled = false;
        if (dataTable != null && (REPLACE_FASTLOAD.equals(loadStyle = this.getLoadStyle()) || REPLACE_MULTILOAD.equals(loadStyle) || TD_REPLACE_INSERT.equals(loadStyle))) {
            enabled = true;
        }
        return enabled;
    }

    public void setUseTPTUtilities(boolean bUseTPT) {
        if (bUseTPT == this.m_bUseTPTUtilities) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseTPTUtilitiesUndoable(this.m_bUseTPTUtilities, bUseTPT));
        }
        this.m_bUseTPTUtilities = bUseTPT;
        this.updateLoadUtilities();
        this.fireModelChangedEvent(USE_TPT_UTILITIES_CHANGED, null);
    }

    public boolean isTPTEnabled() {
        return this.m_bUseTPTUtilities;
    }

    public boolean isUsingTPTUtilitiesSupported() {
        return this.isUsingTPTUtilitiesSupported(this.getLoadStyle());
    }

    public boolean isUsingTPTUtilitiesSupported(String sLoadStyle) {
        return sLoadStyle.equals(APPEND_MULTILOAD) || sLoadStyle.equals(REPLACE_FASTLOAD) || sLoadStyle.equals(REPLACE_MULTILOAD) || sLoadStyle.equals(BEST_RUNTIME_TECHNIQUE) || sLoadStyle.equals(APPEND_TPUMP);
    }

    public boolean isUsingTPT() {
        return this.isTPTEnabled() && this.isUsingTPTUtilitiesSupported(this.getLoadStyle());
    }

    @Override
    public void setLoadStyle(String loadStyle) {
        if (loadStyle.equalsIgnoreCase(this.getLoadStyle())) {
            return;
        }
        this.startCompoundUndoable();
        try {
            super.setLoadStyle(loadStyle);
            if (this.isUsingTPTUtilitiesSupported(loadStyle)) {
                if (BEST_RUNTIME_TECHNIQUE.equals(loadStyle)) {
                    this.setUseTPTUtilities(this.isDefaultTPTUtilities());
                }
            } else {
                this.setUseTPTUtilities(false);
            }
            this.updateLoadUtilities();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void updateLoadUtilities() {
        ITransformTableOptions targetOptions;
        IPhysicalTable target = this.getTargetTable();
        if (target != null && target.getDBMSType() instanceof TERADATAType && (targetOptions = this.getTableOptionObject(target, false)) != null) {
            IPromptDefinitionValue tptOption = targetOptions.getOptionModel().findDefinition("TPT");
            IPromptDefinitionValue fastOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_FASTLOAD);
            IPromptDefinitionValue multOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_MULTILOAD);
            IPromptDefinitionValue multStmtOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_MULTISTMT);
            try {
                tptOption.setFixed(false);
                fastOption.setFixed(false);
                multOption.setFixed(false);
                multStmtOption.setFixed(false);
                tptOption.setValue(this.isUsingTPT() ? "YES" : "NO");
                fastOption.setValue(this.isFastLoadStyle() || this.isBestLoadStyle() ? "YES" : "NO");
                multOption.setValue(this.isMultiLoadReplaceStyle() || this.isMultiLoadStyle() || this.isBestLoadStyle() || UPSERT_MULTILOAD.equalsIgnoreCase(this.getLoadStyle()) ? "YES" : "NO");
                multStmtOption.setValue(this.isTPumpLoadStyle() ? "YES" : "NO");
                IPromptDefinitionValue errLimitOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_ERRLIMIT);
                if (errLimitOption != null) {
                    errLimitOption.setCodeGenerationEnabled(!this.isMultiLoadReplaceStyle() && !this.isMultiLoadStyle() && !UPSERT_MULTILOAD.equalsIgnoreCase(this.getLoadStyle()));
                }
                tptOption.setFixed(true);
                fastOption.setFixed(true);
                multOption.setFixed(true);
                multStmtOption.setFixed(true);
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
            }
        }
    }

    public boolean isCustomRestartEnabled() {
        return this.isCheckpointEnabled();
    }

    @Override
    public boolean isCustomRestartSupported() {
        String sLoadStyle = this.getLoadStyle();
        if (sLoadStyle.equals(APPEND_MULTILOAD) || sLoadStyle.equals(REPLACE_MULTILOAD)) {
            return true;
        }
        return this.isTPTEnabled() || sLoadStyle.equals(BEST_RUNTIME_TECHNIQUE);
    }

    private boolean isSAStoTeradata() {
        return this.isTPumpLoadStyle() || this.isFastLoadStyle() || this.isMultiLoadReplaceStyle() || this.isMultiLoadStyle() || this.isBestLoadStyle();
    }

    private boolean isTPumpLoadStyle() {
        return this.getLoadStyle().equals(APPEND_TPUMP);
    }

    public boolean isMultiLoadStyle() {
        return this.getLoadStyle().equals(APPEND_MULTILOAD);
    }

    public boolean isMultiLoadReplaceStyle() {
        return this.getLoadStyle().equals(REPLACE_MULTILOAD);
    }

    public boolean isFastLoadStyle() {
        return this.getLoadStyle().equals(REPLACE_FASTLOAD);
    }

    public boolean isBestLoadStyle() {
        return this.getLoadStyle().equals(BEST_RUNTIME_TECHNIQUE);
    }

    @Override
    public boolean isReplacingEntireTable() {
        if (this.getDataTargetsCount() > 0) {
            return (REPLACE_FASTLOAD.equalsIgnoreCase(this.getLoadStyle()) || REPLACE_MULTILOAD.equalsIgnoreCase(this.getLoadStyle()) || TD_REPLACE_INSERT.equalsIgnoreCase(this.getLoadStyle())) && this.getReplaceType().equalsIgnoreCase("EntireTable");
        }
        return false;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setUseTPTUtilities(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_TPT_UTILTIES, this.isDefaultTPTUtilities()));
        this.updateLoadUtilities();
        IPhysicalTable source = this.getSourceTable();
        if (source != null) {
            this.m_oPreviousSourceDBMSType = source.getDBMSType();
            this.m_bIsPrevSourceAndTargetSameServer = this.isSourceAndTargetSameDatabaseServer();
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_TPT_UTILTIES, this.isTPTEnabled());
        this.setChanged(false);
    }

    @Override
    protected IPhysicalTable[] getValidateTables() {
        ArrayList<IPhysicalTable> tables = new ArrayList<IPhysicalTable>(Arrays.asList(super.getValidateTables()));
        tables.add(this.getTargetTable());
        return tables.toArray(new IPhysicalTable[tables.size()]);
    }

    @Override
    protected void genLoadStyleCode(ICodeSegment codeSegment, boolean bValidate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPhysicalTable target = this.getTargetTable();
        boolean createConstraints = this.isConstraintEnabled(target) && !this.getConstraintBeforeValue().equalsIgnoreCase("OFF") && !this.getConstraintBeforeValue().equalsIgnoreCase("ASIS");
        boolean createIndexes = this.isIndexEnabled(target) && !(this.getIndexBeforeValue().equalsIgnoreCase("OFF") | this.getIndexBeforeValue().equalsIgnoreCase("ASIS"));
        IIndex modifyingIndex = null;
        if (UPSERT_MULTILOAD.equalsIgnoreCase(this.getLoadStyle()) || TD_UPDATE_INSERT.equalsIgnoreCase(this.getLoadStyle())) {
            codeSegment.addSourceCode("%let etls_hasUpdateIndex=0; \n\n");
        }
        IDBMSType tableDBMSType = target.getDBMSType();
        if (!this.isReplacingEntireTable()) {
            tableDBMSType.create(codeSegment, target, true, createConstraints, createIndexes, true, this.getDataTableOptions(), this);
        }
        if (UPSERT_MULTILOAD.equalsIgnoreCase(this.getLoadStyle())) {
            modifyingIndex = this.getIndexMatchingMatchColumns(target);
            this.updateCIPreLoad(codeSegment, target, true, modifyingIndex);
            this.loadWithUpsert(codeSegment, target, this.getMatchingColumnsList(), this.isUnmappedEqMissingInUpdate(), Arrays.asList(this.getOrdinaryUnmappedTargetColumns(null)));
        } else if (TD_UPDATE_INSERT.equalsIgnoreCase(this.getLoadStyle())) {
            modifyingIndex = this.getModifyIndex();
            this.updateCIPreLoad(codeSegment, target, true, modifyingIndex);
            this.loadWithSQLUpdateInsert(codeSegment, target, bValidate);
        } else if (REPLACE_FASTLOAD.equalsIgnoreCase(this.getLoadStyle()) || REPLACE_MULTILOAD.equalsIgnoreCase(this.getLoadStyle()) || TD_REPLACE_INSERT.equalsIgnoreCase(this.getLoadStyle())) {
            String restartReplaceCondition = this.getRestartReplaceCondition();
            String replaceType = this.getReplaceType();
            if (replaceType.equalsIgnoreCase("Delete") && tableDBMSType.isDeleteAllRowsSupported()) {
                boolean droppingCorI;
                boolean bl = droppingCorI = this.isConstraintEnabled() && this.getConstraintBeforeValue().equals("OFF") || this.isIndexEnabled() && this.getIndexBeforeValue().equals("OFF");
                if (droppingCorI) {
                    this.updateCIPreLoad(codeSegment, target, true, null);
                    codeSegment.addSourceCode("%if (&etls_tableExist eq 1)");
                    if (this.isGenerateCustomRestartCodeRequired() & this.isCustomRestartEnabled()) {
                        codeSegment.addSourceCode(restartReplaceCondition.equals("") ? "" : " and " + restartReplaceCondition);
                    }
                    codeSegment.addSourceCode(" %then \n");
                } else {
                    codeSegment.addSourceCode("%else\n");
                    if (this.isGenerateCustomRestartCodeRequired() & this.isCustomRestartEnabled()) {
                        codeSegment.addSourceCode(restartReplaceCondition.equals("") ? "\n" : " %if " + restartReplaceCondition + " %then \n");
                    }
                }
                codeSegment.addSourceCode("%do;  /* table exists */ \n").indent();
                tableDBMSType.deleteAllRows(codeSegment, target, replaceType.equals("Truncate"));
                target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLETRUNCATED", this, target);
                codeSegment.unIndent().addSourceCode("%end; /* table exists */ \n\n");
                if (!droppingCorI) {
                    this.updateCIPreLoad(codeSegment, target, false, null);
                }
            } else {
                boolean simTruncate = replaceType.equalsIgnoreCase("SimulateTruncate");
                if (!bValidate) {
                    if (this.isGenerateCustomRestartCodeRequired() & this.isCustomRestartEnabled()) {
                        codeSegment.addSourceCode("%if &etls_teraRestartType= %then %let etls_teraRestartType=0;\n\n");
                        codeSegment.addSourceCode("%if ").addSourceCode(restartReplaceCondition.equals("") ? "" : " " + restartReplaceCondition).addSourceCode("%then\n%do;\n").indent();
                    }
                    tableDBMSType.genReplaceEntireTable(codeSegment, target, this.isConstraintEnabled(), createConstraints, createIndexes, this.getDataTableOptions(), simTruncate, this);
                }
                if (this.isGenerateCustomRestartCodeRequired() & this.isCustomRestartEnabled()) {
                    codeSegment.addSourceCode("%end;\n").unIndent();
                }
            }
        } else {
            this.updateCIPreLoad(codeSegment, target, true, null);
        }
        if (TD_APPEND_INSERT.equalsIgnoreCase(this.getLoadStyle()) || TD_REPLACE_INSERT.equalsIgnoreCase(this.getLoadStyle())) {
            this.loadWithSQLInsert(codeSegment, target, bValidate);
        } else if (!TD_UPDATE_INSERT.equalsIgnoreCase(this.getLoadStyle()) && !UPSERT_MULTILOAD.equalsIgnoreCase(this.getLoadStyle())) {
            this.loadWithAppend(codeSegment, target);
        }
        this.updateCIPostLoad(codeSegment, target, modifyingIndex);
    }

    protected StringBuffer getSQLInsertUpdateTargetOptions() {
        return new StringBuffer();
    }

    @Override
    protected ICodeSegment loadWithUpsert(ICodeSegment codeSegment, IPhysicalTable table, List matchColumnList, boolean unmappedEqMissingInUpdate, List unmappedColumnList) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPromptDefinitionValue[] mlOpts = this.getMultiloadOptions();
        IPromptDefinitionValue[] exOpts = new IPromptDefinitionValue[mlOpts.length - 1];
        int exInd = 0;
        for (int i = 0; i < mlOpts.length; ++i) {
            if (mlOpts[i].getName().equals(OPTION_NAME_MULTILOAD)) continue;
            exOpts[exInd++] = mlOpts[i];
        }
        StringBuffer sMultiloadOptions = new StringBuffer(this.getOptionValues(exOpts));
        sMultiloadOptions.append(this.genCheckpointOption(false));
        return table.getDBMSType().loadWithUpsert(codeSegment, table, matchColumnList, unmappedEqMissingInUpdate, unmappedColumnList, sMultiloadOptions.toString(), this);
    }

    @Override
    public ICodeSegment append(ICodeSegment codeSegment, IPhysicalTable table, boolean genJobStatus, String tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        StringBuffer gen_opts = new StringBuffer();
        ITransformTableOptions targetOptions = this.getTableOptionObject(table, false);
        String targetDataOptions = "";
        if (targetOptions != null) {
            targetDataOptions = targetOptions.getTableOptions(false, null, tableOptions, codeSegment.getCurrentServer());
        }
        gen_opts.append(targetDataOptions).append(targetDataOptions.length() > 0 ? "\n" : "");
        if (genJobStatus) {
            codeSegment.genJobStatusUpdateBefore(table);
        }
        if (this.isSAStoTeradata()) {
            if (!this.isGenerateCustomRestartCodeRequired()) {
                this.genTeradataOptionsWithoutRestart(codeSegment, tableName, gen_opts);
            } else {
                this.genTeradataOptionsWithRestart(codeSegment, tableName, gen_opts);
            }
        } else {
            codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.Append.msg.notrans")).genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
            codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode("(").addSourceCode(gen_opts.toString()).addSourceCode(")\n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions) force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        }
        if (genJobStatus) {
            codeSegment.genJobStatusUpdateAfter(table);
        }
        return codeSegment;
    }

    private boolean isGenerateCustomRestartCodeRequired() {
        return this.isCustomRestartSupported() && this.isCPRStepCodeNeeded();
    }

    public ICodeSegment genTeradataOptionsWithoutRestart(ICodeSegment codeSegment, String tableName, StringBuffer gen_opts) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String sTPTOptions = this.getOptionValues(this.getTPTOptions());
        if (this.isFastLoadStyle()) {
            gen_opts.append(this.getOptionValues(this.getFastloadOptions()));
            gen_opts.append(this.genCheckpointOption(true));
            if (!this.isUsingTPT()) {
                gen_opts.append(" TPT = NO");
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.FastLoad.TPT.txt"));
            } else {
                gen_opts.append(sTPTOptions);
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.FastLoad.txt"));
            }
        } else if (this.isMultiLoadStyle() || this.isMultiLoadReplaceStyle()) {
            gen_opts.append(this.getOptionValues(this.getMultiloadOptions()));
            gen_opts.append(this.genCheckpointOption(false));
            if (!this.isUsingTPT()) {
                gen_opts.append(" TPT = NO");
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.MultiLoad.txt"));
            } else {
                gen_opts.append(sTPTOptions);
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.MultiLoad.TPT.txt"));
            }
        } else if (this.isBestLoadStyle()) {
            this.genBestLoadStyleCode(codeSegment, tableName, sTPTOptions, gen_opts, false);
        } else if (this.isTPumpLoadStyle()) {
            gen_opts.append(this.getOptionValues(this.getTPumpOptions()));
            if (!this.isUsingTPT()) {
                gen_opts.append(" TPT = NO");
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.TPUMP.txt"));
            } else {
                gen_opts.append(sTPTOptions);
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.TPUMP.TPT.txt"));
            }
        }
        if (!this.isBestLoadStyle()) {
            codeSegment.genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
            StringBuffer opts = new StringBuffer();
            if (gen_opts.length() > 0) {
                opts.append("(").append(gen_opts.toString()).append(" )");
            }
            codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(opts.toString()).addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions").addSourceCode(") force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        }
        return codeSegment;
    }

    protected ICodeSegment genBestLoadStyleCode(ICodeSegment codeSegment, String tableName, String sTPTOptions, StringBuffer gen_opts, boolean bRestart) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer gen_opts_fastload = new StringBuffer();
        StringBuffer gen_opts_multiload = new StringBuffer();
        if (!this.isUsingTPT()) {
            gen_opts.append(" TPT=NO ");
        }
        gen_opts_fastload.append(gen_opts);
        gen_opts_fastload.append(this.getOptionValues(this.getFastloadOptions()));
        gen_opts_fastload.append(this.genCheckpointOption(true));
        gen_opts_fastload.append(sTPTOptions);
        gen_opts_multiload.append(gen_opts);
        gen_opts_multiload.append(this.getOptionValues(this.getMultiloadOptions()));
        gen_opts_multiload.append(this.genCheckpointOption(false));
        gen_opts_multiload.append(sTPTOptions);
        codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.BestLoad.txt"));
        if (bRestart) {
            codeSegment.addSourceCode("%if &etlsCPR_runningID = " + this.getID() + " and &etls_teraBestType ne %then\n").addSourceCode("%do;\n").indent().addSourceCode("%if \"&etls_teraBestType\"=\"FAST\" %then %let etls_recnt=0;\n").addSourceCode("%else %let etls_recnt=0;\n").unIndent().addSourceCode("%end;\n").addSourceCode("%else %do;\n").indent();
        }
        codeSegment.addSourceCode("%let etls_recnt=-1;\n").addSourceCode("%let dsid = %sysfunc(open(").addSourceCode(this.getTargetTable().getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(", i));\n");
        codeSegment.addSourceCode("%let val=%sysfunc(fetch(&dsid));\n");
        codeSegment.addSourceCode("%let rc=%sysfunc(close(&dsid));\n");
        codeSegment.addSourceCode("%if &val eq 0 or &val eq -1 %then\n");
        codeSegment.indent().addSourceCode("%do;\n");
        codeSegment.indent();
        this.getGeneratedTargetRowCountCode(codeSegment);
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        codeSegment.unIndent();
        if (bRestart) {
            codeSegment.unIndent().addSourceCode("%end;\n");
        }
        codeSegment.addSourceCode("%put %bquote(").addSourceCode("\"").addSourceCode(RB.getStringResource("TeradataTableLoaderTransformModel.RestartAppendFromBeginning.txt")).addSourceCode("\"").addSourceCode(");\n");
        codeSegment.addSourceCode("%if &etls_recnt=0 \n").indent().addSourceCode("%then %do; \n").indent();
        if (bRestart) {
            codeSegment.addSourceCode("%let etls_teraBestType=FAST;\n");
        }
        StringBuffer opts_fl_wparens = new StringBuffer();
        StringBuffer opts_ml_wparens = new StringBuffer();
        codeSegment.genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
        if (gen_opts_fastload.length() > 0) {
            opts_fl_wparens.append("(").append(gen_opts_fastload.toString()).append(" )");
        }
        codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(opts_fl_wparens.toString()).addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions").addSourceCode(") force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        codeSegment.unIndent().addSourceCode("%end; \n");
        codeSegment.addSourceCode("%else %do; \n").indent();
        if (bRestart) {
            codeSegment.addSourceCode("%let etls_teraBestType=MULTI;\n");
        }
        if (gen_opts_multiload.length() > 0) {
            opts_ml_wparens.append("(").append(gen_opts_multiload.toString()).append(" )");
        }
        codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(opts_ml_wparens.toString()).addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions").addSourceCode(") force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        codeSegment.unIndent().addSourceCode("%end; \n");
        return codeSegment;
    }

    @Override
    protected ICodeSegment genBeginningMacros(ICodeSegment codeSegment) {
        if (this.isCustomRestartSupported()) {
            codeSegment.addSourceCode("%global SYS_TPT_USED;\n");
            if (this.isUsingTPT()) {
                codeSegment.addSourceCode("%global SYS_TPT_FIRSTOBS;\n");
                codeSegment.addSourceCode("%global SYS_TPT_FAILURE_PHASE;\n");
                codeSegment.addSourceCode("%global SYS_TPT_RESTART_TGT_OPT;\n");
                codeSegment.addSourceCode("%global SYS_TPT_RESTART_SRC_OPT;\n");
            } else {
                codeSegment.addSourceCode("%global SYS_MULTILOAD_FIRSTOBS;\n");
                codeSegment.addSourceCode("%global SYS_MULTILOAD_FAILURE_PHASE;\n");
                codeSegment.addSourceCode("%global SYS_MULTILOAD_RESTART_TGT_OPT;\n");
                codeSegment.addSourceCode("%global SYS_MULTILOAD_RESTART_SRC_OPT;\n");
                codeSegment.addSourceCode("%global SYS_MULTILOAD_LOGIN_FILE;\n");
                codeSegment.addSourceCode("%global ML_SCRIPTFILELOC;\n");
            }
        }
        if (this.isCPRStepCodeNeeded()) {
            codeSegment.addSourceCode("%if not (&etlsCPR_runningID = " + this.getID() + ") %then\n").addSourceCode("%do;\n").indent().addSourceCode("%let etls_teraRestartType=0;\n").addSourceCode("%let etls_teraBestType=;\n").addSourceCode("%let etls_failure_phase=;\n").addSourceCode("%let etls_teraRestartRow=1;\n").unIndent().addSourceCode("%end;\n");
        }
        return super.genBeginningMacros(codeSegment);
    }

    public ICodeSegment genTeradataOptionsWithRestart(ICodeSegment codeSegment, String tableName, StringBuffer gen_opts) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (!this.isBestLoadStyle()) {
            codeSegment.addSourceCode("%if &etls_teraRestartType= %then %let etls_teraRestartType=0;\n\n");
        }
        ITransformTableOptions transTblOpts = this.getTableOptionObject(this.getSourceTable(), false);
        String sourceOptions = "";
        if (transTblOpts != null) {
            sourceOptions = transTblOpts.getTableOptions(false, codeSegment.getCurrentServer());
        }
        StringBuffer restart_opts = new StringBuffer(gen_opts);
        if (this.isFastLoadStyle()) {
            if (this.isUsingTPT()) {
                gen_opts.append(this.getOptionValues(this.getTPTOptions()));
                restart_opts.append(this.getOptionValues(this.getTPTOptions()));
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.FastLoad.TPT.txt"));
            } else {
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.FastLoad.txt"));
            }
            codeSegment.genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
            gen_opts.append(this.getOptionValues(this.getFastloadOptions()));
            gen_opts.append(this.genCheckpointOption(true));
            restart_opts.append(this.getOptionValues(this.getFastloadOptions()));
            restart_opts.append(this.genCheckpointOption(true));
            restart_opts.append(" &etls_TPT_RESTART_TGT_OPT");
        } else if (this.isMultiLoadStyle() || this.isMultiLoadReplaceStyle()) {
            if (this.isUsingTPT()) {
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.MultiLoad.TPT.txt")).genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
                gen_opts.append(this.getOptionValues(this.getTPTOptions())).append(this.getOptionValues(this.getMultiloadOptions()));
                gen_opts.append(this.genCheckpointOption(false));
                restart_opts.append(this.getOptionValues(this.getTPTOptions())).append(this.getOptionValues(this.getMultiloadOptions()));
                restart_opts.append(this.genCheckpointOption(false));
                restart_opts.append(" &etls_tpt_restart_tgt_opt");
            } else {
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.MultiLoad.txt"));
                codeSegment.addSourceCode(this.genMultiloadFileOptions());
                codeSegment.addSourceCode("\n");
                codeSegment.genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
                gen_opts.append(this.getOptionValues(this.getMultiloadOptions()));
                gen_opts.append(this.genCheckpointOption(false));
                restart_opts.append(this.getOptionValues(this.getMultiloadOptions()));
                restart_opts.append(" &etls_ml_restart_tgt_opt");
                restart_opts.append(this.genCheckpointOption(false));
            }
        } else if (this.isBestLoadStyle()) {
            this.genBestLoadStyleCode(codeSegment, tableName, this.getOptionValues(this.getTPTOptions()), gen_opts, true);
        } else if (this.isTPumpLoadStyle()) {
            if (this.isUsingTPT()) {
                gen_opts.append(this.getOptionValues(this.getTPTOptions()));
                restart_opts.append(this.getOptionValues(this.getTPTOptions()));
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.TPUMP.TPT.txt"));
            } else {
                codeSegment.addSectionComment(RB.getStringResource("TeradataTableLoaderTransformModel.TPUMP.txt"));
            }
            codeSegment.genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
            gen_opts.append(this.getOptionValues(this.getTPumpOptions()));
            gen_opts.append(this.genCheckpointOption(false));
            restart_opts.append(" MULTISTMT=YES &etls_tpt_restart_tgt_opt");
            restart_opts.append(this.genCheckpointOption(false));
        }
        if (!this.isBestLoadStyle()) {
            boolean bCPRNeeded;
            if (!this.isUsingTPT()) {
                gen_opts.append(" TPT=NO");
                restart_opts.append(" TPT=NO");
            }
            if (bCPRNeeded = this.isCPRStepCodeNeeded()) {
                codeSegment.addSourceCode("%if &etls_teraRestartType=0 %then\n").addSourceCode("%do;\n").indent();
            }
            codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode("(").addSourceCode(gen_opts.toString()).addSourceCode(")").addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions").addSourceCode(") force; \n").addSourceCode("run; \n");
            if (bCPRNeeded) {
                codeSegment.unIndent().addSourceCode("%end;\n").addSourceCode("%else %if &etls_teraRestartType=1 %then\n").addSourceCode("%do;\n").indent();
                codeSegment.addSourceCode("%if \"&etls_failure_phase\" = \"ACQUISITION\" %then\n").addSourceCode("%do;\n").indent();
                codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode("(").addSourceCode(restart_opts.toString()).addSourceCode(")").addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (").addSourceCode(" &etls_tableOptions ");
                if (this.isUsingTPT()) {
                    codeSegment.addSourceCode(" &etls_tpt_restart_src_opt FIRSTOBS=&etls_teraRestartRow) force; \n");
                } else {
                    codeSegment.addSourceCode(" FIRSTOBS=&etls_teraRestartRow) force; \n");
                }
                codeSegment.addSourceCode("run;\n").unIndent().addSourceCode("%end;\n").addSourceCode("%else\n").addSourceCode("%do;\n").indent();
                if (this.isUsingTPT()) {
                    codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode("(").addSourceCode(restart_opts.toString()).addSourceCode(")\n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions").addSourceCode(" &etls_tpt_restart_src_opt) force; \n").addSourceCode("run;\n").unIndent();
                } else {
                    codeSegment.addSourceCode("%put ERROR%str(:) restart is unsupported for this type of load;\n");
                    codeSegment.addSourceCode("Intentional error to force no-syntax-check mode  and prevent further processing.;\n");
                    codeSegment.addSourceCode("%put Restart script located at - &ML_SCRIPTFILELOC;\n");
                    codeSegment.unIndent();
                }
                codeSegment.addSourceCode("%end;\n").unIndent().addSourceCode("%end;\n");
                codeSegment.unIndent();
                codeSegment.unIndent();
            }
            codeSegment.genRCSetCall("&syserr");
        }
        return codeSegment;
    }

    protected String getRestartReplaceCondition() {
        if (this.isCustomRestartSupported()) {
            return "&etls_teraRestartType = 0 ";
        }
        return "";
    }

    @Override
    public ICodeSegment getCPRCustomPreStepCode(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("%etlsCPR_loadStepFailInfo(" + this.getID() + ", " + FAIL_INFO_TABLE_NAME + ");\n").addSourceCode("%etlsCPR_clearStepFailInfo();\n");
        if (this.getLoadStyle().equals(BEST_RUNTIME_TECHNIQUE)) {
            codeSegment.addSourceCode("%let etls_teraBestType=;\n").addSourceCode("%if %sysfunc(exist(work.etls_failureInfo)) %then \n").addSourceCode("%do; \n").indent().addSourceCode("data _null_;\n").addSourceCode("   set work.etls_failureInfo;\n").indent().addSourceCode("call symput('etls_teraBestType', bestType);\n").unIndent().addSourceCode("run;\n").unIndent().addSourceCode("%end;\n");
            return codeSegment;
        }
        codeSegment.addSourceCode("%local etls_tpt_used etls_failure_phase etls_teraRestartType;\n");
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("%local etls_tpt_restart_tgt_opt etls_tpt_restart_src_opt ;\n");
        } else {
            codeSegment.addSourceCode("%local etls_ml_restart_tgt_opt etls_ml_restart_src_opt etls_ml_failure_phase;\n");
        }
        codeSegment.addSourceCode("%local etls_ml_firstobs etls_tpt_firstobs;\n").addSourceCode("%if %sysfunc(exist(work.etls_failureInfo)) %then \n").addSourceCode("%do; \n").indent().addSourceCode("data _null_;\n").addSourceCode("   set work.etls_failureInfo;\n");
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("   call symput('etls_tpt_firstobs',trim(left(put(tpt_firstobs,8.))));\n").addSourceCode("   call symput('etls_tpt_failure_phase',trim(tpt_failure_phase));\n").addSourceCode("   call symput('etls_tpt_restart_tgt_opt',trim(tpt_restart_tgt_opt));\n").addSourceCode("   call symput('etls_tpt_restart_src_opt',trim(tpt_restart_src_opt));\n");
        } else {
            codeSegment.addSourceCode("   call symput('etls_ml_firstobs',trim(left(put(ml_firstobs,8.))));\n").addSourceCode("   call symput('etls_ml_failure_phase',trim(ml_failure_phase));\n").addSourceCode("   call symput('etls_ml_restart_tgt_opt',trim(ml_restart_tgt_opt));\n").addSourceCode("   call symput('etls_ml_restart_src_opt',trim(ml_restart_src_opt));\n");
        }
        codeSegment.addSourceCode("   call symput('etls_tpt_used',trim(tpt_used));\n").addSourceCode("   call symput('etls_teraRestartRow',trim(first_obs));\n").addSourceCode("run;\n");
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("%if &etls_tpt_restart_tgt_opt ne & ").addSourceCode("&etls_tpt_firstobs ne %then \n").addSourceCode("%do;\n").indent().addSourceCode("%let etls_teraRestartType = 1;\n").addSourceCode("%if &etls_teraRestartRow = 0 %then\n").indent().addSourceCode("%let etls_teraRestartRow = &etls_tpt_firstobs;\n").unIndent().addSourceCode("%else \n").addSourceCode("%do;\n").indent().addSourceCode("%if \"&etls_tpt_used\" = \"YES\" %then\n").addSourceCode("%do;\n").indent().addSourceCode("%let etls_ldr_firstobs = %eval(&etls_tpt_firstobs + &etls_teraRestartRow - 1);\n").addSourceCode("%let etls_teraRestartRow = &etls_ldr_firstobs;\n").unIndent().addSourceCode("%end;\n").addSourceCode("%else\n").addSourceCode("%do;\n").indent().addSourceCode("%let etls_ldr_firstobs = &etls_tpt_firstobs;\n").addSourceCode("%let etls_teraRestartRow = &etls_ldr_firstobs;\n").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%end;\n");
        } else {
            codeSegment.addSourceCode("%if &etls_ml_restart_tgt_opt ne & ").addSourceCode("&etls_ml_firstobs ne %then \n").addSourceCode("%do;\n").indent().addSourceCode("%let etls_teraRestartType = 1;\n").addSourceCode("%if &etls_teraRestartRow = 0 %then\n").indent().addSourceCode("%let etls_teraRestartRow = &etls_ml_firstobs;\n").unIndent().addSourceCode("%else \n").addSourceCode("%do;\n").indent().addSourceCode("%if &etls_ml_firstobs ne 0 %then\n").indent().addSourceCode("%do;\n").indent().addSourceCode("%let etls_ldr_firstobs = &etls_ml_firstobs;\n").addSourceCode("%let etls_teraRestartRow = &etls_ldr_firstobs;\n").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%end;\n");
        }
        codeSegment.addSourceCode("%else \n").indent().addSourceCode("%let etls_teraRestartType=0;\n").unIndent().unIndent();
        codeSegment.addSourceCode("%if &etls_teraRestartRow = 0 %then %let etls_teraRestartRow=1;\n");
        codeSegment.addSourceCode("%end;\n\n");
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("%if &etls_tpt_failure_phase ne %then \n").indent().addSourceCode("%let etls_failure_phase = &etls_tpt_failure_phase;\n");
        } else {
            codeSegment.addSourceCode("%if &etls_ml_failure_phase ne %then \n").indent().addSourceCode("%let etls_failure_phase = &etls_ml_failure_phase;\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getCPRCustomPostStepCode(ICodeSegment codeSegment) {
        if (this.getLoadStyle().equals(BEST_RUNTIME_TECHNIQUE)) {
            codeSegment.addSourceCode("%etlsCPR_setNoSyntaxCheck;\n").addSourceCode("data work.etls_failureInfo;\n").indent();
            codeSegment.addSourceCode("bestType=\"&etls_teraBestType\";\n").unIndent().addSourceCode("run;\n");
            codeSegment.addSourceCode("%etlsCPR_resetNoSyntaxCheck;\n").addSourceCode("%etlsCPR_saveStepFailInfo(" + this.getID() + ", " + FAIL_INFO_TABLE_NAME + ");\n");
            return codeSegment;
        }
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("%if &sys_tpt_firstobs = %then \n").addSourceCode("%let sys_tpt_firstobs = 0;\n");
        } else {
            codeSegment.addSourceCode("%if &sys_multiload_firstobs = %then \n").addSourceCode("%let sys_multiload_firstobs = 0;\n");
        }
        codeSegment.addSourceCode("%if &etls_teraRestartType = 0 %then \n").addSourceCode("%let etls_teraRestartRow = 0;\n");
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("%if &sys_tpt_restart_tgt_opt ne %then \n");
        } else {
            codeSegment.addSourceCode("%if \"&sys_multiload_failure_phase\"=\"APPLICATION\" || &sys_multiload_restart_tgt_opt ne %then \n");
        }
        codeSegment.addSourceCode("%do;\n").indent().addSourceCode("%etlsCPR_setNoSyntaxCheck;\n").addSourceCode("data work.etls_failureInfo;\n").indent();
        if (this.isUsingTPT()) {
            codeSegment.addSourceCode("tpt_firstobs=\"&sys_tpt_firstobs\";\n").addSourceCode("tpt_failure_phase=\"&sys_tpt_failure_phase\";\n").addSourceCode("tpt_restart_src_opt=\"&sys_tpt_restart_src_opt\";\n").addSourceCode("tpt_restart_tgt_opt=\"&sys_tpt_restart_tgt_opt\";\n");
        } else {
            codeSegment.addSourceCode("ml_firstobs=\"&sys_multiload_firstobs\";\n").addSourceCode("ml_failure_phase=\"&sys_multiload_failure_phase\";\n").addSourceCode("ml_restart_src_opt=\"&sys_multiload_restart_src_opt\";\n").addSourceCode("ml_restart_tgt_opt=\"&sys_multiload_restart_tgt_opt\";\n");
        }
        codeSegment.addSourceCode("tpt_used=\"&sys_tpt_used\";\n").addSourceCode("first_obs=\"&etls_teraRestartRow\";\n").unIndent().addSourceCode("run;\n\n");
        if (!this.isUsingTPT() && (this.isMultiLoadStyle() || this.isMultiLoadReplaceStyle())) {
            String scrName = codeSegment.formatObjectIDForMacroVar(this);
            StringBuffer scriptFile = new StringBuffer("\"&ML_SCRIPTFILELOC.").append(scrName).append(".txt\"");
            codeSegment.addSourceCode("%if \"&ML_SCRIPTFILELOC\" ne %then\n").addSourceCode("%do;\n").indent();
            codeSegment.addSourceCode("%if \"&sys_multiload_failure_phase\"=\"APPLICATION\" %then \n").addSourceCode("%do;\n").addSourceCode("data _null_;\n").indent().addSourceCode("file ").addSourceCode(scriptFile.toString()).addSourceCode(";\n").addSourceCode("length etls_scr $32767;\n").addSourceCode("etls_scr = symget('SYS_MULTILOAD_RESTART_SCRIPT');\n").addSourceCode("etls_scr = substr(etls_scr, 6, length(etls_scr) - 7);\n").addSourceCode("etls_pos = index(etls_scr,\";\");\n").addSourceCode("do until (etls_pos = 0);\n").indent().addSourceCode("etls_nextline=substr(etls_scr,1,etls_pos);\n").addSourceCode("put etls_nextline;\n").addSourceCode("etls_pos=etls_pos+1;\n").addSourceCode("if etls_pos < length(etls_scr) then\n").addSourceCode("do;\n").indent().addSourceCode("etls_scr=substr(etls_scr,etls_pos);\n").addSourceCode("etls_pos=index(etls_scr,\";\");\n").unIndent().addSourceCode("end;\n").addSourceCode("else\n").addSourceCode("do;\n").indent().addSourceCode("etls_pos=0;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("run;\n").unIndent().genPercentPutStatement(RB.getStringResource("TeradataTableLoaderTransformModel.ScriptFileSet.txt"), "ERROR%QUOTE(:)").addSourceCode("\n").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%else;\n").indent().addCommentLine(RB.getStringResource("TeradataTableLoaderTransformModel.NoScriptFileSet.txt")).unIndent().addSourceCode("%end;\n");
        }
        codeSegment.addSourceCode("%etlsCPR_resetNoSyntaxCheck;\n").addSourceCode("%etlsCPR_saveStepFailInfo(" + this.getID() + ", " + FAIL_INFO_TABLE_NAME + ");\n").unIndent().addSourceCode("%end;\n\n");
        return codeSegment;
    }

    private class SetUseTPTUtilitiesUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldbUseTPTUtilities;
        private boolean m_newbUseTPTUtilities;

        public SetUseTPTUtilitiesUndoable(boolean oldbUseTPTUtilities, boolean newbUseTPTUtilities) {
            this.m_oldbUseTPTUtilities = oldbUseTPTUtilities;
            this.m_newbUseTPTUtilities = newbUseTPTUtilities;
        }

        @Override
        public void undo() {
            super.undo();
            TeradataTableLoaderTransformModel.this.setUseTPTUtilities(this.m_oldbUseTPTUtilities);
        }

        @Override
        public void redo() {
            super.redo();
            TeradataTableLoaderTransformModel.this.setUseTPTUtilities(this.m_newbUseTPTUtilities);
        }
    }

    protected class cTeradataLoaderOptionModel
    extends BaseLoaderPromptModel
    implements IPromptModel {
        public cTeradataLoaderOptionModel(IModel model, ILoaderTransform owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
            IPromptDefinitionValue dbiDefinition = this.getPromptDefinitionValue("OPTION_DBI_DIRECT_EXEC");
            if (dbiDefinition != null) {
                dbiDefinition.setHidden(false);
                dbiDefinition.setDefaultValue(TeradataTableLoaderTransformModel.this.getDefaultDBIDirectExecValue());
            }
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cTeradataLoaderOptionModel.class.getResource("res/Options_TeradataTableLoader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected IModelListener createModelListener() {
            return new cLoaderModelListener((TableLoaderTransformModel)this.getOwner());
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            TeradataTableLoaderTransformModel tl = (TeradataTableLoaderTransformModel)this.getOwner();
            this.setOptionValue("UnmappedEqMissingInUpdate", (Object)tl.booleanToYesNo(tl.isUnmappedEqMissingInUpdate()));
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new LoaderTransformValueChangedListener((TableLoaderTransformModel)this.getOwner(), this);
        }

        private class LoaderTransformValueChangedListener
        extends BaseLoaderTransformValueChangedListener {
            public LoaderTransformValueChangedListener(TableLoaderTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals("UnmappedEqMissingInUpdate")) {
                        TeradataTableLoaderTransformModel.this.setUnmappedEqMissingInUpdate(((TableLoaderTransformModel)this.getOwner()).yesNoToBoolean(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class cLoaderModelListener
        extends BaseLoaderModelListener {
            public cLoaderModelListener(TableLoaderTransformModel transform) {
                super(transform, (IPromptModel)cTeradataLoaderOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals("TableLoaderTransformModel:UnmappedMissingEQInUpdateChanged")) {
                        cTeradataLoaderOptionModel.this.setOptionValue("UnmappedEqMissingInUpdate", (Object)TeradataTableLoaderTransformModel.this.booleanToYesNo(TeradataTableLoaderTransformModel.this.isUnmappedEqMissingInUpdate()));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

