/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.SASSPDSType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractLoaderTransform;
import com.sas.etl.models.job.impl.BaseLoaderModelListener;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.BaseLoaderTransformValueChangedListener;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UsageVersion;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SPDSTableLoaderTransformModel
extends AbstractLoaderTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SPDSLoader";
    private static final String TRANSFORMATION_ROLE = "Loader:HIDE";
    private static final String ARM_DISPLAY_NAME = "SPDSLoader";
    private boolean m_bInTableLoaderRemove = false;
    private boolean m_bDropRecreateIndexesAfter = false;
    private boolean m_bDropRecreateIndexesBefore = false;
    private boolean m_bParallelIndexCreation = false;
    private int m_iGroupingLimit = 0;
    private static final UsageVersion SPDS_LOADER_MODEL_VERSION = new UsageVersion(2, 1);
    public static final String TRUNCATE_TABLE_CHANGED = "SPDSTableLoaderTransformModel:TruncateTableChanged";
    public static final String REMOVE_ALL_ROWS_CHANGED = "SPDSTableLoaderTransformModel:RemovaAllRowsChanged";
    public static final String DROP_TABLE_CHANGED = "SPDSTableLoaderTransformModel:DropTableChanged";
    public static final String DROP_RECREATE_INDEXES_AFTER_CHANGED = "SPDSTableLoaderTransformModel:DropRecreateIndexesAfterChanged";
    public static final String DROP_RECREATE_INDEXES_BEFORE_CHANGED = "SPDSTableLoaderTransformModel:DropRecreateIndexesBeforeChanged";
    public static final String PARALLEL_INDEX_CREATION_CHANGED = "SPDSTableLoaderTransformModel:ParallelIndexCreationChanged";
    public static final String GROUPING_LIMIT_CHANGED = "SPDSTableLoaderTransformModel:GroupingLimitChanged";
    public static final String LOAD_TYPE_CHANGED = "SPDSTableLoaderTransformModel:LoadTypeChanged";
    public static final String REFRESH_TYPE_CHANGED = "SPDSTableLoaderTransformModel:RefreshTypeChanged";
    public static final int REFRESH_TYPE_TRUNCATE = 0;
    public static final int REFRESH_TYPE_REMOVE = 1;
    public static final int REFRESH_TYPE_DROP = 2;
    public static final String DATA_TABLE_OPTIONS_CHANGED = "SPDSTableLoaderTransformModel:DataTableOptionsChanged";
    public static final String MACRO_OPTIONS_CHANGED = "SPDSTableLoaderTransformModel:MacroOptionsChanged";
    public static final String LOADTYPE_UPDATE = "Update";
    public static final String LOADTYPE_APPEND = "Append";
    public static final String LOADTYPE_REFRESH = "Refresh";
    private static final String PROPERTY_NAME_INDEX_BEFORE = "RecreateIndex";
    private static final String PROPERTY_NAME_INDEX_AFTER = "RecreateIndexAfter";
    private static final String PROPERTY_NAME_PARALLEL_INDEXES = "ParallelIndex";
    private static final String PROPERTY_NAME_GROUPING_LIMIT = "ParallelGroup";
    private static final String DATATABLE_OPTIONS = "DataTableOptions";
    private static final String PROPERTY_NAME_LOAD_TYPE = "LoadType";
    private static final String PROPERTY_NAME_REMOVE = "Remove";
    private static final String PROPERTY_NAME_TRUNCATE = "Truncate";
    private static final String PROPERTY_NAME_DROP = "Drop";
    private String m_sDefaultLoadType = "Refresh";
    private String m_sDataTableOptions;
    private String m_sLoadType;
    private int m_iRefreshType;
    private cSPDSLoaderOptionModel m_spdsOptionModel;

    public SPDSTableLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
        super.setCollectSourceTableRowCounts(false);
        super.setCollectTargetTableRowCounts(true);
        this.createConditionActionSetTemplates();
        ModelLogger.getDefaultLogger().debug((Object)"here is the spds loader");
        this.m_sLoadType = this.m_sDefaultLoadType;
        this.m_sDataTableOptions = "";
    }

    @Override
    public UsageVersion getModelVersion() {
        return SPDS_LOADER_MODEL_VERSION;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SPDSTableLoaderTransformModel.Name.txt");
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            if (this.getSPDSMacroOptionModel().isChanged()) {
                this.getSPDSMacroOptionModel().saveToOMR(omr);
            }
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_LOAD_TYPE, PROPERTY_NAME_LOAD_TYPE, "", this.m_sLoadType, 12, 2);
        String sOption = this.setBooleanValue(this.isDropRecreateIndexesBeforeSet());
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_BEFORE, PROPERTY_NAME_INDEX_BEFORE, "", sOption, 12, 2);
        sOption = this.setBooleanValue(this.isDropRecreateIndexesAfterSet());
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_AFTER, PROPERTY_NAME_INDEX_AFTER, "", sOption, 12, 2);
        sOption = this.setBooleanValue(this.isParallelIndexCreationSet());
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_PARALLEL_INDEXES, PROPERTY_NAME_PARALLEL_INDEXES, "", sOption, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPING_LIMIT, PROPERTY_NAME_GROUPING_LIMIT, "", String.valueOf(this.getGroupingLimit()), 12, 2);
        sOption = this.setBooleanValue(this.getRefreshType() == 1);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_REMOVE, PROPERTY_NAME_REMOVE, "", sOption, 12, 2);
        sOption = this.setBooleanValue(this.getRefreshType() == 0);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_TRUNCATE, PROPERTY_NAME_TRUNCATE, "", sOption, 12, 2);
        sOption = this.setBooleanValue(this.getRefreshType() == 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_DROP, PROPERTY_NAME_DROP, "", sOption, 12, 2);
        this.savePropertyToOMR(omr, "", DATATABLE_OPTIONS, DATATABLE_OPTIONS, DATATABLE_OPTIONS, this.getDataTableOptions(), 12, 1);
        this.getSPDSMacroOptionModel().saveToOMR(omr);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep step = (TransformationStep)omr.acquireOMRObject(this);
        PropertySet mdoSet = this.findPropertySet(omr, (Root)step, "OPTIONS", 2);
        boolean bTruncateSetProperly = false;
        boolean bTruncateSetImproperly = false;
        boolean bTruncatePropertyMissing = true;
        if (mdoSet != null) {
            Property mdoProperty = this.findProperty(omr, (Root)step, "OPTIONS", PROPERTY_NAME_TRUNCATE, 0);
            if (mdoProperty != null) {
                bTruncateSetImproperly = true;
                bTruncatePropertyMissing = false;
            } else {
                mdoProperty = this.findProperty(omr, (Root)step, "OPTIONS", PROPERTY_NAME_TRUNCATE, 2);
                if (mdoProperty != null) {
                    bTruncateSetProperly = true;
                    bTruncatePropertyMissing = false;
                }
            }
        }
        String sPropVal = "";
        if (bTruncatePropertyMissing) {
            this.m_sLoadType = this.m_sDefaultLoadType;
            this.setRefreshType(0);
        }
        if (bTruncateSetImproperly) {
            this.m_sLoadType = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_LOAD_TYPE, this.m_sDefaultLoadType, 0);
            if (!bTruncatePropertyMissing) {
                boolean bRefreshTypeSet = false;
                sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_REMOVE, "NO", 0);
                if (sPropVal.equals("YES")) {
                    this.setRefreshType(1);
                    bRefreshTypeSet = true;
                }
                if ((sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_TRUNCATE, "NO", 0)).equals("YES")) {
                    this.setRefreshType(0);
                    bRefreshTypeSet = true;
                }
                if ((sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_DROP, "NO", 0)).equals("YES")) {
                    this.setRefreshType(2);
                    bRefreshTypeSet = true;
                }
                if (!bRefreshTypeSet) {
                    this.setRefreshType(2);
                }
            }
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_BEFORE, "NO", 0);
            this.m_bDropRecreateIndexesBefore = this.getBooleanValue(sPropVal);
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_AFTER, "NO", 0);
            this.m_bDropRecreateIndexesAfter = this.getBooleanValue(sPropVal);
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_PARALLEL_INDEXES, "NO", 0);
            this.m_bParallelIndexCreation = this.getBooleanValue(sPropVal);
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPING_LIMIT, "0", 0);
            try {
                this.m_iGroupingLimit = this.getIntValue(sPropVal);
            }
            catch (NumberFormatException ex) {
                this.m_iGroupingLimit = 0;
            }
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_LOAD_TYPE);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_BEFORE);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_AFTER);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_PARALLEL_INDEXES);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPING_LIMIT);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_REMOVE);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_TRUNCATE);
            this.deletePropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_DROP);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_LOAD_TYPE, this.m_sDefaultLoadType, 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_REMOVE, "NO", 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_TRUNCATE, "NO", 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_DROP, "NO", 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_BEFORE, "NO", 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_AFTER, "NO", 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_PARALLEL_INDEXES, "NO", 2);
            this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPING_LIMIT, "0", 2);
        } else {
            this.m_sLoadType = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_LOAD_TYPE, this.m_sDefaultLoadType, 2);
            if (!bTruncatePropertyMissing) {
                boolean bRefreshTypeSet = false;
                sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_REMOVE, "NO", 2);
                if (sPropVal.equals("YES")) {
                    this.setRefreshType(1);
                    bRefreshTypeSet = true;
                }
                if ((sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_TRUNCATE, "NO", 2)).equals("YES")) {
                    this.setRefreshType(0);
                    bRefreshTypeSet = true;
                }
                if ((sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_DROP, "NO", 2)).equals("YES")) {
                    this.setRefreshType(2);
                    bRefreshTypeSet = true;
                }
                if (!bRefreshTypeSet) {
                    this.setRefreshType(2);
                }
            }
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_BEFORE, "NO", 2);
            this.m_bDropRecreateIndexesBefore = this.getBooleanValue(sPropVal);
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_INDEX_AFTER, "NO", 2);
            this.m_bDropRecreateIndexesAfter = this.getBooleanValue(sPropVal);
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_PARALLEL_INDEXES, "NO", 2);
            this.m_bParallelIndexCreation = this.getBooleanValue(sPropVal);
            sPropVal = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPING_LIMIT, "0", 2);
            try {
                this.m_iGroupingLimit = this.getIntValue(sPropVal);
            }
            catch (NumberFormatException ex) {
                this.m_iGroupingLimit = 0;
            }
        }
        this.setDataTableOptions(this.loadPropertyFromOMR(omr, "", DATATABLE_OPTIONS, "", 1));
        this.getSPDSMacroOptionModel().loadFromOMR(omr);
        this.setChanged(true);
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETDATAMODIFIED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLECREATED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLEDROPPED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLETRUNCATED");
    }

    private boolean getBooleanValue(String propertyValue) {
        return propertyValue.equals("YES");
    }

    private String setBooleanValue(boolean boolValue) {
        if (boolValue) {
            return "YES";
        }
        return "NO";
    }

    private int getIntValue(String propertyValue) {
        return Integer.valueOf(propertyValue);
    }

    @Override
    protected void saveWorkTablesToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        this.m_spdsOptionModel = new cSPDSLoaderOptionModel(this.getModel(), this);
        return this.m_spdsOptionModel;
    }

    protected IPromptModel getSPDSMacroOptionModel() {
        return this.m_spdsOptionModel;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.getSPDSMacroOptionModel().updateIDs(mapIDs);
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SPDSTableLoaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("Loader doesnt support work tables");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(IDataObject target) {
        if (this.m_bInTableLoaderRemove) {
            return;
        }
        this.startCompoundUndoable();
        try {
            try {
                this.m_bInTableLoaderRemove = true;
                super.removeDataTarget(target);
                boolean bOldUndoableSetting = this.getModel().isUndoSupported();
                this.getModel().setUndoSupported(false);
                this.getModel().setUndoSupported(bOldUndoableSetting);
            }
            finally {
                this.m_bInTableLoaderRemove = false;
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void deleteWorkTablesFromOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public IWorkTable[] getWorkTables() {
        return new IWorkTable[0];
    }

    public String getDataTableOptions() {
        return this.m_sDataTableOptions;
    }

    public void setDataTableOptions(String newDataTableOptions) {
        this.startCompoundUndoable();
        try {
            if (this.m_sDataTableOptions.equals(newDataTableOptions)) {
                return;
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDataTableOptionsUndoable(this.m_sDataTableOptions, newDataTableOptions));
            }
            this.m_sDataTableOptions = newDataTableOptions;
            this.fireModelChangedEvent(DATA_TABLE_OPTIONS_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public List getAvailableIndexes() {
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            return dataTarget.getIndexesList();
        }
        return new ArrayList();
    }

    public void setLoadType(String sValue) {
        if (sValue.equalsIgnoreCase(this.m_sLoadType)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (!(sValue.equalsIgnoreCase(LOADTYPE_UPDATE) || sValue.equalsIgnoreCase(LOADTYPE_APPEND) || sValue.equalsIgnoreCase(LOADTYPE_REFRESH))) {
                throw new IllegalArgumentException("LoadType value passed in not one of the allowed types");
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetLoadTypeUndoable(this.m_sLoadType, sValue));
            }
            this.m_sLoadType = sValue;
            this.fireModelChangedEvent(LOAD_TYPE_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public String getLoadType() {
        return this.m_sLoadType;
    }

    public boolean isAppendLoadType() {
        return this.getLoadType().equals(LOADTYPE_APPEND);
    }

    public boolean isRefreshLoadType() {
        return this.getLoadType().equals(LOADTYPE_REFRESH);
    }

    public boolean isUpdateLoadType() {
        return this.getLoadType().equals(LOADTYPE_UPDATE);
    }

    public boolean isTruncateRefreshType() {
        return this.getRefreshType() == 0;
    }

    public boolean isDropRefreshType() {
        return this.getRefreshType() == 2;
    }

    public boolean isRemoveAllRefreshType() {
        return this.getRefreshType() == 1;
    }

    public void setRefreshType(int iValue) {
        if (this.m_iRefreshType == iValue) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (iValue != 0 && iValue != 1 && iValue != 2) {
                throw new IllegalArgumentException("ReplaceType value passed in not one of the allowed types");
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetRefreshTypeUndoable(this.m_iRefreshType, iValue));
            }
            this.m_iRefreshType = iValue;
            this.fireModelChangedEvent(REFRESH_TYPE_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public int getRefreshType() {
        return this.m_iRefreshType;
    }

    public boolean isDropRecreateIndexesAfterSet() {
        return this.m_bDropRecreateIndexesAfter;
    }

    public void setDropRecreateIndexesAfter(boolean bValue) {
        if (bValue == this.m_bDropRecreateIndexesAfter) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDropRecreateIndexesAfterUndoable(this.m_bDropRecreateIndexesAfter, bValue));
            }
            this.m_bDropRecreateIndexesAfter = bValue;
            this.fireModelChangedEvent(DROP_RECREATE_INDEXES_AFTER_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public boolean isDropRecreateIndexesBeforeSet() {
        return this.m_bDropRecreateIndexesBefore;
    }

    public void setDropRecreateIndexesBefore(boolean bValue) {
        if (bValue == this.m_bDropRecreateIndexesBefore) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDropRecreateIndexesBeforeUndoable(this.m_bDropRecreateIndexesBefore, bValue));
            }
            this.m_bDropRecreateIndexesBefore = bValue;
            this.fireModelChangedEvent(DROP_RECREATE_INDEXES_BEFORE_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void setParallelIndexCreation(boolean bValue) {
        if (bValue == this.m_bParallelIndexCreation) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetParallelIndexCreationUndoable(this.m_bParallelIndexCreation, bValue));
            }
            this.m_bParallelIndexCreation = bValue;
            this.fireModelChangedEvent(PARALLEL_INDEX_CREATION_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public boolean isParallelIndexCreationSet() {
        return this.m_bParallelIndexCreation;
    }

    public void setGroupingLimit(String sValue) {
        if (sValue.length() == 0) {
            this.setGroupingLimit(0);
        } else {
            try {
                int i = Integer.valueOf(sValue);
                this.setGroupingLimit(i);
            }
            catch (NumberFormatException invalid) {
                this.setGroupingLimit(0);
            }
        }
    }

    public void setGroupingLimit(int iValue) {
        if (iValue == this.m_iGroupingLimit) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetGroupingLimitUndoable(this.m_iGroupingLimit, iValue));
            }
            this.m_iGroupingLimit = iValue;
            this.fireModelChangedEvent(GROUPING_LIMIT_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public int getGroupingLimit() {
        return this.m_iGroupingLimit;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            try {
                String type = dataTarget.getDBMSProductName();
                if (type == null) {
                    lReasons.add(RB.getStringResource("SPDSTableLoaderTransformModel.IncompleteSPDSTableRequired.msg.txt"));
                } else if (!type.equals("SASSPDS") && !type.equals("SASSPDSPRE43")) {
                    lReasons.add(RB.getStringResource("SPDSTableLoaderTransformModel.IncompleteSPDSTableRequired.msg.txt"));
                }
            }
            catch (BadLibraryDefinitionException ble) {
                lReasons.add(ble.getLocalizedMessage());
            }
        }
        return lReasons;
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            try {
                String type = dataTarget.getDBMSProductName();
                if (!type.equals("SASSPDS") && !type.equals("SASSPDSPRE43")) {
                    return false;
                }
            }
            catch (BadLibraryDefinitionException ble) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws ServerException, CodegenException, RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException {
        boolean indexesCanBeDropped;
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        codeSegment.addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        codeSegment.addSectionComment(RB.getStringResource("SPDSTableLoaderTransformModel.DefineMacro.msg.notrans")).addSourceCode("\n");
        ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
        codeSegment.addSourceCode("%macro etls_loader;\n\n").indent();
        String dsOptions = this.getTableOptionObject(source, true).getTableOptions(false, codeSegment.getCurrentServer());
        if (dsOptions != null && dsOptions.length() > 0) {
            codeSegment.addSourceCode("%let etls_tableOptions = %nrquote(").addSourceCode(dsOptions).addSourceCode(");\n\n");
        } else {
            codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
        }
        IDataObject[] sources = this.getDataSources();
        int numSources = sources.length;
        if (numSources > 1 && !this.isAppendLoadType()) {
            throw new CodegenException(RB.getStringResource("DBMSSTORE.MultipleInputs.msg.txt"), (IObject)this);
        }
        try {
            this.loadMacroValues(codeSegment);
        }
        catch (Exception sce) {
            throw new CodegenException(sce.getLocalizedMessage(), (IObject)this);
        }
        List columnsToExcludeFromMapping = this.genLoadTimeCode(codeSegment, target);
        codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.Exist.msg.notrans"));
        codeSegment.genTableExist(target.getFullNameQuotedAsNeeded(codeSegment), "etls_tableExist");
        String additionalTableOptions = this.getDataTableOptions();
        boolean inParallel = this.isParallelIndexCreationSet();
        Integer parallelgroup = new Integer(this.getGroupingLimit());
        boolean truncate = this.isTruncateRefreshType();
        boolean remove = this.isRemoveAllRefreshType();
        boolean drop = this.isDropRefreshType();
        boolean update = this.isUpdateLoadType();
        boolean append = this.isAppendLoadType();
        boolean refresh = this.isRefreshLoadType();
        boolean createIndexesSelected = this.isDropRecreateIndexesBeforeSet() || this.isDropRecreateIndexesAfterSet();
        ArrayList matchColumnList = new ArrayList();
        ArrayList unmappedColumnList = new ArrayList();
        codeSegment.addSourceCode("%if (&etls_tableExist eq 0) ").addSourceCode("%then \n").addSourceCode("%do;  ").indent();
        target.getDBMSType().create(codeSegment, target, false, false, false, true, additionalTableOptions, this);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLECREATED", this, target);
        codeSegment.unIndent().addSourceCode("%end;  /* if table does not exist */\n\n");
        boolean hasIndexes = false;
        if (target.getIndexesList().size() > 0) {
            hasIndexes = true;
        }
        boolean bl = indexesCanBeDropped = append || update || truncate;
        if (hasIndexes && indexesCanBeDropped && createIndexesSelected) {
            codeSegment.addSourceCode("%if (&etls_tableExist gt 0) ").addSourceCode("%then \n").addSourceCode("%do;  \n").indent();
            target.getDBMSType().dropIndexes(codeSegment, target, null);
            codeSegment.unIndent().addSourceCode("%end;  /* if table did exist */\n\n");
        }
        if (refresh) {
            codeSegment.addSourceCode("%if (&etls_tableExist gt 0) ").addSourceCode("%then \n").addSourceCode("%do;  \n").indent();
            if (truncate) {
                ((SASSPDSType)target.getDBMSType()).loadWithTruncate(codeSegment, target, matchColumnList, false, unmappedColumnList, additionalTableOptions, inParallel, parallelgroup, this.isDropRecreateIndexesBeforeSet(), this.isDropRecreateIndexesAfterSet(), target.getIndexesList());
                target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLETRUNCATED", this, target);
            } else if (remove) {
                ((SASSPDSType)target.getDBMSType()).removeAllRows(codeSegment, target, additionalTableOptions);
            } else if (drop) {
                target.getDBMSType().drop(codeSegment, target, false);
                target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLEDROPPED", this, target);
                target.getDBMSType().create(codeSegment, target, false, false, false, true, additionalTableOptions, this);
                target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLECREATED", this, target);
            }
            codeSegment.unIndent().addSourceCode("%end;  \n\n");
        }
        if (!createIndexesSelected && hasIndexes) {
            codeSegment.addSourceCode("%if (&etls_tableExist eq 0) ").addSourceCode("%then \n").addSourceCode("%do;  ").indent();
            ((SASSPDSType)target.getDBMSType()).createIndexes(codeSegment, inParallel, parallelgroup, target.getIndexesList(), createIndexesSelected, target);
            codeSegment.unIndent().addSourceCode("%end;  /* if table does not exist */\n\n");
        }
        if (this.isDropRecreateIndexesBeforeSet()) {
            ((SASSPDSType)target.getDBMSType()).createIndexes(codeSegment, inParallel, parallelgroup, target.getIndexesList(), createIndexesSelected, target);
        }
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateBefore(target);
        }
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
        String mappingStepOutputName = "";
        if (isMappingNeeded) {
            String altLibRef = this.getAltLibRef();
            mappingStepOutputName = altLibRef.length() > 0 ? altLibRef + "." + codeSegment.getUniqueWorkTableName(false, 0) : codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, source, target, mappingStepOutputName, "&etls_lastTable", dsOptions.length() > 0 ? "&etls_tableOptions" : "", null, true, true, false, columnsToExcludeFromMapping.toArray(new IColumn[columnsToExcludeFromMapping.size()]), null, false, null, null, null);
            codeSegment.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            codeSegment.addSourceCode("%let etls_tableOptions = ; \n\n");
        }
        if (update) {
            ((SASSPDSType)target.getDBMSType()).loadWithUpsert(codeSegment, target, false, additionalTableOptions, targetOptions);
            target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, target);
        } else {
            this.append(codeSegment, target, false, additionalTableOptions);
            target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, target);
        }
        if (this.isDropRecreateIndexesAfterSet()) {
            ((SASSPDSType)target.getDBMSType()).createIndexes(codeSegment, inParallel, parallelgroup, target.getIndexesList(), createIndexesSelected, target);
        }
        if (isMappingNeeded && !target.isView()) {
            codeSegment.genTableDelete(mappingStepOutputName);
        }
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateAfter(target);
        }
        codeSegment.unIndent().addSourceCode("%mend etls_loader;\n").addSourceCode("%etls_loader;\n\n");
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, target);
        return codeSegment;
    }

    private String getAltLibRef() {
        ILibrary altLib = this.getJob().getAlternateTemporaryLibrary();
        if (altLib != null) {
            return altLib.getLibref();
        }
        return "";
    }

    public List genLoadTimeCode(ICodeSegment codeSegment, IPhysicalTable target) throws CodegenException {
        IColumn loadTimeColumn = null;
        try {
            loadTimeColumn = (IColumn)this.getOptionModel().getOptionValue("LoadTime");
        }
        catch (Exception exc) {
            throw new CodegenException(exc.getLocalizedMessage(), (IObject)this);
        }
        ArrayList<IColumn> columnsToExcludeFromMapping = new ArrayList<IColumn>();
        if (loadTimeColumn != null) {
            columnsToExcludeFromMapping.add(loadTimeColumn);
            codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.SetLoadTime.msg.notrans"));
            String dsname = codeSegment.getUniqueWorkTableName();
            codeSegment.genTableDelete(dsname).addSourceCode("data work.").addSourceCode(dsname).addSourceCode(" / view=work.").addSourceCode(dsname).addSourceCode(";\n").indent().addSourceCode("set ");
            codeSegment.addSourceCode("&SYSLAST (&etls_tableOptions)");
            codeSegment.addSourceCode(";\n");
            String dtFormat = "nldatm.";
            String loadColName = loadTimeColumn.getColumnName(codeSegment.isQuoting());
            codeSegment.addSourceCode("\n").addSourceCode(loadColName).addSourceCode(" = input(\"&SYSDATE9 &SYSTIME\",DATETIME20.);\n\n").addSourceCode("if _n_ eq 1 then \n").indent().addSourceCode("put 'NOTE: ").addSourceCode(RB.getStringResource("TableLoaderTransformModel.LoadtimeNote.msg.notrans")).addSourceCode(" ' ").addSourceCode(loadColName).addSourceCode(" ").addSourceCode(dtFormat).addSourceCode(";\n").unIndent();
            codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").addSourceCode("%let SYSLAST = work.").addSourceCode(dsname).addSourceCode(";\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
            String dsOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
            if (dsOptions.length() > 0) {
                codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
            } else {
                codeSegment.addSourceCode("\n");
            }
        }
        return columnsToExcludeFromMapping;
    }

    public void loadMacroValues(ICodeSegment codeSegment) throws MdException, RemoteException, ServiceException, SAXException, ServerConnectionException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, IOException, ParserConfigurationException, FileNotFoundException, MdException, ServerException {
        codeSegment.addCommentLine(RB.getStringResource("SPDSTableLoaderTransformModel.MacroOptions.comment.notrans")).addSourceCode("\n");
        codeSegment.addSourceCode(this.getSPDSMacroOptionModel().getOptionsString(codeSegment, "OPTION", true, false, true, false));
    }

    public ICodeSegment loadWithUpsert(ICodeSegment codeSegment, IPhysicalTable table, List matchColumnList, boolean unmappedEqMissingInUpdate, List unmappedColumnList) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return table.getDBMSType().loadWithUpsert(codeSegment, table, matchColumnList, unmappedEqMissingInUpdate, unmappedColumnList, this.getDataTableOptions(), this);
    }

    protected class cSPDSLoaderOptionModel
    extends BaseLoaderPromptModel
    implements IPromptModel {
        public cSPDSLoaderOptionModel(IModel model, ILoaderTransform owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
            this.setSaveValuesAsStrings(true);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cSPDSLoaderOptionModel.class.getResource("res/Options_SPDSTableLoader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected IModelListener createModelListener() {
            return new cLoaderStandardModelListener((SPDSTableLoaderTransformModel)this.getOwner());
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            SPDSTableLoaderTransformModel tl = (SPDSTableLoaderTransformModel)this.getOwner();
            this.setOptionValue(SPDSTableLoaderTransformModel.DATATABLE_OPTIONS, (Object)tl.getDataTableOptions());
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new LoaderTransformStandardValueChangedListener((SPDSTableLoaderTransformModel)this.getOwner(), this);
        }

        private class LoaderTransformStandardValueChangedListener
        extends BaseLoaderTransformValueChangedListener {
            public LoaderTransformStandardValueChangedListener(SPDSTableLoaderTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(SPDSTableLoaderTransformModel.DATATABLE_OPTIONS)) {
                        SPDSTableLoaderTransformModel.this.setDataTableOptions(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class cLoaderStandardModelListener
        extends BaseLoaderModelListener {
            public cLoaderStandardModelListener(SPDSTableLoaderTransformModel transform) {
                super(transform, (IPromptModel)cSPDSLoaderOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(SPDSTableLoaderTransformModel.DATA_TABLE_OPTIONS_CHANGED)) {
                        cSPDSLoaderOptionModel.this.setOptionValue(SPDSTableLoaderTransformModel.DATATABLE_OPTIONS, (Object)SPDSTableLoaderTransformModel.this.getDataTableOptions());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                    cSPDSLoaderOptionModel.this.setChanged(true);
                }
            }
        }
    }

    private class SetGroupingLimitUndoable
    extends AbstractUndoableEdit {
        private int m_oldGroupingLimit;
        private int m_newGroupingLimit;

        public SetGroupingLimitUndoable(int oldGroupingLimit, int newGroupingLimit) {
            this.m_oldGroupingLimit = oldGroupingLimit;
            this.m_newGroupingLimit = newGroupingLimit;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setGroupingLimit(this.m_oldGroupingLimit);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setGroupingLimit(this.m_newGroupingLimit);
        }
    }

    private class SetParallelIndexCreationUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldParallelIndexCreation;
        private boolean m_newParallelIndexCreation;

        public SetParallelIndexCreationUndoable(boolean oldParallelIndexCreation, boolean newParallelIndexCreation) {
            this.m_oldParallelIndexCreation = oldParallelIndexCreation;
            this.m_newParallelIndexCreation = newParallelIndexCreation;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setParallelIndexCreation(this.m_oldParallelIndexCreation);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setParallelIndexCreation(this.m_newParallelIndexCreation);
        }
    }

    private class SetDropRecreateIndexesBeforeUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDropRecreateIndexes;
        private boolean m_newDropRecreateIndexes;

        public SetDropRecreateIndexesBeforeUndoable(boolean oldDropRecreateIndexes, boolean newDropRecreateIndexes) {
            this.m_oldDropRecreateIndexes = oldDropRecreateIndexes;
            this.m_newDropRecreateIndexes = newDropRecreateIndexes;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setDropRecreateIndexesBefore(this.m_oldDropRecreateIndexes);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setDropRecreateIndexesBefore(this.m_newDropRecreateIndexes);
        }
    }

    private class SetDropRecreateIndexesAfterUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDropRecreateIndexes;
        private boolean m_newDropRecreateIndexes;

        public SetDropRecreateIndexesAfterUndoable(boolean oldDropRecreateIndexes, boolean newDropRecreateIndexes) {
            this.m_oldDropRecreateIndexes = oldDropRecreateIndexes;
            this.m_newDropRecreateIndexes = newDropRecreateIndexes;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setDropRecreateIndexesAfter(this.m_oldDropRecreateIndexes);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setDropRecreateIndexesAfter(this.m_newDropRecreateIndexes);
        }
    }

    private class SetRefreshTypeUndoable
    extends AbstractUndoableEdit {
        private int m_oldiRefreshType;
        private int m_newiRefreshType;

        public SetRefreshTypeUndoable(int oldType, int newType) {
            this.m_oldiRefreshType = oldType;
            this.m_newiRefreshType = newType;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setRefreshType(this.m_oldiRefreshType);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setRefreshType(this.m_newiRefreshType);
        }
    }

    private class SetLoadTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldsLoadType;
        private String m_newsLoadType;

        public SetLoadTypeUndoable(String oldsType, String newsType) {
            this.m_oldsLoadType = oldsType;
            this.m_newsLoadType = newsType;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setLoadType(this.m_oldsLoadType);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setLoadType(this.m_newsLoadType);
        }
    }

    private class SetDataTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldsTableOptions;
        private String m_newsTableOptions;

        public SetDataTableOptionsUndoable(String oldsTableOptions, String newsTableOptions) {
            this.m_oldsTableOptions = oldsTableOptions;
            this.m_newsTableOptions = newsTableOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SPDSTableLoaderTransformModel.this.setDataTableOptions(this.m_oldsTableOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SPDSTableLoaderTransformModel.this.setDataTableOptions(this.m_newsTableOptions);
        }
    }
}

