/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPasteModify;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.CopyPasteDependentItem;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICopyPasteAdvanced;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.etl.models.job.transforms.splitter.IRowSelectorTransform;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.SASCodeGeneration;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LibraryContentsTransformModel
extends AbstractDataTransform
implements IRowSelectorTransform,
ICopyPasteAdvanced {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.contentreaders.SASLibraryContents";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.transforms.contentreaders.SASLibraryContents";
    private static final String ARM_DISPLAY_NAME = "LibraryContents";
    private ModelList m_lRowSels = new cRowSelectorList(this, new String[]{"RowSelector:RowSelectorAdded", "RowSelector:RowSelectorRemoved"}, 3, IRowSelector.class);
    public static final String ROW_SELECTOR_CHANGED = "LibraryContents:RowSelectorChanged";
    private IWorkTable m_srcTable;
    private static final String REMOTE_MACRO = "etls_remoteMacro";

    public LibraryContentsTransformModel(String sID, IModel model) {
        super(sID, model);
        IRowSelector rowSel = this.getModel().getObjectFactory().createNewRowSelector(this.getID());
        rowSel.setClassifierMapID(this.getClassifierMapId());
        this.m_lRowSels.add(rowSel);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.m_srcTable != null) {
            this.m_srcTable.deleteFromOMR(omr);
        }
        this.m_lRowSels.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null) {
            rowSelector.updateIDs(mapIDs);
            rowSelector.setClassifierMapID(this.getClassifierMapId());
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent me;
        IRowSelector rowSelector = this.getRowSelector();
        if (ev.getSource() == rowSelector) {
            this.fireModelChangedEvent(ROW_SELECTOR_CHANGED, null);
        }
        if ((me = ev.getModelEvent()) != null && this.getDataSourcesCount() > 0 && "PhysicalTable:LibraryChanged".equals(me.getType()) && me.getModelObject() == this.getSourceTables()[0]) {
            this.fireModelChangedEvent(me.getData() != null ? "DataTransform.DataSourceAdded" : "DataTransform.DataSourceRemoved", me.getData(), new Integer(1));
        }
        super.notify(ev);
    }

    @Override
    public ITable[] getSourceTables() {
        if (this.m_srcTable != null) {
            return new ITable[]{this.m_srcTable};
        }
        return new ITable[0];
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
        if (source instanceof ILibrary && !((ILibrary)source).isClientLibrary() && !this.containsInDataSources(source)) {
            this.setInputLibrary((ILibrary)source);
            super.addDataSource(iSource, source);
        } else if (source instanceof IWorkTable) {
            this.m_srcTable = (IWorkTable)source;
            ILibrary lib = this.m_srcTable.getLibrary();
            if (lib != null && !this.containsInDataSources(lib)) {
                this.addDataSource(iSource, lib);
            }
        }
    }

    @Override
    public void removeDataSource(IDataObject source) {
        if (source instanceof ILibrary && this.containsInDataSources(source)) {
            this.setInputLibrary(null);
            super.removeDataSource(source);
        }
        if (source instanceof IWorkTable) {
            this.m_srcTable = (IWorkTable)source;
            ILibrary lib = this.m_srcTable.getLibrary();
            if (lib != null && this.containsInDataSources(lib)) {
                this.removeDataSource(lib);
            }
        }
    }

    @Override
    public void addDefaultSettings() {
        this.startCompoundUndoable();
        try {
            IWorkTable target = this.addNewWorkTable();
            IWorkTable source = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            source.setView(true);
            source.setName("Dictionary Table");
            source.setSASTableName("dictionary.tables");
            this.setDefaultColumnsOnTables(source);
            this.m_srcTable = source;
            this.addDataSource(source);
            this.mapColumns(source, target);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable table = super.addNewWorkTable();
            table.setView(true);
            this.setDefaultColumnsOnTables(table);
            this.mapColumns();
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setDefaultColumnsOnTables(ITable table) {
        this.createColumn(table, "libname", 8, 0);
        this.createColumn(table, "memname", 32, 0);
        this.createColumn(table, "memtype", 8, 0);
        this.createColumn(table, "dbms_memtype", 32, 0);
        this.createColumn(table, "memlabel", 256, 0);
        this.createColumn(table, "typemem", 8, 0);
        this.createColumn(table, "crdate", 8, 1, "DATETIME.", "DATETIME.");
        this.createColumn(table, "modate", 8, 1, "DATETIME.", "DATETIME.");
        this.createColumn(table, "nobs", 8, 1);
        this.createColumn(table, "obslen", 8, 1);
        this.createColumn(table, "nvar", 8, 1);
        this.createColumn(table, "protect", 3, 0);
        this.createColumn(table, "compress", 8, 0);
        this.createColumn(table, "encrypt", 8, 0);
        this.createColumn(table, "npage", 8, 1);
        this.createColumn(table, "filesize", 8, 1);
        this.createColumn(table, "pcompress", 8, 1);
        this.createColumn(table, "reuse", 3, 0);
        this.createColumn(table, "bufsize", 8, 1);
        this.createColumn(table, "delobs", 8, 1);
        this.createColumn(table, "nlobs", 8, 1);
        this.createColumn(table, "maxvar", 8, 1);
        this.createColumn(table, "maxlabel", 8, 1);
        this.createColumn(table, "maxgen", 8, 1);
        this.createColumn(table, "gen", 8, 1);
        this.createColumn(table, "attr", 3, 0);
        this.createColumn(table, "indxtype", 9, 0);
        this.createColumn(table, "datarep", 32, 0);
        this.createColumn(table, "sortname", 8, 0);
        this.createColumn(table, "sorttype", 4, 0);
        this.createColumn(table, "sortchar", 8, 0);
        this.createColumn(table, "reqvector", 24, 0, "$HEX48.", "$HEX48.");
        this.createColumn(table, "datarepname", 170, 0);
        this.createColumn(table, "encoding", 256, 0);
        this.createColumn(table, "audit", 3, 0);
        this.createColumn(table, "audit_before", 3, 0);
        this.createColumn(table, "audit_admin", 3, 0);
        this.createColumn(table, "audit_error", 3, 0);
        this.createColumn(table, "audit_data", 3, 0);
    }

    protected IColumn createColumn(ITable table, String name, int length, int type) {
        return this.createColumn(table, name, length, type, "", "");
    }

    protected IColumn createColumn(ITable table, String name, int length, int type, String format, String informat) {
        IColumn column = this.getModel().getObjectFactory().createNewColumn(this.getID());
        column.setName(name);
        column.setLength(length);
        column.setType(type);
        column.setFormat(format);
        column.setInformat(informat);
        column.setDescription(RB.getStringResource("LibraryContentsTransformModel.Column." + name + ".desc.txt"));
        table.addColumn(column);
        return column;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("LibraryContentsTranformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("LibraryContentsTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.transforms.contentreaders.SASLibraryContents";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.transforms.contentreaders.SASLibraryContents";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.transforms.contentreaders.SASLibraryContents";
    }

    @Override
    public boolean isIncludedInPropagation() {
        return false;
    }

    public IRowSelector getRowSelector() {
        if (!this.m_lRowSels.isEmpty()) {
            return (IRowSelector)this.m_lRowSels.get(0);
        }
        return null;
    }

    @Override
    public List getRowSelectorList() {
        return this.m_lRowSels;
    }

    @Override
    public IRowSelector[] getRowSelectorObjects() {
        return (IRowSelector[])this.m_lRowSels.toArray(new IRowSelector[this.m_lRowSels.size()]);
    }

    @Override
    public IDataObject[] getDataSources() {
        ArrayList<ILibrary> dsList = new ArrayList<ILibrary>();
        ILibrary lib = this.getInputLibrary();
        if (lib != null) {
            dsList.add(lib);
        }
        return dsList.toArray(new IDataObject[dsList.size()]);
    }

    public IPhysicalTable getSourceTable() {
        return this.m_srcTable;
    }

    public ILibrary getInputLibrary() {
        IPhysicalTable srcTable = this.getSourceTable();
        if (srcTable != null) {
            return srcTable.getLibrary();
        }
        return null;
    }

    protected void setInputLibrary(ILibrary library) {
        IPhysicalTable srcTable = this.getSourceTable();
        if (srcTable != null) {
            srcTable.setLibrary(library);
        }
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        ILibrary library = this.getSourceTable().getCodeGenLibrary(defaultServer);
        if (library != null) {
            return library.getBestServer(defaultServer);
        }
        return defaultServer;
    }

    protected boolean isLibraryRemoteFromStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        ILibrary library = this.getInputLibrary();
        if (library != null) {
            return !ObjectComparator.isEqual(defaultServer, library.getClientLibrary(defaultServer).getBestServer(defaultServer));
        }
        return false;
    }

    @Override
    public ICodeSegment getGeneratedRemoteCodeStart(IServer stepServer, ICodeSegment codeSegment, IServer currentServer, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        IPhysicalTable target = (IPhysicalTable)this.getTargetTables()[0];
        IPhysicalTable source = (IPhysicalTable)this.getSourceTables()[0];
        if (this.isLibraryRemoteFromStep(environment.getDefaultServer())) {
            String tableOptions;
            boolean bTargetOnDefaultServer;
            boolean bTargetOnSameServer = target.isTableOnSameServer(source, environment.getDefaultServer());
            boolean bl = bTargetOnDefaultServer = target.getServer(environment.getDefaultServer()) == environment.getDefaultServer();
            if (!bTargetOnSameServer && bTargetOnDefaultServer) {
                target.genTableDelete(codeSegment);
            }
            ILibrary library = this.getInputLibrary();
            IServer server = library.getClientLibrary(codeSegment.getCurrentServer()).getBestServer(stepServer);
            ISASClientConnection conn = stepServer.getConnectClient();
            if (conn == null) {
                throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), stepServer.getName()), (IObject)this);
            }
            if (!environment.isOnSignonCache(stepServer)) {
                conn.genAccessCode(codeSegment);
                environment.addToSignonCache(stepServer);
            }
            codeSegment.genReturnCodeRemoteSetup(conn, codeSegment.getRuntimeStatsConnectMacros(codeSegment), isValidate);
            codeSegment.genRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), conn.getHostName(), true).addSourceCode("\n");
            conn.genStartSubmit("sysrputsync = yes", codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
            environment.setCurrentServer(server);
            codeSegment.indent().addSourceCode("\n");
            if (codeSegment.isQuoting()) {
                codeSegment.genValidvarnameOptionAny(false);
            }
            codeSegment.addSourceCode("%macro ").addSourceCode("etls_transformationStep").addSourceCode("(); \n").indent();
            String tableName = bTargetOnSameServer ? target.getFullNameQuotedAsNeeded(codeSegment) : target.getWorkTableName(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            String string = tableOptions = bTargetOnSameServer ? this.getTableOptionObject(target, false).getTableOptions(codeSegment.getCurrentServer()) : "";
            if (bTargetOnSameServer) {
                target.genAccessPath(codeSegment, null);
            }
            this.getLibraryQuery(codeSegment, tableName, tableOptions);
            if (!bTargetOnSameServer && !bTargetOnDefaultServer) {
                IServer targetServer = target.getServer(server);
                ISASClientConnection targetConnection = targetServer.getConnectClient();
                if (targetConnection == null) {
                    throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), targetServer.getName()), (IObject)this);
                }
                if (!environment.isOnSignonCache(targetServer)) {
                    targetConnection.genAccessCode(codeSegment);
                    environment.addToSignonCache(targetServer);
                }
                codeSegment.genReturnCodeRemoteSetup(targetConnection, codeSegment.getRuntimeStatsConnectMacros(codeSegment), false);
                codeSegment.genRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), targetConnection.getHostName(), true).addSourceCode("\n");
                targetConnection.genStartSubmit("sysrputsync = yes", codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
                environment.setCurrentServer(targetServer);
                codeSegment.indent().addSourceCode("\n");
                if (codeSegment.isQuoting()) {
                    codeSegment.genValidvarnameOptionAny(false);
                }
                codeSegment.addSourceCode("%macro ").addSourceCode("etls_transformationStep").addSourceCode("(); \n").indent();
                target.genAccessPath(codeSegment, null);
                target.genTableDelete(codeSegment);
                codeSegment.addSourceCode("proc upload data = " + target.getWorkTableName(codeSegment.getCurrentServer(), codeSegment.isQuoting()) + " \n").addSourceCode("     out = " + target.getFullNameQuotedAsNeeded(codeSegment));
                String targetOptions = this.getTableOptionObject(target, false).getTableOptions(codeSegment.getCurrentServer());
                if (targetOptions != null && targetOptions.length() > 0) {
                    codeSegment.addSourceCode(" ").addSourceCode(targetOptions);
                }
                codeSegment.addSourceCode(";\n");
                codeSegment.addSourceCode("run;\n");
                codeSegment.genRCSetCall("&syserr");
                codeSegment.genReturnCodeRemoteEnding(false);
                codeSegment.unIndent();
                codeSegment.addSourceCode("\n%mend ").addSourceCode("etls_transformationStep").addSourceCode("; \n\n").addSourceCode("%").addSourceCode("etls_transformationStep").addSourceCode(";\n\n");
                codeSegment.unIndent();
                targetConnection.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
                environment.setCurrentServer(server);
            } else if (!bTargetOnSameServer && bTargetOnDefaultServer) {
                codeSegment.addSourceCode("proc download data = " + target.getWorkTableName(codeSegment.getCurrentServer(), codeSegment.isQuoting()) + " \n").addSourceCode("     out = " + target.getFullNameQuotedAsNeeded(codeSegment));
                String targetOptions = this.getTableOptionObject(target, false).getTableOptions(codeSegment.getCurrentServer());
                if (targetOptions != null && targetOptions.length() > 0) {
                    codeSegment.addSourceCode(" ").addSourceCode(targetOptions);
                }
                codeSegment.addSourceCode(";\n");
                codeSegment.addSourceCode("run;\n");
                codeSegment.genRCSetCall("&syserr");
            }
            codeSegment.genReturnCodeRemoteEnding(false);
            codeSegment.unIndent();
            codeSegment.addSourceCode("\n%mend ").addSourceCode("etls_transformationStep").addSourceCode("; \n\n").addSourceCode("%").addSourceCode("etls_transformationStep").addSourceCode(";\n\n");
            codeSegment.unIndent();
            conn.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
            environment.setCurrentServer(environment.getDefaultServer());
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getGeneratedRemoteCodeEnd(IServer stepServer, ICodeSegment codeSegment, IServer currentServer, boolean isValidate) throws CodegenException, BadServerDefinitionException, BadLibraryDefinitionException {
        return codeSegment;
    }

    protected ICodeSegment getLibraryQuery(ICodeSegment codeSegment, String targetName, String targetOptions) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPhysicalTable target;
        String strExpression;
        ITextExpression expression;
        IRowSelector rowSelector;
        super.getGeneratedCode(codeSegment);
        IPhysicalTable sourceTable = (IPhysicalTable)this.getSourceTables()[0];
        ILibrary sasLib = sourceTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        String whereClause = "";
        if (sasLib != null) {
            sasLib.genAccessPath(codeSegment);
            String libref = sasLib.getLibref().toUpperCase();
            whereClause = "where libname = \"" + libref + "\"";
        }
        if ((rowSelector = this.getRowSelector()) != null && (expression = rowSelector.getExpression()) != null && (strExpression = expression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting())).length() > 0 && strExpression.length() > 0) {
            whereClause = whereClause.length() == 0 ? "where " + strExpression : whereClause + " and " + strExpression;
        }
        if ((target = (IPhysicalTable)this.getTargetTables()[0]).getLibrary() != null && sourceTable.isTableOnSameServer(target, codeSegment.getCurrentServer())) {
            target.genAccessPath(codeSegment, null);
        }
        this.getOrdinaryMappingCode(codeSegment, sourceTable, target, targetName, "dictionary.tables", null, targetOptions, target.isView(), true, true, null, null, false, whereClause, null, null);
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (!this.isLibraryRemoteFromStep(codeSegment.getDefaultServer())) {
            IPhysicalTable target = (IPhysicalTable)this.getTargetTables()[0];
            IPhysicalTable source = (IPhysicalTable)this.getSourceTables()[0];
            String targetName = target.getFullNameQuotedAsNeeded(codeSegment);
            String targetOptions = this.getTableOptionObject(target, false).getTableOptions(codeSegment.getCurrentServer());
            boolean stSameServer = target.isTableOnSameServer(source, codeSegment.getCurrentServer());
            if (!stSameServer) {
                targetName = target.getWorkTableName(codeSegment.getCurrentServer(), codeSegment.isQuoting());
                targetOptions = "";
            }
            this.getLibraryQuery(codeSegment, targetName, targetOptions);
            if (!stSameServer) {
                ILibrary lib = target.getClientLibrary(codeSegment);
                IServer targetServer = lib.getBestServer(codeSegment.getCurrentServer());
                if (codeSegment.isQuoting()) {
                    codeSegment.genValidvarnameOptionAny(false);
                }
                lib.genAccessPath(codeSegment);
                ISASClientConnection connection = targetServer.getConnectClient();
                if (connection != null) {
                    ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
                    boolean alreadySignedOn = environment.isOnSignonCache(codeSegment.getCurrentServer());
                    codeSegment.genReturnCodeRemoteSetup(connection, codeSegment.getRuntimeStatsConnectMacros(codeSegment), false);
                    codeSegment.genRemoteMacroVariablesSetup(connection.getHostName()).addSourceCode("\n");
                    connection.genStartSubmit(SASCodeGeneration.SYSRPUTSYNC_YES, codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
                    codeSegment.addSourceCode("%macro ").addSourceCode(REMOTE_MACRO).addSourceCode("; \n").indent();
                    if (!alreadySignedOn) {
                        codeSegment.genSystemOptions(this.getSystemOptions());
                    }
                    if (codeSegment.isQuoting()) {
                        codeSegment.genValidvarnameOptionAny(false);
                    }
                    target.genTableDelete(codeSegment);
                    String tOptions = this.getTableOptionObject(target, false).getTableOptions(codeSegment.getCurrentServer());
                    codeSegment.addSourceCode("proc upload data = " + targetName + " \n").addSourceCode("     out = " + target.getFullNameQuotedAsNeeded(codeSegment));
                    if (tOptions != null && tOptions.length() > 0) {
                        codeSegment.addSourceCode(" ").addSourceCode(tOptions);
                    }
                    codeSegment.addSourceCode(";\n");
                    codeSegment.addSourceCode("run;\n");
                    codeSegment.genRCSetCall("&syserr");
                    codeSegment.genReturnCodeRemoteEnding(false);
                    codeSegment.unIndent();
                    codeSegment.addSourceCode("%mend ").addSourceCode(REMOTE_MACRO).addSourceCode("; \n").addSourceCode("%").addSourceCode(REMOTE_MACRO).addSourceCode("; \n\n").unIndent();
                    connection.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
                } else {
                    throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), targetServer.getName()), (IObject)this);
                }
            }
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForTargets(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return codeSegment;
    }

    @Override
    public void delete() {
        if (this.m_srcTable != null) {
            this.m_srcTable.delete();
        }
        this.m_lRowSels.delete();
        super.delete();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        AssociationList rows = mdoCM.getAssociatedRowSelectors();
        if (!rows.isEmpty()) {
            this.m_lRowSels.loadFromOMR(omr, (List)rows);
        }
        this.setChanged(false);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.m_lRowSels.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        lReasons.addAll(this.m_lRowSels.getReasonsIncomplete());
        return lReasons;
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        if (this.m_srcTable != null) {
            this.m_srcTable.saveToOMR(omr);
            AssociationList sources = mdoCM.getClassifierSources(false);
            sources.clear();
            sources.add(omr.acquireOMRObject(this.m_srcTable));
        }
        this.m_lRowSels.saveToOMR(omr, (List)mdoCM.getAssociatedRowSelectors(false));
        this.setChanged(false);
    }

    public void setRowSelector(IRowSelector newRowSelector) {
        if (newRowSelector == null) {
            throw new IllegalArgumentException("row selector cannot be null");
        }
        IRowSelector rowSel = this.getRowSelector();
        if (rowSel == newRowSelector) {
            return;
        }
        this.m_lRowSels.clear();
        this.m_lRowSels.add(newRowSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            IRowSelector rowSelector = this.getRowSelector();
            if (rowSelector.getExpression() != null) {
                rowSelector.getExpression().replaceTableColumns(oldTable, newTable);
            }
            super.replaceTargetTable(oldTable, newTable, columnsMap);
            this.getRowSelector().setTable(newTable);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDataTarget(IDataObject target) {
        super.addDataTarget(target);
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null) {
            rowSelector.setTable((ITable)target);
            if (rowSelector.getExpression() != null) {
                rowSelector.getExpression().replaceTableColumns(null, (ITable)target);
            }
        }
    }

    @Override
    public void removeDataTarget(IDataObject target) {
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null) {
            rowSelector.setTable(null);
        }
        super.removeDataTarget(target);
    }

    @Override
    public List<CopyPasteDependentItem> getAdditionalCopyObjects() {
        return this.m_srcTable != null ? Arrays.asList(new CopyPasteDependentItem(this.m_srcTable, true, false)) : null;
    }

    @Override
    public List<IObject> pasteAction() throws MdException, RemoteException {
        super.pasteAction();
        if (this.m_srcTable != null) {
            this.m_srcTable.setView(true);
            this.m_srcTable.setName("Dictionary Table");
            this.m_srcTable.setSASTableName("dictionary.tables");
        }
        return new ArrayList<IObject>();
    }

    @Override
    public List<IPasteModify> getPasteChildObjects() {
        return this.m_srcTable != null ? Arrays.asList(this.m_srcTable) : null;
    }

    @Override
    public List<IObject> getDependentObjects() {
        return null;
    }

    private class cRowSelectorList
    extends ModelList {
        public cRowSelectorList(AbstractPersistableObject owner, String[] aEventIDs, int ePersistenceType, Class clsAllowedType) {
            super(owner, aEventIDs, ePersistenceType, clsAllowedType);
        }

        @Override
        protected void addImpl(int iObj, Object obj) {
            super.addImpl(iObj, obj);
            IRowSelector rowSel = (IRowSelector)obj;
            rowSel.setClassifierMapID(LibraryContentsTransformModel.this.getClassifierMapId());
            rowSel.addNotifyListener(LibraryContentsTransformModel.this);
            if (LibraryContentsTransformModel.this.getTargetTables().length > 0) {
                rowSel.setTable(LibraryContentsTransformModel.this.getTargetTables()[0]);
            }
        }

        @Override
        protected Object removeImpl(int iObject) {
            IRowSelector rowSel = (IRowSelector)this.get(iObject);
            rowSel.removeNotifyListener(LibraryContentsTransformModel.this);
            return super.removeImpl(iObject);
        }
    }
}

