/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FileWriterTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.FileWriter";
    private static final String TRANSFORMATION_ROLE = "FileWriter:HIDE";
    private static final String ARM_DISPLAY_NAME = "FileWriter";
    public static final String ADDITIONAL_FILE_OPTIONS_CHANGED = "FileWriterTransformModel:AdditionalFileOptionsChanged";
    private static final String PROPERTYNAME_ADDITIONAL_FILE_OPTIONS = "FileOptions";
    private static final String PROPERTY_NAME_ADDITIONAL_FILE_OPTIONS = "Additional File Options";
    private static final String PROMPT_NAME_ADDITIONAL_FILE_OPTIONS = "etls_fileOptions";
    private static final String DEFAULT_ADDITIONAL_FILE_OPTIONS = "";
    private String m_sAdditionalFileOptions = "";

    public FileWriterTransformModel(String sID, IModel model) {
        super(sID, model);
        this.createConditionActionSetTemplates();
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("FileWriterTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("FileWriterTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    public String getAdditionalFileOptions() {
        return this.m_sAdditionalFileOptions;
    }

    public void setAdditionalFileOptions(String sOptions) {
        if (sOptions == null) {
            throw new IllegalArgumentException("null is not allowed for additional file options");
        }
        if (this.m_sAdditionalFileOptions.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAdditionalFileOptionsUndoable(this.m_sAdditionalFileOptions, sOptions));
        }
        this.m_sAdditionalFileOptions = sOptions;
        this.fireModelChangedEvent(ADDITIONAL_FILE_OPTIONS_CHANGED, this.m_sAdditionalFileOptions);
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("File writer does not support work tables");
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        if (this.getDataTargets().length == 0) {
            return null;
        }
        IExternalTable targetTable = (IExternalTable)this.getDataTargets()[0];
        IServer server = targetTable.getServer();
        if (server == null) {
            server = defaultServer;
        }
        return server;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IExternalTable targetTable = (IExternalTable)this.getDataTargets()[0];
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        boolean mappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, targetTable, null, true);
        String mappingStepOutputName = DEFAULT_ADDITIONAL_FILE_OPTIONS;
        if (mappingNeeded) {
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, source, targetTable, mappingStepOutputName, "&SYSLAST", DEFAULT_ADDITIONAL_FILE_OPTIONS, DEFAULT_ADDITIONAL_FILE_OPTIONS, true, true, true, null, null, false, null, null, null);
        }
        codeSegment.addSourceCode(targetTable.getDataStepCodeToCreateFile(codeSegment.getCodeGenerationEnvironment(), "&SYSLAST", this.getTableOptionObject(source, true).getTableOptions(codeSegment.getCurrentServer()), this.getAdditionalFileOptions()));
        codeSegment.genRCSetCall("&syserr");
        if (mappingNeeded && !targetTable.isView()) {
            codeSegment.genTableDelete(mappingStepOutputName);
        }
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, null);
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, null);
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, null);
        return codeSegment;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        super.loadFromOMR(omr);
        this.setAdditionalFileOptions(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTYNAME_ADDITIONAL_FILE_OPTIONS, DEFAULT_ADDITIONAL_FILE_OPTIONS, 2));
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_ADDITIONAL_FILE_OPTIONS, PROPERTYNAME_ADDITIONAL_FILE_OPTIONS, "OPTIONS", this.m_sAdditionalFileOptions, 12, 2);
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptDefinitionValue pdv;
        cFileWriterOptionModel model = new cFileWriterOptionModel();
        if (model != null && (pdv = model.getPromptDefinitionValue("FILEMACROVARS")) != null) {
            pdv.setHidden(false);
        }
        return model;
    }

    private class SetAdditionalFileOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetAdditionalFileOptionsUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            FileWriterTransformModel.this.setAdditionalFileOptions(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            FileWriterTransformModel.this.setAdditionalFileOptions(this.m_sNewOptions);
        }
    }

    protected class cFileWriterOptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public cFileWriterOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(FileWriterTransformModel.this.getModel(), FileWriterTransformModel.this);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cFileWriterOptionModel.class.getResource("res/Options_FileWriter_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            FileWriterTransformModel transform = (FileWriterTransformModel)this.getOwner();
            this.setOptionValue(FileWriterTransformModel.PROMPT_NAME_ADDITIONAL_FILE_OPTIONS, (Object)transform.getAdditionalFileOptions());
        }

        @Override
        protected IModelListener createModelListener() {
            return new cFileWriterModelChangeListener();
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new FileWriterTransformValueChangedListener((FileWriterTransformModel)this.getOwner(), this);
        }

        private class FileWriterTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public FileWriterTransformValueChangedListener(FileWriterTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = FileWriterTransformModel.DEFAULT_ADDITIONAL_FILE_OPTIONS;
                    }
                    if (optionName.equals(FileWriterTransformModel.PROMPT_NAME_ADDITIONAL_FILE_OPTIONS)) {
                        FileWriterTransformModel.this.setAdditionalFileOptions(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class cFileWriterModelChangeListener
        extends BaseDataTransformModelListener {
            public cFileWriterModelChangeListener() {
                super(cFileWriterOptionModel.this.getOwner(), cFileWriterOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(FileWriterTransformModel.ADDITIONAL_FILE_OPTIONS_CHANGED)) {
                        cFileWriterOptionModel.this.setOptionValue(FileWriterTransformModel.PROMPT_NAME_ADDITIONAL_FILE_OPTIONS, (Object)FileWriterTransformModel.this.getAdditionalFileOptions());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

