/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AppendTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.Append";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.visuals.Append";
    private static final String ARM_DISPLAY_NAME = "Append";

    public AppendTransformModel(String id, IModel model) {
        super(id, model);
        this.createConditionActionSetTemplates();
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.visuals.Append";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.visuals.Append";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.visuals.Append";
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("AppendTranformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("AppendTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        boolean createView;
        super.getGeneratedCode(codeSegment);
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        ArrayList<String> datasetNames = new ArrayList<String>();
        IDataObject[] sourceTables = this.getDataSources();
        for (int i = 0; i < sourceTables.length; ++i) {
            IPhysicalTable sourceTable = (IPhysicalTable)sourceTables[i];
            ITransformTableOptions sourceTableOptions = this.getTableOptionObject(sourceTable, true);
            String sourceTableName = sourceTable.getFullNameQuotedAsNeeded(codeSegment);
            String workTableName = "work." + codeSegment.getUniqueWorkTableName();
            codeSegment.genTableExist(sourceTableName, "dbxrc");
            sourceTable.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLEDOESNOTEXIST", this, sourceTable);
            boolean mappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable);
            if (mappingNeeded) {
                this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, workTableName, sourceTableName, sourceTableOptions.getTableOptions(codeSegment.getCurrentServer()), null, true, true, true, null, null, false, null, null, null);
                datasetNames.add(workTableName);
                continue;
            }
            if (sourceTableOptions.getTableOptions(codeSegment.getCurrentServer()).length() == 0) {
                datasetNames.add(sourceTableName);
                continue;
            }
            StringBuffer fullSourceTableName = new StringBuffer();
            fullSourceTableName.append(sourceTableName);
            fullSourceTableName.append(sourceTableOptions.getTableOptions(true, codeSegment.getCurrentServer()));
            datasetNames.add(fullSourceTableName.toString());
        }
        String targetTableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        this.genTableDelete(codeSegment, targetTable);
        codeSegment.addSourceCode("data ").addSourceCode(targetTableName);
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        if (targetOptions.getTableOptions(codeSegment.getCurrentServer()).length() > 0) {
            codeSegment.indent().addSourceCode(targetOptions.getTableOptions(true, codeSegment.getCurrentServer())).addSourceCode(" \n").unIndent();
        }
        if (createView = targetTable.isView()) {
            codeSegment.addSourceCode(" / view=").addSourceCode(targetTableName);
        }
        codeSegment.addSourceCode(";\n").indent().addSourceCode("set ");
        for (int i = 0; i < datasetNames.size(); ++i) {
            if (i > 0) {
                codeSegment.addSourceCode("\n    ");
            }
            codeSegment.addSourceCode((String)datasetNames.get(i));
        }
        codeSegment.addSourceCode(";\n");
        List<IColumn> targetTableColumns = Arrays.asList(targetTable.getColumns());
        String targetKeepList = codeSegment.makeColumnList(targetTableColumns, " ", codeSegment.isQuoting());
        if (targetKeepList.length() > 0) {
            codeSegment.addSourceCode("keep ").addSourceCode(targetKeepList.toString()).addSourceCode("; \n");
        }
        codeSegment.unIndent().addSourceCode("run;\n\n");
        codeSegment.genRCSetCall("&syserr");
        return codeSegment;
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLENOEXIST");
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.addNewWorkTable();
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable table = super.addNewWorkTable();
            table.setView(true);
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        super.replaceTargetTable(oldTable, newTable, columnsMap);
    }

    @Override
    protected boolean areExpressionsAllowed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IColumn[] propagateColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, List lExcludedColumns, boolean bForward) {
        IObjectFactory factory = this.getObjectFactory();
        IColumn[] aSource = new IColumn[1];
        IColumn[] aTarget = new IColumn[1];
        this.startCompoundUndoable();
        try {
            IColumn[] aTargetColumns = tblTarget.getColumns();
            ArrayList<IColumn> lNewTargetColumns = new ArrayList<IColumn>();
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            for (int iColumn = 0; iColumn < aSourceColumns.length; ++iColumn) {
                IMapping mapping;
                IColumn colSource = aSourceColumns[iColumn];
                if (lExcludedColumns.contains(colSource)) continue;
                IColumn colTarget = this.findNameInColumns(colSource.getName(), aTargetColumns, bCaseSensitive);
                if (colTarget != null) {
                    if (!bForward || colSource.getType() != colTarget.getType() || colSource.getLength() > colTarget.getLength() || (mapping = this.getOrdinaryMappingsForTargetColumn(colTarget)) == null || !mapping.getType().equals("ONETOONE") || mapping.containsInSources(colSource)) continue;
                    mapping.addSource(colSource);
                    continue;
                }
                colTarget = factory.createNewColumn(tblTarget.getID());
                aSourceColumns[iColumn].deepCopy(colTarget);
                tblTarget.addColumn(colTarget);
                lNewTargetColumns.add(colTarget);
                if (!bForward && (mapping = this.getOrdinaryMappingsForTargetColumn(colSource)) != null && mapping.getType().equals("ONETOONE")) {
                    mapping.addSource(colTarget);
                    continue;
                }
                aSource[0] = colSource;
                aTarget[0] = colTarget;
                if (bForward) {
                    this.addMapping(aSource, aTarget, "ONETOONE", null);
                    continue;
                }
                this.addMapping(aTarget, aSource, "ONETOONE", null);
            }
            IColumn[] iColumnArray = lNewTargetColumns.toArray(new IColumn[lNewTargetColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private IColumn findNameInColumns(String sName, IColumn[] aColumns, boolean bCaseSensitive) {
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            boolean bEquals;
            String sColumnName = aColumns[iColumn].getName();
            boolean bl = bEquals = bCaseSensitive ? sColumnName.equals(sName) : sColumnName.equalsIgnoreCase(sName);
            if (!bEquals) continue;
            return aColumns[iColumn];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets, IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            IColumn[] aOneSource = new IColumn[1];
            IColumn[] aOneTarget = new IColumn[1];
            List lExcludedTargetColumns = this.getListOfColumnsExcludedFromMapping();
            ArrayList<IColumn> lSources = new ArrayList<IColumn>(Arrays.asList(aSources));
            lSources.removeAll(this.getSourceColumnsExcludedFromMapping());
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                IColumn tgt = aTargets[iTarget];
                if (lExcludedTargetColumns.contains(tgt)) continue;
                IMapping mapping = this.findTargetMapping(tgt);
                boolean bBreak = false;
                for (int iSource = 0; iSource < lSources.size() && !bBreak; ++iSource) {
                    IColumn src = (IColumn)lSources.get(iSource);
                    for (int iRule = 0; iRule < aRules.length && !bBreak; ++iRule) {
                        String sExpression;
                        if (!aRules[iRule].canMap(src, tgt) || (sExpression = aRules[iRule].getExpressionText()) != null && sExpression.length() != 0) continue;
                        if (mapping == null) {
                            aOneSource[0] = src;
                            aOneTarget[0] = tgt;
                            mapping = this.addMapping(aOneSource, aOneTarget, "ONETOONE", null);
                        } else if (!mapping.containsInSources(src)) {
                            mapping.addSource(src);
                        }
                        bBreak = true;
                        lSources.remove(src);
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected boolean isExpressionNeeded(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length == 0 || aTargets.length != 1) {
            return true;
        }
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            if (aSources[iSource].getType() == aTargets[0].getType()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IMapping createMapping(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        IModel mdl = this.getModel();
        AppendMapping mapping = (AppendMapping)mdl.getObject(mdoFM.getFQID());
        if (mapping != null) {
            return mapping;
        }
        mapping = new AppendMapping(mdoFM.getFQID(), mdl);
        mapping.loadFromOMR(omr);
        return mapping;
    }

    @Override
    protected String getClassifierMapType() {
        return "Select";
    }

    @Override
    public IMapping createNewMapping() {
        return new AppendMapping(this.getModel().createIDForNewObject(this.getID()), this.getModel());
    }

    @Override
    protected int getMaximumDataSourceCount() {
        return Integer.MAX_VALUE;
    }

    public class AppendMapping
    extends BaseMapping {
        public AppendMapping(String sID, IModel model) {
            super(sID, model);
            this.setTypeImpl("ONETOONE");
            this.setExpressionAllowed(false);
        }

        @Override
        public void setType(String sType) {
            if (!"ONETOONE".equals(sType)) {
                throw new IllegalArgumentException("Illegal type for append mapping: " + sType);
            }
        }

        @Override
        protected void loadTypeFromOMR(FeatureMap mdoFM) throws RemoteException {
            this.setTypeImpl("ONETOONE");
        }

        @Override
        public boolean isComplete() {
            return this.isSourceAndTargetComplete() && this.getExpression() == null && !this.isExpressionNeeded();
        }

        @Override
        protected boolean isExpressionNeeded() {
            if (!this.isSourceAndTargetComplete()) {
                return true;
            }
            return AppendTransformModel.this.isExpressionNeeded(this.getSources(), this.getTargets());
        }

        @Override
        protected boolean isSourceAndTargetComplete() {
            return this.getSourceCount() >= 1 && this.getTargetCount() == 1;
        }

        @Override
        public List getReasonsIncomplete() {
            ArrayList<String> lReasons = new ArrayList<String>();
            if (this.getSourceCount() == 0) {
                lReasons.add(RB.getStringResource("AppendTransformModel.AppendMapping.ReasonIncomplete.MissingSource.txt"));
            }
            if (this.getTargetCount() > 1) {
                lReasons.add(RB.getStringResource("AppendTransformModel.AppendMapping.ReasonIncomplete.TooManyTargets.txt"));
            }
            if (this.getTargetCount() == 0) {
                lReasons.add(RB.getStringResource("AppendTransformModel.AppendMapping.ReasonIncomplete.MissingTarget.txt"));
            }
            if (this.getTargetCount() == 1) {
                IColumn[] aSources = this.getSources();
                IColumn[] aTargets = this.getTargets();
                for (int iSource = 0; iSource < aSources.length; ++iSource) {
                    if (aSources[iSource].getType() == aTargets[0].getType()) continue;
                    lReasons.add(RB.getStringResource("AppendTransformModel.AppendMapping.ReasonIncomplete.TypeMismatch.txt"));
                }
            }
            return lReasons;
        }

        @Override
        public String getWarning() {
            if (this.getTargetCount() == 1) {
                IColumn[] aSources = this.getSources();
                IColumn[] aTargets = this.getTargets();
                for (int iSource = 0; iSource < aSources.length; ++iSource) {
                    if (aSources[iSource].getType() != aTargets[0].getType()) {
                        return MessageFormat.format(RB.getStringResource("AppendTransformModel.AppendMapping.Warning.TypeMismatch.txt"), aSources[iSource].getName(), aTargets[0].getName());
                    }
                    if (aSources[iSource].getLength() <= aTargets[0].getLength()) continue;
                    return MessageFormat.format(RB.getStringResource("AppendTransformModel.AppendMapping.Warning.TargetTooShort.txt"), aSources[iSource].getName(), aTargets[0].getName());
                }
            }
            return null;
        }
    }
}

