/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.impl.BaseValidationOperation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;

public class DuplicateValuesValidationOperation
extends BaseValidationOperation {
    private Set m_setColumns = new HashSet();

    public DuplicateValuesValidationOperation(String sID, IModel model) {
        super(sID, model);
    }

    public static String getValidationType() {
        return "ValidationOperation:DuplicateValues";
    }

    @Override
    public boolean isValidationActionSupported(String action) {
        return "ValidationAction:MoveToErrorTable".equals(action) || "ValidationAction:MoveAllButOneToErrorTable".equals(action) || "ValidationAction:AbortJob".equals(action);
    }

    @Override
    public IColumn getColumn() {
        throw new UnsupportedOperationException("getColumn() is not supported for this operation; use getColumns() instead");
    }

    @Override
    public void setColumn(IColumn column) {
        throw new UnsupportedOperationException("setColumn() is not supported for this operation; use setColumns() instead");
    }

    public boolean isColumnsAllowed(IColumn[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (this.isColumnAllowed(columns[i])) continue;
            return false;
        }
        return true;
    }

    public IColumn[] getColumns() {
        return this.m_setColumns.toArray(new IColumn[0]);
    }

    public void setColumns(IColumn[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException("list of columns to validate cannot be null");
        }
        if (columns.length == 0) {
            throw new IllegalArgumentException("list of columns to validate cannot be empty");
        }
        if (!this.isColumnsAllowed(columns)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetColumnsUndoable(this.m_setColumns.toArray(new IColumn[0]), columns));
        }
        this.m_setColumns.clear();
        this.m_setColumns.addAll(Arrays.asList(columns));
        this.fireModelChangedEvent("ValidationEvent:ColumnChanged", this.m_setColumns);
    }

    public void addColumns(IColumn[] columns) {
        if (columns == null) {
            return;
        }
        if (!this.isColumnsAllowed(columns)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddColumnsUndoable(columns));
        }
        this.m_setColumns.addAll(Arrays.asList(columns));
        this.fireModelChangedEvent("ValidationEvent:ColumnChanged", this.m_setColumns);
    }

    public void removeColumns(IColumn[] columns) {
        if (columns == null) {
            return;
        }
        List<IColumn> lColumns = Arrays.asList(columns);
        if (!this.m_setColumns.containsAll(lColumns)) {
            throw new IllegalArgumentException("the list of columns to remove contains a column not used in this operation");
        }
        if (this.m_setColumns.size() == columns.length) {
            throw new IllegalArgumentException("all columns cannot be removed; the list of columns to validate cannot be made empty");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveColumnsUndoable(columns));
        }
        this.m_setColumns.removeAll(Arrays.asList(columns));
        this.fireModelChangedEvent("ValidationEvent:ColumnChanged", this.m_setColumns);
    }

    private class RemoveColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_columns;

        public RemoveColumnsUndoable(IColumn[] columns) {
            this.m_columns = columns;
        }

        @Override
        public void undo() {
            super.undo();
            DuplicateValuesValidationOperation.this.addColumns(this.m_columns);
        }

        @Override
        public void redo() {
            super.redo();
            DuplicateValuesValidationOperation.this.removeColumns(this.m_columns);
        }
    }

    private class AddColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_columns;

        public AddColumnsUndoable(IColumn[] columns) {
            this.m_columns = columns;
        }

        @Override
        public void undo() {
            super.undo();
            DuplicateValuesValidationOperation.this.removeColumns(this.m_columns);
        }

        @Override
        public void redo() {
            super.redo();
            DuplicateValuesValidationOperation.this.addColumns(this.m_columns);
        }
    }

    private class SetColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_oldColumns;
        private IColumn[] m_newColumns;

        public SetColumnsUndoable(IColumn[] oldColumns, IColumn[] newColumns) {
            this.m_oldColumns = oldColumns;
            this.m_newColumns = newColumns;
        }

        @Override
        public void undo() {
            super.undo();
            DuplicateValuesValidationOperation.this.setColumns(this.m_oldColumns);
        }

        @Override
        public void redo() {
            super.redo();
            DuplicateValuesValidationOperation.this.setColumns(this.m_newColumns);
        }
    }
}

