/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.ConditionActionsTemplateJobModel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Root;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DesignTimeJobModel
extends ConditionActionsTemplateJobModel {
    public static DesignTimeJobModel createModelForExistingJob(String sJobID) {
        DesignTimeJobModel model = new DesignTimeJobModel();
        model.m_job = model.getObjectFactory().createJob(sJobID);
        model.setMainObject(model.m_job);
        return model;
    }

    public static DesignTimeJobModel createModelForNewJob(String sContainerID) {
        DesignTimeJobModel model = new DesignTimeJobModel();
        model.m_job = model.getObjectFactory().createNewJob(sContainerID);
        model.setMainObject(model.m_job);
        return model;
    }

    private DesignTimeJobModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataObjectFromJob(IDataObject data) {
        this.startCompoundUndoable();
        try {
            IDataTransform[] producers;
            IDataTransform[] consumers = data.getConsumerTransforms();
            if (consumers != null && consumers.length > 0) {
                for (int iConsumer = 0; iConsumer < consumers.length; ++iConsumer) {
                    data.removeConsumerTransform(consumers[iConsumer]);
                    consumers[iConsumer].removeDataSource(data);
                }
            }
            if ((producers = data.getProducerTransforms()) != null && producers.length > 0) {
                for (int iProducer = 0; iProducer < producers.length; ++iProducer) {
                    data.removeProducerTransform(producers[iProducer]);
                    producers[iProducer].removeDataTarget(data);
                }
            }
            this.getJob().getDataObjectsList().remove(data);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public List validateControlFlow() {
        ArrayList<ITransform> lBadTransformations = new ArrayList<ITransform>();
        ITransform[] aTransforms = this.m_job.getTransforms();
        for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            if (this.areTransformationSourcesPopulatedBeforeRunnning(aTransforms[iTransform])) continue;
            lBadTransformations.add(aTransforms[iTransform]);
        }
        return lBadTransformations;
    }

    public boolean areTransformationSourcesPopulatedBeforeRunnning(ITransform xfm) {
        int iFlowPosition = this.m_job.getControlOrderedTransformsList().indexOf(xfm);
        if (iFlowPosition == -1) {
            return false;
        }
        if (!(xfm instanceof IDataTransform)) {
            return true;
        }
        IDataObject[] aSources = ((IDataTransform)xfm).getDataSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            IDataTransform[] aProducers = aSources[iSource].getProducerTransforms();
            for (int iProducer = 0; iProducer < aProducers.length; ++iProducer) {
                int iProducerFlowPosition = this.m_job.getControlOrderedTransformsList().indexOf(aProducers[iProducer]);
                if (iProducerFlowPosition <= iFlowPosition) continue;
                return false;
            }
        }
        return true;
    }

    public boolean areAnyDataObjectsChanged() {
        IDataObject[] aObjects = this.m_job.getDataObjects();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!aObjects[iObject].isChanged()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChangedDataObjects(MdFactory factory) throws RemoteException, MdException {
        this.setSaving(true);
        try {
            OMRAdapter omr = new OMRAdapter(this, factory, "saveChangedDataObjects");
            try {
                IDataObject[] aObjects = this.m_job.getDataObjects();
                for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                    if (!aObjects[iObject].isChanged()) continue;
                    aObjects[iObject].saveToOMR(omr);
                    WsMetadataUtil.updateModifiedByFor((Root)omr.acquireOMRObject(aObjects[iObject]));
                }
                omr.save();
            }
            finally {
                omr.dispose();
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectAutomaticControlFlow(IDataTransform fromDataTransform, ITransform toTransform) {
        if (fromDataTransform != null && toTransform != null) {
            this.startCompoundUndoable();
            try {
                List controlTransforms = this.getJob().getControlOrderedTransformsList();
                if (controlTransforms.indexOf(toTransform) >= 0 && controlTransforms.indexOf(fromDataTransform) >= 0) {
                    return;
                }
                if (controlTransforms.indexOf(toTransform) == -1 && controlTransforms.indexOf(fromDataTransform) == -1) {
                    controlTransforms.add(fromDataTransform);
                    if (fromDataTransform != toTransform) {
                        controlTransforms.add(toTransform);
                    }
                } else if (controlTransforms.indexOf(toTransform) == -1 && controlTransforms.indexOf(fromDataTransform) >= 0) {
                    int fromIndex = controlTransforms.indexOf(fromDataTransform);
                    controlTransforms.add(fromIndex + 1, toTransform);
                } else if (controlTransforms.indexOf(toTransform) >= 0 && controlTransforms.indexOf(fromDataTransform) == -1) {
                    int toIndex = controlTransforms.indexOf(toTransform);
                    if (toIndex == 0) {
                        controlTransforms.add(toIndex, fromDataTransform);
                    } else {
                        controlTransforms.add(toIndex - 1, fromDataTransform);
                    }
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectAutomaticControlFlow(ITransform fromTransform, IDataTransform toDataTransform) {
        this.startCompoundUndoable();
        try {
            if (fromTransform != null && toDataTransform != null) {
                List controlTransforms = this.getJob().getControlOrderedTransformsList();
                if (controlTransforms.indexOf(toDataTransform) >= 0 && controlTransforms.indexOf(fromTransform) >= 0) {
                    return;
                }
                if (controlTransforms.indexOf(toDataTransform) == -1 && controlTransforms.indexOf(fromTransform) == -1) {
                    controlTransforms.add(fromTransform);
                    if (fromTransform != toDataTransform) {
                        controlTransforms.add(toDataTransform);
                    }
                } else if (controlTransforms.indexOf(toDataTransform) == -1 && controlTransforms.indexOf(fromTransform) >= 0) {
                    int fromIndex = controlTransforms.indexOf(fromTransform);
                    controlTransforms.add(fromIndex + 1, toDataTransform);
                } else if (controlTransforms.indexOf(toDataTransform) >= 0 && controlTransforms.indexOf(fromTransform) == -1) {
                    int toIndex = controlTransforms.indexOf(toDataTransform);
                    if (toIndex == 0) {
                        controlTransforms.add(toIndex, fromTransform);
                    } else {
                        controlTransforms.add(toIndex, fromTransform);
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataTransform(IDataTransform transform) {
        this.startCompoundUndoable();
        try {
            IDataObject[] aSources = transform.getDataSources();
            IDataObject[] aTargets = transform.getDataTargets();
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                if (aTargets[iTarget] instanceof IWorkTable) {
                    IDataTransform[] aConsumerTransforms = aTargets[iTarget].getConsumerTransforms();
                    for (int iTargetTransform = 0; iTargetTransform < aConsumerTransforms.length; ++iTargetTransform) {
                        aConsumerTransforms[iTargetTransform].removeDataSource(aTargets[iTarget]);
                    }
                }
                transform.removeDataTarget(aTargets[iTarget]);
            }
            for (int iSource = 0; iSource < aSources.length; ++iSource) {
                transform.removeDataSource(aSources[iSource]);
            }
            this.getJob().getTransformsList().remove(transform);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapColumns() {
        this.startCompoundUndoable();
        try {
            ITransform[] aTransforms = this.m_job.getTransforms();
            for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
                IDataTransform transform;
                if (!(aTransforms[iTransform] instanceof IDataTransform) || !(transform = (IDataTransform)aTransforms[iTransform]).isIncludedInMapping()) continue;
                transform.mapColumns();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }
}

