/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.INotesContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.INote;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.connection.ConnectionManager;
import java.io.IOException;
import java.io.StringReader;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class CodeSegment
implements ICodeSegment {
    private StringBuffer m_GeneratedSource;
    private String m_indentString = "";
    protected int m_numIndents = 0;
    private boolean m_generateParallelMacroHeaderComments = false;
    int m_startPosition = -1;
    int m_endPosition = -1;
    private boolean m_clientGeneratedSegment = false;
    public static final String SYSLAST_PROPERTY_NAME = "SYSLAST";
    public static final String ETLS_SYSLAST_PROPERTY_NAME = "ETLS_SYSLAST";
    public static final String NOTE_LABEL = "NOTE:";
    public static final String GLOBAL_ALL = "ALL";
    public static final String WORK_LIBREF = "work";
    public static final String PARALLEL_WORK_LIBREF = "etlswork";
    private static final String CHECK_EXIST_MACROVAR_NAME = "etls_recCheckExist";
    private static final String DIVIDER = "*";
    public static final int FQID_LENGTH = 17;
    public static final String ATTRIBUTE_OPTION_PREFIX = "OPTION.";
    public static final int MAXIMUM_LINE_LENGTH = 254;
    public static final int MVS_MAXIMUM_LINE_LENGTH = 79;
    private IObject m_model;
    private String m_name;
    private ICodeGenerationEnvironment m_environment;
    private boolean m_bAutoAddSourceToEnvironment = false;
    private ICodeSegment m_parentSegment;
    private static final String JCL_INDENT = " ";
    private boolean m_bisBody;
    public static final String DI_SYSCC_MACRO = "di_syscc";

    public CodeSegment(ICodeGenerationEnvironment environment, IObject modelObject) {
        this(environment, modelObject, false);
    }

    public CodeSegment(ICodeGenerationEnvironment environment, IObject modelObject, boolean autoAddSource) {
        this.m_environment = environment;
        this.m_model = modelObject;
        if (modelObject != null) {
            this.m_name = modelObject.getName();
        }
        this.m_GeneratedSource = new StringBuffer();
        this.m_bAutoAddSourceToEnvironment = autoAddSource;
        this.m_bisBody = false;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setIsBody(boolean isBody) {
        this.m_bisBody = isBody;
    }

    @Override
    public boolean isBody() {
        return this.m_bisBody;
    }

    @Override
    public IServer getDefaultServer() {
        return this.m_environment.getDefaultServer();
    }

    @Override
    public void setParentSegment(ICodeSegment owningSegment) {
        this.m_parentSegment = owningSegment;
    }

    @Override
    public ICodeSegment getParentSegment() {
        return this.m_parentSegment;
    }

    @Override
    public boolean isAutoAddSourceCodeToEnvironment() {
        return this.m_bAutoAddSourceToEnvironment;
    }

    @Override
    public void setAutoAddSourceCodeToEnvironment(boolean autoAdd) {
        this.m_bAutoAddSourceToEnvironment = autoAdd;
    }

    public boolean isGenerateJCLIndent() {
        return this.getCodeGenerationEnvironment().isGenerateJCLIndent();
    }

    @Override
    public ICodeSegment createNewCodeSegment(IObject object) {
        ICodeSegment codeSegment = this.m_environment.createNewCodeSegment(object);
        codeSegment.setParentSegment(this);
        codeSegment.setAutoAddSourceCodeToEnvironment(false);
        return codeSegment;
    }

    @Override
    public ICodeGenerationEnvironment getCodeGenerationEnvironment() {
        return this.m_environment;
    }

    @Override
    public IObject getModelObject() {
        return this.m_model;
    }

    @Override
    public IServer getCurrentServer() {
        return this.m_environment.getCurrentServer();
    }

    @Override
    public ICodeSegment addSourceCode(String sourceText) {
        if (sourceText != null) {
            if (this.isGenerateJCLIndent() && this.m_GeneratedSource.length() == 0 && !sourceText.startsWith("\n") && !sourceText.startsWith(JCL_INDENT)) {
                sourceText = JCL_INDENT + sourceText;
            }
            if (this.isGenerateJCLIndent()) {
                sourceText = sourceText.replaceAll("\n", "\n ");
            }
            if (this.getIndentString().length() > 0) {
                sourceText = sourceText.replaceAll("\n", "\n" + this.getIndentString());
            }
            if (this.m_parentSegment != null) {
                this.m_parentSegment.addSourceCode(sourceText);
            }
            if (this.m_bAutoAddSourceToEnvironment) {
                this.m_environment.addSourceCode(new StringBuffer(sourceText));
            }
            this.m_GeneratedSource.append(sourceText);
            int endLocation = this.m_startPosition + this.m_GeneratedSource.length();
            if (this.m_parentSegment != null) {
                endLocation = this.m_parentSegment.getEnvironmentEndPosition();
            }
            this.m_endPosition = endLocation;
        }
        return this;
    }

    @Override
    public ICodeSegment addSourceCode(ICodeSegment codeSegment) {
        if (codeSegment != null) {
            String sourceText = codeSegment.toString();
            if (this.isGenerateJCLIndent() && this.m_GeneratedSource.length() == 0 && !sourceText.startsWith("\n") && !sourceText.startsWith(JCL_INDENT)) {
                sourceText = JCL_INDENT + sourceText;
            }
            if (this.isGenerateJCLIndent()) {
                sourceText = sourceText.replaceAll("\n", "\n ");
            }
            if (this.getIndentString().length() > 0) {
                sourceText = sourceText.replaceAll("\n", "\n" + this.getIndentString());
            }
            if (this.m_parentSegment != null) {
                this.m_parentSegment.addSourceCode(sourceText);
            }
            if (!codeSegment.isAutoAddSourceCodeToEnvironment() && this.isAutoAddSourceCodeToEnvironment()) {
                this.m_environment.addSourceCode(new StringBuffer(sourceText));
            }
            this.m_GeneratedSource.append(sourceText);
            int endLocation = this.m_startPosition + this.m_GeneratedSource.length();
            if (this.m_parentSegment != null) {
                endLocation = this.m_parentSegment.getEnvironmentEndPosition();
            }
            this.m_endPosition = endLocation;
        }
        return this;
    }

    @Override
    public ICodeSegment addSourceCode(ICodeGenerationEnvironment environment) {
        if (environment != null) {
            int difference = this.m_environment.getGeneratedCode().length();
            this.addSourceCode(environment.getGeneratedCode());
            ICodeSegment[] codeSegments = environment.getCodeSegments();
            for (int i = 0; i < codeSegments.length; ++i) {
                ICodeSegment cs = codeSegments[i];
                this.m_environment.addCodeSegment(cs);
                cs.setStartPosition(cs.getEnvironmentStartPosition() + difference);
                cs.setEndPosition(cs.getEnvironmentEndPosition() + difference);
            }
        }
        return this;
    }

    @Override
    public ICodeSegment addSourceCode(StringBuffer sourceText) {
        return this.addSourceCode(sourceText.toString());
    }

    @Override
    public String toString() {
        return this.m_GeneratedSource.toString();
    }

    @Override
    public StringBuffer getGeneratedCode() {
        return !this.m_environment.isUseMVSLineLength() ? this.m_GeneratedSource : this.m_environment.getLimitedString(this.m_GeneratedSource);
    }

    @Override
    public ICodeSegment clearSourceCode() {
        return this.clearSourceCode(true);
    }

    @Override
    public ICodeSegment clearSourceCode(boolean cleanCache) {
        this.m_GeneratedSource = new StringBuffer();
        this.m_numIndents = 0;
        this.m_indentString = "";
        this.m_environment.removeCodeSegmentCode(this);
        if (cleanCache) {
            // empty if block
        }
        return this;
    }

    @Override
    public ICodeSegment addCommentLine(String msg) {
        this.addSourceCode(this.makeComment(msg));
        return this;
    }

    @Override
    public ICodeSegment newLine() {
        return this.newLine(1);
    }

    @Override
    public ICodeSegment newLine(int numNewLines) {
        this.addSourceCode(this.getNewLineString(numNewLines));
        return this;
    }

    private StringBuffer getNewLineString(int numNewLines) {
        StringBuffer lines = new StringBuffer();
        for (int i = 0; i < numNewLines; ++i) {
            lines.append("\n");
        }
        return lines;
    }

    @Override
    public ICodeSegment space() {
        return this.space(1);
    }

    @Override
    public ICodeSegment space(int numSpaces) {
        this.addSourceCode(this.getSpaceString(numSpaces));
        return this;
    }

    private StringBuffer getSpaceString(int numSpaces) {
        StringBuffer spaces = new StringBuffer();
        for (int i = 0; i < numSpaces; ++i) {
            spaces.append(JCL_INDENT);
        }
        return spaces;
    }

    @Override
    public ICodeSegment indent() {
        return this.indent(1);
    }

    @Override
    public ICodeSegment indent(int numIndents) {
        int newNumIndents = this.m_numIndents + numIndents;
        this.setIndent(newNumIndents);
        this.addSourceCode(this.getIndentionString(numIndents));
        return this;
    }

    public void setGenerateCommentsOnParallelMacros(boolean value) {
        this.m_generateParallelMacroHeaderComments = value;
    }

    @Override
    public ICodeSegment setIndent(int numIndents) {
        this.m_numIndents = numIndents;
        StringBuffer indents = this.getIndentionString(this.m_numIndents);
        if (this.isGenerateJCLIndent()) {
            indents.append(JCL_INDENT);
        }
        this.m_indentString = indents.toString();
        return this;
    }

    @Override
    public int getIndents() {
        return this.m_numIndents;
    }

    private StringBuffer getIndentionString(int numIndents) {
        if (this.m_environment.isUseMVSLineLength()) {
            return new StringBuffer();
        }
        StringBuffer indents = new StringBuffer();
        for (int i = 0; i < numIndents; ++i) {
            indents.append("   ");
        }
        return indents;
    }

    @Override
    public String getIndentString() {
        return !this.m_environment.isUseMVSLineLength() ? this.m_indentString : "";
    }

    @Override
    public void removeIndent(int numIndents) {
        String temp;
        String indents = "";
        for (int i = 0; i < numIndents; ++i) {
            indents = indents + "   ";
        }
        int length = this.m_GeneratedSource.length();
        if (length > indents.length() && (temp = this.m_GeneratedSource.substring(length - indents.length())).equals(indents)) {
            int envLength;
            int startDelete;
            StringBuffer envCode;
            String tempE;
            this.m_GeneratedSource.delete(length - indents.length(), length);
            if (this.m_bAutoAddSourceToEnvironment && (tempE = (envCode = this.m_environment.getGeneratedCode()).substring(startDelete = (envLength = envCode.length()) - indents.length())).equals(indents)) {
                envCode.delete(startDelete, envLength);
            }
            if (this.m_parentSegment != null) {
                this.m_parentSegment.removeIndent(numIndents);
            }
        }
    }

    @Override
    public ICodeSegment unIndent() {
        return this.unIndent(1);
    }

    @Override
    public ICodeSegment unIndent(int numIndentsToRemove) {
        int numIndents = this.m_numIndents - numIndentsToRemove;
        if (numIndents < 0) {
            numIndents = 0;
        }
        this.setIndent(numIndents);
        this.removeIndent(numIndentsToRemove);
        return this;
    }

    @Override
    public ICodeSegment genParallelMacros(IServer server, boolean generateCommentHeaders) {
        return this.genParallelMacros(server, generateCommentHeaders, false);
    }

    @Override
    public ICodeSegment genParallelMacros(IServer server, boolean generateCommentHeaders, boolean bRCSetSYSCCEnabled) {
        if (!this.m_environment.getParallelMacroStatus(server)) {
            this.m_environment.setGenerateCommentHeaderOnParallelMacros(generateCommentHeaders);
            this.addSourceCode(this.getParallelMacros(this.m_environment.getCurrentServer(), bRCSetSYSCCEnabled));
            this.m_environment.addServerToParallelMacroGeneration(server);
        }
        return this;
    }

    public StringBuffer getParallelMacros(IServer server, boolean bRCSetSYSCCEnabled) {
        StringBuffer code = new StringBuffer();
        code.append(this.getSascmdOption()).append(this.getTSLevelMacro("etls_gridInstalled", "uwugrdsv")).append(this.getSignonMacro(server, bRCSetSYSCCEnabled)).append(this.getParallelServerConnectedMacro()).append(this.getSignoffMacro()).append(this.getParallelGetHandleMacro()).append(this.getParallelFreeHandleMacro()).append(this.getParallelCreateHandleMacro()).append(this.getParallelWaitForMacro()).append(this.getParallelProcessesRunning());
        return code;
    }

    @Override
    public StringBuffer getSubmitToGridSignon(IServer server, IJob job) {
        return this.getSubmitToGridSignon(server, job, false);
    }

    @Override
    public StringBuffer getSubmitToGridSignon(IServer server, IJob job, boolean bRCSetSYSCCEnabled) {
        WorkspaceFile adFile = Workspace.getWorkspace().getAppDefaultsFile();
        int signonRetries = adFile.getPropertyInt("SubmitToGrid.SignonRetries", 0);
        String gridSubmitWorkload = adFile.getPropertyString("SubmitToGrid.Workload", "");
        String additionalSignonOptions = adFile.getPropertyString("SubmitToGrid.SignonOptions", "");
        String gridApplication = "";
        if (job.getJob().getExecutionServer().getGridServer() != null && job.getJob().getExecutionServer().getGridServer().getGridOptionSets() != null) {
            ArrayList<String> gasL = new ArrayList<String>();
            gasL.addAll(server.getGridServer().getGridOptionSets());
            if (gasL.size() == 0) {
                gridApplication = "";
            } else if (gasL.size() == 1) {
                gridApplication = gasL.contains(gasL.get(0)) ? (String)gasL.get(0) : "";
            }
        }
        if (gridApplication == "") {
            gridApplication = adFile.getPropertyString("SubmitToGrid.Application", "");
        }
        String gridSuppJobOptions = adFile.getPropertyString("SubmitToGrid.GridSuppJobOptions", "");
        String gridSubmitJobName = job.getName();
        String gridSubmitHandleName = "etlsRmt";
        StringBuffer prefixCode = new StringBuffer();
        prefixCode.append(this.getReturnCodeSetup(bRCSetSYSCCEnabled)).append(this.getTSLevelMacro("etls_gridInstalled", "uwugrdsv")).append(this.getSignonMacro(server, bRCSetSYSCCEnabled)).append(this.getParallelServerConnectedMacro()).append(this.getSignoffMacro()).append(this.getSascmdOption());
        prefixCode.append("%global etls_signonStatus; \n").append("%let etls_gridOptionSet = %nrstr(").append(gridApplication).append(");\n").append("%let etls_workload = ").append(gridSubmitWorkload).append(";\n").append("%let etls_additionalSignonOptions = ").append(additionalSignonOptions).append(";\n").append("%let etls_gridJobName = DIS_").append(gridSubmitJobName).append(";\n").append("%let etls_handleName = ").append(gridSubmitHandleName).append(";\n").append("%let etls_startTime_&etls_handleName = %sysfunc(datetime()); \n").append("%let etls_endTime_&etls_handleName = &&&etls_startTime_&etls_handleName; \n\n");
        prefixCode.append("%let etls_gridSuppJobOptions = ").append(gridSuppJobOptions).append(";\n");
        prefixCode.append("signoff &etls_handleName;\n");
        prefixCode.append("%etls_signon(handleName=&etls_handleName, cmacvar=etls_signonStatus, \n").append("   ").append("machineIdMacroVariable=etls_machineId,");
        if (gridSubmitWorkload.length() > 0) {
            prefixCode.append("workloadMacroVariable=etls_workload, \n");
        }
        if (gridApplication.length() > 0) {
            prefixCode.append("gridOptionSet=&etls_gridOptionSet, \n");
        }
        prefixCode.append("\n").append("   ").append("additionalSignonOptions=&etls_additionalSignonOptions,signonRetries=").append(signonRetries).append(", gridJobName=&etls_gridJobName); \n\n");
        prefixCode.append("libname rmt_work slibref=work server=&etls_handleName;\n");
        prefixCode.append("%syslput etls_handleName = &etls_handleName / remote = &etls_handleName; \n\n").append("rsubmit &etls_handlename wait = yes sysrputsync = yes persist = yes;\n\n").append("%sysrput etls_startTime_&etls_handleName = %sysfunc(datetime()); \n\n");
        prefixCode.append("endrsubmit;\n\n");
        return prefixCode;
    }

    @Override
    public StringBuffer getSubmitToGridRSubmit() {
        StringBuffer prefixCode = new StringBuffer();
        prefixCode.append("rsubmit &etls_handlename wait = yes sysrputsync = yes persist = yes;\n\n");
        return prefixCode;
    }

    @Override
    public StringBuffer getSubmitToGridEndRSubmit() {
        StringBuffer prefixCode = new StringBuffer();
        prefixCode.append("endrsubmit;\n\n");
        return prefixCode;
    }

    @Override
    public StringBuffer getSubmitToGridSuffix(boolean doSignoff) {
        StringBuffer suffixCode = new StringBuffer();
        suffixCode.append(this.getSubmitToGridRSubmit());
        suffixCode.append("%sysrput etls_endTime_&etls_handleName = %sysfunc(datetime()); \n").append("%sysrput job_rc&etls_handleName = &job_rc;\n").append(this.getSubmitToGridEndRSubmit()).append("\n\n");
        if (doSignoff) {
            suffixCode.append("%etls_signoff(handleName=&etls_handleName); \n\n");
        }
        suffixCode.append("%put NOTE: Total runtime was %sysfunc(round(%sysevalf((&&&etls_endTime_&etls_handleName - &&&etls_startTime_&etls_handleName)/60),.0001)) (minutes).; \n").append("%put NOTE: Return code was &&job_rc&etls_handleName...; \n");
        return suffixCode;
    }

    @Override
    public StringBuffer getRestartPointClear() {
        StringBuffer restartCode = new StringBuffer();
        restartCode.append("%let etls_resetRestart=1;").append("%let etls_runningInteractive=1;\n");
        return restartCode;
    }

    public StringBuffer getSascmdOption() {
        StringBuffer code = new StringBuffer();
        code.append("%macro genSASCommand; \n").append("   ").append("%local noobjserver; \n").append("   ").append("%if \"&sysscp\"=\"OS\" %then %let noobjserver=; \n").append("   ").append("%else %if \"&sysscp\"=\"VMS_AXP\" %then %let noobjserver=%quote(/noobjectserver); \n").append("   ").append("%else %let noobjserver=%quote(-noobjectserver); \n").append("   ").append("options sascmd = \"!sascmd &noobjserver\"; \n").append("%mend genSASCommand; \n").append("%genSASCommand; \n\n");
        return code;
    }

    @Override
    public StringBuffer getDebugOptionCode() {
        StringBuffer code = new StringBuffer();
        code.append("%macro etls_genDebugOptionCode; \n").append("   ").append("%local nostsuffix; \n").append("   ").append("%if \"&sysscp\"=\"OS\" %then %let nostsuffix=; \n").append("   ").append("%else %let nostsuffix=nostsuffix; \n").append("   ").append("options sql_ip_trace = all sastrace = ',,,sd' fullstimer &nostsuffix;\n").append("%mend etls_genDebugOptionCode; \n").append("%etls_genDebugOptionCode; \n\n");
        return code;
    }

    @Override
    public ICodeSegment genDebugOptionCode() {
        return this.addSourceCode(this.getDebugOptionCode());
    }

    public ICodeSegment genSascmdOption() {
        this.addSourceCode(this.getSascmdOption());
        return this;
    }

    public StringBuffer getSignonMacro(IServer server, boolean isRCSetSYSCCEnabled) {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_signon");
            macro.addParameter("handleName").addParameter("cmacvar").addParameter("gridRC").addParameter("useGrid").addParameter("machineIdMacroVariable").addParameter("gridOptionSet").addParameter("workloadMacroVariable").addParameter("log").addParameter("output").addParameter("additionalSignonOptions").addParameter("signonRetries").addParameter("gridJobName");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_signon(handleName=etlsRemote,\n").append("                   cmacvar=etls_signonStatus,\n").append("                   gridRC=rc,\n").append("                   useGrid=1,\n").append("                   machineIdMacroVariable=etls_machineId,\n").append("                   gridOptionSet=,\n").append("                   workloadMacroVariable=,\n").append("                   log=,\n").append("                   output=,\n").append("                   additionalSignonOptions=,\n").append("                   signonRetries=3,\n").append("                   gridJobName=&&etls_jobName&row);\n\n").append("   ").append("%let etls_gridInstalled =;\n").append("   ").append("%etls_tsLevel(macroName=etls_gridInstalled, featureName=uwugrdsv); \n\n").append("   ").append("%if (&useGrid = 1) %then \n").append("   ").append("%do; \n\n").append("   ").append("   ").append("%if (\"&etls_gridInstalled\" ne \"\") %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%if (&gridRC eq ) %then \n").append("   ").append("   ").append("   ").append("   ").append("%let gridRC = &handleName.RC ; \n\n").append("   ").append("   ").append("   ").append("%global &gridRC;\n").append("   ").append("   ").append("   ").append("%let workload = ; \n").append("   ").append("   ").append("   ").append("%if (\"&workloadMacroVariable\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("data _null_;\n").append("   ").append("   ").append("   ").append("   ").append("   ").append("call symput('workload','; workload = '||symget(\"&workloadMacroVariable\"));\n").append("   ").append("   ").append("   ").append("   ").append("run;\n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("%let gridoptset = ;\n").append("   ").append("   ").append("   ").append("%if (\"&gridOptionSet\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("data _null_;\n").append("   ").append("   ").append("   ").append("   ").append("   ").append("call symput('gridoptset',\"; gridoptset = '\"||\"&gridOptionSet\"||\"'\");\n").append("   ").append("   ").append("   ").append("   ").append("run;\n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("%let gridJobOpts = ;\n").append("   ").append("   ").append("   ").append("%let gridSuppOpts = ;\n").append("   ").append("   ").append("   ").append("%if (\"&etls_gridSuppJobOptions\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("data _null_;\n").append("   ").append("   ").append("   ").append("   ").append("   ").append("call symput('gridJobOpts', \"&etls_gridSuppJobOptions\");\n").append("   ").append("   ").append("   ").append("   ").append("run;\n").append("   ").append("   ").append("   ").append("   ").append("data _null_;\n").append("   ").append("   ").append("   ").append("   ").append("   ").append("call symput('gridSuppOpts', '; JOBOPTS=gridJobOpts');\n").append("   ").append("   ").append("   ").append("   ").append("run;\n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("   ").append("data _null_;\n").append("   ").append("   ").append("   ").append("   ").append("   ").append("call symput('gridJbName', \"; jobname = gridJobName\");\n").append("   ").append("   ").append("   ").append("   ").append("run;\n").append("   ").append("   ").append("   ").append("%let &gridRC = %sysfunc(grdsvc_enable(\"&handleName\", \"server = ").append(server.getName()).append(" &gridoptset &workload &gridSuppOpts &gridJbName\"));\n").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(RB.getStringResource("CodeSegment.GridServiceFunctionsNotInstalled.sasmacro.notrans"))).append("   ").append("%end; \n\n");
        code.append("   ").append("%local sleeptime sleepIncreaseAmount tryCount; \n").append("   ").append("%let sleepIncreaseAmount=5; \n").append("   ").append("%let sleeptime=5; \n").append("   ").append("%let tryCount=1; \n").append("   ").append("%let &cmacvar=1; \n\n").append("   ").append(this.makeComment("Store original return code values to reset them if a signon succeeds")).append("   ").append("%local etls_sysrc");
        if (isRCSetSYSCCEnabled) {
            code.append(" etls_syscc");
        }
        code.append(";\n");
        code.append("   ").append("%let etls_sysrc = &sysrc;\n");
        if (isRCSetSYSCCEnabled) {
            code.append("   ").append("%let etls_syscc = &syscc;\n\n");
        }
        code.append("   ").append("%do %until((&&&cmacvar ne 1) or (&tryCount gt %eval(&signonRetries+1))); \n").append("   ").append("   ").append("data _null_; \n").append("   ").append("   ").append("signon &handleName cmacvar=&cmacvar \n").append("   ").append("   ").append("   ").append("%if (\"&log\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("   ").append("log=&log; \n").append("   ").append("   ").append("   ").append("%if (\"&output\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("   ").append("output=&output; \n").append("   ").append("   ").append("   ").append("%if (\"&additionalSignonOptions\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("   ").append("&additionalSignonOptions; \n").append("   ").append("   ").append(";run; \n\n");
        code.append("   ").append("   ").append("%if \"&&&cmacvar\" eq \"1\" %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%if &tryCount lt %eval(&signonRetries+1) %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(MessageFormat.format(RB.getStringResource("CodeSegment.SignonFailedWillRetry.note.sasmacro.notrans"), "#&tryCount", "&sleeptime"), NOTE_LABEL, false)).append("   ").append("   ").append("   ").append("   ").append("%let rc=%sysfunc(sleep(&sleeptime,1)); \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("%else %if &signonRetries gt 0 %then \n").append("   ").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(MessageFormat.format(RB.getStringResource("CodeSegment.SignonFailedFinal.sasmacro.notrans"), "#&tryCount"), "ERROR%QUOTE(:)", false)).append("\n").append("   ").append("   ").append("   ").append("%let sleeptime=%sysevalf(&sleeptime+&sleepIncreaseAmount,int); /* increase sleeptime by factor */ \n").append("   ").append("   ").append("   ").append("%let tryCount=%eval(&tryCount+1); \n").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%else\n").append("   ").append("   ").append("%do;\n").append("   ").append("   ").append("   ").append(this.makeComment("Signon succeeded make sure return codes are reset to original values")).append("   ").append("   ").append("   ").append("%let sysrc = &etls_sysrc;\n");
        if (isRCSetSYSCCEnabled) {
            code.append("   ").append("   ").append("   ").append("%let syscc = &etls_syscc;\n");
        }
        code.append("   ").append("   ").append("%end;\n").append("   ").append("%end; \n").append("   ").append(this.getRCSetCall("&syserr", true));
        code.append("   ").append("/* On successful signon, fetch and report machine name if grid was requested. */ \n").append("   ").append("%if (\"&machineIdMacroVariable\" ne \"\") %then %let &machineIdMacroVariable = ; \n").append("   ").append("%if (\"&&&cmacvar\" ne \"1\" and \"&machineIdMacroVariable\" ne \"\" and \n").append("   ").append("   ").append("  &useGrid = 1 and \"&etls_gridInstalled\" ne \"\") %then \n").append("   ").append("%do; \n").append("   ").append("   ").append("%put; \n").append("   ").append("   ").append("%if (\"&&&gridRC\" eq \"0\") %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%let &machineIdmacroVariable = %sysfunc(grdsvc_getname(&handleName)); \n").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(RB.getStringResource("CodeSegment.SignedOnToGridMachine.sasmacro.notrans"))).append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(RB.getStringResource("CodeSegment.SignedOnToLocalMachine.sasmacro.notrans"))).append("   ").append("   ").append("%put; \n").append("   ").append("%end; \n\n");
        code.append("%mend etls_signon; \n\n");
        return code;
    }

    public ICodeSegment genSignonMacro(IServer server, boolean isRCSetSYSCCEnabled) {
        this.addSourceCode(this.getSignonMacro(server, isRCSetSYSCCEnabled));
        return this;
    }

    public StringBuffer getParallelServerConnectedMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_serverConnected");
            macro.addParameter("serverId").addParameter("macvarname");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_serverConnected(serverId=,macvarname=isConnected); \n").append("   ").append("%let &macvarname=0; \n").append("   ").append("%local search_str none_str savenotes; \n\n").append("   ").append("/* setup information for listtask output */ \n").append("   ").append("/* listtask output on OS/390 differs */ \n").append("   ").append("%if %bquote(&sysscp) eq OS %then \n").append("   ").append("%do; \n").append("   ").append("   ").append("%let search_str=Remote submit for; \n").append("   ").append("   ").append("%let token=5; \n").append("   ").append("%end; \n").append("   ").append("%else  \n").append("   ").append("%do; \n").append("   ").append("   ").append("%let search_str=--------------; \n").append("   ").append("   ").append("%let token=1; \n").append("   ").append("%end; \n\n").append("   ").append("/* Issue listtask within PROC PRINTTO - send output to file */ \n").append("   ").append("filename __tmptxt TEMP; \n").append("   ").append("%let savenotes=%sysfunc(getoption(notes)); \n").append("   ").append("options nonotes; \n\n").append("   ").append("proc printto log=__tmptxt new; \n").append("   ").append("run; \n\n").append("   ").append("options notes; \n").append("   ").append("listtask; \n").append("   ").append("proc printto; \n").append("   ").append("run; \n\n").append("   ").append("options nonotes; \n\n").append("   ").append("/* read in the output from listtask */ \n").append("   ").append("%let dsname=_null_; \n").append("   ").append("data _null_(keep=Session); \n").append("   ").append("   ").append("length line $256 sessionId $60; \n").append("   ").append("   ").append("infile __tmptxt length=len; \n").append("   ").append("   ").append("input @1 line $varying. len; \n\n").append("   ").append("   ").append("if line=:'There are no' then \n").append("   ").append("   ").append("   ").append("stop; \n").append("   ").append("   ").append("/* look for the search string and scan for server name */ \n").append("   ").append("   ").append("if index(line,\"&search_str\") then  \n").append("   ").append("   ").append("do; \n").append("   ").append("   ").append("   ").append("sessionId=kscan(line,&token,\" \"); \n").append("   ").append("   ").append("   ").append("sessionId=kupcase(ktrim(kleft(tranwrd(sessionId,'\"',' ')))); \n").append("   ").append("   ").append("   ").append("if sessionId=kupcase(symget(\"serverId\")) then \n").append("   ").append("   ").append("   ").append("do;  \n").append("   ").append("   ").append("   ").append("   ").append("call symput(\"&macvarname\",\"1\"); \n").append("   ").append("   ").append("   ").append("   ").append("stop; \n").append("   ").append("   ").append("   ").append("end; \n").append("   ").append("   ").append("end; \n").append("   ").append("run; \n").append("   ").append("filename __tmptxt clear; \n").append("   ").append("options &savenotes; \n").append("%mend etls_serverConnected; \n\n");
        return code;
    }

    public ICodeSegment genParallelServerConnectedMacro() {
        this.addSourceCode(this.getParallelServerConnectedMacro());
        return this;
    }

    public StringBuffer getSignoffMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_signoff");
            macro.addParameter("handleName");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_signoff(handleName=rmt); \n").append("   ").append("%local savemprint; \n").append("   ").append("%let savemprint=%sysfunc(getoption(mprint)); \n").append("   ").append(this.getPercentPutStatement(MessageFormat.format(RB.getStringResource("CodeSegment.etls_signoff.note.sasmacro.notrans"), "etls_serverConnected"))).append("   ").append("options nomprint; \n").append("   ").append("%local isConnected; \n").append("   ").append("%etls_serverConnected(serverId=&handleName); \n").append("   ").append("options &savemprint; \n").append("   ").append("%if &isConnected %then \n").append("   ").append("   ").append("signoff &handleName ;; \n").append("%mend etls_signoff; \n\n");
        return code;
    }

    public ICodeSegment genSignoffMacro() {
        this.addSourceCode(this.getSignoffMacro());
        return this;
    }

    public StringBuffer getParallelGetHandleMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_getHandle");
            macro.addParameter("statusTable").addParameter("handleVariable").addParameter("row");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_getHandle(statusTable=, handleVariable=, row=); \n").append("   ").append("%let etls_dsid = %sysfunc(open(&statusTable)); \n").append("   ").append("%if (&etls_dsid = 0) %then \n").append("   ").append("   ").append("%put %sysfunc(sysmsg()); \n").append("   ").append("%else \n").append("   ").append("%do; \n").append("   ").append("   ").append("%let rc = %sysfunc(fetchobs(&etls_dsid, &row)); \n").append("   ").append("   ").append("%if (&rc ne 0) %then \n").append("   ").append("   ").append("   ").append("%put %sysfunc(sysmsg()); \n").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%let etls_varnum = %sysfunc(varnum(&etls_dsid,&handleVariable)); \n").append("   ").append("   ").append("   ").append("%if (&etls_varnum > 0) %then \n").append("   ").append("   ").append("   ").append("   ").append("%sysfunc(getvarc(&etls_dsid,&etls_varnum)); \n").append("   ").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("   ").append("   ").append("%put %sysfunc(sysmsg()); \n").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%let rc = %sysfunc(close(&etls_dsid)); \n").append("   ").append("%end; \n").append("%mend etls_getHandle; \n\n");
        return code;
    }

    @Override
    public ICodeSegment genParallelGetHandleMacro() {
        this.addSourceCode(this.getParallelGetHandleMacro());
        return this;
    }

    public StringBuffer getParallelFreeHandleMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_freeHandle");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("handleVariable").addParameter("handleName").addParameter("statusSetting").addParameter("endTimeVariable").addParameter("startTimeVariable").addParameter("signoff").addParameter("returnCodeVariable").addParameter("returnCodeMacroVariable").addParameter("setMainJobRC").addParameter("statusUnknownReturnCode");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_freeHandle(statusTable=, statusVariable=, handleVariable=, \n").append("   ").append("handleName=, statusSetting=\"").append(RB.getStringResource("CodeSegment.StatusSetting.Finish.default.txt")).append("\", \n").append("   ").append("endTimeVariable=endTime, startTimeVariable=startTime, signoff=1, \n").append("   ").append("returnCodeVariable=, returnCodeMacroVariable=, setMainJobRC=1, \n").append("   ").append("statusUnknownReturnCode=., startTimeMacroVariable=, endTimeMacroVariable= ); \n\n").append("   ").append("%if (&statusTable ne ) %then \n").append("   ").append("%do; \n").append("   ").append("   ").append("%local etls_rcMacroVarExisted; \n").append("   ").append("   ").append("%let etls_rcMacroVarExisted = 0; \n").append("   ").append("   ").append("%if (\"&returnCodeMacroVariable\" ne \"\") %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("proc sql noprint; \n").append("   ").append("   ").append("   ").append("   ").append("select '1' into: etls_rcMacroVarExisted from dictionary.macros \n").append("   ").append("   ").append("   ").append("   ").append("where name=kupcase(\"&returnCodeMacroVariable\"); \n").append("   ").append("   ").append("   ").append("quit; \n\n").append("   ").append("   ").append("   ").append(this.getRCSetCall("&sqlrc", false)).append("   ").append("   ").append("   ").append("%if (&etls_rcMacroVarExisted = 0) %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(RB.getStringResource("CodeSegment.etls_freeHandle.returnCodeNotFound.sasmacro.notrans"), "WARNING%QUOTE(:)", false)).append("   ").append("   ").append("   ").append("   ").append("%let &returnCodeMacroVariable=&statusUnknownReturnCode; \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("%if (&setMainJobRC eq 1) %then \n").append("   ").append("   ").append("   ").append("   ").append("%rcSet(&&&returnCodeMacroVariable); \n").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%let returnCodeMacroVariable=etls_rcmacvar; \n").append("   ").append("   ").append("   ").append("%let &returnCodeMacroVariable=&statusUnknownReturnCode; \n").append("   ").append("   ").append("%end; \n\n");
        code.append("   ").append("   ").append("%local etls_startTimeMacroVarExisted; \n").append("   ").append("   ").append("%let etls_startTimeMacroVarExisted = 0; \n").append("   ").append("   ").append("%if (\"&startTimeMacroVariable\" ne \"\") %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("proc sql noprint; \n").append("   ").append("   ").append("   ").append("   ").append("select '1' into: etls_startTimeMacroVarExisted from dictionary.macros \n").append("   ").append("   ").append("   ").append("   ").append("where name=kupcase(\"&startTimeMacroVariable\"); \n").append("   ").append("   ").append("   ").append("quit; \n\n").append("   ").append("   ").append("   ").append(this.getRCSetCall("&sqlrc", false)).append("   ").append("   ").append("   ").append("%if (&etls_startTimeMacroVarExisted = 0) %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(RB.getStringResource("CodeSegment.etls_freeHandle.startTimeNotFound.sasmacro.notrans"), "WARNING%QUOTE(:)", false)).append("   ").append("   ").append("   ").append("   ").append("%let &startTimeMacroVariable=; \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%end; \n\n");
        code.append("   ").append("   ").append("%local etls_endTimeMacroVarExisted; \n").append("   ").append("   ").append("%let etls_endTimeMacroVarExisted = 0; \n").append("   ").append("   ").append("%if (\"&endTimeMacroVariable\" ne \"\") %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("proc sql noprint; \n").append("   ").append("   ").append("   ").append("   ").append("select '1' into: etls_endTimeMacroVarExisted from dictionary.macros \n").append("   ").append("   ").append("   ").append("   ").append("where name=kupcase(\"&endTimeMacroVariable\"); \n").append("   ").append("   ").append("   ").append("quit; \n\n").append("   ").append("   ").append("   ").append(this.getRCSetCall("&sqlrc", false)).append("   ").append("   ").append("   ").append("%if (&etls_endTimeMacroVarExisted = 0) %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(RB.getStringResource("CodeSegment.etls_freeHandle.endTimeNotFound.sasmacro.notrans"), "WARNING%QUOTE(:)", false)).append("   ").append("   ").append("   ").append("   ").append("%let &endTimeMacroVariable=%sysfunc(datetime()); \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%end; \n\n");
        code.append("   ").append("   ").append("data &statusTable; \n").append("   ").append("   ").append("   ").append("modify &statusTable(where=(&handleVariable = &handleName)); \n").append("   ").append("   ").append("   ").append("%if (\"&startTimeMacroVariable\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("&startTimeVariable = input(symget(\"&startTimeMacroVariable\"),32.);; \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("%if (\"&endTimeVariable\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("%if (\"&endTimeMacroVariable\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("   ").append("&endTimeVariable = input(symget(\"&endTimeMacroVariable\"),32.);; \n").append("   ").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("   ").append("   ").append("   ").append("&endTimeVariable = datetime();; \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("   ").append("%if (\"&returnCodeVariable\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("   ").append("&returnCodeVariable = input(symget(\"&returnCodeMacroVariable\"),32.);; \n").append("   ").append("   ").append("   ").append("%if (\"&statusVariable\" ne \"\") %then \n").append("   ").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("   ").append("if (symget(\"etls_rcMacroVarExisted\") eq \"0\") then \n").append("   ").append("   ").append("   ").append("   ").append("   ").append("&statusVariable = \"").append(RB.getStringResource("CodeSegment.StatusSetting.UnknownStatus.default.txt")).append("\"; \n").append("   ").append("   ").append("   ").append("   ").append("else\n").append("   ").append("   ").append("   ").append("   ").append("   ").append("&statusVariable = &statusSetting;\n").append("   ").append("   ").append("   ").append("%end;\n");
        code.append("   ").append("   ").append("   ").append("call symput('handle',&handleVariable); \n").append("   ").append("   ").append("   ").append("replace; \n").append("   ").append("   ").append("   ").append("stop; \n").append("   ").append("   ").append("run; \n\n");
        code.append("   ").append("   ").append(this.getRCSetCall("&syserr", true)).append("   ").append("   ").append("%if (&signoff eq 1) %then \n").append("   ").append("   ").append("   ").append("%etls_signoff(handleName=&handle); \n").append("   ").append("%end; \n").append("%mend etls_freeHandle; \n\n");
        return code;
    }

    @Override
    public ICodeSegment genParallelFreeHandleMacro() {
        this.addSourceCode(this.getParallelFreeHandleMacro());
        return this;
    }

    public StringBuffer getParallelCreateHandleMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_createHandle");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("handleVariable").addParameter("handlePrefix").addParameter("gridOptionSet").addParameter("workloadMacroVariable").addParameter("row").addParameter("machineVariable").addParameter("statusSetting").addParameter("signon").addParameter("useGrid").addParameter("log").addParameter("output").addParameter("gridRC").addParameter("cmacvar").addParameter("additionalSignonOptions").addParameter("signonRetries");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_createHandle(statusTable=,\n").append("                         statusVariable=,\n").append("                         handleVariable=,\n").append("                         handlePrefix=rmt,\n").append("                         gridOptionSet=,\n").append("                         workloadMacroVariable=,\n").append("                         row=,\n").append("                         machineVariable=,\n").append("                         statusSetting=\"").append(RB.getStringResource("CodeSegment.StatusSetting.Running.default.txt")).append("\", \n").append("                         startTimeVariable=startTime,\n").append("                         signon=1,\n").append("                         useGrid=1,\n").append("                         log=,\n").append("                         output=,\n").append("                         gridRC=,\n").append("                         cmacvar=etls_signonStatus,\n").append("                         additionalSignonOptions=,\n").append("                         signonRetries= ); \n\n").append("   ").append("%local remoteSessionId; \n").append("   ").append("%let remoteSessionId = &handlePrefix.&row; \n").append("   ").append("%let &cmacvar = 1; \n").append("   ").append("%local etls_machineId; \n");
        code.append("   ").append("%if (&signon eq 1) %then \n\n").append("      %etls_signon(handleName=&remoteSessionId,\n").append("                   useGrid=&useGrid,\n").append("                   machineIdMacroVariable=etls_machineId,\n").append("                   gridOptionSet=&etls_gridOptionSet,\n").append("                   workloadMacroVariable=&workloadMacroVariable,\n").append("                   log=&log,\n").append("                   output=&output,\n").append("                   cmacvar=&cmacvar,\n").append("                   gridRC=&gridRC,\n").append("                   additionalSignonOptions=&additionalSignonOptions,\n").append("\t\t\t\t\tsignonRetries=&signonRetries,\n").append("                   gridJobName=DIS_&etls_jobName._&row); \n\n").append("   ").append("%else %let &cmacvar=0; \n\n");
        code.append("   ").append("data &statusTable; \n").append("   ").append("   ").append("retain ptr &row; \n").append("   ").append("   ").append("modify &statusTable point = ptr; \n").append("   ").append("   ").append("&handleVariable = \"&remoteSessionId\"; \n").append("   ").append("   ").append("%if (&signon eq 1) %then \n").append("   ").append("   ").append("   ").append("&machineVariable = \"&etls_machineId\";; \n").append("   ").append("   ").append("%if (&&&cmacvar ne 0) %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("&statusVariable = \"").append(RB.getStringResource("CodeSegment.StatusSetting.FailedSignon.default.txt")).append("\"; \n").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%else \n").append("   ").append("   ").append("   ").append("&statusVariable = &statusSetting;; \n").append("   ").append("   ").append("%if (&startTimeVariable ne ) %then \n").append("   ").append("   ").append("   ").append("&startTimeVariable = datetime();; \n").append("   ").append("   ").append("replace; \n").append("   ").append("   ").append("stop; \n").append("   ").append("run; \n\n").append("   ").append(this.getRCSetCall("&syserr", false)).append("%mend etls_createHandle; \n\n");
        return code;
    }

    @Override
    public ICodeSegment genParallelCreateHandleMacro() {
        this.addSourceCode(this.getParallelCreateHandleMacro());
        return this;
    }

    public StringBuffer getParallelWaitForMacro() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_waitfor");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("runningStatusSetting").addParameter("handleVariable").addParameter("completeStatusSetting").addParameter("endTimeVariable").addParameter("startTimeVariable").addParameter("waitType").addParameter("signoff").addParameter("returnCodeVariable").addParameter("returnCodeMacroVariable").addParameter("statusUnknownReturnCode");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_waitfor(statusTable=, statusVariable=, runningStatusSetting=\"").append(RB.getStringResource("CodeSegment.StatusSetting.Running.default.txt")).append("\", handleVariable=, \n").append("   ").append("completeStatusSetting=\"").append(RB.getStringResource("CodeSegment.StatusSetting.Finish.default.txt")).append("\", endTimeVariable=endTime, \n").append("   ").append("startTimeVariable=startTime, waitType=_ANY_, signoff=1, \n").append("   ").append("returnCodeVariable=, returnCodeMacroVariable=, statusUnknownReturnCode=.); \n\n").append("   ").append("proc sql noprint; \n").append("   ").append("   ").append("select count(*) into :etls_rows \n").append("   ").append("   ").append("   from &statusTable where &statusVariable = &runningStatusSetting; \n").append("   ").append("   ").append("%let etls_rows = &etls_rows; \n").append("   ").append("   ").append("%if (&etls_rows gt 0) %then \n").append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("select &handleVariable into :etlsHandles1 - :etlsHandles&etls_rows \n").append("   ").append("   ").append("   ").append("   from &statusTable where &statusVariable = &runningStatusSetting; \n").append("   ").append("   ").append("%end; \n").append("   ").append("quit; \n\n").append("   ").append(this.getRCSetCall("&sqlrc", true)).append("   ").append("%if (&etls_rows gt 0) %then \n").append("   ").append("%do; \n").append("   ").append("   ").append("waitfor &waitType \n").append("   ").append("   ").append("   ").append("%do i=1 %to &etls_rows; \n").append("   ").append("   ").append("   ").append("   ").append("&&etlsHandles&i \n").append("   ").append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("; \n").append("   ").append("%end; \n\n").append("   ").append("%local useDefaultRCMacVar; \n").append("   ").append("%if (\"&returnCodeMacroVariable\" eq \"\") %then \n").append("   ").append("   ").append("%let useDefaultRCMacVar=Y; \n\n").append("   ").append("%do i=1 %to &etls_rows; \n\n").append("   ").append("   ").append("%if (\"&useDefaultRCMacVar\"=\"Y\") %then \n").append("   ").append("   ").append("   ").append("%let returnCodeMacroVariable=job_rc&&etlsHandles&i; \n\n").append("   ").append("   ").append("waitfor &&etlsHandles&i timeout=1; \n").append("   ").append("   ").append("%if (&SYSRC eq 0) or (&SYSRC eq -2) %then ").append(this.makeComment(RB.getStringResource("CodeSegment.WaitFor.ProcessComplete.comment.txt"))).append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%etls_freeHandle(statusTable=&statusTable, statusVariable=&statusVariable,\n").append("   ").append("   ").append("   ").append("   ").append("handleVariable=&handleVariable, handleName=\"&&etlsHandles&i\", \n").append("   ").append("   ").append("   ").append("   ").append("statusSetting=&completeStatusSetting, endTimeVariable=&endTimeVariable, \n").append("   ").append("   ").append("   ").append("   ").append("startTimeVariable=&startTimeVariable, signoff=&signoff, \n").append("   ").append("   ").append("   ").append("   ").append("returnCodeVariable=&returnCodeVariable, returnCodeMacroVariable=&returnCodeMacroVariable, \n").append("   ").append("   ").append("   ").append("   ").append("statusUnknownReturnCode=&statusUnknownReturnCode, \n").append("   ").append("   ").append("   ").append("   ").append("startTimeMacroVariable=etls_startTime_&&etlsHandles&i., \n").append("   ").append("   ").append("   ").append("   ").append("endTimeMacroVariable=etls_endTime_&&etlsHandles&i. ); \n").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(MessageFormat.format(RB.getStringResource("CodeSegment.WaitFor.ProcessComplete.note.sasmacro.notrans"), "&&etlsHandles&i."), NOTE_LABEL, false)).append("   ").append("   ").append("%end; \n").append("   ").append("   ").append("%else %if (&SYSRC ne -1) %then ").append(this.makeComment(RB.getStringResource("CodeSegment.WaitFor.UnknownStatus.comment.txt"))).append("   ").append("   ").append("%do; \n").append("   ").append("   ").append("   ").append("%etls_freeHandle(statusTable=&statusTable, statusVariable=&statusVariable,\n").append("   ").append("   ").append("   ").append("   ").append("handleVariable=&handleVariable, handleName=\"&&etlsHandles&i\", \n").append("   ").append("   ").append("   ").append("   ").append("statusSetting=\"").append(RB.getStringResource("CodeSegment.StatusSetting.UnknownStatus.default.txt")).append("\", endTimeVariable=&endTimeVariable, \n").append("   ").append("   ").append("   ").append("   ").append("startTimeVariable=&startTimeVariable, signoff=&signoff, \n").append("   ").append("   ").append("   ").append("   ").append("returnCodeVariable=&returnCodeVariable, returnCodeMacroVariable=&returnCodeMacroVariable, \n").append("   ").append("   ").append("   ").append("   ").append("statusUnknownReturnCode=&statusUnknownReturnCode, startTimeMacroVariable=etls_startTime_&&etlsHandles&i ); \n").append("   ").append("   ").append("   ").append(this.getPercentPutStatement(MessageFormat.format(RB.getStringResource("CodeSegment.WaitFor.UnknownStatus.note.sasmacro.notrans"), "&&etlsHandles&i."), NOTE_LABEL, false)).append("   ").append("   ").append("%end; \n").append("   ").append("%end; \n").append("%mend etls_waitfor; \n\n");
        return code;
    }

    public ICodeSegment genParallelWaitForMacro() {
        this.addSourceCode(this.getParallelWaitForMacro());
        return this;
    }

    public StringBuffer getParallelProcessesRunning() {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_getProcessesRunning");
            macro.addParameter("statusTable").addParameter("statusVariable").addParameter("processCountMacro").addParameter("statusSetting");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_getProcessesRunning(statusTable=, statusVariable=, processCountMacro=, \n").append("   ").append("statusSetting=\"").append(RB.getStringResource("CodeSegment.StatusSetting.Running.default.txt")).append("\"); \n\n").append("   ").append("proc sql noprint; \n").append("   ").append("   ").append("select count(*) into: &processCountMacro \n").append("   ").append("   ").append("   ").append("from &statusTable where &statusVariable = &statusSetting; \n").append("   ").append("quit; \n\n").append("   ").append(this.getRCSetCall("&sqlrc", false)).append("%mend etls_getProcessesRunning; \n\n");
        return code;
    }

    public ICodeSegment genParallelProcessesRunning() {
        this.addSourceCode(this.getParallelProcessesRunning());
        return this;
    }

    public String getReturnCodeSetup() {
        return this.getReturnCodeSetup(false);
    }

    @Override
    public String getReturnCodeSetup(boolean bRCSetSYSCCEnabled) {
        StringBuffer code = new StringBuffer();
        code.append(this.makeComment(RB.getStringResource("CodeSegment.ReturnCodeSetup.msg.txt")));
        code.append("%global job_rc trans_rc sqlrc");
        if (bRCSetSYSCCEnabled) {
            code.append(" syscc;\n");
        } else {
            code.append(";\n");
        }
        code.append("%let sysrc = 0;\n").append("%let job_rc = 0;\n").append("%let trans_rc = 0;\n").append("%let sqlrc = 0;\n").append("%let syscc = 0;\n");
        if (bRCSetSYSCCEnabled) {
            code.append("%let syscc = 0;\n");
        }
        code.append("%global etls_stepStartTime; \n").append("/* ").append(RB.getStringResource("CodeSegment.ReturnCodeSyserr.txt")).append(" */ ").append("\ndata _null_; run;\n").append("\n").append(this.getRCSetMacro());
        return code.toString();
    }

    public ICodeSegment genAddIfVersionMacro(String macName, String oper, String version, String sasCode) {
        this.addSourceCode(this.getAddIfVersionMacro(macName, oper, version, sasCode));
        return this;
    }

    public String getAddIfVersionMacro(String macName, String oper, String version, String sasCode) {
        StringBuffer code = new StringBuffer();
        code.append("%macro ").append(macName).append("; \n").append("   ").append("%if %sysevalf(&sysver ").append(oper).append(JCL_INDENT).append(version).append(",boolean) %then ").append(sasCode).append("; \n").append("%mend ").append(macName).append("; \n");
        return code.toString();
    }

    @Override
    public ICodeSegment genPushDownMacroCode() {
        return this.addSourceCode(this.getPushDownMacroCode());
    }

    @Override
    public StringBuffer getPushDownMacroCode() {
        StringBuffer code = new StringBuffer();
        code.append("%global ").append("etls_sql_pushDown").append(";\n");
        code.append("%let ").append("etls_sql_pushDown").append(" = &sys_sql_ip_all;\n\n");
        return code;
    }

    @Override
    public ICodeSegment genReturnCodeRemoteSetup(ISASClientConnection connection, Map additionalMacros, boolean isValidate) {
        this.addSourceCode(this.getReturnCodeRemoteSetup(connection, additionalMacros, isValidate, false));
        return this;
    }

    @Override
    public ICodeSegment genReturnCodeRemoteSetup(ISASClientConnection connection, Map additionalMacros, boolean isValidate, boolean bRCSetSYSCCEnabled) {
        this.addSourceCode(this.getReturnCodeRemoteSetup(connection, additionalMacros, isValidate, bRCSetSYSCCEnabled));
        return this;
    }

    @Override
    public StringBuffer getReturnCodeRemoteSetup(ISASClientConnection connection, Map additionalMacros, boolean isValidate) {
        return this.getReturnCodeRemoteSetup(connection, additionalMacros, isValidate, false);
    }

    @Override
    public StringBuffer getReturnCodeRemoteSetup(ISASClientConnection connection, Map additionalMacros, boolean isValidate, boolean bRCSetSYSCCEnabled) {
        StringBuffer code = new StringBuffer();
        if (connection != null) {
            code.append(this.makeComment(RB.getStringResource("CodeSegment.ReturnCodeRemoteSetup.msg.txt")));
            code.append("data _null_;\n").append("   ").append("if &sysver ge 9 then rmtname = \"/ remote = " + connection.getHostName() + "\";\n").append("   ").append("else rmtname = \"\";\n");
            if (!isValidate) {
                code.append("   ").append("call execute('%syslput job_rc = &job_rc '||rmtname||';');\n").append("   ").append("call execute('%syslput trans_rc = &trans_rc '||rmtname||';');\n").append("   ").append("call execute('%syslput sqlrc = &sqlrc '||rmtname||';');\n");
            }
            if (bRCSetSYSCCEnabled) {
                code.append("   ").append("call execute('%syslput syscc = &syscc '||rmtname||';');\n");
            }
            code.append("   ").append("call execute('%syslput etls_stepStartTime  = &etls_stepStartTime'||rmtname||';');\n");
            if (additionalMacros != null && !additionalMacros.isEmpty()) {
                for (Object next : additionalMacros.keySet()) {
                    String value = MessageFormat.format(additionalMacros.get(next).toString(), connection.getHostAddress());
                    code.append("   ").append("call execute('%syslput ").append(next).append(" = ").append(value).append(" '||rmtname||';');\n");
                }
            }
            code.append("   ").append("call execute('run;');\n").append("run;\n");
        }
        return code;
    }

    @Override
    public ICodeSegment genReturnCodeRemoteEnding(boolean isValidate) {
        return this.addSourceCode(this.getReturnCodeRemoteEnding(isValidate, false, false));
    }

    @Override
    public ICodeSegment genReturnCodeRemoteEnding(boolean isValidate, boolean bGeneratePushdownMacro) {
        return this.addSourceCode(this.getReturnCodeRemoteEnding(isValidate, bGeneratePushdownMacro, false));
    }

    @Override
    public ICodeSegment genReturnCodeRemoteEnding(boolean isValidate, boolean bGeneratePushdownMacro, boolean bRCSetSYSCCEnabled) {
        return this.addSourceCode(this.getReturnCodeRemoteEnding(isValidate, bGeneratePushdownMacro, bRCSetSYSCCEnabled));
    }

    @Override
    public StringBuffer getReturnCodeRemoteEnding(boolean isValidate) {
        return this.getReturnCodeRemoteEnding(isValidate, false, false);
    }

    @Override
    public StringBuffer getReturnCodeRemoteEnding(boolean isValidate, boolean bGeneratePushdownMacro) {
        return this.getReturnCodeRemoteEnding(isValidate, bGeneratePushdownMacro, false);
    }

    @Override
    public StringBuffer getReturnCodeRemoteEnding(boolean isValidate, boolean bGeneratePushdownMacro, boolean bRCSetSYSCCEnabled) {
        StringBuffer code = new StringBuffer();
        if (bGeneratePushdownMacro) {
            code.append("%sysrput ").append("etls_sql_pushDown").append(" = &").append("etls_sql_pushDown").append(" ;\n");
        }
        if (isValidate) {
            return code;
        }
        code.append(this.makeComment(RB.getStringResource("CodeSegment.ReturnCodeRemoteEnding.msg.txt")));
        code.append("%sysrput job_rc = &job_rc ;\n").append("%sysrput trans_rc = &trans_rc ;\n").append("%sysrput sqlrc = &sqlrc ;\n");
        if (bRCSetSYSCCEnabled) {
            code.append("%sysrput ").append(DI_SYSCC_MACRO).append(" = &syscc ;\n");
        }
        return code;
    }

    @Override
    public ICodeSegment genReturnCodeAndPerformanceSetup() {
        return this.genReturnCodeAndPerformanceSetup(false, "SAS Data Integration Studio");
    }

    @Override
    public ICodeSegment genReturnCodeAndPerformanceSetup(boolean bRCSetSYSCCEnabled, String sApplName) {
        if (!this.m_environment.isGeneratedReturnCodeSetup()) {
            if (this.isRunStatisticsEnabled()) {
                this.genInitPerformanceStatistics(this.m_environment.getCurrentServer(), this.isRunTableStatisticsEnabled(), true, sApplName);
            }
            this.addSourceCode(this.getReturnCodeSetup(bRCSetSYSCCEnabled));
        }
        this.m_environment.setGeneratedReturnCodeSetup(true);
        return this;
    }

    @Override
    public String getRCSetMacro() {
        return this.getRCSetMacros(true, true);
    }

    @Override
    public String getRCSetMacros(boolean getMacroVersion, boolean getDSVersion) {
        StringBuffer code = new StringBuffer();
        if (this.m_environment.isGenerateRCSetCalls()) {
            if (getMacroVersion) {
                code.append("%macro rcSet(error); \n").append("   ").append("%if (&error gt &trans_rc) %then \n").append("   ").append("   ").append("%let trans_rc = &error;\n").append("   ").append("%if (&error gt &job_rc) %then \n").append("   ").append("   ").append("%let job_rc = &error;\n").append("%mend rcSet; \n");
            }
            if (getDSVersion) {
                if (getMacroVersion) {
                    code.append("\n");
                }
                code.append("%macro rcSetDS(error); \n").append("   ").append("if &error gt input(symget('trans_rc'),12.) then \n").append("   ").append("   ").append("call symput('trans_rc',trim(left(put(&error,12.))));\n").append("   ").append("if &error gt input(symget('job_rc'),12.) then \n").append("   ").append("   ").append("call symput('job_rc',trim(left(put(&error,12.))));\n").append("%mend rcSetDS; \n");
            }
        }
        return code.toString();
    }

    @Override
    public ICodeSegment genRCSetMacro() {
        this.addSourceCode(this.getRCSetMacro());
        return this;
    }

    @Override
    public String getRCSetCall(String errorVariable, boolean addBlankLine) {
        StringBuffer code = new StringBuffer();
        if (this.m_environment.isGenerateRCSetCalls()) {
            if (errorVariable.length() <= 0) {
                errorVariable = "&sysrc";
            }
            code.append("%rcSet(" + errorVariable + "); \n");
            if (addBlankLine) {
                code.append("\n");
            }
        }
        return code.toString();
    }

    @Override
    public ICodeSegment genRCSetCall(String errorVariable) {
        return this.genRCSetCall(errorVariable, true);
    }

    @Override
    public ICodeSegment genRCSetCall(String errorVariable, boolean addBlankLine) {
        return this.addSourceCode(this.getRCSetCall(errorVariable, addBlankLine));
    }

    @Override
    public String getRCSetDSCall(String errorVariable, boolean addBlankLine) {
        StringBuffer code = new StringBuffer();
        if (this.m_environment.isGenerateRCSetCalls()) {
            if (errorVariable.length() <= 0) {
                errorVariable = "&sysrc";
            }
            code.append("%rcSetDS(" + errorVariable + "); \n");
            if (addBlankLine) {
                code.append("\n");
            }
        }
        return code.toString();
    }

    @Override
    public ICodeSegment genRCSetDSCall(String errorVariable, boolean addBlankLine) {
        return this.addSourceCode(this.getRCSetDSCall(errorVariable, addBlankLine));
    }

    @Override
    public ICodeSegment genRemoteMacroVariablesSetup(List remoteVars, String remoteName) {
        return this.genRemoteMacroVariablesSetup(remoteVars, remoteName, false);
    }

    @Override
    public ICodeSegment genRemoteMacroVariablesSetup(List remoteVars, String remoteName, boolean blankLine) {
        return this.addSourceCode(this.getRemoteMacroVariablesSetup(remoteVars, remoteName, blankLine));
    }

    @Override
    public String getIfInSyntaxCheckMode(boolean bAddThenDo, boolean bNegate) {
        String checkCode = "%if " + (bNegate ? "not " : "") + "(%sysfunc(getoption(OBS))=0 and &syserr ne 0)" + (bAddThenDo ? " %then \n%do;" : "");
        return checkCode;
    }

    @Override
    public ICodeSegment genGOTOErrorCheck(String gotoLinkNameBase) {
        return this.addSourceCode("\n%" + this.getIfInSyntaxCheckMode(false, true) + " %then %goto " + gotoLinkNameBase + "_ERR" + ";\n");
    }

    @Override
    public ICodeSegment genGOTOError(String gotoLinkNameBase) {
        return this.addSourceCode("%goto " + gotoLinkNameBase + "_ERR" + ";\n\n");
    }

    @Override
    public ICodeSegment genGOTOErrorRoutine(String gotoLinkNameBase, String errorSASCode) {
        this.addSourceCode("%goto " + gotoLinkNameBase + "_CONTINUE" + ";\n\n").addSourceCode("%" + gotoLinkNameBase + "_ERR" + ":\n\n");
        if (errorSASCode.equals("")) {
            this.indent().addSourceCode("%let sysrc = 9999; \n").genRCSetCall("&sysrc").unIndent();
        } else {
            this.addSourceCode(errorSASCode);
        }
        this.addSourceCode("%" + gotoLinkNameBase + "_CONTINUE" + ":\n\n");
        return this;
    }

    @Override
    public StringBuffer getRemoteMacroVariablesSetup(List remoteVars, String remoteName) {
        return this.getRemoteMacroVariablesSetup(remoteVars, remoteName, false);
    }

    @Override
    public StringBuffer getRemoteMacroVariablesSetup(List remoteVars, String remoteName, boolean blankLine) {
        int i;
        StringBuffer code = new StringBuffer();
        if (remoteVars == null) {
            return code;
        }
        ArrayList<String> valuesToRemote = new ArrayList<String>();
        for (i = 0; i < remoteVars.size(); ++i) {
            String value = remoteVars.get(i).toString();
            boolean found = false;
            for (int k = 0; k < valuesToRemote.size(); ++k) {
                if (!valuesToRemote.get(k).toString().equalsIgnoreCase(value)) continue;
                found = true;
                break;
            }
            if (found) continue;
            valuesToRemote.add(value);
        }
        if (valuesToRemote != null && !valuesToRemote.isEmpty()) {
            code.append(this.makeComment(RB.getStringResource("CodeSegment.GenerateRemoteMacroVariablesSetup.txt")));
            code.append("data _null_;\n").append("   ").append("if &sysver ge 9 then rmtname = \"/ remote = " + remoteName + "\";\n").append("   ").append("else rmtname = \"\";\n");
            for (i = 0; i < valuesToRemote.size(); ++i) {
                String macroName = valuesToRemote.get(i).toString();
                code.append("   ").append("call execute('%syslput ").append(macroName).append(" = &").append(macroName).append(" '||rmtname||';');\n");
            }
            code.append("   ").append("call execute('run;');\n").append("run;\n");
        }
        if (blankLine) {
            code.append("\n");
        }
        return code;
    }

    public StringBuffer getTSLevelMacro(String macroName, String featureName) {
        StringBuffer code = new StringBuffer();
        if (this.m_generateParallelMacroHeaderComments) {
            SASMacro macro = new SASMacro("etls_tsLevel");
            macro.addParameter("macroName");
            macro.addParameter("featureName");
            code.append(macro.getCommentHeader());
        }
        code.append("%macro etls_tsLevel(macroName=, featureName=); \n").append("   ").append("data _null_; \n").append("   ").append("   ").append("call symput(\"&macroName\",tslvl(\"&featureName\")); \n").append("   ").append("run; \n").append("%mend etls_tsLevel; \n\n");
        return code;
    }

    @Override
    public String getCommentLabelForStep() {
        return this.m_environment.getCommentLabelForStep();
    }

    @Override
    public String getCommentLabelForDescription() {
        return this.m_environment.getCommentLabelForDescription();
    }

    @Override
    public String getCommentLabelForErrorType() {
        return this.m_environment.getCommentLabelForErrorType();
    }

    @Override
    public String getCommentLabelForGeneratedBy() {
        return this.m_environment.getCommentLabelForGeneratedBy();
    }

    @Override
    public String getCommentLabelForGeneratedOn() {
        return this.m_environment.getCommentLabelForGeneratedOn();
    }

    @Override
    public String getCommentLabelForJob() {
        return this.m_environment.getCommentLabelForJob();
    }

    @Override
    public String getCommentLabelForLocation() {
        return this.m_environment.getCommentLabelForLocation();
    }

    @Override
    public String getCommentLabelForMetadataServer() {
        return this.m_environment.getCommentLabelForMetadataServer();
    }

    @Override
    public String getCommentLabelForPort() {
        return this.m_environment.getCommentLabelForPort();
    }

    @Override
    public String getCommentLabelForServer() {
        return this.m_environment.getCommentLabelForServer();
    }

    @Override
    public String getCommentLabelForTransform() {
        return this.m_environment.getCommentLabelForTransform();
    }

    @Override
    public String getCommentLabelForUserWritten() {
        return this.m_environment.getCommentLabelForUserWritten();
    }

    @Override
    public String getCommentLabelForVersion() {
        return this.m_environment.getCommentLabelForVersion();
    }

    @Override
    public String getCommentLabelForSource() {
        return this.m_environment.getCommentLabelForSource();
    }

    @Override
    public String getCommentLabelForSources() {
        return this.m_environment.getCommentLabelForSources();
    }

    @Override
    public String getCommentLabelForTarget() {
        return this.m_environment.getCommentLabelForTarget();
    }

    @Override
    public String getCommentLabelForTargets() {
        return this.m_environment.getCommentLabelForTargets();
    }

    public StringBuffer getCommentLine(String label) {
        return this.getCommentLine(label, "", "");
    }

    public StringBuffer getCommentLine(String label, String name) {
        return this.getCommentLine(label, name, "");
    }

    @Override
    public StringBuffer getCommentLine(String label, String name, String ID) {
        StringBuffer line = new StringBuffer();
        int labelAndID = label.length() + ID.length() + 1;
        int nameLength = 72 - labelAndID;
        List<String> nameList = this.splitString(name, nameLength, true);
        String labelPad = this.repeat(JCL_INDENT, label.length());
        String IDPad = this.repeat(JCL_INDENT, ID.length());
        if (nameList.size() <= 0) {
            String pad = this.repeat(JCL_INDENT, 72 - label.length());
            line.append(" * ").append(label).append(pad).append(" * \n");
        }
        for (int i = 0; i < nameList.size(); ++i) {
            String blanks;
            int pad;
            String currentName = nameList.get(i);
            String currentLabel = labelPad;
            String currentID = IDPad;
            if (i == 0) {
                currentLabel = label;
                currentID = ID;
            }
            line.append(" * ").append(currentLabel).append(currentName);
            if (currentID.length() > 0) {
                pad = 78 - (23 + currentLabel.length() + currentName.length());
                blanks = this.repeat(JCL_INDENT, pad);
                line.append(blanks).append(currentID).append(" *");
            } else {
                pad = 78 - (6 + currentLabel.length() + currentName.length());
                blanks = this.repeat(JCL_INDENT, pad);
                line.append(blanks).append(" *");
            }
            line.append(" \n");
        }
        return line;
    }

    @Override
    public ICodeSegment genCommentLine() {
        return this.genCommentLine("", "", "");
    }

    @Override
    public ICodeSegment genCommentLine(String line) {
        List<String> lines = this.splitString(line, 72, false);
        return this.genCommentLine(lines);
    }

    @Override
    public ICodeSegment genCommentLine(List lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String singleLine = (String)lines.get(i);
            int pad = 78 - (6 + singleLine.length());
            String blanks = this.repeat(JCL_INDENT, pad);
            this.addSourceCode(" * ").addSourceCode(singleLine).addSourceCode(blanks).addSourceCode(" * \n");
        }
        return this;
    }

    @Override
    public ICodeSegment genCommentTableLine(IDataObject[] tableList, String singularLabel, String pluralLabel) throws CodegenException, BadLibraryDefinitionException {
        if (tableList.length <= 0) {
            return this;
        }
        String label = singularLabel;
        if (tableList.length > 1) {
            label = pluralLabel;
        }
        String blankLabel = this.repeat(JCL_INDENT, label.length());
        for (int i = 0; i < tableList.length; ++i) {
            String metadataName;
            if (!(tableList[i] instanceof ITable)) continue;
            ITable table = (ITable)tableList[i];
            String tableName = table.getFullNameQuotedAsNeeded(this);
            String name = metadataName = table.getName();
            if (tableName.length() > 0 && !tableName.equals(metadataName)) {
                name = name + " - " + tableName;
            }
            String id = table.getID();
            if (i == 0) {
                this.genCommentLine(label, name, id);
                continue;
            }
            this.genCommentLine(blankLabel, name, id);
        }
        return this;
    }

    @Override
    public ICodeSegment genCommentValidateUnsupported(String divider) {
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("\n");
        this.genCommentLine();
        this.genCommentLine(RB.getStringResource("CodeSegment.ValidateUnsupported.msg.txt"));
        this.genCommentLine();
        return this;
    }

    @Override
    public ICodeSegment genCommentValidateExplicitOn(String divider) {
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("\n");
        this.genCommentLine();
        this.genCommentLine(RB.getStringResource("CodeSegment.ValidateExplicitOn.msg.txt"));
        this.genCommentLine();
        return this;
    }

    @Override
    public ICodeSegment genCommentNotActive(String divider) {
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("\n");
        this.genCommentLine();
        this.genCommentLine(RB.getStringResource("CodeSegment.DoNotGenerate.msg.txt"));
        this.genCommentLine();
        return this;
    }

    @Override
    public void genCommentNotesLine(INotesContainer noteContainer, String divider) {
        INote[] noteList = noteContainer.getNotes();
        ArrayList<String> notes = new ArrayList<String>();
        for (int i = 0; i < noteList.length; ++i) {
            StringBuffer textString = this.parseNote(noteList[i]);
            String[] lines = textString.toString().split("\\n");
            ArrayList<String> tempNotes = new ArrayList<String>();
            for (String line : lines) {
                List<String> s = this.splitString(line, 70, true);
                if (s.isEmpty()) {
                    tempNotes.add("");
                    continue;
                }
                for (String ls : s) {
                    tempNotes.add(JCL_INDENT.concat(ls));
                }
            }
            if (i > 0 && textString.length() > 0) {
                notes.add(JCL_INDENT);
            }
            notes.add(noteList[i].getName());
            notes.addAll(tempNotes);
        }
        String privateNote = noteContainer.getPrivateNote();
        if (notes.size() > 0 || privateNote != null && privateNote.length() > 0) {
            this.addSourceCode(" *").addSourceCode(divider).addSourceCode("\n");
        }
        if (privateNote != null && privateNote.length() > 0) {
            String[] pNotes = privateNote.split("\\n");
            this.genCommentLine(RB.getStringResource("CodeSegment.CommentLabel.QuickNote.txt"));
            ArrayList<String> pList = new ArrayList<String>();
            for (int i = 0; i < pNotes.length; ++i) {
                pList.addAll(this.splitString(pNotes[i], 71, true));
            }
            this.genCommentLine(pList);
            if (notes.size() > 0) {
                this.genCommentLine();
            }
        }
        if (notes.size() > 0) {
            this.genCommentLine(RB.getStringResource("CodeSegment.CommentLabel.Notes.txt"));
            this.genCommentLine(notes);
        }
    }

    private StringBuffer parseNote(INote note) {
        final StringBuffer textString = new StringBuffer();
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t.breaksFlow()) {
                    // empty if block
                }
            }

            @Override
            public void handleText(char[] data, int pos) {
                textString.append(data);
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (HTML.Tag.BR == t || HTML.Tag.P == t) {
                    textString.append("\n");
                }
            }
        };
        try {
            StringReader reader = new StringReader(note.getText());
            new ParserDelegator().parse(reader, callback, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return textString;
    }

    @Override
    public ICodeSegment genCommentUserWrittenLine(ICodeGenerator object, String label) {
        if (object.isUsingUserWrittenCode()) {
            ICodeSource text = object.getUserWrittenCode().getUserWrittenSourceCode();
            if (text == null) {
                return this;
            }
            this.genCommentLine();
            if (text instanceof IFile) {
                IFile file = (IFile)text;
                IServer server = file.getServer();
                this.genCommentLine(label, file.getName() + ": " + (server != null ? server.getName() + " @ " : "") + file.getFileName(), "");
            } else {
                this.genCommentLine(label, text.getName(), "");
            }
            if (text.getDescription().length() > 0) {
                this.genCommentLine(this.repeat(JCL_INDENT, label.length()), text.getDescription(), "");
            }
        }
        return this;
    }

    @Override
    public ICodeSegment genCommentLine(String label, String name, String ID) {
        return this.addSourceCode(this.getCommentLine(label, name, ID));
    }

    @Override
    public ICodeSegment genCommentLine(String label, IObject object) {
        if (object == null) {
            return this;
        }
        this.genCommentLine(label, object.getName(), object.getID());
        return this;
    }

    public boolean isJobDateFormatNLS(AbstractTransformation mObject) throws MdException, RemoteException {
        Job job = null;
        boolean isNLSFormat = false;
        if (mObject != null) {
            TransformationActivity act;
            AssociationList jobs;
            TransformationStep step;
            AssociationList acts;
            ClassifierMap map;
            AssociationList steps;
            if (mObject instanceof Job) {
                job = (Job)mObject;
            } else if (mObject instanceof TransformationStep) {
                TransformationActivity act2;
                AssociationList jobs2;
                TransformationStep step2 = (TransformationStep)mObject;
                AssociationList acts2 = step2.getActivities();
                if (!acts2.isEmpty() && !(jobs2 = (act2 = (TransformationActivity)acts2.get(0)).getJobs()).isEmpty()) {
                    job = (Job)jobs2.get(0);
                }
            } else if (mObject instanceof ClassifierMap && !(steps = (map = (ClassifierMap)mObject).getSteps()).isEmpty() && !(acts = (step = (TransformationStep)steps.get(0)).getActivities()).isEmpty() && !(jobs = (act = (TransformationActivity)acts.get(0)).getJobs()).isEmpty()) {
                job = (Job)jobs.get(0);
            }
            if (job != null) {
                // empty if block
            }
        }
        return isNLSFormat;
    }

    @Override
    public ICodeSegment genPutStatement(String msg) {
        return this.addSourceCode(this.getPutStatement(msg, NOTE_LABEL));
    }

    @Override
    public ICodeSegment genPutStatement(String msg, String label) {
        return this.addSourceCode(this.getPutStatement(msg, label));
    }

    @Override
    public ICodeSegment genPutStatement(String msg, String label, boolean splitLabel) {
        return this.addSourceCode(this.getPutStatement(msg, label, splitLabel));
    }

    @Override
    public ICodeSegment genPutStatement(String msg, String label, String sasvar, boolean splitLabel) {
        return this.addSourceCode(this.getPutStatement(msg, label, sasvar, splitLabel));
    }

    @Override
    public StringBuffer getPutStatement(String msg) {
        return this.getPutStatement(msg, NOTE_LABEL);
    }

    @Override
    public StringBuffer getPutStatement(String msg, String label) {
        return this.getPutStatement(msg, label, false);
    }

    @Override
    public StringBuffer getPutStatement(String msg, String label, boolean splitLabel) {
        return this.getPutStatement(msg, label, "", false);
    }

    @Override
    public StringBuffer getPutStatement(String msg, String label, String sasvar, boolean splitLabel) {
        StringBuffer message = new StringBuffer("put ");
        boolean isSasVarSet = sasvar.length() > 0;
        String newLabel = label;
        if (splitLabel) {
            message.append("\"" + newLabel.replaceAll(":", "\" "));
            newLabel = ":";
        }
        StringBuffer msgBuff = new StringBuffer(msg);
        if (isSasVarSet) {
            msgBuff.append(JCL_INDENT);
        }
        message.append(this.splitString(newLabel + JCL_INDENT + msgBuff.toString(), 68, false, "     ", true));
        if (!isSasVarSet) {
            message.append(";\n");
        } else {
            message.append(JCL_INDENT).append(sasvar).append(";\n");
        }
        return message;
    }

    @Override
    public ICodeSegment genPercentPutStatement(String msg, String label, boolean usePercentStr) {
        this.addSourceCode(this.getPercentPutStatement(msg, label, usePercentStr));
        return this;
    }

    @Override
    public ICodeSegment genPercentPutStatement(String msg) {
        return this.genPercentPutStatement(msg, NOTE_LABEL);
    }

    @Override
    public ICodeSegment genPercentPutStatement(String msg, String label) {
        return this.genPercentPutStatement(msg, label, true);
    }

    public StringBuffer getPercentPutStatement(String msg) {
        return this.getPercentPutStatement(msg, NOTE_LABEL);
    }

    public StringBuffer getPercentPutStatement(String msg, String label) {
        return this.getPercentPutStatement(msg, label, true);
    }

    @Override
    public StringBuffer getPercentPutStatement(String msg, String label, boolean usePercentStr) {
        StringBuffer message = new StringBuffer("%put ");
        if (usePercentStr) {
            message.append("%str(");
            msg = this.getEscapedMacroValue(msg);
        }
        message.append(label).append(JCL_INDENT).append(this.splitString(msg, 68, false, "     ", false));
        if (usePercentStr) {
            message.append(")");
        }
        message.append(";\n");
        return message;
    }

    public String getAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needQuotes) throws MdException, RemoteException {
        return this.getAttrib(column, isDataStep, passthru, needLabel, needFormats, needFormats, needQuotes);
    }

    public String getAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needInformats, boolean needQuotes) throws MdException, RemoteException {
        String columnDesc;
        String columnInformat;
        String columnFormat;
        StringBuffer attrib = new StringBuffer("");
        String columnName = column.getSASColumnName();
        if (columnName == null || columnName.length() == 0) {
            return "";
        }
        attrib.append(columnName).append(" length = ");
        String columnType = column.getSASColumnType();
        int columnLength = column.getSASColumnLength();
        if (columnType.equalsIgnoreCase("C") && isDataStep) {
            attrib.append("$");
        }
        attrib.append(columnLength);
        if (needFormats && (columnFormat = column.getSASFormat()) != null && columnFormat.length() > 0) {
            attrib.append(" format = " + columnFormat);
        }
        if (needInformats && (columnInformat = column.getSASInformat()) != null && columnInformat.length() > 0) {
            attrib.append(" informat = " + columnInformat);
        }
        if ((columnDesc = column.getDesc()) != null && columnDesc.length() > 0 && needLabel) {
            columnDesc = columnDesc.replaceAll("'", "''");
            attrib.append("\nlabel = '").append(columnDesc).append("'");
        }
        String stmt = attrib.toString();
        stmt = isDataStep ? "attrib " + stmt.replaceAll("\n", "\n          ") + "; \n" : stmt.replaceAll("\n", "\n          ");
        return stmt;
    }

    public CodeSegment genAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needQuotes) throws MdException, RemoteException {
        this.addSourceCode(this.getAttrib(column, isDataStep, passthru, needLabel, needFormats, needQuotes));
        return this;
    }

    public CodeSegment genAttrib(Column column, boolean isDataStep, boolean passthru, boolean needLabel, boolean needFormats, boolean needInformats, boolean needQuotes) throws MdException, RemoteException {
        this.addSourceCode(this.getAttrib(column, isDataStep, passthru, needLabel, needFormats, needInformats, needQuotes));
        return this;
    }

    public String getQuotedColumnName(Column column, boolean quoted) throws MdException, RemoteException {
        String columnName = column.getSASColumnName();
        DataTable table = column.getTable();
        return columnName;
    }

    @Override
    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent, boolean useTableNameAsAlias) {
        if (columnList == null || columnList.size() == 0) {
            return "";
        }
        if (indent == null) {
            indent = this.m_indentString;
        }
        if (!delimiter.equals(JCL_INDENT)) {
            delimiter = delimiter + JCL_INDENT;
        }
        if ((tableAlias = tableAlias.trim()).length() > 0) {
            tableAlias = tableAlias.concat(".");
        }
        StringBuffer columnString = new StringBuffer();
        int currentLineLength = spacesToIndentNextLines.length() + indent.length();
        for (int i = 0; i < columnList.size(); ++i) {
            String columnName;
            Object obj = columnList.get(i);
            if (obj instanceof String) {
                columnName = needQuotes ? DBMSNamesUtil.getQuotedString((String)obj, passthru) : (String)obj;
            } else {
                if (!(obj instanceof IColumn)) continue;
                IColumn column = (IColumn)obj;
                if (useTableNameAsAlias && (tableAlias == null || tableAlias.length() == 0) && column.getTable() instanceof IPhysicalTable) {
                    IPhysicalTable table = (IPhysicalTable)column.getTable();
                    tableAlias = table.getSASTableName().concat(".");
                }
                columnName = column.getColumnName(needQuotes, passthru);
            }
            if (oneColumnPerLine) {
                if (i > 0) {
                    columnString.append(delimiter).append("\n").append(spacesToIndentNextLines);
                }
            } else {
                if (i > 0) {
                    columnString.append(delimiter);
                }
                if (currentLineLength + columnName.length() + tableAlias.length() > 78) {
                    columnString.append("\n").append(spacesToIndentNextLines);
                    currentLineLength = spacesToIndentNextLines.length() + indent.length();
                }
                currentLineLength = currentLineLength + columnName.length() + tableAlias.length() + delimiter.length();
            }
            if (tableAlias.length() > 0) {
                columnString.append(tableAlias);
            }
            columnString.append(columnName);
        }
        return columnString.toString();
    }

    @Override
    public String makeColumnListWithTableNames(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent, boolean useTableNameAsAlias) {
        String originalAlias = tableAlias;
        if (columnList == null || columnList.size() == 0) {
            return "";
        }
        if (indent == null) {
            indent = this.m_indentString;
        }
        if (!delimiter.equals(JCL_INDENT)) {
            delimiter = delimiter + JCL_INDENT;
        }
        if ((tableAlias = tableAlias.trim()).length() > 0) {
            tableAlias = tableAlias.concat(".");
        }
        StringBuffer columnString = new StringBuffer();
        int currentLineLength = spacesToIndentNextLines.length() + indent.length();
        for (int i = 0; i < columnList.size(); ++i) {
            String columnName;
            Object obj = columnList.get(i);
            if (obj instanceof String) {
                columnName = needQuotes ? DBMSNamesUtil.getQuotedString((String)obj, passthru) : (String)obj;
            } else {
                if (!(obj instanceof IColumn)) continue;
                IColumn column = (IColumn)obj;
                if (useTableNameAsAlias && (tableAlias == null || tableAlias.length() == 0) && column.getTable() instanceof IPhysicalTable || useTableNameAsAlias && (originalAlias == null || originalAlias.length() == 0) && column.getTable() instanceof IPhysicalTable) {
                    IPhysicalTable table = (IPhysicalTable)column.getTable();
                    tableAlias = table.getSASTableName().concat(".");
                }
                columnName = column.getColumnName(needQuotes, passthru);
            }
            if (oneColumnPerLine) {
                if (i > 0) {
                    columnString.append(delimiter).append("\n").append(spacesToIndentNextLines);
                }
            } else {
                if (i > 0) {
                    columnString.append(delimiter);
                }
                if (currentLineLength + columnName.length() + tableAlias.length() > 78) {
                    columnString.append("\n").append(spacesToIndentNextLines);
                    currentLineLength = spacesToIndentNextLines.length() + indent.length();
                }
                currentLineLength = currentLineLength + columnName.length() + tableAlias.length() + delimiter.length();
            }
            if (tableAlias.length() > 0) {
                columnString.append(tableAlias);
            }
            columnString.append(columnName);
        }
        return columnString.toString();
    }

    @Override
    public ICodeSegment genGetNumRows(String tableName, String tableOptions, String macroVariable, boolean hasDeletedRows) {
        return this.genGetNumRows(tableName, tableOptions, macroVariable, hasDeletedRows, GLOBAL_ALL);
    }

    @Override
    public StringBuffer getNoSyntaxCheck(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append("%local etls_syntaxcheck; \n").append(indent).append("%let etls_syntaxcheck = %sysfunc(getoption(syntaxcheck)); \n").append(indent).append(this.makeComment(RB.getStringResource("CodeSegment.SyntaxCheck.Note.txt"))).append(indent).append("options nosyntaxcheck;\n");
        return synCode;
    }

    @Override
    public StringBuffer getObsMaxSet() {
        return this.getObsMaxSet("");
    }

    @Override
    public StringBuffer getObsMaxSet(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append("%local etls_obs; \n").append(indent).append("%let etls_obs = %sysfunc(getoption(obs)); \n").append(indent).append(this.makeComment(RB.getStringResource("CodeSegment.ObsMax.Note.txt"))).append(indent).append("options obs = max;\n");
        return synCode;
    }

    @Override
    public StringBuffer getResetObs() {
        return this.getResetObs("");
    }

    @Override
    public StringBuffer getResetObs(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append(this.makeComment(RB.getStringResource("CodeSegment.ResetObs.Note.txt"))).append(indent).append("options obs = &etls_obs; \n");
        return synCode;
    }

    @Override
    public StringBuffer getResetSyntaxCheck(String indent) {
        StringBuffer synCode = new StringBuffer();
        synCode.append(indent).append(this.makeComment(RB.getStringResource("CodeSegment.ResetSyntaxCheck.Note.txt"))).append(indent).append("options &etls_syntaxcheck; \n");
        return synCode;
    }

    @Override
    public ICodeSegment genGetNumRows(String tableName, String tableOptions, String macroVariable, boolean hasDeletedRows, String maxRowsToCount) {
        return this.genGetNumRows(tableName, tableOptions, macroVariable, hasDeletedRows, maxRowsToCount, "");
    }

    public ICodeSegment genGetNumRows(String tableName, String tableOptions, String macroVariable, boolean hasDeletedRows, String maxRowsToCount, String whereClause) {
        this.addSourceCode("%let ").addSourceCode(CHECK_EXIST_MACROVAR_NAME).addSourceCode(" = 0; \n");
        this.addSourceCode("%let ").addSourceCode(macroVariable).addSourceCode(" = 0; \n");
        this.addSourceCode("%macro etls_recordCheck; \n").indent();
        this.genTableExist(tableName, null, CHECK_EXIST_MACROVAR_NAME, false);
        this.addSourceCode("%if (&etls_recCheckExist) %then\n");
        this.addSourceCode("%do;\n");
        this.indent();
        this.addSourceCode(this.getNoSyntaxCheck("")).addSourceCode("\n");
        if (!whereClause.equals("")) {
            whereClause = " where=(" + whereClause + ")";
        }
        if (!maxRowsToCount.equals(GLOBAL_ALL)) {
            this.addSourceCode("data _null_; \n").indent();
            if (maxRowsToCount.equals("1")) {
                this.addSourceCode("set ").addSourceCode(tableName).addSourceCode("(");
                if (tableOptions != null && tableOptions.length() > 0) {
                    this.addSourceCode(tableOptions).addSourceCode(JCL_INDENT);
                }
                this.addSourceCode(whereClause).addSourceCode(" obs=1 ); \n").addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\",'1'); \n");
            } else {
                this.addSourceCode("do until(_ptr=").addSourceCode(maxRowsToCount).addSourceCode(" or _eof); \n").indent().addSourceCode("set ").addSourceCode(tableName).addSourceCode("(");
                if (tableOptions != null && tableOptions.length() > 0) {
                    this.addSourceCode(tableOptions).addSourceCode(JCL_INDENT);
                }
                this.addSourceCode(whereClause).addSourceCode(")").addSourceCode(" end = _eof; \n").addSourceCode("etls_ptr+1; \n").unIndent().addSourceCode("end; \n").addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\",trim(left(put(etls_ptr,16.))) ); \n").addSourceCode("stop; \n");
            }
            this.unIndent().addSourceCode("run; \n");
        } else if (hasDeletedRows) {
            this.addSourceCode("proc contents data = ").addSourceCode(tableName);
            if (tableOptions != null && tableOptions.length() > 0) {
                this.addSourceCode(" (").addSourceCode(tableOptions).addSourceCode(")\n");
            }
            this.addSourceCode(" out = ").addSourceCode(WORK_LIBREF).addSourceCode(".etls_contents(keep = nobs) noprint; \n").addSourceCode("run; \n\n").addSourceCode("data _null_; \n").indent().addSourceCode("set ").addSourceCode(WORK_LIBREF).addSourceCode(".etls_contents (obs = 1); \n").addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\", left(put(nobs,32.))); \n").unIndent().addSourceCode("run;\n\n").genTableDelete("work.etls_contents");
        } else {
            this.addSourceCode("data _null_; \n\n").indent().addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\", left(put(nobs,32.))); \n").addSourceCode("stop; \n").addSourceCode("set ").addSourceCode(tableName);
            if (tableOptions != null && tableOptions.length() > 0) {
                this.addSourceCode(JCL_INDENT).addSourceCode(tableOptions);
            }
            this.addSourceCode(" nobs = nobs;\n\n").unIndent().addSourceCode("run; \n");
        }
        this.addSourceCode(this.getResetSyntaxCheck(""));
        this.unIndent();
        this.addSourceCode("%end;\n");
        this.unIndent();
        this.addSourceCode("%mend etls_recordCheck;\n");
        this.addSourceCode("%etls_recordCheck;\n\n");
        return this;
    }

    @Override
    public StringBuffer getSectionComment(String msg) {
        StringBuffer comment = new StringBuffer();
        String marker = this.repeat("-", 4);
        int lineLength = 78 - (6 + 2 * marker.length() + this.getIndentString().length());
        List<String> lineList = this.splitString(msg, lineLength, true);
        for (int i = 0; i < lineList.size(); ++i) {
            String line = lineList.get(i);
            comment.append("/*").append(marker).append(JCL_INDENT).append(line).append(JCL_INDENT).append(marker).append("*/ \n");
        }
        return comment;
    }

    @Override
    public ICodeSegment addSectionComment(String msg) {
        return this.addSourceCode(this.getSectionComment(msg));
    }

    public String makeColumnList(ITable table, String spacesToIndentNextLines, boolean needQuotes, String indent) {
        if (table == null) {
            return null;
        }
        IColumn[] columnList = table.getColumns();
        return this.makeColumnList(Arrays.asList(columnList), false, spacesToIndentNextLines, false, JCL_INDENT, "", needQuotes, indent, false);
    }

    @Override
    public String makeColumnList(ITable table, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean needQuotes, String indent) {
        if (table == null) {
            return null;
        }
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        return this.makeColumnList(columnList, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, needQuotes, indent, false);
    }

    @Override
    public String makeColumnList(IColumn[] columns, String spacesToIndentNextLines, boolean needQuotes, String delimiter) {
        return this.makeColumnList(Arrays.asList(columns), spacesToIndentNextLines, needQuotes, delimiter);
    }

    @Override
    public String makeColumnList(List columnList, String spacesToIndentNextLines, boolean needQuotes, String delimiter) {
        return this.makeColumnList(columnList, false, spacesToIndentNextLines, false, delimiter, "", needQuotes, "", false);
    }

    @Override
    public String makeColumnList(List columnList, String spacesToIndentNextLines, boolean needQuotes) {
        return this.makeColumnList(columnList, false, spacesToIndentNextLines, false, JCL_INDENT, "", needQuotes, "", false);
    }

    @Override
    public String makeComment(String msg) {
        int lineLength = 72;
        List<String> lineList = this.splitString(msg, lineLength, true);
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < lineList.size(); ++i) {
            String line = lineList.get(i);
            code.append("/* ").append(line).append(" */ \n");
        }
        return code.toString();
    }

    @Override
    public List<String> splitString(String string, int lineLength, boolean pad) {
        return this.splitString(string, lineLength, pad, false);
    }

    public List<String> splitString(String string, int lineLength, boolean pad, boolean bPutStatement) {
        List<String> lineList = new ArrayList<String>();
        if (string == null) {
            return lineList;
        }
        string = string.replaceAll("\n", "").replaceAll("\r", "");
        while (string.length() > 0) {
            if (string.length() <= lineLength) {
                lineList.add(string);
                break;
            }
            String blank = "X";
            int index = lineLength + 1;
            while (!blank.equals(JCL_INDENT) && index > 0) {
                blank = string.substring(--index, index + 1);
            }
            if (index <= 0) {
                index = lineLength - 1;
            }
            String line = bPutStatement ? string.substring(0, index) : string.substring(0, index).trim();
            lineList.add(line);
            string = string.substring(index);
        }
        if (pad) {
            lineList = this.padStrings(lineList);
        }
        return lineList;
    }

    public String splitString(String string, int lineLength, boolean pad, String spacesToIndentNextLines, boolean quoteEachLine) {
        List<String> lineList = this.splitString(string, lineLength, pad, true);
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < lineList.size(); ++i) {
            if (i > 0) {
                text.append("\n").append(spacesToIndentNextLines);
            }
            String line = lineList.get(i);
            if (quoteEachLine) {
                line = "\"" + line.replaceAll("\"", "\"\"") + "\"";
            }
            text.append(line);
        }
        return text.toString();
    }

    public List<String> padStrings(List<String> list) {
        String text;
        int i;
        int maxLength = 0;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i);
            maxLength = Math.max(maxLength, text.length());
        }
        ++maxLength;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i);
            text = text + this.repeat(JCL_INDENT, maxLength - text.length());
            list.set(i, text);
        }
        return list;
    }

    @Override
    public String repeat(String repeatString, int numRepeats) {
        return this.m_environment.repeat(repeatString, numRepeats);
    }

    @Override
    public String getEscapedMacroValue(String string) {
        if (!string.startsWith("%str(")) {
            string = string.replaceAll("%", "%%").replaceAll("'", "%'").replaceAll("\"", "%\"").replaceAll("[(]", "%(").replaceAll("[)]", "%)");
        }
        return string;
    }

    @Override
    public boolean isEscapedMacroValue(String string) {
        boolean foundEscapeChar = false;
        if (!string.startsWith("%str(")) {
            foundEscapeChar = string.indexOf("%") != -1 ? true : (string.indexOf("'") != -1 ? true : (string.indexOf("\"") != -1 ? true : (string.indexOf("(") != -1 ? true : string.indexOf(")") != -1)));
        }
        return foundEscapeChar;
    }

    public static StringBuffer getLabelStatement(String desc) {
        StringBuffer labelStatement = new StringBuffer();
        String desc2 = desc;
        if (desc2 != null && desc2.length() > 0) {
            desc2 = desc2.replaceAll("'", "''");
            labelStatement.append("label = '").append(desc2).append("'");
        }
        return labelStatement;
    }

    @Override
    public int getEnvironmentStartPosition() {
        return this.m_startPosition;
    }

    @Override
    public void setStartPosition(int start) {
        this.m_startPosition = start;
    }

    @Override
    public int getEnvironmentEndPosition() {
        return this.m_endPosition;
    }

    @Override
    public void setEndPosition(int end) {
        this.m_endPosition = end;
    }

    @Override
    public ICodeSegment genUserWrittenCode(ICodeGenerator code) throws ServerException, CodegenException {
        return this.genUserWrittenCode(code, true);
    }

    @Override
    public ICodeSegment genUserWrittenCode(ICodeGenerator code, boolean addRCSet) throws CodegenException, ServerException {
        return this.genCodeSource(code.getUserWrittenCode().getUserWrittenSourceCode(), addRCSet, USER_WRITTEN_START_COMMENT, USER_WRITTEN_END_COMMENT);
    }

    @Override
    public ICodeSegment genCodeSource(ICodeSource sourceCode, String beginningComment, String endingComment) throws CodegenException, ServerException {
        return this.genCodeSource(sourceCode, true, beginningComment, endingComment);
    }

    @Override
    public ICodeSegment genSaveSyslast() {
        return this.addSourceCode("%let ETLS_SYSLAST = &SYSLAST;\n");
    }

    @Override
    public ICodeSegment genRestoreSyslast() {
        return this.addSourceCode("%let SYSLAST = &ETLS_SYSLAST;\n\n");
    }

    @Override
    public ICodeSegment genCodeSource(ICodeSource sourceCode, boolean addRCSet, String beginningComment, String endingComment) throws CodegenException, ServerException {
        if (sourceCode == null) {
            throw new CodegenException(RB.getStringResource("CodeSegment.NoSourceCode.msg.txt"), (IObject)sourceCode);
        }
        this.addSectionComment(beginningComment).addSourceCode("\n");
        this.addSourceCode(sourceCode.getCode());
        this.addSourceCode("\n").addSectionComment(endingComment);
        this.addSourceCode("\n");
        if (addRCSet) {
            this.genRCSetCall("&syserr", false);
            this.genRCSetCall("&sqlrc");
        }
        return this;
    }

    @Override
    public ICodeSegment genDiagnosticMessage(String message) {
        return this.genDiagnosticMessage(message, false);
    }

    @Override
    public ICodeSegment genDiagnosticMessage(String message, boolean usePercentPut) {
        if (!usePercentPut) {
            this.addSourceCode("data _null_;\n").indent().genPutStatement(message, "ETLS_DIAG%QUOTE(:)").unIndent().addSourceCode("run;\n");
        } else {
            this.genPercentPutStatement(message, "ETLS_DIAG%QUOTE(:)", true);
        }
        return this;
    }

    @Override
    public ICodeSegment genDiagnosticTableExists(IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        this.addSourceCode("%macro etls_checkTable;\n").indent();
        table.genTableExist(this, "etls_tableExist").addSourceCode("%if (&etls_tableExist eq 0) %then\n").addSourceCode("%do;\n").indent().genDiagnosticMessage("Table " + table.getName() + "(" + table.getFullNameQuotedAsNeeded(this.getCurrentServer(), false, false) + ") does not exist.").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%mend;\n").addSourceCode("%etls_checkTable;\n\n");
        return this;
    }

    @Override
    public ICodeSegment genSyslast(IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        this.addSourceCode("%let SYSLAST = %nrquote(" + table.getFullNameQuotedAsNeeded(this) + "); \n\n");
        return this;
    }

    @Override
    public ICodeSegment genTableExist(String tableName, String macroVariable) {
        return this.genTableExist(tableName, null, macroVariable, false);
    }

    @Override
    public ICodeSegment genTableExist(String tableName, String typeOfTable, String macroVariable) {
        return this.genTableExist(tableName, null, macroVariable, false);
    }

    @Override
    public ICodeSegment genTableExist(String tableName, String typeOfTable, String macroVariable, boolean genComment) {
        return this.addSourceCode(this.getTableExist(tableName, typeOfTable, macroVariable, genComment));
    }

    public StringBuffer getTableExist(String tableName, String typeOfTable, String macroVariable, boolean genComment) {
        StringBuffer code = new StringBuffer();
        if (genComment) {
            code.append(this.makeComment(RB.getStringResource("CodeSegment.Exist.msg.notrans")));
        }
        String macroVarTrim = macroVariable.trim();
        if (typeOfTable == null || typeOfTable.length() == 0) {
            code.append("%let ").append(macroVarTrim).append(" = %eval(%sysfunc(exist(").append(tableName).append(", ").append("DATA").append(")) or \n ").append("     ").append("%sysfunc(exist(").append(tableName).append(", ").append("VIEW").append("))); \n\n");
        } else {
            code.append("%let ").append(macroVarTrim).append(" = %sysfunc(exist(").append(tableName).append(", ").append(typeOfTable).append("));\n\n");
        }
        return code;
    }

    @Override
    public ICodeSegment genRowsProcessedCount(IPhysicalTable table, String macroVariable) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String macroVarTrim = macroVariable == null ? "etls_recnt" : macroVariable.trim();
        if (!table.isView()) {
            table.getDBMSType().genGetNumRows(this, table.getFullNameQuotedAsNeeded(this), table.getReadTableOptions(), macroVarTrim);
        } else {
            this.addSourceCode("%let ").addSourceCode(macroVarTrim).addSourceCode(" = -1;\n");
        }
        return this;
    }

    @Override
    public ICodeSegment genSystemOptions(String systemOptions) {
        if (systemOptions != null && systemOptions.length() > 0) {
            this.addCommentLine(RB.getStringResource("CodeSegment.SystemOptions.msg.txt"));
            this.addSourceCode("options ").addSourceCode(systemOptions).addSourceCode("; \n\n");
        }
        return this;
    }

    @Override
    public boolean isQuoting() {
        return this.m_environment.isQuoting();
    }

    @Override
    public void setQuoting(boolean quoting) {
        this.m_environment.setQuoting(quoting);
    }

    @Override
    public ICodeSegment genTableDelete(IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table == null) {
            return this;
        }
        return table.genTableDelete(this);
    }

    @Override
    public ICodeSegment genTableDelete(String tableName) {
        return this.addSourceCode(this.getTableDelete(tableName, ""));
    }

    @Override
    public ICodeSegment genTableDelete(String tableName, String passwordOption) {
        return this.addSourceCode(this.getTableDelete(tableName, passwordOption));
    }

    @Override
    public ICodeSegment genCasutilDropTable(String sessRef, String tableName, String caslib, boolean isTableNameQuoted) {
        return this.addSourceCode(this.getCasutilDropTable(sessRef, tableName, caslib, isTableNameQuoted));
    }

    @Override
    public ICodeSegment genCreateCasSession(String sessRef, String host, int port) {
        return this.addSourceCode(this.getCreateCasSession(sessRef, host, port));
    }

    @Override
    public ICodeSegment genTerminateCasSession(String sessRef) {
        return this.addSourceCode(this.getTerminateCasSession(sessRef));
    }

    @Override
    public ICodeSegment genTableProcDelete(String tableName, String passwordOption) {
        return this.addSourceCode(this.getTableProcDelete(tableName, passwordOption));
    }

    @Override
    public StringBuffer getTableDelete(String tableName, String passwordOption) {
        StringBuffer code = new StringBuffer();
        String lib = DBMSNamesUtil.getLibrefPart(tableName);
        if (lib.length() <= 0) {
            lib = WORK_LIBREF;
        }
        String dsName = DBMSNamesUtil.getTableNamePart(tableName);
        code.append("proc datasets lib = ").append(lib).append(" nolist nowarn memtype = (data view);\n").append("   ").append("delete ").append(dsName).append(passwordOption != null && passwordOption.length() > 0 ? "(" + passwordOption + ")" : "").append(";\n").append("quit;\n\n");
        return code;
    }

    @Override
    public StringBuffer getCasutilDropTable(String sessRef, String tableName, String caslib, boolean isTableNameQuoted) {
        StringBuffer code = new StringBuffer();
        code.append("proc casutil sessref=").append(sessRef).append(";").append("\n").append("   ");
        if (isTableNameQuoted) {
            code.append("droptable casdata=").append(tableName);
        } else {
            code.append("droptable casdata='").append(tableName).append("'");
        }
        code.append(" incaslib=\"").append(caslib).append("\"").append(" quiet;").append("\n").append("quit;").append("\n\n");
        return code;
    }

    @Override
    public StringBuffer getCreateCasSession(String sessRef, String host, int port) {
        StringBuffer code = new StringBuffer();
        code.append("cas ").append(sessRef).append(" host=\"").append(host).append("\"").append(" port=").append(port).append(";").append("\n\n");
        return code;
    }

    @Override
    public StringBuffer getTerminateCasSession(String sessRef) {
        StringBuffer code = new StringBuffer();
        code.append("cas ").append(sessRef).append(" terminate;").append("\n\n");
        return code;
    }

    @Override
    public ICodeSegment genSQLTableDelete(String tableName, String passwordOption, boolean isView) {
        return this.addSourceCode(this.getSQLTableDelete(tableName, passwordOption, isView));
    }

    @Override
    public StringBuffer getSQLTableDelete(String tableName, String passwordOption, boolean isView) {
        StringBuffer code = new StringBuffer();
        String lib = DBMSNamesUtil.getLibrefPart(tableName);
        if (lib.length() <= 0) {
            lib = WORK_LIBREF;
        }
        String dsName = DBMSNamesUtil.getTableNamePart(tableName);
        String modifiedTableName = lib + "." + dsName;
        code.append("%macro etls_deleteTable; \n");
        String tableMacro = "etls_tableExists";
        code.append("   ").append("%local dstype dsid ").append(tableMacro).append(";\n");
        code.append("   ").append(this.getTableExist(tableName, null, tableMacro, false));
        code.append("   ").append("%if (&").append(tableMacro).append(") %then\n").append("   ").append("%do;\n");
        code.append("   ").append("   ").append("%let dsid = %sysfunc(open(").append(modifiedTableName).append("));\n").append("   ").append("   ").append("%let dstype = %sysfunc(attrc(&dsid,MTYPE));\n").append("   ").append("   ").append("%if &dstype eq VIEW %then %let dstype = view;\n").append("   ").append("   ").append("%else %let dstype = table;\n").append("   ").append("   ").append("%let rc = %sysfunc(close(&dsid));\n");
        code.append("   ").append("   ").append("proc sql;\n").append("   ").append("   ").append("   ").append("drop &dstype. ").append(modifiedTableName).append(passwordOption != null && passwordOption.length() > 0 ? "(" + passwordOption + ")" : "").append(";\n").append("   ").append("   ").append("quit;\n").append("   ").append(this.getRCSetCall("&sqlrc", false));
        code.append("   ").append("%end;\n");
        code.append("%mend;\n");
        code.append("%etls_deleteTable;\n\n");
        return code;
    }

    public StringBuffer getTableProcDelete(String tableName, String passwordOption) {
        StringBuffer code = new StringBuffer();
        String lib = DBMSNamesUtil.getLibrefPart(tableName);
        if (lib.length() <= 0) {
            lib = WORK_LIBREF;
        }
        String dsName = DBMSNamesUtil.getTableNamePart(tableName);
        code.append("%macro etls_deleteTable; \n");
        String tableMacro = "etls_tableExists";
        code.append("   ").append("%local ").append(tableMacro).append(";\n");
        code.append("   ").append(this.getTableExist(tableName, null, tableMacro, false));
        code.append("   ").append("%if (&").append(tableMacro).append(") %then\n").append("   ").append("%do;\n");
        code.append("   ").append("   ").append("proc delete data = ").append(lib).append(".").append(dsName).append(passwordOption != null && passwordOption.length() > 0 ? "(" + passwordOption + ")" : "").append(";\n").append("   ").append("   ").append("quit;\n");
        code.append("   ").append("%end;\n");
        code.append("%mend;\n");
        code.append("%etls_deleteTable;\n\n");
        return code;
    }

    @Override
    public String parsePasswordOption(String sTableOptions, Pattern passwordType) {
        Matcher oMatcher = passwordType.matcher(sTableOptions);
        return oMatcher.find() ? oMatcher.group(0) : "";
    }

    @Override
    public ICodeSegment genTableRename(String tableName, String tableNameNew, String tableType) {
        String lib = DBMSNamesUtil.getLibrefPart(tableName);
        if (lib.length() <= 0) {
            lib = WORK_LIBREF;
        }
        String dsName = DBMSNamesUtil.getTableNamePart(tableName);
        String dsNameNew = DBMSNamesUtil.getTableNamePart(tableNameNew);
        this.addSourceCode("proc datasets lib=").addSourceCode(lib).addSourceCode(" nolist nowarn memtype = ").addSourceCode(tableType).addSourceCode(";\n");
        this.indent();
        this.addSourceCode("change ").addSourceCode(dsName).addSourceCode(" = ").addSourceCode(dsNameNew).addSourceCode(";\n");
        this.unIndent();
        this.addSourceCode("quit;\n\n");
        return this;
    }

    @Override
    public ICodeSegment genTableDelete(List tableList) throws CodegenException, BadLibraryDefinitionException {
        if (tableList == null || tableList.size() <= 0) {
            return this;
        }
        ArrayList tables = new ArrayList(tableList);
        while (tables.size() > 0) {
            int i;
            ArrayList<String> sameLibTables = new ArrayList<String>();
            String lib = "";
            boolean firstRec = true;
            for (i = 0; i < tables.size(); ++i) {
                String libref;
                Object obj = tables.get(i);
                String librefTableName = "";
                if (obj instanceof String) {
                    librefTableName = (String)obj;
                    libref = DBMSNamesUtil.getLibrefPart(librefTableName);
                    if (libref.length() <= 0) {
                        librefTableName = "work." + librefTableName;
                    }
                } else if (obj instanceof IPhysicalTable) {
                    IPhysicalTable table = (IPhysicalTable)obj;
                    librefTableName = table.getFullNameQuotedAsNeeded(this);
                } else {
                    tables.remove(i);
                    --i;
                    continue;
                }
                libref = DBMSNamesUtil.getLibrefPart(librefTableName);
                if (firstRec) {
                    lib = libref;
                    sameLibTables.add(librefTableName);
                    tables.remove(i);
                    --i;
                    firstRec = false;
                    continue;
                }
                if (!lib.equalsIgnoreCase(libref)) continue;
                sameLibTables.add(librefTableName);
                tables.remove(i);
                --i;
            }
            this.addSourceCode("proc datasets lib=").addSourceCode(lib).addSourceCode(" nolist nowarn memtype = (data view);\n");
            this.indent();
            for (i = 0; i < sameLibTables.size(); ++i) {
                String librefTableName = (String)sameLibTables.get(i);
                String dsName = DBMSNamesUtil.getTableNamePart(librefTableName);
                this.addSourceCode("delete ").addSourceCode(dsName).addSourceCode(";\n");
            }
            this.unIndent();
            this.addSourceCode("quit;\n\n");
        }
        return this;
    }

    @Override
    public String getUniqueWorkTableName(int offset) {
        return this.m_environment.getUniqueWorkTableName(offset);
    }

    @Override
    public String getUniqueWorkTableName() {
        return this.getUniqueWorkTableName(0);
    }

    @Override
    public String getCasSessRefUnique() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        StringBuffer sessRef = new StringBuffer();
        sessRef.append("CAS_").append(uuid);
        return sessRef.toString();
    }

    @Override
    public String getUniqueWorkTableName(boolean includeLibref, int offset) {
        return (includeLibref ? "work." : "") + this.getUniqueWorkTableName(offset);
    }

    @Override
    public ICodeSegment genCodeConditionCheck(ICodeSegment codeSegment, String sType, IDataTransform transformModel, IPhysicalTable table) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        List sets = transformModel.getConditionActionSetsList();
        for (int i = 0; i < sets.size(); ++i) {
            IConditionActionSet set = (IConditionActionSet)sets.get(i);
            ICondition condition = set.getCondition();
            if (!condition.getUniqueIdentifier().equalsIgnoreCase(sType)) continue;
            if (sType.equals("DIS_CDATAMODIFIED")) {
                if (table == null) {
                    throw new CodegenException(RB.getStringResource("CodeSegment.DataModifiedWithNoTable.msg.txt"), (IObject)table);
                }
                codeSegment.addCommentLine(RB.getStringResource("CodeSegment.CodeConditionCheck.msg.notrans"));
                table.getDBMSType().genGetNumRows(codeSegment, "&etls_lastTable", table.getReadTableOptions(false), "send");
            }
            codeSegment.addCommentLine(RB.getStringResource("CodeSegment.CodeConditionLoader.msg.notrans"));
            codeSegment.addSourceCode("%macro etls_loaderCheck; \n").indent();
            String sMacroVar = "trans_rc";
            if (transformModel instanceof JobTransformModel) {
                sMacroVar = "job_rc";
            }
            codeSegment.addSourceCode(condition.getConditionMacroCall(sMacroVar));
            codeSegment.addSourceCode("\n");
            codeSegment.addSourceCode("%do; \n").indent();
            ILibrary lib = null;
            if (table != null) {
                lib = table.getCodeGenLibrary(codeSegment.getCurrentServer());
            }
            codeSegment.genActionCodeConditionCheck(transformModel.getJob().isUsingNLSDateFormat(), codeSegment, set, table, lib);
            codeSegment.addSourceCode("\n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etls_loaderCheck; \n").addSourceCode("%etls_loaderCheck; \n\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genActionCodeConditionCheck(boolean useNLSDate, ICodeSegment codeSegment, IConditionActionSet set, IPhysicalTable table, ILibrary library) {
        if (set == null || set.getActionList().isEmpty()) {
            return codeSegment;
        }
        IConditionAction action = (IConditionAction)set.getActionList().get(0);
        return this.addSourceCode(action.getActionMacroCall(useNLSDate, codeSegment, table, library));
    }

    @Override
    public ICodeSegment genJobStatusUpdateBefore(IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        ILibrary library = table.getClientLibrary(this);
        String lib = this.getEscapedMacroValue(library != null ? library.getName() : WORK_LIBREF);
        this.addCommentLine(RB.getStringResource("CodeSegment.JobStatus.txt"));
        table.getDBMSType().genGetNumRows(this, table.getFullNameQuotedAsNeeded(this), table.getReadTableOptions(false), "etls_recordsBefore");
        this.addSourceCode("%let etls_table = %nrquote(").addSourceCode(table.getName()).addSourceCode(");\n");
        this.addSourceCode("%let etls_lib   = %nrquote(").addSourceCode(lib).addSourceCode(");\n\n");
        return this;
    }

    @Override
    public ICodeSegment genJobStatusUpdateAfter(IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tableDSName = table.getFullNameQuotedAsNeeded(this);
        this.addCommentLine(RB.getStringResource("CodeSegment.JobStatus.txt"));
        table.getDBMSType().genGetNumRows(this, tableDSName, table.getReadTableOptions(false), "etls_recordsAfter");
        return this;
    }

    @Override
    public ICodeSegment genMetadataMacrosAndOptions(IPersistableObject modelObject, IServer applicationServer) throws MdException, RemoteException {
        return this.genMetadataMacrosAndOptions(modelObject, applicationServer, false, null, null);
    }

    @Override
    public ICodeSegment genMetadataMacrosAndOptions(IPersistableObject modelObject, IServer applicationServer, boolean makeMetauser, String metauser, String metapass) throws MdException, RemoteException {
        return this.addSourceCode(this.getMetadataMacrosAndOptions(modelObject, applicationServer, makeMetauser, metauser, metapass));
    }

    @Override
    public StringBuffer getMetadataMacrosAndOptions(IPersistableObject modelObject, IServer applicationServer, boolean makeMetauser, String metauser, String metapass) throws MdException, RemoteException {
        StringBuffer code = new StringBuffer();
        code.append("/* ").append(RB.getStringResource("CodeSegment.MetadataMacroVars.msg.txt")).append(" */\n");
        String appServerName = this.getEscapedMacroValue(applicationServer != null ? applicationServer.getName() : "");
        code.append("%let IOMServer      = %nrquote(").append(appServerName).append(");\n");
        Workspace ws = Workspace.getWorkspace();
        ConnectionManager connectionManager = ws.getConnectionManager();
        UserContextInterface userContext = ws.getUserContext();
        if (makeMetauser) {
            PasswordAuthentication pw = connectionManager.getAuthenticatedLogin();
            if (pw != null) {
                String SASPassword;
                if (metapass == null) {
                    metapass = new String(pw.getPassword());
                }
                try {
                    SASPassword = SasPasswordString.encode((String)"sas002", (String)metapass);
                }
                catch (SasPasswordEncodingException spee) {
                    SASPassword = metapass;
                }
                code.append("%let metaUser       = %nrquote(");
                if (metauser == null) {
                    code.append(pw.getUserName());
                } else {
                    code.append(metauser);
                }
                code.append(");\n");
                code.append("%let metaPass       = %nrquote(").append(SASPassword).append(");\n");
            } else {
                makeMetauser = false;
            }
        }
        try {
            ServerInterface serverInterface = userContext.getAuthServer();
            code.append("%let metaPort       = %nrquote(").append(serverInterface.getPort()).append(");\n");
            code.append("%let metaServer     = %nrquote(").append(serverInterface.getHost()).append(");\n");
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        code.append("\n");
        if (Workspace.isSetMetaOptionSet()) {
            code.append("/* ").append(RB.getStringResource("CodeSegment.MetadataSetOptions.msg.txt")).append(" */\n");
            code.append("options metaport       = &metaPort \n");
        }
        if (makeMetauser) {
            code.append("        metauser       = \"&metaUser\" \n");
            code.append("        metapass       = \"&metaPass\" \n");
        }
        if (Workspace.isSetMetaOptionSet()) {
            code.append("        metaserver     = \"&metaServer\"; \n\n");
        }
        return code;
    }

    @Override
    public ICodeSegment handleException(Exception e) {
        if (this.m_environment.hasGeneratedException()) {
            return this;
        }
        this.m_environment.setGeneratedException(true);
        ModelLogger.getDefaultLogger().error((Object)e.toString(), (Throwable)e);
        return this.addErrorComment(e);
    }

    protected ICodeSegment addErrorComment(Exception exception) {
        String divider = this.repeat("!", 74);
        this.addSourceCode("\n").addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        this.genCommentLine(RB.getStringResource("CodeSegment.CodegenError.msg.txt"), "", "");
        this.genCommentLine();
        String currentObjectName = this.getModelObject().getName();
        this.genCommentLine(currentObjectName);
        this.genCommentLine();
        this.genCommentLine(this.m_environment.getCommentLabelForErrorType(), exception.toString(), "");
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("* \n");
        this.genCommentLine();
        this.genCommentLine("", exception.getLocalizedMessage(), "");
        this.genCommentLine();
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        return this;
    }

    public String escapeMacroValue(String string) {
        if (!string.startsWith("%str(")) {
            string = string.replaceAll("%", "%%").replaceAll("'", "%'").replaceAll("\"", "%\"").replaceAll("[(]", "%(").replaceAll("[)]", "%)");
        }
        return string;
    }

    @Override
    public ICodeSegment genGetColumnExists(IPhysicalTable table, IColumn lookupColumn, String dsidMacroVariable, String lookupVarNumberMacroVariable) throws CodegenException, BadLibraryDefinitionException {
        String columnName = lookupColumn.getName();
        String unquotedColumnName = columnName.replaceAll("\"", "\"\"");
        String tableName = table.getFullNameQuotedAsNeeded(this.getCurrentServer(), false, false, false, "");
        String unquotedTableName = tableName.replaceAll("\"", "\"\"");
        String sastablename = table.getSASTableName();
        if (sastablename.startsWith("'") && sastablename.endsWith("'")) {
            unquotedTableName = unquotedTableName + "n";
        }
        this.addSourceCode("data _null_; \n\n").indent().addSourceCode("dsid = open(\"" + unquotedTableName + "\"); \n").addSourceCode("call symput(\"").addSourceCode(dsidMacroVariable).addSourceCode("\", compress(put(dsid, 10.))); \n\n").addSourceCode("if (dsid gt 0) then \n").addSourceCode("do; \n").indent().addSourceCode("varnum = varnum(dsid, \"").addSourceCode(unquotedColumnName).addSourceCode("\"); \n").addSourceCode("call symput(\"").addSourceCode(lookupVarNumberMacroVariable).addSourceCode("\", compress(put(varnum, 10.))); \n").addSourceCode("dsid = close(dsid); \n").unIndent().addSourceCode("end; \n\n").unIndent().addSourceCode("run; \n\n");
        return this;
    }

    @Override
    public ICodeSegment genDatetimeMacrovarAssignment(String macrovar, String format) throws CodegenException {
        this.addSourceCode("%let ").addSourceCode(macrovar).addSourceCode(" = %sysfunc(datetime()");
        if (format.length() > 0) {
            this.addSourceCode(", ").addSourceCode(format);
        }
        this.addSourceCode("); \n\n");
        return this;
    }

    @Override
    public ICodeSegment genDeleteMacro(String entryName) {
        this.addSourceCode("/* Cleanup: remove " + entryName + " macro */\n");
        this.addSourceCode("%let etls_rmvMacro=;\n");
        this.addSourceCode("proc sql; select 'proc catalog cat=work.'||memname||'; delete " + entryName + "/et=macro;quit;' into:etls_rmvmacro  \n");
        this.addSourceCode("   from dictionary.catalogs where upcase(libname)='WORK' and memname like 'SASMAC%' and objname='" + entryName.toUpperCase() + "'; \nquit; \n");
        this.addSourceCode("&etls_rmvMacro; \n\n");
        return this;
    }

    @Override
    public String getAbortJobCode(String returnCode) {
        StringBuffer code = new StringBuffer();
        code.append(this.makeComment(MessageFormat.format(RB.getStringResource("CodeSegment.AbortJob.comment.txt"), returnCode)));
        if (this.isGenerateLoopMacroStatusCallOnAbort()) {
            code.append("%").append("etls_setClientSideStatus").append(";\n");
        }
        code.append("%abort return ").append(returnCode).append("; \n");
        return code.toString();
    }

    @Override
    public boolean isGenerateLoopMacroStatusCallOnAbort() {
        return this.m_environment.isGenerateLoopMacroStatusCallOnAbort();
    }

    @Override
    public void setGenerateLoopMacroStatusCallOnAbort(boolean generateMacroOnAbort) {
        this.m_environment.setGenerateLoopMacroStatusCallOnAbort(generateMacroOnAbort);
    }

    @Override
    public String formatObjectIDForMacroVar(IObject object) {
        String varName = object.getID().replaceAll("\\.", "_").replaceAll("\\$", "_");
        if (!SASNAME_PATTERN.matcher(varName).matches()) {
            varName = "";
        }
        return varName;
    }

    @Override
    public void setCurrentLoop(String loopControlName) {
        this.m_environment.setCurrentLoop(loopControlName);
    }

    @Override
    public void endCurrentLoop() {
        this.m_environment.endCurrentLoop();
    }

    @Override
    public int getLoopCount() {
        return this.m_environment.getLoopCount();
    }

    @Override
    public String getUniqueLoopHandleName() {
        return this.m_environment.getUniqueLoopHandleName();
    }

    @Override
    public boolean getParallelMacroStatus(IServer server) {
        return this.m_environment.getParallelMacroStatus(server);
    }

    @Override
    public void setGenerateCommentHeaderOnParallelMacros(boolean value) {
        this.m_environment.setGenerateCommentHeaderOnParallelMacros(value);
    }

    @Override
    public boolean isGeneratingCommentHeaderOnParallelMacros() {
        return this.m_environment.isGeneratingCommentHeaderOnParallelMacros();
    }

    @Override
    public void setInRemoteSubmit(boolean inRemote) {
        this.m_environment.setInRemoteSubmit(inRemote);
    }

    @Override
    public ICodeSegment genGetParameterNamesMacro() {
        this.addSourceCode("%macro etls_getParameterNames(parameterTable=, parameterVariableMacro=, startingColumnNumber=1);\n").indent().addSourceCode("%let &parameterVariableMacro = ;\n").addSourceCode("%let dsid = %sysfunc(open(&parameterTable));\n").addSourceCode("%if (&dsid gt 0) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%do i=&startingColumnNumber %to %sysfunc(attrn(&dsid,nvars)); \n").indent().addSourceCode("%let &parameterVariableMacro = &&&parameterVariableMacro %sysfunc(varname(&dsid,&i)); \n").unIndent().addSourceCode("%end; \n").addSourceCode("%let dsid = %sysfunc(close(&dsid)); \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().genRCSetCall("&syserr", false).unIndent().addSourceCode("%mend etls_getParameterNames; \n\n");
        return this;
    }

    @Override
    public ICodeSegment genGetParametersMacro() {
        this.addSourceCode("%macro etls_getParameters(parameterTable=, row=, startingColumnNumber=1 ").addSourceCode(", handleName=");
        this.addSourceCode("); \n").indent().addSourceCode("data _null_; \n").indent().addSourceCode("length vname $256 vtype $1 value $32767; \n").addSourceCode("dsid = open(\"&parameterTable\"); \n").addSourceCode("if (dsid > 0) then \n").addSourceCode("do; \n").indent().addSourceCode("do _i = 1 to &row; \n").indent().addSourceCode("fetchrc = fetch(dsid); \n").unIndent().addSourceCode("end; \n").addSourceCode("do _i=&startingColumnNumber to attrn(dsid,'nvars'); \n").indent().addSourceCode("vname = varname(dsid,_i); \n").addSourceCode("vtype = vartype(dsid,_i); \n").addSourceCode("if (fetchrc = 0) then \n").addSourceCode("do; \n").indent().addSourceCode("if (vtype = 'C') then \n").addSourceCode("do; \n").indent().addSourceCode("value = getvarc(dsid,_i); \n").addSourceCode("value = tranwrd(value,\"%\",\"%%\"); \n").addSourceCode("value = tranwrd(value,\"(\",\"%(\"); \n").addSourceCode("value = tranwrd(value,\")\",\"%)\"); \n").addSourceCode("value = tranwrd(value,'\"','%\"'); \n").addSourceCode("value = tranwrd(value,\"'\",\"%'\"); \n").unIndent().addSourceCode("end; \n").addSourceCode("else \n").indent().addSourceCode("value = left(put(getvarn(dsid,_i),best32.)); \n").unIndent().unIndent().addSourceCode("end; /* fetchrc = 0 */ \n");
        this.addSourceCode("\nput ;\n").addSourceCode("if kindexc(trimn(value),\"+-*/<>=^~;, '()&%\",'\"')>0 then \n").addSourceCode("do; \n").indent().addSourceCode("value='%nrstr('||ktrim(value)||')'; \n").addSourceCode("put \"").addSourceCode("ETLS_DIAG%QUOTE(:)").addSourceCode(JCL_INDENT).addSourceCode(RB.getStringResource("CodeSegment.GetParametersMacro.SpecialCharacters.txt")).addSourceCode(" %nrbquote(%)UNQUOTE(&\" vname+(-1)').';\n").addSourceCode("put \"").addSourceCode(NOTE_LABEL).addSourceCode(JCL_INDENT).addSourceCode(RB.getStringResource("CodeSegment.GetParametersMacro.SpecialCharacters.txt")).addSourceCode(" %nrbquote(%)UNQUOTE(&\" vname+(-1)').';\n").unIndent().addSourceCode("end; \n");
        this.addSourceCode("%if %str(&handlename) ne %str() %then \n").addSourceCode("%do; \n").indent().addSourceCode("value = '%syslput '||ktrim(vname)||'= '||ktrim(value)||\" / remote = &handleName;\"; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("value = '%let '||ktrim(vname)||'= '||ktrim(value)||';'; \n").unIndent().addSourceCode("%end; \n");
        this.addSourceCode("\nput \"").addSourceCode(NOTE_LABEL).addSourceCode(JCL_INDENT).addSourceCode(MessageFormat.format(RB.getStringResource("CodeSegment.GetParametersMacro.DebugMacro.txt"), "vname", "\"")).addSourceCode("\" value ;\n").addSourceCode("call execute(value); \n").unIndent().addSourceCode("end; /* do i= */ \n").addSourceCode("dsid = close(dsid); \n").unIndent().addSourceCode("end; /* dsid > 0 */ \n").addSourceCode("else \n").addSourceCode("do; \n").indent().genPutStatement(MessageFormat.format(RB.getStringResource("CodeSegment.GetParametersMacro.ParameterTableDoesNotExist.txt"), "&parameterTable."), "ERROR%QUOTE(:)", true).addSourceCode("abort; \n").unIndent().addSourceCode("end; \n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr", false).unIndent().addSourceCode("%mend etls_getParameters; \n\n");
        return this;
    }

    @Override
    public void addRemoteMacroVariables(IPromptDefinitionValue[] parameterList) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        this.m_environment.addRemoteMacroVariables(parameterList, this);
    }

    @Override
    public void addRemoteMacroVariable(String macro) {
        this.m_environment.addRemoteMacroVariable(macro);
    }

    @Override
    public void addRemoteMacroVariable(String macroKey, String macroName) {
        this.m_environment.addRemoteMacroVariable(macroKey, macroName);
    }

    @Override
    public void clearRemoteMacroVariables() {
        this.m_environment.clearRemoteMacroVariables();
    }

    @Override
    public Map getRemoteMacroVariablesMap() {
        return this.m_environment.getRemoteMacroVariablesMap();
    }

    @Override
    public ICodeSegment genRemoteMacroVariablesSetup(String remoteName) {
        this.genRemoteMacroVariablesSetup(remoteName, false);
        return this;
    }

    @Override
    public ICodeSegment genRemoteMacroVariablesSetup(String remoteName, boolean blankLine) {
        return this.addSourceCode(this.getRemoteMacroVariablesSetup(new ArrayList(this.getRemoteMacroVariablesMap().values()), remoteName, blankLine));
    }

    public static StringBuffer getValidvarnameOptionAny(boolean bSaveOldOption) {
        StringBuffer code = new StringBuffer();
        if (bSaveOldOption) {
            code.append("%let etls_VVNOption = %sysfunc(getOption(VALIDVARNAME)); \n");
            code.append("%let etls_VMNOption = %sysfunc(getOption(VALIDMEMNAME)); \n");
        }
        code.append("options VALIDVARNAME = ANY VALIDMEMNAME = EXTEND; \n\n");
        return code;
    }

    @Override
    public ICodeSegment genValidvarnameOptionAny(boolean bSaveOldOption) {
        this.addSourceCode(CodeSegment.getValidvarnameOptionAny(bSaveOldOption));
        return this;
    }

    public static StringBuffer getValidvarnameOptionReset() {
        StringBuffer code = new StringBuffer();
        code.append("options VALIDVARNAME = &etls_VVNOption VALIDMEMNAME = &etls_VMNOption;\n\n");
        return code;
    }

    @Override
    public ICodeSegment genValidvarnameOptionReset() {
        this.addSourceCode(CodeSegment.getValidvarnameOptionReset());
        return this;
    }

    @Override
    public String getDateTimeFormat(boolean bUseNLSFormat) {
        return this.getDateTimeFormat(bUseNLSFormat, "");
    }

    @Override
    public String getDateTimeFormat(boolean bUseNLSFormat, String width) {
        return bUseNLSFormat ? "nldatm" + width + "." : "datetime" + width + ".";
    }

    @Override
    public ICodeSegment genInitPerformanceStatistics(IServer server, boolean genTableStatistics) {
        return this.genInitPerformanceStatistics(server, genTableStatistics, false, "SAS Data Integration Studio");
    }

    public ICodeSegment genInitPerformanceStatistics(IServer server, boolean genTableStatistics, boolean setArmExec) {
        return this.genInitPerformanceStatistics(server, genTableStatistics, true, "SAS Data Integration Studio");
    }

    @Override
    public ICodeSegment genInitPerformanceStatistics(IServer server, boolean genTableStatistics, boolean setArmExec, String sApplName) {
        this.addSourceCode("%global applName;\n");
        this.addSourceCode("data _null_;\n");
        this.addSourceCode("applName=\"" + sApplName + "\";\n");
        this.addSourceCode("call symput('applName',%nrstr(applName));\n");
        this.addSourceCode("run;\n");
        this.addCommentLine(RB.getStringResource("CodeSegment.PerformanceStatistics.comment.txt"));
        this.addSourceCode("%macro etls_startPerformanceStats;\n");
        this.indent();
        this.addSourceCode("%log4sas();\n");
        this.addSourceCode("%log4sas_logger(Perf.ARM, 'level=info');\n");
        this.addSourceCode("options armagent=log4sas armsubsys=(ARM_PROC);\n");
        if (setArmExec) {
            this.addSourceCode("%global _armexec;\n");
            this.addSourceCode("%let _armexec = 1;\n");
        }
        this.addSourceCode("%perfinit(applname=\"&applName\");\n");
        if (genTableStatistics) {
            this.addSourceCode("%global etls_recnt;\n");
            this.addSourceCode("%let etls_recnt=-1;\n");
        }
        this.unIndent();
        this.addSourceCode("%mend;\n");
        this.addSourceCode("%etls_startPerformanceStats;\n");
        this.addSourceCode("\n");
        this.addSourceCode("%macro etls_setArmagent;\n");
        this.indent();
        this.addSourceCode("%let armagentLength = %length(%sysfunc(getoption(armagent)));\n");
        this.addSourceCode("%if (&armagentLength eq 0) %then\n");
        this.indent();
        this.addSourceCode("%do;\n");
        this.indent();
        this.addSourceCode("%log4sas();\n");
        this.addSourceCode("%log4sas_logger(Perf.ARM, 'level=info');\n");
        this.addSourceCode("options armagent=log4sas armsubsys=(ARM_PROC);\n");
        this.unIndent();
        this.addSourceCode("%end;\n");
        this.unIndent();
        this.unIndent();
        this.addSourceCode("%mend etls_setArmagent;\n\n");
        this.addSourceCode("%macro etls_setPerfInit;\n");
        this.indent();
        this.addSourceCode("%if \"&_perfinit\" eq \"0\" %then \n");
        this.indent();
        this.addSourceCode("%do;\n");
        this.indent();
        this.addSourceCode("%etls_setArmagent;\n");
        this.addSourceCode("%global _armexec;\n");
        this.addSourceCode("%let _armexec = 1;\n");
        this.addSourceCode("%perfinit(applname=\"&applName\");\n");
        this.unIndent();
        this.addSourceCode("%end;\n");
        this.unIndent();
        this.unIndent();
        this.addSourceCode("%mend etls_setPerfInit; \n\n");
        this.m_environment.addToPerformanceStatisticsCache(server);
        return this;
    }

    @Override
    public ICodeSegment genEndPerformanceStatistics(IServer server) {
        this.addCommentLine(RB.getStringResource("CodeSegment.PerformanceStatisticsEnd.comment.txt"));
        this.addSourceCode("data _null_;\n");
        this.indent();
        this.addSourceCode("if \"&_perfinit\" eq \"1\" then \n");
        this.indent();
        this.addSourceCode("call execute('%perfend;');\n\n");
        this.unIndent();
        this.unIndent();
        this.addSourceCode("run;\n");
        if (this.m_environment.isOnPerformanceStatisticsCache(server) && this.getLoopCount() == 0) {
            this.m_environment.removeFromPerformanceStatisticsCache(server);
        }
        return this;
    }

    @Override
    public final Map getRuntimeStatsConnectMacros(ICodeSegment codeSegment) {
        return this.getRuntimeStatsConnectMacros(codeSegment, false);
    }

    @Override
    public final Map getRuntimeStatsConnectMacros(ICodeSegment codeSegment, boolean bJobLevel) {
        HashMap<String, String> remoteMap = null;
        if (codeSegment.isRunStatisticsEnabled()) {
            remoteMap = new HashMap<String, String>();
            remoteMap.put("_armexec", "&_armexec");
            if (!bJobLevel) {
                remoteMap.put("transformID", "&transformID");
            }
            if (codeSegment.isRunTableStatisticsEnabled()) {
                remoteMap.put("etls_recnt", "&etls_recnt");
            }
        }
        return remoteMap;
    }

    @Override
    public void setRunStatisticsEnabled(boolean runStats) {
        this.m_environment.setRunStatisticsEnabled(runStats);
    }

    @Override
    public boolean isRunStatisticsEnabled() {
        return this.m_environment.isRunStatisticsEnabled();
    }

    @Override
    public void setRunTableStatisticsEnabled(boolean runStats) {
        this.m_environment.setRunTableStatisticsEnabled(runStats);
    }

    @Override
    public boolean isRunTableStatisticsEnabled() {
        return this.m_environment.isRunTableStatisticsEnabled();
    }

    public static String getTempFilenameAndDSCode(IObject objectReference, String fileref, String fileContent, boolean resolveMacros) throws CodegenException {
        return CodeSegment.getFilenameAndDSCode(objectReference, fileref, "temp", fileContent, null, resolveMacros);
    }

    public static String getTempFilenameAndDSCode(IObject objectReference, String fileref, String fileContent, String filenameOptions, boolean resolveMacros) throws CodegenException {
        return CodeSegment.getFilenameAndDSCode(objectReference, fileref, "temp", fileContent, filenameOptions, resolveMacros);
    }

    public static String getFilenameAndDSCode(IObject objectReference, String fileref, String filelocation, String fileContent, boolean resolveMacros) throws CodegenException {
        return CodeSegment.getFilenameAndDSCode(objectReference, fileref, filelocation, fileContent, null, resolveMacros);
    }

    public static String getFilenameAndDSCode(IObject objectReference, String fileref, String filelocation, String fileContent, String filenameOptions, boolean resolveMacros) throws CodegenException {
        String[] lines;
        if (fileref == null || fileref.length() == 0) {
            throw new CodegenException("File reference cannot be blank", objectReference);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("filename ").append(fileref).append(JCL_INDENT).append(filelocation);
        if (filenameOptions != null && filenameOptions.length() > 0) {
            sb.append(JCL_INDENT).append(filenameOptions);
        }
        sb.append(" ;\n\n");
        String[] stringArray = lines = fileContent != null ? fileContent.split("\\n") : new String[]{};
        if (resolveMacros) {
            sb.append("data _null_;").append("\n").append("file ").append(fileref).append(";\n");
            for (String line : lines) {
                if (line != null && line.trim().length() > 0) {
                    sb.append("put \"").append(line.replace("\"", "\"\"")).append("\"").append(";\n");
                    continue;
                }
                sb.append("put ;\n");
            }
            sb.append("run;\n\n");
        } else {
            sb.append("data _null_;").append("\n").append("file ").append(fileref).append(";\n").append("input;").append("\n").append("put _infile_;").append("\n").append("datalines4;").append("\n").append(fileContent != null ? fileContent : "");
            if (fileContent != null && !fileContent.endsWith("\n")) {
                sb.append("\n");
            }
            sb.append(";;;;\n").append("run;\n\n");
        }
        return sb.toString();
    }

    public static String getTempFilenameAndDSCodeForBRM(IObject objectReference, String fileref, String fileContent, String filenameOptions, boolean resolveMacros) throws CodegenException {
        return CodeSegment.getFilenameAndDSCodeForBRM(objectReference, fileref, "temp", fileContent, filenameOptions, resolveMacros);
    }

    public static String getFilenameAndDSCodeForBRM(IObject objectReference, String fileref, String filelocation, String fileContent, String filenameOptions, boolean resolveMacros) throws CodegenException {
        String[] lines;
        if (fileref == null || fileref.length() == 0) {
            throw new CodegenException("File reference cannot be blank", objectReference);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("filename ").append(fileref).append(JCL_INDENT).append(filelocation);
        if (filenameOptions != null && filenameOptions.length() > 0) {
            sb.append(JCL_INDENT).append(filenameOptions);
        }
        sb.append(" ;\n\n");
        String[] stringArray = lines = fileContent != null ? fileContent.split("\\n") : new String[]{};
        if (resolveMacros) {
            sb.append("data _null_;").append("\n").append("file ").append(fileref).append(";\n");
            for (String line : lines) {
                if (line != null && line.trim().length() > 0) {
                    sb.append("put \"").append(line.replace("\"", "\"\"")).append("\"").append(";\n");
                    continue;
                }
                sb.append("put ;\n");
            }
            sb.append("run;\n\n");
        } else {
            sb.append("data _null_;").append("\n").append("file ").append(fileref).append(";\n");
            for (String line : lines) {
                if (line != null && line.trim().length() > 0) {
                    sb.append("put '").append(line.replace("'", "''")).append("'").append(";\n");
                    continue;
                }
                sb.append("put ;\n");
            }
            sb.append("run;\n\n");
        }
        return sb.toString();
    }

    @Override
    public StringBuffer getSelectResults(IColumn[] tableColumns, boolean bGenFormats) {
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < tableColumns.length; ++i) {
            IColumn tColumn = tableColumns[i];
            String columnName = tColumn.getColumnName(this);
            code.append(columnName);
            char[] indent = new char[columnName.length() + 1];
            Arrays.fill(indent, ' ');
            code.append(" length = ").append(tColumn.getLength());
            String format = tColumn.getFormat();
            String informat = tColumn.getInformat();
            String desc = tColumn.getDescription();
            if (bGenFormats && format.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append("format = ").append(format);
            }
            if (bGenFormats && informat.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append("informat = ").append(informat);
            }
            if (desc.length() > 0) {
                code.append("\n").append(String.valueOf(indent)).append(tColumn.getLabelStatement());
            }
            if (i == tableColumns.length - 1) continue;
            code.append(",\n");
        }
        return code;
    }

    @Override
    public boolean isClientGeneratedSegment() {
        return this.m_clientGeneratedSegment;
    }

    @Override
    public void setClientGeneratedSegment(boolean value) {
        this.m_clientGeneratedSegment = value;
    }

    @Override
    public ICodeSegment genSaveCasSessionRef() {
        return this.addSourceCode(this.getSaveCasSessionRef());
    }

    @Override
    public ICodeSegment genResetCasSessionRef() {
        return this.addSourceCode(this.getResetCasSessionRef());
    }

    @Override
    public StringBuffer getSaveCasSessionRef() {
        StringBuffer code = new StringBuffer();
        code.append("%global sessref_option;").append("\n").append("%let sessref_option=%sysfunc(getoption(SESSREF));").append("\n\n");
        return code;
    }

    @Override
    public StringBuffer getResetCasSessionRef() {
        StringBuffer code = new StringBuffer();
        code.append("options sessref=&sessref_option.;").append("\n").append("%let _SESSREF_=&sessref_option.;").append("\n").append("%symdel sessref_option;").append("\n\n");
        return code;
    }

    public class SASMacro {
        private String m_name;
        private String m_description;
        private List m_parameters = new ArrayList();

        public SASMacro(String name) {
            this.m_name = name;
            this.m_description = RB.getStringResource("CodeSegment." + name + ".desc.txt");
        }

        public SASMacro addParameter(String name) {
            this.m_parameters.add(new Parameter(name, this.m_name));
            return this;
        }

        public StringBuffer getCommentHeader() {
            StringBuffer comment = new StringBuffer();
            String divider = CodeSegment.this.repeat(CodeSegment.DIVIDER, 75);
            comment.append("/*").append(divider).append(" \n").append(CodeSegment.this.getCommentLine(RB.getStringResource("CodeSegment.Macro.txt"))).append(CodeSegment.this.getCommentLine("   " + this.m_name, " - " + this.m_description));
            if (!this.m_parameters.isEmpty()) {
                comment.append(CodeSegment.this.getCommentLine(""));
                comment.append(CodeSegment.this.getCommentLine("   " + RB.getStringResource("CodeSegment.Parameters.txt")));
            }
            for (int i = 0; i < this.m_parameters.size(); ++i) {
                Parameter parm = (Parameter)this.m_parameters.get(i);
                comment.append(CodeSegment.this.getCommentLine("      " + parm.getName(), " - " + parm.getDescription()));
            }
            comment.append(" *").append(divider).append("/ \n");
            return comment;
        }

        private class Parameter {
            private String m_parameterName;
            private String m_parameterDescription;

            public Parameter(String name, String macroName) {
                this.m_parameterName = name;
                this.m_parameterDescription = RB.getStringResource("CodeSegment." + macroName + "." + name + ".desc.txt");
            }

            public String getName() {
                return this.m_parameterName;
            }

            public String getDescription() {
                return this.m_parameterDescription;
            }
        }
    }
}

