/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeGenerationEnvironment
implements ICodeGenerationEnvironment {
    private static final String JOB_KEY = "JOB";
    private static final String LOCATION_KEY = "LOCATION";
    private static final String VERSION_KEY = "VERSION";
    private static final String SERVER_KEY = "SERVER";
    private static final String GEN_ON_KEY = "GENON";
    private static final String GEN_BY_KEY = "GENBY";
    private static final String STEP_KEY = "STEP";
    private static final String TRANSFORM_KEY = "TRANSFORM";
    private static final String ERROR_TYPE_KEY = "ERRORTYPE";
    private static final String DESC_KEY = "DESC";
    private static final String USER_KEY = "USER";
    private static final String SOURCE_KEY = "SOURCE";
    private static final String SOURCES_KEY = "SOURCES";
    private static final String TARGET_KEY = "TARGET";
    private static final String TARGETS_KEY = "TARGETS";
    private static final String METADATA_SERVER_KEY = "METADATA_SERVER";
    private static final String PORT_KEY = "PORT";
    private Map m_commentLabelMap;
    private Stack m_currentLoop;
    private HashMap m_loopMap;
    private Map m_codeSegments;
    private StringBuffer m_codeGenerated = new StringBuffer();
    private Map m_librariesGenerated;
    private IServer m_currentServer;
    private IServer m_defaultServer;
    private Map<String, RemoteMacroHolder> m_remoteMacroVariables;
    private Map m_signonCache;
    private Map m_remoteSignonCache;
    private Map m_workTablesMap;
    private boolean m_bQuoted = false;
    private boolean m_bSpecialCharacters = false;
    private String m_userName;
    private String m_applicationVersion;
    private boolean m_inRemoteSubmit = false;
    private Map m_mapGeneratedParallelMacros;
    private Map m_mapRunTimeStatus;
    private boolean m_bGenerateCommentsOnParallelMacros = true;
    private boolean m_bGenerateParameterDefaults;
    private boolean m_bGeneratedException;
    private boolean m_bGenerateRCSetStatements;
    private boolean m_bReturnCodeSetup;
    private boolean m_bGenerateLoopMacroStatusCallOnAbort = false;
    private Stack m_stkRemoteStack;
    private boolean m_bRunStatisticsEnabled = false;
    private boolean m_bRunTableStatisticsEnabled = false;
    private Map<Object, List<String>> m_stkParametersGenerated;

    public CodeGenerationEnvironment(IServer defaultServer) {
        this.m_codeSegments = new LinkedHashMap();
        this.m_librariesGenerated = new HashMap();
        this.m_remoteMacroVariables = new HashMap<String, RemoteMacroHolder>();
        this.m_signonCache = new HashMap();
        this.m_remoteSignonCache = new HashMap();
        this.m_workTablesMap = new HashMap();
        this.m_userName = Workspace.getWorkspace().getUsername();
        this.m_applicationVersion = Workspace.getWorkspace().getApplicationName();
        this.m_mapGeneratedParallelMacros = new HashMap();
        this.m_mapRunTimeStatus = new HashMap();
        this.m_defaultServer = defaultServer;
        this.m_bGeneratedException = false;
        this.m_bGenerateRCSetStatements = true;
        this.m_loopMap = new HashMap();
        this.m_currentLoop = new Stack();
        this.m_bGenerateParameterDefaults = true;
        this.m_bReturnCodeSetup = false;
        this.setCurrentServer(defaultServer);
        this.createCommentLabelMap();
        this.m_stkRemoteStack = new Stack();
        this.m_stkParametersGenerated = new LinkedHashMap<Object, List<String>>();
    }

    @Override
    public void addGeneratedParameters(IParametersContainer container, ICodeSegment codeSegment) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        this.addGeneratedParameters(container, codeSegment, Arrays.asList(container.getParameters()));
    }

    @Override
    public void addGeneratedParameters(Object container, ICodeSegment codeSegment, List<IPromptDefinitionValue> prompts) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        HashMap<String, String> macs = new HashMap<String, String>();
        for (IPromptDefinitionValue def : prompts) {
            macs.putAll(def.getMacroNamesAndValues(codeSegment, true, true, false, false));
        }
        this.addRemoteMacroVariables(prompts.toArray(new IPromptDefinitionValue[prompts.size()]), codeSegment);
        this.m_stkParametersGenerated.put(container, new ArrayList(macs.keySet()));
    }

    @Override
    public void removeGeneratedParameters(Object container) {
        this.m_stkParametersGenerated.remove(container);
    }

    @Override
    public List<String> getGeneratedParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<Object, List<String>> entry : this.m_stkParametersGenerated.entrySet()) {
            for (String p : entry.getValue()) {
                names.add(p);
            }
        }
        return names;
    }

    @Override
    public void clearGeneratedParameters() {
        this.m_stkParametersGenerated.clear();
    }

    @Override
    public boolean hasParameterBeenGenerated(String name) {
        List<String> gend = this.getGeneratedParameterNames();
        for (String n : gend) {
            if (!ObjectComparator.isEqual(n, name, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IPromptDefinitionValue> getDefinitionsNotGenerated(List<IPromptDefinitionValue> prompts, ICodeSegment codeSegment) throws ServiceException, ServerConnectionException, CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ArrayList<IPromptDefinitionValue> lst = new ArrayList<IPromptDefinitionValue>();
        block0: for (IPromptDefinitionValue def : prompts) {
            PromptDefinitionInterface pdf = def.getDefinition();
            DataTypeInterface dti = pdf.getPromptDataType();
            if (dti instanceof BaseRangeDataType) {
                Map<String, String> macs = def.getMacroNamesAndValues(codeSegment, true, true, false, false);
                for (Map.Entry<String, String> map : macs.entrySet()) {
                    if (this.hasParameterBeenGenerated(map.getKey())) continue;
                    lst.add(def);
                    continue block0;
                }
                continue;
            }
            if (this.hasParameterBeenGenerated(def.getName())) continue;
            lst.add(def);
        }
        return lst;
    }

    @Override
    public ICodeGenerationEnvironment copy() {
        CodeGenerationEnvironment newEnvironment = new CodeGenerationEnvironment(this.getDefaultServer());
        newEnvironment.setGenerateLoopMacroStatusCallOnAbort(true);
        newEnvironment.setRunStatisticsEnabled(this.isRunStatisticsEnabled());
        newEnvironment.setRunTableStatisticsEnabled(this.isRunTableStatisticsEnabled());
        newEnvironment.setCurrentLoopStack(this.getCurrentLoopStack());
        newEnvironment.setRemoteMacroVariablesMap(this.getRemoteMacroVariablesMap());
        return newEnvironment;
    }

    @Override
    public Stack getCurrentLoopStack() {
        return this.m_currentLoop;
    }

    @Override
    public void setCurrentLoopStack(Stack currentLoopStack) {
        this.m_currentLoop = currentLoopStack;
    }

    private void createCommentLabelMap() {
        this.m_commentLabelMap = new HashMap();
        this.m_commentLabelMap.put(JOB_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Job.txt"));
        this.m_commentLabelMap.put(LOCATION_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Location.txt"));
        this.m_commentLabelMap.put(VERSION_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Version.txt"));
        this.m_commentLabelMap.put(SERVER_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Server.txt"));
        this.m_commentLabelMap.put(GEN_ON_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.GeneratedOn.txt"));
        this.m_commentLabelMap.put(GEN_BY_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.GeneratedBy.txt"));
        this.m_commentLabelMap.put(ERROR_TYPE_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.ErrorType.txt"));
        this.m_commentLabelMap.put(STEP_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Step.txt"));
        this.m_commentLabelMap.put(TRANSFORM_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Transform.txt"));
        this.m_commentLabelMap.put(DESC_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Description.txt"));
        this.m_commentLabelMap.put(USER_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.UserWritten.txt"));
        this.m_commentLabelMap.put(SOURCE_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.SourceTable.txt"));
        this.m_commentLabelMap.put(SOURCES_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.SourceTables.txt"));
        this.m_commentLabelMap.put(TARGET_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.TargetTable.txt"));
        this.m_commentLabelMap.put(TARGETS_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.TargetTables.txt"));
        this.m_commentLabelMap.put(METADATA_SERVER_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.MetadataServer.txt"));
        this.m_commentLabelMap.put(PORT_KEY, RB.getStringResource("CodeGenerationEnvironment.CommentLabel.Port.txt"));
        Collection valueCollection = this.m_commentLabelMap.values();
        List values = new ArrayList();
        values.addAll(valueCollection);
        values = this.padStrings(values);
        Set keySet = this.m_commentLabelMap.keySet();
        Iterator iterator = keySet.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.m_commentLabelMap.put(key, values.get(counter));
            ++counter;
        }
    }

    @Override
    public boolean isGenerateLoopMacroStatusCallOnAbort() {
        return this.m_bGenerateLoopMacroStatusCallOnAbort;
    }

    @Override
    public void setGenerateLoopMacroStatusCallOnAbort(boolean generateMacroOnAbort) {
        this.m_bGenerateLoopMacroStatusCallOnAbort = generateMacroOnAbort;
    }

    @Override
    public IServer getDefaultServer() {
        return this.m_defaultServer;
    }

    @Override
    public void setDefaultServer(IServer defaultServer) {
        this.m_defaultServer = defaultServer;
    }

    @Override
    public void addSourceCode(StringBuffer code) {
        this.m_codeGenerated.append(code);
    }

    @Override
    public void setGeneratedReturnCodeSetup(boolean isSetup) {
        this.m_bReturnCodeSetup = isSetup;
    }

    @Override
    public boolean isUseMVSLineLength() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.GenerateLineLengthsLessThanEighty", false);
    }

    @Override
    public StringBuffer getLimitedString(StringBuffer sourceText) {
        if (sourceText == null) {
            return new StringBuffer();
        }
        ArrayList<String> newLines = new ArrayList<String>();
        String[] lines = sourceText.toString().split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 79) {
                StringBuffer newLine = new StringBuffer();
                Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
                Matcher regexMatcher = regex.matcher(line);
                while (regexMatcher.find()) {
                    String temp = regexMatcher.group();
                    if (newLine.length() + temp.length() > 79) {
                        newLines.add(newLine.toString());
                        newLine.setLength(0);
                    }
                    if (temp == null || temp.length() <= 0) continue;
                    int end = regexMatcher.end();
                    if (line.length() > end) {
                        if (' ' == line.charAt(end)) {
                            newLine.append(temp).append(" ");
                            continue;
                        }
                        newLine.append(temp);
                        continue;
                    }
                    newLine.append(temp);
                }
                newLines.add(newLine.toString());
                continue;
            }
            newLines.add(line);
        }
        StringBuffer newSourceText = new StringBuffer();
        for (int i = 0; i < newLines.size(); ++i) {
            String line = (String)newLines.get(i);
            if (line.length() <= 0) continue;
            if (this.isGenerateJCLIndent() && !line.substring(0, 1).equals(" ")) {
                newSourceText.append(" ");
            }
            newSourceText.append(line).append("\n");
        }
        return newSourceText;
    }

    @Override
    public boolean isGenerateJCLIndent() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.GenerateJCL", false);
    }

    @Override
    public boolean isGeneratedReturnCodeSetup() {
        return this.m_bReturnCodeSetup;
    }

    @Override
    public boolean isGenerateRCSetCalls() {
        return this.m_bGenerateRCSetStatements;
    }

    @Override
    public void setGenerateRCSetCalls(boolean generateRcSetStatements) {
        this.m_bGenerateRCSetStatements = generateRcSetStatements;
    }

    @Override
    public String getCommentLabelForJob() {
        Object val = this.m_commentLabelMap.get(JOB_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForLocation() {
        Object val = this.m_commentLabelMap.get(LOCATION_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForMetadataServer() {
        Object val = this.m_commentLabelMap.get(METADATA_SERVER_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForPort() {
        Object val = this.m_commentLabelMap.get(PORT_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForVersion() {
        Object val = this.m_commentLabelMap.get(VERSION_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForServer() {
        Object val = this.m_commentLabelMap.get(SERVER_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForGeneratedOn() {
        Object val = this.m_commentLabelMap.get(GEN_ON_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForGeneratedBy() {
        Object val = this.m_commentLabelMap.get(GEN_BY_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForErrorType() {
        Object val = this.m_commentLabelMap.get(ERROR_TYPE_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForStep() {
        Object val = this.m_commentLabelMap.get(STEP_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForTransform() {
        Object val = this.m_commentLabelMap.get(TRANSFORM_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForDescription() {
        Object val = this.m_commentLabelMap.get(DESC_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForUserWritten() {
        Object val = this.m_commentLabelMap.get(USER_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForSource() {
        Object val = this.m_commentLabelMap.get(SOURCE_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForSources() {
        Object val = this.m_commentLabelMap.get(SOURCES_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForTarget() {
        Object val = this.m_commentLabelMap.get(TARGET_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public String getCommentLabelForTargets() {
        Object val = this.m_commentLabelMap.get(TARGETS_KEY);
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    @Override
    public void setGenerateCommentHeaderOnParallelMacros(boolean value) {
        this.m_bGenerateCommentsOnParallelMacros = value;
    }

    @Override
    public boolean isGeneratingCommentHeaderOnParallelMacros() {
        return this.m_bGenerateCommentsOnParallelMacros;
    }

    @Override
    public boolean getParallelMacroStatus(IServer server) {
        return this.m_mapGeneratedParallelMacros.get(server) != null && !this.m_inRemoteSubmit;
    }

    @Override
    public void addServerToParallelMacroGeneration(IServer server) {
        if (!this.m_mapGeneratedParallelMacros.containsKey(server)) {
            this.m_mapGeneratedParallelMacros.put(server, server);
        }
    }

    @Override
    public void clearParallelMacroServerGeneration() {
        this.m_mapGeneratedParallelMacros.clear();
    }

    @Override
    public void setInRemoteSubmit(boolean value) {
        this.m_inRemoteSubmit = value;
    }

    @Override
    public ICodeSegment createNewCodeSegment(IObject model) {
        CodeSegment code = new CodeSegment(this, model, true);
        code.setStartPosition(this.m_codeGenerated.length());
        if (!this.m_codeSegments.containsKey(model)) {
            this.m_codeSegments.put(model, code);
        }
        return code;
    }

    @Override
    public void addCodeSegment(ICodeSegment segment) {
        this.m_codeSegments.put(segment.getModelObject(), segment);
    }

    @Override
    public ICodeSegment[] getCodeSegments() {
        return this.m_codeSegments.values().toArray(new ICodeSegment[this.m_codeSegments.size()]);
    }

    @Override
    public boolean isQuoting() {
        return this.m_bQuoted;
    }

    @Override
    public void setQuoting(boolean quoted) {
        this.m_bQuoted = quoted;
    }

    @Override
    public boolean isSpecialCharactersNeeded() {
        return this.m_bSpecialCharacters;
    }

    @Override
    public void setSpecialCharactersNeeded(boolean specialCharacters) {
        this.m_bSpecialCharacters = specialCharacters;
    }

    @Override
    public StringBuffer getGeneratedCode() {
        return !this.isUseMVSLineLength() ? this.m_codeGenerated : this.getLimitedString(this.m_codeGenerated);
    }

    @Override
    public List<String> getRemoteMacroVariables() {
        return new ArrayList<String>(this.getRemoteMacroVariablesMap().values());
    }

    @Override
    public IServer getCurrentServer() {
        return this.m_currentServer;
    }

    @Override
    public void setCurrentServer(IServer server) {
        this.m_currentServer = server;
    }

    @Override
    public void addRemoteSession(IServer server) {
        this.m_stkRemoteStack.push(server);
    }

    @Override
    public void removeRemoteSession() {
        this.m_stkRemoteStack.pop();
    }

    protected String getRemoteStackIds() {
        String ids = this.getCurrentServer().getID();
        Iterator iter = this.m_stkRemoteStack.iterator();
        while (iter.hasNext()) {
            ids = ids + ((IServer)iter.next()).getID();
        }
        return ids;
    }

    @Override
    public List getLibrariesGeneratedList() {
        String currentServer = this.getRemoteStackIds();
        List libList = (List)this.getLibrariesGenerated().get(currentServer);
        return libList;
    }

    @Override
    public void addToPerformanceStatisticsCache(IServer server) {
        if (server != null) {
            String currentServer = this.getRemoteStackIds();
            ArrayList<IServer> serverList = (ArrayList<IServer>)this.m_mapRunTimeStatus.get(currentServer);
            if (serverList == null) {
                serverList = new ArrayList<IServer>();
            }
            if (!serverList.contains(server)) {
                serverList.add(server);
            }
            this.m_mapRunTimeStatus.put(currentServer, serverList);
        }
    }

    @Override
    public boolean isOnPerformanceStatisticsCache(IServer server) {
        if (server != null) {
            String currentServer = this.getRemoteStackIds();
            List serverList = (List)this.m_mapRunTimeStatus.get(currentServer);
            return serverList != null && serverList.contains(server);
        }
        return false;
    }

    @Override
    public void removeFromPerformanceStatisticsCache(IServer server) {
        String currentServer;
        List serverList;
        if (server != null && (serverList = (List)this.m_mapRunTimeStatus.get(currentServer = this.getRemoteStackIds())) != null) {
            serverList.remove(server);
        }
    }

    @Override
    public void addToSignonCache(IServer server) {
        if (server != null) {
            String currentServer = this.getRemoteStackIds();
            ArrayList<IServer> serverList = (ArrayList<IServer>)this.m_signonCache.get(currentServer);
            if (serverList == null) {
                serverList = new ArrayList<IServer>();
            }
            if (!serverList.contains(server)) {
                serverList.add(server);
            }
            this.m_signonCache.put(currentServer, serverList);
        }
    }

    @Override
    public boolean isOnSignonCache(IServer server) {
        if (server != null) {
            String currentServer = this.getRemoteStackIds();
            List serverList = (List)this.m_signonCache.get(currentServer);
            return serverList != null && serverList.contains(server);
        }
        return false;
    }

    @Override
    public void addToRemoteSubmitCache(ISASClientConnection connect) {
        if (connect != null) {
            String server = this.getRemoteStackIds();
            ArrayList<ISASClientConnection> remoteList = (ArrayList<ISASClientConnection>)this.m_remoteSignonCache.get(server);
            if (remoteList == null) {
                remoteList = new ArrayList<ISASClientConnection>();
            }
            if (!remoteList.contains(connect)) {
                remoteList.add(connect);
            }
            this.m_remoteSignonCache.put(server, remoteList);
        }
    }

    @Override
    public boolean isOnRemoteSubmitCache(ISASClientConnection connect) {
        if (connect != null) {
            String server = this.getRemoteStackIds();
            List remoteList = (List)this.m_remoteSignonCache.get(server);
            return remoteList != null && remoteList.contains(connect);
        }
        return false;
    }

    @Override
    public void addLibraryToContextList(ILibrary lib) {
        if (lib != null) {
            String currentServer = this.getRemoteStackIds();
            ArrayList<ILibrary> libList = (ArrayList<ILibrary>)this.m_librariesGenerated.get(currentServer);
            if (libList == null) {
                libList = new ArrayList<ILibrary>();
            }
            if (!libList.contains(lib)) {
                libList.add(lib);
            }
            this.m_librariesGenerated.put(currentServer, libList);
        }
    }

    @Override
    public boolean isOnLibraryContextList(ILibrary lib) {
        if (lib != null) {
            String currentServer = this.getRemoteStackIds();
            List libList = (List)this.m_librariesGenerated.get(currentServer);
            return libList != null && libList.contains(lib);
        }
        return false;
    }

    @Override
    public Map getLibrariesGenerated() {
        return new HashMap(this.m_librariesGenerated);
    }

    @Override
    public void setLibrariesGenerated(Map librariesGenerated) {
        this.m_librariesGenerated = librariesGenerated;
    }

    @Override
    public void clearLibraryContextList() {
        this.m_librariesGenerated.clear();
    }

    @Override
    public ICodeSegment replaceCodeSegment(ICodeSegment c, IObject model) {
        int start = this.getCodeGenerationStart(model);
        int end = this.getCodeGenerationEnd(model);
        if (start > -1 && end > -1) {
            this.m_codeGenerated.replace(start, end, c.toString());
        }
        this.m_codeSegments.put(model, c);
        return c;
    }

    @Override
    public void removeCodeSegmentCode(ICodeSegment c) {
        if (this.m_codeSegments.containsValue(c)) {
            int start = c.getEnvironmentStartPosition();
            int end = c.getEnvironmentEndPosition();
            if (start > -1 && end > -1) {
                this.m_codeGenerated.replace(start, end, "");
            }
        }
    }

    @Override
    public int getCodeGenerationStart(IObject model) {
        int start = -1;
        Object seg = this.m_codeSegments.get(model);
        if (seg != null) {
            ICodeSegment s = (ICodeSegment)seg;
            start = s.getEnvironmentStartPosition();
        }
        return start;
    }

    @Override
    public int getCodeGenerationEnd(IObject model) {
        int end = -1;
        Object seg = this.m_codeSegments.get(model);
        if (seg != null) {
            ICodeSegment s = (ICodeSegment)seg;
            end = s.getEnvironmentEndPosition();
        }
        return end;
    }

    public List padStrings(List list) {
        String text;
        int i;
        int maxLength = 0;
        for (i = 0; i < list.size(); ++i) {
            text = (String)list.get(i);
            maxLength = Math.max(maxLength, text.length());
        }
        ++maxLength;
        for (i = 0; i < list.size(); ++i) {
            text = (String)list.get(i);
            text = text + this.repeat(" ", maxLength - text.length());
            list.set(i, text);
        }
        return list;
    }

    @Override
    public String repeat(String repeatString, int numRepeats) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < numRepeats; ++i) {
            newString.append(repeatString);
        }
        return newString.toString();
    }

    @Override
    public String getUserName() {
        return this.m_userName;
    }

    @Override
    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    @Override
    public String getApplicationVersion() {
        return this.m_applicationVersion;
    }

    @Override
    public void setApplicationVersion(String version) {
        this.m_applicationVersion = version;
    }

    @Override
    public String getUniqueWorkTableName(int offset) {
        String workTableName = CodeGenerationEnvironment.createWorkTableName(offset);
        while (this.m_workTablesMap.containsKey(workTableName)) {
            workTableName = CodeGenerationEnvironment.createWorkTableName(offset++);
        }
        this.m_workTablesMap.put(workTableName, workTableName);
        return workTableName;
    }

    public void abort() {
    }

    public boolean isAborted() {
        return false;
    }

    public static String createWorkTableName(int offset) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        long time = System.nanoTime() / 100000L + (long)(offset * 10);
        boolean done = false;
        StringBuffer base36 = new StringBuffer("");
        do {
            int remainder = (int)(time % 36L);
            base36.insert(0, cArray[remainder]);
            if ((time /= 36L) != 0L) continue;
            done = true;
        } while (!done);
        return base36.insert(0, 'W').substring(0);
    }

    public static String createWorkTableName8Char(int offset) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        long time = System.nanoTime() / 100000L + (long)(offset * 10);
        boolean done = false;
        StringBuffer base36 = new StringBuffer("");
        do {
            int remainder = (int)(time % 36L);
            base36.insert(0, cArray[remainder]);
            if ((time /= 36L) != 0L) continue;
            done = true;
        } while (!done);
        while (base36.length() > 7) {
            base36.deleteCharAt(base36.length() - 1);
        }
        return base36.insert(0, 'W').substring(0);
    }

    @Override
    public void setRunStatisticsEnabled(boolean runStats) {
        this.m_bRunStatisticsEnabled = runStats;
    }

    @Override
    public boolean isRunStatisticsEnabled() {
        return this.m_bRunStatisticsEnabled;
    }

    @Override
    public void setRunTableStatisticsEnabled(boolean runStats) {
        this.m_bRunTableStatisticsEnabled = runStats;
    }

    @Override
    public boolean isRunTableStatisticsEnabled() {
        return this.m_bRunTableStatisticsEnabled;
    }

    @Override
    public void setGeneratedException(boolean generatedException) {
        this.m_bGeneratedException = generatedException;
    }

    @Override
    public boolean hasGeneratedException() {
        return this.m_bGeneratedException;
    }

    @Override
    public void setCurrentLoop(String loopControlName) {
        this.m_currentLoop.push(loopControlName);
    }

    @Override
    public void endCurrentLoop() {
        Object current;
        if (!this.m_currentLoop.isEmpty() && (current = this.m_currentLoop.pop()) instanceof String) {
            this.m_remoteMacroVariables.remove(current.toString());
        }
    }

    @Override
    public int getLoopCount() {
        return this.m_currentLoop.size();
    }

    @Override
    public String getUniqueLoopHandleName() {
        Random generator = new Random();
        String loopname = "L" + Integer.toString(generator.nextInt(100)) + "_";
        while (this.m_loopMap.containsKey(loopname)) {
            loopname = "L" + Integer.toString(generator.nextInt(100)) + "_";
        }
        this.m_loopMap.put(loopname, loopname);
        return loopname;
    }

    public static String getUniqueLoopHandleNamePrefix() {
        Random generator = new Random();
        return "L" + Integer.toString(generator.nextInt(100)) + "_";
    }

    @Override
    public void addRemoteMacroVariables(IPromptDefinitionValue[] parameterList, ICodeSegment codeSegment) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        if (parameterList == null) {
            return;
        }
        for (IPromptDefinitionValue def : parameterList) {
            Map<String, String> macs = def.getMacroNamesAndValues(codeSegment, true, true, false, false);
            for (Map.Entry<String, String> map : macs.entrySet()) {
                this.addRemoteMacroVariable(map.getKey());
            }
        }
    }

    @Override
    public void addRemoteMacroVariable(String macro) {
        this.addRemoteMacroVariable(macro, macro);
    }

    private String getCurrentLoopName() {
        Object last;
        Object object = last = !this.m_currentLoop.isEmpty() ? (Object)this.m_currentLoop.lastElement() : null;
        return this.m_currentLoop.isEmpty() ? "default" : (null != last ? last.toString() : "default");
    }

    @Override
    public void addRemoteMacroVariable(String macroKey, String macroName) {
        String currentName = this.getCurrentLoopName();
        RemoteMacroHolder holder = this.getRemoteHolder();
        holder.addMacro(macroKey, macroName);
        this.m_remoteMacroVariables.put(currentName, holder);
    }

    private RemoteMacroHolder getRemoteHolder() {
        String currentName = this.getCurrentLoopName();
        RemoteMacroHolder holder = this.m_remoteMacroVariables.get(currentName);
        if (null == holder) {
            holder = new RemoteMacroHolder(currentName);
        }
        return holder;
    }

    @Override
    public void clearRemoteMacroVariables() {
        this.m_remoteMacroVariables.clear();
    }

    @Override
    public Map<String, String> getRemoteMacroVariablesMap() {
        HashMap<String, String> macros = new HashMap<String, String>();
        for (RemoteMacroHolder holder : this.m_remoteMacroVariables.values()) {
            macros.putAll(holder.macros);
        }
        return macros;
    }

    @Override
    public void setRemoteMacroVariablesMap(Map<String, String> remoteMacroMap) {
        for (Map.Entry<String, String> entry : remoteMacroMap.entrySet()) {
            this.addRemoteMacroVariable(entry.getKey(), entry.getValue());
        }
    }

    public boolean isGenerateParameterDefaultSetting() {
        return this.m_bGenerateParameterDefaults;
    }

    public void setGenerateParameterDefaultSetting(boolean genDefaults) {
        this.m_bGenerateParameterDefaults = genDefaults;
    }

    public class RemoteMacroHolder {
        private Map<String, String> macros = new HashMap<String, String>();
        private String remoteName = "default";

        public RemoteMacroHolder(String remoteName) {
            this.remoteName = remoteName;
        }

        public void addMacro(String key, String value) {
            this.macros.put(key, value);
        }

        public String getRemoteName() {
            return this.remoteName;
        }
    }
}

