/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.data.impl.TransformTablePromptDefinitionValue;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BaseTransformTableOptions
extends AbstractPersistableObject
implements ITransformTableOptions {
    private static final String ASSOCIATEDOBJECT_CUSTOMLIST_NAME = "AssociatedObject";
    private boolean m_bIsAccessInput = false;
    private IPhysicalTable m_table;
    private IPersistableObject m_owner;
    private PhysicalTablePromptModelCollection m_optionModel;
    private IPromptValueChangeListener m_promptChangeListener = new cPromptValueChangeListener();
    private String m_displayName;

    public BaseTransformTableOptions(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setAccessTypeInput(boolean bAccessInput) {
        this.m_bIsAccessInput = bAccessInput;
        this.setDisplayName(this.m_bIsAccessInput ? RB.getStringResource("BaseTransformTableOptions.Input.txt") : RB.getStringResource("BaseTransformTableOptions.Output.txt"));
        this.updateVisibleOptions();
    }

    @Override
    public void setShowTransformSpecificOptions() {
        PhysicalTablePromptModelCollection model = this.getOptionModel();
        if (model != null) {
            model.setShowTransformSpecificOptions();
        }
    }

    @Override
    public boolean isAccessTypeInput() {
        return this.m_bIsAccessInput;
    }

    protected void setOptionModel(PhysicalTablePromptModelCollection model) {
        if (this.m_optionModel != null) {
            this.m_optionModel.dispose();
        }
        this.m_optionModel = model;
        if (this.m_optionModel != null) {
            this.m_optionModel.setTable(this.getOptionTable());
            this.m_optionModel.setOwner(this);
            this.updateVisibleOptions();
        }
    }

    @Override
    public IPromptValueChangeListener getPromptChangeListener() {
        return this.m_promptChangeListener;
    }

    @Override
    public String getTableOptions(IServer currentServer) {
        return this.getTableOptions(false, null, currentServer);
    }

    @Override
    public String getTableOptions(boolean parenthesis, IServer currentServer) {
        return this.getTableOptions(parenthesis, null, currentServer);
    }

    @Override
    public String getTableOptions(boolean parenthesis, String optionRole, IServer currentServer) {
        return this.getTableOptions(parenthesis, optionRole, "", currentServer);
    }

    @Override
    public String getTableOptions(boolean parenthesis, String optionRole, String additionalTableOptions, IServer currentServer) {
        StringBuffer options = new StringBuffer();
        PhysicalTablePromptModelCollection optionModel = this.getOptionModel();
        if (optionModel != null) {
            try {
                if (currentServer == null || !this.m_table.isRemoteToServer(currentServer)) {
                    options.append(optionModel.getOptionsString(null).toString().trim());
                }
            }
            catch (Exception e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            if (additionalTableOptions != null && additionalTableOptions.length() > 0) {
                options.append(" " + additionalTableOptions);
            }
            if (options.length() > 0 && parenthesis) {
                options.insert(0, "(").append(")");
            }
        }
        return options.toString().trim();
    }

    @Override
    public String getTableOptions(boolean parenthesis, String optionRole, String additionalTableOptions, IServer currentServer, IPromptDefinitionValue[] definitions) {
        StringBuffer options = new StringBuffer();
        PhysicalTablePromptModelCollection optionModel = this.getOptionModel();
        if (optionModel != null) {
            try {
                if (currentServer == null || !this.m_table.isRemoteToServer(currentServer)) {
                    options.append(optionModel.getOptionsString(definitions, null, null).toString().trim());
                }
            }
            catch (Exception e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
            if (additionalTableOptions != null && additionalTableOptions.length() > 0) {
                options.append(" " + additionalTableOptions);
            }
            if (options.length() > 0 && parenthesis) {
                options.insert(0, "(").append(")");
            }
        }
        return options.toString().trim();
    }

    private void updateVisibleOptions() {
        PhysicalTablePromptModelCollection model = this.getOptionModel();
        if (model != null) {
            if (this.isAccessTypeInput()) {
                model.setShowReadOptions();
            } else {
                model.setShowWriteOptions();
            }
        }
    }

    @Override
    public void setGenerateTransformSpecificOptions(boolean bGenTransformSpecific) {
        PhysicalTablePromptModelCollection model = this.getOptionModel();
        if (model != null) {
            model.setGenerateTransformSpecificOptions(bGenTransformSpecific);
        }
    }

    @Override
    public PhysicalTablePromptModelCollection getOptionModel() {
        return this.m_optionModel;
    }

    @Override
    public void setOptionTable(IPhysicalTable table) {
        if (this.m_table == table) {
            return;
        }
        if (this.m_table != null) {
            this.m_table.removeNotifyListener(this);
        }
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.addNotifyListener(this);
        }
        try {
            this.setOptionModel(this.getTableOptionModel());
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    @Override
    public IPhysicalTable getOptionTable() {
        return this.m_table;
    }

    protected PhysicalTablePromptModelCollection getTableOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerException {
        IPhysicalTable table = this.getOptionTable();
        if (table != null && table.getTableOptionCollection() != null) {
            table.getTableOptionCollection().addChangeListener(this.getPromptChangeListener());
            PhysicalTablePromptModelCollection options = table.getTableOptionCollectionForTransformTableOnly(this);
            return options;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    @Override
    public String getOMRType() {
        return "PropertySet";
    }

    @Override
    public void setOwner(IPersistableObject owner) {
        if (this.m_owner == owner) {
            return;
        }
        this.m_owner = owner;
    }

    @Override
    public IPersistableObject getOwner() {
        return this.m_owner;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        PhysicalTablePromptModelCollection model = this.getOptionModel();
        if (model != null) {
            model.deleteFromOMR(omr);
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        String type;
        ModelEvent modelEvent = ev.getModelEvent();
        if (modelEvent != null && "PhysicalTable:OptionModelChanged".equals(type = modelEvent.getType())) {
            try {
                this.setOptionModel(this.getTableOptionModel());
            }
            catch (FileNotFoundException e) {
                ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            }
            catch (ServerException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServerException", (Throwable)e);
            }
            catch (IOException e) {
                ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
            }
            catch (SAXException e) {
                ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
            }
        }
        super.notify(ev);
    }

    @Override
    public IPhysicalTable loadAssociatedObject(OMRAdapter omr, String id) throws MdException, RemoteException {
        PropertySet pSet = (PropertySet)omr.acquireOMRObject(this.getID(), "PropertySet");
        if (pSet != null) {
            IPersistableObject[] assocObj = this.loadCustomListFromOMR(omr, (Root)pSet, ASSOCIATEDOBJECT_CUSTOMLIST_NAME);
            return assocObj.length > 0 ? (IPhysicalTable)assocObj[0] : null;
        }
        return null;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        PropertySet pSet = (PropertySet)omr.acquireOMRObject(this.getID(), "PropertySet");
        if (pSet != null) {
            IPersistableObject[] assocObj = this.loadCustomListFromOMR(omr, (Root)pSet, ASSOCIATEDOBJECT_CUSTOMLIST_NAME);
            IPhysicalTable table = assocObj.length > 0 ? (IPhysicalTable)assocObj[0] : null;
            this.setOptionTable(table);
            this.setAccessTypeInput("Read".equals(pSet.getPropertySetName()));
            PhysicalTablePromptModelCollection optModel = this.getOptionModel();
            if (optModel != null) {
                optModel.setOwner(this);
                optModel.loadFromOMR(omr);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        IPhysicalTable table;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Root owner = omr.acquireOMRObject(this.m_owner);
        PropertySet mdoSet = (PropertySet)omr.acquireOMRObject(this.getID(), "PropertySet");
        mdoSet = (PropertySet)omr.acquireOMRObject(this.getID(), "PropertySet");
        mdoSet.setName("TransformTableOptions");
        mdoSet.setSetRole("TransformTableOptions");
        mdoSet.setPropertySetName(this.isAccessTypeInput() ? "Read" : "Write");
        if (!owner.getPropertySets(false).contains((Object)mdoSet)) {
            owner.getPropertySets(false).add((Object)mdoSet);
        }
        if ((table = this.getOptionTable()) != null) {
            IPhysicalTable[] iPhysicalTableArray = new IPhysicalTable[1];
            iPersistableObjectArray = iPhysicalTableArray;
            iPhysicalTableArray[0] = table;
        } else {
            iPersistableObjectArray = new IPhysicalTable[]{};
        }
        this.saveCustomListToOMR(omr, (Root)mdoSet, ASSOCIATEDOBJECT_CUSTOMLIST_NAME, iPersistableObjectArray);
        PhysicalTablePromptModelCollection optModel = this.getOptionModel();
        optModel.setOwner(this);
        optModel.saveToOMR(omr);
        this.setChanged(false);
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.getOptionModel() != null && this.getOptionModel().isChanged();
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        PhysicalTablePromptModelCollection optModel = this.getOptionModel();
        if (optModel != null) {
            optModel.updateIDs(mapIDs);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        PhysicalTablePromptModelCollection optModel = this.getOptionModel();
        if (optModel != null) {
            optModel.dispose();
        }
    }

    private class cPromptValueChangeListener
    implements IPromptValueChangeListener {
        private cPromptValueChangeListener() {
        }

        @Override
        public boolean isListeningForChanges() {
            return true;
        }

        @Override
        public void setListeningForChanges(boolean isListening) {
        }

        public void promptValueChanged(PromptValueChangeEventInterface event) {
            PhysicalTablePromptModelCollection model = BaseTransformTableOptions.this.getOptionModel();
            if (model != null) {
                try {
                    IPromptDefinitionValue definition = model.findDefinition(event.getPromptDefinition().getPromptName());
                    if (definition != null) {
                        TransformTablePromptDefinitionValue def;
                        Object newValue = event.getNewValue();
                        if (definition.isValueValid(newValue)) {
                            definition.setDefaultValue(newValue);
                        } else {
                            definition.revertDefault();
                        }
                        if (definition instanceof TransformTablePromptDefinitionValue && (def = (TransformTablePromptDefinitionValue)definition).isTableOnlyDefinition()) {
                            if (def.isValueValid(newValue)) {
                                def.setValue(newValue);
                            } else {
                                definition.clearValue();
                            }
                        }
                    }
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
                }
                catch (IllegalStateException e) {
                    ModelLogger.getDefaultLogger().error((Object)"IllegalStateException", (Throwable)e);
                }
                catch (ServiceException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
                }
                catch (ServerConnectionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
                }
                catch (MdException e) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
                }
            }
        }
    }
}

