/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.RB;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseMapping
extends AbstractPersistableObject
implements IMapping {
    private List m_lSources = new ArrayList();
    private List m_lTargets = new ArrayList();
    private String m_sType = "ONETOONE";
    private IExpression m_expression;
    private boolean m_bExpressionAllowed = true;
    private boolean m_bAutoType = false;
    private boolean m_bReplacing;
    protected boolean m_bChangedDuringLoad = false;

    public BaseMapping(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public IColumn[] getSources() {
        return this.m_lSources.toArray(new IColumn[this.m_lSources.size()]);
    }

    @Override
    public int getSourceCount() {
        return this.m_lSources.size();
    }

    @Override
    public void clearSources() {
        IColumn[] sources = this.getSources();
        this.startCompoundUndoable();
        try {
            for (int i = 0; i < sources.length; ++i) {
                this.removeSource(sources[i]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addSource(IColumn column) {
        this.addSource(this.m_lSources.size(), column);
    }

    @Override
    public void addSource(int iSource, IColumn column) {
        this.startCompoundUndoable();
        try {
            this.m_lSources.add(iSource, column);
            column.addNotifyListener(this);
            this.fireModelChangedEvent("Mapping:SourceColumnAdded", column);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddSourceUndoable(iSource, column));
            }
            if (this.getExpression() != null) {
                this.getExpression().replaceColumn(null, column);
            }
            if (this.isAutoType()) {
                this.updateType();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeSource(IColumn column) {
        if (!this.m_lSources.contains(column)) {
            return;
        }
        int iSource = this.m_lSources.indexOf(column);
        this.m_lSources.remove(iSource);
        column.removeNotifyListener(this);
        this.fireModelChangedEvent("Mapping:SourceColumnRemoved", column);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveSourceUndoable(iSource, column));
        }
        if (this.getExpression() != null) {
            this.getExpression().replaceColumn(column, null);
        }
        if (this.isAutoType()) {
            this.updateType();
        }
    }

    @Override
    public boolean containsInSources(IColumn column) {
        return this.m_lSources.contains(column);
    }

    @Override
    public int indexInSources(IColumn column) {
        return this.m_lSources.indexOf(column);
    }

    @Override
    public IColumn[] getTargets() {
        return this.m_lTargets.toArray(new IColumn[this.m_lTargets.size()]);
    }

    @Override
    public void clearTargets() {
        IColumn[] targets = this.getTargets();
        this.startCompoundUndoable();
        try {
            for (int i = 0; i < targets.length; ++i) {
                this.removeTarget(targets[i]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public int getTargetCount() {
        return this.m_lTargets.size();
    }

    @Override
    public void addTarget(IColumn column) {
        this.addTarget(this.m_lTargets.size(), column);
    }

    @Override
    public void addTarget(int iTarget, IColumn column) {
        this.m_lTargets.add(iTarget, column);
        column.addNotifyListener(this);
        this.fireModelChangedEvent("Mapping:TargetColumnAdded", column);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddTargetUndoable(iTarget, column));
        }
        if (this.isAutoType()) {
            this.updateType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            this.m_bReplacing = true;
            try {
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new SetReplacingUndoable(false));
                }
                this.removeTarget(oldColumn);
                this.addTarget(newColumn);
                if (this.getExpression() != null) {
                    this.getExpression().replaceColumn(oldColumn, newColumn);
                }
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new SetReplacingUndoable(true));
                }
            }
            finally {
                this.m_bReplacing = false;
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            this.m_bReplacing = true;
            try {
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new SetReplacingUndoable(false));
                }
                if (this.getExpression() != null) {
                    this.getExpression().replaceColumn(oldColumn, newColumn);
                }
                this.removeSource(oldColumn);
                this.addSource(newColumn);
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new SetReplacingUndoable(true));
                }
            }
            finally {
                this.m_bReplacing = false;
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isReplacing() {
        return this.m_bReplacing;
    }

    @Override
    public void removeTarget(IColumn column) {
        if (!this.m_lTargets.contains(column)) {
            return;
        }
        int iTarget = this.m_lTargets.indexOf(column);
        this.m_lTargets.remove(iTarget);
        column.removeNotifyListener(this);
        this.fireModelChangedEvent("Mapping:TargetColumnRemoved", column);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveTargetUndoable(iTarget, column));
        }
        if (this.getExpression() != null) {
            this.getExpression().replaceColumn(column, null);
        }
        if (this.isAutoType()) {
            this.updateType();
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        Object source = ev.getSource();
        if (source instanceof IColumn) {
            IColumn column = (IColumn)ev.getSource();
            if (ev.getType() == 0) {
                if (this.containsInTargets(column)) {
                    this.removeTarget(column);
                } else if (this.containsInSources(column)) {
                    this.removeSource(column);
                }
            } else {
                String sType = ev.getModelEvent().getType();
                if (sType == "Object:NameChanged") {
                    if (this.m_lTargets.indexOf(column) == 0) {
                        this.setName(column.getName());
                    }
                } else if (sType == "Column:TypeChanged" || sType == "Column:LengthChanged") {
                    if (this.isAutoType()) {
                        this.updateType();
                    }
                    this.fireModelChangedEvent("Mapping:MappingChanged", column);
                }
            }
        } else if (ev.getSource() == this.getExpression()) {
            this.fireNotifyEvent(new NotifyEvent(this, 1, ev.getModelEvent()));
        }
        super.notify(ev);
    }

    protected void updateType() {
        if (this.isReplacing()) {
            return;
        }
        if (this.m_expression != null) {
            this.setTypeImpl("DERIVED");
        } else if (this.isExpressionNeeded() && this.isExpressionAllowed()) {
            this.setTypeImpl("DERIVED");
        } else {
            this.setTypeImpl("ONETOONE");
        }
    }

    protected boolean isSourceAndTargetComplete() {
        return this.m_lSources.size() == 1 && this.m_lTargets.size() == 1;
    }

    protected boolean isExpressionNeeded() {
        if (!this.isSourceAndTargetComplete()) {
            return true;
        }
        IColumn source = (IColumn)this.m_lSources.get(0);
        IColumn target = (IColumn)this.m_lTargets.get(0);
        return source.getType() != target.getType();
    }

    @Override
    public boolean containsInTargets(IColumn column) {
        return this.m_lTargets.contains(column);
    }

    @Override
    public int indexInTargets(IColumn column) {
        return this.m_lTargets.indexOf(column);
    }

    public void setAutoType(boolean bAutoType) {
        this.m_bAutoType = bAutoType;
        if (bAutoType) {
            boolean bChanged = this.isChanged();
            try {
                this.updateType();
            }
            finally {
                this.setChanged(bChanged);
            }
        }
    }

    public boolean isAutoType() {
        return this.m_bAutoType;
    }

    @Override
    public void setType(String sType) {
        if (sType == null) {
            throw new NullPointerException("Mapping type must not be null");
        }
        if ("DERIVED".equals(sType) && !this.m_bExpressionAllowed) {
            throw new IllegalArgumentException("Mapping type can not be DERIVED in mappings that don't allow expressions");
        }
        if (this.isAutoType()) {
            throw new UnsupportedOperationException("Mapping type can not be set on an autotype mapping");
        }
        if (this.m_sType.equals(sType)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTypeUndoable(this.m_sType, sType));
        }
        this.setTypeImpl(sType);
    }

    protected void setTypeImpl(String sType) {
        if (this.m_sType.equals(sType)) {
            return;
        }
        this.m_sType = sType;
        this.fireModelChangedEvent("Mapping:TypeChanged", null);
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public boolean isOrdinary() {
        return "ONETOONE".equals(this.m_sType) || "DERIVED".equals(this.m_sType);
    }

    @Override
    public boolean isSpecial() {
        return !this.isOrdinary();
    }

    @Override
    public void setExpression(IExpression expression) {
        if (this.m_expression == null ? expression == null : this.m_expression.equals(expression)) {
            return;
        }
        if (expression != null && !this.m_bExpressionAllowed) {
            throw new IllegalArgumentException("Expression can not be set on a mapping that does not allow expressions");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExpressionUndoable(this.m_expression, expression));
        }
        if (this.m_expression != null) {
            this.addToDeletedObjects(this.m_expression);
            this.m_expression.removeNotifyListener(this);
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
            expression.addNotifyListener(this);
        }
        this.m_expression = expression;
        this.fireModelChangedEvent("Mapping:ExpressionChanged", expression);
        if (this.isAutoType()) {
            this.updateType();
        }
    }

    @Override
    public IExpression getExpression() {
        return this.m_expression;
    }

    @Override
    public IExpression createNewExpression() {
        return this.getModel().getObjectFactory().createNewTextExpression(this.getID());
    }

    public void setExpressionAllowed(boolean bAllowed) {
        this.m_bExpressionAllowed = bAllowed;
    }

    public boolean isExpressionAllowed() {
        return this.m_bExpressionAllowed;
    }

    @Override
    public boolean isComplete() {
        if ("ONETOONE".equals(this.m_sType)) {
            return this.isSourceAndTargetComplete();
        }
        if ("DERIVED".equals(this.m_sType)) {
            return this.m_lTargets.size() == 1 && (this.m_expression == null && this.isSourceAndTargetComplete() || this.m_expression != null && this.m_expression.isComplete());
        }
        return this.m_expression == null || this.m_expression.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_lTargets.size() == 0 && this.isOrdinary()) {
            lReasons.add(RB.getStringResource("BaseMapping.ReasonIncomplete.MissingTarget.txt"));
        }
        if ("ONETOONE".equals(this.m_sType)) {
            if (this.m_lTargets.size() > 1) {
                lReasons.add(RB.getStringResource("BaseMapping.ReasonIncomplete.TooManyTargets.txt"));
            }
            if (this.m_lSources.size() == 0) {
                lReasons.add(RB.getStringResource("BaseMapping.ReasonIncomplete.OneToOne.MissingSource.txt"));
            }
            if (this.m_lSources.size() > 1) {
                lReasons.add(RB.getStringResource("BaseMapping.ReasonIncomplete.OneToOne.TooManySources.txt"));
            }
        } else if ("DERIVED".equals(this.m_sType)) {
            if (this.m_lTargets.size() > 1) {
                lReasons.add(RB.getStringResource("BaseMapping.ReasonIncomplete.TooManyTargets.txt"));
            }
            if (this.m_expression == null) {
                if (!this.isSourceAndTargetComplete()) {
                    lReasons.add(RB.getStringResource("BaseMapping.ReasonIncomplete.Derived.NoExpression.txt"));
                }
            } else {
                lReasons.addAll(this.m_expression.getReasonsIncomplete());
            }
        }
        return lReasons;
    }

    @Override
    public String getWarning() {
        if ("ONETOONE".equals(this.m_sType)) {
            if (this.m_lSources.size() == 1 && this.m_lTargets.size() == 1) {
                IColumn colSource = (IColumn)this.m_lSources.get(0);
                IColumn colTarget = (IColumn)this.m_lTargets.get(0);
                if (colSource.getType() != colTarget.getType()) {
                    if (this.isExpressionAllowed()) {
                        return MessageFormat.format(RB.getStringResource("BaseMapping.Warning.OneToOne.TypeMismatch.txt"), colSource.getName(), colTarget.getName());
                    }
                    return MessageFormat.format(RB.getStringResource("BaseMapping.Warning.OneToOneNoExp.TypeMismatch.txt"), colSource.getName(), colTarget.getName());
                }
                if (colSource.getLength() > colTarget.getLength()) {
                    return MessageFormat.format(RB.getStringResource("BaseMapping.Warning.OneToOne.TargetTooShort.txt"), colSource.getName(), colTarget.getName());
                }
            }
        } else if ("DERIVED".equals(this.m_sType)) {
            List lReasonsInc;
            if (this.m_expression == null) {
                if (this.m_lSources.size() == 1 && this.m_lTargets.size() == 1) {
                    IColumn colSource = (IColumn)this.m_lSources.get(0);
                    IColumn colTarget = (IColumn)this.m_lTargets.get(0);
                    if (colSource.getType() != colTarget.getType()) {
                        return MessageFormat.format(RB.getStringResource("BaseMapping.Warning.Derived.TypeMismatch.txt"), colSource.getName(), colTarget.getName());
                    }
                    if (colSource.getLength() > colTarget.getLength()) {
                        return MessageFormat.format(RB.getStringResource("BaseMapping.Warning.Derived.TargetTooShort.txt"), colSource.getName(), colTarget.getName());
                    }
                }
                return RB.getStringResource("BaseMapping.Warning.Derived.NoExpression.txt");
            }
            if (!this.m_expression.isComplete() && !(lReasonsInc = this.m_expression.getReasonsIncomplete()).isEmpty()) {
                return (String)lReasonsInc.get(0);
            }
            List warnings = this.m_expression.getWarnings();
            if (!warnings.isEmpty()) {
                return (String)warnings.get(0);
            }
            IObject[] aExpressionColumns = this.m_expression.getSources();
            ArrayList<IObject> lExpressionColumns = new ArrayList<IObject>(aExpressionColumns.length);
            for (int iExpressionColumn = 0; iExpressionColumn < aExpressionColumns.length; ++iExpressionColumn) {
                if (!(aExpressionColumns[iExpressionColumn] instanceof IColumn)) continue;
                lExpressionColumns.add(aExpressionColumns[iExpressionColumn]);
            }
            IColumn[] aMappingColumns = this.getSources();
            for (int iMappingColumn = 0; iMappingColumn < aMappingColumns.length; ++iMappingColumn) {
                if (!lExpressionColumns.contains(aMappingColumns[iMappingColumn])) {
                    return RB.getStringResource("BaseMapping.Warning.Derived.ExpressionColumnsMismatch.txt");
                }
                lExpressionColumns.remove(aMappingColumns[iMappingColumn]);
            }
            if (!lExpressionColumns.isEmpty()) {
                return RB.getStringResource("BaseMapping.Warning.Derived.ExpressionColumnsMismatch.txt");
            }
        }
        return null;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        String warning = this.getWarning();
        return warning != null && warning.length() > 0;
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        String warning = this.getWarning();
        if (warning != null && warning.length() > 0) {
            warnings.add(warning);
        }
        return warnings;
    }

    @Override
    public boolean isDead() {
        if (this.isOrdinary()) {
            if (this.getTargetCount() == 0) {
                return true;
            }
            if (this.getSourceCount() == 0 && this.getExpression() == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        if (this.m_expression != null) {
            return this.m_expression.isChanged();
        }
        return false;
    }

    @Override
    public void saveXMLToStream(OutputStream strm) throws IOException {
    }

    @Override
    public void loadXMLFromStream(InputStream strm) throws IOException {
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        mdoFM.setTransformRole(this.getType());
        this.saveSourcesToOMR(omr, mdoFM);
        this.saveTargetsToOMR(omr, mdoFM);
        if (this.m_expression != null) {
            if ("DERIVED".equalsIgnoreCase(this.m_expression.getExpressionType())) {
                ((ITextExpression)this.m_expression).setExpressionAnchor((AbstractTransformation)mdoFM);
                this.m_expression.saveToOMR(omr);
            } else {
                AssociationList lTransTargets = mdoFM.getTransformationTargets(false);
                lTransTargets.clear();
                this.m_expression.saveToOMR(omr);
                lTransTargets.add(omr.acquireOMRObject(this.m_expression));
            }
        }
    }

    protected void saveSourcesToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        AssociationList lSources = mdoFM.getFeatureSources(false);
        lSources.clear();
        for (int iSource = 0; iSource < this.m_lSources.size(); ++iSource) {
            lSources.add(omr.acquireOMRObject((IColumn)this.m_lSources.get(iSource)));
        }
    }

    protected void saveTargetsToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        AssociationList lTargets = mdoFM.getFeatureTargets(false);
        lTargets.clear();
        for (int iTarget = 0; iTarget < this.m_lTargets.size(); ++iTarget) {
            lTargets.add(omr.acquireOMRObject((IColumn)this.m_lTargets.get(iTarget)));
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.m_bChangedDuringLoad = false;
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        this.loadTypeFromOMR(mdoFM);
        this.m_lSources.clear();
        this.loadSourcesFromOMR(omr, mdoFM);
        this.m_lTargets.clear();
        this.loadTargetsFromOMR(omr, mdoFM);
        if (!"ONETOONE".equals(this.m_sType)) {
            this.loadExpressionFromOMR(omr, mdoFM);
        }
        this.setChanged(this.m_bChangedDuringLoad);
    }

    protected void loadTypeFromOMR(FeatureMap mdoFM) throws RemoteException {
        this.setTypeImpl(mdoFM.getTransformRole());
    }

    protected void loadSourcesFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        AssociationList lSources = mdoFM.getFeatureSources();
        for (int iSource = 0; iSource < lSources.size(); ++iSource) {
            this.addSource((IColumn)omr.acquireObject((Root)((Column)lSources.get(iSource))));
        }
    }

    protected void loadTargetsFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        AssociationList lTargets = mdoFM.getFeatureTargets();
        for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
            this.addTarget((IColumn)omr.acquireObject((Root)((Column)lTargets.get(iTarget))));
        }
    }

    protected void loadExpressionFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        Text mdoExpression = mdoFM.getSourceCode();
        if (mdoExpression != null && mdoExpression.getCMetadataType().equalsIgnoreCase("TextStore")) {
            ITextExpression exp = this.getObjectFactory().createTextExpression(mdoExpression.getFQID());
            this.setExpression(exp);
            exp.setExpressionAnchor((AbstractTransformation)mdoFM);
            exp.loadFromOMR(omr);
        }
    }

    @Override
    public String getOMRType() {
        return "FeatureMap";
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        lAssociations.add("FeatureSources");
        lAssociations.add("FeatureTargets");
        lAssociations.add("SourceCode");
        lAssociations.add("SubstitutionVariables");
        lAssociations = (List)map.get("TextStore");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            map.put("TextStore", lAssociations);
        }
        lAssociations.add("PropertySets");
        return map;
    }

    @Override
    public void dump(PrintStream strm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID());
        sb.append(":");
        sb.append("ONETOONE".equals(this.m_sType) ? "1to1" : ("DERIVED".equals(this.m_sType) ? "Derived" : this.m_sType));
        sb.append(":");
        for (int iSource = 0; iSource < this.m_lSources.size(); ++iSource) {
            IColumn source = (IColumn)this.m_lSources.get(iSource);
            sb.append(source + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("->");
        for (int iTarget = 0; iTarget < this.m_lTargets.size(); ++iTarget) {
            IColumn target = (IColumn)this.m_lTargets.get(iTarget);
            sb.append(target + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        strm.println(sb.toString());
    }

    @Override
    public boolean isMappingNeeded(boolean quoting, ITable sourceTable) {
        IColumn sourceColumn;
        if ("DERIVED".equals(this.getType())) {
            return true;
        }
        if ("ONETOONE".equals(this.getType()) && (sourceColumn = this.findSourceTableColumnInMapping(sourceTable)) != null) {
            IColumn targetColumn = this.getTargets()[0];
            return this.isMappingRename(quoting, sourceTable) || targetColumn.getLength() != sourceColumn.getLength() || targetColumn.getFormat() != "" && !targetColumn.equalsFormat(sourceColumn) || targetColumn.getInformat() != "" && !targetColumn.equalsInformat(sourceColumn) || targetColumn.getDescription() != "" && !targetColumn.equalsLabel(sourceColumn);
        }
        return false;
    }

    @Override
    public IColumn findSourceTableColumnInMapping(ITable sourceTable) {
        IColumn[] sources = this.getSources();
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i].getTable() != sourceTable) continue;
            return sources[i];
        }
        return null;
    }

    @Override
    public boolean isMappingRename(boolean quoting, ITable sourceTable) {
        IColumn sourceColumn;
        boolean rename = false;
        if ("ONETOONE".equals(this.getType()) && (sourceColumn = this.findSourceTableColumnInMapping(sourceTable)) != null) {
            String tName;
            IColumn targetColumn = this.getTargets()[0];
            String sName = quoting ? sourceColumn.getName() : sourceColumn.getName().toUpperCase();
            String string = tName = quoting ? targetColumn.getName() : targetColumn.getName().toUpperCase();
            if (!sName.equals(tName) || targetColumn.getLength() != sourceColumn.getLength() && targetColumn.getLength() > 0) {
                rename = true;
            }
        }
        return rename;
    }

    private class SetReplacingUndoable
    extends AbstractUndoableEdit {
        private boolean m_bSetOnUndo;

        public SetReplacingUndoable(boolean bSetOnUndo) {
            this.m_bSetOnUndo = bSetOnUndo;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.m_bReplacing = this.m_bSetOnUndo;
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.m_bReplacing = !this.m_bSetOnUndo;
        }
    }

    private class SetExpressionUndoable
    extends AbstractUndoableEdit {
        private IExpression m_oldExpression;
        private IExpression m_newExpression;

        public SetExpressionUndoable(IExpression oldExpression, IExpression newExpression) {
            this.m_oldExpression = oldExpression;
            this.m_newExpression = newExpression;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.setExpression(this.m_oldExpression);
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.setExpression(this.m_newExpression);
        }
    }

    private class SetTypeUndoable
    extends AbstractUndoableEdit {
        private String m_sOldType;
        private String m_sNewType;

        public SetTypeUndoable(String sOldType, String sNewType) {
            this.m_sOldType = sOldType;
            this.m_sNewType = sNewType;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.setTypeImpl(this.m_sOldType);
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.setTypeImpl(this.m_sNewType);
        }
    }

    private class RemoveTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IColumn m_column;

        public RemoveTargetUndoable(int iTarget, IColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.addTarget(this.m_iTarget, this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.removeTarget(this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }

    private class AddTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IColumn m_column;

        public AddTargetUndoable(int iTarget, IColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.removeTarget(this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.addTarget(this.m_iTarget, this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }

    private class RemoveSourceUndoable
    extends AbstractUndoableEdit {
        private int m_iSource;
        private IColumn m_column;

        public RemoveSourceUndoable(int iSource, IColumn column) {
            this.m_iSource = iSource;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.addSource(this.m_iSource, this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.removeSource(this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }

    private class AddSourceUndoable
    extends AbstractUndoableEdit {
        private int m_iSource;
        private IColumn m_column;

        public AddSourceUndoable(int iSource, IColumn column) {
            this.m_iSource = iSource;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            BaseMapping.this.removeSource(this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            BaseMapping.this.addSource(this.m_iSource, this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }
}

