/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.impl.AbstractParametersContainer;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IGeneratedTransformDefinition;
import com.sas.etl.models.job.IGeneratedTransformTemplate;
import com.sas.etl.models.job.impl.GeneratedTransformNames;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.UsageVersion;
import com.sas.util.ValueItem;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BaseGeneratedTransformDefinition
extends AbstractParametersContainer
implements IGeneratedTransformDefinition {
    private static final String PROPERTY_NAME_VERSION = "VERSION";
    private static String OPTION_NAME_HELPPRODUCT = "DIS_HELP_PRODUCT";
    private static String OPTION_NAME_HELPID = "DIS_HELP_ID";
    private static String OPTION_NAME_HELPCLASS = "DIS_HELP_CLASS";
    private String m_strTransformClass = "";
    private String m_strTransformationStepXML = "";
    private String m_strCode = "";
    private boolean m_bDeleteOutputs = true;
    private int m_intTransformVersion = 1;
    private IGeneratedTransformTemplate m_template;
    private boolean m_bGenerateColumnMappings = false;

    public BaseGeneratedTransformDefinition(String sID, IModel model) {
        super(sID, model);
        this.setTemplate(model.getObjectFactory().createNewGeneratedTransformTemplate(sID));
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        lAssociations.add("Properties");
        lAssociations = new ArrayList<String>();
        lAssociations.add("StoredConfiguration");
        map.put("Property", lAssociations);
        return map;
    }

    @Override
    public String getOMRType() {
        return "Prototype";
    }

    @Override
    public String getPublicType() {
        return "GeneratedTransform";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    @Override
    public String getTransformClass() {
        return this.m_strTransformClass;
    }

    public void setTransformClass(String newClass) {
        this.m_strTransformClass = newClass;
        GeneratedTransformNames names = new GeneratedTransformNames(newClass);
        if (names.isNameStoredInBundle()) {
            this.setName(names.getName());
            this.setDescription(names.getDescription());
        }
    }

    @Override
    public int getTransformVersion() {
        return this.m_intTransformVersion;
    }

    public void setTransformVersion(int version) {
        this.m_intTransformVersion = version;
    }

    public static String createNewTransformClassId() {
        return GUID.newGUID();
    }

    public String getTransformationStepXML() {
        return this.m_strTransformationStepXML;
    }

    public void setTransformationStepXML(String transformationStepXML) {
        this.m_strTransformationStepXML = transformationStepXML;
    }

    @Override
    public boolean isDeletingOutputs() {
        return this.m_bDeleteOutputs;
    }

    public void setDeletingOutputs(boolean bDeleteOutputs) {
        if (this.m_bDeleteOutputs == bDeleteOutputs) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDeletingOutputsUndoable(this.m_bDeleteOutputs, bDeleteOutputs));
        }
        this.m_bDeleteOutputs = bDeleteOutputs;
        this.fireModelChangedEvent("IGeneratedTransformDefinition:CodeChanged", null);
    }

    @Override
    public String getSourceCode() {
        return this.m_strCode;
    }

    public void setSourceCode(String code) {
        if (this.m_strCode.equalsIgnoreCase(code)) {
            return;
        }
        if (code == null) {
            throw new NullPointerException("code must not be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCodeUndoable(this.m_strCode, code));
        }
        this.m_strCode = code;
        this.fireModelChangedEvent("IGeneratedTransformDefinition:CodeChanged", null);
    }

    @Override
    public void setPromptGroup(PromptGroupInterface promptGroup) {
        super.setPromptGroup(promptGroup);
        if (promptGroup != null) {
            this.setDeletingOutputs(promptGroup.getPromptDefinition("ADMIN.DONTDELETEOUTPUTS", true) == null);
        } else {
            this.setDeletingOutputs(true);
        }
    }

    @Override
    public IPromptModel getOptionModel(IDataTransform transform) throws ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException, IOException {
        return new GeneratedTransformDefinitionPromptModel(transform.getModel(), (GeneratedTransformModel)transform);
    }

    @Override
    public String getHelpClass() {
        Object val;
        IPromptDefinitionValue helpDef;
        String helpClass = null;
        IPromptModel optionModel = this.getPromptModel();
        if (optionModel != null && (helpDef = optionModel.getPromptDefinitionValue(OPTION_NAME_HELPCLASS)) != null && (val = helpDef.getValue()) instanceof String && ((String)val).length() > 0) {
            helpClass = (String)val;
        }
        return helpClass;
    }

    @Override
    public String getHelpProduct() {
        GeneratedTransformNames names;
        Object val;
        IPromptDefinitionValue helpDef;
        String helpProd = "wdb";
        IPromptModel optionModel = this.getPromptModel();
        if (optionModel != null && (helpDef = optionModel.getPromptDefinitionValue(OPTION_NAME_HELPPRODUCT)) != null && (val = helpDef.getValue()) instanceof String && ((String)val).length() > 0) {
            helpProd = (String)val;
        }
        if ((names = new GeneratedTransformNames(this.getTransformClass())).isNameStoredInBundle() && names.getHelpId() != null && names.getHelpId().length() > 0) {
            helpProd = "wdb";
        }
        return helpProd;
    }

    @Override
    public String getHelpId() {
        GeneratedTransformNames names;
        Object val;
        IPromptDefinitionValue helpDef;
        String helpId = "";
        IPromptModel optionModel = this.getPromptModel();
        if (optionModel != null && (helpDef = optionModel.getPromptDefinitionValue(OPTION_NAME_HELPID)) != null && (val = helpDef.getValue()) instanceof String && ((String)val).length() > 0) {
            helpId = (String)val;
        }
        if ((names = new GeneratedTransformNames(this.getTransformClass())).isNameStoredInBundle() && names.getHelpId() != null && names.getHelpId().length() > 0) {
            helpId = names.getHelpId();
        }
        return helpId;
    }

    public void setTemplate(IGeneratedTransformTemplate template) {
        if (this.m_template == template) {
            return;
        }
        this.m_template = template;
    }

    @Override
    public IGeneratedTransformTemplate getTemplate() {
        return this.m_template;
    }

    @Override
    public int getMaximumDataSourceCount() {
        return this.m_template.getSourceMaximum();
    }

    @Override
    public int getMaximumDataTargetCount() {
        return this.m_template.getTargetMaximum();
    }

    @Override
    public int getMinimumDataSourceCount() {
        return this.m_template.getSourceMinimum();
    }

    @Override
    public int getMinimumDataTargetCount() {
        return this.m_template.getTargetMinimum();
    }

    @Override
    public void setGenerateMappingMacros(boolean generateMappings) {
        this.m_bGenerateColumnMappings = generateMappings;
    }

    @Override
    public boolean getGenerateMappingMacros() {
        return this.m_bGenerateColumnMappings;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Prototype mdoPrototype = (Prototype)omr.acquireOMRObject(this);
        this.loadTransformationStepXML(omr.getOMRFactory(), mdoPrototype);
        this.loadGuid(mdoPrototype);
        this.setTransformVersion(Integer.parseInt(this.loadPropertyFromOMR(omr, "", PROPERTY_NAME_VERSION, "1", 1)));
        this.setGenerateMappingMacros(this.findProperty(omr, (Root)mdoPrototype, "ADMIN.GENERATE_MAPPING_MACROS", "ADMIN.GENERATE_MAPPING_MACROS", 1) != null);
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Prototype mdoPrototype = (Prototype)omr.acquireOMRObject(this);
        this.saveTransformationStepXML(omr, mdoPrototype);
        this.saveGuid(omr, mdoPrototype);
        int newVersion = this.getTransformVersion() + 1;
        this.savePropertyToOMR(omr, "", PROPERTY_NAME_VERSION, PROPERTY_NAME_VERSION, PROPERTY_NAME_VERSION, Integer.toString(newVersion), 4, 1);
        this.setTransformVersion(newVersion);
    }

    private void loadGuid(Prototype proto) throws MdException, RemoteException {
        Property prop = this.findGUIDProperty(proto);
        if (prop != null) {
            this.setTransformClass(prop.getDefaultValue());
        } else {
            String sGetXML = this.getTransformationStepXML();
            if (sGetXML == null) {
                throw new MdException("GetXML not found");
            }
            Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
            Matcher matcher = pattern.matcher(sGetXML);
            String strGUID = null;
            if (matcher.find()) {
                strGUID = matcher.group();
            }
            this.setTransformClass(strGUID);
        }
    }

    private Property findGUIDProperty(Prototype proto) throws MdException, RemoteException {
        AssociationList lstProps = proto.getProperties();
        int size = lstProps.size();
        for (int i = 0; i < size; ++i) {
            Property p = (Property)lstProps.get(i);
            if (!p.getPropertyName().equals("Class")) continue;
            return p;
        }
        return null;
    }

    private TextStore getGetXMLTextStore(Prototype mdoTransform) throws MdException, RemoteException {
        TextStore textStore = null;
        if (mdoTransform != null) {
            AssociationList lProperties = mdoTransform.getProperties();
            for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
                TextStore storedText;
                String sGetXML;
                Property property = (Property)lProperties.get(iProperty);
                if (!property.getPropertyName().equalsIgnoreCase("GetXML") || (sGetXML = (storedText = (TextStore)property.getStoredConfiguration()).getStoredText()).indexOf("PropertyName=\"Class\"") <= -1) continue;
                textStore = storedText;
                break;
            }
        }
        return textStore;
    }

    private void createGUIDProperty(OMRAdapter omr, Prototype proto) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, "", "Class", "Class", "ESMACRO", this.getTransformClass(), 12, 1);
    }

    private void saveGuid(OMRAdapter omr, Prototype proto) throws MdException, RemoteException {
        Property prop = this.findGUIDProperty(proto);
        if (prop != null) {
            prop.setDefaultValue(this.getTransformClass());
        } else {
            this.createGUIDProperty(omr, proto);
        }
    }

    private void saveTransformationStepXML(OMRAdapter omr, Prototype mdoTransform) throws MdException, RemoteException {
        String sGetXML;
        TextStore storedText = this.getGetXMLTextStore(mdoTransform);
        if (storedText != null && (sGetXML = this.getTransformationStepXML()) != null) {
            Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
            Matcher matcher = pattern.matcher(sGetXML);
            String sNewStoredText = matcher.replaceAll(this.getTransformClass());
            String strNormalizedSourceCode = omr.getOMRFactory().getOMIUtil().cleanStringForXML(this.getSourceCode());
            int index = sNewStoredText.indexOf("SASCODE");
            int index2 = sNewStoredText.indexOf("StoredText", index);
            int index3 = sNewStoredText.indexOf("/StoredConfiguration", index2);
            String substr1 = sNewStoredText.substring(0, index2 += 12);
            String substr2 = sNewStoredText.substring(index3 -= 4);
            sNewStoredText = substr1 + strNormalizedSourceCode + substr2;
            storedText.setStoredText(sNewStoredText);
        }
    }

    private StringBuffer populateAssociationProperties(Prototype prototype) {
        int outputLoopLength;
        int i;
        int inputLoopLength;
        StringBuffer storedText = new StringBuffer();
        boolean fStartOfString = false;
        int minInputs = this.getMinimumDataSourceCount();
        int maxInputs = this.getMaximumDataSourceCount();
        int minOutputs = this.getMinimumDataTargetCount();
        int maxOutputs = this.getMaximumDataTargetCount();
        Object inputNames = null;
        List inputPrompts = null;
        Object outputNames = null;
        List outputPrompts = null;
        if (minInputs > 0 || maxInputs > 0 || minOutputs > 0 || maxOutputs > 0 || maxInputs == -1 || maxOutputs == -1) {
            fStartOfString = true;
            storedText.append("<UsingPrototype>");
            storedText.append("<Prototype Name=\"PFDTEMPLATE\">");
            storedText.append("<PrototypeProperties>");
        }
        if (minInputs == -1 || minInputs == 0 && maxInputs == -1) {
            inputLoopLength = inputPrompts == null ? 0 : inputPrompts.size();
            for (i = 0; i < inputLoopLength; ++i) {
            }
        } else if (minInputs > 0 || maxInputs > 0) {
            inputLoopLength = inputPrompts == null ? minInputs : (minInputs < inputPrompts.size() ? inputPrompts.size() : minInputs);
            for (i = 0; i < inputLoopLength; ++i) {
            }
            if (inputPrompts == null && (maxInputs > 0 || maxInputs == -1) || inputPrompts == null || maxInputs > inputPrompts.size() || maxInputs == -1) {
                // empty if block
            }
        }
        if (minOutputs == -1 || minOutputs == 0 && maxOutputs == -1) {
            outputLoopLength = outputPrompts == null ? 0 : outputPrompts.size();
            for (i = 0; i < outputLoopLength; ++i) {
            }
        } else if (minOutputs > 0 || maxOutputs > 0) {
            outputLoopLength = outputPrompts == null ? minOutputs : (minOutputs < outputPrompts.size() ? outputPrompts.size() : minOutputs);
            for (i = 0; i < outputLoopLength; ++i) {
            }
            if (outputPrompts == null && (maxOutputs > 0 || maxOutputs == -1) || outputPrompts == null || maxOutputs > outputPrompts.size() || maxOutputs == -1) {
                // empty if block
            }
        }
        if (fStartOfString) {
            storedText.append("</PrototypeProperties></Prototype></UsingPrototype>");
        }
        return storedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransformationStepXML(MdFactory mdFactory, Prototype protoFromRepository) throws MdException, RemoteException {
        TextStore storedText = this.getGetXMLTextStore(protoFromRepository);
        if (storedText != null) {
            this.setTransformationStepXML(storedText.getStoredText());
            String strGetXML = this.getTransformationStepXML();
            Document doc = mdFactory.getOMIUtil().parseXML(strGetXML);
            Node firstNode = doc.getFirstChild();
            OMRAdapter omr = new OMRAdapter(this.getModel(), mdFactory, "BaseGeneratedTransformDefinition: LoadPortInformation");
            String objectId = this.getModel().createIDForNewObject(this.getID());
            TransformationStep stepFromPrototype = (TransformationStep)omr.acquireOMRObject(objectId, "TransformationStep");
            try {
                ArrayList inputs = new ArrayList();
                ArrayList outputs = new ArrayList();
                stepFromPrototype = (TransformationStep)this.populateNewObjects(omr, (CMetadata)stepFromPrototype, firstNode.getAttributes(), firstNode.getChildNodes(), inputs, outputs);
                Prototype stepPrototypeFromPrototype = (Prototype)stepFromPrototype.getUsingPrototype();
                if (stepPrototypeFromPrototype != null) {
                    this.m_template = this.getModel().getObjectFactory().createGeneratedTransformTemplate(stepPrototypeFromPrototype.getFQID());
                    omr.populateFor(this.m_template);
                    this.m_template.loadFromOMR(omr);
                }
                ClassifierMap mapFromPrototype = (ClassifierMap)stepFromPrototype.getTransformations().elementAt(0);
                Prototype mapPrototypeFromPrototype = (Prototype)mapFromPrototype.getUsingPrototype();
                Property prop = (Property)mapPrototypeFromPrototype.getProperties().get(0);
                TextStore sourceCodeStoreFromPrototype = (TextStore)prop.getStoredConfiguration();
                this.setSourceCode(sourceCodeStoreFromPrototype.getStoredText());
            }
            finally {
                omr.dispose();
            }
        }
    }

    private CMetadata populateNewObjects(OMRAdapter omr, CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, ArrayList inputs, ArrayList outputs) throws RemoteException {
        metaObject = this.doSimple(metaObject, simpleNodeMap, inputs, outputs);
        ArrayList outComplexNames = new ArrayList();
        ArrayList[] outComplexObjects = new ArrayList[1];
        outComplexObjects = this.doComplex(omr, metaObject, complexNodeList, outComplexNames, outComplexObjects, inputs, outputs);
        BaseGeneratedTransformDefinition.setComplex(metaObject, outComplexNames, outComplexObjects);
        return metaObject;
    }

    private static void setComplex(CMetadata metaObject, ArrayList outComplexNames, ArrayList[] outComplexObjects) {
        int length = outComplexNames.size();
        Class[] classes = new Class[]{AssociationList.class};
        for (int i = 0; i < length; ++i) {
            String AssocName = (String)outComplexNames.get(i);
            AssociationList complexAssoc = new AssociationList(AssocName, (Collection)outComplexObjects[i]);
            complexAssoc.setState(4);
            try {
                StringBuffer strTemp = new StringBuffer("set");
                strTemp.append(AssocName);
                if (!AssocName.endsWith("s")) {
                    strTemp.append("s");
                }
                Method method = metaObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classes);
                Object[] args = new Object[]{complexAssoc};
                try {
                    method.invoke((Object)metaObject, args);
                }
                catch (InvocationTargetException e) {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::setComplex -> Can't call method: " + strTemp.substring(0, strTemp.length()) + ", Object not found"));
                }
                catch (IllegalAccessException e) {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::setComplex -> Can't call method: " + strTemp.substring(0, strTemp.length()) + ", No Permission"));
                }
                continue;
            }
            catch (NoSuchMethodException e) {
                try {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::setComplex -> Can't set association: " + AssocName + ", on object:" + metaObject.getCMetadataType() + ", ID: " + metaObject.getFQID()));
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    private CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap, ArrayList inputs, ArrayList outputs) throws RemoteException {
        int iLengthinSimpleAttr = thisNodeMap.getLength();
        Class[] classes = new Class[]{String.class, Integer.TYPE};
        Integer state = new Integer(1);
        boolean AssocProptype = false;
        if (thisObject instanceof AssociationProperty) {
            AssocProptype = true;
        }
        for (int i = 0; i < iLengthinSimpleAttr; ++i) {
            try {
                StringBuffer strTemp = new StringBuffer("set");
                Object[] args = null;
                if (AssocProptype && thisNodeMap.item(i).getNodeName().equals("MetadataType")) {
                    String value = thisNodeMap.item(i).getNodeValue();
                    if (value.indexOf("INPUT") > -1) {
                        inputs.add(thisObject);
                    } else if (value.indexOf("OUTPUT") > -1) {
                        outputs.add(thisObject);
                    }
                }
                strTemp.append(thisNodeMap.item(i).getNodeName());
                args = new Object[]{thisNodeMap.item(i).getNodeValue(), state};
                Method method = thisObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classes);
                try {
                    method.invoke((Object)thisObject, args);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return thisObject;
    }

    private ArrayList[] doComplex(OMRAdapter omr, CMetadata thisObject, NodeList thisNodeList, ArrayList outComplexNames, ArrayList[] outComplexObjects, ArrayList inputs, ArrayList outputs) throws RemoteException {
        String name = "";
        int numChildLists = thisNodeList.getLength();
        MdStore thisStore = thisObject.getObjectStore();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                String strType = myChildNodeList.item(i).getNodeName();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                if (nameNode != null) {
                    name = nameNode.getNodeValue();
                }
                CMetadata complexObject = omr.getOMRFactory().createComplexMetadataObject((MdObjectStore)thisStore, null, name, strType, this.getModel().createIDForNewObject(this.getID()), null);
                thisObject.addElementToChangeList(complexObject);
                complexObject = this.populateNewObjects(omr, complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), inputs, outputs);
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    private class SetDeletingOutputsUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDeletingOutputs;
        private boolean m_newDeletingOutputs;

        public SetDeletingOutputsUndoable(boolean oldDeletingOutputs, boolean newDeletingOutputs) {
            this.m_oldDeletingOutputs = oldDeletingOutputs;
            this.m_newDeletingOutputs = newDeletingOutputs;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformDefinition.this.setDeletingOutputs(this.m_oldDeletingOutputs);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformDefinition.this.setDeletingOutputs(this.m_newDeletingOutputs);
        }
    }

    private class SetCodeUndoable
    extends AbstractUndoableEdit {
        private String m_oldCode;
        private String m_newCode;

        public SetCodeUndoable(String oldCode, String newCode) {
            this.m_oldCode = oldCode;
            this.m_newCode = newCode;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformDefinition.this.setSourceCode(this.m_oldCode);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformDefinition.this.setSourceCode(this.m_newCode);
        }
    }

    private class GeneratedTransformDefinitionPromptModel
    extends BaseDataTransformPromptModel {
        public GeneratedTransformDefinitionPromptModel(IModel model, GeneratedTransformModel transform) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, transform);
        }

        @Override
        protected PromptGroupInterface getPromptGroupInstance() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            return this.getPromptGroup();
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp1;
            PromptDefinitionInterface updateDef;
            PromptGroupInterface grp = super.getPromptGroup();
            PromptDefinitionInterface system = grp.getPromptDefinition("SystemOptions", true);
            PromptGroupInterface subGrp = grp.findPromptSubgroup(system);
            if (system != null && subGrp != null) {
                this.addCommonGeneratedOptions(subGrp);
            }
            if ((updateDef = (grp1 = ((GeneratedTransformModel)this.getOwner()).getTransformDefinition().getPromptGroup()).getPromptDefinition("ADMIN.DONTDELETEOUTPUTS", true)) != null) {
                PromptGroupInterface g = grp1.findPromptSubgroup(updateDef);
                g.removePromptDefinition(updateDef);
                grp.addPromptDefinition(updateDef);
            }
            return this.combinePromptGroups(grp1, grp);
        }

        protected void addCommonGeneratedOptions(PromptGroupInterface promptGroup) {
            TextDefinition updateMetadata = new TextDefinition("ADMIN.UPDATEMETADATA");
            updateMetadata.setPromptLabel(RB.getStringResource("BaseGeneratedTransformDefinition.UpdateMetadata.label.txt"), Locale.getDefault());
            updateMetadata.setPromptDescription(RB.getStringResource("BaseGeneratedTransformDefinition.UpdateMetadata.desc.txt"), Locale.getDefault());
            updateMetadata.setMinimumValueCount(1);
            updateMetadata.setAllowUserValues(false);
            ArrayList<ValueItem> valueList1 = new ArrayList<ValueItem>();
            ValueItem vItem3 = new ValueItem((Object)RB.getStringResource("Common.Yes.txt"), (Object)"YES");
            ValueItem vItem4 = new ValueItem((Object)RB.getStringResource("Common.No.txt"), (Object)"NO");
            valueList1.add(vItem3);
            valueList1.add(vItem4);
            StaticValueProvider sp1 = new StaticValueProvider(valueList1, Locale.getDefault());
            updateMetadata.setValueProvider((ValueProviderInterface)sp1);
            updateMetadata.setDefaultValue((Object)"NO");
            promptGroup.addPromptDefinition((PromptDefinitionInterface)updateMetadata, 0);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue("ADMIN.UPDATEMETADATA", (Object)(((GeneratedTransformModel)this.getOwner()).isUpdateTableMetadata() ? "YES" : "NO"));
            this.debugPromptXML();
        }

        @Override
        public IPromptDefinitionValue[] getPromptDefinitionsToCodeGen() {
            return this.getTransformPromptDefinitions();
        }

        @Override
        public IPromptDefinitionValue[] getPromptDefinitionsToPersist() {
            return this.getTransformPromptDefinitions();
        }

        private IPromptDefinitionValue[] getTransformPromptDefinitions() {
            List<IPromptDefinitionValue> transformDefinitions = Arrays.asList(this.getTransformDefinitionValues());
            IPromptDefinitionValue[] values = super.getPromptDefinitionValues();
            ArrayList<IPromptDefinitionValue> promptValues = new ArrayList<IPromptDefinitionValue>();
            for (int i = 0; i < values.length; ++i) {
                String name = values[i].getName();
                if ("ADMIN.DONTDELETEOUTPUTS".equals(name) || transformDefinitions.contains(values[i])) continue;
                promptValues.add(values[i]);
            }
            return promptValues.toArray(new IPromptDefinitionValue[promptValues.size()]);
        }

        @Override
        protected IModelListener createModelListener() {
            return new GeneratedTransformModelChangedListener((GeneratedTransformModel)this.getOwner(), this);
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new GeneratedTransformValueChangedListener((GeneratedTransformModel)this.getOwner(), this);
        }

        private class GeneratedTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public GeneratedTransformValueChangedListener(GeneratedTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals("ADMIN.UPDATEMETADATA")) {
                        ((GeneratedTransformModel)this.getOwner()).setUpdateTableMetadata("YES".equalsIgnoreCase(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class GeneratedTransformModelChangedListener
        extends BaseDataTransformModelListener {
            public GeneratedTransformModelChangedListener(GeneratedTransformModel transform, IPromptModel model) {
                super(transform, model);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals("GeneratedTransformModel:UpdateTableMetadataChanged")) {
                        this.m_promptModel.setOptionValue("ADMIN.UPDATEMETADATA", (Object)(((GeneratedTransformModel)ev.getModelObject()).isUpdateTableMetadata() ? "YES" : "NO"));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().debug((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().debug((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().debug((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().debug((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

