/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITransform;
import com.sas.workspace.WsAppServer;
import java.util.ArrayList;
import java.util.List;

public class BaseDesignTimeModel
extends BaseModel
implements IDesignTimeModel {
    protected IJob m_job;
    private WsAppServer m_appServer;

    public BaseDesignTimeModel() {
    }

    public BaseDesignTimeModel(IJob job) {
        this.setJob(job);
    }

    @Override
    public void setJob(IJob job) {
        this.m_job = job;
    }

    @Override
    public IJob getJob() {
        return this.m_job;
    }

    @Override
    public void setSASAppServer(WsAppServer server) {
        if (server == this.m_appServer) {
            return;
        }
        if (this.m_appServer != null) {
            this.m_appServer.dispose();
        }
        this.m_appServer = server;
    }

    @Override
    public WsAppServer getSASAppServer() {
        return this.m_appServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromBeginningToEnd() {
        PropagateFromBeginningConfiguration configBeginning = new PropagateFromBeginningConfiguration();
        PropagateToEndConfiguration configEnd = new PropagateToEndConfiguration();
        ITransform[] aTransforms = this.m_job.getTransforms();
        this.startCompoundUndoable();
        try {
            for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
                IDataTransform xfm;
                ContainerTablePair pair;
                if (!(aTransforms[iTransform] instanceof IDataTransform) || configBeginning.isInVisitedList(pair = new ContainerTablePair(xfm = (IDataTransform)aTransforms[iTransform], null)) || configEnd.isInVisitedList(pair)) continue;
                configBeginning.addToVisitedList(pair);
                configEnd.addToVisitedList(pair);
                ITable[] aSources = xfm.getSourceTables();
                ITable[] aTargets = xfm.getTargetTables();
                this.propagateImpl(aSources, configBeginning, 1);
                configEnd.addToVisitedList(configBeginning.getVisitedList());
                if (xfm.isIncludedInPropagation()) {
                    xfm.propagateColumnsToTargetTables(aSources, aTargets, 1);
                }
                this.propagateImpl(aTargets, configEnd, 1);
                configBeginning.addToVisitedList(configEnd.getVisitedList());
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromEndToBeginning() {
        PropagateToBeginningConfiguration configBeginning = new PropagateToBeginningConfiguration();
        PropagateFromEndConfiguration configEnd = new PropagateFromEndConfiguration();
        ITransform[] aTransforms = this.m_job.getTransforms();
        this.startCompoundUndoable();
        try {
            for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
                IDataTransform xfm;
                ContainerTablePair pair;
                if (!(aTransforms[iTransform] instanceof IDataTransform) || configBeginning.isInVisitedList(pair = new ContainerTablePair(xfm = (IDataTransform)aTransforms[iTransform], null)) || configEnd.isInVisitedList(pair)) continue;
                configBeginning.addToVisitedList(pair);
                configEnd.addToVisitedList(pair);
                ITable[] aSources = xfm.getSourceTables();
                ITable[] aTargets = xfm.getTargetTables();
                this.propagateImpl(aTargets, configEnd, 1);
                configBeginning.addToVisitedList(configEnd.getVisitedList());
                if (xfm.isIncludedInPropagation()) {
                    xfm.propagateColumnsToSourceTables(aSources, aTargets, 1);
                }
                this.propagateImpl(aSources, configBeginning, 1);
                configEnd.addToVisitedList(configBeginning.getVisitedList());
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromBeginningToEnd(IDataTransform xfm, ITable tblTarget) {
        this.startCompoundUndoable();
        try {
            PropagateFromBeginningConfiguration configBeginning = new PropagateFromBeginningConfiguration();
            PropagateToEndConfiguration configEnd = new PropagateToEndConfiguration();
            ContainerTablePair pair = new ContainerTablePair(xfm, null);
            configBeginning.addToVisitedList(pair);
            configEnd.addToVisitedList(pair);
            ITable[] aSourceTables = xfm.getSourceTables();
            ITable[] aTargetTables = new ITable[]{tblTarget};
            this.propagateImpl(aSourceTables, configBeginning, 1);
            if (xfm.isIncludedInPropagation()) {
                xfm.propagateColumnsToTargetTables(aSourceTables, aTargetTables, 1);
            }
            configEnd.addToVisitedList(configBeginning.getVisitedList());
            this.propagateImpl(aTargetTables, configEnd, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromBeginningToEnd(ITable tblSource, IDataTransform xfm) {
        this.startCompoundUndoable();
        try {
            PropagateFromBeginningConfiguration configBeginning = new PropagateFromBeginningConfiguration();
            PropagateToEndConfiguration configEnd = new PropagateToEndConfiguration();
            ContainerTablePair pair = new ContainerTablePair(xfm, null);
            configBeginning.addToVisitedList(pair);
            configEnd.addToVisitedList(pair);
            ITable[] aSourceTables = new ITable[]{tblSource};
            ITable[] aTargetTables = xfm.getTargetTables();
            this.propagateImpl(aSourceTables, configBeginning, 1);
            if (xfm.isIncludedInPropagation()) {
                xfm.propagateColumnsToTargetTables(aSourceTables, aTargetTables, 1);
            }
            configEnd.addToVisitedList(configBeginning.getVisitedList());
            this.propagateImpl(aTargetTables, configEnd, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromEndToBeginning(IDataTransform xfm, ITable tblTarget) {
        this.startCompoundUndoable();
        try {
            PropagateToBeginningConfiguration configBeginning = new PropagateToBeginningConfiguration();
            PropagateFromEndConfiguration configEnd = new PropagateFromEndConfiguration();
            ContainerTablePair pair = new ContainerTablePair(xfm, null);
            configBeginning.addToVisitedList(pair);
            configEnd.addToVisitedList(pair);
            ITable[] aSourceTables = xfm.getSourceTables();
            ITable[] aTargetTables = new ITable[]{tblTarget};
            this.propagateImpl(aTargetTables, configEnd, 1);
            if (xfm.isIncludedInPropagation()) {
                xfm.propagateColumnsToSourceTables(aSourceTables, aTargetTables, 1);
            }
            configBeginning.addToVisitedList(configEnd.getVisitedList());
            this.propagateImpl(aSourceTables, configBeginning, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromEndToBeginning(ITable tblSource, IDataTransform xfm) {
        this.startCompoundUndoable();
        try {
            PropagateToBeginningConfiguration configBeginning = new PropagateToBeginningConfiguration();
            PropagateFromEndConfiguration configEnd = new PropagateFromEndConfiguration();
            ContainerTablePair pair = new ContainerTablePair(xfm, null);
            configBeginning.addToVisitedList(pair);
            configEnd.addToVisitedList(pair);
            ITable[] aSourceTables = new ITable[]{tblSource};
            ITable[] aTargetTables = xfm.getTargetTables();
            this.propagateImpl(aTargetTables, configEnd, 1);
            if (xfm.isIncludedInPropagation()) {
                xfm.propagateColumnsToSourceTables(aSourceTables, aTargetTables, 1);
            }
            configBeginning.addToVisitedList(configEnd.getVisitedList());
            this.propagateImpl(aSourceTables, configBeginning, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void propagateFromSourcesToTargets(IMappingsContainer container) {
        this.propagateFromSourcesToTargets(container, container.getSourceTables(), container.getTargetTables());
    }

    @Override
    public void propagateFromSourcesToBeginning(IMappingsContainer container) {
        this.propagateFromSourcesToBeginning(container, container.getSourceTables());
    }

    @Override
    public void propagateFromSourcesToEnd(IMappingsContainer container) {
        this.propagateFromSourcesToEnd(container, container.getSourceTables(), container.getTargetTables());
    }

    @Override
    public void propagateFromBeginningToSources(IMappingsContainer container) {
        this.propagateFromBeginningToSources(container, container.getSourceTables());
    }

    @Override
    public void propagateFromEndToSources(IMappingsContainer container) {
        this.propagateFromEndToSources(container, container.getSourceTables(), container.getTargetTables());
    }

    @Override
    public void propagateFromTargetsToSources(IMappingsContainer container) {
        this.propagateFromTargetsToSources(container, container.getSourceTables(), container.getTargetTables());
    }

    @Override
    public void propagateFromTargetsToBeginning(IMappingsContainer container) {
        this.propagateFromTargetsToBeginning(container, container.getSourceTables(), container.getTargetTables());
    }

    @Override
    public void propagateFromTargetsToEnd(IMappingsContainer container) {
        this.propagateFromTargetsToEnd(container, container.getTargetTables());
    }

    @Override
    public void propagateFromBeginningToTargets(IMappingsContainer container) {
        this.propagateFromBeginningToTargets(container, container.getSourceTables(), container.getTargetTables());
    }

    @Override
    public void propagateFromEndToTargets(IMappingsContainer container) {
        this.propagateFromEndToTargets(container, container.getTargetTables());
    }

    @Override
    public void propagateFromSourcesToTargets(IMappingsContainer container, ITable[] aSourceTables, ITable[] aTargetTables) {
        container.propagateColumnsToTargetTables(aSourceTables, aTargetTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromSourcesToBeginning(IMappingsContainer container, ITable[] aSourceTables) {
        this.startCompoundUndoable();
        try {
            PropagateToBeginningConfiguration config = new PropagateToBeginningConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aSourceTables, config, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromSourcesToEnd(IMappingsContainer container, ITable[] aSourceTables, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            container.propagateColumnsToTargetTables(aSourceTables, aTargetTables);
            PropagateToEndConfiguration config = new PropagateToEndConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aTargetTables, config, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromBeginningToSources(IMappingsContainer container, ITable[] aSourceTables) {
        this.startCompoundUndoable();
        try {
            PropagateFromBeginningConfiguration config = new PropagateFromBeginningConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aSourceTables, config, 0);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromEndToSources(IMappingsContainer container, ITable[] aSourceTables, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            PropagateFromEndConfiguration config = new PropagateFromEndConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aTargetTables, config, 0);
            container.propagateColumnsToSourceTables(aSourceTables, aTargetTables);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void propagateFromTargetsToSources(IMappingsContainer container, ITable[] aSourceTables, ITable[] aTargetTables) {
        container.propagateColumnsToSourceTables(aSourceTables, aTargetTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromTargetsToBeginning(IMappingsContainer container, ITable[] aSourceTables, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            container.propagateColumnsToSourceTables(aSourceTables, aTargetTables);
            PropagateToBeginningConfiguration config = new PropagateToBeginningConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aSourceTables, config, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromTargetsToEnd(IMappingsContainer container, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            PropagateToEndConfiguration config = new PropagateToEndConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aTargetTables, config, 1);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromBeginningToTargets(IMappingsContainer container, ITable[] aSourceTables, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            PropagateFromBeginningConfiguration config = new PropagateFromBeginningConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aSourceTables, config, 0);
            container.propagateColumnsToTargetTables(aSourceTables, aTargetTables);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagateFromEndToTargets(IMappingsContainer container, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            PropagateFromEndConfiguration config = new PropagateFromEndConfiguration();
            config.addToVisitedList(new ContainerTablePair(container, null));
            this.propagateImpl(aTargetTables, config, 0);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void propagateImpl(ITable[] aTables, PropagationConfiguration config, int eNonWorkTableHandling) {
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IDataTransform[] aTransforms = config.getNextTransforms(aTables[iTable]);
            for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
                ContainerTablePair pair;
                IDataTransform xfm = aTransforms[iTransform];
                if (!xfm.isIncludedInPropagation() || config.isInVisitedList(pair = new ContainerTablePair(xfm, aTables[iTable]))) continue;
                config.addToVisitedList(pair);
                config.propagateColumns(xfm, aTables[iTable], eNonWorkTableHandling);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateFromSourcesToTargets(IMappingsContainer container, IColumn[] aSourceColumns, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                container.propagateColumnsToTargetTable(aSourceColumns, aTargetTables[iTargetTable]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateFromSourcesToBeginning(IMappingsContainer container, ITable[] aSourceTables, IColumn[] aSourceColumns) {
        this.startCompoundUndoable();
        try {
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                this.propagateColumnsFromSourceToBeginning(container, aSourceTables[iSourceTable], aSourceColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateFromSourcesToEnd(IMappingsContainer container, IColumn[] aSourceColumns, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                IColumn[] aTargetColumns = container.propagateColumnsToTargetTable(aSourceColumns, aTargetTables[iTargetTable]);
                this.propagateColumnsFromTargetToEnd(container, aTargetTables[iTargetTable], aTargetColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateFromTargetsToSources(IMappingsContainer container, ITable[] aSourceTables, IColumn[] aTargetColumns) {
        this.startCompoundUndoable();
        try {
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                container.propagateColumnsToSourceTable(aSourceTables[iSourceTable], aTargetColumns);
            }
        }
        finally {
            container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateFromTargetsToBeginning(IMappingsContainer container, ITable[] aSourceTables, IColumn[] aTargetColumns) {
        this.startCompoundUndoable();
        try {
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                IColumn[] aSourceColumns = container.propagateColumnsToSourceTable(aSourceTables[iSourceTable], aTargetColumns);
                this.propagateColumnsFromSourceToBeginning(container, aSourceTables[iSourceTable], aSourceColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateFromTargetsToEnd(IMappingsContainer container, ITable[] aTargetTables, IColumn[] aTargetColumns) {
        this.startCompoundUndoable();
        try {
            for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                this.propagateColumnsFromTargetToEnd(container, aTargetTables[iTargetTable], aTargetColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void propagateColumnsFromSourceToBeginning(IMappingsContainer container, ITable tblSource, IColumn[] aSourceColumns) {
        PropagateColumnsToBeginningConfiguration config = new PropagateColumnsToBeginningConfiguration();
        config.addToVisitedList(container);
        this.propagateColumnsImpl(tblSource, aSourceColumns, config, true);
    }

    private void propagateColumnsFromTargetToEnd(IMappingsContainer container, ITable tblTarget, IColumn[] aTargetColumns) {
        PropagateColumnsToEndConfiguration config = new PropagateColumnsToEndConfiguration();
        config.addToVisitedList(container);
        this.propagateColumnsImpl(tblTarget, aTargetColumns, config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedColumnsFromSourcesToTargets(IMappingsContainer container, IColumn[] aSourceColumns, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                container.updateMappedColumnsToTargetTable(aSourceColumns, aTargetTables[iTargetTable]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedColumnsFromSourcesToBeginning(IMappingsContainer container, ITable[] aSourceTables, IColumn[] aSourceColumns) {
        this.startCompoundUndoable();
        try {
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                this.updateMappedColumnsFromSourceToBeginning(container, aSourceTables[iSourceTable], aSourceColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedColumnsFromSourcesToEnd(IMappingsContainer container, IColumn[] aSourceColumns, ITable[] aTargetTables) {
        this.startCompoundUndoable();
        try {
            for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                IColumn[] aNewColumns = container.updateMappedColumnsToTargetTable(aSourceColumns, aTargetTables[iTargetTable]);
                this.updateMappedColumnsFromTargetToEnd(container, aTargetTables[iTargetTable], aNewColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedColumnsFromTargetsToSources(IMappingsContainer container, ITable[] aSourceTables, IColumn[] aTargetColumns) {
        this.startCompoundUndoable();
        try {
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                container.updateMappedColumnsToSourceTable(aSourceTables[iSourceTable], aTargetColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedColumnsFromTargetsToBeginning(IMappingsContainer container, ITable[] aSourceTables, IColumn[] aTargetColumns) {
        this.startCompoundUndoable();
        try {
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                IColumn[] aNewColumns = container.updateMappedColumnsToSourceTable(aSourceTables[iSourceTable], aTargetColumns);
                this.updateMappedColumnsFromSourceToBeginning(container, aSourceTables[iSourceTable], aNewColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedColumnsFromTargetsToEnd(IMappingsContainer container, ITable[] aTargetTables, IColumn[] aTargetColumns) {
        this.startCompoundUndoable();
        try {
            for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                this.updateMappedColumnsFromTargetToEnd(container, aTargetTables[iTargetTable], aTargetColumns);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void updateMappedColumnsFromSourceToBeginning(IMappingsContainer container, ITable tblSource, IColumn[] aSourceColumns) {
        UpdateColumnsToBeginningConfiguration config = new UpdateColumnsToBeginningConfiguration();
        config.addToVisitedList(container);
        this.propagateColumnsImpl(tblSource, aSourceColumns, config, true);
    }

    private void updateMappedColumnsFromTargetToEnd(IMappingsContainer container, ITable tblTarget, IColumn[] aTargetColumns) {
        UpdateColumnsToEndConfiguration config = new UpdateColumnsToEndConfiguration();
        config.addToVisitedList(container);
        this.propagateColumnsImpl(tblTarget, aTargetColumns, config, true);
    }

    private void propagateColumnsImpl(ITable tbl, IColumn[] aColumns, ColumnsPropagationConfiguration config, boolean bUpdateWorkTablesOnly) {
        IDataTransform[] aTransforms = config.getNextTransforms(tbl);
        for (int iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            IDataTransform xfm = aTransforms[iTransform];
            if (!xfm.isIncludedInPropagation() || config.isInVisitedList(xfm)) continue;
            config.addToVisitedList(xfm);
            ITable[] aTables = config.getNextTables(xfm);
            for (int iTable = 0; iTable < aTables.length; ++iTable) {
                if (bUpdateWorkTablesOnly && !(aTables[iTable] instanceof IWorkTable)) continue;
                IColumn[] aNewColumns = config.propagateColumns(xfm, aColumns, aTables[iTable]);
                this.propagateColumnsImpl(aTables[iTable], aNewColumns, config, true);
            }
        }
    }

    private class UpdateColumnsToEndConfiguration
    extends AbstractColumnsPropagationConfiguration {
        private UpdateColumnsToEndConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getConsumerTransforms();
        }

        @Override
        public ITable[] getNextTables(IDataTransform transform) {
            return transform.getTargetTables();
        }

        @Override
        public IColumn[] propagateColumns(IDataTransform transform, IColumn[] aColumns, ITable tbl) {
            return transform.updateMappedColumnsToTargetTable(aColumns, tbl);
        }
    }

    private class PropagateColumnsToEndConfiguration
    extends AbstractColumnsPropagationConfiguration {
        private PropagateColumnsToEndConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getConsumerTransforms();
        }

        @Override
        public ITable[] getNextTables(IDataTransform transform) {
            return transform.getTargetTables();
        }

        @Override
        public IColumn[] propagateColumns(IDataTransform transform, IColumn[] aColumns, ITable tbl) {
            return transform.propagateColumnsToTargetTable(aColumns, tbl);
        }
    }

    private class UpdateColumnsToBeginningConfiguration
    extends AbstractColumnsPropagationConfiguration {
        private UpdateColumnsToBeginningConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getProducerTransforms();
        }

        @Override
        public ITable[] getNextTables(IDataTransform transform) {
            return transform.getSourceTables();
        }

        @Override
        public IColumn[] propagateColumns(IDataTransform transform, IColumn[] aColumns, ITable tbl) {
            return transform.updateMappedColumnsToSourceTable(tbl, aColumns);
        }
    }

    private class PropagateColumnsToBeginningConfiguration
    extends AbstractColumnsPropagationConfiguration {
        private PropagateColumnsToBeginningConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getProducerTransforms();
        }

        @Override
        public ITable[] getNextTables(IDataTransform transform) {
            return transform.getSourceTables();
        }

        @Override
        public IColumn[] propagateColumns(IDataTransform transform, IColumn[] aColumns, ITable tbl) {
            return transform.propagateColumnsToSourceTable(tbl, aColumns);
        }
    }

    private abstract class AbstractColumnsPropagationConfiguration
    implements ColumnsPropagationConfiguration {
        private List m_lVisited = new ArrayList();

        @Override
        public void addToVisitedList(IMappingsContainer container) {
            this.m_lVisited.add(container);
        }

        @Override
        public boolean isInVisitedList(IMappingsContainer container) {
            return this.m_lVisited.contains(container);
        }
    }

    private static interface ColumnsPropagationConfiguration {
        public IDataTransform[] getNextTransforms(ITable var1);

        public ITable[] getNextTables(IDataTransform var1);

        public IColumn[] propagateColumns(IDataTransform var1, IColumn[] var2, ITable var3);

        public void addToVisitedList(IMappingsContainer var1);

        public boolean isInVisitedList(IMappingsContainer var1);
    }

    private class PropagateFromEndConfiguration
    extends AbstractPropagationConfiguration {
        private PropagateFromEndConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getConsumerTransforms();
        }

        @Override
        public void propagateColumns(IDataTransform transform, ITable tbl, int eNonWorkTableHandling) {
            ITable[] aTargetTables = transform.getTargetTables();
            BaseDesignTimeModel.this.propagateImpl(aTargetTables, this, 1);
            transform.propagateColumnsToSourceTables(new ITable[]{tbl}, aTargetTables, eNonWorkTableHandling);
        }
    }

    private class PropagateToEndConfiguration
    extends AbstractPropagationConfiguration {
        private PropagateToEndConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getConsumerTransforms();
        }

        @Override
        public void propagateColumns(IDataTransform transform, ITable tbl, int eNonWorkTableHandling) {
            ITable[] aTargetTables = transform.getTargetTables();
            transform.propagateColumnsToTargetTables(new ITable[]{tbl}, aTargetTables, eNonWorkTableHandling);
            BaseDesignTimeModel.this.propagateImpl(aTargetTables, this, 1);
        }
    }

    private class PropagateFromBeginningConfiguration
    extends AbstractPropagationConfiguration {
        private PropagateFromBeginningConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getProducerTransforms();
        }

        @Override
        public void propagateColumns(IDataTransform transform, ITable tbl, int eNonWorkTableHandling) {
            ITable[] aSourceTables = transform.getSourceTables();
            BaseDesignTimeModel.this.propagateImpl(aSourceTables, this, 1);
            transform.propagateColumnsToTargetTables(aSourceTables, new ITable[]{tbl}, eNonWorkTableHandling);
        }
    }

    private class PropagateToBeginningConfiguration
    extends AbstractPropagationConfiguration {
        private PropagateToBeginningConfiguration() {
        }

        @Override
        public IDataTransform[] getNextTransforms(ITable tbl) {
            return tbl.getProducerTransforms();
        }

        @Override
        public void propagateColumns(IDataTransform transform, ITable tbl, int eNonWorkTableHandling) {
            ITable[] aSourceTables = transform.getSourceTables();
            transform.propagateColumnsToSourceTables(aSourceTables, new ITable[]{tbl}, eNonWorkTableHandling);
            BaseDesignTimeModel.this.propagateImpl(aSourceTables, this, 1);
        }
    }

    private abstract class AbstractPropagationConfiguration
    implements PropagationConfiguration {
        private List m_lVisited = new ArrayList();

        @Override
        public void addToVisitedList(ContainerTablePair pair) {
            this.m_lVisited.add(pair);
        }

        @Override
        public void addToVisitedList(List lPairs) {
            this.m_lVisited.addAll(lPairs);
        }

        @Override
        public List getVisitedList() {
            return this.m_lVisited;
        }

        @Override
        public boolean isInVisitedList(ContainerTablePair pair) {
            return this.m_lVisited.contains(pair);
        }

        public boolean isInVisitedList(IMappingsContainer container) {
            return this.m_lVisited.contains(container);
        }
    }

    private static interface PropagationConfiguration {
        public IDataTransform[] getNextTransforms(ITable var1);

        public void propagateColumns(IDataTransform var1, ITable var2, int var3);

        public void addToVisitedList(ContainerTablePair var1);

        public void addToVisitedList(List var1);

        public List getVisitedList();

        public boolean isInVisitedList(ContainerTablePair var1);
    }

    private static class ContainerTablePair {
        private IMappingsContainer m_container;
        private ITable m_table;

        public ContainerTablePair(IMappingsContainer container, ITable table) {
            this.m_container = container;
            this.m_table = table;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ContainerTablePair)) {
                return false;
            }
            ContainerTablePair other = (ContainerTablePair)object;
            if (this.m_container != other.m_container) {
                return false;
            }
            return this.m_table == null || other.m_table == null || this.m_table == other.m_table;
        }

        public int hashcode() {
            return super.hashCode();
        }
    }
}

