/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.AbstractConditionActionSetContainer;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPrePostCodeContainer
extends AbstractConditionActionSetContainer
implements IPrePostCode {
    private IUserWrittenCodeContainer m_codePreProcess;
    private IUserWrittenCodeContainer m_codePostProcess;
    private boolean m_bPreProcessEnabled = true;
    private boolean m_bPostProcessEnabled = true;

    public AbstractPrePostCodeContainer(String sID, IModel model) {
        super(sID, model);
        this.m_codePreProcess = model.getObjectFactory().createUserWrittenHelper(this);
        this.m_codePreProcess.setContainerOMRType("Transformation");
        this.m_codePreProcess.setContainerRole("PreProcess");
        this.m_codePreProcess.setName("PreProcess");
        this.m_codePreProcess.setActiveFlagLocation(1);
        this.m_codePreProcess.setActiveEventName("IPrePostCode:UsePreProcessCodeChanged");
        this.m_codePreProcess.setCodeChangeEventName("IPrePostCode:PreProcessCodeChanged");
        this.m_codePostProcess = model.getObjectFactory().createUserWrittenHelper(this);
        this.m_codePostProcess.setContainerOMRType("Transformation");
        this.m_codePostProcess.setContainerRole("PostProcess");
        this.m_codePostProcess.setName("PostProcess");
        this.m_codePostProcess.setActiveFlagLocation(1);
        this.m_codePostProcess.setActiveEventName("IPrePostCode:UsePostProcessCodeChanged");
        this.m_codePostProcess.setCodeChangeEventName("IPrePostCode:PostProcessCodeChanged");
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("TransformationSources");
        lAssociations.add("TransformationTargets");
        map.put(this.getOMRType(), lAssociations);
        this.m_codePreProcess.getOMRLoadTemplateMap(map);
        this.m_codePostProcess.getOMRLoadTemplateMap(map);
        return map;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_codePreProcess != null && this.m_codePreProcess.isChanged() || this.m_codePostProcess != null && this.m_codePostProcess.isChanged();
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        if (this.isUsingPreProcessCode() && this.getPreProcessCode() != null && !this.getPreProcessCode().isComplete()) {
            return false;
        }
        return !this.isUsingPostProcessCode() || this.getPostProcessCode() == null || this.getPostProcessCode().isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.isUsingPreProcessCode() && this.getPreProcessCode() != null) {
            lReasons.addAll(this.getPreProcessCode().getReasonsIncomplete());
        }
        if (this.isUsingPostProcessCode() && this.getPostProcessCode() != null) {
            lReasons.addAll(this.getPostProcessCode().getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public void setUsePreProcessCode(boolean bUsePreProcessCode) {
        if (this.m_codePreProcess.isActive() == bUsePreProcessCode) {
            return;
        }
        this.m_codePreProcess.setIsActive(bUsePreProcessCode);
    }

    @Override
    public boolean isUsingPreProcessCode() {
        return this.m_codePreProcess.isActive();
    }

    @Override
    public boolean isPreProcessEnabled() {
        return this.m_bPreProcessEnabled;
    }

    public void setPreProcessEnabled(boolean bEnabled) {
        if (this.m_bPreProcessEnabled == bEnabled) {
            return;
        }
        this.m_bPreProcessEnabled = bEnabled;
        this.fireModelChangedEvent("IPrePostCode:PreProcessEnabledChanged", new Boolean(this.m_bPreProcessEnabled));
    }

    @Override
    public boolean isPostProcessEnabled() {
        return this.m_bPostProcessEnabled;
    }

    public void setPostProcessEnabled(boolean bEnabled) {
        if (this.m_bPostProcessEnabled == bEnabled) {
            return;
        }
        this.m_bPostProcessEnabled = bEnabled;
        this.fireModelChangedEvent("IPrePostCode:PostProcessEnabledChanged", new Boolean(this.m_bPostProcessEnabled));
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_codePostProcess.updateIds(mapIDs);
        this.m_codePreProcess.updateIds(mapIDs);
    }

    @Override
    public void setPreProcessCode(ICodeSource code) {
        this.m_codePreProcess.setUserWrittenSourceCode(code);
    }

    @Override
    public IUserWrittenCodeContainer getPreProcessCode() {
        return this.m_codePreProcess;
    }

    @Override
    public void setUsePostProcessCode(boolean bUsePostProcessCode) {
        if (this.m_codePostProcess.isActive() == bUsePostProcessCode) {
            return;
        }
        this.m_codePostProcess.setIsActive(bUsePostProcessCode);
    }

    @Override
    public boolean isUsingPostProcessCode() {
        return this.m_codePostProcess.isActive();
    }

    @Override
    public void setPostProcessCode(ICodeSource code) {
        this.m_codePostProcess.setUserWrittenSourceCode(code);
    }

    @Override
    public IUserWrittenCodeContainer getPostProcessCode() {
        return this.m_codePostProcess;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.m_codePreProcess.deleteFromOMR(omr);
        this.m_codePostProcess.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Transformation postHolder;
        super.loadFromOMR(omr);
        AbstractTransformation mdObject = (AbstractTransformation)omr.acquireOMRObject(this);
        Transformation preHolder = this.findPreCodeContainer(mdObject);
        if (preHolder != null) {
            this.m_codePreProcess.setContainer((AbstractTransformation)preHolder);
            this.m_codePreProcess.loadFromOMR(omr);
        }
        if ((postHolder = this.findPostCodeContainer(mdObject)) != null) {
            this.m_codePostProcess.setContainer((AbstractTransformation)postHolder);
            this.m_codePostProcess.loadFromOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        AbstractTransformation mdObject = (AbstractTransformation)omr.acquireOMRObject(this);
        IUserWrittenCodeContainer preCode = this.getPreProcessCode();
        preCode.saveToOMR(omr);
        Transformation preHolder = (Transformation)this.m_codePreProcess.getOMRContainer(omr);
        if (preHolder != null) {
            mdObject.getTransformationSources(false).add((Object)preHolder);
        }
        IUserWrittenCodeContainer postCode = this.getPostProcessCode();
        postCode.saveToOMR(omr);
        Transformation postHolder = (Transformation)this.m_codePostProcess.getOMRContainer(omr);
        if (postHolder != null) {
            mdObject.getTransformationTargets(false).add((Object)postHolder);
        }
        this.setChanged(false);
    }

    private Transformation findPreCodeContainer(AbstractTransformation mdObject) throws RemoteException, MdException {
        Transformation trans = null;
        AssociationList sources = mdObject.getTransformationSources();
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Root target = (Root)sources.get(i);
            if (!(target instanceof Transformation) || !((Transformation)target).getTransformRole().equals("PreProcess")) continue;
            return (Transformation)target;
        }
        return trans;
    }

    private Transformation findPostCodeContainer(AbstractTransformation mdObject) throws RemoteException, MdException {
        Transformation trans = null;
        AssociationList targets = mdObject.getTransformationTargets();
        int size = targets.size();
        for (int i = 0; i < size; ++i) {
            Root target = (Root)targets.get(i);
            if (!(target instanceof Transformation) || !((Transformation)target).getTransformRole().equals("PostProcess")) continue;
            return (Transformation)target;
        }
        return trans;
    }
}

