/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMultiplePortTransformModel;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformOptionModel;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.ITransformTemplate;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformTemplate;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.xml.sax.SAXException;

public abstract class AbstractMultiplePortTransformModel
extends AbstractDataTransform
implements IMultiplePortTransformModel {
    private ITransformTemplate m_template;
    private boolean m_bUpdateTableMetadata;
    protected boolean m_bStatsTableExists;

    public AbstractMultiplePortTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        super.addDefaultSettings();
        this.addDefaultTemplate();
    }

    protected void addDefaultTemplate() throws MdException, RemoteException {
        this.setTemplate(this.createDefaultTemplate());
    }

    @Override
    public List<ITransformPort<? extends IDataObject>> getTargetPortsMissingObjects() {
        ArrayList<ITransformPort<? extends IDataObject>> lst = new ArrayList<ITransformPort<? extends IDataObject>>();
        for (ITransformPort<? extends IDataObject> d : this.getTargetPorts()) {
            if (d.getObject() != null) continue;
            lst.add(d);
        }
        return lst;
    }

    @Override
    public List<ITransformPort<? extends IDataObject>> getSourcePortsMissingObjects() {
        ArrayList<ITransformPort<? extends IDataObject>> lst = new ArrayList<ITransformPort<? extends IDataObject>>();
        for (ITransformPort<? extends IDataObject> d : this.getSourcePorts()) {
            if (d.getObject() != null) continue;
            lst.add(d);
        }
        return lst;
    }

    protected ITransformTemplate createDefaultTemplate() {
        ITransformTemplate template = this.createTemplate(this.createIDForNewObject(), this.getModel());
        template.setPortFactory(this);
        return template;
    }

    public ITransformPort<? extends IDataObject> createNewPort(IModel model, String containerId, String partnerName) {
        return this.createPort(model, this.createIDForNewObject(), partnerName);
    }

    public ITransformPort<? extends IDataObject> createPort(IModel model, String id, String partnerName) {
        BaseTransformPort port = new BaseTransformPort(id, this.getModel());
        port.setPartnerName(partnerName);
        return port;
    }

    @Override
    public void setPortObjectTypes(ITransformPort<?> port) {
        port.setObjectTypes(new String[]{"PhysicalTable", "WorkTable"});
    }

    @Override
    public void setPortObjectName(ITransformPort<?> port) {
        port.setObjectName(RB.getStringResource("AbstractMultiplePortTransformModel.Table.txt"));
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            template.deleteFromOMR(omr);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            template.dispose();
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("TransformationStep");
        if (lAssociations == null) {
            System.err.println("No entry in load map for TransformationStep");
        }
        lAssociations.add("UsingPrototype");
        lAssociations = new ArrayList<String>();
        lAssociations.add("PrototypeProperties");
        map.put("Prototype", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("UsingPrototype");
        map.put("AssociationProperty", lAssociations);
        return map;
    }

    @Override
    public void delete() {
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            template.delete();
        }
        super.delete();
    }

    @Override
    public void notify(NotifyEvent ev) {
        String type;
        Object source = ev.getSource();
        ModelEvent modelEvent = ev.getModelEvent();
        if (source == this.getTemplate() && modelEvent != null) {
            ITransformPort port;
            ITransformTemplate template = (ITransformTemplate)source;
            String type2 = modelEvent.getType();
            if ("ITransformTemplate:SourcePortRemoved".equals(type2)) {
                IDataObject table;
                ITransformPort port2 = (ITransformPort)modelEvent.getData();
                if (port2 != null && (table = (IDataObject)port2.getObject()) != null) {
                    this.removeDataSource(port2, table);
                }
                this.fireModelChangedEvent("DataTransform.InputRemoved", port2, modelEvent.getAdditionalData());
            } else if ("ITransformTemplate:SourcePortAdded".equals(type2)) {
                ITransformPort port3 = (ITransformPort)modelEvent.getData();
                if (port3 != null) {
                    this.fireModelChangedEvent("DataTransform.InputAdded", port3, modelEvent.getAdditionalData());
                    IDataObject table = (IDataObject)port3.getObject();
                    if (table != null) {
                        this.addSourceTable(template.getPortIndex(port3), table);
                    }
                }
            } else if ("ITransformTemplate:TargetPortRemoved".equals(type2)) {
                IDataObject obj;
                ITransformPort port4 = (ITransformPort)modelEvent.getData();
                if (port4 != null && (obj = (IDataObject)port4.getObject()) != null) {
                    this.removeDataTarget(port4, obj);
                }
                this.fireModelChangedEvent("DataTransform.OutputRemoved", port4, modelEvent.getAdditionalData());
            } else if ("ITransformTemplate:TargetPortAdded".equals(type2) && (port = (ITransformPort)modelEvent.getData()) != null) {
                this.fireModelChangedEvent("DataTransform.OutputAdded", port, modelEvent.getAdditionalData());
                IDataObject table = (IDataObject)port.getObject();
                if (table != null) {
                    this.addTargetTable(template.getPortIndex(port), table);
                }
            }
        } else if (source instanceof ITransformPort && modelEvent != null && "ITransformPort:TableChanged".equals(type = modelEvent.getType())) {
            ITransformPort port = (ITransformPort)source;
            IDataObject table = (IDataObject)modelEvent.getAdditionalData();
            int portIndex = this.m_template.getPortIndex(port);
            if (port.isInputTemplate()) {
                if (port.getObject() != null) {
                    this.addSourceTable(portIndex, (IDataObject)port.getObject());
                } else {
                    this.removeSourceTable(port, table);
                }
            } else if (port.getObject() != null) {
                this.addTargetTable(portIndex, (IDataObject)port.getObject());
            } else {
                this.removeTargetTable(port, table);
            }
        }
        super.notify(ev);
    }

    @Override
    public List<ITransformPort<? extends IDataObject>> getSourcePorts() {
        ArrayList<ITransformPort<? extends IDataObject>> lst = new ArrayList<ITransformPort<? extends IDataObject>>();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            for (ITransformPort<?> port : template.getSourcePorts()) {
                lst.add(port);
            }
        }
        return lst;
    }

    @Override
    public List<ITransformPort<? extends IDataObject>> getTargetPorts() {
        ArrayList<ITransformPort<? extends IDataObject>> lst = new ArrayList<ITransformPort<? extends IDataObject>>();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            for (ITransformPort<?> port : template.getTargetPorts()) {
                lst.add(port);
            }
        }
        return lst;
    }

    @Override
    public ITransformPort<? extends IDataObject> findPortByName(String name, List<ITransformPort<? extends IDataObject>> lst) {
        for (ITransformPort<? extends IDataObject> port : lst) {
            if (!ObjectComparator.isEqual(port.getName(), name)) continue;
            return port;
        }
        return null;
    }

    @Override
    public ITransformPort<? extends IDataObject> findPortByPartnerName(String name, List<ITransformPort<? extends IDataObject>> lst) {
        for (ITransformPort<? extends IDataObject> port : lst) {
            if (!ObjectComparator.isEqual(port.getPartnerName(), name)) continue;
            return port;
        }
        return null;
    }

    @Override
    public ITransformPort<?>[] getSourcePortsWithObject(IDataObject obj) {
        ArrayList lst = new ArrayList();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            for (ITransformPort<?> port : template.getSourcePorts()) {
                if (port.getObject() != obj) continue;
                lst.add(port);
            }
        }
        return lst.toArray(new ITransformPort[lst.size()]);
    }

    @Override
    public int[] getSourcePortIndexWithObject(IDataObject obj) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            List<ITransformPort<? extends IDataObject>> ports = this.getSourcePorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (ports.get(i).getObject() != obj) continue;
                lst.add(i);
            }
        }
        return ArrayUtils.toPrimitive((Integer[])lst.toArray(new Integer[lst.size()]));
    }

    @Override
    public ITransformPort<?> getTargetPortWithObject(IDataObject obj) {
        ITransformPort<?>[] lst = this.getTargetPortsWithObject(obj);
        return lst.length == 0 ? null : lst[0];
    }

    @Override
    public ITransformPort<?>[] getTargetPortsWithObject(IDataObject obj) {
        ArrayList lst = new ArrayList();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            for (ITransformPort<?> port : template.getTargetPorts()) {
                if (port.getObject() != obj) continue;
                lst.add(port);
            }
        }
        return lst.toArray(new ITransformPort[lst.size()]);
    }

    @Override
    public int[] getTargetPortIndexWithObject(IDataObject obj) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            List<ITransformPort<? extends IDataObject>> ports = this.getTargetPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (ports.get(i).getObject() != obj) continue;
                lst.add(i);
            }
        }
        return ArrayUtils.toPrimitive((Integer[])lst.toArray(new Integer[lst.size()]));
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ArrayList<ITransformTableOptions> opts = new ArrayList<ITransformTableOptions>();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            for (ITransformPort<?> port : template.getPorts()) {
                if (port.getTransformTableOption() == null) continue;
                opts.add(port.getTransformTableOption());
            }
        }
        return opts.toArray(new ITransformTableOptions[opts.size()]);
    }

    private boolean hasUpdateMetadataAndNewTable() {
        if (!this.isUpdateTableMetadata()) {
            return false;
        }
        List<IDataObject> targetTables = this.getDataTargetList();
        for (int iTarget = 0; iTarget < targetTables.size(); ++iTarget) {
            ITable table;
            IDataObject target = targetTables.get(iTarget);
            if (!(target instanceof ITable) || !(table = (ITable)target).isNew()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        return this.hasUpdateMetadataAndNewTable();
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        if (this.hasUpdateMetadataAndNewTable()) {
            warnings.add(RB.getStringResource("AbstractMultiplePortTransformModel.UpdateMetadataNewTablesWarning.txt"));
        }
        return warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkTable addNewWorkTable() {
        if (this.isAddWorkTableAvailable()) {
            this.startCompoundUndoable();
            try {
                ITransformPort<?> port = this.getTemplate().getNextAvailablePort(false);
                if (port == null && this.isAddOutputAvailable()) {
                    this.addOutput();
                    port = this.getTemplate().getNextAvailablePort(false);
                }
                if (port != null) {
                    IWorkTable table = this.getObjectFactory().createNewWorkTable(this.getID());
                    table.setName(this.getName() + port.getName());
                    this.addDataTarget(port, (IDataObject)table);
                    IWorkTable iWorkTable = table;
                    return iWorkTable;
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
        return null;
    }

    public IPhysicalTable getSourceTable() {
        IPhysicalTable[] sources = this.getSourceTables();
        return sources.length > 0 ? sources[0] : null;
    }

    public IPhysicalTable[] getSourceTables() {
        ArrayList<IPhysicalTable> tables = new ArrayList<IPhysicalTable>();
        for (IDataObject dobject : this.getDataSourceList()) {
            if (!(dobject instanceof IPhysicalTable)) continue;
            tables.add((IPhysicalTable)dobject);
        }
        return tables.toArray(new IPhysicalTable[tables.size()]);
    }

    @Override
    public IDataObject[] getDataSources() {
        List<IDataObject> tables = this.getDataSourceList();
        return tables.toArray(new IDataObject[tables.size()]);
    }

    @Override
    public List<IDataObject> getDataSourceList() {
        ArrayList<IDataObject> tables = new ArrayList<IDataObject>();
        for (ITransformPort<? extends IDataObject> sourcePort : this.getSourcePorts()) {
            IDataObject table = sourcePort.getObject();
            if (table == null || tables.contains(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public List<IDataObject> getDataTargetList() {
        ArrayList<IDataObject> tables = new ArrayList<IDataObject>();
        for (ITransformPort<? extends IDataObject> targetPort : this.getTargetPorts()) {
            IDataObject table = targetPort.getObject();
            if (table == null || tables.contains(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public int getDataSourcesCount() {
        int cnt = 0;
        for (ITransformPort<? extends IDataObject> port : this.getSourcePorts()) {
            if (port.getObject() == null) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public IDataObject[] getDataTargets() {
        List<IDataObject> tables = this.getDataTargetList();
        return tables.toArray(new IDataObject[tables.size()]);
    }

    public IPhysicalTable getTargetTable() {
        IPhysicalTable[] targets = this.getTargetTables();
        return targets.length > 0 ? targets[0] : null;
    }

    public IPhysicalTable[] getTargetTables() {
        IDataObject[] targets = this.getDataTargets();
        ArrayList<IPhysicalTable> tables = new ArrayList<IPhysicalTable>();
        for (IDataObject dobject : targets) {
            if (!(dobject instanceof IPhysicalTable)) continue;
            tables.add((IPhysicalTable)dobject);
        }
        return tables.toArray(new IPhysicalTable[tables.size()]);
    }

    @Override
    public int getDataTargetsCount() {
        int cnt = 0;
        for (ITransformPort<? extends IDataObject> port : this.getTargetPorts()) {
            if (port.getObject() == null) continue;
            ++cnt;
        }
        return cnt;
    }

    public void setStatsTableExists(boolean b) {
        this.m_bStatsTableExists = b;
    }

    public boolean getStatsTableExists() {
        return this.m_bStatsTableExists;
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
    }

    @Override
    public void addDataSource(ITransformPort port, IDataObject source) {
        this.startCompoundUndoable();
        try {
            if (port != null && port.getObject() != source) {
                port.setObject(source);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void addSourceTable(int portIndex, IDataObject table) {
        if (!table.containsInConsumerTransforms(this)) {
            table.addConsumerTransform(this);
            table.addNotifyListener(this);
        }
        this.fireModelChangedEvent("DataTransform.DataSourceAdded", table, new Integer(portIndex + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            for (ITransformPort<? extends IDataObject> port : this.getSourcePorts()) {
                if (port.getObject() != source) continue;
                this.removeDataSource(port, source);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeDataSource(ITransformPort<? extends IDataObject> port, IDataObject source) {
        this.startCompoundUndoable();
        try {
            if (port.getObject() == source) {
                port.setObject(null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void removeSourceTable(ITransformPort<? extends IDataObject> port, IDataObject table) {
        if (table.containsInConsumerTransforms(this) && this.getSourcePortsWithObject(table).length == 0) {
            table.removeConsumerTransform(this);
            table.removeNotifyListener(this);
            if (!port.isInUndoOrRedo() && table instanceof IPhysicalTable) {
                this.removeSourceTableFromMappings((IPhysicalTable)table);
            }
        }
        this.fireModelChangedEvent("DataTransform.DataSourceRemoved", table, new Integer(this.m_template.getPortIndex(port) + 1));
    }

    private boolean canAutoMapAndPropagate(ITable tblTarget) {
        for (ITransformPort<?> port : this.getTargetPortsWithObject(tblTarget)) {
            if (port.canPropagateColumns()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IColumn[] propagateColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, List lExcludedColumns, boolean bForward) {
        if (!this.canAutoMapAndPropagate(tblTarget)) {
            return new IColumn[0];
        }
        return super.propagateColumnsImpl(aSourceColumns, tblTarget, lExcludedColumns, bForward);
    }

    @Override
    public boolean containsInDataSources(IDataObject source) {
        return this.getDataSourceList().contains(source);
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.getDataTargetList().contains(target);
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
    }

    @Override
    public void addDataTarget(ITransformPort port, IDataObject target) {
        this.startCompoundUndoable();
        try {
            if (port != null && port.getObject() != target) {
                port.setObject(target);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void addTargetTable(int portIndex, IDataObject table) {
        if (table instanceof IWorkTable) {
            this.removeFromDeletedObjects(table);
            this.updateTargetLibrary((IWorkTable)table);
        }
        if (!table.containsInProducerTransforms(this)) {
            table.addProducerTransform(this);
            table.addNotifyListener(this);
        }
        this.fireModelChangedEvent("DataTransform.DataTargetAdded", table, new Integer(portIndex + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        try {
            for (ITransformPort<? extends IDataObject> port : this.getTargetPorts()) {
                if (port.getObject() != target) continue;
                this.removeDataTarget(port, target);
                if (!target.getName().toString().equalsIgnoreCase("EDM Stats")) continue;
                this.setStatsTableExists(false);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(ITransformPort<? extends IDataObject> port, IDataObject target) {
        this.startCompoundUndoable();
        try {
            if (port.getObject() == target) {
                if (target instanceof IWorkTable) {
                    IDataTransform[] consumers = target.getConsumerTransforms();
                    for (int i = 0; i < consumers.length; ++i) {
                        consumers[i].removeDataSource(target);
                    }
                }
                port.setObject(null);
                if (target.getName().toString().equalsIgnoreCase("EDM Stats")) {
                    this.setStatsTableExists(false);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void removeTargetTable(ITransformPort<? extends IDataObject> port, IDataObject table) {
        if (table.containsInProducerTransforms(this) && this.getTargetPortsWithObject(table).length == 0) {
            table.removeProducerTransform(this);
            table.removeNotifyListener(this);
            if (!port.isInUndoOrRedo() && table instanceof IPhysicalTable) {
                this.removeTargetTableFromMappings((IPhysicalTable)table);
            }
            if (table.getName().toString().equalsIgnoreCase("EDM Stats")) {
                this.setStatsTableExists(false);
            }
        }
        if (table instanceof IWorkTable) {
            this.addToDeletedObjects(table);
        }
        this.fireModelChangedEvent("DataTransform.DataTargetRemoved", table, new Integer(this.m_template.getPortIndex(port) + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            this.replaceSourceMappings(oldTable, newTable, columnsMap);
            this.replaceSourceTableOptions(oldTable, newTable, columnsMap);
            ITransformTemplate template = this.getTemplate();
            if (template != null) {
                for (int i = 0; i < portIndexes.length; ++i) {
                    ITransformPort<? extends IDataObject> port = this.getSourcePorts().get(portIndexes[i] - 1);
                    this.removeDataSource(port, oldTable);
                    this.addDataSource(port, (IDataObject)newTable);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            this.replaceTargetMappings(oldTable, newTable, columnsMap);
            this.replaceTargetTableOptions(oldTable, newTable, columnsMap);
            ITransformTemplate template = this.getTemplate();
            if (template != null) {
                for (int i = 0; i < portIndexes.length; ++i) {
                    ITransformPort<? extends IDataObject> port = this.getTargetPorts().get(portIndexes[i] - 1);
                    this.removeDataTarget(port, oldTable);
                    this.addDataTarget(port, (IDataObject)newTable);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isUpdateTableMetadata() {
        return this.m_bUpdateTableMetadata;
    }

    @Override
    public void setUpdateTableMetadata(boolean doUpdate) {
        if (doUpdate == this.m_bUpdateTableMetadata) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUpdateTableMetadataUndoable(this.m_bUpdateTableMetadata, doUpdate));
        }
        this.m_bUpdateTableMetadata = doUpdate;
        this.fireModelChangedEvent("AbstractMultiplePortTransformModel:UpdateTableChanged", this.m_bUpdateTableMetadata);
    }

    protected void preSetTemplate(ITransformTemplate oldTemplate, ITransformTemplate newTemplate) {
        if (oldTemplate != null) {
            int i;
            for (i = 0; i < oldTemplate.getSourcePortCount(); ++i) {
                this.fireModelChangedEvent("DataTransform.InputRemoved", oldTemplate.getSourcePorts().get(i), new Integer(i));
            }
            for (i = 0; i < oldTemplate.getTargetPortCount(); ++i) {
                this.fireModelChangedEvent("DataTransform.OutputRemoved", oldTemplate.getTargetPorts().get(i), new Integer(i));
            }
            oldTemplate.removeNotifyListener(this);
            oldTemplate.setPortFactory(null);
            this.addToDeletedObjects(oldTemplate);
        }
    }

    protected void postSetTemplate(ITransformTemplate oldTemplate, ITransformTemplate newTemplate) {
        if (newTemplate != null) {
            ITransformPort<?> port;
            int i;
            this.removeFromDeletedObjects(newTemplate);
            for (i = 0; i < newTemplate.getSourcePortCount(); ++i) {
                port = newTemplate.getSourcePorts().get(i);
                this.fireModelChangedEvent("DataTransform.InputAdded", port, new Integer(i));
                if (port.getObject() == null) continue;
                this.addSourceTable(i, (IDataObject)port.getObject());
            }
            for (i = 0; i < newTemplate.getTargetPortCount(); ++i) {
                port = newTemplate.getTargetPorts().get(i);
                this.fireModelChangedEvent("DataTransform.OutputAdded", port, new Integer(i));
                if (port.getObject() == null) continue;
                this.addTargetTable(i, (IDataObject)port.getObject());
            }
            newTemplate.addNotifyListener(this);
            newTemplate.setPortFactory(this);
        }
    }

    protected boolean canSetTemplate(ITransformTemplate newTemplate) {
        return this.m_template != newTemplate;
    }

    protected abstract void templateChangedRequested(ITransformTemplate var1);

    @Override
    public void setTemplate(ITransformTemplate template) {
        this.templateChangedRequested(template);
        if (!this.canSetTemplate(template)) {
            if (template != null) {
                this.addToDeletedObjects(template);
            }
            return;
        }
        ITransformTemplate old = this.m_template;
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTemplateUndoable(this.m_template, template));
            }
            this.preSetTemplate(old, template);
            this.m_template = template;
            this.postSetTemplate(old, template);
            this.fireModelChangedEvent("AbstractMultiplePortTransformModel:TemplateChanged", this.m_template);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public ITransformTemplate getTemplate() {
        return this.m_template;
    }

    protected int getMinimumDataSourceCount() {
        if (this.m_template != null) {
            return this.m_template.getSourceMinimum();
        }
        return 0;
    }

    public int getMaximumSourceTableCount() {
        return this.getMaximumDataSourceCount();
    }

    @Override
    protected int getMaximumDataSourceCount() {
        if (this.m_template != null) {
            return this.m_template.getSourceMaximum();
        }
        return 0;
    }

    protected int getMinimumDataTargetCount() {
        if (this.m_template != null) {
            return this.m_template.getTargetMinimum();
        }
        return 0;
    }

    public int getMaximumTargetTableCount() {
        return this.getMaximumDataTargetCount();
    }

    @Override
    protected int getMaximumDataTargetCount() {
        if (this.m_template != null) {
            return this.m_template.getTargetMaximum();
        }
        return 0;
    }

    @Override
    public boolean isAddInputAvailable() {
        ITransformTemplate template = this.getTemplate();
        return template != null ? template.canPortBeAdded(true) : false;
    }

    @Override
    public boolean isAddOutputAvailable() {
        ITransformTemplate template = this.getTemplate();
        return template != null ? template.canPortBeAdded(false) : false;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return this.getDataTargetsCount() < this.getMaximumDataTargetCount();
    }

    @Override
    public boolean isDeleteInputAvailable() {
        ITransformTemplate template = this.getTemplate();
        return template != null ? template.canPortBeRemoved(true) : false;
    }

    @Override
    public boolean isDeleteOutputAvailable() {
        ITransformTemplate template = this.getTemplate();
        return template != null ? template.canPortBeRemoved(false) : false;
    }

    @Override
    public final ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, isValidate);
        this.getCodeForTransform(codeSegment, isValidate);
        if (this.isUpdateTableMetadata()) {
            for (IPhysicalTable table : this.getTargetTables()) {
                codeSegment.addSourceCode(table.getUpdateTableMetadataCode()).addSourceCode("\n");
            }
        }
        return codeSegment;
    }

    protected abstract ICodeSegment getCodeForTransform(ICodeSegment var1, boolean var2) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException;

    @Override
    public void addInput() {
        if (!this.isAddInputAvailable()) {
            return;
        }
        this.startCompoundUndoable();
        try {
            ITransformPort<? extends IDataObject> port = this.createNewPort(this.getModel(), this.getID(), null);
            this.addPort(true, port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addOutput() {
        if (!this.isAddOutputAvailable()) {
            return;
        }
        this.startCompoundUndoable();
        try {
            ITransformPort<? extends IDataObject> port = this.createNewPort(this.getModel(), this.getID(), null);
            this.addPort(false, port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPort(boolean isInput, ITransformPort port) {
        if (port != null) {
            this.startCompoundUndoable();
            try {
                if (this.isUndoSupported()) {
                    AbstractUndoableEdit undo = null;
                    undo = isInput ? new AddInputPortUndoable(port) : new AddOutputPortUndoable(port);
                    this.undoableEditHappened(undo);
                }
                if (isInput) {
                    this.getTemplate().addSourcePort(port);
                } else {
                    this.getTemplate().addTargetPort(port);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePort(boolean isInput, ITransformPort port) {
        if (port != null) {
            this.startCompoundUndoable();
            try {
                if (this.isUndoSupported()) {
                    AbstractUndoableEdit undo = null;
                    undo = isInput ? new RemoveInputPortUndoable(port) : new RemoveOutputPortUndoable(port);
                    this.undoableEditHappened(undo);
                }
                if (isInput) {
                    this.getTemplate().removeSourcePort(port);
                } else {
                    this.getTemplate().removeTargetPort(port);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public void deleteInput() {
        if (!this.isDeleteInputAvailable()) {
            return;
        }
        ITransformPort<?> port = this.getTemplate().getPortToRemove(true);
        this.removePort(true, port);
    }

    @Override
    public void deleteOutput() {
        if (!this.isDeleteOutputAvailable()) {
            return;
        }
        ITransformPort<?> port = this.getTemplate().getPortToRemove(false);
        this.removePort(false, port);
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return this.getMinimumDataSourceCount() > 0;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return this.getMinimumDataTargetCount() > 0;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.getTemplate() == null || this.getTemplate().isComplete());
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            reasons.addAll(template.getReasonsIncomplete());
        }
        return reasons;
    }

    @Override
    public boolean isChanged() {
        ITransformTemplate template = this.getTemplate();
        return super.isChanged() || template != null && template.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.saveStringOptionToOMR(omr, "UpdateTargetMetadata", this.isUpdateTableMetadata() ? "YES" : "NO");
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            template.saveToOMR(omr);
            Root mdoTemplate = omr.acquireOMRObject(template);
            mdoStep.setUsingPrototype(mdoTemplate);
        }
        this.setChanged(false);
    }

    @Override
    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        return false;
    }

    @Override
    protected void loadDataSourcesTargetsFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        AssociationList lTransformations = mdoStep.getTransformations();
        if (!lTransformations.isEmpty()) {
            ClassifierMap mdoCM = (ClassifierMap)lTransformations.get(0);
            this.setClassifierMapId(mdoCM.getFQID());
            this.loadMappingsFromOMR(omr, mdoCM);
        }
    }

    protected ITransformTemplate createTemplate(String id, IModel model) {
        BaseTransformTemplate template = new BaseTransformTemplate(id, this.getModel());
        template.setPortFactory(this);
        return template;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        ITransformTemplate template = null;
        if (!mdoStep.getUsingPrototypes().isEmpty()) {
            Prototype prototype = (Prototype)mdoStep.getUsingPrototype();
            template = this.createTemplate(prototype.getFQID(), this.getModel());
            template.loadFromOMR(omr);
            this.setTemplate(template);
        }
        AssociationList lTransformations = mdoStep.getTransformations();
        IDataObject[] sources = null;
        IDataObject[] targets = null;
        if (!lTransformations.isEmpty()) {
            ClassifierMap mdoCM = (ClassifierMap)lTransformations.get(0);
            AssociationList cmSrc = mdoCM.getClassifierSources();
            sources = new IDataObject[cmSrc.size()];
            for (int i = 0; i < cmSrc.size(); ++i) {
                sources[i] = (IDataObject)omr.acquireObject((Root)cmSrc.get(i));
            }
            AssociationList cmTrg = mdoCM.getClassifierTargets();
            targets = new IDataObject[cmTrg.size()];
            for (int i = 0; i < cmTrg.size(); ++i) {
                targets[i] = (IDataObject)omr.acquireObject((Root)cmTrg.get(i));
            }
        }
        super.loadFromOMR(omr);
        boolean changed = false;
        if (template != null) {
            ITransformPort<? extends IDataObject> newport;
            int[] portNum;
            if (sources != null) {
                for (int i = 0; i < sources.length; ++i) {
                    portNum = template.findInSourcePorts(sources[i]);
                    if (portNum.length >= 0) continue;
                    ITransformPort<?> port = template.getNextAvailablePort(true);
                    if (port != null) {
                        port.setObject(sources[i]);
                    } else if (template.canPortBeAdded(true)) {
                        newport = this.createNewPort(this.getModel(), this.getID(), null);
                        this.addPort(true, newport);
                        newport.setObject(sources[i]);
                    }
                    changed = true;
                }
                template.setChanged(changed);
            }
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    portNum = template.findInTargetPorts((IObject)targets[i]);
                    if (portNum.length >= 0) continue;
                    ITransformPort<?> port = template.getNextAvailablePort(false);
                    if (port != null) {
                        port.setObject(targets[i]);
                    } else if (template.canPortBeAdded(false)) {
                        newport = this.createNewPort(this.getModel(), this.getID(), null);
                        this.addPort(false, newport);
                        newport.setObject(targets[i]);
                    }
                    changed = true;
                }
                template.setChanged(changed);
            }
        }
        this.setUpdateTableMetadata("YES".equals(this.loadStringOptionFromOMR(omr, "UpdateTargetMetadata", "NO")));
        this.setChanged(changed);
    }

    protected void savePortConnections(OMRAdapter omr) throws RemoteException, MdException {
        ITransformTemplate template = this.getTemplate();
        if (template != null) {
            template.saveToOMR(omr);
        }
    }

    @Override
    public IWorkTable[] getWorkTables() {
        ArrayList<IWorkTable> workTables = new ArrayList<IWorkTable>();
        for (ITransformPort<? extends IDataObject> port : this.getTargetPorts()) {
            if (!(port.getObject() instanceof IWorkTable)) continue;
            workTables.add((IWorkTable)port.getObject());
        }
        return workTables.toArray(new IWorkTable[workTables.size()]);
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new AbstractMultiplePortTransformOptionModel(this.getModel(), this);
    }

    private class SetTemplateUndoable
    extends AbstractUndoableEdit {
        private ITransformTemplate m_oldTemplate;
        private ITransformTemplate m_newTemplate;

        public SetTemplateUndoable(ITransformTemplate oldTemplate, ITransformTemplate newTemplate) {
            this.m_oldTemplate = oldTemplate;
            this.m_newTemplate = newTemplate;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractMultiplePortTransformModel.this.setTemplate(this.m_oldTemplate);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractMultiplePortTransformModel.this.setTemplate(this.m_newTemplate);
        }
    }

    private class SetUpdateTableMetadataUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUpdateTableMetadata;
        private boolean m_newUpdateTableMetadata;

        public SetUpdateTableMetadataUndoable(boolean oldUpdateTableMetadata, boolean newUpdateTableMetadata) {
            this.m_oldUpdateTableMetadata = oldUpdateTableMetadata;
            this.m_newUpdateTableMetadata = newUpdateTableMetadata;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractMultiplePortTransformModel.this.setUpdateTableMetadata(this.m_oldUpdateTableMetadata);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractMultiplePortTransformModel.this.setUpdateTableMetadata(this.m_newUpdateTableMetadata);
        }
    }

    private class AddOutputPortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<? extends IDataObject> m_port;

        public AddOutputPortUndoable(ITransformPort<? extends IDataObject> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractMultiplePortTransformModel.this.removePort(false, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractMultiplePortTransformModel.this.addPort(false, this.m_port);
        }
    }

    private class AddInputPortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<? extends IDataObject> m_port;

        public AddInputPortUndoable(ITransformPort<? extends IDataObject> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractMultiplePortTransformModel.this.removePort(true, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractMultiplePortTransformModel.this.addPort(true, this.m_port);
        }
    }

    private class RemoveOutputPortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<? extends IDataObject> m_port;

        public RemoveOutputPortUndoable(ITransformPort<? extends IDataObject> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractMultiplePortTransformModel.this.addPort(false, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractMultiplePortTransformModel.this.removePort(false, this.m_port);
        }
    }

    private class RemoveInputPortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<? extends IDataObject> m_port;

        public RemoveInputPortUndoable(ITransformPort<? extends IDataObject> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractMultiplePortTransformModel.this.addPort(true, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractMultiplePortTransformModel.this.removePort(true, this.m_port);
        }
    }
}

