/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.impl.BaseWorkTable;
import com.sas.etl.models.impl.AbstractPrimaryModelList;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractTransform;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.BaseTransformTableOptions;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DefaultMappingRules;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.FileReaderTransformModel;
import com.sas.etl.models.job.transforms.FileWriterTransformModel;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class AbstractDataTransform
extends AbstractTransform
implements IDataTransform {
    private static final String INCLUDED_IN_MAPPING = "IncludedInMapping";
    private static final String INCLUDED_IN_PROPAGATION = "IncludedInPropagation";
    private static final String COLUMNS_EXCLUDED_FROM_MAPPING_NAME = "ColumnsExcludedFromMapping";
    private static final String COLUMNS_EXCLUDED_FROM_PROPAGATION_NAME = "ColumnsExcludedFromPropagation";
    private static final String CONNECTED_SOURCES_NAME = "ConnectedSources";
    private List m_lDataSources;
    private List m_lDataTargets;
    private List m_lMappings;
    private List m_lColumnsExcludedFromMapping;
    private List m_lColumnsExcludedFromPropagation;
    private List m_lConnectedSources;
    private boolean m_bGenerateIndexesOnTables = true;
    private boolean m_bGenerateSYSLAST = true;
    private boolean m_bAppendForce = true;
    private boolean m_bColMacroVars = true;
    private boolean m_bFileMacroVars = true;
    private boolean m_bIncludedInPropagation = true;
    private boolean m_bIncludedInMapping = true;
    private boolean m_collectSourceTableRowCounts = true;
    private boolean m_collectTargetTableRowCounts = false;
    private String m_sClassifierMapID = this.createIDForNewObject();
    private String m_sGenerateFormatsInformats = "JOB";
    private String m_sUseConnectUsing = "JOB";
    private boolean m_bTargetDataAutomaticallyMoved = false;
    private int m_iDBMSType = 109;
    private String m_sDBMSTypeName = "SAS";
    private List m_lTableOptionModels;
    protected static final String BLANK = "";
    protected static final String DBI_DIRECT_EXEC = "DBIDIRECTEXEC";
    protected static final String NO_DBI_DIRECT_EXEC = "NODBIDIRECTEXEC";
    private static final String[] DBI_DIRECT_VALUES = new String[]{"", "DBIDIRECTEXEC", "NODBIDIRECTEXEC"};
    private String m_sDBIDirectExec;

    public AbstractDataTransform(String sID, IModel model) {
        super(sID, model);
        this.m_lDataSources = new DataSourcesList();
        this.m_lDataTargets = new DataTargetsList();
        this.m_lMappings = new ArrayList();
        this.m_lColumnsExcludedFromMapping = new ModelList(this, new String[]{"MappingsContainer:ColumnExcludedFromMapping", "MappingsContainer:ColumnIncludedInMapping"}, 0, IColumn.class);
        this.m_lColumnsExcludedFromPropagation = new ModelList(this, new String[]{"MappingsContainer:ColumnExcludedFromPropagation", "MappingsContainer:ColumnIncludedInPropagation"}, 0, IColumn.class);
        this.m_lConnectedSources = new ConnectedSourcesList();
        this.m_lTableOptionModels = new ArrayList();
        this.m_sDBIDirectExec = this.getDefaultDBIDirectExecValue();
    }

    protected int getMaximumDataSourceCount() {
        return 1;
    }

    @Override
    public boolean isDataTargetsAllowed() {
        return this.getMaximumDataTargetCount() > 0;
    }

    @Override
    public boolean isDataSourcesAllowed() {
        return this.getMaximumDataSourceCount() == 0;
    }

    protected int getMaximumDataTargetCount() {
        return 1;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new BaseDataTransformPromptModel(this.getModel(), this);
    }

    protected String getClassifierMapId() {
        return this.m_sClassifierMapID;
    }

    protected void setClassifierMapId(String sID) {
        this.m_sClassifierMapID = sID;
    }

    @Override
    public IPromptDefinitionValue[] getParameters(boolean includeSubComponents) {
        ITable[] targets;
        ITable[] sources;
        ArrayList<IPromptDefinitionValue> parameters = new ArrayList<IPromptDefinitionValue>();
        IPromptDefinitionValue[] prompts = super.getParameters();
        if (prompts != null) {
            parameters.addAll(Arrays.asList(prompts));
        }
        if ((sources = this.getSourceTables()) != null) {
            for (int i = 0; i < sources.length; ++i) {
                parameters.addAll(Arrays.asList(sources[i].getParameters()));
            }
        }
        if ((targets = this.getTargetTables()) != null) {
            for (int i = 0; i < targets.length; ++i) {
                parameters.addAll(Arrays.asList(targets[i].getParameters()));
            }
        }
        return parameters.toArray(new IPromptDefinitionValue[parameters.size()]);
    }

    protected String getDefaultDBIDirectExecValue() {
        return BLANK;
    }

    @Override
    public void setDBIDirectExec(String value) {
        if (!(BLANK.equals(value) || DBI_DIRECT_EXEC.equals(value) || NO_DBI_DIRECT_EXEC.equals(value))) {
            throw new IllegalArgumentException("value for dbidirectexec invalid");
        }
        if (value.equals(this.m_sDBIDirectExec)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDBIDirectExecUndoable(this.m_sDBIDirectExec, value));
        }
        this.m_sDBIDirectExec = value;
        this.fireModelChangedEvent("IDataTransform:DBIDirectExecChanged", value);
    }

    @Override
    public String getDBIDirectExecValue() {
        return this.m_sDBIDirectExec;
    }

    @Override
    public void setGenerateIndexesOnTargetTables(boolean genIndexes) {
        if (this.m_bGenerateIndexesOnTables == genIndexes) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGenerateIndexesOnTargetTables(this.m_bGenerateIndexesOnTables, genIndexes));
        }
        this.m_bGenerateIndexesOnTables = genIndexes;
        this.fireModelChangedEvent("DataTransform.GenerateIndexesOnTargetsChanged", null);
    }

    @Override
    public boolean isGenerateIndexesOnTargetTables() {
        return this.m_bGenerateIndexesOnTables;
    }

    @Override
    public void setSYSLASTVariableGenerationEnabled(boolean enabled) {
        if (enabled == this.m_bGenerateSYSLAST) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSYSLASTVariableGenerationEnabledUndoable(this.m_bGenerateSYSLAST, enabled));
        }
        this.m_bGenerateSYSLAST = enabled;
        this.fireModelChangedEvent("DataTransform::GenerateSYSLASTChanged", null);
    }

    @Override
    public boolean isSYSLASTVariableGenerationEnabled() {
        return this.m_bGenerateSYSLAST;
    }

    @Override
    public void setAppendForceEnabled(boolean enabled) {
        if (enabled == this.m_bAppendForce) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAppendForceEnabledUndoable(this.m_bAppendForce, enabled));
        }
        this.m_bAppendForce = enabled;
        this.fireModelChangedEvent("DataTransform::AppendForceChanged", null);
    }

    @Override
    public boolean isAppendForceEnabled() {
        return this.m_bAppendForce;
    }

    @Override
    public void setColMacroVarsEnabled(boolean enabled) {
        if (enabled == this.m_bColMacroVars) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetColMacroVarsEnabledUndoable(this.m_bColMacroVars, enabled));
        }
        this.m_bColMacroVars = enabled;
        this.fireModelChangedEvent("IDataTransform:ColMacroVarsChanged", null);
    }

    @Override
    public void setFileMacroVarsEnabled(boolean enabled) {
        if (enabled == this.m_bFileMacroVars) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFileMacroVarsEnabledUndoable(this.m_bFileMacroVars, enabled));
        }
        this.m_bFileMacroVars = enabled;
        this.fireModelChangedEvent("IDataTransform:FileMacroVarsChanged", null);
    }

    @Override
    public boolean isColMacroVarsEnabled() {
        return this.m_bColMacroVars;
    }

    @Override
    public boolean isFileMacroVarsEnabled() {
        return this.m_bFileMacroVars;
    }

    @Override
    public void setFormatInformatGeneration(String value) {
        if (value == this.m_sGenerateFormatsInformats) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFormatInformatGenerationUndoable(this.m_sGenerateFormatsInformats, value));
        }
        this.m_sGenerateFormatsInformats = value;
        this.fireModelChangedEvent("DataTransform::GenerateFORMATINFORMATChanged", null);
    }

    @Override
    public String getUseConnectUsing() {
        return this.m_sUseConnectUsing;
    }

    @Override
    public void setUseConnectUsing(String value) {
        if (value == this.m_sUseConnectUsing) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseConnectUsingUndoable(this.m_sUseConnectUsing, value));
        }
        this.m_sUseConnectUsing = value;
        this.fireModelChangedEvent("DataTransform::UseConnectUsingChanged", null);
    }

    public boolean isUseConnectUsingEnabled() {
        if (this.getUseConnectUsing().equalsIgnoreCase("JOB")) {
            return this.getJob().isConnectUsingEnabled();
        }
        return this.getUseConnectUsing().equalsIgnoreCase("YES");
    }

    @Override
    public String getFormatInformatGeneration() {
        return this.m_sGenerateFormatsInformats;
    }

    public boolean isFormatGenerationEnabled() {
        if (this.getFormatInformatGeneration().equalsIgnoreCase("JOB")) {
            return this.getJob().isFormatInformatGenerationEnabled();
        }
        return this.getFormatInformatGeneration().equalsIgnoreCase("YES");
    }

    @Override
    public void setIncludedInPropagation(boolean bIncluded) {
        if (this.m_bIncludedInPropagation == bIncluded) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludedInPropagationUndoable(this.m_bIncludedInPropagation, bIncluded));
        }
        this.m_bIncludedInPropagation = bIncluded;
        this.fireModelChangedEvent("MappingsContainer:IncludeInPropagationChanged", null);
    }

    @Override
    public boolean isIncludedInPropagation() {
        return this.m_bIncludedInPropagation;
    }

    @Override
    public void setIncludedInMapping(boolean bIncluded) {
        if (this.m_bIncludedInMapping == bIncluded) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludedInMappingUndoable(this.m_bIncludedInMapping, bIncluded));
        }
        this.m_bIncludedInMapping = bIncluded;
        this.fireModelChangedEvent("MappingsContainer:IncludeInMappingsChanged", null);
    }

    @Override
    public boolean isIncludedInMapping() {
        return this.m_bIncludedInMapping;
    }

    @Override
    public IDataObject[] getDataSources() {
        return this.m_lDataSources.toArray(new IDataObject[this.m_lDataSources.size()]);
    }

    @Override
    public List getDataSourceList() {
        return this.m_lDataSources;
    }

    @Override
    public boolean containsInDataSources(IDataObject source) {
        return this.m_lDataSources.contains(source);
    }

    @Override
    public int getDataSourcesCount() {
        return this.m_lDataSources.size();
    }

    @Override
    public void addDataSource(IDataObject source) {
        this.addDataSource(this.m_lDataSources.size(), source);
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
        if (this.m_lDataSources.size() >= this.getMaximumDataSourceCount()) {
            throw new UnsupportedOperationException("Maximum data source count will be exceeded (" + this.getMaximumDataSourceCount() + ")");
        }
        this.m_lDataSources.add(iSource, source);
    }

    protected void preAddDataSource(IDataObject source) {
    }

    protected void postAddDataSource(IDataObject source) {
        this.postAddTransformTableOption(source, true);
    }

    @Override
    public void removeDataSource(IDataObject source) {
        this.m_lDataSources.remove(source);
    }

    protected void preRemoveDataSource(IDataObject source) {
        if (source instanceof ITable) {
            this.removeSourceTableFromMappings((ITable)source);
            this.preRemoveTransformTableOptions(source, true);
        }
    }

    protected void postRemoveDataSource(IDataObject source) {
    }

    @Override
    public ITable[] getSourceTables() {
        ArrayList lTables = new ArrayList();
        for (int iDataSource = 0; iDataSource < this.m_lDataSources.size(); ++iDataSource) {
            Object obj = this.m_lDataSources.get(iDataSource);
            if (!(obj instanceof ITable)) continue;
            lTables.add(obj);
        }
        return lTables.toArray(new ITable[lTables.size()]);
    }

    @Override
    public void addConnectedSource(IDataObject source) {
        this.m_lConnectedSources.add(source);
    }

    @Override
    public void removeConnectedSource(IDataObject source) {
        this.m_lConnectedSources.remove(source);
    }

    @Override
    public List getConnectedSources() {
        return this.m_lConnectedSources;
    }

    @Override
    public int getConnectedSourcesCount() {
        return this.m_lConnectedSources.size();
    }

    @Override
    public IDataObject[] getDataTargets() {
        return this.m_lDataTargets.toArray(new IDataObject[this.m_lDataTargets.size()]);
    }

    @Override
    public List getDataTargetList() {
        return this.m_lDataTargets;
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.m_lDataTargets.contains(target);
    }

    @Override
    public int getDataTargetsCount() {
        return this.m_lDataTargets.size();
    }

    @Override
    public void addDataTarget(IDataObject target) {
        this.addDataTarget(this.m_lDataTargets.size(), target);
    }

    public void addDataTarget(int iTarget, IDataObject target) {
        if (this.m_lDataTargets.size() >= this.getMaximumDataTargetCount()) {
            throw new UnsupportedOperationException("Maximum data target count will be exceeded (" + this.getMaximumDataTargetCount() + ")");
        }
        this.m_lDataTargets.add(iTarget, target);
    }

    protected void preAddDataTarget(IDataObject target) {
    }

    protected void postAddDataTarget(IDataObject target) {
        this.postAddTransformTableOption(target, false);
        if (target instanceof IWorkTable) {
            this.updateTargetLibrary((IWorkTable)target);
        }
    }

    @Override
    public void removeDataTarget(IDataObject target) {
        this.m_lDataTargets.remove(target);
        if (target != null) {
            target.removeNotifyListener(this);
        }
    }

    protected void preRemoveDataTarget(IDataObject target) {
        if (target instanceof ITable) {
            this.removeTargetTableFromMappings((ITable)target);
            this.preRemoveTransformTableOptions(target, false);
        }
    }

    protected void postRemoveDataTarget(IDataObject target) {
    }

    protected void clearDataTargetsBeforeLoad() {
        this.m_lDataTargets.clear();
    }

    @Override
    public int getTargetTableIndex(ITable table) {
        IDataObject[] aTargets = this.getDataTargets();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            if (aTargets[iTarget] != table) continue;
            return iTarget;
        }
        return -1;
    }

    protected void updateTargetLibrary(IWorkTable table) {
        IJob job = this.getJob();
        if (job != null && table instanceof IWorkTable) {
            table.setAlternateJobLibrary(job.getAlternateTemporaryLibrary());
        }
    }

    @Override
    public ITable[] getTargetTables() {
        ArrayList lTables = new ArrayList();
        for (int iDataTarget = 0; iDataTarget < this.m_lDataTargets.size(); ++iDataTarget) {
            Object obj = this.m_lDataTargets.get(iDataTarget);
            if (!(obj instanceof ITable)) continue;
            lTables.add(obj);
        }
        return lTables.toArray(new ITable[lTables.size()]);
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable tbl = this.getObjectFactory().createNewWorkTable(this.getID());
            tbl.setName(this.getName());
            this.addDataTarget(tbl);
            IWorkTable iWorkTable = tbl;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IWorkTable[] getWorkTables() {
        ArrayList lWorkTables = new ArrayList();
        for (int iTable = 0; iTable < this.getDataTargetList().size(); ++iTable) {
            if (!(this.getDataTargetList().get(iTable) instanceof IWorkTable)) continue;
            lWorkTables.add(this.getDataTargetList().get(iTable));
        }
        return lWorkTables.toArray(new IWorkTable[lWorkTables.size()]);
    }

    @Override
    public IColumn[] updateMappedColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        return this.updateMappedColumnsImpl(aSourceColumns, tblTarget, true);
    }

    @Override
    public IColumn[] updateMappedColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        return this.updateMappedColumnsImpl(aTargetColumns, tblSource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] updateMappedColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, boolean bForward) {
        this.startCompoundUndoable();
        try {
            List<IColumn> lSourceColumns = Arrays.asList(aSourceColumns);
            IColumn[] aTargetColumns = tblTarget.getColumns();
            ArrayList<IColumn> lUpdatedColumns = new ArrayList<IColumn>();
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            List lMappings = this.getMappingsList();
            for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
                boolean bEqual;
                IColumn[] aTargets;
                IColumn[] aSources;
                IMapping mapping = (IMapping)lMappings.get(iMapping);
                if ("ONETOONE".equals(mapping.getType())) {
                    aSources = bForward ? mapping.getSources() : mapping.getTargets();
                    IColumn[] iColumnArray = aTargets = bForward ? mapping.getTargets() : mapping.getSources();
                    if (aSources.length != 1 || aTargets.length != 1 || !lSourceColumns.contains(aSources[0]) || !tblTarget.containsColumn(aTargets[0])) continue;
                    boolean bl = bEqual = bCaseSensitive ? aSources[0].getName().equals(aTargets[0].getName()) : aSources[0].getName().equalsIgnoreCase(aTargets[0].getName());
                    if (!bEqual && this.doesNameExistInColumns(aSources[0].getName(), aTargetColumns, bCaseSensitive)) continue;
                    aSources[0].deepCopy(aTargets[0]);
                    lUpdatedColumns.add(aTargets[0]);
                    continue;
                }
                if (!"DERIVED".equals(mapping.getType())) continue;
                aSources = bForward ? mapping.getSources() : mapping.getTargets();
                IColumn[] iColumnArray = aTargets = bForward ? mapping.getTargets() : mapping.getSources();
                if (aSources.length != 1 || aTargets.length != 1 || this.doesMappingHaveExpression(mapping) || !lSourceColumns.contains(aSources[0]) || !tblTarget.containsColumn(aTargets[0])) continue;
                boolean bl = bEqual = bCaseSensitive ? aSources[0].getName().equals(aTargets[0].getName()) : aSources[0].getName().equalsIgnoreCase(aTargets[0].getName());
                if (!bEqual && this.doesNameExistInColumns(aSources[0].getName(), aTargetColumns, bCaseSensitive)) continue;
                aSources[0].deepCopy(aTargets[0]);
                lUpdatedColumns.add(aTargets[0]);
            }
            IColumn[] iColumnArray = lUpdatedColumns.toArray(new IColumn[lUpdatedColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private boolean doesMappingHaveExpression(IMapping mapping) {
        IExpression expression = mapping.getExpression();
        if (expression == null) {
            return false;
        }
        try {
            return expression.getText(null, false, false).length() > 0;
        }
        catch (RemoteException ex) {
            ModelLogger.getDefaultLogger().error((Object)BLANK, (Throwable)ex);
        }
        catch (CodegenException ex) {
            ModelLogger.getDefaultLogger().error((Object)BLANK, (Throwable)ex);
        }
        catch (MdException ex) {
            ModelLogger.getDefaultLogger().error((Object)BLANK, (Throwable)ex);
        }
        catch (BadServerDefinitionException ex) {
            ModelLogger.getDefaultLogger().error((Object)BLANK, (Throwable)ex);
        }
        catch (BadLibraryDefinitionException ex) {
            ModelLogger.getDefaultLogger().error((Object)BLANK, (Throwable)ex);
        }
        catch (ServerException ex) {
            ModelLogger.getDefaultLogger().error((Object)BLANK, (Throwable)ex);
        }
        return true;
    }

    protected boolean areExpressionsAllowed() {
        return true;
    }

    @Override
    public boolean isMappingAllowed(IColumn[] aSources, IColumn[] aTargets) {
        return !this.isExpressionNeeded(aSources, aTargets) || this.areExpressionsAllowed();
    }

    @Override
    public String getReasonMappingIsNotAllowed(IColumn[] aSources, IColumn[] aTargets) {
        if (this.isExpressionNeeded(aSources, aTargets) && !this.areExpressionsAllowed()) {
            if (aSources.length == 1 && aTargets.length == 1 && aSources[0].getType() != aTargets[0].getType()) {
                return RB.getStringResource("AbstractDataTransform.ReasonMappingNotAllowed.TypeMismatch.txt");
            }
            return RB.getStringResource("AbstractDataTransform.ReasonMappingNotAllowed.ExpressionNotAllowed.txt");
        }
        return null;
    }

    @Override
    public void mapColumns() {
        this.mapColumns(DefaultMappingRules.getRules());
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget) {
        this.mapColumns(tblSource, tblTarget, DefaultMappingRules.getRules());
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets) {
        this.mapColumns(aSources, aTargets, DefaultMappingRules.getRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapColumns(IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            ITable[] targetTables = this.getTargetTables();
            ITable[] sourceTables = this.getSourceTables();
            for (int iDataTarget = 0; iDataTarget < targetTables.length; ++iDataTarget) {
                ITable tblTarget = targetTables[iDataTarget];
                for (int iDataSource = 0; iDataSource < sourceTables.length; ++iDataSource) {
                    ITable tblSource = sourceTables[iDataSource];
                    this.mapColumns(tblSource, tblTarget, aRules);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget, IMappingRule[] aRules) {
        this.mapColumns(tblSource.getColumns(), tblTarget.getColumns(), aRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets, IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            IColumn[] aOneSource = new IColumn[1];
            IColumn[] aOneTarget = new IColumn[1];
            List lExcludedTargetColumns = this.getListOfColumnsExcludedFromMapping();
            ArrayList<IColumn> lSources = new ArrayList<IColumn>(Arrays.asList(aSources));
            lSources.removeAll(this.getSourceColumnsExcludedFromMapping());
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                IColumn tgt = aTargets[iTarget];
                if (lExcludedTargetColumns.contains(tgt)) continue;
                IMapping mapping = this.findTargetMapping(tgt);
                if (mapping != null && mapping.getExpression() != null) {
                    this.mapUsingExpression(aSources, mapping);
                    continue;
                }
                aOneTarget[0] = tgt;
                boolean bUnmapped = mapping == null;
                for (int iSource = 0; iSource < lSources.size() && bUnmapped; ++iSource) {
                    IColumn src;
                    aOneSource[0] = src = (IColumn)lSources.get(iSource);
                    if (!this.isMappingAllowed(aOneSource, aOneTarget)) continue;
                    for (int iRule = 0; iRule < aRules.length && bUnmapped; ++iRule) {
                        if (!aRules[iRule].canMap(src, tgt)) continue;
                        String sExpression = aRules[iRule].getExpressionText();
                        if (sExpression != null && sExpression.length() > 0) {
                            if (!this.areExpressionsAllowed()) continue;
                            ITextExpression expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                            expression.setText(sExpression, new IObject[]{src, src.getTable()});
                            this.addMapping(aOneSource, aOneTarget, "DERIVED", expression);
                        } else {
                            this.addMapping(aOneSource, aOneTarget, "ONETOONE", null);
                        }
                        bUnmapped = false;
                        lSources.remove(src);
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void mapUsingExpression(IColumn[] aSources, IMapping mapping) {
        IExpression expression = mapping.getExpression();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            if (!expression.containsRememberedColumn(aSources[iSource])) continue;
            mapping.addSource(aSources[iSource]);
        }
    }

    @Override
    public void propagateColumnsToSourceTables() {
        this.propagateColumnsToSourceTables(0);
    }

    @Override
    public void propagateColumnsToSourceTables(int eNonWorkTableHandling) {
        this.propagateColumnsToSourceTables(this.getSourceTables(), this.getTargetTables(), eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        this.propagateColumnsToSourceTables(aSourceTables, aTargetTables, 0);
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        this.propagateColumnsImpl(aTargetTables, aSourceTables, this.getListOfColumnsExcludedFromPropagation(), eNonWorkTableHandling, false);
    }

    @Override
    public void propagateColumnsToTargetTables() {
        this.propagateColumnsToTargetTables(0);
    }

    @Override
    public void propagateColumnsToTargetTables(int eNonWorkTableHandling) {
        this.propagateColumnsToTargetTables(this.getSourceTables(), this.getTargetTables(), eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        this.propagateColumnsToTargetTables(aSourceTables, aTargetTables, 0);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        this.propagateColumnsImpl(aSourceTables, aTargetTables, this.getSourceColumnsExcludedFromPropagation(), eNonWorkTableHandling, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void propagateColumnsImpl(ITable[] aSourceTables, ITable[] aTargetTables, List lExcludedColumns, int eNonWorkTableHandling, boolean bForward) {
        this.startCompoundUndoable();
        try {
            int iTargetTable = 0;
            while (iTargetTable < aTargetTables.length) {
                block8: {
                    int iSourceTable;
                    ITable tblTarget;
                    block9: {
                        block7: {
                            tblTarget = aTargetTables[iTargetTable];
                            if (tblTarget instanceof IWorkTable) break block7;
                            if (eNonWorkTableHandling == 2) break block8;
                            if (eNonWorkTableHandling != 1) break block7;
                            break block9;
                        }
                        for (iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                            this.propagateColumnsImpl(aSourceTables[iSourceTable].getColumns(), tblTarget, lExcludedColumns, bForward);
                        }
                        break block8;
                    }
                    for (iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                        if (bForward) {
                            this.mapColumns(aSourceTables[iSourceTable], tblTarget);
                            continue;
                        }
                        this.mapColumns(tblTarget, aSourceTables[iSourceTable]);
                    }
                }
                ++iTargetTable;
            }
            return;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IColumn[] propagateColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, List lExcludedColumns, boolean bForward) {
        IObjectFactory factory = this.getObjectFactory();
        IColumn[] aSource = new IColumn[1];
        IColumn[] aTarget = new IColumn[1];
        this.startCompoundUndoable();
        try {
            ArrayList<IColumn> lNewTargetColumns = new ArrayList<IColumn>();
            IColumn[] aTargetColumns = tblTarget.getColumns();
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            for (int iColumn = 0; iColumn < aSourceColumns.length; ++iColumn) {
                IColumn colSource = aSourceColumns[iColumn];
                if (lExcludedColumns.contains(colSource) || this.doesNameExistInColumns(colSource.getName(), aTargetColumns, bCaseSensitive) || !bForward && this.getOrdinaryMappingsForTargetColumn(colSource) != null) continue;
                IColumn colTarget = factory.createNewColumn(tblTarget.getID());
                aSourceColumns[iColumn].deepCopy(colTarget);
                tblTarget.addColumn(colTarget);
                lNewTargetColumns.add(colTarget);
                aSource[0] = colSource;
                aTarget[0] = colTarget;
                if (bForward) {
                    this.addMapping(aSource, aTarget, "ONETOONE", null);
                    continue;
                }
                this.addMapping(aTarget, aSource, "ONETOONE", null);
            }
            IColumn[] iColumnArray = lNewTargetColumns.toArray(new IColumn[lNewTargetColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        return this.propagateColumnsToSourceTable(tblSource, aTargetColumns, 0);
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns, int eNonWorkTableHandling) {
        if (!(tblSource instanceof IWorkTable)) {
            if (eNonWorkTableHandling == 2) {
                return new IColumn[0];
            }
            if (eNonWorkTableHandling == 1) {
                this.mapColumns(tblSource.getColumns(), aTargetColumns);
                return new IColumn[0];
            }
        }
        return this.propagateColumnsImpl(aTargetColumns, tblSource, new ArrayList(), false);
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        return this.propagateColumnsToTargetTable(aSourceColumns, tblTarget, 0);
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget, int eNonWorkTableHandling) {
        if (!(tblTarget instanceof IWorkTable)) {
            if (eNonWorkTableHandling == 2) {
                return new IColumn[0];
            }
            if (eNonWorkTableHandling == 1) {
                this.mapColumns(tblTarget.getColumns(), aSourceColumns);
                return new IColumn[0];
            }
        }
        return this.propagateColumnsImpl(aSourceColumns, tblTarget, new ArrayList(), true);
    }

    private List getSourceColumnsExcludedFromPropagation() {
        ArrayList lColumns = new ArrayList();
        ITable[] aTables = this.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IDataTransform[] aProducers = aTables[iTable].getProducerTransforms();
            for (int iProducer = 0; iProducer < aProducers.length; ++iProducer) {
                lColumns.addAll(aProducers[iProducer].getListOfColumnsExcludedFromPropagation());
            }
        }
        return lColumns;
    }

    protected final List getSourceColumnsExcludedFromMapping() {
        ArrayList lColumns = new ArrayList();
        ITable[] aTables = this.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IDataTransform[] aProducers = aTables[iTable].getProducerTransforms();
            for (int iProducer = 0; iProducer < aProducers.length; ++iProducer) {
                lColumns.addAll(aProducers[iProducer].getListOfColumnsExcludedFromMapping());
            }
        }
        return lColumns;
    }

    private boolean doesNameExistInColumns(String sName, IColumn[] aColumns, boolean bCaseSensitive) {
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            boolean bEquals;
            String sColumnName = aColumns[iColumn].getName();
            boolean bl = bEquals = bCaseSensitive ? sColumnName.equals(sName) : sColumnName.equalsIgnoreCase(sName);
            if (!bEquals) continue;
            return true;
        }
        return false;
    }

    protected final IMapping findTargetMapping(IColumn colTarget) {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            IColumn[] aTargets = mapping.getTargets();
            if (aTargets.length != 1 || aTargets[0] != colTarget) continue;
            return mapping;
        }
        return null;
    }

    public void replaceTargetTable(ITable oldTable, ITable newTable) {
        this.replaceTargetTable(oldTable, newTable, null, null);
    }

    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Integer[] portIndexes) {
        this.replaceTargetTable(oldTable, newTable, null, portIndexes);
    }

    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.replaceTargetTable(oldTable, newTable, columnsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.preReplaceTargetTable(oldTable, newTable, columnsMap);
            this.replaceTargetMappings(oldTable, newTable, columnsMap);
            this.replaceTargetTableOptions(oldTable, newTable, columnsMap);
            this.removeDataTarget(oldTable);
            this.addDataTarget(newTable);
            this.postReplaceTargetTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void preReplaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
    }

    protected void postReplaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceTargetMappings(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            IMapping mapping;
            int iMap;
            ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
            IMapping[] aMappings = this.getMappings();
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                IColumn[] aColumns = mapping.getTargets();
                block4: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    if (!oldTable.containsColumn(column)) {
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    boolean bCaseSenistive = this.isQuotingNeeded() || newTable.isQuoted();
                    for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        IColumn newColumn = aNewColumns[iNewColumn];
                        if (!column.equalsName(newColumn, bCaseSenistive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                        mapping.replaceTargetColumn(column, newColumn);
                        lChangedMappings.add(mapping);
                        continue block4;
                    }
                }
            }
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                this.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Integer[] portIndexes) {
        this.replaceSourceTable(oldTable, newTable, null, portIndexes);
    }

    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.replaceSourceTable(oldTable, newTable, columnsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.replaceSourceMappings(oldTable, newTable, columnsMap);
            this.replaceSourceTableOptions(oldTable, newTable, columnsMap);
            this.removeDataSource(oldTable);
            this.removeConnectedSource(oldTable);
            this.addDataSource(newTable);
            this.addConnectedSource(newTable);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void replaceSourceTableOptions(ITable oldTable, ITable newTable, Map columnsMap) {
        try {
            IPromptModel optionModel = this.getOptionModel();
            optionModel.replaceSourceTable(oldTable, newTable, columnsMap, this.isQuotingNeeded());
        }
        catch (FileNotFoundException ex) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)ex);
        }
        catch (ServiceException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
        }
        catch (ServerConnectionException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
        }
        catch (IOException ex) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)ex);
        }
        catch (SAXException ex) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)ex);
        }
        catch (MdException ex) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
        }
    }

    protected void replaceTargetTableOptions(ITable oldTable, ITable newTable, Map columnsMap) {
        try {
            IPromptModel optionModel = this.getOptionModel();
            optionModel.replaceTargetTable(oldTable, newTable, columnsMap, this.isQuotingNeeded());
        }
        catch (FileNotFoundException ex) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)ex);
        }
        catch (ServiceException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
        }
        catch (ServerConnectionException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
        }
        catch (IOException ex) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)ex);
        }
        catch (SAXException ex) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)ex);
        }
        catch (MdException ex) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceSourceMappings(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            IMapping mapping;
            int iMap;
            ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
            IMapping[] aMappings = this.getMappings();
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                IColumn[] aColumns = mapping.getSources();
                block4: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    if (!oldTable.containsColumn(column)) {
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    boolean bCaseSenistive = this.isQuotingNeeded() || newTable.isQuoted();
                    for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        IColumn newColumn = aNewColumns[iNewColumn];
                        if (!column.equalsName(newColumn, bCaseSenistive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                        mapping.replaceSourceColumn(column, newColumn);
                        lChangedMappings.add(mapping);
                        continue block4;
                    }
                }
            }
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                this.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        this.startCompoundUndoable();
        try {
            List lMappings = this.getMappingsList();
            for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
                IMapping mapping = (IMapping)lMappings.get(iMapping);
                for (int iColumn = 0; iColumn < aOldColumns.length; ++iColumn) {
                    int iWhere = mapping.indexInSources(aOldColumns[iColumn]);
                    if (iWhere == -1) continue;
                    mapping.replaceSourceColumn(aOldColumns[iColumn], aNewColumns[iColumn]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        this.startCompoundUndoable();
        try {
            List lMappings = this.getMappingsList();
            for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
                IMapping mapping = (IMapping)lMappings.get(iMapping);
                for (int iColumn = 0; iColumn < aOldColumns.length; ++iColumn) {
                    int iWhere = mapping.indexInTargets(aOldColumns[iColumn]);
                    if (iWhere == -1) continue;
                    mapping.replaceTargetColumn(aOldColumns[iColumn], aNewColumns[iColumn]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceTableFromMappings(ITable tbl) {
        this.startCompoundUndoable();
        try {
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.removeSourceColumnFromMappings(aColumns[iColumn]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (!mapping.containsInSources(column)) continue;
                mapping.removeSource(column);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetTableFromMappings(ITable tbl) {
        this.startCompoundUndoable();
        try {
            IColumn[] aColumns = tbl.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.removeTargetColumnFromMappings(aColumns[iColumn]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (!mapping.containsInTargets(column)) continue;
                if (mapping.getType() == "ONETOONE") {
                    this.removeMapping(mapping);
                    continue;
                }
                mapping.removeTarget(column);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IMapping[] getMappings() {
        List lMappings = this.getMappingsList();
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public List getMappingsList() {
        return this.m_lMappings;
    }

    @Override
    public IMapping[] getOrdinaryMappings() {
        ArrayList<IMapping> lOrdinaryMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary()) continue;
            lOrdinaryMappings.add(mapping);
        }
        return lOrdinaryMappings.toArray(new IMapping[lOrdinaryMappings.size()]);
    }

    @Override
    public IMapping[] getSpecialMappings() {
        ArrayList<IMapping> lSpecialMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isSpecial()) continue;
            lSpecialMappings.add(mapping);
        }
        return lSpecialMappings.toArray(new IMapping[lSpecialMappings.size()]);
    }

    @Override
    public IMapping[] getOrdinaryMappingsForSourceColumn(IColumn source) {
        ArrayList<IMapping> lOrdinaryMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary() || !mapping.containsInSources(source)) continue;
            lOrdinaryMappings.add(mapping);
        }
        return lOrdinaryMappings.toArray(new IMapping[lOrdinaryMappings.size()]);
    }

    @Override
    public IMapping getOrdinaryMappingsForTargetColumn(IColumn target) {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary() || !mapping.containsInTargets(target)) continue;
            return mapping;
        }
        return null;
    }

    protected void clearMappingsBeforeLoad() {
        List lMappings = this.getMappingsList();
        lMappings.clear();
    }

    protected boolean isExpressionNeeded(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length != 1 || aTargets.length != 1) {
            return true;
        }
        return aSources[0].getType() != aTargets[0].getType();
    }

    protected IMapping createNewMapping() {
        return this.getModel().getObjectFactory().createNewMapping(this.getID());
    }

    @Override
    public IMapping addMapping(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length == 1 && aTargets.length == 1) {
            IMappingRule[] aRules = DefaultMappingRules.getRules();
            for (int iRule = 0; iRule < aRules.length; ++iRule) {
                if (!aRules[iRule].canMap(aSources[0], aTargets[0])) continue;
                String sExpression = aRules[iRule].getExpressionText();
                if (sExpression != null && sExpression.length() > 0) {
                    if (!this.areExpressionsAllowed()) continue;
                    ITextExpression expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                    expression.setText(sExpression, new IObject[]{aSources[0], aSources[0].getTable()});
                    return this.addMapping(aSources, aTargets, "DERIVED", expression);
                }
                return this.addMapping(aSources, aTargets, "ONETOONE", null);
            }
        }
        String sType = this.isExpressionNeeded(aSources, aTargets) ? "DERIVED" : "ONETOONE";
        return this.addMapping(aSources, aTargets, sType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapping addMapping(IColumn[] aSourceColumns, IColumn[] aTargetColumns, String sType, IExpression oExpression) {
        this.startCompoundUndoable();
        try {
            IMapping mapping = this.createNewMapping();
            mapping.setName(aTargetColumns.length == 1 ? aTargetColumns[0].getName() : "newmapping");
            mapping.setType(sType);
            mapping.setExpression(oExpression);
            for (int iSourceColumn = 0; iSourceColumn < aSourceColumns.length; ++iSourceColumn) {
                mapping.addSource(aSourceColumns[iSourceColumn]);
            }
            for (int iTargetColumn = 0; iTargetColumn < aTargetColumns.length; ++iTargetColumn) {
                mapping.addTarget(aTargetColumns[iTargetColumn]);
            }
            if (mapping.isOrdinary() && mapping instanceof BaseMapping) {
                BaseMapping ordinary = (BaseMapping)mapping;
                ordinary.setAutoType(true);
                ordinary.setExpressionAllowed(this.areExpressionsAllowed());
            }
            this.addMapping(mapping);
            IMapping iMapping = mapping;
            return iMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addMapping(IMapping mapping) {
        this.addMapping(this.m_lMappings.size(), mapping);
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        this.removeFromDeletedObjects(mapping);
        this.m_lMappings.add(iMapping, mapping);
        this.fireModelChangedEvent("MappingsContainer:MappingAdded", mapping);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddMappingUndoable(iMapping, mapping));
        }
        mapping.addNotifyListener(this);
    }

    @Override
    public void removeMapping(IMapping mapping) {
        int iMapping = this.m_lMappings.indexOf(mapping);
        if (iMapping == -1) {
            return;
        }
        this.addToDeletedObjects(mapping);
        this.m_lMappings.remove(iMapping);
        this.fireModelChangedEvent("MappingsContainer:MappingRemoved", mapping);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveMappingUndoable(iMapping, mapping));
        }
        mapping.removeNotifyListener(this);
    }

    @Override
    public boolean containsMapping(IMapping mapping) {
        return this.m_lMappings.contains(mapping);
    }

    @Override
    public IColumn[] getColumnsExcludedFromMapping() {
        return this.m_lColumnsExcludedFromMapping.toArray(new IColumn[this.m_lColumnsExcludedFromMapping.size()]);
    }

    @Override
    public List getListOfColumnsExcludedFromMapping() {
        return this.m_lColumnsExcludedFromMapping;
    }

    @Override
    public IColumn[] getColumnsExcludedFromPropagation() {
        return this.m_lColumnsExcludedFromPropagation.toArray(new IColumn[this.m_lColumnsExcludedFromPropagation.size()]);
    }

    @Override
    public List getListOfColumnsExcludedFromPropagation() {
        return this.m_lColumnsExcludedFromPropagation;
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getType() == 1 && ev.getSource() instanceof IMapping) {
            IMapping mapping = (IMapping)ev.getSource();
            if (mapping.isReplacing()) {
                this.fireModelChangedEvent("MappingsContainer:MappingChanged", ev.getSource());
            } else if (mapping.isDead()) {
                this.removeMapping(mapping);
            } else {
                this.fireModelChangedEvent("MappingsContainer:MappingChanged", ev.getSource());
            }
            this.fireModelChangedEvent("ITransform:TransformChanged", mapping);
        } else if (ev.getSource() instanceof IDataObject) {
            String sType = BLANK;
            if (ev.getModelEvent() != null) {
                sType = ev.getModelEvent().getType();
            }
            if (!sType.equals("Objecty:ResponsiblePartyAdded") && !sType.equals("Objecty:ResponsiblePartyRemoved")) {
                IDataObject dataObject = (IDataObject)ev.getSource();
                if (this.getDataSourceList().contains(dataObject) || this.getDataTargetList().contains(dataObject)) {
                    this.fireModelChangedEvent("ITransform:TransformChanged", dataObject);
                }
            }
        } else {
            super.notify(ev);
        }
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return this.m_lDataTargets.isEmpty();
    }

    @Override
    public boolean isAddInputAvailable() {
        return false;
    }

    @Override
    public boolean isGenDefaultJobStatusUpdate() {
        return true;
    }

    @Override
    public boolean isAddOutputAvailable() {
        return false;
    }

    @Override
    public boolean isDeleteInputAvailable() {
        return false;
    }

    @Override
    public boolean isDeleteOutputAvailable() {
        return false;
    }

    @Override
    public void addInput() {
        throw new UnsupportedOperationException("add input not supported");
    }

    @Override
    public void addOutput() {
        throw new UnsupportedOperationException("add output not supported");
    }

    @Override
    public void deleteInput() {
        throw new UnsupportedOperationException("delete input not supported");
    }

    @Override
    public void deleteOutput() {
        throw new UnsupportedOperationException("delete output not supported");
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        return this.isSourceTargetTablesWarning() || this.hasMappingWarnings();
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        warnings.addAll(this.getSourceTargetsWarnings());
        warnings.addAll(this.getMappingWarnings());
        return warnings;
    }

    protected boolean hasMappingWarnings() {
        IMapping[] mappings = this.getOrdinaryMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].hasWarnings()) continue;
            return true;
        }
        return false;
    }

    protected List getMappingWarnings() {
        ArrayList warnings = new ArrayList();
        IMapping[] mappings = this.getOrdinaryMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].hasWarnings()) continue;
            warnings.addAll(mappings[i].getWarnings());
        }
        return warnings;
    }

    @Override
    public boolean isComplete() {
        return !(!super.isComplete() || this.doesNoSourcesMeanIncomplete() && this.getDataSourceList().isEmpty() || this.doesNoTargetsMeanIncomplete() && this.getDataTargetList().isEmpty() || this.doesNoMappingsMeanIncomplete() && !this.doesMappingExistOnAllTargetTables() || !this.areMappingsComplete() || !this.isSourceTargetTablesComplete());
    }

    protected boolean isMappingRequiredForTargetTable(ITable table) {
        return true;
    }

    protected boolean doesMappingExistOnAllTargetTables() {
        List lMappings = this.getMappingsList();
        if (lMappings.isEmpty()) {
            return false;
        }
        ArrayList<ITable> targets = new ArrayList<ITable>();
        for (ITable table : this.getTargetTables()) {
            if (!this.isMappingRequiredForTargetTable(table)) continue;
            targets.add(table);
        }
        ITable[] aTargetTables = targets.toArray(new ITable[targets.size()]);
        ArrayList<ITable> lTargetTables = new ArrayList<ITable>(aTargetTables.length);
        for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
            lTargetTables.add(aTargetTables[iTargetTable]);
        }
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isOrdinary()) continue;
            IColumn[] aColumns = mapping.getTargets();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                if (!lTargetTables.remove(aColumns[iColumn].getTable()) || !lTargetTables.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getDataSourceList().isEmpty() && this.doesNoSourcesMeanIncomplete()) {
            lReasons.add(RB.getStringResource("AbstractDataTransform.ReasonIncomplete.NoSources.txt"));
        }
        if (this.getDataTargetList().isEmpty() && this.doesNoTargetsMeanIncomplete()) {
            lReasons.add(RB.getStringResource("AbstractDataTransform.ReasonIncomplete.NoTargets.txt"));
        }
        if (!this.doesMappingExistOnAllTargetTables() && this.doesNoMappingsMeanIncomplete()) {
            lReasons.add(RB.getStringResource("AbstractDataTransform.ReasonIncomplete.NoMappings.txt"));
        }
        lReasons.addAll(this.getReasonsSourceTargetsIncomplete());
        lReasons.addAll(this.getReasonsMappingsIncomplete());
        return lReasons;
    }

    protected boolean isSourceTargetTablesWarning() {
        int i;
        IDataObject[] sources = this.getDataSources();
        IDataObject[] targets = this.getDataTargets();
        for (i = 0; i < sources.length; ++i) {
            if (!sources[i].hasWarnings()) continue;
            return true;
        }
        for (i = 0; i < targets.length; ++i) {
            if (!targets[i].hasWarnings()) continue;
            return true;
        }
        return false;
    }

    protected boolean isSourceTargetTablesComplete() {
        int i;
        IDataObject[] sources = this.getDataSources();
        IDataObject[] targets = this.getDataTargets();
        for (i = 0; i < sources.length; ++i) {
            if (sources[i].isComplete()) continue;
            return false;
        }
        for (i = 0; i < targets.length; ++i) {
            if (targets[i].isComplete()) continue;
            return false;
        }
        return true;
    }

    protected List getSourceTargetsWarnings() {
        int i;
        ArrayList reasons = new ArrayList();
        IDataObject[] sources = this.getDataSources();
        IDataObject[] targets = this.getDataTargets();
        for (i = 0; i < sources.length; ++i) {
            reasons.addAll(sources[i].getWarnings());
        }
        for (i = 0; i < targets.length; ++i) {
            reasons.addAll(targets[i].getWarnings());
        }
        return reasons;
    }

    protected List getReasonsSourceTargetsIncomplete() {
        int i;
        ArrayList reasons = new ArrayList();
        IDataObject[] sources = this.getDataSources();
        IDataObject[] targets = this.getDataTargets();
        for (i = 0; i < sources.length; ++i) {
            reasons.addAll(sources[i].getReasonsIncomplete());
        }
        for (i = 0; i < targets.length; ++i) {
            reasons.addAll(targets[i].getReasonsIncomplete());
        }
        return reasons;
    }

    protected boolean doesNoSourcesMeanIncomplete() {
        return true;
    }

    protected boolean doesNoTargetsMeanIncomplete() {
        return true;
    }

    protected boolean doesNoMappingsMeanIncomplete() {
        return !this.isUsingUserWrittenCode();
    }

    protected boolean areMappingsComplete() {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (mapping.isComplete()) continue;
            return false;
        }
        return true;
    }

    protected List getReasonsMappingsIncomplete() {
        List lMappings = this.getMappingsList();
        ArrayList lReasons = new ArrayList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            lReasons.addAll(mapping.getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public String getOMRType() {
        return "TransformationStep";
    }

    protected String getClassifierMapType() {
        return "ClassifierMap";
    }

    protected ClassifierMap getClassifierMapObject(OMRAdapter omr) throws MdException, RemoteException {
        return (ClassifierMap)omr.acquireOMRObject(this.m_sClassifierMapID, this.getClassifierMapType());
    }

    @Override
    public boolean isChanged() {
        IDataObject data;
        if (super.isChanged()) {
            return true;
        }
        for (int iSource = 0; iSource < this.m_lDataSources.size(); ++iSource) {
            data = (IDataObject)this.m_lDataSources.get(iSource);
            if (!data.isChanged()) continue;
            return true;
        }
        for (int iTarget = 0; iTarget < this.m_lDataTargets.size(); ++iTarget) {
            data = (IDataObject)this.m_lDataTargets.get(iTarget);
            if (!data.isChanged()) continue;
            return true;
        }
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            if (!mapping.isChanged()) continue;
            return true;
        }
        ITransformTableOptions[] tableOpts = this.getTableOptionObjects();
        for (int i = 0; i < tableOpts.length; ++i) {
            if (!tableOpts[i].isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.saveWorkTablesToOMR(omr);
        this.saveClassifierMapToOMR(omr, mdoStep);
        String sGenerateSYSLAST = this.isSYSLASTVariableGenerationEnabled() ? "YES" : "NO";
        this.savePropertyToOMR(omr, "OPTIONS", "SYSLAST", "SYSLAST", "SYSLAST", sGenerateSYSLAST, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", "GENERATEFORMATSINFORMATS", "GENERATEFORMATSINFORMATS", "GENERATEFORMATSINFORMATS", this.m_sGenerateFormatsInformats, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", "USECONNECTUSING", "USECONNECTUSING", "USECONNECTUSING", this.m_sUseConnectUsing, 12, 2);
        String sAppendForce = this.isAppendForceEnabled() ? "YES" : "NO";
        this.savePropertyToOMR(omr, "OPTIONS", "APPENDFORCE", "APPENDFORCE", "APPENDFORCE", sAppendForce, 12, 2);
        String sColMacroVars = this.isColMacroVarsEnabled() ? "YES" : "NO";
        this.savePropertyToOMR(omr, "OPTIONS", "COLMACROVARS", "COLMACROVARS", "COLMACROVARS", sColMacroVars, 12, 2);
        String sFileMacroVars = this.isFileMacroVarsEnabled() ? "YES" : "NO";
        this.savePropertyToOMR(omr, "OPTIONS", "FILEMACROVARS", "FILEMACROVARS", "FILEMACROVARS", sFileMacroVars, 12, 2);
        this.saveBooleanOptionToOMR(omr, INCLUDED_IN_PROPAGATION, this.m_bIncludedInPropagation);
        this.saveBooleanOptionToOMR(omr, INCLUDED_IN_MAPPING, this.m_bIncludedInMapping);
        this.saveBooleanOptionToOMR(omr, "GenerateIndexesOnTargets", this.isGenerateIndexesOnTargetTables());
        this.saveStringOptionToOMR(omr, "OPTION_DBI_DIRECT_EXEC", this.getDBIDirectExecValue());
        this.saveCustomListToOMR(omr, COLUMNS_EXCLUDED_FROM_MAPPING_NAME, this.getColumnsExcludedFromMapping());
        this.saveCustomListToOMR(omr, COLUMNS_EXCLUDED_FROM_PROPAGATION_NAME, this.getColumnsExcludedFromPropagation());
        this.saveCustomListToOMR(omr, CONNECTED_SOURCES_NAME, this.m_lConnectedSources.toArray(new IDataObject[0]));
        this.saveTransformTableOptions(omr);
        this.setChanged(false);
    }

    protected void saveWorkTablesToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IWorkTable[] aTables = this.getWorkTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            aTables[iTable].saveToOMR(omr);
        }
    }

    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
        ITransformTableOptions[] opts = this.getTableOptionObjects();
        for (int i = 0; i < opts.length; ++i) {
            opts[i].saveToOMR(omr);
        }
    }

    protected void saveClassifierMapToOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        AssociationList lTransformations = mdoStep.getTransformations(false);
        lTransformations.clear();
        String sName = this.getName();
        if (this.m_sClassifierMapID == null || this.m_sClassifierMapID.length() == 0) {
            this.m_sClassifierMapID = this.createIDForNewObject();
        }
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this.m_sClassifierMapID, this.getClassifierMapType());
        mdoCM.setName(sName);
        mdoCM.getClassifierTargets(false).clear();
        mdoCM.getClassifierSources(false).clear();
        IDataObject[] aDataSources = this.getDataSources();
        for (int iDataSource = 0; iDataSource < aDataSources.length; ++iDataSource) {
            IDataObject objSource = aDataSources[iDataSource];
            if (!(objSource instanceof ITable)) continue;
            mdoCM.getClassifierSources(false).add((Object)omr.acquireOMRObject(objSource));
        }
        IDataObject[] aDataTargets = this.getDataTargets();
        for (int i = 0; i < aDataTargets.length; ++i) {
            if (!(aDataTargets[i] instanceof ITable)) continue;
            mdoCM.getClassifierTargets(false).add((Object)omr.acquireOMRObject(aDataTargets[i]));
        }
        ITable[] aMappingTargets = this.getTargetTables();
        for (int i = 0; i < aMappingTargets.length; ++i) {
            this.saveMappingsToOMR(omr, mdoCM, aMappingTargets[i]);
        }
        lTransformations.add(mdoCM);
    }

    @Override
    protected AbstractTransformation getUserWrittenCodeAnchor(OMRAdapter omr) throws MdException, RemoteException {
        TransformationStep mdoThis = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList classifiers = mdoThis.getTransformations();
        if (!classifiers.isEmpty()) {
            this.m_sClassifierMapID = ((Root)classifiers.get(0)).getFQID();
        }
        if (this.m_sClassifierMapID == null || this.m_sClassifierMapID.length() == 0) {
            this.m_sClassifierMapID = this.createIDForNewObject();
        }
        return (AbstractTransformation)omr.acquireOMRObject(this.m_sClassifierMapID, this.getClassifierMapType());
    }

    protected void saveMappingsToOMR(OMRAdapter omr, ClassifierMap mdoCM, ITable tblTarget) throws MdException, RemoteException {
        AssociationList lFMs = mdoCM.getFeatureMaps(false);
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)lMappings.get(iMapping);
            IColumn[] aTargets = mapping.getTargets();
            if (mapping.isDead()) {
                this.removeMapping(mapping);
                continue;
            }
            if (mapping.isOrdinary() && aTargets.length != 0 && aTargets[0].getTable() != tblTarget) continue;
            mapping.saveToOMR(omr);
            Root mdoMapping = omr.acquireOMRObject(mapping);
            lFMs.add(mdoMapping);
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_sClassifierMapID = this.updateSubordinateID(this.m_sClassifierMapID, mapIDs);
        IMapping[] maps = this.getMappings();
        for (int i = 0; i < maps.length; ++i) {
            maps[i].updateIDs(mapIDs);
        }
        ITransformTableOptions[] opts = this.getTableOptionObjects();
        for (int i = 0; i < opts.length; ++i) {
            opts[i].updateIDs(mapIDs);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        int iColumn;
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.loadDataSourcesTargetsFromOMR(omr, mdoStep);
        String value = this.loadPropertyFromOMR(omr, "OPTIONS", "SYSLAST", "YES", 2);
        this.setSYSLASTVariableGenerationEnabled("YES".equalsIgnoreCase(value));
        String FORCE_value = this.loadPropertyFromOMR(omr, "OPTIONS", "APPENDFORCE", "YES", 2);
        this.setAppendForceEnabled("YES".equalsIgnoreCase(FORCE_value));
        String COLMACRO_Value = this.loadPropertyFromOMR(omr, "OPTIONS", "COLMACROVARS", "YES", 2);
        this.setColMacroVarsEnabled("YES".equalsIgnoreCase(COLMACRO_Value));
        String FILEMACRO_Value = this.loadPropertyFromOMR(omr, "OPTIONS", "FILEMACROVARS", "YES", 2);
        this.setFileMacroVarsEnabled("YES".equalsIgnoreCase(FILEMACRO_Value));
        String formatsinformats_value = this.loadPropertyFromOMR(omr, "OPTIONS", "GENERATEFORMATSINFORMATS", "JOB", 2);
        this.setFormatInformatGeneration(formatsinformats_value);
        String useConnectUsing_value = this.loadPropertyFromOMR(omr, "OPTIONS", "USECONNECTUSING", "JOB", 2);
        this.setUseConnectUsing(useConnectUsing_value);
        this.setGenerateIndexesOnTargetTables(this.loadBooleanOptionFromOMR(omr, "GenerateIndexesOnTargets", true));
        this.setIncludedInPropagation(this.loadBooleanOptionFromOMR(omr, INCLUDED_IN_PROPAGATION, true));
        this.setIncludedInMapping(this.loadBooleanOptionFromOMR(omr, INCLUDED_IN_MAPPING, true));
        this.setDBIDirectExec(this.loadStringOptionFromOMR(omr, "OPTION_DBI_DIRECT_EXEC", this.getDefaultDBIDirectExecValue()));
        IPersistableObject[] aColumns = this.loadCustomListFromOMR(omr, COLUMNS_EXCLUDED_FROM_MAPPING_NAME);
        for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            this.getListOfColumnsExcludedFromMapping().add(aColumns[iColumn]);
        }
        aColumns = this.loadCustomListFromOMR(omr, COLUMNS_EXCLUDED_FROM_PROPAGATION_NAME);
        for (iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            this.getListOfColumnsExcludedFromPropagation().add(aColumns[iColumn]);
        }
        IPersistableObject[] aConnectedSources = this.loadCustomListFromOMR(omr, CONNECTED_SOURCES_NAME);
        for (int i = 0; i < aConnectedSources.length; ++i) {
            this.m_lConnectedSources.add(aConnectedSources[i]);
        }
        try {
            IPromptModel optionModel = this.getOptionModel();
            if (optionModel != null) {
                if (optionModel.getDataProvider() != null) {
                    optionModel.getDataProvider().addDataSources(this.getDataSources());
                    optionModel.getDataProvider().addDataTargets(this.getDataTargets());
                }
                optionModel.fixDefinitions();
            }
        }
        catch (FileNotFoundException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServerConnectionException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        boolean changed = this.loadTransformTableOptionsFromOMR(omr);
        this.setChanged(changed);
    }

    protected void loadDataSourcesTargetsFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        this.m_lDataSources.clear();
        this.m_lDataTargets.clear();
        AssociationList lTransformations = mdoStep.getTransformations();
        if (!lTransformations.isEmpty()) {
            ClassifierMap mdoCM = (ClassifierMap)lTransformations.get(0);
            this.m_sClassifierMapID = mdoCM.getFQID();
            AssociationList lSources = mdoCM.getClassifierSources();
            for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                Root mdoSource = (Root)lSources.get(iSource);
                IDataObject source = (IDataObject)omr.acquireObject(mdoSource);
                if (this.m_lDataSources.contains(source) || iSource >= this.getMaximumDataSourceCount()) continue;
                this.addDataSource(source);
            }
            AssociationList lTargets = mdoCM.getClassifierTargets();
            for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                Root mdoTarget = (Root)lTargets.get(iTarget);
                IDataObject target = (IDataObject)omr.acquireObject(mdoTarget);
                if (!this.m_lDataTargets.contains(target) && iTarget < this.getMaximumDataTargetCount()) {
                    this.addDataTarget(target);
                }
                if (!(target instanceof BaseWorkTable)) continue;
                ((BaseWorkTable)target).resetOptionModel(omr);
            }
            this.loadMappingsFromOMR(omr, mdoCM);
        }
    }

    protected ITransformTableOptions findTransformTableOptionsFromOMR(OMRAdapter omr, IPhysicalTable table) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            BaseTransformTableOptions transformOpts;
            IPhysicalTable associatedtable;
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole()) || (associatedtable = (transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel())).loadAssociatedObject(omr, pSet.getFQID())) != table) continue;
            transformOpts.setOwner(this);
            transformOpts.loadFromOMR(omr);
            return transformOpts;
        }
        return null;
    }

    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        boolean changed = false;
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            List tableList;
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole())) continue;
            BaseTransformTableOptions transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel());
            IPhysicalTable table = transformOpts.loadAssociatedObject(omr, pSet.getFQID());
            List list = tableList = "Read".equals(pSet.getPropertySetName()) ? this.getDataSourceList() : this.getDataTargetList();
            if (tableList.contains(table)) {
                transformOpts.setOwner(this);
                transformOpts.loadFromOMR(omr);
                this.addTransformTableOption(transformOpts);
                continue;
            }
            this.addToDeletedObjects(transformOpts);
            changed = true;
        }
        return changed;
    }

    protected void loadMappingsFromOMR(OMRAdapter omr, ClassifierMap mdoCM) throws MdException, RemoteException {
        AssociationList lFMs = mdoCM.getFeatureMaps();
        for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
            FeatureMap mdoFM = (FeatureMap)lFMs.get(iFM);
            IMapping mapping = this.createMapping(omr, mdoFM);
            if (mapping.isDead()) {
                this.addToDeletedObjects(mapping);
                continue;
            }
            this.addMapping(mapping);
        }
    }

    protected IMapping createMapping(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        BaseMapping mapping = (BaseMapping)omr.acquireObject((Root)mdoFM);
        mapping.setExpressionAllowed(this.areExpressionsAllowed());
        if (mapping.isOrdinary()) {
            mapping.setAutoType(true);
        }
        return mapping;
    }

    @Override
    public void dispose() {
        super.dispose();
        ITransformTableOptions[] tableOptions = this.getTableOptionObjects();
        for (int i = 0; i < tableOptions.length; ++i) {
            tableOptions[i].dispose();
        }
    }

    @Override
    public void delete() {
        IWorkTable[] aTables = this.getWorkTables();
        if (aTables == null) {
            return;
        }
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            aTables[iTable].delete();
        }
        ITransformTableOptions[] tableOptions = this.getTableOptionObjects();
        for (int i = 0; i < tableOptions.length; ++i) {
            tableOptions[i].delete();
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.deleteWorkTablesFromOMR(omr);
        this.deleteClassifierMapFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    protected void deleteTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ITransformTableOptions[] tableModels = this.getTableOptionObjects();
        for (int i = 0; i < tableModels.length; ++i) {
            tableModels[i].deleteFromOMR(omr);
        }
    }

    private void deleteWorkTablesFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IWorkTable[] aTables = this.getWorkTables();
        if (aTables == null) {
            return;
        }
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            aTables[iTable].deleteFromOMR(omr);
        }
    }

    protected void deleteClassifierMapFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            ((IMapping)lMappings.get(iMapping)).deleteFromOMR(omr);
        }
        if (this.m_sClassifierMapID != null) {
            omr.deleteOMRObject(this.m_sClassifierMapID, this.getClassifierMapType());
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("TransformationStep");
        if (lAssociations == null) {
            ModelLogger.getDefaultLogger().error((Object)"No entry in load map for TransformationStep");
        } else {
            lAssociations.add("Transformations");
        }
        lAssociations = new ArrayList<String>();
        lAssociations.add("FeatureMaps");
        lAssociations.add("ClassifierSources");
        lAssociations.add("ClassifierTargets");
        lAssociations.add("SourceCode");
        lAssociations.add("TransformationSources");
        lAssociations.add("TransformationTargets");
        map.put(this.getClassifierMapType(), lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("FeatureSources");
        lAssociations.add("FeatureTargets");
        map.put("FeatureMap", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("Columns");
        map.put("PhysicalTable", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("Columns");
        map.put("WorkTable", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("Predecessors");
        lAssociations.add("Successors");
        map.put("StepPrecedence", lAssociations);
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public boolean isQuotingNeeded() {
        ArrayList<IDataObject> tables = new ArrayList<IDataObject>(Arrays.asList(this.getDataSources()));
        tables.addAll(Arrays.asList(this.getDataTargets()));
        int tableSize = tables.size();
        for (int i = 0; i < tableSize; ++i) {
            ITable table;
            IDataObject dObject = (IDataObject)tables.get(i);
            if (!(dObject instanceof ITable) || !(table = (ITable)dObject).isQuoted()) continue;
            return true;
        }
        return false;
    }

    public void setConnectUsingFlagOnTables() {
        ArrayList<IDataObject> tables = new ArrayList<IDataObject>(Arrays.asList(this.getDataSources()));
        tables.addAll(Arrays.asList(this.getDataTargets()));
        int tableSize = tables.size();
        for (int i = 0; i < tableSize; ++i) {
            IDataObject dObject = (IDataObject)tables.get(i);
            if (!(dObject instanceof ITable)) continue;
            boolean bUseConnectUsing = this.isUseConnectUsingEnabled();
            ITable table = (ITable)dObject;
            table.setUseConnectUsing(bUseConnectUsing);
        }
    }

    @Override
    public final boolean isSpecialCharactersNeeded() {
        ArrayList<IDataObject> tables = new ArrayList<IDataObject>(Arrays.asList(this.getDataSources()));
        tables.addAll(Arrays.asList(this.getDataTargets()));
        int tableSize = tables.size();
        for (int i = 0; i < tableSize; ++i) {
            ITable table;
            IDataObject dObject = (IDataObject)tables.get(i);
            if (!(dObject instanceof ITable) || !(table = (ITable)dObject).isSpecialCharacters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dump(PrintStream strm) {
        super.dump(strm);
        strm.println("<Data Sources>");
        for (int iDataSource = 0; iDataSource < this.m_lDataSources.size(); ++iDataSource) {
            ((IObject)this.m_lDataSources.get(iDataSource)).dump(strm);
        }
        strm.println("</Data Sources>");
        strm.println("<Data Targets>");
        for (int iDataTarget = 0; iDataTarget < this.m_lDataTargets.size(); ++iDataTarget) {
            ((IObject)this.m_lDataTargets.get(iDataTarget)).dump(strm);
        }
        strm.println("</Data Targets>");
        strm.println("<Mappings>");
        List lMappings = this.getMappingsList();
        for (int iMapping = 0; iMapping < lMappings.size(); ++iMapping) {
            ((IMapping)lMappings.get(iMapping)).dump(strm);
        }
        strm.println("</Mappings>");
    }

    @Override
    public void dumpXML(PrintStream stream) {
        IObject obj;
        int iDataSource;
        super.dumpXML(stream);
        stream.println("<sources>");
        for (iDataSource = 0; iDataSource < this.m_lDataSources.size(); ++iDataSource) {
            obj = (IObject)this.m_lDataSources.get(iDataSource);
            stream.println("<table>");
            stream.println("<name>" + obj.getName() + "</name>");
            stream.println("</table>");
        }
        stream.println("</sources>");
        stream.println("<targets>");
        for (iDataSource = 0; iDataSource < this.m_lDataTargets.size(); ++iDataSource) {
            obj = (IObject)this.m_lDataTargets.get(iDataSource);
            stream.println("<table>");
            stream.println("<name>" + obj.getName() + "</name>");
            stream.println("</table>");
        }
        stream.println("</targets>");
    }

    @Override
    public ICodeSegment getSourceTargetComment(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        IDataObject[] sourceList = this.getDataSources();
        IDataObject[] targetList = this.getDataTargets();
        if (sourceList.length > 0 || targetList.length > 0) {
            codeSegment.genCommentLine(BLANK, BLANK, BLANK);
            codeSegment.genCommentTableLine(sourceList, codeSegment.getCommentLabelForSource(), codeSegment.getCommentLabelForSources());
            codeSegment.genCommentTableLine(targetList, codeSegment.getCommentLabelForTarget(), codeSegment.getCommentLabelForTargets());
        }
        return codeSegment;
    }

    public IColumn[] getOrdinaryUnmappedSourceColumns(List excludeColumns) {
        ArrayList<IColumn> unmappedColumns = new ArrayList<IColumn>();
        IDataObject[] sources = this.getDataSources();
        int size = sources.length;
        for (int i = 0; i < size; ++i) {
            if (!(sources[i] instanceof ITable)) continue;
            ITable source = (ITable)sources[i];
            for (IColumn col : source.getColumns()) {
                IMapping[] mapping = this.getOrdinaryMappingsForSourceColumn(col);
                if (mapping == null || mapping.length <= 0 || unmappedColumns.contains(col) || excludeColumns != null && excludeColumns.contains(col)) continue;
                unmappedColumns.add(col);
            }
        }
        return unmappedColumns.toArray(new IColumn[unmappedColumns.size()]);
    }

    public IColumn[] getOrdinaryMappedSourceColumns(List excludeColumns) {
        ArrayList<IColumn> mappedColumns = new ArrayList<IColumn>();
        IDataObject[] sources = this.getDataSources();
        int size = sources.length;
        for (int i = 0; i < size; ++i) {
            if (!(sources[i] instanceof ITable)) continue;
            ITable source = (ITable)sources[i];
            for (IColumn col : source.getColumns()) {
                IMapping[] mapping = this.getOrdinaryMappingsForSourceColumn(col);
                if (mapping == null || mapping.length <= 0 || mappedColumns.contains(col) || excludeColumns != null && excludeColumns.contains(col)) continue;
                mappedColumns.add(col);
            }
        }
        return mappedColumns.toArray(new IColumn[mappedColumns.size()]);
    }

    public IColumn[] getOrdinaryUnmappedTargetColumns(List excludeColumns) {
        ArrayList<IColumn> unmappedColumns = new ArrayList<IColumn>();
        IDataObject[] targets = this.getDataTargets();
        int size = targets.length;
        for (int i = 0; i < size; ++i) {
            if (!(targets[i] instanceof ITable)) continue;
            ITable target = (ITable)targets[i];
            for (IColumn col : target.getColumns()) {
                IMapping mapping = this.getOrdinaryMappingsForTargetColumn(col);
                if (mapping != null || unmappedColumns.contains(col) || excludeColumns != null && excludeColumns.contains(col)) continue;
                unmappedColumns.add(col);
            }
        }
        return unmappedColumns.toArray(new IColumn[unmappedColumns.size()]);
    }

    public IColumn[] getOrdinaryMappedTargetColumns(List excludeColumns) {
        ArrayList<IColumn> mappedColumns = new ArrayList<IColumn>();
        IDataObject[] targets = this.getDataTargets();
        int size = targets.length;
        for (int i = 0; i < size; ++i) {
            if (!(targets[i] instanceof ITable)) continue;
            ITable target = (ITable)targets[i];
            for (IColumn col : target.getColumns()) {
                IMapping mapping = this.getOrdinaryMappingsForTargetColumn(col);
                if (mapping == null || mappedColumns.contains(col) || excludeColumns != null && excludeColumns.contains(col)) continue;
                mappedColumns.add(col);
            }
        }
        return mappedColumns.toArray(new IColumn[mappedColumns.size()]);
    }

    public ICodeSegment getOrdinaryMappingCode(ICodeSegment codeSegment, IPhysicalTable sourceTable, IPhysicalTable targetTable, String mappingTargetTableName, String inputTableName) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        return this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingTargetTableName, inputTableName, this.getTableOptionObject(sourceTable, true).getTableOptions(codeSegment.getCurrentServer()), this.getTableOptionObject(targetTable, false).getTableOptions(codeSegment.getCurrentServer()), true, true, true, null, null, false, null, null, null);
    }

    public ICodeSegment getOrdinaryMappingCode(ICodeSegment codeSegment, IPhysicalTable sourceTable, IPhysicalTable targetTable, String mappingTargetTableName, String inputTableName, String sourceTableOptions, String targetTableOptions, boolean createView, boolean genComments, boolean genLabelStatements) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        return this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingTargetTableName, inputTableName, sourceTableOptions, targetTableOptions, createView, genComments, genLabelStatements, null, null, false, null, null, null);
    }

    public ICodeSegment getOrdinaryMappingCode(ICodeSegment codeSegment, ITable sourceTable, ITable targetTable, String mappingTargetTableName, String inputTableName, String sourceTableOptions, String targetTableOptions, boolean createView, boolean genComments, boolean genLabelStatements, IColumn[] passedOnlyColumns, IColumn[] excludeColumns, boolean useDistinctKeyword, String whereClause, IGroupBy groupByClause, ISorting orderByClause) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        return this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingTargetTableName, inputTableName, sourceTableOptions, targetTableOptions, createView, genComments, genLabelStatements, passedOnlyColumns, excludeColumns, useDistinctKeyword, whereClause, groupByClause, orderByClause, true, true);
    }

    public ICodeSegment getOrdinaryMappingCode(ICodeSegment codeSegment, ITable sourceTable, ITable targetTable, String mappingTargetTableName, String inputTableName, String sourceTableOptions, String targetTableOptions, boolean createView, boolean genComments, boolean genLabelStatements, IColumn[] passedOnlyColumns, IColumn[] excludeColumns, boolean useDistinctKeyword, String whereClause, IGroupBy groupByClause, ISorting orderByClause, boolean bGenExcludedColumnStatement, boolean bGenUnMappedColumnStatement) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        return this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingTargetTableName, inputTableName, sourceTableOptions, targetTableOptions, createView, genComments, genLabelStatements, passedOnlyColumns, excludeColumns, useDistinctKeyword, whereClause, groupByClause, orderByClause, bGenExcludedColumnStatement, bGenUnMappedColumnStatement, false);
    }

    protected IPhysicalTable[] getValidateTables() {
        ArrayList<ITable> tables = new ArrayList<ITable>();
        ITable[] sources = this.getSourceTables();
        for (int i = 0; i < sources.length; ++i) {
            if (!(sources[i] instanceof IPhysicalTable)) continue;
            tables.add(sources[i]);
        }
        return tables.toArray(new IPhysicalTable[tables.size()]);
    }

    private final String getValidateMacroName(IPhysicalTable table) {
        String tableId = table.getID().replaceAll("\\.", BLANK);
        return "etls_" + tableId.replaceAll("\\$", "_");
    }

    @Override
    protected ICodeSegment getPreValidateCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        codeSegment.genDebugOptionCode();
        IPhysicalTable[] tables = this.getValidateTables();
        if (tables.length > 0) {
            codeSegment.addSourceCode("%macro etls_createValidateTables;\n").indent();
        }
        for (int i = 0; i < tables.length; ++i) {
            IPhysicalTable table = tables[i];
            table.genAccessPath(codeSegment, false, 0, null);
            String macro = this.getValidateMacroName(table);
            codeSegment.addSourceCode("%global " + macro + ";\n");
            table.genTableExist(codeSegment, macro);
            table.getDBMSType().create(codeSegment, table, true, true, true, false, BLANK, this, macro);
        }
        if (tables.length > 0) {
            codeSegment.unIndent();
            codeSegment.addSourceCode("%mend etls_createValidateTables;\n");
            codeSegment.addSourceCode("%etls_createValidateTables;\n\n");
        }
        return codeSegment;
    }

    @Override
    protected ICodeSegment getPostValidateCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPhysicalTable[] tables = this.getValidateTables();
        if (tables.length > 0) {
            codeSegment.addSourceCode("%macro etls_deleteValidateTables;\n").indent();
        }
        for (int i = 0; i < tables.length; ++i) {
            IPhysicalTable table = tables[i];
            String macro = this.getValidateMacroName(table);
            codeSegment.addSourceCode("%if (&").addSourceCode(macro).addSourceCode(" eq 0) %then\n").addSourceCode("%do;\n").indent();
            table.genTableDelete(codeSegment);
            codeSegment.unIndent().addSourceCode("%end;\n");
        }
        if (tables.length > 0) {
            codeSegment.unIndent();
            codeSegment.addSourceCode("%mend etls_deleteValidateTables;\n");
            codeSegment.addSourceCode("%etls_deleteValidateTables;\n\n");
        }
        codeSegment.addSourceCode("%macro etls_pushdownMsg;\n");
        codeSegment.addSourceCode("%put ; %put ;\n");
        codeSegment.addSourceCode("%if (%symexist(").addSourceCode("etls_sql_pushDown").addSourceCode(")) %then\n");
        codeSegment.addSourceCode("%do;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("%if (&").addSourceCode("etls_sql_pushDown").addSourceCode(" eq 0) %then\n");
        codeSegment.indent().genPercentPutStatement("Transformation, " + this.getName() + ", will process on database.", "NOTE:").unIndent();
        codeSegment.addSourceCode("%else\n");
        codeSegment.indent().genPercentPutStatement("Transformation, " + this.getName() + ", will not process on database.", "NOTE:").unIndent();
        codeSegment.unIndent();
        codeSegment.addSourceCode("%end;\n");
        codeSegment.addSourceCode("%else\n");
        codeSegment.indent().genPercentPutStatement("Transformation, " + this.getName() + ", will not process on database.", "NOTE:").unIndent();
        codeSegment.addSourceCode("%put ; %put ;\n");
        codeSegment.addSourceCode("%mend;\n");
        codeSegment.addSourceCode("%etls_pushdownMsg;\n\n");
        return codeSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeSegment getOrdinaryMappingCode(ICodeSegment codeSegment, ITable sourceTable, ITable targetTable, String mappingTargetTableName, String inputTableName, String sourceTableOptions, String targetTableOptions, boolean createView, boolean genComments, boolean genLabelStatements, IColumn[] passedOnlyColumns, IColumn[] excludeColumns, boolean useDistinctKeyword, String whereClause, IGroupBy groupByClause, ISorting orderByClause, boolean bGenExcludedColumnStatement, boolean bGenUnMappedColumnStatement, boolean bIsValidate) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        StringBuffer code;
        IColumn targetColumn;
        int i;
        boolean bGenerateFormatsInformats = true;
        bGenerateFormatsInformats = this.isFormatGenerationEnabled();
        if (genComments) {
            codeSegment.addSectionComment(RB.getStringResource("AbstractDataTransform.MapColumns.msg.notrans"));
        }
        if (!mappingTargetTableName.equalsIgnoreCase(inputTableName)) {
            IDBMSType dbmsType = DBMSTypeFactory.getDefaultType();
            if (targetTable != null && targetTable instanceof IPhysicalTable) {
                dbmsType = ((IPhysicalTable)targetTable).getDBMSType();
            }
            boolean bSameTable = ObjectComparator.isEqual(sourceTable, targetTable);
            if (!bIsValidate && !bSameTable) {
                if (!"work".equalsIgnoreCase(DBMSNamesUtil.getLibrefPart(mappingTargetTableName))) {
                    dbmsType.genTableDelete(codeSegment, false, mappingTargetTableName, targetTableOptions != null ? codeSegment.parsePasswordOption(targetTableOptions, ICodeSegment.ALTER_PASSWORD_PATTERN) : BLANK);
                } else {
                    codeSegment.genTableDelete(mappingTargetTableName, targetTableOptions != null ? codeSegment.parsePasswordOption(targetTableOptions, ICodeSegment.ALTER_PASSWORD_PATTERN) : BLANK);
                }
            }
        }
        ArrayList<IColumn> lstPassedOnlyColumns = passedOnlyColumns != null ? new ArrayList<IColumn>(Arrays.asList(passedOnlyColumns)) : new ArrayList();
        ArrayList<IColumn> lstExcludeColumns = excludeColumns != null ? new ArrayList<IColumn>(Arrays.asList(excludeColumns)) : new ArrayList();
        IColumn[] targetColumns = targetTable.getColumns();
        for (int i2 = 0; i2 < targetColumns.length; ++i2) {
            IMapping mapping;
            IColumn targetColumn2 = targetColumns[i2];
            if (lstExcludeColumns.contains(targetColumn2) || lstPassedOnlyColumns.contains(targetColumn2) || (mapping = this.getOrdinaryMappingsForTargetColumn(targetColumn2)) == null) continue;
            this.generateMappingWarnings(codeSegment, new IMapping[]{mapping});
        }
        ArrayList<IColumn> ignoreUnmappedColumns = new ArrayList<IColumn>(lstPassedOnlyColumns);
        ignoreUnmappedColumns.addAll(lstExcludeColumns);
        IColumn[] unmappedColumns = this.getOrdinaryUnmappedTargetColumns(ignoreUnmappedColumns);
        if (bGenUnMappedColumnStatement && unmappedColumns != null && unmappedColumns.length > 0) {
            codeSegment.addSourceCode("data _null_;\n").indent().genPutStatement(MessageFormat.format(RB.getStringResource("AbstractDataTransform.UnmappedSetMissing.comment.notrans"), codeSegment.makeColumnList(Arrays.asList(unmappedColumns), "   ", false, ","))).unIndent().addSourceCode("run;\n\n");
        }
        if (bGenExcludedColumnStatement && lstExcludeColumns != null && lstExcludeColumns.size() > 0) {
            codeSegment.addSourceCode("data _null_;\n").indent().genPutStatement(MessageFormat.format(RB.getStringResource("AbstractDataTransform.UnmappedExcluded.comment.notrans"), codeSegment.makeColumnList(lstExcludeColumns, "   ", false, ","))).unIndent().addSourceCode("run;\n\n");
        }
        if (genComments) {
            codeSegment.genPercentPutStatement(RB.getStringResource("AbstractDataTransform.MappingColumnsNote.msg.sasmacro.notrans"));
        }
        codeSegment.addSourceCode("proc sql");
        if (bIsValidate) {
            codeSegment.addSourceCode(" noexec");
        }
        codeSegment.addSourceCode(";\n").indent().addSourceCode("create");
        if (createView) {
            codeSegment.addSourceCode(" view ");
        } else {
            codeSegment.addSourceCode(" table ");
        }
        if (mappingTargetTableName == null || mappingTargetTableName.length() == 0) {
            mappingTargetTableName = "work.mapped";
        } else if (!(mappingTargetTableName.indexOf(46) != -1 || targetTable != null && targetTable.isWebStreamDataTarget())) {
            mappingTargetTableName = "work." + mappingTargetTableName;
        }
        codeSegment.addSourceCode(mappingTargetTableName);
        if (targetTableOptions != null && targetTableOptions.length() > 0) {
            codeSegment.addSourceCode("\n").indent().addSourceCode("(").addSourceCode(targetTableOptions).addSourceCode(")").unIndent().addSourceCode("\n");
        }
        codeSegment.addSourceCode(" as\n").indent().addSourceCode("select");
        if (useDistinctKeyword) {
            codeSegment.addSourceCode(" distinct");
        }
        codeSegment.addSourceCode("\n").indent();
        String commaNewLine = BLANK;
        for (i = 0; i < targetColumns.length; ++i) {
            targetColumn = targetColumns[i];
            if (lstExcludeColumns.contains(targetColumn)) continue;
            if (!lstPassedOnlyColumns.contains(targetColumn)) {
                IMapping mapping = this.getOrdinaryMappingsForTargetColumn(targetColumn);
                if (mapping != null) {
                    if ("DERIVED".equals(mapping.getType()) && mapping.getExpression() != null) {
                        IExpression exp = mapping.getExpression();
                        String expression = exp.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), false);
                        expression = expression.replaceAll("\\n", "\n   ");
                        codeSegment.addSourceCode(commaNewLine);
                        codeSegment.addSourceCode("(").addSourceCode(expression.trim()).addSourceCode(")");
                        codeSegment.addSourceCode(" as ");
                        codeSegment.addSourceCode(targetColumn.getAttribStatement(codeSegment.isQuoting(), false, bGenerateFormatsInformats, genLabelStatements));
                        commaNewLine = ",\n";
                        continue;
                    }
                    if ("ONETOONE".equals(mapping.getType())) {
                        IColumn sourceColumn = mapping.findSourceTableColumnInMapping(sourceTable);
                        if (sourceColumn == null) continue;
                        codeSegment.addSourceCode(commaNewLine);
                        if (!targetColumn.equalsName(sourceColumn, codeSegment.isQuoting())) {
                            codeSegment.addSourceCode(sourceColumn.getColumnName(codeSegment.isQuoting()));
                            codeSegment.addSourceCode(" as ");
                        }
                        codeSegment.addSourceCode(targetColumn.getColumnName(codeSegment.isQuoting()));
                        if (targetColumn.getType() != sourceColumn.getType() || targetColumn.getLength() != sourceColumn.getLength()) {
                            codeSegment.addSourceCode(" ").addSourceCode(targetColumn.getLengthStatement(false));
                        }
                        codeSegment.indent();
                        if (bGenerateFormatsInformats) {
                            if (!targetColumn.equalsFormat(sourceColumn) && !BLANK.equals(targetColumn.getFormat())) {
                                codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getFormatStatement());
                            }
                            if (!targetColumn.equalsInformat(sourceColumn) && !BLANK.equals(targetColumn.getInformat())) {
                                codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getInformatStatement());
                            }
                        }
                        if (genLabelStatements && !BLANK.equals(targetColumn.getDescription()) && !targetColumn.equalsLabel(sourceColumn)) {
                            codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getLabelStatement());
                        }
                        codeSegment.unIndent();
                        commaNewLine = ",\n";
                        continue;
                    }
                    codeSegment.addSourceCode(commaNewLine);
                    if (targetColumn.getType() == 0) {
                        codeSegment.addSourceCode("\"\"");
                    } else {
                        codeSegment.addSourceCode(".");
                    }
                    codeSegment.addSourceCode(" as ");
                    codeSegment.addSourceCode(targetColumn.getAttribStatement(codeSegment.isQuoting(), false, bGenerateFormatsInformats, genLabelStatements));
                    commaNewLine = ",\n";
                    continue;
                }
                codeSegment.addSourceCode(commaNewLine);
                if (targetColumn.getType() == 0) {
                    codeSegment.addSourceCode("\"\"");
                } else {
                    codeSegment.addSourceCode(".");
                }
                codeSegment.addSourceCode(" as ");
                codeSegment.addSourceCode(targetColumn.getAttribStatement(codeSegment.isQuoting(), false, bGenerateFormatsInformats, genLabelStatements));
                commaNewLine = ",\n";
                continue;
            }
            codeSegment.addSourceCode(commaNewLine);
            codeSegment.addSourceCode(targetColumn.getColumnName(codeSegment.isQuoting()));
            commaNewLine = ",\n";
            lstPassedOnlyColumns.remove(targetColumn);
        }
        for (i = 0; i < lstPassedOnlyColumns.size(); ++i) {
            targetColumn = (IColumn)lstPassedOnlyColumns.get(i);
            codeSegment.addSourceCode(commaNewLine);
            codeSegment.addSourceCode(targetColumn.getColumnName(codeSegment.isQuoting()));
            commaNewLine = ",\n";
        }
        codeSegment.addSourceCode("\n");
        if (inputTableName == null || inputTableName.length() == 0) {
            inputTableName = sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        }
        codeSegment.unIndent().unIndent().addSourceCode("from ").addSourceCode(inputTableName).addSourceCode("\n");
        if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
            codeSegment.indent().addSourceCode("(").addSourceCode(sourceTableOptions).addSourceCode(")").unIndent().addSourceCode("\n");
        }
        if (whereClause != null && whereClause.length() > 0) {
            whereClause = whereClause.replaceAll("\n", "\n   ");
            codeSegment.indent().addSourceCode(whereClause.trim()).unIndent().addSourceCode("\n");
        }
        if (groupByClause != null && (code = groupByClause.getCode(codeSegment.isQuoting(), false)) != null && code.length() > 0) {
            codeSegment.addSourceCode(code);
        }
        if (orderByClause != null) {
            int iOldType = orderByClause.getSyntaxType();
            orderByClause.setSyntaxType(2);
            try {
                StringBuffer code2 = orderByClause.getCode(codeSegment.isQuoting(), false);
                if (code2 != null && code2.length() > 0) {
                    codeSegment.addSourceCode(code2);
                }
            }
            finally {
                orderByClause.setSyntaxType(iOldType);
            }
        }
        codeSegment.addSourceCode(";\n").unIndent().addSourceCode("quit;\n\n");
        codeSegment.addSourceCode("%let SYSLAST = ").addSourceCode(mappingTargetTableName).addSourceCode(";\n\n");
        return codeSegment;
    }

    protected void generateMappingWarnings(ICodeSegment codeSegment, IMapping[] mappings) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        if (mappings != null) {
            for (int i = 0; i < mappings.length; ++i) {
                String warning = mappings[i].getWarning();
                if (warning == null || warning.length() <= 0) continue;
                codeSegment.addSourceCode("data _null_;\n").indent();
                codeSegment.genPutStatement(warning, this.getJob().isGenerateWarningOnMapping() ? "WARNING%QUOTE(:)" : "NOTE:").unIndent();
                codeSegment.addSourceCode("run;\n\n");
                break;
            }
        }
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validateCode);
        this.setConnectUsingFlagOnTables();
        String dbiExec = this.getDBIDirectExecValue();
        if (dbiExec != null && dbiExec.length() > 0) {
            if (DBI_DIRECT_EXEC.equals(dbiExec)) {
                codeSegment.addSourceCode("%global ").addSourceCode("etls_sql_pushDown").addSourceCode(";\n");
                codeSegment.addSourceCode("%let ").addSourceCode("etls_sql_pushDown").addSourceCode(" = -1;\n");
            }
            codeSegment.addSourceCode("option ").addSourceCode(dbiExec).addSourceCode(";\n\n");
        }
        return codeSegment;
    }

    @Override
    public final ICodeSegment getTransformSetup(ICodeSegment codeSegment, boolean isRemote, boolean isValidate) throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        int i;
        ITable[] targetTables;
        this.getValidVarNameCode(codeSegment, isRemote);
        if (!isValidate) {
            this.getGeneratedLibnameCodeForSources(codeSegment);
            this.getGeneratedLibnameCodeForTargets(codeSegment);
        }
        if (codeSegment.isRunTableStatisticsEnabled() && this.isCollectSourceTableRowCounts()) {
            this.getGeneratedSourceRowCountCode(codeSegment);
        }
        if (this.isGenDefaultJobStatusUpdate() && this.getJob().isSendJobStatusEnabled() && (targetTables = this.getTargetTables()) != null) {
            for (i = 0; i < targetTables.length; ++i) {
                ITable table = targetTables[i];
                if (!table.getMetadataType().equalsIgnoreCase("PhysicalTable")) continue;
                codeSegment.genJobStatusUpdateBefore((IPhysicalTable)table);
                break;
            }
        }
        this.getSyslastCode(codeSegment);
        super.getTransformSetup(codeSegment, isRemote, isValidate);
        if (this.isUsingUserWrittenCode()) {
            IDataObject[] sources = this.getDataSources();
            codeSegment.addSourceCode("%let _INPUT_count = " + sources.length + ";\n");
            for (i = 0; i < sources.length; ++i) {
                IDataObject source = sources[i];
                if (source instanceof IPhysicalTable) {
                    if (i == 0) {
                        codeSegment.addSourceCode(PromptUtils.getTablePercentLetStatements(codeSegment, "_INPUT", (IPhysicalTable)source, false, this.getTableOptionObject((IPhysicalTable)source, true), null, false, this.isColMacroVarsEnabled()));
                        codeSegment.addSourceCode("%let _INPUT_filetype = ").addSourceCode(source.getMetadataType()).addSourceCode(";\n\n");
                    }
                    codeSegment.addSourceCode(PromptUtils.getTablePercentLetStatements(codeSegment, "_INPUT" + (i + 1), (IPhysicalTable)source, false, this.getTableOptionObject((IPhysicalTable)source, true), null, false, this.isColMacroVarsEnabled()));
                    codeSegment.addSourceCode("%let _INPUT" + (i + 1) + "_filetype = ").addSourceCode(source.getMetadataType()).addSourceCode(";\n\n");
                    continue;
                }
                if (!(source instanceof IExternalTable) || !this.isFileMacroVarsEnabled()) continue;
                if (!(this instanceof FileReaderTransformModel) && !(this instanceof FileWriterTransformModel)) {
                    codeSegment.addSourceCode(source.getDefaultParameterCode().toString());
                }
                if (i == 0) {
                    codeSegment.addSourceCode("%let _INPUT = ").addSourceCode(((IExternalTable)source).getFullName()).addSourceCode(";\n");
                    codeSegment.addSourceCode("%let _INPUT_filetype = ").addSourceCode(source.getMetadataType()).addSourceCode(";\n\n");
                }
                codeSegment.addSourceCode("%let _INPUT" + (i + 1) + " = ").addSourceCode(((IExternalTable)source).getFullName()).addSourceCode(";\n");
                codeSegment.addSourceCode("%let _INPUT" + (i + 1) + "_filetype = ").addSourceCode(source.getMetadataType()).addSourceCode(";\n\n");
            }
            IDataObject[] targets = this.getDataTargets();
            codeSegment.addSourceCode("%let _OUTPUT_count = " + targets.length + ";\n");
            for (int i2 = 0; i2 < targets.length; ++i2) {
                IDataObject target = targets[i2];
                if (target instanceof IPhysicalTable) {
                    if (i2 == 0) {
                        codeSegment.addSourceCode(PromptUtils.getTablePercentLetStatements(codeSegment, "_OUTPUT", (IPhysicalTable)target, true, this.getTableOptionObject((IPhysicalTable)target, false), this.getOrdinaryMappingsForTargetTable((IPhysicalTable)target), true, this.isColMacroVarsEnabled()));
                        codeSegment.addSourceCode("%let _OUTPUT_filetype = ").addSourceCode(target.getMetadataType()).addSourceCode(";\n\n");
                    }
                    codeSegment.addSourceCode(PromptUtils.getTablePercentLetStatements(codeSegment, "_OUTPUT" + (i2 + 1), (IPhysicalTable)target, true, this.getTableOptionObject((IPhysicalTable)target, false), this.getOrdinaryMappingsForTargetTable((IPhysicalTable)target), true, this.isColMacroVarsEnabled()));
                    codeSegment.addSourceCode("%let _OUTPUT" + (i2 + 1) + "_filetype = ").addSourceCode(target.getMetadataType()).addSourceCode(";\n\n");
                    continue;
                }
                if (!(target instanceof IExternalTable) || !this.isFileMacroVarsEnabled()) continue;
                if (!(this instanceof FileReaderTransformModel) && !(this instanceof FileWriterTransformModel)) {
                    codeSegment.addSourceCode(target.getDefaultParameterCode().toString());
                }
                if (i2 == 0) {
                    codeSegment.addSourceCode("%let _OUTPUT = ").addSourceCode(((IExternalTable)target).getFullName()).addSourceCode(";\n");
                    codeSegment.addSourceCode("%let _OUTPUT_filetype = ").addSourceCode(target.getMetadataType()).addSourceCode(";\n\n");
                }
                codeSegment.addSourceCode("%let _OUTPUT" + (i2 + 1) + " = ").addSourceCode(((IExternalTable)target).getFullName()).addSourceCode(";\n");
                codeSegment.addSourceCode("%let _OUTPUT" + (i2 + 1) + "_filetype = ").addSourceCode(target.getMetadataType()).addSourceCode(";\n\n");
            }
        }
        return codeSegment;
    }

    public IMapping[] getOrdinaryMappingsForTargetTable(ITable target) {
        ArrayList<IMapping> maps = new ArrayList<IMapping>();
        IColumn[] columns = target.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            IMapping map = this.getOrdinaryMappingsForTargetColumn(columns[i]);
            if (map == null) continue;
            maps.add(map);
        }
        return maps.toArray(new IMapping[maps.size()]);
    }

    @Override
    public ICodeSegment getPreDiagnostics(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        super.getPreDiagnostics(codeSegment);
        IDataObject[] sources = this.getDataSources();
        for (int i = 0; i < sources.length; ++i) {
            if (!(sources[i] instanceof IPhysicalTable)) continue;
            codeSegment.genDiagnosticTableExists((IPhysicalTable)sources[i]);
        }
        return codeSegment;
    }

    public final boolean isTableSource(IPhysicalTable table) {
        IDataObject[] sources = this.getDataSources();
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i] != table) continue;
            return true;
        }
        return false;
    }

    public final ICodeSegment genTableDelete(ICodeSegment codeSegment, List tables) throws CodegenException, BadLibraryDefinitionException {
        ArrayList<IDataObject> deleteTables = new ArrayList<IDataObject>();
        for (int i = 0; i < tables.size(); ++i) {
            IDataObject table = (IDataObject)tables.get(i);
            if (!(table instanceof IPhysicalTable) || this.isTableSource((IPhysicalTable)table)) continue;
            deleteTables.add(table);
        }
        codeSegment.genTableDelete(deleteTables);
        return codeSegment;
    }

    public final ICodeSegment genTableDelete(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (!this.isTableSource(table)) {
            codeSegment.genTableDelete(table);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getBodyCode(ICodeGenerationEnvironment environment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.updateQuotingSetting(environment);
        return super.getBodyCode(environment);
    }

    public final void updateQuotingSetting(ICodeGenerationEnvironment environment) {
        if (!environment.isQuoting()) {
            if (this.isQuotingNeeded()) {
                environment.setQuoting(true);
            } else {
                List lTransforms = this.getJob().getControlOrderedTransformsList();
                for (int iTransform = lTransforms.indexOf(this) - 1; iTransform >= 0; --iTransform) {
                    IDataTransform dt;
                    Object obj = lTransforms.get(iTransform);
                    if (!(obj instanceof IDataTransform) || !(dt = (IDataTransform)obj).isQuotingNeeded()) continue;
                    environment.setQuoting(true);
                    break;
                }
            }
        }
    }

    @Override
    public final ICodeSegment getValidVarNameCode(ICodeSegment codeSegment, boolean isRemote) {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        this.updateQuotingSetting(environment);
        if (!environment.isSpecialCharactersNeeded()) {
            if (this.isSpecialCharactersNeeded()) {
                codeSegment.genValidvarnameOptionAny(isRemote);
                environment.setSpecialCharactersNeeded(true);
            } else {
                List lTransforms = this.getJob().getControlOrderedTransformsList();
                for (int iTransform = lTransforms.indexOf(this) - 1; iTransform >= 0; --iTransform) {
                    IDataTransform dt;
                    Object obj = lTransforms.get(iTransform);
                    if (!(obj instanceof IDataTransform) || !(dt = (IDataTransform)obj).isSpecialCharactersNeeded()) continue;
                    codeSegment.genValidvarnameOptionAny(isRemote);
                    environment.setSpecialCharactersNeeded(true);
                    break;
                }
            }
        }
        return codeSegment;
    }

    public final ICodeSegment getSyslastCode(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        IPhysicalTable prevTable = this.getPreviousSyslastTable();
        if (prevTable != null) {
            codeSegment.genSyslast(prevTable);
        }
        return codeSegment;
    }

    private IPhysicalTable getPreviousSyslastTable() {
        IDataTransform transform = this.getSyslastDataTransform(this);
        Object sources = this.getDataSources();
        if (transform != null) {
            sources = this.isPreviousSyslastEnabled(transform) ? transform.getDataSources() : null;
        }
        if (sources != null && ((IDataObject[])sources).length == 1 && sources[0] instanceof IPhysicalTable) {
            return (IPhysicalTable)sources[0];
        }
        return null;
    }

    private boolean isPreviousSyslastEnabled(IDataTransform transform) {
        IDataObject[] sources = transform.getDataSources();
        if (sources.length == 1 && sources[0] instanceof IPhysicalTable) {
            IPhysicalTable pt = (IPhysicalTable)sources[0];
            IDataTransform[] producers = pt.getProducerTransforms();
            if (producers != null && producers.length > 0) {
                for (int i = 0; i < producers.length; ++i) {
                    boolean isEnabled = producers[i].isSYSLASTVariableGenerationEnabled();
                    if (!isEnabled) continue;
                    return true;
                }
            } else if (producers == null || producers.length == 0) {
                return true;
            }
        }
        return false;
    }

    private IDataTransform getSyslastDataTransform(IDataTransform transform) {
        IDataObject[] sources = transform.getDataSources();
        if (sources.length == 1 && sources[0] instanceof IPhysicalTable) {
            IPhysicalTable pt = (IPhysicalTable)sources[0];
            IDataTransform[] producers = pt.getProducerTransforms();
            IDataTransform producer = null;
            if (producers != null && producers.length > 0) {
                producer = producers[0];
                if (!producer.isCodeGenerationEnabled()) {
                    IDataTransform prevTransform = this.getSyslastDataTransform(producer);
                    if (prevTransform == null) {
                        return producer;
                    }
                    if (prevTransform.isCodeGenerationEnabled()) {
                        return producer;
                    }
                    return this.getSyslastDataTransform(prevTransform);
                }
                return transform;
            }
        }
        return null;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForSources(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        IDataObject[] sources = this.getDataSources();
        for (int i = 0; i < sources.length; ++i) {
            if (!(sources[i] instanceof IPhysicalTable)) continue;
            IPhysicalTable table = (IPhysicalTable)sources[i];
            table.genAccessPath(codeSegment, codeSegment.getCodeGenerationEnvironment().isGenerateRCSetCalls(), -1, codeSegment.getRuntimeStatsConnectMacros(codeSegment), codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled(), this.getTableOptionObject(table, true));
        }
        return codeSegment;
    }

    @Override
    public final ICodeSegment getTransformCompletion(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        ITable[] targetTables;
        this.getGenerateTableIndexes(codeSegment);
        if (this.isGenDefaultJobStatusUpdate() && this.getJob().isSendJobStatusEnabled() && (targetTables = this.getTargetTables()) != null) {
            for (int i = 0; i < targetTables.length; ++i) {
                ITable table = targetTables[i];
                if (!table.getMetadataType().equalsIgnoreCase("PhysicalTable")) continue;
                codeSegment.genJobStatusUpdateAfter((IPhysicalTable)table);
                break;
            }
        }
        if (codeSegment.isRunTableStatisticsEnabled() && this.isCollectTargetTableRowCounts()) {
            this.getGeneratedTargetRowCountCode(codeSegment);
        }
        return super.getTransformCompletion(codeSegment);
    }

    public ICodeSegment getGenerateTableIndexes(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.isGenerateIndexesOnTargetTables()) {
            IDataObject[] targets = this.getDataTargets();
            IServer currentServer = codeSegment.getCurrentServer();
            ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
            for (int i = 0; i < targets.length; ++i) {
                ISASClientConnection conn;
                if (!(targets[i] instanceof IPhysicalTable) || ((IPhysicalTable)targets[i]).isView()) continue;
                IPhysicalTable pt = (IPhysicalTable)targets[i];
                boolean remote = false;
                ILibrary library = pt.getClientLibrary(codeSegment);
                IServer libServer = null;
                if (library != null) {
                    library.genAccessPath(codeSegment);
                    libServer = library.getBestServer(codeSegment.getCurrentServer());
                    boolean bl = remote = !ObjectComparator.isEqual(libServer, codeSegment.getCurrentServer());
                    if (remote) {
                        conn = libServer.getConnectClient();
                        if (conn == null) {
                            throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), libServer.getName()), (IObject)this);
                        }
                        if (!environment.isOnSignonCache(libServer)) {
                            conn.genAccessCode(codeSegment);
                            environment.addToSignonCache(libServer);
                        }
                        IJob job = this.getJob();
                        codeSegment.genReturnCodeRemoteSetup(conn, codeSegment.getRuntimeStatsConnectMacros(codeSegment), false, job.isRCSetSYSCCEnabled());
                        codeSegment.genRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), conn.getHostName(), true).addSourceCode("\n");
                        conn.genStartSubmit("sysrputsync = yes", codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
                        environment.setCurrentServer(libServer);
                        codeSegment.indent().addSourceCode("\n");
                        if (codeSegment.isQuoting()) {
                            codeSegment.genValidvarnameOptionAny(false);
                        }
                        codeSegment.addSourceCode("%macro ").addSourceCode("etls_transformationStep").addSourceCode("(); \n").indent();
                    }
                }
                pt.getDBMSType().createIndexes2(codeSegment, pt, null, BLANK);
                if (!remote) continue;
                conn = libServer.getConnectClient();
                codeSegment.genReturnCodeRemoteEnding(false, false, this.getJob().isRCSetSYSCCEnabled());
                codeSegment.unIndent();
                codeSegment.addSourceCode("\n%mend ").addSourceCode("etls_transformationStep").addSourceCode("; \n\n").addSourceCode("%").addSourceCode("etls_transformationStep").addSourceCode(";\n\n");
                codeSegment.unIndent();
                conn.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
                environment.setCurrentServer(currentServer);
            }
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForTargets(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        IDataObject[] targets = this.getDataTargets();
        for (int i = 0; i < targets.length; ++i) {
            if (!(targets[i] instanceof IPhysicalTable)) continue;
            IPhysicalTable table = (IPhysicalTable)targets[i];
            table.genAccessPath(codeSegment, codeSegment.getCodeGenerationEnvironment().isGenerateRCSetCalls(), -1, codeSegment.getRuntimeStatsConnectMacros(codeSegment), codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled(), this.getTableOptionObject(table, false));
        }
        return codeSegment;
    }

    public boolean isCollectSourceTableRowCounts() {
        return this.m_collectSourceTableRowCounts;
    }

    public void setCollectSourceTableRowCounts(boolean collectSourceTableRowCounts) {
        this.m_collectSourceTableRowCounts = collectSourceTableRowCounts;
    }

    public boolean isCollectTargetTableRowCounts() {
        return this.m_collectTargetTableRowCounts;
    }

    public void setCollectTargetTableRowCounts(boolean collectTargetTableRowCounts) {
        this.m_collectTargetTableRowCounts = collectTargetTableRowCounts;
    }

    public ICodeSegment getGeneratedSourceRowCountCode(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IDataObject[] sources = this.getDataSources();
        if (sources.length > 0 && sources[0] instanceof IPhysicalTable) {
            this.getGeneratedTableRowCountCode(codeSegment, (IPhysicalTable)sources[0], null);
        }
        return codeSegment;
    }

    public ICodeSegment getGeneratedTargetRowCountCode(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IDataObject[] targets = this.getDataTargets();
        if (targets.length > 0 && (targets[0] instanceof IPhysicalTable || targets[0] instanceof IWorkTable)) {
            this.getGeneratedTableRowCountCode(codeSegment, (IPhysicalTable)targets[0], null);
        }
        return codeSegment;
    }

    public ICodeSegment getGeneratedTableRowCountCode(ICodeSegment codeSegment, IPhysicalTable table, String macroVar) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return codeSegment.genRowsProcessedCount(table, macroVar);
    }

    @Override
    public IPhysicalTable[] getTablesForTransfer(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        ArrayList<IPhysicalTable> transfers = new ArrayList<IPhysicalTable>();
        IDataObject[] sources = this.getDataSources();
        for (int i = 0; i < sources.length; ++i) {
            IServer stepServer;
            IPhysicalTable table;
            if (sources[i] instanceof IWorkTable) {
                IWorkTable table2 = (IWorkTable)sources[i];
                IDataTransform[] tableProducers = table2.getProducerTransforms();
                IDataTransform tableProducer = null;
                if (tableProducers != null && tableProducers.length > 0) {
                    tableProducer = tableProducers[0];
                }
                if (tableProducer == null || tableProducer.isTargetDataAutomaticallyMoved()) continue;
                IServer stepServer2 = this.getServerForStep(defaultServer);
                IServer previousServer = tableProducer.getServerForStep(defaultServer);
                if (ObjectComparator.isEqual(previousServer, stepServer2)) continue;
                transfers.add(table2);
                continue;
            }
            if (!(sources[i] instanceof IPhysicalTable) || !(table = (IPhysicalTable)sources[i]).isRemoteToServer(stepServer = this.getServerForStep(defaultServer))) continue;
            transfers.add(table);
        }
        return transfers.toArray(new IPhysicalTable[transfers.size()]);
    }

    @Override
    public boolean isTransformPerformingDataTransfer(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        IPhysicalTable[] tables = this.getTablesForTransfer(defaultServer);
        return tables != null && tables.length > 0;
    }

    @Override
    public ICodeSegment getGeneratedRemoteCodeStart(IServer stepServer, ICodeSegment codeSegment, IServer currentServer, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
        IDataObject[] sources = this.getDataSources();
        for (int i = 0; i < sources.length; ++i) {
            ILibrary lib;
            IServer previousServer;
            if (!(sources[i] instanceof IWorkTable)) continue;
            IWorkTable table = (IWorkTable)sources[i];
            IDataTransform[] tableProducers = table.getProducerTransforms();
            IDataTransform tableProducer = null;
            if (tableProducers != null && tableProducers.length > 0) {
                tableProducer = tableProducers[0];
            }
            if (tableProducer == null || tableProducer.isTargetDataAutomaticallyMoved() || ObjectComparator.isEqual(previousServer = tableProducer.getServerForStep(currentServer), stepServer)) continue;
            ISASClientConnection conn = stepServer.getConnectClient();
            if (conn == null) {
                throw new CodegenException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), stepServer.getName()), (IObject)this);
            }
            if (conn == null) continue;
            codeSegment.addSectionComment(RB.getStringResource("Transfer.ImplicitComment.msg.txt"));
            if (!environment.isOnSignonCache(stepServer)) {
                if (table.isQuoted()) {
                    codeSegment.addSourceCode(CodeSegment.getValidvarnameOptionAny(false));
                }
                conn.genAccessCode(codeSegment);
                environment.addToSignonCache(stepServer);
            }
            IJob job = this.getJob();
            codeSegment.genReturnCodeRemoteSetup(conn, codeSegment.getRuntimeStatsConnectMacros(codeSegment), isValidate, job.isRCSetSYSCCEnabled());
            codeSegment.genRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), conn.getHostName(), true).addSourceCode("\n");
            conn.genStartSubmit("sysrputsync = yes", codeSegment, true, codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled());
            codeSegment.indent().addSourceCode("\n");
            codeSegment.addSourceCode("%macro ").addSourceCode("etls_transformationStep").addSourceCode("(); \n").indent();
            if (!isValidate) {
                table.genUploadCode(codeSegment, this.getTableOptionObject(table, true)).addSourceCode("\n").genRCSetCall("&syserr");
            }
            if ((lib = table.getCodeGenLibrary(stepServer)) != null) {
                codeSegment.addSourceCode("libname ").addSourceCode(lib.getLibref()).addSourceCode(" (").addSourceCode("work").addSourceCode("); \n");
                codeSegment.genRCSetCall("&syslibrc");
            }
            codeSegment.genReturnCodeRemoteEnding(isValidate, false, this.getJob().isRCSetSYSCCEnabled());
            codeSegment.unIndent();
            codeSegment.addSourceCode("\n%mend ").addSourceCode("etls_transformationStep").addSourceCode("; \n\n").addSourceCode("%").addSourceCode("etls_transformationStep").addSourceCode(";\n\n");
            codeSegment.unIndent();
            conn.genEndSubmit(codeSegment, this.getJob().isRCSetSYSCCEnabled());
        }
        return super.getGeneratedRemoteCodeStart(stepServer, codeSegment, currentServer, isValidate);
    }

    @Override
    public ICodeSegment getGeneratedRemoteCodeEnd(IServer stepServer, ICodeSegment codeSegment, IServer defaultServer, boolean isValidate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IDataObject[] targets = this.getDataTargets();
        for (int i = 0; i < targets.length; ++i) {
            if (!(targets[i] instanceof IWorkTable)) continue;
            IWorkTable table = (IWorkTable)targets[i];
            IDataTransform[] tableConsumers = table.getConsumerTransforms();
            for (int j = 0; j < tableConsumers.length; ++j) {
                if (ObjectComparator.isEqual(stepServer, tableConsumers[j].getServerForStep(defaultServer))) continue;
                codeSegment.addSectionComment(RB.getStringResource("Transfer.ImplicitComment.msg.txt"));
                table.genDownloadCode(codeSegment, this.getTableOptionObject(table, false)).addSourceCode("\n").genRCSetCall("&syserr");
            }
        }
        return super.getGeneratedRemoteCodeEnd(stepServer, codeSegment, defaultServer, isValidate);
    }

    public boolean isMappingNeeded(boolean quoting, IPhysicalTable sourceTable, IPhysicalTable targetTable) {
        return this.isMappingNeeded(quoting, sourceTable, targetTable, null, true);
    }

    public boolean isMappingNeeded(boolean quoting, ITable sourceTable, ITable targetTable, List ignoreColumns) {
        boolean needed = false;
        return this.isMappingNeeded(quoting, sourceTable, targetTable, null, true);
    }

    public boolean isMappingNeeded(boolean quoting, ITable sourceTable, ITable targetTable, List ignoreColumns, boolean columnCountsMustMatch) {
        boolean needed = false;
        if (columnCountsMustMatch && sourceTable.getColumnCount() != targetTable.getColumnCount()) {
            needed = true;
        } else {
            int targetSize = targetTable.getColumnCount();
            for (int i = 0; i < targetSize; ++i) {
                IMapping mapping;
                IColumn targetColumn = targetTable.getColumns()[i];
                if (ignoreColumns != null && ignoreColumns.contains(targetColumn) || (mapping = this.getOrdinaryMappingsForTargetColumn(targetColumn)) != null && !mapping.isMappingNeeded(quoting, sourceTable)) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    @Override
    public boolean isTargetDataAutomaticallyMoved() {
        return this.m_bTargetDataAutomaticallyMoved;
    }

    protected void setTargetDataAutomaticallyMoved(boolean bTargetDataMoved) {
        this.m_bTargetDataAutomaticallyMoved = bTargetDataMoved;
    }

    @Override
    public void updateDBMSExecutionType() {
        boolean bSameTypes = true;
        IDBMSType type = null;
        List lSources = this.getDataSourceList();
        for (int iSource = 0; iSource < lSources.size(); ++iSource) {
            if (!(lSources.get(iSource) instanceof IPhysicalTable)) continue;
            IPhysicalTable table = (IPhysicalTable)lSources.get(iSource);
            if (type == null) {
                type = table.getDBMSType();
            }
            if (type == table.getDBMSType()) continue;
            bSameTypes = false;
            break;
        }
        if (bSameTypes) {
            this.setDBMSExecutionType(type != null ? type.getDBMSTypeID() : 109);
            this.setDBMSExecutionTypeName(type != null ? type.getDBMSTypeName() : "SAS");
        } else {
            this.setDBMSExecutionType(109);
            this.setDBMSExecutionTypeName("SAS");
        }
        this.fireModelChangedEvent("DataTransform.RefreshDBMSType", null);
    }

    @Override
    public String getDBMSExecutionTypeName() {
        return this.m_sDBMSTypeName;
    }

    protected void setDBMSExecutionTypeName(String sDBMSTypeName) {
        this.m_sDBMSTypeName = sDBMSTypeName;
    }

    protected void setDBMSExecutionType(int iDBMSType) {
        if (this.m_iDBMSType == iDBMSType) {
            return;
        }
        this.m_iDBMSType = iDBMSType;
        this.fireModelChangedEvent("DataTransform.DBMSExecutionTypeChanged", null);
    }

    @Override
    public int getDBMSExecutionType() {
        return this.m_iDBMSType;
    }

    protected void postAddTransformTableOption(IDataObject table, boolean isSource) {
        if (table instanceof IPhysicalTable) {
            IPhysicalTable pt = (IPhysicalTable)table;
            this.addTransformTableOption(this.createTransformTableOption(pt, isSource));
            pt.getDBMSType().updateTransformTableOptions(this.getTableOptionObject(pt, isSource), isSource);
        }
    }

    protected void preRemoveTransformTableOptions(IDataObject table, boolean isSource) {
        ITransformTableOptions tableOptions;
        if (table instanceof IPhysicalTable && (tableOptions = this.getTableOptionObject((IPhysicalTable)table, isSource)) != null) {
            this.removeTransformTableOption(tableOptions);
        }
    }

    @Override
    public boolean hasTableOptionObject(IPhysicalTable table, boolean isSource) {
        return this.getTableOptionObject(table, isSource) != null;
    }

    @Override
    public ITransformTableOptions getTableOptionObject(IPhysicalTable table, boolean isSource) {
        return this.getTableOptionObject(table, isSource, this.getTableOptionObjects());
    }

    protected ITransformTableOptions getTableOptionObject(IPhysicalTable table, boolean isSource, ITransformTableOptions[] opts) {
        for (int i = 0; i < opts.length; ++i) {
            if (opts[i].getOptionTable() != table || opts[i].isAccessTypeInput() != isSource) continue;
            return opts[i];
        }
        return null;
    }

    protected void addTransformTableOption(ITransformTableOptions optionSet) {
        ITransformTableOptions lddOpts;
        if (this.m_lTableOptionModels.contains(optionSet)) {
            return;
        }
        if (optionSet != null) {
            this.removeFromDeletedObjects(optionSet);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddTransformTableOptionUndoable(optionSet));
        }
        if ((lddOpts = this.getTableOptionObject(optionSet.getOptionTable(), optionSet.isAccessTypeInput())) != null) {
            this.removeTransformTableOption(lddOpts);
        }
        this.m_lTableOptionModels.add(optionSet);
        this.fireModelChangedEvent("DataTransform.TransformTableOptionAddded", optionSet);
    }

    protected void removeTransformTableOption(ITransformTableOptions optionSet) {
        if (!this.m_lTableOptionModels.contains(optionSet)) {
            return;
        }
        if (optionSet != null) {
            this.addToDeletedObjects(optionSet);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveTransformTableOptionUndoable(optionSet));
        }
        this.m_lTableOptionModels.remove(optionSet);
        this.fireModelChangedEvent("DataTransform.TransformTableOptionRemoved", optionSet);
    }

    protected ITransformTableOptions createTransformTableOption(IPhysicalTable table, boolean isSource) {
        BaseTransformTableOptions optionSet = new BaseTransformTableOptions(this.createIDForNewObject(), this.getModel());
        optionSet.setOptionTable(table);
        optionSet.setAccessTypeInput(isSource);
        optionSet.setOwner(this);
        return optionSet;
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        return this.m_lTableOptionModels.toArray(new ITransformTableOptions[this.m_lTableOptionModels.size()]);
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        IServer serverStep = null;
        IDataObject[] targets = this.getDataTargets();
        for (int i = 0; i < targets.length; ++i) {
            IPhysicalTable target;
            ILibrary library;
            if (!(targets[i] instanceof IPhysicalTable) || (library = (target = (IPhysicalTable)targets[i]).getCodeGenLibrary(defaultServer)) == null) continue;
            serverStep = library.getBestServer(defaultServer);
        }
        if (serverStep == null) {
            IServer requestedServer = this.getExecutionServer();
            serverStep = requestedServer != null ? requestedServer : defaultServer;
        }
        return serverStep;
    }

    private class SetDBIDirectExecUndoable
    extends AbstractUndoableEdit {
        private String m_oldType;
        private String m_newType;

        public SetDBIDirectExecUndoable(String oldType, String newType) {
            this.m_oldType = oldType;
            this.m_newType = newType;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setDBIDirectExec(this.m_oldType);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setDBIDirectExec(this.m_newType);
        }
    }

    private class SetGenerateIndexesOnTargetTables
    extends AbstractUndoableEdit {
        private boolean m_oldGenerateTargetTableIndexes;
        private boolean m_newGenerateTargetTableIndexes;

        public SetGenerateIndexesOnTargetTables(boolean oldGenerateTargetTableIndexes, boolean newGenerateTargetTableIndexes) {
            this.m_oldGenerateTargetTableIndexes = oldGenerateTargetTableIndexes;
            this.m_newGenerateTargetTableIndexes = newGenerateTargetTableIndexes;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setGenerateIndexesOnTargetTables(this.m_oldGenerateTargetTableIndexes);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setGenerateIndexesOnTargetTables(this.m_newGenerateTargetTableIndexes);
        }
    }

    private class SetIncludedInMappingUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldIncludedInMapping;
        private boolean m_newIncludedInMapping;

        public SetIncludedInMappingUndoable(boolean oldIncludedInMapping, boolean newIncludedInMapping) {
            this.m_oldIncludedInMapping = oldIncludedInMapping;
            this.m_newIncludedInMapping = newIncludedInMapping;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setIncludedInMapping(this.m_oldIncludedInMapping);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setIncludedInMapping(this.m_newIncludedInMapping);
        }
    }

    private class SetIncludedInPropagationUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldIncludedInPropagation;
        private boolean m_newIncludedInPropagation;

        public SetIncludedInPropagationUndoable(boolean oldIncludedInPropagation, boolean newIncludedInPropagation) {
            this.m_oldIncludedInPropagation = oldIncludedInPropagation;
            this.m_newIncludedInPropagation = newIncludedInPropagation;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setIncludedInPropagation(this.m_oldIncludedInPropagation);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setIncludedInPropagation(this.m_newIncludedInPropagation);
        }
    }

    private class SetFileMacroVarsEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetFileMacroVarsEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setFileMacroVarsEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setFileMacroVarsEnabled(this.m_newValue);
        }
    }

    private class SetColMacroVarsEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetColMacroVarsEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setColMacroVarsEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setColMacroVarsEnabled(this.m_newValue);
        }
    }

    private class SetAppendForceEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetAppendForceEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setAppendForceEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setAppendForceEnabled(this.m_newValue);
        }
    }

    private class SetUseConnectUsingUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetUseConnectUsingUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setUseConnectUsing(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setUseConnectUsing(this.m_newValue);
        }
    }

    private class SetFormatInformatGenerationUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetFormatInformatGenerationUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setFormatInformatGeneration(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setFormatInformatGeneration(this.m_newValue);
        }
    }

    private class SetSYSLASTVariableGenerationEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetSYSLASTVariableGenerationEnabledUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.setSYSLASTVariableGenerationEnabled(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.setSYSLASTVariableGenerationEnabled(this.m_newValue);
        }
    }

    private class RemoveMappingUndoable
    extends AbstractUndoableEdit {
        private int m_iMapping;
        private IMapping m_mapping;

        public RemoveMappingUndoable(int iMapping, IMapping mapping) {
            this.m_iMapping = iMapping;
            this.m_mapping = mapping;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.addMapping(this.m_iMapping, this.m_mapping);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.removeMapping(this.m_mapping);
        }

        @Override
        public void die() {
            this.m_mapping = null;
        }
    }

    private class AddMappingUndoable
    extends AbstractUndoableEdit {
        private int m_iMapping;
        private IMapping m_mapping;

        public AddMappingUndoable(int iMapping, IMapping mapping) {
            this.m_iMapping = iMapping;
            this.m_mapping = mapping;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.removeMapping(this.m_mapping);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.addMapping(this.m_iMapping, this.m_mapping);
        }

        @Override
        public void die() {
            this.m_mapping = null;
        }
    }

    private class RemoveTransformTableOptionUndoable
    extends AbstractUndoableEdit {
        private ITransformTableOptions m_TransformTableOption;

        public RemoveTransformTableOptionUndoable(ITransformTableOptions TransformTableOption) {
            this.m_TransformTableOption = TransformTableOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.addTransformTableOption(this.m_TransformTableOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.removeTransformTableOption(this.m_TransformTableOption);
        }

        @Override
        public void die() {
            this.m_TransformTableOption = null;
        }
    }

    private class AddTransformTableOptionUndoable
    extends AbstractUndoableEdit {
        private ITransformTableOptions m_TransformTableOption;

        public AddTransformTableOptionUndoable(ITransformTableOptions TransformTableOption) {
            this.m_TransformTableOption = TransformTableOption;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractDataTransform.this.removeTransformTableOption(this.m_TransformTableOption);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractDataTransform.this.addTransformTableOption(this.m_TransformTableOption);
        }

        @Override
        public void die() {
            this.m_TransformTableOption = null;
        }
    }

    private class ConnectedSourcesList
    extends ModelList {
        public ConnectedSourcesList() {
            super(AbstractDataTransform.this, new String[]{"DataTransform:ConnectedSourceAdded", "DataTransform:ConnectedSourceRemoved"});
        }
    }

    private class DataSourcesList
    extends AbstractPrimaryModelList {
        public DataSourcesList() {
            super(AbstractDataTransform.this, new String[]{"DataTransform.DataSourceAdded", "DataTransform.DataSourceRemoved"}, 2, IDataObject.class);
            this.setOwnerNotified(true);
        }

        @Override
        protected void addTo(Object secondary) {
            ((IDataObject)secondary).addConsumerTransform(AbstractDataTransform.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            ((IDataObject)secondary).removeConsumerTransform(AbstractDataTransform.this);
        }

        @Override
        protected void preAdd(Object obj) {
            if (AbstractDataTransform.this.getJob() != null && !AbstractDataTransform.this.getJob().getDataObjectsList().contains(obj) && !(obj instanceof IWorkTable)) {
                AbstractDataTransform.this.getJob().getDataObjectsList().add(obj);
            }
            AbstractDataTransform.this.preAddDataSource((IDataObject)obj);
        }

        @Override
        protected void postAdd(Object obj) {
            AbstractDataTransform.this.postAddDataSource((IDataObject)obj);
        }

        @Override
        protected void preRemove(Object obj) {
            AbstractDataTransform.this.preRemoveDataSource((IDataObject)obj);
        }

        @Override
        protected void postRemove(Object obj) {
            AbstractDataTransform.this.postRemoveDataSource((IDataObject)obj);
        }
    }

    private static class DeleteWorkTablesFilter
    implements IFilter {
        private DeleteWorkTablesFilter() {
        }

        @Override
        public boolean pass(Object obj) {
            return obj instanceof IWorkTable;
        }
    }

    private class DataTargetsList
    extends AbstractPrimaryModelList {
        public DataTargetsList() {
            super(AbstractDataTransform.this, new String[]{"DataTransform.DataTargetAdded", "DataTransform.DataTargetRemoved"}, 2, IDataObject.class);
            this.setDeleteFilter(new DeleteWorkTablesFilter());
            this.setOwnerNotified(true);
        }

        @Override
        protected void addTo(Object secondary) {
            ((IDataObject)secondary).addProducerTransform(AbstractDataTransform.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            ((IDataObject)secondary).removeProducerTransform(AbstractDataTransform.this);
        }

        @Override
        protected void preAdd(Object obj) {
            if (AbstractDataTransform.this.getJob() != null && !AbstractDataTransform.this.getJob().getDataObjectsList().contains(obj) && !(obj instanceof IWorkTable)) {
                AbstractDataTransform.this.getJob().getDataObjectsList().add(obj);
            }
            AbstractDataTransform.this.preAddDataTarget((IDataObject)obj);
        }

        @Override
        protected void postAdd(Object obj) {
            AbstractDataTransform.this.postAddDataTarget((IDataObject)obj);
        }

        @Override
        protected void preRemove(Object obj) {
            AbstractDataTransform.this.preRemoveDataTarget((IDataObject)obj);
        }

        @Override
        protected void postRemove(Object obj) {
            AbstractDataTransform.this.postRemoveDataTarget((IDataObject)obj);
        }
    }
}

