/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ObjectComparator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class BaseObject
implements IObject,
INotifyListener {
    private String m_sID;
    private String m_sName;
    private String m_sDescription;
    private boolean m_bChanged;
    private Map m_mapUserProperties;
    private IModel m_model;
    private List m_lListeners;

    public BaseObject(String sID, IModel model) {
        this.m_sID = sID;
        this.m_sName = this.getDefaultName();
        this.m_sDescription = "";
        this.m_model = model;
        this.m_bChanged = model.isNewObjectID(sID);
        this.m_model.putObject(this);
    }

    @Override
    public String getID() {
        return this.m_sID;
    }

    protected void setID(String sID) {
        this.m_model.removeObject(this);
        this.m_sID = sID;
        this.m_model.putObject(this);
    }

    @Override
    public void setName(String sName) {
        if (sName == null) {
            throw new NullPointerException("name can not be set to null");
        }
        if (sName.trim().length() == 0) {
            throw new IllegalArgumentException("name must have at least one non-blank character");
        }
        if (sName.equals(this.m_sName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNameUndoable(this.m_sName, sName));
        }
        this.m_sName = sName;
        this.fireModelChangedEvent("Object:NameChanged", this.m_sName);
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void setDescription(String sDescription) {
        if (ObjectComparator.isEqual(sDescription, this.m_sDescription)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDescriptionUndoable(this.m_sDescription, sDescription));
        }
        this.m_sDescription = sDescription;
        this.fireModelChangedEvent("Object:DescriptionChanged", this.m_sDescription);
    }

    @Override
    public String getDescription() {
        return this.m_sDescription;
    }

    @Override
    public void setChanged(boolean bChanged) {
        if (this.getModel().isCopyPaste()) {
            return;
        }
        this.m_bChanged = bChanged;
    }

    @Override
    public boolean isChanged() {
        return this.m_bChanged || this.getModel() != null && this.getModel().isCopyPaste();
    }

    @Override
    public List getReasonsIncomplete() {
        return new ArrayList();
    }

    @Override
    public List getWarnings() {
        return new ArrayList();
    }

    @Override
    public boolean isNew() {
        return this.isNewObjectID(this.m_sID);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean hasWarnings() {
        return false;
    }

    @Override
    public IModel getModel() {
        return this.m_model;
    }

    public void setModel(IModel model) {
        if (this.m_model == model) {
            return;
        }
        this.m_model = model;
        this.m_model.putObject(this);
    }

    @Override
    public void setUserProperty(String sName, String sValue) {
        String sOldValue;
        if (this.m_mapUserProperties == null) {
            this.m_mapUserProperties = new HashMap();
        }
        if ((sOldValue = (String)this.m_mapUserProperties.get(sName)) != null && sOldValue.equals(sValue)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUserPropertyUndoable(sName, this.getUserProperty(sName), sValue));
        }
        this.m_mapUserProperties.put(sName, sValue);
        this.fireModelChangedEvent("Object:UserPropertySet", sName);
    }

    @Override
    public String getUserProperty(String sName) {
        return this.m_mapUserProperties == null ? null : (String)this.m_mapUserProperties.get(sName);
    }

    @Override
    public void removeUserProperty(String sName) {
        if (this.m_mapUserProperties == null) {
            return;
        }
        String sValue = this.getUserProperty(sName);
        if (sValue == null) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveUserPropertyUndoable(sName, sValue));
        }
        this.m_mapUserProperties.remove(sName);
        this.fireModelChangedEvent("Object:UserPropertyRemoved", sName);
    }

    protected String[] getUserPropertyKeys() {
        if (this.m_mapUserProperties == null) {
            return new String[0];
        }
        Set keys = this.m_mapUserProperties.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    protected String getDefaultName() {
        return "unnamed";
    }

    protected void fireModelChangedEvent(ModelEvent ev) {
        this.setChanged(true);
        this.m_model.fireModelEvent(ev);
        this.fireNotifyEvent(1, ev);
    }

    protected void fireModelChangedEvent(String sType, Object data) {
        this.fireModelChangedEvent(new ModelEvent(this.m_model, this, sType, data));
    }

    protected void fireModelChangedEvent(String sType, Object data, Object additionalData) {
        this.fireModelChangedEvent(new ModelEvent(this.m_model, this, sType, data, additionalData));
    }

    protected boolean isUndoSupported() {
        return this.m_model.isUndoSupported();
    }

    protected void undoableEditHappened(UndoableEdit edit) {
        this.m_model.undoableEditHappened(edit);
    }

    protected void startCompoundUndoable() {
        this.m_model.startCompoundUndoable();
    }

    protected void endCompoundUndoable() {
        this.m_model.endCompoundUndoable();
    }

    protected IObjectFactory getObjectFactory() {
        return this.m_model.getObjectFactory();
    }

    protected String createIDForNewObject() {
        return this.m_model.createIDForNewObject(this.getID());
    }

    protected boolean isNewObjectID(String sID) {
        return this.m_model.isNewObjectID(sID);
    }

    @Override
    public void addNotifyListener(INotifyListener lsnr) {
        if (this.m_lListeners == null) {
            this.m_lListeners = new ArrayList();
        }
        if (this.m_lListeners.contains(lsnr)) {
            return;
        }
        this.m_lListeners.add(lsnr);
    }

    @Override
    public void removeNotifyListener(INotifyListener lsnr) {
        if (this.m_lListeners != null) {
            this.m_lListeners.remove(lsnr);
        }
    }

    protected final void fireNotifyEvent(int eNotifyType) {
        this.fireNotifyEvent(eNotifyType, null);
    }

    protected final void fireNotifyEvent(int eNotifyType, ModelEvent modelEvent) {
        if (this.m_lListeners == null || this.m_lListeners.isEmpty()) {
            return;
        }
        this.fireNotifyEventImpl(new NotifyEvent(this, eNotifyType, modelEvent));
    }

    protected final void fireNotifyEvent(NotifyEvent ev) {
        if (this.m_lListeners == null || this.m_lListeners.isEmpty()) {
            return;
        }
        this.fireNotifyEventImpl(ev);
    }

    private void fireNotifyEventImpl(NotifyEvent ev) {
        INotifyListener[] aListeners = this.m_lListeners.toArray(new INotifyListener[this.m_lListeners.size()]);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].notify(ev);
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        this.fireNotifyEvent(ev);
    }

    @Override
    public void dump(PrintStream strm) {
        strm.println(this);
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_sName.length() + 17);
        sb.append(this.m_sName);
        sb.append(":");
        sb.append(this.m_sID);
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IObject) {
            return this.m_sID.equals(((IObject)object).getID());
        }
        return false;
    }

    public int hashcode() {
        return super.hashCode();
    }

    private class RemoveUserPropertyUndoable
    extends AbstractUndoableEdit {
        private String m_sPropertyName;
        private String m_sPropertyValue;

        public RemoveUserPropertyUndoable(String sPropertyName, String sPropertyValue) {
            this.m_sPropertyName = sPropertyName;
            this.m_sPropertyValue = sPropertyValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseObject.this.setUserProperty(this.m_sPropertyName, this.m_sPropertyValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseObject.this.removeUserProperty(this.m_sPropertyName);
        }
    }

    private class SetUserPropertyUndoable
    extends AbstractUndoableEdit {
        private String m_sPropertyName;
        private String m_sOldPropertyValue;
        private String m_sNewPropertyValue;

        public SetUserPropertyUndoable(String sPropertyName, String sOldPropertyValue, String sNewPropertyValue) {
            this.m_sPropertyName = sPropertyName;
            this.m_sOldPropertyValue = sOldPropertyValue;
            this.m_sNewPropertyValue = sNewPropertyValue;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_sOldPropertyValue == null) {
                BaseObject.this.removeUserProperty(this.m_sPropertyName);
            } else {
                BaseObject.this.setUserProperty(this.m_sPropertyName, this.m_sOldPropertyValue);
            }
        }

        @Override
        public void redo() {
            super.redo();
            BaseObject.this.setUserProperty(this.m_sPropertyName, this.m_sNewPropertyValue);
        }
    }

    private class SetDescriptionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldDescription;
        private String m_sNewDescription;

        public SetDescriptionUndoable(String sOldDescription, String sNewDescription) {
            this.m_sOldDescription = sOldDescription;
            this.m_sNewDescription = sNewDescription;
        }

        @Override
        public void undo() {
            super.undo();
            BaseObject.this.setDescription(this.m_sOldDescription);
        }

        @Override
        public void redo() {
            super.redo();
            BaseObject.this.setDescription(this.m_sNewDescription);
        }
    }

    private class SetNameUndoable
    extends AbstractUndoableEdit {
        private String m_sOldName;
        private String m_sNewName;

        public SetNameUndoable(String sOldName, String sNewName) {
            this.m_sOldName = sOldName;
            this.m_sNewName = sNewName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseObject.this.setName(this.m_sOldName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseObject.this.setName(this.m_sNewName);
        }
    }
}

