/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPersistableObject
extends BaseObject
implements IPersistableObject {
    protected static final int USE_PROPERTIES_DIRECTLY = 1;
    protected static final int USE_PROPERTYSET_PROPERTIES = 2;
    protected static final int USE_PROPERTYSET_SETPROPERTIES = 0;
    protected static final int SET_DELIMITER = 16;
    protected static final int COMPARE_PROPERTY_NAME = 0;
    protected static final int COMPARE_NAME = 32;
    protected static final int COMPARE_PROPERTYSET_SETROLE = 0;
    protected static final int COMPARE_PROPERTYSET_NAME = 64;
    protected static final int COMPARE_PROPERTYSET_PROPERTYSETNAME = 128;
    protected static final String OPTIONS_PROPERTYSET_NAME = "OPTIONS";
    private static final String USERPROPERTIES_PROPERTYSET_NAME = "USERPROPERTIES";
    private List m_lDeletedObjects;
    private Map m_mapProperties = new HashMap();
    private Map m_mapPropertySets = new HashMap();
    private Map m_mapCustomLists = new HashMap();

    public AbstractPersistableObject(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void saveXMLToStream(OutputStream strm) throws IOException {
        throw new UnsupportedOperationException("saveXMLToStream not implemented");
    }

    @Override
    public void loadXMLFromStream(InputStream strm) throws IOException {
        throw new UnsupportedOperationException("loadXMLFromStream not implemented");
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        Root mdo = omr.acquireOMRObject(this);
        mdo.setName(this.getName());
        mdo.setDesc(this.getDescription());
        this.saveUserPropertiesToOMR(omr);
        this.deleteDeletedObjectsFromOMR(omr);
        this.setChanged(false);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        this.updatePropertyAndPropertySetIDs(mapIDs);
        this.updateCustomListIDs(mapIDs);
        if (!this.isNew()) {
            return;
        }
        String sNewID = (String)mapIDs.get(this.getID());
        if (sNewID != null) {
            this.setID(sNewID);
        }
    }

    protected void updatePropertyAndPropertySetIDs(Map mapIDs) {
        Collection values = this.m_mapProperties.values();
        PropertyTracker[] aTrackers = new PropertyTracker[values.size()];
        values.toArray(aTrackers);
        for (int iTracker = 0; iTracker < aTrackers.length; ++iTracker) {
            PropertyTracker tracker = aTrackers[iTracker];
            tracker.m_sFQID = this.updateSubordinateID(tracker.m_sFQID, mapIDs);
            tracker.m_sHolderFQID = this.updateSubordinateID(tracker.m_sHolderFQID, mapIDs);
        }
        Set setEntries = this.m_mapPropertySets.entrySet();
        Map.Entry[] aEntries = new Map.Entry[setEntries.size()];
        setEntries.toArray(aEntries);
        for (int iEntry = 0; iEntry < aEntries.length; ++iEntry) {
            String sValue = (String)aEntries[iEntry].getValue();
            sValue = this.updateSubordinateID(sValue, mapIDs);
            aEntries[iEntry].setValue(sValue);
        }
    }

    protected void updateCustomListIDs(Map mapIDs) {
        Set setEntries = this.m_mapCustomLists.entrySet();
        Map.Entry[] aEntries = new Map.Entry[setEntries.size()];
        setEntries.toArray(aEntries);
        for (int iEntry = 0; iEntry < aEntries.length; ++iEntry) {
            String sValue = (String)aEntries[iEntry].getValue();
            sValue = this.updateSubordinateID(sValue, mapIDs);
            aEntries[iEntry].setValue(sValue);
        }
    }

    protected final String updateSubordinateID(String sSubordinateID, Map mapIDs) {
        if (sSubordinateID != null && this.isNewObjectID(sSubordinateID) && mapIDs.containsKey(sSubordinateID)) {
            return (String)mapIDs.get(sSubordinateID);
        }
        return sSubordinateID;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdo = omr.acquireOMRObject(this);
        if (mdo.isNewObject() && (mdo.getName() == null || mdo.getName().equalsIgnoreCase(""))) {
            mdo.setName(this.getDefaultName());
        }
        boolean bNameChanged = false;
        String sName = mdo.getName();
        if (sName.trim().length() == 0) {
            sName = "NONAME";
            bNameChanged = true;
        }
        this.setName(sName);
        this.setDescription(mdo.getDesc());
        this.clearListsBeforeLoad();
        this.loadUserPropertiesFromOMR(omr);
        this.setChanged(bNameChanged);
    }

    protected void clearListsBeforeLoad() {
        this.m_mapCustomLists.clear();
        this.m_mapProperties.clear();
        this.m_mapPropertySets.clear();
    }

    @Override
    public void delete() {
        this.fireNotifyEvent(0, null);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.deleteDeletedObjectsFromOMR(omr);
        this.deletePropertiesAndPropertySetsFromOMR(omr);
        this.deleteCustomListsFromOMR(omr);
        omr.deleteOMRObject(this.getID(), this.getOMRType());
        if (!this.getModel().isCopyPaste()) {
            this.getModel().removeObject(this);
        }
    }

    protected void deletePropertiesAndPropertySetsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Collection values = this.m_mapProperties.values();
        PropertyTracker[] aTrackers = new PropertyTracker[values.size()];
        values.toArray(aTrackers);
        for (int iTracker = 0; iTracker < aTrackers.length; ++iTracker) {
            this.deleteProperty(omr, aTrackers[iTracker]);
        }
        values = this.m_mapPropertySets.values();
        String[] aIDs = new String[values.size()];
        values.toArray(aIDs);
        for (int iID = 0; iID < aIDs.length; ++iID) {
            omr.deleteOMRObject(aIDs[iID], "PropertySet");
        }
    }

    private void deleteProperty(OMRAdapter omr, PropertyTracker tracker) throws MdException, RemoteException {
        omr.deleteOMRObject(tracker.m_sFQID, "Property");
        if (tracker.m_sHolderFQID != null) {
            omr.deleteOMRObject(tracker.m_sHolderFQID, "Transformation");
        }
        if (tracker.m_sCustomAssocFQID != null) {
            omr.deleteOMRObject(tracker.m_sCustomAssocFQID, "CustomAssociation");
        }
    }

    protected void deleteCustomListsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Collection values = this.m_mapCustomLists.values();
        String[] aIDs = new String[values.size()];
        values.toArray(aIDs);
        for (int iID = 0; iID < aIDs.length; ++iID) {
            omr.deleteOMRObject(aIDs[iID], "CustomAssociation");
        }
        this.m_mapCustomLists.clear();
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        HashMap map = new HashMap();
        ArrayList<String> lAssociations = new ArrayList<String>();
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        lAssociations.add("CustomAssociations");
        map.put(this.getOMRType(), lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("SetProperties");
        lAssociations.add("Properties");
        map.put("PropertySet", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("SpecTargetTransformations");
        lAssociations.add("CustomAssociations");
        map.put("Property", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("SourceSpecifications");
        map.put("Transformation", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("AssociatedObjects");
        map.put("CustomAssociation", lAssociations);
        return map;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public List getRefreshObjects() {
        return null;
    }

    public void saveCustomListToOMR(OMRAdapter omr, String sListName, IPersistableObject[] aObjects) throws MdException, RemoteException {
        Root mdo = omr.acquireOMRObject(this);
        this.saveCustomListToOMR(omr, mdo, sListName, aObjects);
    }

    public void saveCustomListToOMR(OMRAdapter omr, Root mdoAnchor, String sListName, IPersistableObject[] aObjects) throws MdException, RemoteException {
        String sFQID = (String)this.m_mapCustomLists.get(sListName);
        if (sFQID == null) {
            sFQID = this.createIDForNewObject();
            this.m_mapCustomLists.put(sListName, sFQID);
        }
        CustomAssociation mdoList = (CustomAssociation)omr.acquireOMRObject(sFQID, "CustomAssociation");
        mdoList.setName(sListName);
        mdoList.setPartnerName(sListName + "Partner");
        mdoList.setisOwned(0);
        AssociationList lCustAssoc = mdoAnchor.getCustomAssociations(false);
        if (!lCustAssoc.contains(mdoList)) {
            lCustAssoc.add(mdoList);
        }
        AssociationList lObjects = mdoList.getAssociatedObjects(false);
        lObjects.clear();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            lObjects.add(omr.acquireOMRObject(aObjects[iObject]));
        }
    }

    public IPersistableObject[] loadCustomListFromOMR(OMRAdapter omr, String sListName) throws MdException, RemoteException {
        Root mdoAnchor = omr.acquireOMRObject(this);
        return this.loadCustomListFromOMR(omr, mdoAnchor, sListName);
    }

    public IPersistableObject[] loadCustomListFromOMR(OMRAdapter omr, Root mdoAnchor, String sListName) throws MdException, RemoteException {
        CustomAssociation mdoList = this.findCustomList(omr, mdoAnchor, sListName);
        if (mdoList == null) {
            return new IPersistableObject[0];
        }
        AssociationList lObjects = mdoList.getAssociatedObjects();
        IPersistableObject[] aObjects = new IPersistableObject[lObjects.size()];
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            aObjects[iObject] = (IPersistableObject)omr.acquireObject((Root)lObjects.get(iObject));
        }
        return aObjects;
    }

    protected CustomAssociation findCustomList(OMRAdapter omr, Root mdoAnchor, String sListName) throws MdException, RemoteException {
        String sFQID = (String)this.m_mapCustomLists.get(sListName);
        if (sFQID != null) {
            return (CustomAssociation)omr.acquireOMRObject(sFQID, "CustomAssociation");
        }
        List lCustAssocs = this.findAllCustomAssociations(omr, mdoAnchor, sListName);
        if (lCustAssocs.size() > 0) {
            CustomAssociation ca = (CustomAssociation)lCustAssocs.get(0);
            this.m_mapCustomLists.put(sListName, ca.getFQID());
            return ca;
        }
        return null;
    }

    protected Map getCustomAssocationMap() {
        return this.m_mapCustomLists;
    }

    protected List findAllCustomAssociations(OMRAdapter omr, Root mdoAnchor, String sListName) throws MdException, RemoteException {
        ArrayList<CustomAssociation> lCAssocReturned = new ArrayList<CustomAssociation>();
        AssociationList lCAssocs = mdoAnchor.getCustomAssociations(false);
        for (int iList = 0; iList < lCAssocs.size(); ++iList) {
            CustomAssociation mdo = (CustomAssociation)lCAssocs.get(iList);
            if (!mdo.getName().equals(sListName)) continue;
            lCAssocReturned.add(mdo);
        }
        return lCAssocReturned;
    }

    public void saveStringOptionToOMR(OMRAdapter omr, String sName, String sValue) throws MdException, RemoteException {
        this.saveOptionToOMR(omr, sName, sValue, 12);
    }

    public void saveIntOptionToOMR(OMRAdapter omr, String sName, int iValue) throws RemoteException, MdException {
        this.saveOptionToOMR(omr, sName, Integer.toString(iValue), 4);
    }

    public void saveDoubleOptionToOMR(OMRAdapter omr, String sName, Double iValue) throws RemoteException, MdException {
        this.saveOptionToOMR(omr, sName, iValue != null ? Double.toString(iValue) : null, 8);
    }

    public void saveBooleanOptionToOMR(OMRAdapter omr, String sName, boolean bValue) throws RemoteException, MdException {
        this.saveOptionToOMR(omr, sName, Boolean.toString(bValue), 16);
    }

    public void saveOptionToOMR(OMRAdapter omr, String sName, String sValue, int eSQLType) throws MdException, RemoteException {
        this.saveOptionToOMR(omr, OPTIONS_PROPERTYSET_NAME, sName, sValue, eSQLType);
    }

    public void saveStringOptionToOMR(OMRAdapter omr, String sSetRole, String sName, String sValue) throws MdException, RemoteException {
        this.saveOptionToOMR(omr, sSetRole, sName, sValue, 12);
    }

    public void saveIntOptionToOMR(OMRAdapter omr, String sSetRole, String sName, int iValue) throws RemoteException, MdException {
        this.saveOptionToOMR(omr, sSetRole, sName, Integer.toString(iValue), 4);
    }

    public void saveBooleanOptionToOMR(OMRAdapter omr, String sSetRole, String sName, boolean bValue) throws RemoteException, MdException {
        this.saveOptionToOMR(omr, sSetRole, sName, Boolean.toString(bValue), 16);
    }

    public void saveOptionToOMR(OMRAdapter omr, String sSetRole, String sName, String sValue, int eSQLType) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, sSetRole, sName, sName, "OPTION", sValue, eSQLType, 0);
    }

    public void saveUserPropertiesToOMR(OMRAdapter omr) throws MdException, RemoteException {
        int iKey;
        String[] aKeys = this.getUserPropertyKeys();
        ArrayList lOldKeys = new ArrayList(this.m_mapProperties.keySet());
        for (iKey = 0; iKey < aKeys.length; ++iKey) {
            String sName = aKeys[iKey];
            String sValue = this.getUserProperty(sName);
            if (sValue == null) continue;
            this.savePropertyToOMR(omr, USERPROPERTIES_PROPERTYSET_NAME, sName, sName, "USER", sValue, 12, 0);
            lOldKeys.remove(USERPROPERTIES_PROPERTYSET_NAME + sName);
        }
        for (iKey = 0; iKey < lOldKeys.size(); ++iKey) {
            String sKey = (String)lOldKeys.get(iKey);
            if (!sKey.startsWith(USERPROPERTIES_PROPERTYSET_NAME)) continue;
            this.deleteProperty(omr, (PropertyTracker)this.m_mapProperties.get(sKey));
            this.m_mapProperties.remove(sKey);
        }
    }

    protected void savePropertyToOMR(OMRAdapter omr, String sSetRole, String sName, String sPropertyName, String sPropertyRole, String sValue, int eSQLType, int fFlags) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, omr.acquireOMRObject(this), sSetRole, sName, sPropertyName, sPropertyRole, sValue, eSQLType, fFlags);
    }

    protected void savePropertyToOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sPropertyName, String sPropertyRole, String sValue, int eSQLType, int fFlags) throws MdException, RemoteException {
        Property mdoProperty = this.acquireProperty(omr, mdoAnchor, sSetRole, sName, sPropertyName, sPropertyRole, eSQLType, fFlags);
        mdoProperty.setDefaultValue(sValue);
    }

    public void saveObjectListPropertyToOMR(OMRAdapter omr, String sSetRole, String sName, String sPropertyName, String sPropertyRole, IPersistableObject[] aObjects, int eSQLType, int fFlags) throws MdException, RemoteException {
        this.saveObjectListPropertyToOMR(omr, omr.acquireOMRObject(this), sSetRole, sName, sPropertyName, sPropertyRole, aObjects, eSQLType, fFlags, false);
    }

    public void saveObjectListPropertyToOMR(OMRAdapter omr, String sSetRole, String sName, String sPropertyName, String sPropertyRole, IPersistableObject[] aObjects, int eSQLType, int fFlags, boolean bSaveObjectList) throws MdException, RemoteException {
        this.saveObjectListPropertyToOMR(omr, omr.acquireOMRObject(this), sSetRole, sName, sPropertyName, sPropertyRole, aObjects, eSQLType, fFlags, bSaveObjectList);
    }

    protected void saveObjectListPropertyToOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sPropertyName, String sPropertyRole, IPersistableObject[] aObjects, int eSQLType, int fFlags) throws MdException, RemoteException {
        this.saveObjectListPropertyToOMR(omr, mdoAnchor, sSetRole, sName, sPropertyName, sPropertyRole, aObjects, eSQLType, fFlags, false);
    }

    protected void saveObjectListPropertyToOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sPropertyName, String sPropertyRole, IPersistableObject[] aObjects, int eSQLType, int fFlags, boolean bSaveObjectList) throws MdException, RemoteException {
        Transformation mdoTransform;
        Property mdoProperty = this.acquireProperty(omr, mdoAnchor, sSetRole, sName, sPropertyName, sPropertyRole, eSQLType, fFlags);
        mdoProperty.setDefaultValue(sPropertyName);
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sSetRole + sPropertyName);
        if (tracker.m_sHolderFQID != null) {
            mdoTransform = (Transformation)omr.acquireOMRObject(tracker.m_sHolderFQID, "Transformation");
        } else {
            tracker.m_sHolderFQID = this.createIDForNewObject();
            mdoTransform = (Transformation)omr.acquireOMRObject(tracker.m_sHolderFQID, "Transformation");
        }
        mdoTransform.setName(sPropertyName);
        mdoTransform.setTransformRole(sPropertyName);
        if (!mdoProperty.getSpecTargetTransformations().contains((Object)mdoTransform)) {
            mdoProperty.getSpecTargetTransformations().add((Object)mdoTransform);
        }
        AssociationList lObjects = mdoTransform.getSourceSpecifications(false);
        lObjects.clear();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            IPersistableObject obj = aObjects[iObject];
            if (bSaveObjectList) {
                obj.saveToOMR(omr);
            }
            lObjects.add(omr.acquireOMRObject(obj));
        }
    }

    public void saveOptionWithCustomListToOMR(OMRAdapter omr, String sSetRole, String sName, String sValue, IPersistableObject[] aObjects) throws MdException, RemoteException {
        Property mdoProperty = this.acquireProperty(omr, omr.acquireOMRObject(this), sSetRole, sName, sName, sName, 12, 0);
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sSetRole + sName);
        mdoProperty.setDefaultValue(sValue);
        if (tracker.m_sCustomAssocFQID == null) {
            tracker.m_sCustomAssocFQID = this.createIDForNewObject();
        }
        CustomAssociation mdoCustAssoc = (CustomAssociation)omr.acquireOMRObject(tracker.m_sCustomAssocFQID, "CustomAssociation");
        mdoCustAssoc.setName(sName);
        mdoCustAssoc.setPartnerName(sName + "Partner");
        mdoCustAssoc.setisOwned(0);
        AssociationList lAssoc = mdoProperty.getCustomAssociations();
        lAssoc.clear();
        lAssoc.add(mdoCustAssoc);
        AssociationList lObjects = mdoCustAssoc.getAssociatedObjects(false);
        lObjects.clear();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            lObjects.add(omr.acquireOMRObject(aObjects[iObject]));
        }
    }

    private Property acquireProperty(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sPropertyName, String sPropertyRole, int eSQLType, int fFlags) throws MdException, RemoteException {
        return this.acquireProperty(omr, mdoAnchor, sSetRole, sName, sPropertyName, sPropertyRole, eSQLType, fFlags, "");
    }

    private Property acquireProperty(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sPropertyName, String sPropertyRole, int eSQLType, int fFlags, String sPropertySetName) throws MdException, RemoteException {
        String sTestName = (fFlags & 0x20) == 0 ? sPropertyName : sName;
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sPropertySetName + sSetRole + sTestName);
        String sID = this.createIDForNewObject();
        if (tracker == null) {
            this.m_mapProperties.put(sPropertySetName + sSetRole + sTestName, new PropertyTracker(sID));
        } else {
            sID = tracker.m_sFQID;
        }
        Property mdoProperty = (Property)omr.acquireOMRObject(sID, "Property");
        boolean bDelimiter = (fFlags & 0x10) != 0;
        mdoProperty.setName(sName);
        mdoProperty.setPropertyName(sPropertyName);
        mdoProperty.setPropertyRole(sPropertyRole);
        mdoProperty.setSQLType(eSQLType);
        mdoProperty.setUseValueOnly(bDelimiter ? 0 : 1);
        mdoProperty.setDelimiter(bDelimiter ? "=" : "");
        if ((fFlags & 1) != 0) {
            if (!mdoAnchor.getProperties(false).contains((Object)mdoProperty)) {
                mdoAnchor.getProperties(false).add((Object)mdoProperty);
            }
        } else {
            PropertySet mdoSet = this.acquirePropertySet(mdoAnchor, omr, sSetRole, sPropertySetName);
            if ((fFlags & 2) != 0) {
                if (!mdoSet.getProperties(false).contains((Object)mdoProperty)) {
                    mdoSet.getProperties(false).add((Object)mdoProperty);
                }
            } else if (!mdoSet.getSetProperties(false).contains((Object)mdoProperty)) {
                mdoSet.getSetProperties(false).add((Object)mdoProperty);
            }
        }
        return mdoProperty;
    }

    public PropertySet acquirePropertySet(OMRAdapter omr, Root mdoAnchor, String sSetRole) throws MdException, RemoteException {
        return this.acquirePropertySet(mdoAnchor, omr, sSetRole, "");
    }

    public PropertySet acquirePropertySet(Root mdoAnchor, OMRAdapter omr, String sSetRole, String sPropertySetName) throws MdException, RemoteException {
        String sSetID = (String)this.m_mapPropertySets.get(sSetRole + sPropertySetName);
        if (sSetID == null || sSetID.length() == 0) {
            sSetID = this.createIDForNewObject();
            this.m_mapPropertySets.put(sSetRole + sPropertySetName, sSetID);
        }
        PropertySet mdoSet = (PropertySet)omr.acquireOMRObject(sSetID, "PropertySet");
        mdoSet.setName(sSetRole);
        mdoSet.setSetRole(sSetRole);
        mdoSet.setPropertySetName(sPropertySetName);
        if (!mdoAnchor.getPropertySets(false).contains((Object)mdoSet)) {
            mdoAnchor.getPropertySets(false).add((Object)mdoSet);
        }
        return mdoSet;
    }

    public String loadStringOptionFromOMR(OMRAdapter omr, String sName, String sDefaultValue) throws MdException, RemoteException {
        return this.loadStringOptionFromOMR(omr, OPTIONS_PROPERTYSET_NAME, sName, sDefaultValue);
    }

    public Double loadDoubleOptionFromOMR(OMRAdapter omr, String sName, Double iDefaultValue) throws RemoteException, MdException {
        return this.loadDoubleOptionFromOMR(omr, OPTIONS_PROPERTYSET_NAME, sName, iDefaultValue);
    }

    public Double loadDoubleOptionFromOMR(OMRAdapter omr, String sSetRole, String sName, Double iDefaultValue) throws RemoteException, MdException {
        String sValue = this.loadOptionFromOMRImpl(omr, sSetRole, sName);
        if (sValue != null) {
            try {
                return Double.parseDouble(sValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iDefaultValue;
    }

    public int loadIntOptionFromOMR(OMRAdapter omr, String sName, int iDefaultValue) throws RemoteException, MdException {
        return this.loadIntOptionFromOMR(omr, OPTIONS_PROPERTYSET_NAME, sName, iDefaultValue);
    }

    public boolean loadBooleanOptionFromOMR(OMRAdapter omr, String sName, boolean bDefaultValue) throws RemoteException, MdException {
        return this.loadBooleanOptionFromOMR(omr, OPTIONS_PROPERTYSET_NAME, sName, bDefaultValue);
    }

    public String loadOptionFromOMR(OMRAdapter omr, String sName, String sDefaultValue) throws MdException, RemoteException {
        return this.loadOptionFromOMR(omr, OPTIONS_PROPERTYSET_NAME, sName, sDefaultValue);
    }

    public String loadStringOptionFromOMR(OMRAdapter omr, String sSetRole, String sName, String sDefaultValue) throws MdException, RemoteException {
        String sValue = this.loadOptionFromOMRImpl(omr, sSetRole, sName);
        return sValue == null ? sDefaultValue : sValue;
    }

    public int loadIntOptionFromOMR(OMRAdapter omr, String sSetRole, String sName, int iDefaultValue) throws RemoteException, MdException {
        String sValue = this.loadOptionFromOMRImpl(omr, sSetRole, sName);
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iDefaultValue;
    }

    public boolean loadBooleanOptionFromOMR(OMRAdapter omr, String sSetRole, String sName, boolean bDefaultValue) throws RemoteException, MdException {
        String sValue = this.loadOptionFromOMRImpl(omr, sSetRole, sName);
        if (sValue != null) {
            return Boolean.valueOf(sValue);
        }
        return bDefaultValue;
    }

    public String loadOptionFromOMR(OMRAdapter omr, String sSetRole, String sName, String sDefaultValue) throws MdException, RemoteException {
        String sValue = this.loadOptionFromOMRImpl(omr, sSetRole, sName);
        return sValue == null ? sDefaultValue : sValue;
    }

    private String loadOptionFromOMRImpl(OMRAdapter omr, String sSetRole, String sName) throws MdException, RemoteException {
        return this.loadPropertyFromOMRImpl(omr, omr.acquireOMRObject(this), sSetRole, sName, 0);
    }

    public void loadUserPropertiesFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        PropertySet mdoSet = this.findPropertySet(omr, omr.acquireOMRObject(this), USERPROPERTIES_PROPERTYSET_NAME, 0);
        if (mdoSet == null) {
            return;
        }
        AssociationList lProperties = mdoSet.getSetProperties();
        for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
            Property mdoProperty = (Property)lProperties.get(iProperty);
            this.setUserProperty(mdoProperty.getPropertyName(), mdoProperty.getDefaultValue());
            this.m_mapProperties.put(USERPROPERTIES_PROPERTYSET_NAME + mdoProperty.getPropertyName(), new PropertyTracker(mdoProperty.getFQID()));
        }
    }

    protected String loadPropertyFromOMR(OMRAdapter omr, String sSetRole, String sPropertyName, String sDefaultValue, int eWhere) throws MdException, RemoteException {
        String sValue = this.loadPropertyFromOMRImpl(omr, omr.acquireOMRObject(this), sSetRole, sPropertyName, eWhere);
        return sValue == null ? sDefaultValue : sValue;
    }

    protected String loadPropertyFromOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, String sDefaultValue, int eWhere) throws MdException, RemoteException {
        String sValue = this.loadPropertyFromOMRImpl(omr, mdoAnchor, sSetRole, sPropertyName, eWhere);
        return sValue == null ? sDefaultValue : sValue;
    }

    private String loadPropertyFromOMRImpl(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, int eWhere) throws MdException, RemoteException {
        Property mdoProperty = this.findProperty(omr, mdoAnchor, sSetRole, sPropertyName, eWhere);
        return mdoProperty == null ? null : mdoProperty.getDefaultValue();
    }

    public IPersistableObject[] loadObjectListPropertyFromOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, int eWhere) throws MdException, RemoteException {
        AssociationList lTransforms;
        Property mdoProperty = this.findProperty(omr, mdoAnchor, sSetRole, sPropertyName, eWhere);
        if (mdoProperty != null && !(lTransforms = mdoProperty.getSpecTargetTransformations()).isEmpty()) {
            Transformation mdoHolder = (Transformation)lTransforms.get(0);
            PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sSetRole + sPropertyName);
            tracker.m_sHolderFQID = mdoHolder.getFQID();
            AssociationList lObjects = mdoHolder.getSourceSpecifications();
            IPersistableObject[] aObjects = new IPersistableObject[lObjects.size()];
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                aObjects[iObject] = (IPersistableObject)omr.acquireObject((Root)lObjects.get(iObject));
            }
            return aObjects;
        }
        return new IPersistableObject[0];
    }

    public IPersistableObject[] loadOptionWithCustomListFromOMR(OMRAdapter omr, String sSetRole, String sName, String sDefaultValue) throws MdException, RemoteException {
        AssociationList lAssocs;
        Property mdoProperty = this.findProperty(omr, omr.acquireOMRObject(this), sSetRole, sName, 0);
        if (mdoProperty != null && !(lAssocs = mdoProperty.getCustomAssociations()).isEmpty()) {
            CustomAssociation mdoCustAssoc = (CustomAssociation)lAssocs.get(0);
            PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sSetRole + sName);
            tracker.m_sCustomAssocFQID = mdoCustAssoc.getFQID();
            AssociationList lObjects = mdoCustAssoc.getAssociatedObjects();
            IPersistableObject[] aObjects = new IPersistableObject[lObjects.size()];
            for (int i = 0; i < aObjects.length; ++i) {
                aObjects[i] = (IPersistableObject)omr.acquireObject((Root)lObjects.get(i));
            }
            return aObjects;
        }
        return new IPersistableObject[0];
    }

    public IPersistableObject[] loadObjectListPropertyFromOMR(OMRAdapter omr, String sSetRole, String sPropertyName, int eWhere) throws MdException, RemoteException {
        return this.loadObjectListPropertyFromOMR(omr, omr.acquireOMRObject(this), sSetRole, sPropertyName, eWhere);
    }

    protected void deletePropertyFromOMR(OMRAdapter omr, String sSetRole, String sPropertyName) throws MdException, RemoteException {
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sSetRole + sPropertyName);
        if (tracker != null) {
            this.deleteProperty(omr, tracker);
            this.m_mapProperties.remove(sSetRole + sPropertyName);
        }
    }

    protected Property findProperty(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, int fFlags) throws MdException, RemoteException {
        AssociationList lProperties;
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(sSetRole + sPropertyName);
        if (tracker != null) {
            return (Property)omr.acquireOMRObject(tracker.m_sFQID, "Property");
        }
        if ((fFlags & 1) != 0) {
            lProperties = mdoAnchor.getProperties();
        } else {
            PropertySet mdoSet = this.findPropertySet(omr, mdoAnchor, sSetRole, fFlags);
            if (mdoSet == null) {
                return null;
            }
            lProperties = (fFlags & 2) != 0 ? mdoSet.getProperties() : mdoSet.getSetProperties();
        }
        boolean bUsePropertyName = (fFlags & 0x20) == 0;
        for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
            String sTestName;
            Property mdoProperty = (Property)lProperties.get(iProperty);
            if (mdoProperty == null) continue;
            String string = sTestName = bUsePropertyName ? mdoProperty.getPropertyName() : mdoProperty.getName();
            if (!sTestName.equalsIgnoreCase(sPropertyName)) continue;
            this.m_mapProperties.put(sSetRole + sPropertyName, new PropertyTracker(mdoProperty.getFQID()));
            return mdoProperty;
        }
        return null;
    }

    protected PropertySet findPropertySet(OMRAdapter omr, Root mdoAnchor, String sSetRole, int fFlags) throws MdException, RemoteException {
        return this.findPropertySet(omr, mdoAnchor, sSetRole, "", fFlags);
    }

    protected PropertySet findPropertySet(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertySetName, int fFlags) throws MdException, RemoteException {
        String sSetID = (String)this.m_mapPropertySets.get(sSetRole + sPropertySetName);
        if (sSetID != null) {
            return (PropertySet)omr.acquireOMRObject(sSetID, "PropertySet");
        }
        AssociationList lSets = mdoAnchor.getPropertySets();
        for (int iSet = 0; iSet < lSets.size(); ++iSet) {
            PropertySet mdoSet = (PropertySet)lSets.get(iSet);
            String sCompareString = (fFlags & 0x40) != 0 ? mdoSet.getName() : ((fFlags & 0x80) != 0 ? mdoSet.getPropertySetName() : ((fFlags & 0x80 & 0) != 0 ? mdoSet.getSetRole() + mdoSet.getPropertySetName() : mdoSet.getSetRole()));
            if (!sCompareString.equalsIgnoreCase(sSetRole + sPropertySetName)) continue;
            this.m_mapPropertySets.put(sSetRole + sPropertySetName, mdoSet.getFQID());
            return mdoSet;
        }
        return null;
    }

    protected List findSameNamePropertySetsObjects(OMRAdapter omr, Root mdoAnchor, String sSetRole, int fFlags) throws MdException, RemoteException {
        return this.findSameNamePropertySetsObjects(omr, mdoAnchor, sSetRole, "", fFlags);
    }

    protected List findSameNamePropertySetsObjects(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertySetName, int fFlags) throws MdException, RemoteException {
        ArrayList<PropertySet> sameNamePropertySets = new ArrayList<PropertySet>();
        AssociationList lSets = mdoAnchor.getPropertySets(true);
        for (int iSet = 0; iSet < lSets.size(); ++iSet) {
            PropertySet mdoSet = (PropertySet)lSets.get(iSet);
            String sCompareString = (fFlags & 0x40) != 0 ? mdoSet.getName() : ((fFlags & 0x80) != 0 ? mdoSet.getPropertySetName() : ((fFlags & 0x80 & 0) != 0 ? mdoSet.getSetRole() + mdoSet.getPropertySetName() : mdoSet.getSetRole()));
            if (!sCompareString.equalsIgnoreCase(sSetRole + sPropertySetName)) continue;
            sameNamePropertySets.add(mdoSet);
        }
        return sameNamePropertySets;
    }

    protected void addToDeletedObjects(IPersistableObject obj) {
        if (this.m_lDeletedObjects == null) {
            this.m_lDeletedObjects = new ArrayList();
        }
        this.m_lDeletedObjects.add(obj);
        this.getModel().removeObject(obj);
        obj.delete();
    }

    protected void removeFromDeletedObjects(IPersistableObject obj) {
        if (obj == null) {
            return;
        }
        if (this.m_lDeletedObjects == null) {
            return;
        }
        this.m_lDeletedObjects.remove(obj);
        this.getModel().putObject(obj);
    }

    protected List getDeletedObjects() {
        if (this.m_lDeletedObjects == null) {
            this.m_lDeletedObjects = new ArrayList();
        }
        return this.m_lDeletedObjects;
    }

    private void deleteDeletedObjectsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.m_lDeletedObjects == null) {
            return;
        }
        for (int iObject = 0; iObject < this.m_lDeletedObjects.size(); ++iObject) {
            ((IPersistableObject)this.m_lDeletedObjects.get(iObject)).deleteFromOMR(omr);
        }
        this.m_lDeletedObjects.clear();
    }

    private static class PropertyTracker {
        String m_sFQID;
        String m_sHolderFQID;
        String m_sCustomAssocFQID;

        PropertyTracker(String sFQID) {
            this.m_sFQID = sFQID;
        }
    }
}

