/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.data.impl.TransformTablePromptModel;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TransformTablePromptModelCollection
extends PhysicalTablePromptModelCollection {
    public TransformTablePromptModelCollection(IObject owner, PhysicalTablePromptModelCollection ptCollection) {
        try {
            PhysicalTablePromptModel[] models = ptCollection.getTableModels();
            for (int i = 0; i < models.length; ++i) {
                TransformTablePromptModel newModel = new TransformTablePromptModel(owner.getModel(), owner);
                newModel.setPromptGroup(PromptUtils.copyPromptGroup(Workspace.getWorkspace().getUserContext(), models[i].getPromptGroupObject()));
                newModel.setAccessType(models[i].getAccessType());
                newModel.setLocation("TransformTable");
                newModel.setListeningForChanges(false);
                IPromptDefinitionValue[] definitions = models[i].getPromptDefinitionValues();
                for (int j = 0; j < definitions.length; ++j) {
                    IPromptDefinitionValue newdef;
                    if (!definitions[j].isValueSetNotIncludingDefault() || (newdef = newModel.getPromptDefinitionValue(definitions[j].getName())) == null) continue;
                    newdef.setValue(definitions[j].getValue());
                }
                newModel.setListeningForChanges(true);
                newModel.swapValuesToDefaultValues();
                this.addModel(newModel, ptCollection.getHelpTopics()[i], ptCollection.getTitles()[i]);
            }
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }
}

