/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PhysicalTablePromptModel
extends BasePromptModel {
    public static final String ADDITIONAL_OPTIONS = "AdditionalOptions";
    public static final String ACCESS_TYPE = "AccessType";
    public static final String ACCESS_TYPE_READ = "Read";
    public static final String ACCESS_TYPE_WRITE = "Write";
    public static final String ACCESS_TYPE_BOTH = "Both";
    public static final String MEMBER_TYPE = "MemberType";
    public static final String MEMBER_TYPE_TABLE = "DATA";
    public static final String MEMBER_TYPE_VIEW = "VIEW";
    public static final String MEMBER_TYPE_BOTH = "Both";
    public static final String LOCATION = "UsageLocation";
    public static final String LOCATION_TABLE = "Table";
    public static final String LOCATION_TRANSFORM = "TransformTable";
    public static final String LOCATION_TRANSFORM_SPECIFIC = "TransformSpecificTable";
    public static final String LOCATION_BOTH = "Both";
    private static final String COMPRESS = "COMPRESS";
    private static final String ENCRYPT = "ENCRYPT";
    private static final String PROPERTY_SET_ACCESS_READ = "ACCESS_READ";
    private static final String PROPERTY_SET_ACCESS_WRITE = "ACCESS_WRITE";
    private boolean m_bGenerateTransformSpecificOptions;
    private String m_sLocation;
    private String m_sAccessType;
    private IPhysicalTable m_table;

    public PhysicalTablePromptModel(IModel model, IObject owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        super(model, owner);
        this.setSaveValuesAsStrings(true);
        this.m_sLocation = LOCATION_TABLE;
        this.m_sAccessType = "Both";
        this.m_bGenerateTransformSpecificOptions = true;
    }

    @Override
    public PromptDataProvider createDataProvider() throws ServiceException, RemoteException, MdException, ServerConnectionException {
        return null;
    }

    @Override
    public void setPromptGroup(PromptGroupInterface group) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        super.setPromptGroup(group);
        this.setVisiblePrompts();
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent mdlEvent;
        super.notify(ev);
        if (ev.getSource() == this.getTable() && ev.getModelEvent() != null && "Table:ViewChanged".equals((mdlEvent = ev.getModelEvent()).getType())) {
            this.setShowMemberTypeOptions(this.getMemberType());
        }
    }

    public void setGenerateTransformSpecificOptions(boolean bGenTransformSpecific) {
        this.m_bGenerateTransformSpecificOptions = bGenTransformSpecific;
    }

    public boolean isGenerateTransformSpecificOptions() {
        return this.m_bGenerateTransformSpecificOptions;
    }

    public IPhysicalTable getTable() {
        return this.m_table;
    }

    public void setTable(IPhysicalTable table) {
        if (this.m_table != null) {
            this.m_table.removeNotifyListener(this);
        }
        this.m_table = table;
        if (this.m_table != null) {
            this.setShowMemberTypeOptions(this.getMemberType());
            this.m_table.addNotifyListener(this);
        }
    }

    public void setLocation(String sLocation) {
        if (!(LOCATION_TABLE.equals(sLocation) || LOCATION_TRANSFORM.equals(sLocation) || LOCATION_TRANSFORM_SPECIFIC.equals(sLocation))) {
            throw new IllegalArgumentException("location not valid");
        }
        if (this.m_sLocation.equals(sLocation)) {
            return;
        }
        this.m_sLocation = sLocation;
        this.setVisiblePrompts();
    }

    public String getLocation() {
        return this.m_sLocation;
    }

    public void setShowTableOptions() {
        this.setLocation(LOCATION_TABLE);
    }

    public void setShowTransformTableOptions() {
        this.setLocation(LOCATION_TRANSFORM);
    }

    public void setShowTransformSpecificOptions() {
        this.setLocation(LOCATION_TRANSFORM_SPECIFIC);
    }

    public void setAccessType(String accessType) {
        if (!(ACCESS_TYPE_READ.equals(accessType) || ACCESS_TYPE_WRITE.equals(accessType) || "Both".equals(accessType))) {
            throw new IllegalArgumentException("wrong access type");
        }
        if (this.m_sAccessType.equals(accessType)) {
            return;
        }
        this.m_sAccessType = accessType;
        this.setVisiblePrompts();
    }

    public void setShowReadOptions() {
        this.setAccessType(ACCESS_TYPE_READ);
    }

    public void setShowWriteOptions() {
        this.setAccessType(ACCESS_TYPE_WRITE);
    }

    public void setShowMemberTypeOptions(String memberType) {
        this.setVisiblePrompts();
    }

    @Override
    public IPromptDefinitionValue[] getPromptDefinitionsToCodeGen() {
        ArrayList<IPromptDefinitionValue> defs = new ArrayList<IPromptDefinitionValue>();
        if (ACCESS_TYPE_READ.equals(this.m_sAccessType)) {
            defs.addAll(Arrays.asList(this.getAccessReadOptions()));
        } else if (ACCESS_TYPE_WRITE.equals(this.m_sAccessType)) {
            defs.addAll(Arrays.asList(this.getAccessWriteOptions()));
        } else {
            defs.addAll(Arrays.asList(this.getPromptDefinitionValues()));
        }
        if (!this.m_bGenerateTransformSpecificOptions) {
            IPromptDefinitionValue[] transforms = this.getPromptDefinitionsWithUserInfo(defs.toArray(new IPromptDefinitionValue[defs.size()]), LOCATION, LOCATION_TRANSFORM_SPECIFIC);
            defs.removeAll(Arrays.asList(transforms));
        }
        return defs.toArray(new IPromptDefinitionValue[defs.size()]);
    }

    public String getAccessType() {
        return this.m_sAccessType;
    }

    public IPromptDefinitionValue[] getTransformationDefinitions() {
        return this.getPromptDefinitionsWithUserInfo(LOCATION, LOCATION_TRANSFORM);
    }

    public IPromptDefinitionValue[] getLocationDefinitions() {
        return this.getLocationDefinitions(this.getPromptDefinitionValues());
    }

    public IPromptDefinitionValue[] getLocationDefinitions(IPromptDefinitionValue[] definitions) {
        if (LOCATION_TRANSFORM.equals(this.m_sLocation)) {
            IPromptDefinitionValue[] def1 = this.getPromptDefinitionsWithUserInfo(definitions, LOCATION, LOCATION_TRANSFORM);
            IPromptDefinitionValue[] def2 = this.getPromptDefinitionsWithUserInfo(definitions, LOCATION, "Both");
            definitions = this.combineArrays(def1, def2);
        } else if (LOCATION_TABLE.equals(this.m_sLocation)) {
            IPromptDefinitionValue[] def1 = this.getPromptDefinitionsWithUserInfo(definitions, LOCATION, LOCATION_TABLE);
            IPromptDefinitionValue[] def2 = this.getPromptDefinitionsWithUserInfo(definitions, LOCATION, "Both");
            definitions = this.combineArrays(def1, def2);
        } else if (LOCATION_TRANSFORM_SPECIFIC.equals(this.m_sLocation)) {
            definitions = this.getPromptDefinitionsWithUserInfo(definitions, LOCATION, LOCATION_TRANSFORM_SPECIFIC);
        }
        return definitions;
    }

    private void setVisiblePrompts() {
        this.showAllDefinitions();
        if (LOCATION_TRANSFORM.equals(this.m_sLocation)) {
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(LOCATION, LOCATION_TABLE), true);
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(LOCATION, LOCATION_TRANSFORM_SPECIFIC), true);
        } else if (LOCATION_TABLE.equals(this.m_sLocation)) {
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(LOCATION, LOCATION_TRANSFORM), true);
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(LOCATION, LOCATION_TRANSFORM_SPECIFIC), true);
        } else if (LOCATION_TRANSFORM_SPECIFIC.equals(this.m_sLocation)) {
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(LOCATION, LOCATION_TABLE), true);
        }
        if (ACCESS_TYPE_READ.equals(this.m_sAccessType)) {
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, ACCESS_TYPE_WRITE), true);
        } else if (ACCESS_TYPE_WRITE.equals(this.m_sAccessType)) {
            this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, ACCESS_TYPE_READ), true);
        }
        this.setPromptDefinitionsHidden(this.getPromptDefinitionsWithUserInfo(MEMBER_TYPE, this.m_table != null ? (this.m_table.isView() ? MEMBER_TYPE_TABLE : MEMBER_TYPE_VIEW) : MEMBER_TYPE_TABLE), true);
    }

    protected String getMemberType() {
        return this.m_table != null ? (this.m_table.isView() ? MEMBER_TYPE_VIEW : MEMBER_TYPE_TABLE) : MEMBER_TYPE_TABLE;
    }

    private IPromptDefinitionValue[] combineArrays(IPromptDefinitionValue[] ar1, IPromptDefinitionValue[] ar2) {
        IPromptDefinitionValue[] retArray = new IPromptDefinitionValue[ar1.length + ar2.length];
        System.arraycopy(ar1, 0, retArray, 0, ar1.length);
        System.arraycopy(ar2, 0, retArray, ar1.length, ar2.length);
        return retArray;
    }

    protected IPromptDefinitionValue[] getMemberTypeOptions() {
        IPromptDefinitionValue[] membertype = this.getPromptDefinitionsWithUserInfo(MEMBER_TYPE, this.getMemberType());
        IPromptDefinitionValue[] both = this.getPromptDefinitionsWithUserInfo(MEMBER_TYPE, "Both");
        return this.combineArrays(membertype, both);
    }

    protected IPromptDefinitionValue[] getMemberTypeOptions(IPromptDefinitionValue[] definitions) {
        IPromptDefinitionValue[] membertype = this.getPromptDefinitionsWithUserInfo(definitions, MEMBER_TYPE, this.getMemberType());
        IPromptDefinitionValue[] both = this.getPromptDefinitionsWithUserInfo(definitions, MEMBER_TYPE, "Both");
        return this.combineArrays(membertype, both);
    }

    public IPromptDefinitionValue[] getAccessReadOptions() {
        return this.getAccessReadOptions(this.getPromptDefinitionValues());
    }

    public IPromptDefinitionValue[] getAccessReadOptions(IPromptDefinitionValue[] definitions) {
        IPromptDefinitionValue[] readonly = this.getPromptDefinitionsWithUserInfo(definitions, ACCESS_TYPE, ACCESS_TYPE_READ);
        IPromptDefinitionValue[] both = this.getPromptDefinitionsWithUserInfo(definitions, ACCESS_TYPE, "Both");
        return this.getMemberTypeOptions(this.combineArrays(readonly, both));
    }

    public IPromptDefinitionValue[] getAccessWriteOptions() {
        return this.getAccessWriteOptions(this.getPromptDefinitionValues());
    }

    public IPromptDefinitionValue[] getAccessWriteOptions(IPromptDefinitionValue[] definitions) {
        IPromptDefinitionValue[] write = this.getPromptDefinitionsWithUserInfo(definitions, ACCESS_TYPE, ACCESS_TYPE_WRITE);
        IPromptDefinitionValue[] both = this.getPromptDefinitionsWithUserInfo(definitions, ACCESS_TYPE, "Both");
        return this.getMemberTypeOptions(this.combineArrays(write, both));
    }

    private IPromptDefinitionValue findDBCreate(IPromptDefinitionValue[] definitionValues) {
        for (int i = 0; i < definitionValues.length; ++i) {
            if (!"DBCREATE_TABLE_OPTS".equals(definitionValues[i].getName()) || this.getTable().getDBMSType().getDBCreateStatements(this.getTable()).length() <= 0) continue;
            return definitionValues[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes, IPromptDefinitionValue[] definitionValues) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        boolean events;
        IPromptDefinitionValue dbCreate = this.findDBCreate(definitionValues);
        String originalValue = null;
        if (dbCreate != null) {
            originalValue = (String)dbCreate.getValue();
            String newValue = originalValue;
            if (newValue == null) {
                newValue = "";
            }
            newValue = this.getTable().getDBMSType().getDBCreateStatements(this.getTable()) + " " + newValue;
            events = dbCreate.isEventsEnabled();
            try {
                dbCreate.setEnableEvents(false);
                dbCreate.setValue(newValue);
            }
            finally {
                dbCreate.setEnableEvents(events);
            }
        }
        StringBuffer options = new StringBuffer();
        try {
            options = super.getOptionsString(codeSegment, role, useLetStatement, genBlankValues, genPercentLocalStatements, bUseEscapeQuotes, definitionValues);
        }
        finally {
            if (dbCreate != null) {
                events = dbCreate.isEventsEnabled();
                try {
                    dbCreate.setEnableEvents(false);
                    dbCreate.setValue(originalValue);
                }
                finally {
                    dbCreate.setEnableEvents(events);
                }
            }
        }
        return options;
    }

    public IPromptDefinitionValue[] getAccessBothOptions() {
        return this.getMemberTypeOptions(this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, "Both"));
    }

    protected void loadOptions(OMRAdapter omr, String propertySetRole, IPromptDefinitionValue[] definitions) throws MdException, RemoteException {
        if (definitions == null || definitions.length == 0) {
            return;
        }
        this.setUsePropertySet(true);
        this.setSetRole(propertySetRole);
        this.setSaveLocationFlag(0);
        for (int i = 0; i < definitions.length; ++i) {
            this.loadDefinition(omr, definitions[i]);
        }
    }

    @Override
    protected void loadDefinitions(OMRAdapter omr) throws MdException, RemoteException {
        this.loadOptions(omr, PROPERTY_SET_ACCESS_READ, this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, ACCESS_TYPE_READ));
        this.loadOptions(omr, PROPERTY_SET_ACCESS_WRITE, this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, ACCESS_TYPE_WRITE));
        this.resetSaveLocations();
        this.loadDefinitions(omr, this.getAccessBothOptions());
        this.loadLegacyOptions(omr);
    }

    protected void loadLegacyOptions(OMRAdapter omr) throws MdException, RemoteException {
        this.resetSaveLocations();
        this.loadLegacyDefinition(omr, COMPRESS, 1);
        this.loadLegacyDefinition(omr, ENCRYPT, 1);
        this.setUsePropertySet(true);
        this.setSaveLocationFlag(2);
        this.setSetRole("MACROOPTIONS");
        this.loadLegacyDefinition(omr, "SEGSIZE", 2);
        this.loadLegacyDefinition(omr, "ASYNCINDEX", 2);
        this.loadLegacyDefinition(omr, "PARTSIZE", 2);
        this.loadLegacyDefinition(omr, "MAXGEN", 2);
        this.loadLegacyDefinition(omr, "NUMGEN", 2);
        this.loadLegacyDefinition(omr, "GENYEAR", 2);
        this.loadLegacyDefinition(omr, "SYNCADD", 2);
        this.loadLegacyDefinition(omr, "UNIQUESAVE", 2);
        this.loadLegacyDefinition(omr, "IOBLOCKSIZE", 2);
        this.loadLegacyDefinition(omr, "BYNOEQUALS", 2);
        this.loadLegacyDefinition(omr, "NOINDEX", 2);
        this.loadLegacyDefinition(omr, "THREADNUM", 2);
        this.loadLegacyDefinition(omr, "WHERENOINDEX", 2);
        this.loadLegacyDefinition(omr, "ENDOBS", 2);
        this.loadLegacyDefinition(omr, "STARTOBS", 2);
        this.loadLegacyDefinition(omr, "VERBOSE", 2);
        this.loadLegacyDefinition(omr, "NETPACKSIZE", 2);
        this.loadLegacyDefinition(omr, "BYSORT", 2);
    }

    private void loadLegacyDefinition(OMRAdapter omr, String name, int location) throws MdException, RemoteException {
        Property prop = this.findProperty(omr, name, location);
        IPromptDefinitionValue def = this.getPromptDefinitionValue(name);
        if (prop != null && def != null) {
            def.loadFromOMR(omr, prop);
        }
    }

    private void resetSaveLocations() {
        this.setUsePropertySet(false);
        this.setSaveLocationFlag(1);
        this.setSetRole("");
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        this.saveOptions(omr, PROPERTY_SET_ACCESS_READ, this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, ACCESS_TYPE_READ));
        this.saveOptions(omr, PROPERTY_SET_ACCESS_WRITE, this.getPromptDefinitionsWithUserInfo(ACCESS_TYPE, ACCESS_TYPE_WRITE));
        this.resetSaveLocations();
        this.saveDefinitions(omr, this.getAccessBothOptions());
        this.saveLegacyOptions(omr);
        this.setChanged(false);
    }

    protected void saveOptions(OMRAdapter omr, String propertySetRole, IPromptDefinitionValue[] definitions) throws MdException, RemoteException {
        if (definitions == null || definitions.length == 0) {
            return;
        }
        this.setUsePropertySet(true);
        this.setSetRole(propertySetRole);
        this.setSaveLocationFlag(0);
        this.saveDefinitions(omr, definitions);
    }

    protected void saveLegacyOptions(OMRAdapter omr) throws MdException, RemoteException {
        this.resetSaveLocations();
        this.saveLegacyDefinition(omr, COMPRESS, 1);
        this.saveLegacyDefinition(omr, ENCRYPT, 1);
        this.setUsePropertySet(true);
        this.setSaveLocationFlag(2);
        this.setSetRole("MACROOPTIONS");
        this.saveLegacyDefinition(omr, "SEGSIZE", 2);
        this.saveLegacyDefinition(omr, "ASYNCINDEX", 2);
        this.saveLegacyDefinition(omr, "PARTSIZE", 2);
        this.saveLegacyDefinition(omr, "MAXGEN", 2);
        this.saveLegacyDefinition(omr, "NUMGEN", 2);
        this.saveLegacyDefinition(omr, "GENYEAR", 2);
        this.saveLegacyDefinition(omr, "SYNCADD", 2);
        this.saveLegacyDefinition(omr, "UNIQUESAVE", 2);
        this.saveLegacyDefinition(omr, "IOBLOCKSIZE", 2);
        this.saveLegacyDefinition(omr, "BYNOEQUALS", 2);
        this.saveLegacyDefinition(omr, "NOINDEX", 2);
        this.saveLegacyDefinition(omr, "THREADNUM", 2);
        this.saveLegacyDefinition(omr, "WHERENOINDEX", 2);
        this.saveLegacyDefinition(omr, "ENDOBS", 2);
        this.saveLegacyDefinition(omr, "STARTOBS", 2);
        this.saveLegacyDefinition(omr, "VERBOSE", 2);
        this.saveLegacyDefinition(omr, "NETPACKSIZE", 2);
        this.saveLegacyDefinition(omr, "BYSORT", 2);
    }

    private void saveLegacyDefinition(OMRAdapter omr, String name, int flag) throws MdException, RemoteException {
        IPromptDefinitionValue def = this.getPromptDefinitionValue(name);
        Property prop = this.findProperty(omr, name, flag);
        if (def != null && prop != null) {
            this.saveDefinition(omr, def, flag);
        }
    }

    @Override
    protected IPromptModel copyObject(IObject newOwner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new PhysicalTablePromptModel(newOwner.getModel(), newOwner);
    }
}

