/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPasteModify;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.impl.BasePhysicalTable;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.etl.models.job.impl.UIPlacement;
import com.sas.etl.models.job.impl.UIPlacementUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseWorkTable
extends BasePhysicalTable
implements IWorkTable {
    protected static final String UI_PROPERTY = "UI_PLACEMENT";
    private ILibrary m_alternateJobLibrary;
    private IUIPlacement m_UIPlacement;

    public BaseWorkTable(String sID, IModel model) {
        super(sID, model);
        this.setSASTableName(this.createWorkTableName());
    }

    @Override
    protected void postAddConsumerTransform(IDataTransform transform) {
        if (transform != null && transform.getJob() != null) {
            this.setAlternateJobLibrary(transform.getJob().getAlternateTemporaryLibrary());
        }
    }

    @Override
    protected void postAddProducerTransform(IDataTransform transform) {
        if (transform != null && transform.getJob() != null) {
            this.setAlternateJobLibrary(transform.getJob().getAlternateTemporaryLibrary());
        }
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.getUIPlacement().isChanged();
    }

    @Override
    public String getPublicType() {
        return "WorkTable";
    }

    @Override
    public boolean isPublicObject() {
        return false;
    }

    @Override
    public String getOMRType() {
        return "WorkTable";
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public String[] getLocationTypes() {
        return new String[]{"JobAlternate", "None", "Physical"};
    }

    @Override
    protected String getDefaultLocationType() {
        return "JobAlternate";
    }

    @Override
    public String getSASTableName() {
        String tableName = super.getSASTableName();
        if (tableName == null || tableName.length() == 0) {
            this.setSASTableName(this.createWorkTableName());
        }
        return tableName;
    }

    @Override
    public boolean doesNoLibraryMeanIncomplete() {
        return false;
    }

    @Override
    public void setAlternateJobLibrary(ILibrary library) {
        if (library == this.m_alternateJobLibrary) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAlternateJobLibraryUndoable(this.m_alternateJobLibrary, library));
        }
        IDBMSType oldType = this.getDBMSType();
        this.m_alternateJobLibrary = library;
        this.updateTableOptionModel(oldType, this.getDBMSType());
        this.fireModelChangedEvent("IWorkTable:AlternateJobLibraryChanged", library);
        if ("JobAlternate".equals(this.getLocationType())) {
            this.fireModelChangedEvent("PhysicalTable:LibraryChanged", library);
        }
    }

    @Override
    public ILibrary getAlternateJobLibrary() {
        return this.m_alternateJobLibrary;
    }

    @Override
    public String getDBMSProductName() throws BadLibraryDefinitionException {
        return DBMSTypeFactory.getInstance().getDBMSProductName(this.getLibraryForUseInJob());
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, "Location", "LOCATION_TYPE", this.getLocationType());
        this.saveStringOptionToOMR(omr, UI_PROPERTY, UIPlacementUtil.createXMLFromUIPlacement(this.getUIPlacement()));
        this.getUIPlacement().setChanged(false);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setUIPlacement(UIPlacementUtil.createUIPlacementFromXML(this.loadStringOptionFromOMR(omr, UI_PROPERTY, "")));
        this.setChanged(false);
    }

    @Override
    protected void loadSASTableName(OMRAdapter omr) throws MdException, RemoteException {
        PhysicalTable mdoTable = (PhysicalTable)omr.acquireOMRObject(this);
        String sTableName = mdoTable.getSASTableName();
        if (sTableName.length() == 0) {
            sTableName = this.createWorkTableName();
        }
        this.setSASTableName(sTableName);
    }

    @Override
    public String getSBIPUrl() throws MdException {
        String url = "";
        IFolder folder = this.getFolder();
        url = folder != null ? folder.getURLtoFolder() + "/" + this.getName() + "(" + this.getOMRType() + ")" : "/" + this.getName() + "_" + this.getID() + "(" + this.getOMRType() + ")";
        return url;
    }

    @Override
    public ILibrary getLibraryForUseInJob() {
        String location = this.getLocationType();
        if ("None".equals(location)) {
            return null;
        }
        if ("Physical".equals(location)) {
            return this.getLibrary();
        }
        if ("JobAlternate".equals(location)) {
            return this.getAlternateJobLibrary();
        }
        return null;
    }

    @Override
    protected void postSetLocationType() {
        super.postSetLocationType();
        if ("JobAlternate".equals(this.getLocationType()) && this.m_bInLoad) {
            this.setAlternateJobLibrary(this.getLibrary());
        }
    }

    @Override
    public List<IObject> pasteAction() throws MdException, RemoteException {
        this.setSASTableName(this.createWorkTableName());
        this.getUIPlacement().setNodeId(GUID.newGUID());
        return new ArrayList<IObject>();
    }

    @Override
    public List<IPasteModify> getPasteChildObjects() {
        return null;
    }

    @Override
    public IUIPlacement getUIPlacement() {
        if (this.m_UIPlacement == null) {
            this.m_UIPlacement = new UIPlacement();
        }
        return this.m_UIPlacement;
    }

    private void setUIPlacement(IUIPlacement placement) {
        this.m_UIPlacement = placement;
    }

    public void resetOptionModel(OMRAdapter omr) {
        PhysicalTablePromptModelCollection model;
        if ("JobAlternate".equals(this.getLocationType()) && (model = this.getTableOptionCollection()) != null) {
            try {
                model.loadFromOMR(omr);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
    }

    private class SetAlternateJobLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_oldAlternateJobLibrary;
        private ILibrary m_newAlternateJobLibrary;

        public SetAlternateJobLibraryUndoable(ILibrary oldAlternateJobLibrary, ILibrary newAlternateJobLibrary) {
            this.m_oldAlternateJobLibrary = oldAlternateJobLibrary;
            this.m_newAlternateJobLibrary = newAlternateJobLibrary;
        }

        @Override
        public void undo() {
            super.undo();
            BaseWorkTable.this.setAlternateJobLibrary(this.m_oldAlternateJobLibrary);
        }

        @Override
        public void redo() {
            super.redo();
            BaseWorkTable.this.setAlternateJobLibrary(this.m_newAlternateJobLibrary);
        }

        @Override
        public void die() {
            this.m_oldAlternateJobLibrary = null;
            this.m_newAlternateJobLibrary = null;
            super.die();
        }
    }
}

