/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IMessageQueue;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Transformation;
import com.sas.services.information.metadata.OMRMessageQueue;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class BaseMessageQueue
extends AbstractDataObject
implements IMessageQueue {
    private int m_iMQType = 0;
    private String m_sMQManagerName = null;
    private String m_sQueueName = null;
    public static final int MESSAGEQUEUE_TYPE_OTHER = 0;
    public static final int MESSAGEQUEUE_TYPE_WSMQ = 1;
    public static final int MESSAGEQUEUE_TYPE_MSMQ = 2;

    public BaseMessageQueue(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "Transformation";
    }

    @Override
    public String getPublicType() {
        return "MessageQueue";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRMessageQueue.CURRENT_VERSION;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Transformation mdoQueue = (Transformation)omr.acquireOMRObject(this);
        this.loadMQType(mdoQueue);
        this.setChanged(false);
    }

    private void loadMQType(Transformation mdoQueue) throws MdException, RemoteException {
        AssociationList lDCs = mdoQueue.getDeployedComponents();
        DeployedComponent deployedComponent = null;
        if (lDCs != null && lDCs.size() > 0) {
            deployedComponent = (DeployedComponent)lDCs.get(0);
        }
        if (deployedComponent != null) {
            if (deployedComponent.getClassIdentifier().compareToIgnoreCase("MessageQueue.Websphere") == 0) {
                this.setMessageQueueType(1);
                this.setMQManagerName(deployedComponent.getName());
                this.setMessageQueueName(mdoQueue.getName());
            } else if (deployedComponent.getClassIdentifier().compareToIgnoreCase("MessageQueue.MSMQ") == 0) {
                String sQueueName;
                this.setMessageQueueType(2);
                this.setMQManagerName(deployedComponent.getName());
                boolean bPrivate = false;
                AssociationList lProperties = mdoQueue.getProperties();
                for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
                    Property property = (Property)lProperties.get(iProperty);
                    if (property.getPropertyName().compareToIgnoreCase("IsPublicQueue") != 0 || property.getDefaultValue().compareTo("0") != 0) continue;
                    bPrivate = true;
                }
                Machine machine = deployedComponent.getAssociatedMachine();
                String sMachineName = "";
                if (machine != null) {
                    sMachineName = machine.getName();
                }
                if ((sQueueName = mdoQueue.getName()).indexOf("\\") <= 0) {
                    if (bPrivate) {
                        sQueueName = sMachineName + "\\private$\\" + sQueueName;
                    } else if (sMachineName != null && sMachineName.length() > 0) {
                        sQueueName = sMachineName + "\\" + sQueueName;
                    }
                }
                this.setMessageQueueName(sQueueName);
            }
        }
    }

    @Override
    public void setMessageQueueType(int queueType) {
        this.m_iMQType = queueType;
    }

    @Override
    public int getMessageQueueType() {
        return this.m_iMQType;
    }

    @Override
    public void setMQManagerName(String sMQManagerName) {
        this.m_sMQManagerName = sMQManagerName;
    }

    @Override
    public String getMQManagerName() {
        return this.m_sMQManagerName;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Transformation mdoQueue = (Transformation)omr.acquireOMRObject(this);
        mdoQueue.setName(this.getName());
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("DeployedComponents");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        lAssociations.add("CustomAssociations");
        return map;
    }

    @Override
    public String getMessageQueueName() {
        return this.m_sQueueName;
    }

    @Override
    public void setMessageQueueName(String sQueueName) {
        this.m_sQueueName = sQueueName;
    }
}

