/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.AbstractSecondaryAttributeHelper;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.UniqueKey;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseKey
extends AbstractPersistableObject
implements IKey {
    private ModelList m_lColumns = new ModelList(this, new String[]{"Key:ColumnAdded", "Key:ColumnRemoved"}, 1, IColumn.class);
    private boolean m_bPrimary;
    private List m_lAddedForeignKeys;
    private List m_lRemovedForeignKeys;
    private SetTableHelper m_helper = new SetTableHelper();

    public BaseKey(String sID, IModel model) {
        super(sID, model);
        this.m_lAddedForeignKeys = new ArrayList();
        this.m_lRemovedForeignKeys = new ArrayList();
    }

    @Override
    public void setPrimary(boolean bPrimary) {
        if (this.m_bPrimary == bPrimary) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPrimaryUndoable(this.m_bPrimary, bPrimary));
        }
        this.m_bPrimary = bPrimary;
        this.fireModelChangedEvent("Key:PrimaryChanged", null);
    }

    @Override
    public boolean isPrimary() {
        return this.m_bPrimary;
    }

    @Override
    public void setTable(IPhysicalTable table) {
        this.m_helper.set(table);
    }

    @Override
    public IPhysicalTable getTable() {
        return (IPhysicalTable)this.m_helper.get();
    }

    @Override
    public IColumn[] getColumns() {
        return (IColumn[])this.m_lColumns.toArray(new IColumn[this.m_lColumns.size()]);
    }

    @Override
    public List getColumnsList() {
        return this.m_lColumns;
    }

    public void addForeignKeyToAddedList(IForeignKey fKey) {
        if (this.m_lRemovedForeignKeys.contains(fKey)) {
            this.m_lRemovedForeignKeys.remove(fKey);
        }
        this.m_lAddedForeignKeys.add(fKey);
    }

    public void addForeignKeyToRemovedList(IForeignKey fKey) {
        if (this.m_lAddedForeignKeys.contains(fKey)) {
            this.m_lAddedForeignKeys.remove(fKey);
        }
        this.m_lRemovedForeignKeys.add(fKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IForeignKey[] loadForeignKeysFromOMR() throws MdException, RemoteException {
        int iKey;
        ArrayList<IForeignKey> lForeignKeys = new ArrayList<IForeignKey>();
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "loadForeignKeysFromOMR");
        try {
            UniqueKey mdoUK = (UniqueKey)omr.acquireOMRObject(this);
            AssociationList alKeys = mdoUK.getForeignKeys(true);
            for (int iKey2 = 0; iKey2 < alKeys.size(); ++iKey2) {
                ForeignKey mdoFK = (ForeignKey)alKeys.get(iKey2);
                DataTable mdoTable = mdoFK.getTable();
                if (mdoTable != null) {
                    omr.acquireObjectUsingTemplate((Root)mdoTable);
                }
                IForeignKey fKey = (IForeignKey)omr.acquireObject((Root)mdoFK);
                lForeignKeys.add(fKey);
            }
        }
        finally {
            omr.dispose();
        }
        for (iKey = 0; iKey < this.m_lAddedForeignKeys.size(); ++iKey) {
            if (lForeignKeys.contains(this.m_lAddedForeignKeys.get(0))) continue;
            lForeignKeys.add((IForeignKey)this.m_lAddedForeignKeys.get(0));
        }
        for (iKey = 0; iKey < this.m_lRemovedForeignKeys.size(); ++iKey) {
            if (lForeignKeys.contains(this.m_lRemovedForeignKeys.get(0))) continue;
            lForeignKeys.add((IForeignKey)this.m_lRemovedForeignKeys.get(0));
        }
        return lForeignKeys.toArray(new IForeignKey[0]);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && !this.m_lColumns.isEmpty() && this.getTable() != null;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_lColumns.isEmpty()) {
            lReasons.add(RB.getStringResource("BaseKey.IncompleteMissingColumns.msg.txt"));
        }
        if (this.getTable() == null) {
            lReasons.add(RB.getStringResource("BaseKey.IncompleteMissingTable.msg.txt"));
        }
        return lReasons;
    }

    @Override
    public String getOMRType() {
        return "UniqueKey";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        UniqueKey mdoKey = (UniqueKey)omr.acquireOMRObject(this);
        mdoKey.setIsPrimary(this.m_bPrimary ? 1 : 0);
        this.m_lColumns.saveToOMR(omr, (List)mdoKey.getKeyedColumns(false));
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        UniqueKey mdoKey = (UniqueKey)omr.acquireOMRObject(this);
        this.m_bPrimary = mdoKey.getIsPrimary() == 1;
        this.m_lColumns.loadFromOMR(omr, (List)mdoKey.getKeyedColumns());
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("UniqueKey");
        lAssociations.add("KeyedColumns");
        return map;
    }

    @Override
    public void copy(IKey key) {
        this.startCompoundUndoable();
        try {
            key.setDescription(this.getDescription());
            key.setName(this.getName());
            key.setPrimary(this.isPrimary());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private class SetPrimaryUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldPrimary;
        private boolean m_newPrimary;

        public SetPrimaryUndoable(boolean oldPrimary, boolean newPrimary) {
            this.m_oldPrimary = oldPrimary;
            this.m_newPrimary = newPrimary;
        }

        @Override
        public void undo() {
            super.undo();
            BaseKey.this.setPrimary(this.m_oldPrimary);
        }

        @Override
        public void redo() {
            super.redo();
            BaseKey.this.setPrimary(this.m_newPrimary);
        }
    }

    private class SetTableHelper
    extends AbstractSecondaryAttributeHelper {
        public SetTableHelper() {
            super(BaseKey.this);
        }

        @Override
        protected void addTo(IObject primary) {
            ((IPhysicalTable)primary).getKeysList().add(BaseKey.this);
        }

        @Override
        protected void removeFrom(IObject primary) {
            ((IPhysicalTable)primary).getKeysList().remove(BaseKey.this);
        }
    }
}

