/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ObjectComparator;
import java.util.ArrayList;
import java.util.List;

public class BaseGeneratedTableColumn
implements IGeneratedTableColumn {
    private String _id;
    private IGeneratedTable<?> m_table;
    private String _name;
    private String _desc;
    private int _sasType;
    private int _sasLength;
    private String _format;
    private String _informat;

    public BaseGeneratedTableColumn(IGeneratedTable<?> table, String sID) {
        this.setTable(table);
        this.setID(sID);
        this.setFormat("");
        this.setInformat("");
    }

    @Override
    public String getFormat() {
        return this._format;
    }

    @Override
    public void setFormat(String format) {
        if (format == null) {
            format = "";
        }
        this._format = format;
    }

    @Override
    public String getInformat() {
        return this._informat;
    }

    @Override
    public void setInformat(String informat) {
        if (informat == null) {
            informat = "";
        }
        this._informat = informat;
    }

    @Override
    public void setSASLength(int length) {
        this._sasLength = length;
    }

    @Override
    public int getSASLength() {
        return this._sasLength;
    }

    @Override
    public void setDescription(String desc) {
        this._desc = desc;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    public void setTable(IGeneratedTable<?> tbl) {
        this.m_table = tbl;
    }

    @Override
    public IGeneratedTable<?> getTable() {
        return this.m_table;
    }

    private void setID(String id) {
        this._id = id;
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getSASType() {
        return this._sasType;
    }

    @Override
    public void setSASType(int type) {
        this._sasType = type;
    }

    @Override
    public boolean isComplete(IColumn column) {
        return true;
    }

    @Override
    public List getReasonsIncomplete(IColumn column) {
        return new ArrayList();
    }

    @Override
    public IColumn createNewColumn(IModel model, String containerId, IPhysicalTable sourceTable) {
        IColumn sourceColumn;
        IColumn c = model.getObjectFactory().createNewColumn(containerId);
        String columnName = this.getName();
        c.setName(columnName);
        c.setDescription(this.getDescription());
        IColumn iColumn = sourceColumn = sourceTable != null ? sourceTable.getColumnWithMatchingName(columnName) : null;
        if (sourceColumn == null) {
            c.setType(this.getSASType());
            c.setFormat(this.getFormat());
            c.setInformat(this.getInformat());
            c.setLength(this.getSASLength());
        } else {
            c.setType(sourceColumn.getType());
            c.setLength(sourceColumn.getLength());
            c.setDescription(sourceColumn.getDescription());
            c.setFormat(sourceColumn.getFormat());
            c.setInformat(sourceColumn.getInformat());
        }
        return c;
    }

    @Override
    public boolean equals(IColumn column) {
        return column != null && ObjectComparator.isEqual(this.getName(), column.getName()) && this.getSASType() == column.getType() && this.getSASLength() == column.getLength();
    }

    public int hashcode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

