/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.AbstractSecondaryAttributeHelper;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.UniqueKey;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseForeignKey
extends AbstractPersistableObject
implements IForeignKey {
    private IKey m_partnerKey;
    private List m_lColumnPairs = new ArrayList();
    private List m_lOldKAs = new ArrayList();
    private SetTableHelper m_helper = new SetTableHelper();

    public BaseForeignKey(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public IKey getPartnerKey() {
        return this.m_partnerKey;
    }

    @Override
    public void setPartnerKey(IKey partnerKey) {
        if (partnerKey == this.m_partnerKey) {
            return;
        }
        this.setPartnerKeyImpl(partnerKey);
    }

    private void setPartnerKeyImpl(IKey partnerKey) {
        this.startCompoundUndoable();
        try {
            this.removeAllKeyColumns();
            if (this.m_partnerKey != null) {
                this.m_partnerKey.removeNotifyListener(this);
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetPartnerKeyUndoable(this.m_partnerKey, partnerKey));
            }
            this.m_partnerKey = partnerKey;
            if (this.m_partnerKey != null) {
                this.m_partnerKey.addNotifyListener(this);
            }
            this.fireModelChangedEvent("ForeignKey:PartnerKeyChanged", partnerKey);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IKey loadPartnerKeyFromOMR() throws MdException, RemoteException {
        if (this.m_partnerKey == null) {
            return null;
        }
        if (this.m_partnerKey.getTable() != null) {
            return this.m_partnerKey;
        }
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "loadPartnerKeyFromOMR");
        try {
            UniqueKey mdoUK = (UniqueKey)omr.acquireOMRObject(this.m_partnerKey);
            DataTable mdoTable = mdoUK.getTable();
            if (mdoTable == null) {
                IKey iKey = null;
                return iKey;
            }
            omr.acquireObjectUsingTemplate((Root)mdoTable);
            IKey iKey = this.m_partnerKey;
            return iKey;
        }
        finally {
            omr.dispose();
        }
    }

    @Override
    public void setTable(IPhysicalTable table) {
        this.m_helper.set(table);
    }

    @Override
    public IPhysicalTable getTable() {
        return (IPhysicalTable)this.m_helper.get();
    }

    @Override
    public IColumn[] getColumns() {
        List lForeignKeyColumns = this.getColumnsList();
        return lForeignKeyColumns.toArray(new IColumn[lForeignKeyColumns.size()]);
    }

    @Override
    public List getColumnsList() {
        if (this.m_lColumnPairs != null) {
            ArrayList<IColumn> lColumns = new ArrayList<IColumn>(this.m_lColumnPairs.size());
            for (int iPair = 0; iPair < this.m_lColumnPairs.size(); ++iPair) {
                ColumnPair pair = (ColumnPair)this.m_lColumnPairs.get(iPair);
                if (pair.m_keyColumn == null) continue;
                lColumns.add(pair.m_keyColumn);
            }
            return lColumns;
        }
        return new ArrayList();
    }

    @Override
    public void addKeyColumn(IColumn partnerColumn, IColumn keyColumn) {
        if (partnerColumn == null) {
            throw new IllegalArgumentException("Partner column can not be null");
        }
        if (keyColumn == null) {
            throw new IllegalArgumentException("Key column can not be null");
        }
        if (this.m_partnerKey == null) {
            throw new IllegalStateException("Partner key must be set on a foreign key before columns may be added");
        }
        if (!this.m_partnerKey.getColumnsList().contains(partnerColumn)) {
            throw new IllegalArgumentException("Partner column is not in partner key");
        }
        if (this.getTable() == null) {
            throw new IllegalStateException("Table must be set on foreign key before columns can be added");
        }
        if (!this.getTable().containsColumn(keyColumn)) {
            throw new IllegalArgumentException("Key column must be in foreign key's table's columns");
        }
        if (this.getKeyColumn(partnerColumn) != null) {
            throw new IllegalArgumentException("A key column has already been added for the partner column");
        }
        if (this.getPartnerKeyColumn(keyColumn) != null) {
            throw new IllegalArgumentException("The key column has already been added to the key");
        }
        this.addKeyColumnImpl(partnerColumn, keyColumn);
    }

    private void addKeyColumnImpl(IColumn partnerColumn, IColumn keyColumn) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddKeyColumnUndoable(partnerColumn, keyColumn));
        }
        this.m_lColumnPairs.add(new ColumnPair(partnerColumn, keyColumn));
        this.fireModelChangedEvent("ForeignKey:ColumnAdded", keyColumn, partnerColumn);
    }

    @Override
    public void replaceKeyColumn(IColumn partnerColumn, IColumn keyColumn) {
        if (partnerColumn == null) {
            throw new IllegalArgumentException("Partner column can not be null");
        }
        if (keyColumn == null) {
            throw new IllegalArgumentException("Key column can not be null");
        }
        if (this.getTable() == null) {
            throw new IllegalStateException("Table must be set on foreign key before columns can be added");
        }
        if (!this.getTable().containsColumn(keyColumn)) {
            throw new IllegalArgumentException("Key column must be in foreign key's table's columns");
        }
        if (this.getPartnerKeyColumn(keyColumn) != null) {
            throw new IllegalArgumentException("The key column has already been added to the key");
        }
        ColumnPair pair = this.getPairForPartnerColumn(partnerColumn);
        if (pair == null) {
            this.addKeyColumn(partnerColumn, keyColumn);
            return;
        }
        if (pair.m_keyColumn == keyColumn) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new ReplaceKeyColumnUndoable(partnerColumn, keyColumn, pair.m_keyColumn));
        }
        pair.m_keyColumn = keyColumn;
        this.fireModelChangedEvent("ForeignKey:ColumnReplaced", keyColumn, partnerColumn);
    }

    @Override
    public IColumn getPartnerKeyColumn(IColumn keyColumn) {
        ColumnPair pair = this.getPairForKeyColumn(keyColumn);
        return pair != null ? pair.m_partnerColumn : null;
    }

    private ColumnPair getPairForKeyColumn(IColumn keyColumn) {
        for (int iPair = 0; iPair < this.m_lColumnPairs.size(); ++iPair) {
            ColumnPair pair = (ColumnPair)this.m_lColumnPairs.get(iPair);
            if (pair.m_keyColumn != keyColumn) continue;
            return pair;
        }
        return null;
    }

    @Override
    public IColumn getKeyColumn(IColumn partnerColumn) {
        ColumnPair pair = this.getPairForPartnerColumn(partnerColumn);
        return pair != null ? pair.m_keyColumn : null;
    }

    private ColumnPair getPairForPartnerColumn(IColumn partnerColumn) {
        for (int iPair = 0; iPair < this.m_lColumnPairs.size(); ++iPair) {
            ColumnPair pair = (ColumnPair)this.m_lColumnPairs.get(iPair);
            if (pair.m_partnerColumn != partnerColumn) continue;
            return pair;
        }
        return null;
    }

    @Override
    public boolean containsKeyColumn(IColumn keyColumn) {
        return this.getPairForKeyColumn(keyColumn) != null;
    }

    @Override
    public void removeKeyColumn(IColumn partnerColumn, IColumn keyColumn) {
        ColumnPair pair = this.getPairForPartnerColumn(partnerColumn);
        if (pair == null) {
            throw new IllegalArgumentException("The partner column key column is not in the key");
        }
        this.removePair(pair);
    }

    private void removePair(ColumnPair pair) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveKeyColumnUndoable(pair.m_partnerColumn, pair.m_keyColumn));
        }
        this.m_lColumnPairs.remove(pair);
        this.fireModelChangedEvent("ForeignKey:ColumnRemoved", pair.m_keyColumn, pair.m_partnerColumn);
    }

    private void removeAllKeyColumns() {
        for (int iPair = 0; iPair < this.m_lColumnPairs.size(); ++iPair) {
            this.removePair((ColumnPair)this.m_lColumnPairs.get(iPair));
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getType() == 0 && ev.getSource() == this.m_partnerKey) {
            this.setPartnerKey(null);
        } else {
            super.notify(ev);
        }
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.getTable() != null && this.m_partnerKey != null && this.arePairsComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getTable() == null || this.m_partnerKey == null || !this.arePairsComplete()) {
            lReasons.add(MessageFormat.format(RB.getStringResource("BaseForeignKey.IncompleteGeneral.msg.txt"), this.getTable().getName()));
        }
        return lReasons;
    }

    private boolean arePairsComplete() {
        for (int iPair = 0; iPair < this.m_lColumnPairs.size(); ++iPair) {
            ColumnPair pair = (ColumnPair)this.m_lColumnPairs.get(iPair);
            if (pair.m_keyColumn != null && pair.m_partnerColumn != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getOMRType() {
        return "ForeignKey";
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        if (!this.isComplete()) {
            throw new IllegalStateException("foreign key must be complete before it can be saved");
        }
        super.saveToOMR(omr);
        ForeignKey mdoKey = (ForeignKey)omr.acquireOMRObject(this);
        if (this.m_partnerKey == null) {
            return;
        }
        mdoKey.setPartnerUniqueKey((UniqueKey)omr.acquireOMRObject(this.m_partnerKey));
        for (int iKA = 0; iKA < this.m_lOldKAs.size(); ++iKA) {
            omr.deleteOMRObject((String)this.m_lOldKAs.get(iKA), "KeyAssociation");
        }
        this.m_lOldKAs.clear();
        AssociationList lKeyedColumns = mdoKey.getKeyedColumns(false);
        lKeyedColumns.clear();
        AssociationList lKAs = mdoKey.getKeyAssociations(false);
        lKAs.clear();
        IColumn[] aPartnerColumns = this.m_partnerKey.getColumns();
        for (int iPartnerColumn = 0; iPartnerColumn < aPartnerColumns.length; ++iPartnerColumn) {
            IColumn partnerColumn = aPartnerColumns[iPartnerColumn];
            IColumn keyColumn = this.getKeyColumn(partnerColumn);
            if (keyColumn == null) continue;
            Column mdoPartnerColumn = (Column)omr.acquireOMRObject(partnerColumn);
            Column mdoKeyColumn = (Column)omr.acquireOMRObject(keyColumn);
            lKeyedColumns.add(mdoKeyColumn);
            KeyAssociation mdoKA = (KeyAssociation)omr.acquireOMRObject(this.createIDForNewObject(), "KeyAssociation");
            lKAs.add(mdoKA);
            mdoKA.setName(partnerColumn.getName() + "." + keyColumn.getName());
            mdoKA.setForeignKeyColumn(mdoKeyColumn);
            mdoKA.setUniqueKeyColumn(mdoPartnerColumn);
            this.m_lOldKAs.add(mdoKA.getFQID());
        }
        this.setChanged(false);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        for (int iKA = 0; iKA < this.m_lOldKAs.size(); ++iKA) {
            this.m_lOldKAs.set(iKA, this.updateSubordinateID((String)this.m_lOldKAs.get(iKA), mapIDs));
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ForeignKey mdoForeignKey = (ForeignKey)omr.acquireOMRObject(this);
        UniqueKey mdoUniqueKey = mdoForeignKey.getPartnerUniqueKey();
        if (mdoUniqueKey != null) {
            this.setPartnerKey((IKey)omr.acquireObject((Root)mdoUniqueKey));
        }
        this.removeAllKeyColumns();
        AssociationList lKeyedColumns = mdoForeignKey.getKeyedColumns();
        if (lKeyedColumns.isEmpty()) {
            return;
        }
        AssociationList lKAs = mdoForeignKey.getKeyAssociations();
        if (lKAs.isEmpty() || lKAs.size() != lKeyedColumns.size() || this.m_partnerKey == null) {
            IColumn[] aPartnerColumns = this.m_partnerKey != null ? this.m_partnerKey.getColumns() : new IColumn[]{};
            for (int iColumn = 0; iColumn < lKeyedColumns.size(); ++iColumn) {
                IColumn keyColumn = (IColumn)omr.acquireObject((Root)((Column)lKeyedColumns.get(iColumn)));
                IColumn partnerColumn = iColumn < aPartnerColumns.length ? aPartnerColumns[iColumn] : null;
                this.addKeyColumnImpl(partnerColumn, keyColumn);
            }
        } else {
            for (int iKA = 0; iKA < lKAs.size(); ++iKA) {
                KeyAssociation mdoKA = (KeyAssociation)lKAs.get(iKA);
                this.m_lOldKAs.add(mdoKA.getFQID());
                Column mdoKeyColumn = mdoKA.getForeignKeyColumn();
                if (mdoKeyColumn == null) continue;
                Column mdoPartnerColumn = mdoKA.getUniqueKeyColumn();
                IColumn partnerColumn = mdoPartnerColumn != null ? (IColumn)omr.acquireObject((Root)mdoPartnerColumn) : null;
                IColumn keyColumn = (IColumn)omr.acquireObject((Root)mdoKeyColumn);
                this.addKeyColumnImpl(partnerColumn, keyColumn);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        for (int iKA = 0; iKA < this.m_lOldKAs.size(); ++iKA) {
            omr.deleteOMRObject((String)this.m_lOldKAs.get(iKA), "KeyAssociation");
        }
        this.m_lOldKAs.clear();
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("ForeignKey");
        lAssociations.add("KeyedColumns");
        lAssociations.add("PartnerUniqueKey");
        lAssociations.add("KeyAssociations");
        lAssociations = new ArrayList<String>();
        lAssociations.add("ForeignKeyColumn");
        lAssociations.add("UniqueKeyColumn");
        map.put("KeyAssociation", lAssociations);
        return map;
    }

    private class ReplaceKeyColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_partnerKeyColumn;
        private IColumn m_oldKeyColumn;
        private IColumn m_newKeyColumn;

        public ReplaceKeyColumnUndoable(IColumn partnerKeyColumn, IColumn newKeyColumn, IColumn oldKeyColumn) {
            this.m_partnerKeyColumn = partnerKeyColumn;
            this.m_oldKeyColumn = oldKeyColumn;
            this.m_newKeyColumn = newKeyColumn;
        }

        @Override
        public void undo() {
            super.undo();
            BaseForeignKey.this.replaceKeyColumn(this.m_partnerKeyColumn, this.m_oldKeyColumn);
        }

        @Override
        public void redo() {
            super.redo();
            BaseForeignKey.this.replaceKeyColumn(this.m_partnerKeyColumn, this.m_newKeyColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldKeyColumn = null;
            this.m_newKeyColumn = null;
            this.m_partnerKeyColumn = null;
        }
    }

    private class RemoveKeyColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_partnerKeyColumn;
        private IColumn m_keyColumn;

        public RemoveKeyColumnUndoable(IColumn partnerKeyColumn, IColumn keyColumn) {
            this.m_partnerKeyColumn = partnerKeyColumn;
            this.m_keyColumn = keyColumn;
        }

        @Override
        public void undo() {
            super.undo();
            BaseForeignKey.this.addKeyColumnImpl(this.m_partnerKeyColumn, this.m_keyColumn);
        }

        @Override
        public void redo() {
            super.redo();
            BaseForeignKey.this.removeKeyColumn(this.m_partnerKeyColumn, this.m_keyColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_keyColumn = null;
            this.m_partnerKeyColumn = null;
        }
    }

    private class AddKeyColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_partnerKeyColumn;
        private IColumn m_keyColumn;

        public AddKeyColumnUndoable(IColumn partnerKeyColumn, IColumn keyColumn) {
            this.m_partnerKeyColumn = partnerKeyColumn;
            this.m_keyColumn = keyColumn;
        }

        @Override
        public void undo() {
            super.undo();
            BaseForeignKey.this.removeKeyColumn(this.m_partnerKeyColumn, this.m_keyColumn);
        }

        @Override
        public void redo() {
            super.redo();
            BaseForeignKey.this.addKeyColumnImpl(this.m_partnerKeyColumn, this.m_keyColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_keyColumn = null;
            this.m_partnerKeyColumn = null;
        }
    }

    private class SetPartnerKeyUndoable
    extends AbstractUndoableEdit {
        private IKey m_oldPartnerKey;
        private IKey m_newPartnerKey;

        public SetPartnerKeyUndoable(IKey oldPartnerKey, IKey newPartnerKey) {
            this.m_oldPartnerKey = oldPartnerKey;
            this.m_newPartnerKey = newPartnerKey;
        }

        @Override
        public void undo() {
            super.undo();
            BaseForeignKey.this.setPartnerKeyImpl(this.m_oldPartnerKey);
        }

        @Override
        public void redo() {
            super.redo();
            BaseForeignKey.this.setPartnerKeyImpl(this.m_newPartnerKey);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldPartnerKey = null;
            this.m_newPartnerKey = null;
        }
    }

    private static class ColumnPair {
        private IColumn m_partnerColumn;
        private IColumn m_keyColumn;

        public ColumnPair(IColumn partnerColumn, IColumn keyColumn) {
            this.m_partnerColumn = partnerColumn;
            this.m_keyColumn = keyColumn;
        }
    }

    private class SetTableHelper
    extends AbstractSecondaryAttributeHelper {
        public SetTableHelper() {
            super(BaseForeignKey.this);
        }

        @Override
        protected void addTo(IObject primary) {
            ((IPhysicalTable)primary).getForeignKeysList().add(BaseForeignKey.this);
        }

        @Override
        protected void removeFrom(IObject primary) {
            ((IPhysicalTable)primary).getForeignKeysList().remove(BaseForeignKey.this);
        }
    }
}

