/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseDocument
extends AbstractDataObject
implements IDocument {
    private String m_sURI = "";
    private String m_sTextRole = "";

    public BaseDocument(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setURI(String sURI) {
        if (sURI == null) {
            throw new IllegalArgumentException("sURI can not be null");
        }
        if (this.m_sURI.equals(sURI)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetURIUndoable(this.m_sURI, sURI));
        }
        this.m_sURI = sURI;
        this.fireModelChangedEvent("Document:URIChanged", null);
    }

    @Override
    public String getURI() {
        return this.m_sURI;
    }

    @Override
    public void setTextRole(String sTextRole) {
        if (sTextRole == null) {
            throw new IllegalArgumentException("sTextRole can not be null");
        }
        String old = this.m_sTextRole;
        if (this.m_sTextRole.equals(sTextRole)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetURIUndoable(this.m_sTextRole, old));
        }
        this.m_sTextRole = sTextRole;
        this.fireModelChangedEvent("Document:TextRoleChanged", this.m_sTextRole, old);
    }

    @Override
    public String getTextRole() {
        return this.m_sTextRole;
    }

    @Override
    public String getOMRType() {
        return "Document";
    }

    @Override
    public String getPublicType() {
        return "Document";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRDocument.CURRENT_VERSION;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Document mdo = (Document)omr.acquireOMRObject(this);
        mdo.setURI(this.getURI());
        mdo.setTextRole(this.getTextRole());
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Document mdo = (Document)omr.acquireOMRObject(this);
        this.setURI(mdo.getURI());
        this.setTextRole(mdo.getTextRole());
        this.setChanged(false);
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    private class SetTextRoleUndoable
    extends AbstractUndoableEdit {
        private String m_sOldTextRole;
        private String m_sNewTextRole;

        public SetTextRoleUndoable(String sOldTextRole, String sNewTextRole) {
            this.m_sOldTextRole = sOldTextRole;
            this.m_sNewTextRole = sNewTextRole;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDocument.this.setTextRole(this.m_sOldTextRole);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDocument.this.setTextRole(this.m_sNewTextRole);
        }
    }

    private class SetURIUndoable
    extends AbstractUndoableEdit {
        private String m_sOldURI;
        private String m_sNewURI;

        public SetURIUndoable(String sOldURI, String sNewURI) {
            this.m_sOldURI = sOldURI;
            this.m_sNewURI = sNewURI;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDocument.this.setURI(this.m_sOldURI);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDocument.this.setURI(this.m_sNewURI);
        }
    }
}

