/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IDirectory;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseDirectory
extends AbstractPersistableObject
implements IDirectory {
    private String m_strDirectoryName = "";
    private boolean m_bRelative = false;
    private String m_strDirectoryRole = "";

    public BaseDirectory(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDirectoryName() {
        return this.m_strDirectoryName;
    }

    @Override
    public void setDirectoryName(String newDirectoryName) {
        if (this.m_strDirectoryName.equals(newDirectoryName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDirectoryNameUndoable(this.m_strDirectoryName, newDirectoryName));
        }
        this.m_strDirectoryName = newDirectoryName;
        this.fireModelChangedEvent("IDirectory:DirectoryNameChanged", this.m_strDirectoryName);
    }

    @Override
    public String getDirectoryRole() {
        return this.m_strDirectoryRole;
    }

    @Override
    public void setDirectoryRole(String newDirectoryRole) {
        if (this.m_strDirectoryRole.equals(newDirectoryRole)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDirectoryRoleUndoable(this.m_strDirectoryRole, newDirectoryRole));
        }
        this.m_strDirectoryRole = newDirectoryRole;
        this.fireModelChangedEvent("IDirectory:DirectoryRoleChanged", this.m_strDirectoryRole);
    }

    @Override
    public boolean isRelative() {
        return this.m_bRelative;
    }

    public void setRelative(boolean isRelative) {
        if (this.m_bRelative == isRelative) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRelativeUndoable(this.m_bRelative, isRelative));
        }
        this.m_bRelative = isRelative;
        this.fireModelChangedEvent("IDirectory:Relativehanged", null);
    }

    @Override
    public String getOMRType() {
        return "Directory";
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Directory mdoDirectory = (Directory)omr.acquireOMRObject(this);
        this.setDirectoryName(mdoDirectory.getDirectoryName());
        this.setDirectoryRole(mdoDirectory.getDirectoryRole());
        this.setRelative(mdoDirectory.getIsRelative() == 1);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Directory mdoDirectory = (Directory)omr.acquireOMRObject(this);
        mdoDirectory.setDirectoryName(this.getDirectoryName());
        mdoDirectory.setDirectoryRole(this.getDirectoryRole());
        mdoDirectory.setIsRelative(this.isRelative() ? 1 : 0);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("Directory");
        lAssociations.add("DeployedComponents");
        return map;
    }

    private class SetRelativeUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldRelative;
        private boolean m_newRelative;

        public SetRelativeUndoable(boolean oldRelative, boolean newRelative) {
            this.m_oldRelative = oldRelative;
            this.m_newRelative = newRelative;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDirectory.this.setRelative(this.m_oldRelative);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDirectory.this.setRelative(this.m_newRelative);
        }
    }

    private class SetDirectoryRoleUndoable
    extends AbstractUndoableEdit {
        private String m_oldRole;
        private String m_newRole;

        public SetDirectoryRoleUndoable(String oldRole, String newRole) {
            this.m_oldRole = oldRole;
            this.m_newRole = newRole;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDirectory.this.setDirectoryRole(this.m_oldRole);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDirectory.this.setDirectoryRole(this.m_newRole);
        }
    }

    private class SetDirectoryNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldName;
        private String m_newName;

        public SetDirectoryNameUndoable(String oldName, String newName) {
            this.m_oldName = oldName;
            this.m_newName = newName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDirectory.this.setDirectoryName(this.m_oldName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDirectory.this.setDirectoryName(this.m_newName);
        }
    }
}

