/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.ICube;
import com.sas.etl.models.data.IOlapSchema;
import com.sas.etl.models.impl.AbstractComplexPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Root;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Map;

public class BaseCube
extends AbstractComplexPersistableObject
implements ICube {
    private String m_strCubeName = "";
    private String m_strCubeType = "";
    private IOlapSchema m_olapSchema;

    public BaseCube(String sId, IModel model) {
        super(sId, model);
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return null;
    }

    public String getPublicType() {
        return "Cube";
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Cube";
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Cube cube = (Cube)omr.acquireOMRObject(this);
        this.setCubeName(cube.getCubeName());
        this.setCubeType(cube.getCubeType());
        OLAPSchema schema = cube.getAssociatedOLAPSchema();
        if (schema != null) {
            this.setSchema((IOlapSchema)omr.acquireObject((Root)schema));
        }
    }

    @Override
    public void setCubeName(String cubeName) {
        if (this.m_strCubeName.equals(cubeName)) {
            return;
        }
        this.m_strCubeName = cubeName;
    }

    @Override
    public String getCubeName() {
        return this.m_strCubeName;
    }

    @Override
    public void setCubeType(String cubeType) {
        if (this.m_strCubeType.equals(cubeType)) {
            return;
        }
        this.m_strCubeType = cubeType;
    }

    @Override
    public String getCubeType() {
        return this.m_strCubeType;
    }

    @Override
    public IOlapSchema getSchema() {
        return this.m_olapSchema;
    }

    @Override
    public void setSchema(IOlapSchema schema) {
        if (this.m_olapSchema == schema) {
            return;
        }
        this.m_olapSchema = schema;
    }
}

