/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IRole;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.impl.AbstractPrimaryModelList;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.DBMSNamesPropertyHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractTable
extends AbstractDataObject
implements ITable {
    protected List m_lColumns = new ColumnsList();
    private boolean m_bView = false;
    private static final String WEB_STREAM_NAME = "ETLS_WEB_STREAM";
    private boolean m_bCaseSensitive;
    private boolean m_bSpecialCharacters;
    private static final String DBMSNAMES = "DBMSNames";
    private static final String CASE = "Case";
    private static final String SPECIAL_CHARS = "SpecChar";
    private static final String NO = "N";
    private static final String YES = "Y";
    private ModelList m_lRoles = new ModelList(this, new String[]{"Table::RoleAdded", "Table::RoleRemoved"}, 1, IRole.class);
    private boolean m_bUseConnectUsing;

    public AbstractTable(String sID, IModel model) {
        super(sID, model);
        this.m_bCaseSensitive = DBMSNamesPropertyHandler.getGlobalCaseValue() == YES;
        this.m_bSpecialCharacters = DBMSNamesPropertyHandler.getGlobalSpecCharValue() == YES;
    }

    @Override
    public int getColumnCount() {
        return this.m_lColumns.size();
    }

    @Override
    public IColumn[] getColumns() {
        return this.m_lColumns.toArray(new IColumn[this.m_lColumns.size()]);
    }

    @Override
    public void addColumn(IColumn column) {
        this.addColumn(this.m_lColumns.size(), column);
    }

    @Override
    public void addColumn(int iColumn, IColumn column) {
        this.m_lColumns.add(iColumn, column);
    }

    @Override
    public void removeColumn(IColumn column) {
        this.m_lColumns.remove(column);
    }

    @Override
    public void notify(NotifyEvent ev) {
        Object source = ev.getSource();
        if (source instanceof IColumn) {
            this.fireNotifyEvent(1, ev.getModelEvent());
        } else {
            super.notify(ev);
        }
    }

    @Override
    public void moveColumn(IColumn column, int iTo) {
        ((ModelList)this.m_lColumns).move(column, iTo);
    }

    @Override
    public int indexOfColumn(IColumn column) {
        return this.m_lColumns.indexOf(column);
    }

    @Override
    public boolean containsColumn(IColumn column) {
        return this.m_lColumns.contains(column);
    }

    @Override
    public boolean containsColumnOfType(int columnType) {
        IColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getType() != columnType) continue;
            return true;
        }
        return false;
    }

    @Override
    public IColumn getColumnWithMatchingName(String columnName) {
        IColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].equalsName(columnName, this.isQuoted())) continue;
            return cols[i];
        }
        return null;
    }

    @Override
    public IColumn getColumnWithMatchingName(String columnName, boolean useCase) {
        return AbstractTable.getColumnWithMatchingName(this.getColumns(), columnName, useCase && this.isQuoted());
    }

    public static IColumn getColumnWithMatchingName(IColumn[] cols, String columnName, boolean useCase) {
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].equalsName(columnName, useCase)) continue;
            return cols[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnmappedColumns() {
        this.startCompoundUndoable();
        try {
            IColumn[] aColumns = this.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                boolean bMapped = false;
                IDataTransform[] aConsumerTransforms = this.getConsumerTransforms();
                for (int iTransform = 0; iTransform < aConsumerTransforms.length && !bMapped; ++iTransform) {
                    IMapping[] aMappings = aConsumerTransforms[iTransform].getMappings();
                    for (int iMapping = 0; iMapping < aMappings.length && !bMapped; ++iMapping) {
                        if (!aMappings[iMapping].containsInSources(aColumns[iColumn])) continue;
                        bMapped = true;
                    }
                }
                IDataTransform[] aProducerTransforms = this.getProducerTransforms();
                for (int iTransform = 0; iTransform < aProducerTransforms.length && !bMapped; ++iTransform) {
                    IMapping[] aMappings = aProducerTransforms[iTransform].getMappings();
                    for (int iMapping = 0; iMapping < aMappings.length && !bMapped; ++iMapping) {
                        if (!aMappings[iMapping].containsInTargets(aColumns[iColumn])) continue;
                        bMapped = true;
                    }
                }
                if (bMapped) continue;
                this.removeColumn(aColumns[iColumn]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void setView(boolean bView) {
        if (this.m_bView == bView) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetViewUndoable(bView));
        }
        this.m_bView = bView;
        this.fireModelChangedEvent("Table:ViewChanged", null);
    }

    @Override
    public boolean isView() {
        return this.m_bView;
    }

    @Override
    public boolean isSpecialCharacters() {
        return this.m_bSpecialCharacters;
    }

    @Override
    public void setSpecialCharacters(boolean bSpecialChars) {
        if (this.m_bSpecialCharacters == bSpecialChars) {
            return;
        }
        if (this.isUndoSupported()) {
            this.startCompoundUndoable();
        }
        try {
            if (bSpecialChars && !this.isCaseSensitive()) {
                this.setCaseSensitive(true);
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetSpecialCharsUndoable(bSpecialChars));
            }
        }
        finally {
            if (this.isUndoSupported()) {
                this.endCompoundUndoable();
            }
        }
        this.m_bSpecialCharacters = bSpecialChars;
        this.fireModelChangedEvent("Table:SpecialCharsChanged", null);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.m_bCaseSensitive;
    }

    @Override
    public void setCaseSensitive(boolean bCaseChars) {
        if (this.m_bCaseSensitive == bCaseChars) {
            return;
        }
        if (this.m_bSpecialCharacters && !bCaseChars) {
            throw new UnsupportedOperationException("case-sensitive flag cannot be set to false when special characters flag is true");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCaseUndoable(bCaseChars));
        }
        this.m_bCaseSensitive = bCaseChars;
        this.fireModelChangedEvent("Table:CaseChanged", null);
    }

    @Override
    public boolean isQuoted() {
        return this.isCaseSensitive() || this.isSpecialCharacters();
    }

    @Override
    public String getTableName() {
        return this.getTableName(this.isQuoted(), false);
    }

    @Override
    public String getTableName(boolean quotes, boolean passthru) {
        if (quotes) {
            return DBMSNamesUtil.getQuotedString(this.getName(), passthru);
        }
        return this.getName();
    }

    @Override
    public String getTableName(boolean quotes) {
        return this.getTableName(quotes, false);
    }

    @Override
    public ICodeSegment getGeneratedDefaultParameterCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return super.getGeneratedDefaultParameterCode(codeSegment);
    }

    protected ITransform getTransform() {
        if (this.getConsumerTransforms().length > 0) {
            return this.getConsumerTransforms()[0];
        }
        if (this.getProducerTransforms().length > 0) {
            return this.getProducerTransforms()[0];
        }
        return null;
    }

    @Override
    public IRole[] getRoles() {
        return (IRole[])this.m_lRoles.toArray(new IRole[this.m_lRoles.size()]);
    }

    @Override
    public void addRole(IRole role) {
        this.addRole(this.m_lRoles.size(), role);
    }

    @Override
    public void addRole(int index, IRole role) {
        this.m_lRoles.add(index, role);
    }

    @Override
    public void removeRole(IRole role) {
        this.m_lRoles.remove(role);
    }

    @Override
    public void dump(PrintStream strm) {
        super.dump(strm);
        strm.println("<Columns>");
        for (int iColumn = 0; iColumn < this.m_lColumns.size(); ++iColumn) {
            ((IColumn)this.m_lColumns.get(iColumn)).dump(strm);
        }
        strm.println("</Columns>");
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        for (int iColumn = 0; iColumn < this.m_lColumns.size(); ++iColumn) {
            IColumn column = (IColumn)this.m_lColumns.get(iColumn);
            if (!column.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveXMLToStream(OutputStream strm) throws IOException {
    }

    @Override
    public void loadXMLFromStream(InputStream strm) throws IOException {
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        DataTable mdoTable = (DataTable)omr.acquireOMRObject(this);
        mdoTable.setTableName(this.getName());
        this.saveColumns(omr);
        this.saveRoles(omr);
        this.saveQuotationSettings(omr);
    }

    protected void saveColumns(OMRAdapter omr) throws MdException, RemoteException {
        DataTable mdoTable = (DataTable)omr.acquireOMRObject(this);
        AssociationList lColumns = mdoTable.getColumns(false);
        lColumns.clear();
        for (int iColumn = 0; iColumn < this.m_lColumns.size(); ++iColumn) {
            IColumn column = (IColumn)this.m_lColumns.get(iColumn);
            column.saveToOMR(omr);
            lColumns.add(omr.acquireOMRObject(column));
        }
    }

    protected void saveRoles(OMRAdapter omr) throws MdException, RemoteException {
        DataTable table = (DataTable)omr.acquireOMRObject(this);
        this.m_lRoles.saveToOMR(omr, (List)table.getRoles(false));
    }

    protected void saveQuotationSettings(OMRAdapter omr) throws RemoteException, MdException {
        String caseSetting = this.isCaseSensitive() ? YES : NO;
        String specCharSetting = this.isSpecialCharacters() ? YES : NO;
        this.savePropertyToOMR(omr, DBMSNAMES, CASE, CASE, "", caseSetting, 1, 2);
        this.savePropertyToOMR(omr, DBMSNAMES, SPECIAL_CHARS, SPECIAL_CHARS, "", specCharSetting, 1, 2);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.loadColumns(omr);
        this.loadRoles(omr);
        this.loadQuotationSettings(omr);
        this.setChanged(false);
    }

    protected void loadColumns(OMRAdapter omr) throws MdException, RemoteException {
        DataTable mdoTable = (DataTable)omr.acquireOMRObject(this);
        ((ModelList)this.m_lColumns).loadFromOMR(omr, (List)mdoTable.getColumns());
    }

    protected void loadRoles(OMRAdapter omr) throws MdException, RemoteException {
        DataTable table = (DataTable)omr.acquireOMRObject(this);
        this.m_lRoles.loadFromOMR(omr, (List)table.getRoles());
    }

    protected void loadQuotationSettings(OMRAdapter omr) throws MdException, RemoteException {
        String caseSetting = this.loadPropertyFromOMR(omr, DBMSNAMES, CASE, NO, 2);
        String specCharSetting = this.loadPropertyFromOMR(omr, DBMSNAMES, SPECIAL_CHARS, NO, 2);
        this.setSpecialCharacters(specCharSetting.equalsIgnoreCase(YES));
        this.setCaseSensitive(caseSetting.equalsIgnoreCase(YES));
    }

    @Override
    public void delete() {
        ((ModelList)this.m_lColumns).delete();
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        for (int iColumn = 0; iColumn < this.m_lColumns.size(); ++iColumn) {
            ((IColumn)this.m_lColumns.get(iColumn)).deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("Columns");
        return map;
    }

    @Override
    public boolean isWebStream() {
        IExtendedAttribute[] attributes = this.getExtendedAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!WEB_STREAM_NAME.equalsIgnoreCase(attributes[i].getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsWebStream(boolean isWebStream) {
        IExtendedAttribute[] attributes = this.getExtendedAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!WEB_STREAM_NAME.equalsIgnoreCase(attributes[i].getName())) continue;
            return;
        }
        List extAttrs = this.getExtendedAttributesList();
        this.startCompoundUndoable();
        try {
            IExtendedAttribute attribute = this.getObjectFactory().createNewExtendedAttribute(this.getID());
            attribute.setName(WEB_STREAM_NAME);
            extAttrs.add(attribute);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isWebStreamDataSource() {
        return false;
    }

    @Override
    public boolean isWebStreamDataTarget() {
        return false;
    }

    @Override
    public void setUseConnectUsing(boolean bUseConnectUsing) {
        this.m_bUseConnectUsing = bUseConnectUsing;
    }

    @Override
    public boolean getUseConnectUsing() {
        return this.m_bUseConnectUsing;
    }

    private class SetViewUndoable
    extends AbstractUndoableEdit {
        private boolean m_bNewView;

        public SetViewUndoable(boolean bNewView) {
            this.m_bNewView = bNewView;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTable.this.setView(!this.m_bNewView);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTable.this.setView(this.m_bNewView);
        }
    }

    private class SetCaseUndoable
    extends AbstractUndoableEdit {
        private boolean m_bCase;

        public SetCaseUndoable(boolean bCaseChars) {
            this.m_bCase = bCaseChars;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTable.this.setCaseSensitive(!this.m_bCase);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTable.this.setCaseSensitive(this.m_bCase);
        }
    }

    private class SetSpecialCharsUndoable
    extends AbstractUndoableEdit {
        private boolean m_bSpecialChars;

        public SetSpecialCharsUndoable(boolean bSpecialChars) {
            this.m_bSpecialChars = bSpecialChars;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractTable.this.setSpecialCharacters(!this.m_bSpecialChars);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractTable.this.setSpecialCharacters(this.m_bSpecialChars);
        }
    }

    private class ColumnsList
    extends AbstractPrimaryModelList {
        public ColumnsList() {
            super(AbstractTable.this, new String[]{"Table:ColumnAdded", "Table:ColumnRemoved", "Table:ColumnMoved"}, 3, IColumn.class);
            this.setOwnerNotified(true);
        }

        @Override
        protected void addTo(Object secondary) {
            ((IColumn)secondary).setTable(AbstractTable.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            ((IColumn)secondary).setTable(null);
        }
    }
}

