/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SYBASEType
extends BaseDBMSType {
    private static final String QUOTED_OPTION = "QUOTED_IDENTIFIER";

    public SYBASEType() {
        this.setClusterWord("CLUSTERED");
    }

    @Override
    public int getDBMSTypeID() {
        return 11;
    }

    @Override
    public String getDBMSTypeName() {
        return "Sybase";
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String user;
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, this.m_passthru);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        if (tableName.indexOf(46) > 0) {
            user = "\"" + tableName.substring(0, tableName.indexOf(46)) + "\"";
            tableName = table.getSASTableName();
        } else {
            user = "";
        }
        codeSegment.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct compress ('\"' || table_name || '\".' || index_name) as idxname, \n").addSourceCode("       table_name as tabname, \n").addSourceCode("       translate(substr(left(reverse(index_name)),1,10),'9999999999','1234567890') as systemAdded \n").indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").indent().addSourceCode("(DBMS::Indexes (\"\", \"" + user.trim() + "\", \"" + tableName.trim() + "\"))\n").unIndent().unIndent().unIndent().addSourceCode(" ) having systemAdded ne '9999999999';\n").unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) {
        return codeSegment.addSourceCode("drop index %bquote(&etls_indexName) \n");
    }

    @Override
    public String getIndexName(ICodeSegment codeSegment, IIndex index, boolean passthru) throws CodegenException {
        passthru = true;
        String indexName = super.getIndexName(codeSegment, index, passthru);
        if (indexName.startsWith("'")) {
            indexName = indexName.replaceAll("'", "\"");
        }
        return indexName;
    }

    @Override
    public ICodeSegment genDeleteAll(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        String subsetTableName = DBMSNamesUtil.getTableNamePart(tableName);
        if (subsetTableName == null || subsetTableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("SYBASEType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("truncate table " + subsetTableName + "\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genDeleteAll2(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        String subsetTableName = DBMSNamesUtil.getTableNamePart(tableName);
        if (subsetTableName == null || subsetTableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("SYBASEType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("delete from " + subsetTableName + "\n");
        return codeSegment;
    }

    @Override
    public String getTableNameCustomizedForDBMS(ICodeSegment codeSegment, IPhysicalTable table, String tableName) throws CodegenException, BadLibraryDefinitionException {
        String unQuotedSchemaPlusTableName = table.getDBMSType().getSchemaName(codeSegment.getCurrentServer(), table, false) + "." + DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment, true));
        if (unQuotedSchemaPlusTableName == null || unQuotedSchemaPlusTableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("SYBASEType.NoTableReference.msg.txt"), (IObject)table);
        }
        return unQuotedSchemaPlusTableName;
    }

    @Override
    public String getSQLInsertOptions() {
        return "undo_policy = none";
    }

    @Override
    public String getAdditionalConnectionOptions(ILibrary iLib, String dbmsOptions) throws MdException, RemoteException {
        String retString = "";
        if (dbmsOptions != null && dbmsOptions.toUpperCase().indexOf(QUOTED_OPTION) > -1) {
            return retString;
        }
        List lProps = iLib.getOptionsList();
        for (int i = 0; i < lProps.size(); ++i) {
            String option = "";
            String optValue = "";
            IProperty iProp = (IProperty)lProps.get(i);
            if (!iProp.getUseValueOnly() || (optValue = iProp.getDefaultValue()) == null || optValue.length() == 0 || !(option = iProp.getPropertyName()).equalsIgnoreCase(QUOTED_OPTION) || !"YES".equalsIgnoreCase(optValue)) continue;
            retString = " " + option + iProp.getDelimiter() + optValue;
        }
        return retString;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_SybaseTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_sybase", RB.getStringResource("SYBASEType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

