/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SASType
extends BaseDBMSType {
    private static final String CI_MODEL_TABLE = "work.etls_CITemplate";
    private static final String COMMANDS_WORK_TABLE = "etls_commands";
    private static final String COMPARE_WORK_TABLE1 = "etls_compare1";
    private static final String COMPARE_WORK_TABLE2 = "etls_compare2";
    private static final String CI_FILTER_PRELOAD = "when in ('PRE1','PRE2')";
    private static final String CI_FILTER_POSTLOAD = "when in ('POST1','POST2')";
    private static final String IC_CREATE_COMMAND = "ic create";
    private static final String HAS_PREEXISTING_CONSTRAINTS_MVAR = "etls_hasPreExistingConstraint";
    private static final String HAS_REFERENTIAL_CONSTRAINTS_MVAR = "etls_otherTablesReferToThisTable";
    protected static final String SAS_OPTION_TEMPLATE = "/com/sas/wadmin/visuals/res/Options_SASTable_Template.xml";

    public SASType() {
        this.setPassThroughSupport(false);
        this.setTruncateSupport(false);
        this.setSimulateTruncateSupport(true);
        this.setConstraintTypesDroppable("PUNR");
        this.setMatchingSimpleIndexNameRequired(true);
        this.setRereadExposureRequired(false);
        this.setNotNullIsConstraint(true);
        this.setBulkloadSupported(false);
    }

    @Override
    public int getDBMSTypeID() {
        return 9;
    }

    @Override
    public String getDBMSTypeName() {
        return "SAS";
    }

    @Override
    public ICodeSegment genKeyedLookupStatement(ICodeSegment codeSegment, IPhysicalTable table, IIndex indexForLookup, boolean unique, String allTableOptions) throws CodegenException, BadLibraryDefinitionException {
        String indexName = this.getIndexName(codeSegment, indexForLookup, false);
        if (allTableOptions != null && allTableOptions.length() > 0) {
            codeSegment.addSourceCode("(" + allTableOptions + ")\n");
        }
        codeSegment.indent().addSourceCode("key = ").addSourceCode(indexName);
        if (unique) {
            codeSegment.addSourceCode(" / unique");
        }
        codeSegment.addSourceCode(";\n\n").unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment createIndexes2(ICodeSegment codeSegment, IPhysicalTable table, List indexList, String altTableName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table.isView()) {
            return codeSegment;
        }
        if (indexList == null) {
            indexList = this.getIndexesToCreate(table);
        }
        if (!indexList.isEmpty()) {
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateIndex.msg.notrans"));
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateIndex.note.sasmacro.notrans"));
            String tabname = "";
            String tableDSOptions = "";
            if (altTableName != null && altTableName.length() > 0) {
                tabname = altTableName;
            } else {
                tabname = table.getFullNameQuotedAsNeeded(codeSegment);
                tableDSOptions = table.getReadTableOptions(true);
            }
            String libname = DBMSNamesUtil.getLibrefPart(tabname);
            String tableName = DBMSNamesUtil.getTableNamePart(tabname);
            codeSegment.addSourceCode("proc datasets lib = " + libname + " nolist; \n").indent().addSourceCode("modify " + tableName + tableDSOptions + "; \n").indent();
            for (int i = 0; i < indexList.size(); ++i) {
                IIndex index = (IIndex)indexList.get(i);
                this.createSingleIndex(codeSegment, table, index);
            }
            codeSegment.unIndent().unIndent().addSourceCode("quit; \n\n").genRCSetCall("&syserr");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment createConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table.isView()) {
            return codeSegment;
        }
        List foreignKeysList = table.getForeignKeysList();
        List uniqueKeysList = table.getKeysList();
        List<IColumn> notNullColumnsList = Arrays.asList(this.getNotNullCols(table));
        if (!(notNullColumnsList.isEmpty() && foreignKeysList.isEmpty() && uniqueKeysList.isEmpty())) {
            this.genCreateConstraints(codeSegment, table, "", notNullColumnsList, uniqueKeysList, foreignKeysList);
        }
        return codeSegment;
    }

    public ICodeSegment createSingleIndex(ICodeSegment codeSegment, IPhysicalTable table, IIndex index) throws CodegenException, BadLibraryDefinitionException {
        String indexName = this.getIndexName(codeSegment, index, false);
        List lColumns = index.getColumnsList();
        if (lColumns.size() == 1) {
            IColumn col = (IColumn)lColumns.get(0);
            String colname = this.getIndexColumnName(codeSegment, col);
            if (!colname.equals(indexName)) {
                throw new CodegenException(MessageFormat.format(RB.getStringResource("BaseDBMSType.IndexNoMatch.msg.txt"), indexName, colname), null);
            }
            codeSegment.addSourceCode("index create " + indexName);
        } else if (lColumns.size() > 0) {
            codeSegment.addSourceCode("index create " + indexName + " = ");
            String indexColumns = codeSegment.makeColumnList(lColumns, false, "                ", false, " ", "", codeSegment.isQuoting(), "", false);
            codeSegment.addSourceCode("(" + indexColumns + ")");
        } else {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsOnIndex.msg.txt"), null);
        }
        StringBuffer opts = new StringBuffer("");
        if (index.isUnique()) {
            opts.append(" unique");
        }
        if (index.isNoMissingValues()) {
            opts.append(" nomiss");
        }
        if (opts.length() > 1) {
            codeSegment.addSourceCode("\n").indent().addSourceCode("/" + opts.toString()).unIndent();
        }
        codeSegment.addSourceCode(";\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        boolean quoting;
        String table_opts = this.getIndexTableOptions();
        if (table_opts.length() > 0) {
            table_opts = "(" + table_opts.trim() + ")";
        }
        if (quoting = codeSegment.isQuoting()) {
            codeSegment.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\"n on %bquote(&etls_indexTable)");
        } else {
            codeSegment.addSourceCode("drop index &etls_indexName on &etls_indexTable");
        }
        codeSegment.addSourceCode(" " + table_opts + "\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tabname = table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false);
        String outlib = DBMSNamesUtil.getLibrefPart(tabname).toUpperCase();
        String outmem = DBMSNamesUtil.getTableNamePart(tabname).toUpperCase();
        codeSegment.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct indxname as idxname, \n").addSourceCode("       \"" + tabname + "\" as tabname \n").indent().addSourceCode("from dictionary.indexes \n").indent().addSourceCode("where libname eq \"" + outlib + "\" and memname eq \"" + outmem + "\" \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
        return codeSegment;
    }

    public ICodeSegment genCreateConstraints(ICodeSegment codeSegment, IPhysicalTable table, String altTableName, List notNullColumns, List uniqueKeys, List foreignKeys) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IKey key;
        int i;
        IForeignKey key2;
        int i2;
        String tabname = "";
        String dsOptions = "";
        if (altTableName != null && altTableName.length() > 0) {
            tabname = altTableName;
        } else {
            dsOptions = table.getReadTableOptions(true);
            tabname = table.getFullNameQuotedAsNeeded(codeSegment);
        }
        String libname = DBMSNamesUtil.getLibrefPart(tabname);
        String tableName = DBMSNamesUtil.getTableNamePart(tabname);
        int foreignKeysSize = foreignKeys.size();
        for (i2 = 0; i2 < foreignKeysSize; ++i2) {
            key2 = (IForeignKey)foreignKeys.get(i2);
            try {
                IKey partnerKey = key2.loadPartnerKeyFromOMR();
                if (partnerKey == null) {
                    throw new CodegenException(RB.getStringResource("SASType.NoPartnerKeyReference.msg.txt"), (IObject)table);
                }
                IPhysicalTable keyTable = partnerKey.getTable();
                if (keyTable == null) continue;
                ILibrary lib = keyTable.getCodeGenLibrary(codeSegment.getCurrentServer());
                try {
                    codeSegment = lib.genAccessPath(codeSegment);
                    continue;
                }
                catch (MdException e) {
                    throw new CodegenException((Exception)((Object)e), (IObject)lib);
                }
                catch (BadLibraryDefinitionException e) {
                    throw new CodegenException(e, (IObject)lib);
                }
                catch (BadServerDefinitionException e) {
                    throw new CodegenException(e, (IObject)lib);
                }
                catch (RemoteException e) {
                    throw new CodegenException(e, (IObject)lib);
                }
            }
            catch (MdException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)table);
            }
            catch (RemoteException e) {
                throw new CodegenException(e, (IObject)table);
            }
        }
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateConstraint.msg.notrans"));
        codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateConstraint.note.sasmacro.notrans"));
        codeSegment.addSourceCode("proc datasets library=").addSourceCode(libname).addSourceCode(" nolist;\n");
        codeSegment.indent().addSourceCode("modify ").addSourceCode(tableName).addSourceCode(dsOptions).addSourceCode(";\n").indent();
        for (i2 = 0; i2 < notNullColumns.size(); ++i2) {
            IColumn col = (IColumn)notNullColumns.get(i2);
            String columnName = DBMSNamesUtil.getQuotedColumnName(col, codeSegment.isQuoting(), false);
            codeSegment.addSourceCode("ic create ").addSourceCode("not null (").addSourceCode(columnName).addSourceCode(");\n");
        }
        for (i2 = 0; i2 < foreignKeysSize; ++i2) {
            key2 = (IForeignKey)foreignKeys.get(i2);
            codeSegment.addSourceCode(this.createSingleFKey(codeSegment, key2, IC_CREATE_COMMAND) + ";").addSourceCode("\n");
        }
        int uniqueSize = uniqueKeys.size();
        ArrayList<IKey> uniqKeys = new ArrayList<IKey>();
        IKey primaryKey = null;
        for (i = 0; i < uniqueSize; ++i) {
            key = (IKey)uniqueKeys.get(i);
            if (key.isPrimary()) {
                primaryKey = key;
                continue;
            }
            uniqKeys.add(key);
        }
        if (primaryKey != null) {
            uniqKeys.add(primaryKey);
        }
        for (i = 0; i < uniqueSize; ++i) {
            key = (IKey)uniqKeys.get(i);
            codeSegment.addSourceCode("ic create ");
            IIndex keyIndex = this.getIndexUsedInUniqueKey(table, key);
            if (keyIndex != null) {
                codeSegment.addSourceCode(this.getIndexName(codeSegment, keyIndex, false) + " = ");
            }
            if (key.isPrimary()) {
                codeSegment.addSourceCode("primary key ");
            } else {
                codeSegment.addSourceCode("unique ");
            }
            String colList = codeSegment.makeColumnList(key.getColumnsList(), false, codeSegment.getIndentString() + "   ", false, " ", "", codeSegment.isQuoting(), "", false);
            codeSegment.addSourceCode("(").addSourceCode(colList).addSourceCode(");\n");
        }
        codeSegment.unIndent().unIndent();
        codeSegment.addSourceCode("quit;\n\n");
        codeSegment.genRCSetCall("&syserr");
        return codeSegment;
    }

    @Override
    public StringBuffer createFKeyOptions(ICodeSegment codeSegment, StringBuffer code, IKey partnerKey) throws CodegenException, BadLibraryDefinitionException {
        code.append(" on update Restrict on delete Restrict");
        return code;
    }

    @Override
    public String makeColumnListInDBMSTypeFormat(ICodeSegment codeSegment, List lColumns) throws CodegenException {
        return codeSegment.makeColumnList(lColumns, false, codeSegment.getIndentString() + "   ", false, " ", "", codeSegment.isQuoting(), "", false);
    }

    @Override
    public boolean syncCISetup(ICodeSegment codeSegment, IPhysicalTable table, IIndex indexToKeep, String ciSelected) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        List indexList = this.getIndexesToCreate(table);
        List foreignKeysList = table.getForeignKeysList();
        List uniqueKeysList = table.getKeysList();
        List<IColumn> notNullColumnsList = Arrays.asList(this.getNotNullCols(table));
        if (indexList.size() < 0 && foreignKeysList.size() < 0 && notNullColumnsList.size() < 0 && uniqueKeysList.size() < 0) {
            return false;
        }
        codeSegment.addSourceCode("/* Prepare table to use as model for indexing */ \n").addSourceCode("data work.etls_CITemplate; \n").indent().addSourceCode("set &etls_lastTable" + table.getReadTableOptions(true) + ";\n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n");
        DBMSTypeFactory.getInstance().getDBMSType("SAS").createIndexes2(codeSegment, table, indexList, CI_MODEL_TABLE);
        if (!notNullColumnsList.isEmpty() || !uniqueKeysList.isEmpty()) {
            String tabname = CI_MODEL_TABLE;
            this.genCreateConstraints(codeSegment, table, tabname, notNullColumnsList, uniqueKeysList, new ArrayList());
        }
        this.genCIContentsMacro(codeSegment, table, true, "", "");
        codeSegment.addSourceCode("%etls_CIContents(table=" + tableName + ", workTableOut=" + COMPARE_WORK_TABLE1 + ", inDSOptions=" + table.getReadTableOptions(true) + ");\n").addSourceCode("%etls_CIContents(table=work.etls_CITemplate, workTableOut=etls_compare2);\n\n");
        this.syncCIFKeys(codeSegment, table, COMPARE_WORK_TABLE2, foreignKeysList);
        this.genSyncCICmdsMacro(codeSegment, table, indexToKeep, tableName, CI_MODEL_TABLE, ciSelected);
        codeSegment.addSourceCode("%etls_syncCICmds(physTable=etls_compare1,mdlTable=etls_compare2,workTableOut=etls_commands);\n\n");
        codeSegment.genTableDelete("etls_compare1 etls_compare2");
        return true;
    }

    private ICodeSegment genCIContentsMacro(ICodeSegment codeSegment, IPhysicalTable table, boolean addRecreate, String referentialCheckMacrovar, String referentialMessageType) {
        if (referentialMessageType.equals("")) {
            referentialMessageType = "NOTE:";
        }
        if (!referentialCheckMacrovar.equals("")) {
            codeSegment.addSourceCode("%let " + referentialCheckMacrovar + "=0;\n\n");
        }
        codeSegment.addSourceCode("%macro etls_CIContents(table=,workTableOut=,inDSOptions=);\n").indent().addSourceCode("%put NOTE: Building table listing Constraints and Indexes for: &table;\n").addSourceCode("proc datasets lib=work nolist; delete &workTableOut; quit;\n").addSourceCode("proc contents data=&table&inDSOptions out2=&workTableOut noprint; run;\n\n");
        codeSegment.addSourceCode("%if %sysfunc(exist(&workTableOut)) ne 0 %then %do;\n").indent().addSourceCode("%let _etlsDsid = %sysfunc(open(&workTableOut));\n").addSourceCode("%let _etlsVarnum = %sysfunc(varnum(&_etlsDsid,RECREATE));\n").addSourceCode("%if &_etlsVarnum > 0 %then %do;\n").indent().addSourceCode("%let _etlsRecreateLen = %sysfunc(varlen(&_etlsDsid,&_etlsVarnum)); /* variable length */\n").unIndent().addSourceCode("%end;\n").addSourceCode("%else %let _etlsRecreateLen=5000;\n").addSourceCode("%let rc = %sysfunc(close(&_etlsDsid));\n").unIndent().addSourceCode("%end;\n").addSourceCode("%else %let _etlsRecreateLen=5000; /* Set a default of 5000 for length if the retrieval is not successful */\n\n");
        codeSegment.addSourceCode("data &workTableOut;\n").indent().addSourceCode("length name $60 type $20 icown idxUnique idxNoMiss $3 recreate $&_etlsRecreateLen;\n").addSourceCode("name = '';\n").addSourceCode("type = '';\n").addSourceCode("icown = '';\n").addSourceCode("idxUnique = '';\n").addSourceCode("idxNoMiss = '';\n").addSourceCode("recreate = '';\n").addSourceCode("set &workTableOut;\n").addSourceCode("ref = '';\n");
        if (addRecreate) {
            codeSegment.addSourceCode("length recreate2 $600;").addSourceCode("retain match 0;\n").addSourceCode("drop match;\n").addSourceCode("if _N_ = 1 then match = prxparse(\"s/\\/ Updatecentiles=[0-9]+|Updatecentiles=[0-9]+//\");\n");
        }
        codeSegment.addSourceCode("type=upcase(type);\n");
        codeSegment.addSourceCode("if type eq 'REFERENTIAL' then\n");
        codeSegment.addSourceCode("do;\n");
        codeSegment.indent();
        if (!referentialCheckMacrovar.equals("")) {
            codeSegment.genPutStatement(RB.getStringResource("SASType.ReferentialConstraintFound.msg.txt"), referentialMessageType, "ref", false);
            codeSegment.addSourceCode("call symput('" + referentialCheckMacrovar + "','1');\n");
        }
        codeSegment.addSourceCode("delete;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("if type='INDEX' and ICOwn eq 'YES' then delete;\n");
        if (addRecreate) {
            codeSegment.addSourceCode("\n");
            codeSegment.addSourceCode("CALL PRXCHANGE(match,-1,recreate,recreate2);\n");
        }
        codeSegment.unIndent().addSourceCode("run;\n").genRCSetCall("&syserr").unIndent().addSourceCode("%mend etls_CIContents;\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment dropCI(ICodeSegment codeSegment, IPhysicalTable table, boolean dropC, boolean dropI, IIndex indexToKeep) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        this.genCIContentsMacro(codeSegment, table, false, "", "");
        codeSegment.addSourceCode("%etls_CIContents(table=" + tableName + ", workTableOut=" + COMMANDS_WORK_TABLE + ", inDSOptions=" + table.getReadTableOptions(true) + ");\n\n");
        codeSegment.addSourceCode("data etls_commands; \n").indent().addSourceCode("retain dropC " + (dropC ? 1 : 0) + " dropI " + (dropI ? 1 : 0) + "; /* user choices */ \n").addSourceCode("set etls_commands; \n");
        String indexNameCode = "'||trim(name)||'";
        if (codeSegment.isQuoting()) {
            indexNameCode = "\"'||trim(name)||'\"n";
        }
        codeSegment.addSourceCode("if upcase(type)='INDEX' then command='index delete ").addSourceCode(indexNameCode).addSourceCode(";';\n").addSourceCode("else command='ic delete ").addSourceCode(indexNameCode).addSourceCode(";';\n").addSourceCode("if dropC and upcase(type) ne 'INDEX' then output;\n").addSourceCode("else if dropI and upcase(type) eq 'INDEX'");
        if (indexToKeep != null) {
            codeSegment.addSourceCode(" and name ne \"" + indexToKeep.getName() + "\"");
        }
        codeSegment.addSourceCode(" then output;\n").unIndent().addSourceCode("run; \n\n");
        this.executeProcDatasetsCmds(codeSegment, table, COMMANDS_WORK_TABLE, "", "");
        codeSegment.genTableDelete(COMMANDS_WORK_TABLE);
        return codeSegment;
    }

    @Override
    public ICodeSegment syncCIPreLoad(ICodeSegment codeSegment, IPhysicalTable table, boolean cOFFBefore, boolean cONBefore, boolean iOFFBefore, boolean iONBefore) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.executeProcDatasetsCmds(codeSegment, table, COMMANDS_WORK_TABLE, CI_FILTER_PRELOAD, "");
    }

    @Override
    public ICodeSegment syncCIPostLoad(ICodeSegment codeSegment, IPhysicalTable table, IIndex indexToKeep, boolean cOFFBefore, boolean cONAfter, boolean cOFFAfter, boolean iOFFBefore, boolean iONAfter, boolean iOFFAfter) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.executeProcDatasetsCmds(codeSegment, table, COMMANDS_WORK_TABLE, CI_FILTER_POSTLOAD, "");
    }

    private void syncCIFKeys(ICodeSegment codeSegment, IPhysicalTable table, String commandTable, List foreignKeys) throws CodegenException, BadLibraryDefinitionException {
        IForeignKey key;
        int i;
        int foreignKeysSize = foreignKeys.size();
        for (i = 0; i < foreignKeysSize; ++i) {
            key = (IForeignKey)foreignKeys.get(i);
            try {
                IKey partnerKey = key.loadPartnerKeyFromOMR();
                if (partnerKey == null) {
                    throw new CodegenException(RB.getStringResource("SASType.NoPartnerKeyReference.msg.txt"), (IObject)table);
                }
                IPhysicalTable primKeyTable = partnerKey.getTable();
                if (primKeyTable == null) {
                    throw new CodegenException(RB.getStringResource("SASType.NoPartnerKeyReference.msg.txt"), (IObject)table);
                }
                try {
                    codeSegment = primKeyTable.genAccessPath(codeSegment);
                    continue;
                }
                catch (MdException e) {
                    throw new CodegenException((Exception)((Object)e), (IObject)primKeyTable);
                }
                catch (BadLibraryDefinitionException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
                catch (BadServerDefinitionException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
                catch (RemoteException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
                catch (ServerException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
            }
            catch (RemoteException ex) {
                throw new CodegenException(ex, (IObject)key.getTable());
            }
            catch (MdException ex) {
                throw new CodegenException((Exception)((Object)ex), (IObject)key.getTable());
            }
        }
        if (foreignKeysSize > 0) {
            codeSegment.addSourceCode("data " + commandTable + "; \n").indent().addSourceCode("if 0 then set " + commandTable + "; /* sets correct column lengths */\n").addSourceCode("type = \"foreign key\";\n");
            for (i = 0; i < foreignKeysSize; ++i) {
                key = (IForeignKey)foreignKeys.get(i);
                codeSegment.addSourceCode("recreate =\"").addSourceCode(this.createSingleFKey(codeSegment, key, IC_CREATE_COMMAND).replaceAll("\"", "\"\"")).addSourceCode("\"; \nrecreate2=recreate;\noutput;\n");
            }
            codeSegment.addSourceCode("modify " + commandTable + "; \n");
            codeSegment.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n");
        }
    }

    public ICodeSegment genSyncCICmdsMacro(ICodeSegment codeSegment, IPhysicalTable table, IIndex keepIndex, String targetTable, String modelTable, String ciSelected) throws CodegenException {
        codeSegment.addSourceCode("%macro etls_CIDelete(when);\n").indent().addSourceCode("do;\n").indent();
        if (!codeSegment.isQuoting()) {
            codeSegment.addSourceCode("command=typeCmd||' delete '||trim(name)||';';\n");
        } else {
            codeSegment.addSourceCode("command=typeCmd||' delete \"'||trim(name)||'\"n;';\n");
        }
        codeSegment.addSourceCode("when=\"&when\";\n").addSourceCode("output;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("%mend;\n").addSourceCode("%macro etls_CICreate(when);\n").indent().addSourceCode("do;\n").indent().addSourceCode("command=recreate;\n").addSourceCode("when=\"&when\";\n").addSourceCode("output;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("%mend;\n");
        codeSegment.addSourceCode("%macro etls_syncCICmds(physTable=,mdlTable=,workTableOut=);\n\n").indent().addSourceCode("%let CISelected=" + ciSelected + ";  /* constrainst before/after, misc indexes before/after */ \n\n").addSourceCode("proc sort data=&physTable; by recreate2 name type; run;\n").addSourceCode("proc sort data=&mdlTable; by recreate2 name type; run;\n\n").addSourceCode("data &workTableOut;\n").indent().addSourceCode("merge &physTable(in=inExisting keep=recreate2 type name recreate IdxUnique IdxNoMiss rename=(IdxUnique=IUOld IdxNoMiss=IMOld name=nameOld))\n").addSourceCode("      &mdlTable(in=inToBe keep=recreate2 type name recreate IdxUnique IdxNoMiss name);\n").addSourceCode("by recreate2;\n").addSourceCode("array CISelections(2,2) $8 _temporary_ (&CISelected);\n").addSourceCode("keep command when typeCmd type selPtr isConstraining;\n").addSourceCode("length command $1000 when $6 typeCmd $5;\n").addSourceCode("type=upcase(type);\n");
        codeSegment.addSourceCode("if type='INDEX' then typeCmd='index';\n").addSourceCode("else typeCmd='ic';\n").addSourceCode("if not inToBe then\n").addSourceCode("do;\n").indent().addSourceCode("IdxUnique=IUOld;\n").addSourceCode("IdxNoMiss=IMOld;\n").addSourceCode("name=nameOld;\n").unIndent().addSourceCode("end;\n").addSourceCode("if type='INDEX' then isConstraining=0;\n").addSourceCode("else isConstraining=1;\n").addSourceCode("if isConstraining then selPtr=1;\n").addSourceCode("else selPtr=2;\n").addSourceCode("/* Identify matches */\n").addSourceCode("if inExisting and inToBe and \n").addSourceCode("   ((type ne 'INDEX') or (type='INDEX' and nameOld eq name)) then\n").addSourceCode("do;\n").indent().addSourceCode("if CISelections(selPtr,1) in ('OFF') then %etls_CIDelete(PRE1)\n").addSourceCode("else /* on,asis */ %etls_CICreate(SKIP);\n").addSourceCode("if CISelections(selPtr,2) in ('OFF') and not (CISelections(selPtr,1) in ('OFF')) then %etls_CIDelete(POST1)\n").addSourceCode("else if CISelections(selPtr,2) in ('ON') and CISelections(selPtr,1)='OFF' then %etls_CICreate(POST2)\n").addSourceCode("else /* asis */ %etls_CICreate(SKIP);\n").addSourceCode("return;\n").unIndent().addSourceCode("end;\n").addSourceCode("/* For those that didn't match... clean out any no longer defined... */\n").addSourceCode("/* unless user doesn't want anything changed.                        */\n").addSourceCode("if inExisting then\n").addSourceCode("do;\n").indent().addSourceCode("if CISelections(selPtr,1) in('ASIS') and CISelections(selPtr,2) in('ASIS') then %etls_CICreate(SKIP)\n").addSourceCode("do; \n").indent().addSourceCode("if CISelections(1,1)='ASIS' and CISelections(2,1)='ASIS' then %etls_CIDelete(POST1) \n").addSourceCode("else %etls_CIDelete(PRE1) \n").unIndent().addSourceCode("end; \n").unIndent().addSourceCode("end;\n").addSourceCode("/* Add any not yet defined (or name changed)... */\n").addSourceCode("if inToBe then\n").addSourceCode("do;\n").indent().addSourceCode("if CISelections(selPtr,1) in('ON') then %etls_CICreate(PRE2)\n").addSourceCode("else /* off,asis */ %etls_CICreate(SKIP)\n").addSourceCode("if CISelections(selPtr,2) in('ON') and not (CISelections(selPtr,1) in('ON')) then %etls_CICreate(POST2)\n").addSourceCode("else if CISelections(selPtr,2) in ('OFF') and CISelections(selPtr,1) in ('ON') then %etls_CIDelete(POST2)\n").addSourceCode("else /* asis */ %etls_CICreate(SKIP)\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").addSourceCode("proc sort data=&workTableOut nodupkey; by when isconstraining command; run;\n").unIndent().addSourceCode("%mend etls_syncCICmds;\n");
        return codeSegment;
    }

    public IIndex getIndexUsedInUniqueKey(IPhysicalTable table, IKey uniqKey) throws CodegenException {
        List indexList = table.getIndexesList();
        for (int i = 0; i < indexList.size(); ++i) {
            IIndex index = (IIndex)indexList.get(i);
            if (!table.indexMatchesUniqueKey(index, uniqKey)) continue;
            return index;
        }
        return null;
    }

    protected String getIndexTableOptions() {
        return "";
    }

    @Override
    public String getIndexColumnName(ICodeSegment codeSegment, IColumn column) throws CodegenException {
        String colname = DBMSNamesUtil.getQuotedColumnName(column, codeSegment.isQuoting(), false);
        if (colname == null || colname.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnName.msg.txt"), (IObject)column);
        }
        return colname;
    }

    private ICodeSegment executeProcDatasetsCmds(ICodeSegment codeSegment, IPhysicalTable table, String commandFile, String filter, String tableName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (tableName.equals("")) {
            tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        }
        if (table.getDBMSProductName() == "SPDE") {
            this.dropIndexSQL(codeSegment, table, commandFile, filter);
        } else {
            codeSegment.addSourceCode("data _null_;\n").indent().addSourceCode("set " + commandFile);
            if (!filter.equals("")) {
                codeSegment.addSourceCode("(where=(" + filter + "))");
            }
            codeSegment.addSourceCode(" end=eof;\n").addSourceCode("if _n_=1 then \n").indent().addSourceCode("call execute('proc datasets nolist lib=" + DBMSNamesUtil.getLibrefPart(tableName) + ";modify " + DBMSNamesUtil.getTableNamePart(tableName).replaceAll("'", "''") + table.getReadTableOptions(true).replaceAll("'", "''") + ";');\n").unIndent().addSourceCode("call execute(command);\n").addSourceCode("if eof then call execute('; quit;');\n").unIndent().addSourceCode("run;\n");
        }
        codeSegment.genRCSetCall("&syserr");
        return codeSegment;
    }

    @Override
    public ICodeSegment genBeginSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment genBeginSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table, StringBuffer columnCode) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment genEndSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment genDisconnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteBegin(ICodeSegment codeSegment, IPhysicalTable table, String prefix) {
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteEnd(ICodeSegment codeSegment, IPhysicalTable table, String prefix) throws CodegenException {
        codeSegment.addSourceCode(prefix + "; \n");
        return codeSegment;
    }

    @Override
    public String getDataTableLabel(IPhysicalTable table) {
        String vdesc = null;
        vdesc = table.getDescription();
        if (vdesc == null || vdesc.trim().length() == 0) {
            vdesc = "";
        }
        return vdesc;
    }

    @Override
    public ICodeSegment genLibname(ICodeSegment codeSegment, IPhysicalTable table, boolean resetLibname) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    @Override
    public String getDBNULL(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return "";
    }

    @Override
    public ICodeSegment dropConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        List foreignKeys = table.getForeignKeysList();
        List uniqueKeys = table.getKeysList();
        List<IColumn> notNullColumnsList = Arrays.asList(this.getNotNullCols(table));
        if (!(notNullColumnsList.isEmpty() && foreignKeys.isEmpty() && uniqueKeys.isEmpty())) {
            String tabname = table.getFullNameQuotedAsNeeded(codeSegment);
            String libname = DBMSNamesUtil.getLibrefPart(tabname);
            String tableName = DBMSNamesUtil.getTableNamePart(tabname);
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DropConstraint.msg.notrans"));
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropConstraint.note.sasmacro.notrans"));
            codeSegment.addSourceCode("proc datasets library=").addSourceCode(libname).addSourceCode(" nolist;\n");
            codeSegment.indent().addSourceCode("modify ").addSourceCode(tableName).addSourceCode(table.getReadTableOptions(true)).addSourceCode(";\n").indent();
            codeSegment.addSourceCode("ic delete _all_;\n");
            codeSegment.unIndent().unIndent();
            codeSegment.addSourceCode("quit;\n\n");
            codeSegment.genRCSetCall("&syserr");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genDeleteAll(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("delete * from " + tableName + table.getReadTableOptions(true) + "; \n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genGetNumRows(ICodeSegment codeSegment, String tableName, String tableOptions, String macroVariable) {
        return codeSegment.genGetNumRows(tableName, tableOptions, macroVariable, true);
    }

    @Override
    public String getPreferredReplaceType() {
        return "EntireTable";
    }

    protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        return PromptUtils.combinePromptGroups(PromptUtils.getPromptGroupFromFile(this.getClass().getResource("res/Options_SASTable_Template.xml")), this.getPromptGroupGeneral());
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(this.getPromptGroup());
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = new PhysicalTablePromptModelCollection();
        collection.addModel(optionModel, "table_options_sas", RB.getStringResource("BaseDBMSType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }

    @Override
    public ICodeSegment genReplaceEntireTable(ICodeSegment codeSegment, IPhysicalTable table, boolean bConstraintEnabled, boolean bCreateConstraints, boolean bCreateIndexes, String dataTableOptions, boolean bRecreateConstraintsASIS, ITransform callingTransform) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSourceCode("%if &etls_tableExist %then \n").addSourceCode("%do;").addCommentLine("table exists").indent();
        if (bRecreateConstraintsASIS) {
            this.replaceTableSimulateTruncate(codeSegment, table, bConstraintEnabled, callingTransform);
        } else {
            this.replaceTableSimple(codeSegment, table, bConstraintEnabled, bCreateConstraints, bCreateIndexes, dataTableOptions, callingTransform);
        }
        this.genCodeConditionCheck(codeSegment, "DIS_CTABLEDROPPED", callingTransform, table);
        codeSegment.unIndent().addSourceCode("%end; ").addCommentLine("table exists").addSourceCode("\n");
        this.create(codeSegment, table, true, bCreateConstraints, bCreateIndexes, true, dataTableOptions, callingTransform);
        return codeSegment;
    }

    public ICodeSegment replaceTableSimulateTruncate(ICodeSegment codeSegment, IPhysicalTable table, boolean constraintEnabled, ITransform callingTransform) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String fullTableName = table.getFullNameQuotedAsNeeded(codeSegment);
        codeSegment.genTableDelete("etls_commands etls_commands_C ");
        codeSegment.addSourceCode("%let etls_hasPreExistingConstraint=0; \n");
        this.genCIContentsMacro(codeSegment, table, true, HAS_REFERENTIAL_CONSTRAINTS_MVAR, "");
        codeSegment.addSourceCode("\n").addSourceCode("%etls_CIContents(table=" + fullTableName + ", workTableOut=" + COMMANDS_WORK_TABLE + ", inDSOptions=" + table.getReadTableOptions(true) + ");\n\n");
        codeSegment.addSourceCode("data etls_commands_C;\n").indent().addSourceCode("set etls_commands; \n");
        codeSegment.addCommentLine(RB.getStringResource("BaseDBMSType.CommandsForReapplyingConstraints.msg.notrans")).addSourceCode("if upcase(type) ne 'INDEX' then \n").addSourceCode("do; \n").indent().addSourceCode("command=recreate;\n").addSourceCode("output etls_commands_C; \n").addSourceCode("call symput('etls_hasPreExistingConstraint','1'); \n").unIndent().addSourceCode("end; \n");
        codeSegment.unIndent().addSourceCode("run; \n\n");
        codeSegment.addSourceCode("%if &etls_otherTablesReferToThisTable %then \n");
        codeSegment.addSourceCode("%do; ").addCommentLine("has referential constraints").addSourceCode("\n").indent();
        if (((TableLoaderTransformModel)callingTransform).getIndexBeforeValue().equals("OFF")) {
            this.dropIndexes(codeSegment, table, null);
        }
        this.genDeleteRowsDueToReferentialConstraints(codeSegment, table);
        this.genCodeConditionCheck(codeSegment, "DIS_CTABLEDROPPED", callingTransform, table);
        codeSegment.unIndent().addSourceCode("%end; ").addCommentLine("has referential constraints").addSourceCode("%else\n").addSourceCode("%do; ").addCommentLine("okay - no referential constraints").addSourceCode("\n").indent();
        this.genDropWithStop(codeSegment, table, "&etls_hasPreExistingConstraint");
        codeSegment.addSourceCode("%if &etls_hasPreExistingConstraint %then \n").addSourceCode("%do; ").addCommentLine("recreating preexisting constraints").addSourceCode("\n").indent().addCommentLine(RB.getStringResource("BaseDBMSType.ReapplyConstraints.msg.notrans"));
        this.executeProcDatasetsCmds(codeSegment, table, "etls_commands_C", "", "");
        codeSegment.genTableDelete("etls_commands_C").unIndent().addSourceCode("%end; ").addCommentLine("recreating preexisting constraints");
        if (((TableLoaderTransformModel)callingTransform).getIndexBeforeValue().equals("ON")) {
            codeSegment.addSourceCode("\n");
            this.createIndexes2(codeSegment, table, null, "");
        }
        codeSegment.unIndent().addSourceCode("%end; ").addCommentLine("okay - no referential constraints").addSourceCode("\n");
        return codeSegment;
    }

    public ICodeSegment replaceTableSimple(ICodeSegment codeSegment, IPhysicalTable table, boolean constraintEnabled, boolean createConstraints, boolean createIndexes, String dataTableOptions, ITransform callingTransform) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String fullTableName = table.getFullNameQuotedAsNeeded(codeSegment);
        codeSegment.addSourceCode("%let etls_hasPreExistingConstraint=0; \n\n");
        codeSegment.genTableDelete("etls_commands etls_commands_F");
        this.genCIContentsMacro(codeSegment, table, false, HAS_REFERENTIAL_CONSTRAINTS_MVAR, "WARNING%QUOTE(:)");
        codeSegment.addSourceCode("\n").addSourceCode("%etls_CIContents(table=" + fullTableName + ", workTableOut=" + COMMANDS_WORK_TABLE + ", inDSOptions=" + table.getReadTableOptions(true) + ");\n\n");
        codeSegment.addSourceCode("%if &etls_otherTablesReferToThisTable %then \n").indent().addSourceCode("%put WARNING%QUOTE(:) Replacing entire table will fail. Consider an alternate load technique or revising constraints.; \n").unIndent().addSourceCode("%else \n").addSourceCode("%do; ").addCommentLine("okay - remove foreign keys").addSourceCode("\n").indent();
        codeSegment.addSourceCode("data etls_commands_F; \n").indent().addSourceCode("set etls_commands; \n").addSourceCode("if upcase(type)=\"FOREIGN KEY\" then \n").addSourceCode("do; \n").indent().addSourceCode("command='ic delete '||trim(name)||';';\n").addSourceCode("output etls_commands_F; \n").unIndent().addSourceCode("end; \n");
        codeSegment.unIndent().addSourceCode("run; \n\n");
        codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.DeleteFKeys.note.sasmacro.notrans"));
        this.executeProcDatasetsCmds(codeSegment, table, "etls_commands_F", "", "");
        codeSegment.unIndent().unIndent().addSourceCode("%end; ").addCommentLine("okay - remove foreign keys").addSourceCode("\n");
        codeSegment.genTableDelete("etls_commands etls_commands_F");
        this.drop(codeSegment, table, true);
        return codeSegment;
    }

    @Override
    public ICodeSegment truncate(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.Truncate.msg.notrans"));
        codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.Truncate.note.sasmacro.notrans"));
        String fullTableName = table.getFullNameQuotedAsNeeded(codeSegment);
        String tableName = DBMSNamesUtil.getTableNamePart(fullTableName);
        String libRef = DBMSNamesUtil.getLibrefPart(fullTableName);
        String constraintTableName = "work.etls_constraints";
        codeSegment.addCommentLine("get the constraints from the table").addSourceCode("proc contents data = " + fullTableName + table.getReadTableOptions(true) + "\n").addSourceCode("              out2 = " + constraintTableName + " \n").addSourceCode("              noprint; \n").addSourceCode("run;\n\n");
        codeSegment.addCommentLine("get the number of constraints (number of rows)");
        codeSegment.genGetNumRows(constraintTableName, null, "etls_hasRows", false, "1");
        codeSegment.addSourceCode("%let ").addSourceCode("etls_numICOwned").addSourceCode(" = 0;\n");
        codeSegment.addSourceCode("%let etls_primaryKey = NO; \n\n").addSourceCode("%if &etls_hasRows %then  \n").addSourceCode("%do;  ").addCommentLine("table has constraints").addSourceCode("\n").indent().addCommentLine("determine if the indexes are owned by any integrity constraint(s)").addSourceCode("proc sql noprint;\n").indent().addSourceCode("select count(*) into :etls_numICOwned \n").indent().addSourceCode(" from ").addSourceCode(constraintTableName).addSourceCode(" where ICOwn = 'YES';\n").unIndent().unIndent().addSourceCode("quit;\n\n").addCommentLine("determine if another table has a foreign key that points to this table").addSourceCode("data " + constraintTableName + "; \n").indent().addSourceCode("set " + constraintTableName + "; \n").addSourceCode("type = upcase(type); \n").addSourceCode("if (type eq \"REFERENTIAL\") then \n").addSourceCode("do; \n").indent().addSourceCode("call symput(\"etls_primaryKey\", \"YES\"); \n").addSourceCode("stop; \n").unIndent().addSourceCode("end; \n\n").addCommentLine("delete any indexes that are created by another constraint").addSourceCode("if (type eq \"INDEX\" and ICOwn eq \"YES\") then \n").indent().addSourceCode("delete; \n").unIndent().unIndent().addSourceCode("run; \n\n").unIndent().addSourceCode("%end; ").addCommentLine("table has constraints").addSourceCode("\n").addSourceCode("%if (&etls_primaryKey eq YES) %then \n").addSourceCode("%do;  ").addCommentLine("table has primary key and referential constraints").addSourceCode("\n").indent();
        this.genDeleteRowsDueToReferentialConstraints(codeSegment, table);
        codeSegment.unIndent().addSourceCode("%end; ").addCommentLine("table has primary key and referential constraints").addSourceCode("\n").addSourceCode("%else \n").addSourceCode("%do;  ").addCommentLine("table does not have a primary key and referential constraints").addSourceCode("\n").indent();
        this.genDropWithStop(codeSegment, table, "&etls_numICOwned gt 0");
        codeSegment.addSourceCode("%if &etls_hasRows %then \n").addSourceCode("%do;  ").addCommentLine("table has constraints").addSourceCode("\n").indent().addCommentLine("Recreate the constraints on the table").addSourceCode("data _null_; \n\n").indent().addSourceCode("set " + constraintTableName + " end=eof; \n\n").addSourceCode("if _n_ eq 1 then \n").addSourceCode("do; \n\n").indent().addSourceCode("call execute(\"proc datasets lib = " + libRef + " nolist;\"); \n").addSourceCode("call execute('   modify " + tableName + table.getReadTableOptions(true).replaceAll("'", "''") + ";'); \n").unIndent().addSourceCode("end; \n\n").addSourceCode("call execute(\"      \" || recreate); \n\n").addSourceCode("if eof then \n").indent().addSourceCode("call execute(\"quit;\"); \n\n").unIndent().unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr").unIndent().addSourceCode("%end; ").addCommentLine("table has constraints").addSourceCode("\n").unIndent().addSourceCode("%end; ").addCommentLine("table does not have a primary key and referential constraints").addSourceCode("\n").genTableDelete(constraintTableName);
        return codeSegment;
    }

    private ICodeSegment genDropWithStop(ICodeSegment codeSegment, IPhysicalTable table, String hasConstraintCondition) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String fullTableName = table.getFullNameQuotedAsNeeded(codeSegment);
        this.genDeleteAllConstraints(codeSegment, table, hasConstraintCondition);
        String readTableDSOptions = table.getReadTableOptions(true);
        String writeTableDSOptions = table.getWriteTableOptions(true, null);
        codeSegment.addCommentLine("Recreate table to physically delete all the records from the table.").addCommentLine("Note: Any revised metadata for the table columns is being ignored.").addSourceCode("data " + fullTableName + writeTableDSOptions + "; \n").indent().addSourceCode("set " + fullTableName + readTableDSOptions + "; \n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
        return codeSegment;
    }

    private ICodeSegment genDeleteAllConstraints(ICodeSegment codeSegment, IPhysicalTable table, String hasConstraintCondition) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String fullTableName = table.getFullNameQuotedAsNeeded(codeSegment);
        String tableName = DBMSNamesUtil.getTableNamePart(fullTableName);
        String libRef = DBMSNamesUtil.getLibrefPart(fullTableName);
        codeSegment.addSourceCode("%if (" + hasConstraintCondition + ") %then\n");
        codeSegment.addSourceCode("%do;  ").addCommentLine("table has constraints").addSourceCode("\n").indent();
        codeSegment.addCommentLine("delete the constraints from the table").addSourceCode("proc datasets lib = " + libRef + " nolist; \n").indent().addSourceCode("modify " + tableName + table.getReadTableOptions(true) + "; \n").indent().addSourceCode("ic delete _all_; \n").unIndent().unIndent().addSourceCode("quit; \n\n").unIndent().addSourceCode("%end; ").addCommentLine("table has constraints").addSourceCode("\n");
        return codeSegment;
    }

    private ICodeSegment genDeleteRowsDueToReferentialConstraints(ICodeSegment codeSegment, IPhysicalTable target) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String warningMessage = "Target table cannot be replaced.  It was found to have referential integrity constraint(s). \nAn attempt will be made to remove all rows. This procedure may fail if the \nconstraints are violated.  Note that if the procedure is successful, the rows \nwill only be logically deleted, not physically deleted.";
        List<String> warnList = codeSegment.splitString(warningMessage, 78, false);
        StringBuffer warningBuffer = new StringBuffer();
        for (int i = 0; i < warnList.size(); ++i) {
            warningBuffer.append("\n    \" ").append(warnList.get(i)).append("\"");
        }
        codeSegment.addSourceCode("data _null_; \n").indent().addSourceCode("put \"WARNING:\"" + warningBuffer.toString() + "; \n").unIndent().addSourceCode("run; \n\n");
        codeSegment.addSourceCode("proc sql;\n").indent();
        this.genDeleteAll(codeSegment, target).unIndent().addSourceCode("quit; \n").genRCSetCall("&sqlrc");
        return codeSegment;
    }

    public ICodeSegment dropIndexSQL(ICodeSegment codeSegment, IPhysicalTable table, String commandFile, String filter) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return null;
    }
}

