/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.OLEDBType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class OLEDBACCESSType
extends BaseDBMSType {
    public OLEDBACCESSType() {
        this.setTruncateSupport(false);
        this.setAddOneKeyPerExecute(true);
        this.setQuoteTypeForPassthru("BACK");
    }

    @Override
    public int getDBMSTypeID() {
        return 6;
    }

    @Override
    public String getDBMSTypeName() {
        return "Access";
    }

    @Override
    public String getConnectionType() {
        return "OLEDB";
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        codeSegment.addSourceCode("drop index `%bquote(&etls_indexName)` on `%bquote(&etls_indexTable)` \n");
        return codeSegment;
    }

    @Override
    public String makeColumnListInDBMSTypeFormat(ICodeSegment codeSegment, List lColumns) throws CodegenException {
        String delimiter = ",";
        String spacesToIndentNextLines = "   ";
        if (lColumns.size() == 0) {
            return "";
        }
        StringBuffer columnString = new StringBuffer();
        for (int i = 0; i < lColumns.size(); ++i) {
            Object obj = lColumns.get(i);
            String columnName = "";
            if (obj instanceof String) {
                columnName = "`" + obj.toString().replaceAll("'", "%str(%')") + "`";
            } else if (obj instanceof IColumn) {
                IColumn column = (IColumn)obj;
                columnName = "`" + column.getColumnName(false).replaceAll("'", "%str(%')") + "`";
            }
            if (i > 0) {
                columnString.append(delimiter).append("\n").append(spacesToIndentNextLines);
            }
            columnString.append(columnName);
        }
        return columnString.toString();
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        OLEDBType ole = new OLEDBType();
        return ole.getTableOptionCollection(model, table);
    }
}

