/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class INFORMIXType
extends BaseDBMSType {
    public INFORMIXType() {
        this.setIndexSupport(true);
        this.setConstraintSupport(false);
        this.setUnquotedTableNameAction("L");
        this.setTruncateSupport(false);
    }

    @Override
    public int getDBMSTypeID() {
        return 4;
    }

    @Override
    public String getDBMSTypeName() {
        return "Informix";
    }

    @Override
    public ICodeSegment createConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        List foreignKeys = table.getForeignKeysList();
        List uniqueKeys = table.getKeysList();
        if (!foreignKeys.isEmpty() || !uniqueKeys.isEmpty()) {
            IForeignKey key;
            int i;
            String tabname = table.getFullNameQuotedAsNeeded(codeSegment, true);
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateConstraint.msg.notrans"));
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateConstraint.note.sasmacro.notrans"));
            codeSegment.addSourceCode("proc sql;\n");
            codeSegment.indent();
            this.genConnect(codeSegment, table);
            codeSegment.addSourceCode("reset noprint; \n\n");
            this.genExecuteBegin(codeSegment, table, "");
            codeSegment.addSourceCode("alter table ").addSourceCode(tabname).addSourceCode("\n").indent();
            int foreignKeysSize = foreignKeys.size();
            for (i = 0; i < foreignKeysSize; ++i) {
                key = (IForeignKey)foreignKeys.get(i);
                IPhysicalTable primKeyTable = key.getTable();
                try {
                    primKeyTable.genAccessPath(codeSegment);
                    continue;
                }
                catch (MdException e) {
                    throw new CodegenException((Exception)((Object)e), (IObject)primKeyTable);
                }
                catch (BadLibraryDefinitionException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
                catch (BadServerDefinitionException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
                catch (RemoteException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
                catch (ServerException e) {
                    throw new CodegenException(e, (IObject)primKeyTable);
                }
            }
            for (i = 0; i < foreignKeysSize; ++i) {
                key = (IForeignKey)foreignKeys.get(i);
                String colList = codeSegment.makeColumnList(key.getColumnsList(), false, codeSegment.getIndentString() + "   ", false, " ", "", codeSegment.isQuoting(), "", false);
                codeSegment.addSourceCode("add constraint foreign key ");
                codeSegment.addSourceCode("(").addSourceCode(colList).addSourceCode(") references ");
                IPhysicalTable primKeyTable = key.getTable();
                String primKeyTableName = primKeyTable.getFullNameQuotedAsNeeded(codeSegment, true);
                codeSegment.addSourceCode(primKeyTableName).addSourceCode("\n");
            }
            int uniqueSize = uniqueKeys.size();
            for (int i2 = 0; i2 < uniqueSize; ++i2) {
                IKey key2 = (IKey)uniqueKeys.get(i2);
                String colList = codeSegment.makeColumnList(key2.getColumnsList(), false, codeSegment.getIndentString() + "   ", false, " ", "", codeSegment.isQuoting(), "", false);
                codeSegment.addSourceCode("add constraint ");
                if (key2.isPrimary()) {
                    codeSegment.addSourceCode("unique ");
                } else {
                    codeSegment.addSourceCode("primary key ");
                }
                codeSegment.addSourceCode("(").addSourceCode(colList).addSourceCode(")\n");
            }
            codeSegment.addSourceCode("\n").unIndent();
            this.genExecuteEnd(codeSegment, table, "");
            this.genExecuteCommit(codeSegment, table, "");
            this.genDisconnect(codeSegment, table);
            codeSegment.unIndent();
            codeSegment.addSourceCode("quit;\n\n");
            codeSegment.genRCSetCall("&sqlrc");
        }
        return codeSegment;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_InformixTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_infor", RB.getStringResource("InformixType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

