/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.visuals.expression.UserDefinedFunction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DB2UNXPCType
extends BaseDBMSType {
    public DB2UNXPCType() {
        this.setUnquotedTableNameAction("U");
        this.setDBMSTempSupport(true);
    }

    @Override
    public int getDBMSTypeID() {
        return 1;
    }

    @Override
    public String getDBMSTypeName() {
        return "DB2";
    }

    @Override
    public boolean isModelManagerFunctionSetsSupported() {
        return true;
    }

    @Override
    public boolean isNativeFunctionSetsSupported() {
        return true;
    }

    @Override
    public StringBuffer getModelManagerProjectsQuery(ILibrary library, boolean quotes) {
        StringBuffer code = new StringBuffer();
        if (!quotes) {
            code.append("select distinct project_name, project_uuid ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".project_metadata");
            } else {
                code.append("from project_metadata");
            }
        } else {
            code.append("select distinct \"PROJECT_NAME\"n, \"PROJECT_UUID\"n ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".\"PROJECT_METADATA\"n");
            } else {
                code.append("from \"PROJECT_METADATA\"n");
            }
        }
        return code;
    }

    @Override
    public StringBuffer getModelManagerFunctionSetsQuery(ILibrary library, boolean quotes, List types) {
        StringBuffer code = new StringBuffer();
        if (!quotes) {
            String uuidWhere = "project_uuid IN (";
            for (int iType = 0; iType < types.size(); ++iType) {
                String name = (String)types.get(iType);
                int start = name.indexOf("(") + 2;
                int end = name.indexOf(")");
                String uuid = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                if (iType > 0 && iType < types.size()) {
                    uuidWhere = uuidWhere + ",";
                }
                uuidWhere = uuidWhere + "\"" + uuid + "\" ";
            }
            uuidWhere = uuidWhere + ")";
            code.append("select model_name, udf_name, udf_signature, mining_function, mining_algorithm").append(" from ");
            if (library.getLibref() != null) {
                code.append(library.getLibref()).append(".model_metadata where model_uuid IN ");
            }
            code.append("(select model_uuid ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".project_model_info").append(" where model_enabled=\"T\" and ").append(uuidWhere).append(");");
            }
        } else {
            String uuidWhere = "\"PROJECT_UUID\"n IN (";
            for (int iType = 0; iType < types.size(); ++iType) {
                String name = (String)types.get(iType);
                int start = name.indexOf("(") + 2;
                int end = name.indexOf(")");
                String uuid = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                if (iType > 0 && iType < types.size()) {
                    uuidWhere = uuidWhere + ",";
                }
                uuidWhere = uuidWhere + "\"" + uuid + "\" ";
            }
            uuidWhere = uuidWhere + ")";
            code.append("select \"MODEL_NAME\"n, \"UDF_NAME\"n, \"UDF_SIGNATURE\"n, \"MINING_FUNCTION\"n, \"MINING_ALGORITHM\"n").append(" from ");
            if (library.getLibref() != null) {
                code.append(library.getLibref()).append(".\"MODEL_METADATA\"n where \"MODEL_UUID\"n IN ");
            }
            code.append("(select \"MODEL_UUID\"n ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".\"PROJECT_MODEL_INFO\"n").append(" where \"MODEL_ENABLED\"n=\"T\" and ").append(uuidWhere).append(");");
            }
        }
        return code;
    }

    @Override
    public StringBuffer getNativeFunctionSetsQuery(ILibrary library, boolean quotes) {
        StringBuffer code = new StringBuffer();
        if (library != null) {
            code.append(" select a.ROUTINENAME, a.SPECIFICNAME, a.ROUTINESCHEMA, b.PARMNAME, b.TYPENAME, b.ORDINAL ");
            if (library.getLibref() != null) {
                code.append(" from ").append(library.getLibref()).append(".ROUTINES a left outer join ").append(library.getLibref()).append(".ROUTINEPARMS b");
            } else {
                code.append(" from ROUTINES a left outer join ROUTINEPARMS b");
            }
            code.append(" ON a.ROUTINESCHEMA=b.ROUTINESCHEMA and a.ROUTINENAME=b.ROUTINENAME ").append(" where a.ROUTINETYPE=\"F\" and a.ORIGIN NOT IN (\"B\",\"S\",\"T\") and ROWTYPE IN (\"B\",\"P\")").append("and b.ORDINAL > 0 and a.ROUTINESCHEMA not like \"SYS%\"").append(" ORDER BY a.ROUTINESCHEMA, a.SPECIFICNAME, b.ORDINAL");
        }
        return code;
    }

    @Override
    public List createNativeFunctionsFromQueryResults(MVAResultSet rsltSet) throws SQLException {
        ArrayList<UserDefinedFunction> sets = new ArrayList<UserDefinedFunction>();
        if (rsltSet != null) {
            UserDefinedFunction func;
            StringBuffer sbDatabaseName;
            StringBuffer sbSpecificName;
            String sName = null;
            String sDisplayName = null;
            String sSchemaName = null;
            String sSpecificName = null;
            String sDescription = null;
            String sFormat = null;
            String sStartDescription = RB.getStringResource("BaseDBMSType.ImportUserDefinedFunctionsDescription.txt");
            String oldName = null;
            String argName = null;
            int position = -1;
            int numParms = 0;
            String argType = null;
            boolean bFirst = true;
            boolean bDone = false;
            while (rsltSet.next()) {
                sName = rsltSet.getString(1).trim();
                sSpecificName = rsltSet.getString(2).trim();
                if (sName == null || sName.equals("")) continue;
                if (!sSpecificName.equals(oldName) && oldName != null) {
                    if (numParms > 0 && position > -1) {
                        sFormat = sFormat + ")";
                        sDisplayName = sDisplayName + ")";
                    }
                    sbSpecificName = new StringBuffer();
                    if (sSpecificName != null) {
                        sbSpecificName.append("<o:p></o:p></span></p>");
                        sbSpecificName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                        sbSpecificName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                        sbSpecificName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("DB2INXPCType.SpecificName.txt")).append("<o:p></o:p></span></b></h2>");
                        sbSpecificName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                        sbSpecificName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                        sbSpecificName.append("   Arial'>").append(sSpecificName).append("<o:p></o:p></span></p>");
                    }
                    sbDatabaseName = new StringBuffer();
                    if (sSchemaName != null) {
                        sbDatabaseName.append("<o:p></o:p></span></p>");
                        sbDatabaseName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                        sbDatabaseName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                        sbDatabaseName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("DB2INXPCType.SchemaName.txt")).append("<o:p></o:p></span></b></h2>");
                        sbDatabaseName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                        sbDatabaseName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                        sbDatabaseName.append("   Arial'>").append(sSchemaName).append("<o:p></o:p></span></p>");
                    }
                    sDescription = sStartDescription + sbSpecificName + sbDatabaseName;
                    func = new UserDefinedFunction(sName, sDisplayName, sDescription, sFormat);
                    sets.add(func);
                    sDisplayName = null;
                    sSchemaName = null;
                    sDescription = null;
                    sFormat = null;
                    bFirst = true;
                    numParms = 0;
                    position = 0;
                }
                oldName = sSpecificName;
                sSchemaName = rsltSet.getString(3).trim();
                argName = rsltSet.getString(4).trim();
                argType = rsltSet.getString(5).trim();
                numParms = rsltSet.getInt(6);
                if (!sSpecificName.equals(oldName) && oldName != null) continue;
                if (numParms == 0) {
                    sFormat = sName + "( )";
                    sDisplayName = sName + "( )";
                    continue;
                }
                if (bFirst) {
                    sFormat = sName + "(<" + argType.trim() + ">";
                    sDisplayName = sName + "(" + argName;
                    bFirst = false;
                    position = 2;
                    continue;
                }
                if (position <= 0) continue;
                sFormat = sFormat + ", <" + argType.trim() + ">";
                sDisplayName = sDisplayName + ", " + argName;
                position += 2;
            }
            rsltSet.close();
            if (sName != null) {
                if (numParms > 0 && position > -1) {
                    sFormat = sFormat + ")";
                    sDisplayName = sDisplayName + ")";
                }
                sbSpecificName = new StringBuffer();
                if (sSpecificName != null) {
                    sbSpecificName.append("<o:p></o:p></span></p>");
                    sbSpecificName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                    sbSpecificName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                    sbSpecificName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("DB2INXPCType.SpecificName.txt")).append("<o:p></o:p></span></b></h2>");
                    sbSpecificName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                    sbSpecificName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                    sbSpecificName.append("   Arial'>").append(sSpecificName).append("<o:p></o:p></span></p>");
                }
                sbDatabaseName = new StringBuffer();
                if (sSchemaName != null) {
                    sbDatabaseName.append("<o:p></o:p></span></p>");
                    sbDatabaseName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                    sbDatabaseName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                    sbDatabaseName.append("style='mso-bidi-font-family:Arial'>").append(RB.getStringResource("DB2INXPCType.SchemaName.txt")).append("<o:p></o:p></span></b></h2>");
                    sbDatabaseName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                    sbDatabaseName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                    sbDatabaseName.append("   Arial'>").append(sSchemaName).append("<o:p></o:p></span></p>");
                }
                sDescription = sStartDescription + sbSpecificName + sbDatabaseName;
                func = new UserDefinedFunction(sName, sDisplayName, sDescription, sFormat);
                sets.add(func);
            }
        }
        return sets;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), true, false, ""));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + " \n").addSourceCode("( \n").indent().addSourceCode("select indname as idxname, \n").addSourceCode("       tabname as tabname \n").indent().addSourceCode("from syscat.indexes \n").indent();
        tableName = tableName.replaceAll("'", "''");
        codeSegment.addSourceCode("where tabname = '" + tableName + "' \n").addSourceCode("and indschema=tabschema \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment genTruncate(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("ALTER TABLE " + tableName + " ACTIVATE NOT LOGGED INITIALLY WITH EMPTY TABLE \n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genDeleteAll(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        super.genDeleteAll(codeSegment, table);
        codeSegment.addSourceCode(" where 1=1 \n");
        return codeSegment;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_DB2UNXPCTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_db2_u", RB.getStringResource("DB2UNXPCType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }

    @Override
    public String getIndexName(ICodeSegment codeSegment, IIndex index, boolean passthru) throws CodegenException {
        String name = index.getName();
        if (name == null || name.trim().length() <= 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.MissingIndexName.msg.txt"), (IObject)index);
        }
        IPhysicalTable table = index.getTable();
        if (table == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.MissingIndexTable.msg.txt"), (IObject)index);
        }
        IDatabaseSchema schema = table.getDatabaseSchema();
        String schemaName = null;
        if (schema != null) {
            schemaName = schema.getSchemaName();
        }
        boolean isTempTable = false;
        if (schemaName != null && schemaName.equalsIgnoreCase("SESSION")) {
            isTempTable = true;
        }
        if (isTempTable) {
            if (codeSegment.isQuoting() && table.isQuoted() && passthru) {
                schemaName = DBMSNamesUtil.getQuotedString(schemaName);
            }
            name = schemaName + "." + DBMSNamesUtil.getQuotedIndexName(index, codeSegment.isQuoting(), passthru);
        } else {
            name = DBMSNamesUtil.getQuotedIndexName(index, codeSegment.isQuoting(), passthru);
        }
        return name;
    }

    @Override
    public ICodeSegment genSingleIndex(ICodeSegment codeSegment, IPhysicalTable table, IIndex index) throws CodegenException, BadLibraryDefinitionException {
        String preOpts = this.getPreIndexOptions(index);
        String tableOpts = this.getIndexTableOptions(codeSegment, index);
        String idxname = this.getIndexName(codeSegment, index, true);
        if (idxname == null || idxname.trim().length() <= 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.IndexNameUndefined.msg.txt"), (IObject)index);
        }
        if (index.getTable() == null) {
            throw new CodegenException(RB.getStringResource("IndexCG.MissingIndexTable.msg.txt"), (IObject)index);
        }
        codeSegment.addSourceCode("create ");
        if (preOpts.length() > 0) {
            codeSegment.addSourceCode(preOpts.trim() + " ");
        }
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, this.m_passthru);
        if ("BACK".equals(this.getQuoteTypeForPassthru())) {
            idxname = this.wrapInBackQuotes(idxname);
            tableName = this.wrapInBackQuotes(tableName);
        }
        tableName = this.getTableNameCustomizedForDBMS(codeSegment, table, tableName);
        if (table.getDatabaseSchema().getName() != null && table.getDatabaseSchema().getName().trim().length() > 1 && !table.getDatabaseSchema().getSchemaName().equalsIgnoreCase("SESSION")) {
            idxname = table.getDatabaseSchema().getSchemaName() + "." + idxname;
        }
        codeSegment.addSourceCode("index " + idxname + "\n").indent().addSourceCode("on " + tableName + "\n").indent().addSourceCode("  (");
        if (tableOpts.length() > 0) {
            codeSegment.addSourceCode(tableOpts + "\n   ");
        }
        List lColumns = null;
        lColumns = index.getColumnsList();
        if (lColumns.isEmpty()) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsOnIndex.msg.txt"), (IObject)index);
        }
        String columns = this.makeColumnListInDBMSTypeFormat(codeSegment, lColumns);
        codeSegment.addSourceCode(columns).addSourceCode(") \n").unIndent().unIndent();
        return codeSegment;
    }
}

