/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.businessrule.impl;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlow;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.data.businessrule.impl.RB;
import com.sas.etl.models.data.impl.BaseGeneratedTableColumn;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.services.information.metadata.businessruleflow.TermUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseBusinessRuleFlowColumn
extends BaseGeneratedTableColumn
implements IBusinessRuleFlowColumn {
    private String _type;
    private String _dType;
    private IBusinessRuleFlowTable _brTable;

    public BaseBusinessRuleFlowColumn(IBusinessRuleFlowTable table, String sID) {
        super(table, sID);
        this._brTable = table;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (TermUtil.isDatagridDataType((String)this._type)) {
            this.setSASLength(Short.MAX_VALUE);
        } else {
            this.setSASLength(this.getDefaultSASLength());
        }
    }

    @Override
    public String getDataType() {
        return this._type;
    }

    @Override
    public void setDataType(String type) {
        this._type = type;
        if (TermUtil.isDateDataType((String)this._type) || TermUtil.isDatetimeDataType((String)this._type) || TermUtil.isIntegerDataType((String)this._type) || TermUtil.isRealDataType((String)this._type) || TermUtil.isBooleanDataType((String)this._type)) {
            this.setSASType(1);
        } else {
            this.setSASType(0);
        }
        if (TermUtil.isDatetimeDataType((String)this._type)) {
            this.setFormat("nldatm.");
            this.setInformat("nldatm.");
        } else if (TermUtil.isDateDataType((String)this._type)) {
            this.setFormat("nldate.");
            this.setInformat("nldate.");
        }
        if (TermUtil.isDatagridDataType((String)this._type)) {
            this.setSASLength(Short.MAX_VALUE);
        }
    }

    @Override
    public String getDisplayableDataType() {
        return this._dType;
    }

    @Override
    public void setDisplayableDataType(String dType) {
        this._dType = dType;
    }

    private Map<String, Integer> getDefaultLengthMap() {
        if (this._brTable != null) {
            IBusinessRuleFlow flow = this._brTable.getBusinessRuleFlowVersion().getRule();
            return flow.getDefaultColumnLengths();
        }
        return new HashMap<String, Integer>();
    }

    @Override
    public boolean isComplete(IColumn column) {
        return super.isComplete(column) && column != null && ObjectComparator.isEqual(this.getName(), column.getName(), false) && this.getSASType() == column.getType();
    }

    @Override
    public List getReasonsIncomplete(IColumn column) {
        List lst = super.getReasonsIncomplete(column);
        if (!ObjectComparator.isEqual(this.getName(), column.getName(), false)) {
            lst.add(MessageFormat.format(RB.getStringResource("BaseBusinessRuleFlowColumn.ColumnNameNoMatch.fmt"), column.getName(), this.getName()));
        }
        if (this.getSASType() != column.getType()) {
            lst.add(MessageFormat.format(RB.getStringResource("BaseBusinessRuleFlowColumn.ColumnTypeNoMatch.fmt"), column.getName()));
        }
        return lst;
    }

    public int getDefaultSASLength() {
        if (this.getTable() != null && this.getName() != null) {
            String fullCName = this.getTable().getName() + '.' + this.getName();
            Map<String, Integer> defaultMap = this.getDefaultLengthMap();
            if (defaultMap.containsKey(fullCName)) {
                return defaultMap.get(fullCName);
            }
        }
        if (0 == this.getSASType()) {
            return 100;
        }
        return 8;
    }

    @Override
    public boolean equals(IColumn column) {
        return column != null && ObjectComparator.isEqual(this.getName(), column.getName()) && this.getSASType() == column.getType();
    }
}

