/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models;

import java.io.Serializable;

public class DISUsageVersion
implements Serializable,
Comparable {
    private static final long serialVersionUID = -8930137219599390479L;
    private int major;
    private int minor;
    private int micro;

    public DISUsageVersion(int majorVersion, int minorVersion) {
        if (majorVersion < 0) {
            throw new IllegalArgumentException("Invalid major version.  Major version must be greater than or equal to 0.");
        }
        if (minorVersion < 0) {
            throw new IllegalArgumentException("Invalid minor version.  Minor version must be greater than or equal to 0.");
        }
        this.major = majorVersion;
        this.minor = minorVersion;
        this.micro = 0;
    }

    public DISUsageVersion(int majorVersion, int minorVersion, int microVersion) {
        if (majorVersion < 0) {
            throw new IllegalArgumentException("Invalid major version.  Major version must be greater than or equal to 0.");
        }
        if (minorVersion < 0) {
            throw new IllegalArgumentException("Invalid minor version.  Minor version must be greater than or equal to 0.");
        }
        if (microVersion < 0) {
            throw new IllegalArgumentException("Invalid micro version.  Micro version must be greater than or equal to 0.");
        }
        this.major = majorVersion;
        this.minor = minorVersion;
        this.micro = microVersion;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMicroVersion() {
        return this.micro;
    }

    public String toString() {
        if (this.micro == 0) {
            return Integer.toString(this.major) + "." + Integer.toString(this.minor);
        }
        return Integer.toString(this.major) + "." + Integer.toString(this.minor) + "." + Integer.toString(this.micro);
    }

    public boolean equals(Object usageVersion) {
        if (!(usageVersion instanceof DISUsageVersion)) {
            return false;
        }
        DISUsageVersion uv = (DISUsageVersion)usageVersion;
        return this.major == uv.getMajorVersion() && this.minor == uv.getMinorVersion() && this.micro == uv.getMicroVersion();
    }

    public int hashCode() {
        return this.major * 1000000 + this.minor * 10000 + this.micro;
    }

    public int compareTo(Object usageVersion) {
        DISUsageVersion uv = (DISUsageVersion)usageVersion;
        if (this.major > uv.getMajorVersion()) {
            return 1;
        }
        if (this.major < uv.getMajorVersion()) {
            return -1;
        }
        if (this.minor > uv.getMinorVersion()) {
            return 1;
        }
        if (this.minor < uv.getMinorVersion()) {
            return -1;
        }
        if (this.micro > uv.getMicroVersion()) {
            return 1;
        }
        if (this.micro < uv.getMicroVersion()) {
            return -1;
        }
        return 0;
    }

    public int compareMajorMinor(DISUsageVersion usageVersion) {
        if (usageVersion == null) {
            if (this.major > 0 || this.minor > 0) {
                return 1;
            }
            return 0;
        }
        if (this.major > usageVersion.getMajorVersion()) {
            return 1;
        }
        if (this.major < usageVersion.getMajorVersion()) {
            return -1;
        }
        if (this.minor > usageVersion.getMinorVersion()) {
            return 1;
        }
        if (this.minor < usageVersion.getMinorVersion()) {
            return -1;
        }
        return 0;
    }

    public boolean isReadCompatible(DISUsageVersion oldest, DISUsageVersion current) {
        return this.compareMajorMinor(oldest) >= 0 && this.major <= current.getMajorVersion();
    }

    public boolean isCompatible(DISUsageVersion oldest, DISUsageVersion current) {
        return this.compareMajorMinor(oldest) >= 0 && this.compareMajorMinor(current) <= 0;
    }
}

