/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.util;

import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class QCGroup {
    protected static final int DATA = 0;
    protected static final int ASCENDING = 1;
    protected static final int DESCENDING = 2;
    protected QCOverlay overlay;
    protected CRD model;
    protected Variable xvalueVar;
    protected ColorEncoder colorEncoder;
    protected Variable groupVar;
    protected Variable groupIndexVar;
    protected StringVariable groupStringVar;
    private int groupOrder = 0;
    private int[] groupsPerCategory;
    private ArrayList[] groupCategoryLists;
    private int[] subToColumnGroupCategory;
    private HashMap groupValue2Category;
    private String overlayID;
    private String[] tableEmptyGroups = null;
    private boolean removeEmptyGroups = true;
    public int nEmptyGroups = 0;

    public QCGroup(QCOverlay o, CRD m) {
        this.overlay = o;
        this.model = m;
        this.groupVar = null;
        this.groupIndexVar = null;
        this.xvalueVar = this.overlay.xvalueVar;
    }

    public void setColorEncoder(ColorEncoder encoder) {
        this.colorEncoder = encoder;
    }

    public ColorEncoder getColorEncoder() {
        return this.colorEncoder;
    }

    public void setXVar(Variable var) {
        this.xvalueVar = var;
    }

    public void setGroupVar(Variable var) {
        this.groupVar = var;
    }

    public void setGroupStringVar(StringVariable var) {
        this.groupStringVar = var;
    }

    public void setGroupIndexVar(Variable var) {
        this.groupIndexVar = var;
    }

    public void createGroupVariables(short role, boolean parmPlot) {
        if (this.groupVar == null) {
            return;
        }
        String[] groups = null;
        IntegerPipe groupCategory = null;
        String[] gString = this.model.isAvailable((int)role) ? this.model.getStringAsClassColumn((int)role, true) : null;
        this.updateNumberOfGroupPerCategory(parmPlot);
        groups = this.groupVar instanceof NumericVariable ? this.overlay.getSubsettedDoubleAsClassColumn(role) : this.overlay.getSubsettedStringAsClassColumn(role);
        groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
        this.groupValue2Category = new HashMap();
        int nobs = this.xvalueVar == null ? 1 : groups.length;
        for (int i = 0; i < nobs; ++i) {
            String group = groups[i];
            int gcat = 0;
            try {
                gcat = groupCategory.getValue(i);
                if (gString != null) {
                    gcat = this.removeEmptyGroups(gcat, gString[i]);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (group.equalsIgnoreCase("Empty") || group.equalsIgnoreCase("None") || this.groupValue2Category.containsKey(group)) continue;
            this.groupValue2Category.put(group, new Integer(gcat));
        }
    }

    public String[] getGroupValues() {
        return this.getGroupValues(false);
    }

    public String[] getGroupValues(boolean deleteEmpty) {
        String gval;
        int i;
        if (this.groupVar == null) {
            return new String[0];
        }
        String[] values = this.groupOrder == 0 ? this.overlay.getUniqueGroups((short)3) : this.overlay.getUniqueGroups((short)3, this.groupOrder == 1 ? 1 : 2);
        if (!deleteEmpty) {
            return values;
        }
        int n = values.length;
        int nEmpty = 0;
        for (i = 0; i < n; ++i) {
            gval = values[i];
            if (!gval.equalsIgnoreCase("Empty") && !gval.equalsIgnoreCase("None")) continue;
            ++nEmpty;
        }
        if (n == nEmpty) {
            return new String[0];
        }
        String[] gv = new String[n - nEmpty];
        int j = 0;
        for (i = 0; i < n; ++i) {
            gval = values[i];
            if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) continue;
            gv[j++] = values[i];
        }
        return gv;
    }

    public Color[] getGroupColors(ColorAttr colorAttrs) {
        Color[] colors = new Color[]{};
        HashMap ht = this.colorEncoder.colorList;
        String[] values = this.getGroupValues();
        colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            String gval = values[i];
            if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) {
                colors[i] = null;
                continue;
            }
            if (colors[i] != null) continue;
            colors[i] = this.groupIndexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.colorEncoder, gval, colorAttrs);
        }
        return colors;
    }

    private void updateNumberOfGroupPerCategory(boolean parmPlot) {
        int maxGroups;
        block23: {
            int numCats;
            block21: {
                NumericVariable xvar;
                block22: {
                    int gCount;
                    int numCats2;
                    if (this.groupVar == null) {
                        return;
                    }
                    if (this.model.getSrcModel().maxGroupsPerCategory == null) {
                        this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
                    }
                    this.overlayID = this.model.getColumnName((short)11) + "." + this.model.getColumnName((short)3);
                    if (this.overlay.isMissingGroupOn()) {
                        this.overlayID = this.overlayID + ".MissingGroup";
                    }
                    maxGroups = -1;
                    maxGroups = this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null ? (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) : 1;
                    if (!parmPlot) break block21;
                    if (this.xvalueVar instanceof NumericVariable) {
                        xvar = new NumericVariable();
                        xvar.connectFrom((NumericVariable)this.xvalueVar);
                        xvar.setFormat(((NumericVariable)this.xvalueVar).getFormat());
                    } else if (this.xvalueVar instanceof StringVariable) {
                        xvar = new StringVariable();
                        ((StringVariable)xvar).connectFrom((StringVariable)this.xvalueVar);
                        ((StringVariable)xvar).setFormat(((StringVariable)this.xvalueVar).getFormat());
                    } else {
                        xvar = null;
                    }
                    StringVariable gvar = new StringVariable();
                    if (this.groupVar instanceof NumericVariable) {
                        gvar.connectFrom((NumericVariable)this.groupVar);
                    } else {
                        gvar.connectFrom((StringVariable)this.groupVar);
                    }
                    VariableProcessor vp = new VariableProcessor();
                    if (xvar != null) {
                        vp.addVariable((Variable)xvar);
                    }
                    vp.addVariable((Variable)gvar);
                    vp.addVariable((Variable)gvar, 0);
                    if (xvar != null) {
                        vp.addGroupVariable((Variable)xvar);
                    }
                    vp.addGroupVariable((Variable)gvar);
                    int n = numCats2 = xvar == null ? 1 : xvar.getUniqueValueCount();
                    if (numCats2 == 0) {
                        return;
                    }
                    this.groupsPerCategory = new int[numCats2];
                    if (xvar != null) break block22;
                    this.groupsPerCategory[0] = gCount = gvar.getUniqueValueCount();
                    if (gCount > maxGroups) {
                        maxGroups = gCount;
                    }
                    break block23;
                }
                int gCount = 1;
                int gIdx = 0;
                String catV = null;
                int nx = xvar.getValueCount();
                for (int i = 0; i < nx; ++i) {
                    try {
                        String xv;
                        String string = xv = xvar instanceof StringVariable ? ((StringVariable)xvar).value.getValue(i) : xvar.formattedValue.getValue(i);
                        if (catV == null) {
                            catV = xv;
                            continue;
                        }
                        if (xv.equals(catV)) {
                            ++gCount;
                            continue;
                        }
                        this.groupsPerCategory[gIdx] = gCount;
                        if (gCount > maxGroups) {
                            maxGroups = gCount;
                        }
                        ++gIdx;
                        gCount = 1;
                        catV = xv;
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                this.groupsPerCategory[gIdx] = gCount;
                if (gCount <= maxGroups) break block23;
                maxGroups = gCount;
                break block23;
            }
            int n = numCats = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
            if (numCats == 0) {
                return;
            }
            this.groupsPerCategory = new int[numCats];
            int nx = this.xvalueVar.getValueCount();
            for (int i = 0; i < nx; ++i) {
                this.groupsPerCategory[i] = 1;
            }
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private void updateNumberOfGroupPerCategory() {
        int numCats;
        if (this.groupVar == null) {
            return;
        }
        int n = numCats = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        if (numCats == 0) {
            return;
        }
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayID = this.model.getColumnName((short)11) + "." + this.model.getColumnName((short)3);
        if (this.overlay.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null ? (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) : 1;
        this.groupsPerCategory = new int[numCats];
        int nx = this.xvalueVar.getValueCount();
        for (int i = 0; i < nx; ++i) {
            this.groupsPerCategory[i] = 1;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private ArrayList[] getGroupCategoryLists() {
        int i;
        int nGrp = this.groupVar.getUniqueValueCount();
        String[] gvalues = this.getGroupValues();
        this.sortEmptyGroups(gvalues);
        this.subToColumnGroupCategory = new int[nGrp];
        this.groupStringVar.getUniqueValueCount();
        HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
        for (i = 0; i < nGrp; ++i) {
            try {
                if (this.groupOrder == 0) {
                    String v = this.groupStringVar.uniqueValue.getValue(i);
                    int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                    groupCategory_column = this.removeEmptyGroups(groupCategory_column, v);
                    value2ColumnCategory.put(v, new Integer(groupCategory_column));
                    this.subToColumnGroupCategory[i] = groupCategory_column;
                    continue;
                }
                this.subToColumnGroupCategory[i] = i;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.xvalueVar == null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < this.groupVar.getUniqueValueCount(); ++i) {
                list.add(new Integer(i));
            }
            if (this.groupOrder != 0) {
                Collections.sort(list);
            }
            return new ArrayList[]{list};
        }
        int nCat = this.xvalueVar instanceof StringVariable ? ((StringVariable)this.xvalueVar).getUniqueValueCount() : ((NumericVariable)this.xvalueVar).getUniqueValueCount();
        ArrayList[] list = new ArrayList[nCat];
        for (i = 0; i < nCat; ++i) {
            list[i] = new ArrayList();
        }
        IntegerPipe xvalueCategory = this.xvalueVar instanceof NumericVariable ? ((NumericVariable)this.xvalueVar).category : ((StringVariable)this.xvalueVar).category;
        IntegerPipe groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
        String[] gString = this.nEmptyGroups > 0 ? this.model.getStringAsClassColumn(3, true) : null;
        int n = this.xvalueVar.getValueCount();
        try {
            for (i = 0; i < n; ++i) {
                Integer IG;
                int xcat = xvalueCategory.getValue(i);
                int gcat = groupCategory.getValue(i);
                if (gString != null) {
                    gcat = this.removeEmptyGroups(gcat, gString[i]);
                }
                if (list[xcat].contains(IG = new Integer(gcat))) continue;
                list[xcat].add(IG);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if (this.groupOrder != 0) {
            for (i = 0; i < nCat; ++i) {
                Collections.sort(list[i]);
            }
        }
        return list;
    }

    protected Color getIndexColor(ColorEncoder encoder, String value, ColorAttr defaultAttr) {
        Color[] cl = encoder.colorArray;
        if (this.groupsPerCategory == null) {
            return Color.PINK;
        }
        Integer gCat = (Integer)this.groupValue2Category.get(value);
        Color c = null;
        if (gCat != null) {
            int gcat = gCat;
            int obs = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupVar).getFirstOccurringValueIndex(gcat);
            try {
                int idx = (int)((NumericVariable)this.groupIndexVar).value.getValue(obs) - 1;
                c = defaultAttr.getTransparency() < 0.0 ? this.overlay.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency((Color)cl[idx % cl.length], (double)defaultAttr.getTransparency());
            }
            catch (MissingValueException e) {
                c = this.overlay.applyDataTransparency(defaultAttr);
            }
        }
        return c;
    }

    public boolean isGroupAllMissings() {
        if (this.model == null) {
            return true;
        }
        if (this.model.isAvailable(3) || this.model.isAvailable(3)) {
            return false;
        }
        return false;
    }

    public int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    public boolean isEmptyGroup(String gval) {
        if (!this.removeEmptyGroups) {
            return false;
        }
        return this.groupVar != null && gval.equalsIgnoreCase("Empty");
    }

    public void sortEmptyGroups(String[] gvalues) {
        String gval;
        int i;
        this.nEmptyGroups = 0;
        this.tableEmptyGroups = null;
        if (!this.removeEmptyGroups) {
            return;
        }
        if (this.groupVar == null || gvalues == null) {
            return;
        }
        int n = gvalues.length;
        this.tableEmptyGroups = new String[n];
        int iempty = 0;
        for (i = 0; i < n; ++i) {
            gval = gvalues[i];
            if (gval.equalsIgnoreCase("Empty")) continue;
            this.tableEmptyGroups[iempty++] = gvalues[i];
        }
        for (i = 0; i < n; ++i) {
            gval = gvalues[i];
            if (!gval.equalsIgnoreCase("Empty")) continue;
            this.tableEmptyGroups[iempty++] = gvalues[i];
            ++this.nEmptyGroups;
        }
    }

    public int removeEmptyGroups(int gcat, String gval) {
        if (this.groupVar == null || this.nEmptyGroups == 0) {
            return gcat;
        }
        if (this.tableEmptyGroups == null) {
            return gcat;
        }
        int n = this.tableEmptyGroups.length;
        for (int i = 0; i < n; ++i) {
            String value = this.tableEmptyGroups[i];
            if (!gval.equals(value)) continue;
            gcat = i;
            break;
        }
        return gcat;
    }
}

