/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCVMaskConnector;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericMapper;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class QCVMask {
    public QCVMaskConnector connector;
    public QCLimitsOverlay.QCLimitScheme schemeType;
    public double mu0;
    public double sigma0;
    public double delta;
    public double shift;
    public double beta;
    public double h;
    public double hScaled;
    public double k;
    public double kAdjust;
    public double kScaled;
    public double originIndex;
    public double originX;
    public double originY;
    public double winsor;
    public double ARLOut;
    public double ARLIn;
    Rectangle frame;
    public static final int VMASK_UL = 0;
    public static final int VMASK_UR = 1;
    public static final int VMASK_LR = 2;
    public static final int VMASK_LL = 3;
    public Point2D.Double[] view = new Point2D.Double[4];
    public double view_dx;
    public double view_dy;
    public Point2D.Double[] data = new Point2D.Double[4];
    public double data_dx;
    public double data_dy;
    public boolean legend;
    public boolean display;

    public QCVMask() {
        this.schemeType = QCLimitsOverlay.QCLimitScheme.SCHEME_TWOSIDED;
        this.mu0 = Double.NaN;
        this.sigma0 = Double.NaN;
        this.delta = Double.NaN;
        this.shift = Double.NaN;
        this.beta = Double.NaN;
        this.h = Double.NaN;
        this.hScaled = Double.NaN;
        this.k = Double.NaN;
        this.kAdjust = Double.NaN;
        this.kScaled = Double.NaN;
        this.originIndex = Double.NaN;
        this.originX = Double.NaN;
        this.originY = Double.NaN;
        this.winsor = Double.NaN;
        this.ARLOut = Double.NaN;
        this.ARLIn = Double.NaN;
        this.view[0] = new Point2D.Double(Double.NaN, Double.NaN);
        this.view[1] = new Point2D.Double(Double.NaN, Double.NaN);
        this.view[2] = new Point2D.Double(Double.NaN, Double.NaN);
        this.view[3] = new Point2D.Double(Double.NaN, Double.NaN);
        this.data[0] = new Point2D.Double(Double.NaN, Double.NaN);
        this.data[1] = new Point2D.Double(Double.NaN, Double.NaN);
        this.data[2] = new Point2D.Double(Double.NaN, Double.NaN);
        this.data[3] = new Point2D.Double(Double.NaN, Double.NaN);
    }

    public void setDrawingArea(Rectangle r) {
        this.frame = r;
    }

    public double getUCL(double x) {
        double ucl = Double.NaN;
        switch (this.schemeType) {
            case SCHEME_ONESIDED: {
                ucl = this.hScaled;
                break;
            }
            case SCHEME_TWOSIDED: {
                if (!(x <= this.originX)) break;
                double offset = this.hScaled + this.kAdjust * (this.originX - x);
                ucl = this.originY + offset;
            }
        }
        return ucl;
    }

    public double getLCL(double x) {
        double lcl = Double.NaN;
        switch (this.schemeType) {
            case SCHEME_ONESIDED: {
                break;
            }
            case SCHEME_TWOSIDED: {
                if (!(x <= this.originX)) break;
                double offset = this.hScaled + this.kAdjust * (this.originX - x);
                lcl = this.originY - offset;
            }
        }
        return lcl;
    }

    public void computeDataMask(double xmin, double xmax) {
        double[] ucl = new double[]{Double.NaN, Double.NaN};
        double[] lcl = new double[]{Double.NaN, Double.NaN};
        double dx = xmax - xmin;
        double dy = 0.0;
        switch (this.schemeType) {
            case SCHEME_ONESIDED: {
                ucl[0] = this.hScaled;
                ucl[1] = this.hScaled;
                break;
            }
            case SCHEME_TWOSIDED: {
                xmax = Math.min(xmax, this.originX);
                dx = xmax - xmin;
                dy = this.kAdjust * dx;
                double offset = this.hScaled + this.kAdjust * (this.originX - xmin);
                ucl[0] = this.originY + offset;
                ucl[1] = this.originY + offset;
                lcl[1] = this.originY - offset;
                lcl[0] = this.originY - offset;
            }
        }
        this.data[0].setLocation(xmin, ucl[0]);
        this.data[1].setLocation(xmax, ucl[1]);
        this.data[2].setLocation(xmax, lcl[1]);
        this.data[3].setLocation(xmin, lcl[0]);
        this.data_dx = dx;
        this.data_dy = dy;
    }

    public void computeDataMask(NumericMapper xvalueMapper) {
        if (!(xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
            return;
        }
        ContinuousRangeToNumericMapper xMap = (ContinuousRangeToNumericMapper)xvalueMapper;
        double xmin = xMap.getInputMin();
        double xmax = xMap.getInputMax();
        this.computeDataMask(xmin, xmax);
    }

    public void computeViewMask(QCOverlay overlay) {
        if (overlay == null) {
            return;
        }
        if (overlay.xvalueMapper == null) {
            return;
        }
        if (overlay.yvalueMapper == null) {
            return;
        }
        ContinuousRangeToNumericMapper xMap = (ContinuousRangeToNumericMapper)overlay.xvalueMapper;
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)overlay.yvalueMapper;
        double[] ucl = new double[2];
        double[] lcl = new double[2];
        double[] mx = new double[2];
        double innermargin = 5.0;
        double fuzz = 2.0;
        double d = this.getDataIncrement(xMap, innermargin + fuzz);
        d = 0.0;
        mx[0] = xMap.getInputMin() - d;
        mx[1] = xMap.getInputMax();
        mx[1] = Math.min(mx[1], this.originX);
        ucl[0] = this.originY + this.hScaled + this.kAdjust * (this.originX - mx[0]);
        ucl[1] = this.originY + this.hScaled + this.kAdjust * (this.originX - mx[1]);
        lcl[1] = this.originY - this.hScaled - this.kAdjust * (this.originX - mx[1]);
        lcl[0] = this.originY - this.hScaled - this.kAdjust * (this.originX - mx[0]);
        double dy = this.kAdjust * (mx[1] - mx[0]);
        dy = this.getPixelIncrement(yMap, dy);
    }

    private double getDataIncrement(ContinuousRangeToNumericMapper map, double delta) {
        if (map == null) {
            return Double.NaN;
        }
        double datamin = map.getInputMin();
        double datamax = map.getInputMax();
        double viewmin = map.getOutputMin();
        double viewmax = map.getOutputMax();
        double m = (datamax - datamin) / (viewmax - viewmin);
        return m * delta;
    }

    private double getPixelIncrement(ContinuousRangeToNumericMapper map, double delta) {
        if (map == null) {
            return Double.NaN;
        }
        double datamin = map.getInputMin();
        double datamax = map.getInputMax();
        double viewmin = map.getOutputMin();
        double viewmax = map.getOutputMax();
        double m = (viewmax - viewmin) / (datamax - datamin);
        return m * delta;
    }

    public boolean getScreenCoordinates(QCOverlay overlay) {
        if (overlay == null) {
            return false;
        }
        if (overlay.xvalueMapper == null || overlay.yvalueMapper == null) {
            return false;
        }
        double omin_x = 0.0;
        double omax_x = 0.0;
        double imin_x = 0.0;
        double imax_x = 0.0;
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)overlay.yvalueMapper;
        NumericMap nyMap = yMap.getNumericMap();
        ContinuousRangeToNumericMapper xMap = (ContinuousRangeToNumericMapper)overlay.xvalueMapper;
        NumericMap nxMap = xMap.getNumericMap();
        omin_x = nxMap.getOutputMin();
        omax_x = nxMap.getOutputMax();
        imin_x = xMap.getInputMin();
        imax_x = xMap.getInputMax();
        int xLeft = overlay.innerAxisBounds.x;
        int xRight = xLeft + overlay.innerAxisBounds.width;
        boolean extend = true;
        if (extend) {
            double lmargin = overlay.innerAxisBounds.x - overlay.outerAxisBounds.x;
            double rmargin = (double)(overlay.outerAxisBounds.width - overlay.innerAxisBounds.width) - lmargin;
            imin_x = xMap.getInverseValue(omin_x - lmargin);
            imax_x = xMap.getInverseValue(omax_x + rmargin);
            xLeft = overlay.outerAxisBounds.x;
            xRight = xLeft + overlay.outerAxisBounds.width;
        }
        double[] temp = new double[3];
        double x = this.originX;
        double y = this.getUCL(x);
        overlay.project(x, y, 0.0, temp);
        double vx = temp[0];
        double vUpper = temp[1];
        y = this.getLCL(x);
        overlay.project(x, y, 0.0, temp);
        double vLower = temp[1];
        double yScale = (nyMap.getOutputMax() - nyMap.getOutputMin()) / (yMap.getInputMax() - yMap.getInputMin());
        double idx = this.originX - imin_x;
        double idy = this.kAdjust * idx;
        double ody = idy * yScale;
        if (vx < (double)xRight) {
            this.view[0].setLocation(xLeft, vUpper - ody);
            this.view[1].setLocation(vx, vUpper);
            this.view[2].setLocation(vx, vLower);
            this.view[3].setLocation(xLeft, vLower + ody);
        } else {
            idx = this.originX - imax_x;
            idy = this.kAdjust * idx;
            double ody2 = idy * yScale;
            this.view[0].setLocation(xLeft, vUpper - ody);
            this.view[1].setLocation(xRight, vUpper - ody2);
            this.view[2].setLocation(xRight, vLower + ody2);
            this.view[3].setLocation(xLeft, vLower + ody);
        }
        return true;
    }

    public Point2D.Double[] getVMask(boolean screen) {
        return screen ? this.view : this.data;
    }

    public Point2D.Double getVMask(VMaskPointType pType, boolean screen) {
        Point2D.Double d = null;
        switch (pType) {
            case UL: {
                d = this.getVMaskUL(screen);
                break;
            }
            case UR: {
                d = this.getVMaskUR(screen);
                break;
            }
            case LL: {
                d = this.getVMaskLL(screen);
                break;
            }
            case LR: {
                d = this.getVMaskLR(screen);
            }
        }
        return d;
    }

    public Point2D.Double getVMaskUL(boolean screen) {
        return screen ? this.view[0] : this.data[0];
    }

    public Point2D.Double getVMaskUR(boolean screen) {
        return screen ? this.view[1] : this.data[1];
    }

    public Point2D.Double getVMaskLR(boolean screen) {
        return screen ? this.view[2] : this.data[2];
    }

    public Point2D.Double getVMaskLL(boolean screen) {
        return screen ? this.view[3] : this.data[3];
    }

    public static enum VMaskPointType {
        UL,
        UR,
        LR,
        LL;

    }
}

