/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCLineConnector;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarCircle;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarDataModel;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarGraphModel;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericPipedFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class QCStarOverlay
extends QCOverlay {
    public static final String RB_KEY = "QCStarOverlay.";
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    private boolean numericL = true;
    private Variable yvalueVar;
    private Variable[] vertexVars;
    private Variable labelVar;
    private Variable urlVar;
    private Variable groupFillVar;
    private Variable groupFillIndexVar;
    private StringVariable groupFillStringVar;
    private Variable groupLineVar;
    private Variable groupLineIndexVar;
    private StringVariable groupLineStringVar;
    private Variable spokeColorIndexVar;
    private Variable spokeLineIndexVar;
    private Variable subgrpLabelVar;
    private Variable oocVar;
    private Variable missingValueControlVar;
    private NumericVectorVariable numericXVar;
    private NetworkRoot networkTest;
    protected NumericMapper xtestMapper;
    protected NumericMapper ytestMapper;
    private Variable xtestVar;
    private Variable ytestVar;
    NumericVector[] vertexPipe = null;
    public boolean selectable = true;
    protected FillAttrs fillAttrs = new FillAttrs();
    protected LineAttrs outlineAttrs = new LineAttrs();
    protected LineAttrs refAttrs = new LineAttrs();
    protected LineAttrs spokeAttrs = new LineAttrs();
    protected LineAttrs lineAttrs = new LineAttrs();
    protected LineAttrs oocSpokeAttrs = new LineAttrs();
    protected TextStyle labelStyle = new TextStyle();
    protected TextStyle legendStyle = new TextStyle();
    private boolean fillOn = true;
    private boolean transparentFill = false;
    private boolean useFillColor = false;
    private boolean useOutlineColor = false;
    private boolean useOutlinePattern = false;
    protected ColorEncoder fillColorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected ColorEncoder oocColorEncoder;
    protected LineEncoder lineEncoder;
    protected ColorEncoder spokeColorEncoder;
    protected LineEncoder spokeLineEncoder;
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private int groupFillOrder = 0;
    private int[] groupFillsPerCategory;
    private ArrayList[] groupFillCategoryLists;
    private int[] subToColumnGroupFillCategory;
    private HashMap groupFillValue2Category;
    private String overlayFillID;
    private String[] tableEmptyGroupFills = null;
    private boolean removeEmptyGroupFills = true;
    private int nEmptyGroupFills = 0;
    private int groupLineOrder = 0;
    private int[] groupLinesPerCategory;
    private ArrayList[] groupLineCategoryLists;
    private int[] subToColumnGroupLineCategory;
    private HashMap groupLineValue2Category;
    private String overlayLineID;
    private String[] tableEmptyGroupLines = null;
    private boolean removeEmptyGroupLines = true;
    private int nEmptyGroupLines = 0;
    private int groupSpokeOrder = 0;
    private int[] groupSpokesPerCategory;
    private ArrayList[] groupSpokeCategoryLists;
    private int[] subToColumngroupSpokeCategory;
    private HashMap groupSpokeValue2Category;
    private String overlaySpokeID;
    private String[] tableEmptygroupSpokes = null;
    private boolean removeEmptygroupSpokes = true;
    private int nEmptygroupSpokes = 0;
    private QCStar star;
    public AQCStar.StarType starType;
    public double[] refValues;
    public double[] radius = new double[]{-1.0, -1.0};
    public double clipRadius;
    public double specs;
    public QCStarLabel.StarLabel labelType;
    public AQCStar.StarLegend legendType;
    public String legendLabel;
    public double startDegrees;
    public double startRadians;
    public boolean lineOut;
    public boolean fillOut;
    public boolean fillIn;
    public boolean starOut;
    public boolean spokeOut;
    public boolean refs;
    public String fillVar;
    public String fillIndexVar;
    public String outlineVar;
    public String outlineIndexVar;
    public String htmlVar;
    public Vertex[] vertex;
    public int nVertex;

    @Override
    public boolean isGlyph() {
        return true;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public boolean overrideGTLRenderingOrder(boolean highlight) {
        return highlight ? true : true;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = this.discreteX ? this.getSubsettedUniqueValueCount(this.xvalueVar, (short)10, this.numericDiscreteX) : (num = this.numericX ? this.getSubsettedValueCount(this.xvalueVar, (short)10, true) : this.getSubsettedUniqueValueCount(this.xvalueVar, (short)10, this.numericDiscreteX));
            if (num == 1 && this.numericX && this.xvalueVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                boolean subset;
                boolean bl = subset = !this.xUnionAllPages;
                newRange = this.discreteX ? (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, subset) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, subset)) : (this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, subset) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, subset));
                newRange.setLabel(this.xvalueVar.getLabel());
            } else {
                newRange = null;
            }
        } else {
            newRange = new StubRange();
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.yvalueVar != null) {
            int num = this.getSubsettedValueCount(this.yvalueVar, (short)11, true);
            if (num == 1 && this.numericY && this.yvalueVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                double[] vals;
                CRD crd = this.model;
                if (StatGraph.MPC > 0) {
                    vals = crd.getDoubleColumn(11);
                    num = vals.length;
                } else {
                    vals = this.getSubsettedDoubleColumn((short)11);
                }
                double min = Double.MAX_VALUE;
                double max = -1.7976931348623157E308;
                for (int i = 0; i < num; ++i) {
                    if (StatGraph.MPC > 0 && !this.missingCategoryOn && this.missingValueControlVar.isMissing(i)) continue;
                    if (vals[i] > max) {
                        max = vals[i];
                    }
                    if (!(vals[i] < min)) continue;
                    min = vals[i];
                }
                newRange = new ContinuousRange(min, max);
                newRange.setLabel(this.yvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 11);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        super.setChannel(channel);
        this.networkTest = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        boolean fill = AQCStar.StarType.fill(this.starType) && this.fillOn;
        double stippleScaleFactor = StatGraph.getStippleScaleFactor();
        int lineWidth = fill && !this.transparentFill ? 1 : this.outlineAttrs.getWidth();
        this.star.lineWidth.setValue((double)lineWidth);
        lineWidth = fill && !this.transparentFill ? 1 : this.spokeAttrs.getWidth();
        this.star.spokeWidth.setValue((double)lineWidth);
        int linePattern = this.outlineAttrs.linePattern;
        int stipplePattern = SASLinePatterns.getStipplePattern((int)linePattern);
        int stippleFactor = (int)(0.5 + stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)linePattern));
        this.star.setStipple(stipplePattern, stippleFactor);
        linePattern = this.oocLineStyle.linePattern;
        stipplePattern = SASLinePatterns.getStipplePattern((int)linePattern);
        stippleFactor = (int)(0.5 + stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)linePattern));
        this.star.setOOCStipple(stipplePattern, stippleFactor);
        this.star.useColorAlpha = true;
        if (this.star.useColorAlpha) {
            float op;
            this.star.infillOpacity = op = this.transparentFill ? 0.0f : ((double)this.infillOpacity == 0.0 ? 0.0f : this.infillOpacity);
        }
        this.networkRoot.draw(channel, false);
    }

    public void drawInfill(Object p) {
        this.drawInFill((Graphics)p, false);
    }

    @Override
    public void drawInFill(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        if (this.networkRoot == null) {
            return;
        }
        if (!this.fillOn) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        boolean fill = AQCStar.StarType.fill(this.starType) && this.fillOn;
        boolean spokes = AQCStar.StarType.spokes(this.starType);
        boolean edges = AQCStar.StarType.edge(this.starType);
        boolean labels = this.star.labelsOn.getValue();
        boolean refs = this.star.refsOn.getValue();
        this.star.labelsOn.setValue(false);
        this.star.edgeOn.setValue(false);
        this.star.spokesOn.setValue(false);
        this.star.refsOn.setValue(false);
        float op = this.transparentFill ? 0.0f : ((double)this.infillOpacity == 0.0 ? 0.0f : (highlightDraw ? this.overlapOpacity : this.infillOpacity));
        this.star.useColorAlpha = false;
        if (this.star.useColorAlpha) {
            this.star.infillOpacity = op;
            this.networkRoot.draw(channel, false);
        } else {
            Composite old = g.getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, op);
            g.setComposite(ac);
            this.networkRoot.draw(channel, false);
            g.setComposite(old);
        }
        this.star.labelsOn.setValue(labels);
        this.star.edgeOn.setValue(edges);
        this.star.spokesOn.setValue(spokes);
        this.star.refsOn.setValue(refs);
    }

    public void drawOutFill(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
    }

    @Override
    public void drawOutline(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        double stippleScaleFactor = StatGraph.getStippleScaleFactor();
        boolean fill = AQCStar.StarType.fill(this.starType) && this.fillOn;
        boolean refs = this.star.refsOn.getValue();
        this.star.fillOn.setValue(false);
        this.star.refsOn.setValue(refs);
        int lineWidth = fill && !this.transparentFill ? 1 : this.outlineAttrs.getWidth();
        this.star.lineWidth.setValue((double)lineWidth);
        lineWidth = fill && !this.transparentFill ? 1 : this.spokeAttrs.getWidth();
        this.star.spokeWidth.setValue((double)lineWidth);
        int linePattern = this.outlineAttrs.linePattern;
        int stipplePattern = SASLinePatterns.getStipplePattern((int)linePattern);
        int stippleFactor = (int)(0.5 + stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)linePattern));
        this.star.setStipple(stipplePattern, stippleFactor);
        linePattern = this.oocLineStyle.linePattern;
        stipplePattern = SASLinePatterns.getStipplePattern((int)linePattern);
        stippleFactor = (int)(0.5 + stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)linePattern));
        this.star.setOOCStipple(stipplePattern, stippleFactor);
        this.networkRoot.draw(channel, false);
        this.star.fillOn.setValue(fill);
        this.star.refsOn.setValue(refs);
        lineWidth = this.outlineAttrs.getWidth();
        this.star.lineWidth.setValue((double)lineWidth);
        lineWidth = this.spokeAttrs.getWidth();
        this.star.spokeWidth.setValue((double)lineWidth);
    }

    @Override
    public void drawRunsTestHighlight(Graphics p) {
        Graphics2D g = (Graphics2D)p;
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
    }

    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.fillColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 54) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.spokeColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 55) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            this.spokeLineEncoder = (LineEncoder)encoder;
        }
        this.needConnect = true;
    }

    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
    }

    public void setModel(CRD aModel, CRD aModel2) {
        super.setModel(aModel);
        this.model2 = aModel2;
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
    }

    public boolean connectNetwork() {
        boolean connectOn;
        StringToNumericMapper translate;
        int markerSize;
        String gval;
        int i;
        if (this.xRange == null || this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        int nobs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        ValueMap map = this.xEncoder.getValueMap();
        if (this.discreteX) {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
        } else if (this.numericX) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
        }
        map = this.yEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        if (!(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
            this.yvalueMapper = new ContinuousRangeToNumericMapper();
        }
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            if (!this.discreteX) {
                this.xvalueVar.setFormat(new GTKFormat((Format)format));
            }
        } else if (this.xvalueVar != null && this.numericX) {
            this.xvalueVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
        }
        format = this.yEncoder.getInput().getFormat();
        if (format != null) {
            this.yvalueVar.setFormat(new GTKFormat((Format)format));
        } else if (this.numericY) {
            this.yvalueVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
        }
        ColorVector colorPipe = null;
        BooleanVector fillOnPipe = null;
        if (this.groupFillVar != null && this.fillColorEncoder != null) {
            colorPipe = new ColorVector();
            fillOnPipe = new BooleanVector();
            StringToColorMap cmap = (StringToColorMap)this.fillColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (i = 0; i < nobs; ++i) {
                Color c = null;
                boolean b = true;
                try {
                    gval = this.groupFillStringVar.value.getValue(i);
                    if (this.isEmptyGroup(gval)) {
                        c = null;
                        b = false;
                    } else {
                        c = this.groupFillIndexVar == null ? cmap.getValue(gval) : this.getIndexFillColor(this.fillColorEncoder, gval, (ColorAttr)this.fillAttrs);
                    }
                }
                catch (MissingValueException e) {
                    c = this.applyInfillTransparency((ColorAttr)this.fillAttrs);
                }
                colorPipe.addValue(c);
                fillOnPipe.addValue(b);
            }
        }
        ColorVector lineColorPipe = null;
        if (this.groupLineVar != null && this.lineColorEncoder != null) {
            lineColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.lineColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (i = 0; i < nobs; ++i) {
                Color c;
                try {
                    gval = this.groupLineStringVar.value.getValue(i);
                    c = this.isEmptyGroup(gval) ? this.applyDataTransparency((ColorAttr)this.outlineAttrs) : (this.groupLineIndexVar == null ? cmap.getValue(gval) : this.getIndexLineColor(this.lineColorEncoder, gval, (ColorAttr)this.outlineAttrs));
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)this.outlineAttrs);
                }
                lineColorPipe.addValue(c);
            }
        }
        ColorVector spokeColorPipe = null;
        if (this.spokeColorIndexVar != null) {
            spokeColorPipe = new ColorVector();
            if (this.spokeColorEncoder != null) {
                StringToColorMap cmap = (StringToColorMap)this.spokeColorEncoder.getValueMap();
                cmap.init(new AInitAction());
            }
            for (int i2 = 0; i2 < this.nVertex; ++i2) {
                Color c = this.getIndexSpokeColor(this.spokeColorEncoder, i2, (ColorAttr)this.spokeAttrs);
                spokeColorPipe.addValue(c);
            }
        }
        NumericVector spokeLinePipe = new NumericVector();
        for (i = 0; i < this.nVertex; ++i) {
            spokeLinePipe.addValue(1.0);
        }
        IntegerVector stipplePatternPipe = new IntegerVector();
        IntegerVector stippleFactorPipe = new IntegerVector();
        IntegerVector linePatternPipe = new IntegerVector();
        for (int i3 = 0; i3 < this.nVertex; ++i3) {
            LineAttrs ls = this.getIndexSpokeLineAttrs(this.spokeLineEncoder, i3, this.spokeAttrs);
            int stipplePattern = ls.getStipplePattern();
            int stippleFactor = ls.getStippleFactor();
            int linePattern = ls.getLinePattern();
            stipplePatternPipe.addValue(stipplePattern);
            stippleFactorPipe.addValue(stippleFactor);
            linePatternPipe.addValue(linePattern);
        }
        this.networkRoot.removeAllElements();
        int scaledMarkerSize = markerSize = 7;
        if (this.scaleMarkers) {
            double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
            double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
            scaledMarkerSize = (int)((double)markerSize * Math.pow(Math.min(ratio_w, ratio_h), 0.25) + 0.5);
            scaledMarkerSize = Math.min(markerSize, Math.max(5, scaledMarkerSize));
        }
        NumericMapper nm = this.yvalueMapper;
        ((ContinuousRangeToNumericMapper)nm).input.connectFrom(((NumericVariable)this.yvalueVar).value);
        nm = this.xvalueMapper;
        if (this.xvalueVar != null) {
            if (this.discreteX) {
                ((StringToNumericMapper)nm).input.connectFrom(((StringVariable)this.xvalueVar).value);
            } else if (this.numericX) {
                ((ContinuousRangeToNumericMapper)nm).input.connectFrom(((NumericVariable)this.xvalueVar).value);
            } else {
                ((StringToNumericMapper)nm).input.connectFrom(((StringVariable)this.xvalueVar).value);
            }
        }
        map = this.xEncoder.getValueMap();
        if (this.discreteX) {
            translate = new StringToNumericMapper();
            if (this.xvalueVar == null) {
                translate.input.setValue("a");
            } else {
                StringPipe uv = ((StringVariable)this.xvalueVar).uniqueValue;
                translate.input.connectFrom(uv);
            }
            translate.setMap((StringToNumericMap)map);
        } else if (this.numericX) {
            translate = new ContinuousRangeToNumericMapper();
            NumericPipe uv = ((NumericVariable)this.xvalueVar).uniqueValue;
            ((ContinuousRangeToNumericMapper)translate).input.connectFrom(uv);
            ((ContinuousRangeToNumericMapper)translate).setMap((ContinuousRangeToNumericMap)map);
        } else {
            translate = new StringToNumericMapper();
            if (this.xvalueVar == null) {
                translate.input.setValue("a");
            } else {
                StringPipe uv = ((StringVariable)this.xvalueVar).uniqueValue;
                translate.input.connectFrom(uv);
            }
            translate.setMap((StringToNumericMap)map);
        }
        DiscreteAttrMapper groupAttrMapper = this.groupFillVar != null && this.hasAttrVar("TUKEYGROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP") : null;
        ColorVector qcColorPipe = null;
        ColorVector oocLineColorPipe = null;
        if (this.starOut && this.oocVar != null) {
            Color ci;
            double d;
            int i4;
            if (colorPipe == null) {
                qcColorPipe = new ColorVector();
                fillOnPipe = new BooleanVector();
                oocLineColorPipe = new ColorVector();
                for (i4 = 0; i4 < nobs; ++i4) {
                    d = (Double)Variable.getValue((Variable)this.oocVar, (int)i4, (boolean)false);
                    ci = d == 1.0 ? this.applyInfillTransparency((ColorAttr)this.oocFillStyle) : this.applyInfillTransparency((ColorAttr)this.fillAttrs);
                    Color co = d == 1.0 ? this.applyDataTransparency((ColorAttr)this.oocLineStyle) : this.applyDataTransparency((ColorAttr)this.outlineAttrs);
                    qcColorPipe.addValue(ci);
                    fillOnPipe.addValue(this.fillOn);
                    oocLineColorPipe.addValue(co);
                }
            } else {
                for (i4 = 0; i4 < nobs; ++i4) {
                    d = (Double)Variable.getValue((Variable)this.oocVar, (int)i4, (boolean)false);
                    if (d != 1.0) continue;
                    ci = this.applyDataTransparency((ColorAttr)this.oocFillStyle);
                    colorPipe.setValueAt(ci, i4);
                }
            }
        }
        ColorProperty fillColorProperty = new ColorProperty();
        BooleanProperty fillOnProperty = new BooleanProperty();
        if (qcColorPipe != null) {
            fillColorProperty.connectFrom((ColorPipe)qcColorPipe);
            fillOnProperty.connectFrom((BooleanPipe)fillOnPipe);
        } else if (this.fillColorEncoder == null || this.useFillColor) {
            fillColorProperty.setValue(this.applyInfillTransparency((ColorAttr)this.fillAttrs));
            fillOnProperty.setValue(this.fillOn);
        } else {
            fillColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? colorPipe : groupAttrMapper.fillColor));
            fillOnProperty.connectFrom((BooleanPipe)fillOnPipe);
        }
        ColorProperty lineColorProperty = new ColorProperty();
        if (oocLineColorPipe != null) {
            lineColorProperty.connectFrom((ColorPipe)oocLineColorPipe);
        } else if (this.lineColorEncoder == null || this.useOutlineColor) {
            lineColorProperty.setValue(this.applyDataTransparency(this.outlineAttrs.getColor()));
        } else {
            lineColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        int nx = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        boolean fill = AQCStar.StarType.fill(this.starType) && this.fillOn;
        int lineWidth = fill ? 1 : this.outlineAttrs.getWidth();
        this.star.setLowerSubgrpIndex(igrpLower);
        this.star.setUpperSubgrpIndex(igrpUpper);
        this.star.edgeOn.setValue(AQCStar.StarType.edge(this.starType));
        this.star.fillOn.setValue(this.fillOn || this.transparentFill);
        this.star.spokesOn.setValue(AQCStar.StarType.spokes(this.starType));
        this.star.refsOn.setValue(this.refs);
        this.star.setEncoder((byte)1, (Encoder)this.xEncoder);
        this.star.setEncoder((byte)2, (Encoder)this.yEncoder);
        this.star.setSubgrpMapper(this.xvalueMapper);
        this.star.setResponseMapper(this.yvalueMapper);
        this.oocFillColor.setValue(this.applyDataTransparency((ColorAttr)this.oocFillStyle));
        this.oocLineColor.setValue(this.applyDataTransparency((ColorAttr)this.oocLineStyle));
        this.star.color.connectFrom((ColorPipe)fillColorProperty);
        this.star.outspokeColor.setValue(this.oocSpokeAttrs.getColor());
        this.star.outfillColor.setValue(this.oocFillStyle.getColor());
        this.star.outfillOn.setValue(this.fillOut);
        this.star.spokeOutOn.setValue(this.spokeOut);
        this.star.edgeColor.connectFrom((ColorPipe)lineColorProperty);
        this.star.setSpokeColors(spokeColorPipe);
        this.star.lineWidth.setValue((double)lineWidth);
        this.star.setSpokePatterns(spokeLinePipe);
        this.star.setSpokeStipplePatterns(stipplePatternPipe);
        this.star.setSpokeStippleFactors(stippleFactorPipe);
        this.star.transform.translateX.connectFrom(this.xvalueMapper.value);
        this.star.transform.translateY.connectFrom(this.yvalueMapper.value);
        this.star.selectEnabled.setValue(this.selectable);
        this.star.setUserData(this.probe);
        this.star.buildJ2D();
        this.networkRoot.addElement((Element)this.star);
        if (this.refs && this.refValues != null) {
            int n = this.refValues.length;
            QCStarCircle[] circles = new QCStarCircle[n];
            Color color = this.refAttrs.getColor();
            for (int i5 = 0; i5 < n; ++i5) {
                QCStarCircle circle = new QCStarCircle();
                circle.setLowerSubgrpIndex(igrpLower);
                circle.setUpperSubgrpIndex(igrpUpper);
                double radius = this.star.getRValue(this.refValues[i5]);
                circle.radius.setValue(radius);
                circle.edgeOn.setValue(true);
                circle.fillOn.setValue(false);
                circle.edgeColor.setValue(color);
                circle.color.setValue(color);
                circle.precision.setValue(200);
                circle.transform.translateX.connectFrom(this.xvalueMapper.value);
                circle.transform.translateY.connectFrom(this.yvalueMapper.value);
                circles[i5] = circle;
            }
            this.star.refs = circles;
        }
        if ((connectOn = true) && this.xvalueVar != null) {
            ContinuousRangeToNumericMapper crnm = new ContinuousRangeToNumericMapper();
            crnm.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
            crnm.input.connectFrom(((NumericVariable)this.yvalueVar).value);
            QCLineConnector line = new QCLineConnector();
            line.setLowerSubgrpIndex(igrpLower);
            line.setUpperSubgrpIndex(igrpUpper);
            line.color.setValue(this.applyDataTransparency(this.lineAttrs.getColor()));
            line.lineWidth.setValue((double)this.lineAttrs.getWidth());
            line.setStipple(this.lineAttrs.getStipplePattern(), this.lineAttrs.getStippleFactor());
            line.pointZ.setValue(0.0);
            line.pointX.connectFrom((NumericPipe)translate);
            line.pointY.connectFrom(crnm.value);
            this.star.connect = line;
        }
        if (this.star.labelsOn.getValue()) {
            QCStarGraphModel graphModel = this.star.getGraphModel();
            Variable[] xVar = graphModel.getLabelXVars();
            Variable[] yVar = graphModel.getLabelYVars();
            int[] jh = graphModel.getJustification(1);
            int[] jv = graphModel.getJustification(2);
            QCStarLabel[] labels = new QCStarLabel[this.nVertex];
            int igrp = 1;
            double y = 0.0;
            for (int i6 = 0; i6 < this.nVertex; ++i6) {
                QCStarLabel label;
                labels[i6] = label = new QCStarLabel();
                label.setLowerSubgrpIndex(igrpLower);
                label.setUpperSubgrpIndex(igrpUpper);
                String str = this.vertexVars[i6].getLabel();
                label.string.setValue(str);
                NumericPipe xPipe = ((NumericVariable)xVar[i6]).value;
                NumericPipe yPipe = ((NumericVariable)yVar[i6]).value;
                try {
                    y = yPipe.getValue(igrp);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                label.coordX.connectFrom(xPipe);
                label.coordY.connectFrom(yPipe);
                label.transform.translateX.connectFrom(this.xvalueMapper.value);
                label.transform.translateY.connectFrom(this.yvalueMapper.value);
                label.verticalJustification.setValue(jv[i6]);
                label.horizontalJustification.setValue(jh[i6]);
                label.color.setValue(this.labelStyle.getColor());
                label.setFont(this.labelStyle.getFont());
                label.labelType = this.labelType;
                this.star.labels = labels;
            }
            boolean bl = true;
        } else {
            this.star.labels = null;
        }
        this.needConnect = false;
        return true;
    }

    private boolean connectTestNetwork() {
        StringPipe uv;
        StringToNumericMapper translate;
        NumericMapper nm;
        this.xtestMapper = this.xvalueMapper;
        this.ytestMapper = this.yvalueMapper;
        this.networkTest.removeAllElements();
        if (this.xtestVar != null) {
            nm = this.xtestMapper;
            if (this.discreteX) {
                ((StringToNumericMapper)nm).input.connectFrom(((StringVariable)this.xtestVar).value);
            } else if (this.numericX) {
                ((ContinuousRangeToNumericMapper)nm).input.connectFrom(((NumericVariable)this.xtestVar).value);
            } else {
                ((StringToNumericMapper)nm).input.connectFrom(((StringVariable)this.xtestVar).value);
            }
        }
        if (this.ytestVar != null) {
            nm = this.ytestMapper;
            ((ContinuousRangeToNumericMapper)nm).input.connectFrom(((NumericVariable)this.ytestVar).value);
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (this.discreteX) {
            translate = new StringToNumericMapper();
            if (this.xtestVar == null) {
                translate.input.setValue("a");
            } else {
                uv = ((StringVariable)this.xtestVar).uniqueValue;
                translate.input.connectFrom(uv);
            }
            translate.setMap((StringToNumericMap)map);
        } else if (this.numericX) {
            translate = new ContinuousRangeToNumericMapper();
            uv = ((NumericVariable)this.xtestVar).uniqueValue;
            ((ContinuousRangeToNumericMapper)translate).input.connectFrom((NumericPipe)uv);
            ((ContinuousRangeToNumericMapper)translate).setMap((ContinuousRangeToNumericMap)map);
        } else {
            translate = new StringToNumericMapper();
            if (this.xtestVar == null) {
                translate.input.setValue("a");
            } else {
                uv = ((StringVariable)this.xtestVar).uniqueValue;
                translate.input.connectFrom(uv);
            }
            translate.setMap((StringToNumericMap)map);
        }
        int nx = this.xtestVar == null ? 1 : this.xtestVar.getUniqueValueCount();
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        if (this.xtestVar != null) {
            ContinuousRangeToNumericMapper crnm = new ContinuousRangeToNumericMapper();
            crnm.shareMap((ContinuousRangeToNumericMapper)this.ytestMapper);
            crnm.input.connectFrom(((NumericVariable)this.ytestVar).value);
            QCLineConnector line = new QCLineConnector();
            line.setLowerSubgrpIndex(igrpLower);
            line.setUpperSubgrpIndex(igrpUpper);
            line.color.setValue(this.applyDataTransparency(this.lineAttrs.getColor()));
            line.lineWidth.setValue((double)this.lineAttrs.getWidth());
            line.setStipple(this.lineAttrs.getStipplePattern(), this.lineAttrs.getStippleFactor());
            line.pointZ.setValue(0.0);
            line.pointX.connectFrom((NumericPipe)translate);
            line.pointY.connectFrom(crnm.value);
            this.networkTest.addElement((Element)line);
        }
        if (this.star.labelsOn.getValue()) {
            QCStarGraphModel graphModel = this.star.getGraphModel();
            Variable[] xVar = graphModel.getLabelXVars();
            Variable[] yVar = graphModel.getLabelYVars();
            int[] jh = graphModel.getJustification(1);
            int[] jv = graphModel.getJustification(2);
            for (int i = 0; i < this.nVertex; ++i) {
                QCStarLabel label = new QCStarLabel();
                label.setLowerSubgrpIndex(igrpLower);
                label.setUpperSubgrpIndex(igrpUpper);
                String str = this.vertexVars[i].getLabel();
                label.string.setValue(str);
                NumericPipe xPipe = ((NumericVariable)xVar[i]).value;
                NumericPipe yPipe = ((NumericVariable)yVar[i]).value;
                label.coordX.connectFrom(xPipe);
                label.coordY.connectFrom(yPipe);
                label.transform.translateX.connectFrom(this.xtestMapper.value);
                label.transform.translateY.connectFrom(this.ytestMapper.value);
                label.verticalJustification.setValue(jv[i]);
                label.horizontalJustification.setValue(jh[i]);
                label.color.setValue(this.labelStyle.getColor());
                label.setFont(this.labelStyle.getFont());
                label.labelType = this.labelType;
                this.networkRoot.addElement((Element)label);
            }
        }
        return true;
    }

    protected void connectVars() {
        boolean b;
        if (this.model.isAvailable(10)) {
            this.numericX = this.model.getColumnClass(10) == Double.class;
            Variable variable = this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (!this.missingCategoryOn) {
                this.missingValueControlVar = this.connectRaw((short)10);
            }
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xvalueVar = null;
            this.numericX = false;
        }
        if (this.model.isAvailable(11)) {
            this.numericY = this.model.getColumnClass(11) == Double.class;
            this.yvalueVar = this.connectRaw((short)11);
        } else {
            this.yvalueVar = null;
        }
        if (this.model.isAvailable(3)) {
            this.groupFillVar = this.connectRaw((short)3);
            this.groupFillVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.groupFillStringVar = (StringVariable)this.connectCategory((short)3, true);
        } else {
            this.groupFillVar = null;
        }
        this.groupFillIndexVar = this.model.isAvailable(44) ? this.connectRaw((short)44) : null;
        if (this.model.isAvailable(46)) {
            this.groupLineVar = this.connectRaw((short)46);
            this.groupLineVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.groupLineStringVar = (StringVariable)this.connectCategory((short)46, true);
        } else {
            this.groupLineVar = null;
        }
        this.groupLineIndexVar = this.model.isAvailable(795) ? this.connectRaw((short)795) : (this.model.isAvailable(44) ? this.connectRaw((short)44) : null);
        this.subgrpLabelVar = this.model.isAvailable(798) ? this.connectRaw((short)798) : null;
        this.oocVar = this.model.isAvailable(796) ? this.connectRaw((short)796) : null;
        this.urlVar = this.connectCategory((short)52, false);
        this.vertexVars = new Variable[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            int role = 740 + i;
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(role);
            this.vertexVars[i] = this.connectRaw((short)role);
            Vertex v = this.vertex[i];
            v.varLabel = cmd.getLabel();
            v.varName = cmd.getName();
        }
        this.spokeColorIndexVar = null;
        this.spokeLineIndexVar = null;
        if (this.model2 != null) {
            int nx;
            this.switchModels();
            if (this.model.isAvailable(733)) {
                // empty if block
            }
            if (this.model.isAvailable(734)) {
                // empty if block
            }
            if (this.model.isAvailable(735)) {
                // empty if block
            }
            if (this.model.isAvailable(736)) {
                this.spokeColorIndexVar = this.connectRaw((short)736);
                Object value = null;
                nx = this.model2.getRowCount();
                value = nx > 0 ? Variable.getValue((Variable)this.spokeColorIndexVar, (int)0, (boolean)false) : null;
                Object object = value = nx > 1 ? Variable.getValue((Variable)this.spokeColorIndexVar, (int)1, (boolean)false) : null;
            }
            if (this.model.isAvailable(737)) {
                this.spokeLineIndexVar = this.connectRaw((short)737);
                Object value = null;
                nx = this.model2.getRowCount();
                value = nx > 0 ? Variable.getValue((Variable)this.spokeLineIndexVar, (int)0, (boolean)false) : null;
                value = nx > 1 ? Variable.getValue((Variable)this.spokeLineIndexVar, (int)1, (boolean)false) : null;
            }
            this.switchModels();
        }
        if (this.model.isAvailable(5)) {
            this.numericL = this.model.getColumnClass(5) == Double.class;
            this.labelVar = this.connectCategory((short)5, false);
        } else {
            this.labelVar = null;
        }
        if (this.model.isAvailable(787)) {
            NumericVariable str = (NumericVariable)this.connectRaw((short)787);
            int nx = this.model.getRowCount();
            Object value = nx > 0 ? Variable.getValue((Variable)str, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)str, (int)1, (boolean)false) : null;
        }
        this.xtestVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
        this.ytestVar = this.connectRaw((short)11);
        int[] obs = null;
        int obsCount = 0;
        boolean subset = false;
        if (!this.missingCategoryOn && this.missingValueControlVar != null) {
            int count = this.missingValueControlVar.getValueCount();
            obs = new int[count];
            for (int i = 0; i < count; ++i) {
                if (this.missingValueControlVar.isMissing(i)) continue;
                obs[obsCount++] = i;
            }
            if (obsCount < count) {
                subset = true;
            }
        }
        VariableProcessor vp = null;
        if (!(this.model.getSortRole() != 10 && !subset || this.xvalueVar == null && this.model.whereExpression == null)) {
            vp = new VariableProcessor();
            if (this.xvalueVar != null) {
                vp.addVariable(this.xvalueVar);
                if (this.model.getSortRole() == 10) {
                    vp.setSort(this.xvalueVar, 1);
                }
            }
            if (this.numericXVar != null) {
                vp.addVariable((Variable)this.numericXVar);
            }
            if (this.urlVar != null) {
                vp.addVariable(this.urlVar);
            }
            if (subset) {
                vp.addVariable(this.yvalueVar);
                this.addVarToVP(vp, this.labelVar);
                vp.setSubsetByObservation(obs, obsCount);
                this.model.subsetObs = obs;
                this.model.subsetObsCount = obsCount;
            }
            this.addCRDWhereClause(vp);
        }
        this.star = new QCStar(this.starType);
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        this.star.setLowerSubgrpIndex(igrpLower);
        this.star.setUpperSubgrpIndex(igrpUpper);
        this.star.setY(this.ytestVar);
        this.star.setVertexVars(this.vertexVars);
        this.star.setStartDegree(this.startDegrees);
        if (this.radius[0] == -1.0 && this.radius[1] == -1.0 && this.clipRadius == -1.0) {
            this.star.setDefaultRadius(1.0);
        } else {
            this.star.setUserRadius(this.radius[0], this.radius[1], this.clipRadius);
        }
        this.star.setLabelStyle(this.labelStyle);
        this.star.labelType.setValue((double)QCStarLabel.StarLabel.toInteger(this.labelType));
        switch (this.labelType) {
            case FIRST: 
            case ALL: 
            case LOW: 
            case HIGH: 
            case OUT: {
                b = true;
                break;
            }
            default: {
                b = false;
            }
        }
        this.star.labelsOn.setValue(b);
        this.star.build();
        this.createInternalVariables();
        CRD crd = this.model;
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            if (this.probeID != null) {
                this.probe.addString(this.probeIDLabel, "" + this.probeID);
            }
            if (this.urlVar != null) {
                this.probe.addPipe("_URL_", (Pipe)((StringVariable)this.urlVar).value);
            }
            String xName = "";
            if (this.subgrpLabelVar != null) {
                xName = this.subgrpLabelVar.getLabel();
                this.probe.addPipe(xName, (Pipe)((StringVariable)this.subgrpLabelVar).uniqueValue);
            } else if (this.xvalueVar != null) {
                xName = this.xvalueVar.getLabel();
                if (this.discreteX) {
                    this.probe.addPipe(xName, (Pipe)((StringVariable)this.xvalueVar).uniqueValue);
                } else if (this.numericX) {
                    this.probe.addPipe(xName, (Pipe)((NumericVariable)this.xvalueVar).formattedValue);
                } else {
                    this.probe.addPipe(xName, (Pipe)((StringVariable)this.xvalueVar).uniqueValue);
                }
            }
            this.addTooltip(vp, "Y");
            SASFormat sfmt = this.getFormat(11);
            GTKFormat fmt = sfmt == null ? new GTKFormat((Format)DataModel.defaultFormat) : new GTKFormat((Format)sfmt);
            String label = null;
            for (int i = 0; i < this.nVertex; ++i) {
                NumericPipedFormat pipe = new NumericPipedFormat();
                pipe.setFormat(fmt);
                pipe.input.connectFrom((NumericPipe)this.vertexPipe[i]);
                label = this.vertexVars[i].getLabel();
                this.probe.addPipe(label, (Pipe)pipe);
            }
        }
    }

    private void createInternalVariables() {
        int i;
        if (this.groupFillVar != null) {
            this.createGroupFillVariables();
        }
        if (this.groupLineVar != null) {
            this.createGroupLineVariables();
        }
        int nobs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        QCStarDataModel dataModel = this.star.getDataModel();
        double[][] v = dataModel.getVertices();
        if (this.vertexPipe == null) {
            this.vertexPipe = new NumericVector[this.nVertex];
            for (i = 0; i < this.nVertex; ++i) {
                this.vertexPipe[i] = new NumericVector();
            }
        } else {
            for (i = 0; i < this.nVertex; ++i) {
                this.vertexPipe[i].removeAllValues();
            }
        }
        for (i = 0; i < nobs; ++i) {
            for (int j = 0; j < this.nVertex; ++j) {
                double d = v[i][j];
                this.vertexPipe[j].addValue(d);
            }
        }
    }

    private void createGroupFillVariables() {
        if (this.groupFillVar == null) {
            return;
        }
        String[] groups = null;
        IntegerPipe groupCategory = null;
        String[] gString = this.model.isAvailable(3) ? this.model.getStringAsClassColumn(3, true) : null;
        this.updateNumberOfGroupFillsPerCategory();
        groups = this.groupFillVar instanceof NumericVariable ? this.getSubsettedDoubleAsClassColumn((short)3) : this.getSubsettedStringAsClassColumn((short)3);
        groupCategory = this.groupFillVar instanceof NumericVariable ? ((NumericVariable)this.groupFillVar).category : ((StringVariable)this.groupFillVar).category;
        this.groupFillValue2Category = new HashMap();
        int nobs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        for (int i = 0; i < nobs; ++i) {
            String group = groups[i];
            int gcat = 0;
            try {
                gcat = groupCategory.getValue(i);
                if (gString != null) {
                    gcat = this.removeEmptyGroups(gcat, gString[i]);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (group.equalsIgnoreCase("Empty") || group.equalsIgnoreCase("None") || this.groupFillValue2Category.containsKey(group)) continue;
            this.groupFillValue2Category.put(group, new Integer(gcat));
        }
    }

    private void createGroupLineVariables() {
        if (this.groupLineVar == null) {
            return;
        }
        String[] groups = null;
        IntegerPipe groupCategory = null;
        String[] gString = this.model.isAvailable(46) ? this.model.getStringAsClassColumn(46, true) : null;
        this.updateNumberOfGroupLinesPerCategory();
        groups = this.groupLineVar instanceof NumericVariable ? this.getSubsettedDoubleAsClassColumn((short)46) : this.getSubsettedStringAsClassColumn((short)46);
        groupCategory = this.groupLineVar instanceof NumericVariable ? ((NumericVariable)this.groupLineVar).category : ((StringVariable)this.groupLineVar).category;
        this.groupLineValue2Category = new HashMap();
        int nobs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        for (int i = 0; i < nobs; ++i) {
            String group = groups[i];
            int gcat = 0;
            try {
                gcat = groupCategory.getValue(i);
                if (gString != null) {
                    gcat = this.removeEmptyGroups(gcat, gString[i]);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (group.equalsIgnoreCase("Empty") || group.equalsIgnoreCase("None") || this.groupLineValue2Category.containsKey(group)) continue;
            this.groupLineValue2Category.put(group, new Integer(gcat));
        }
    }

    public boolean isGroupAllMissings() {
        if (this.model == null) {
            return true;
        }
        if (this.model.isAvailable(3) || this.model.isAvailable(3)) {
            return false;
        }
        return false;
    }

    public String[] getGroupFillValues() {
        return this.getGroupFillValues(false);
    }

    public String[] getGroupLineValues() {
        return this.getGroupLineValues(false);
    }

    public String[] getGroupFillValues(boolean deleteEmpty) {
        String gval;
        int i;
        if (this.groupFillVar == null) {
            return new String[0];
        }
        String[] values = this.groupFillOrder == 0 ? this.getUniqueGroupValues((short)3) : this.getUniqueGroupValues((short)3, this.groupFillOrder == 1 ? 1 : 2);
        if (!deleteEmpty) {
            return values;
        }
        int n = values.length;
        int nEmpty = 0;
        for (i = 0; i < n; ++i) {
            gval = values[i];
            if (!gval.equalsIgnoreCase("Empty") && !gval.equalsIgnoreCase("None")) continue;
            ++nEmpty;
        }
        if (n == nEmpty) {
            return new String[0];
        }
        String[] gv = new String[n - nEmpty];
        int j = 0;
        for (i = 0; i < n; ++i) {
            gval = values[i];
            if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) continue;
            gv[j++] = values[i];
        }
        return gv;
    }

    public String[] getGroupLineValues(boolean deleteEmpty) {
        String gval;
        int i;
        if (this.groupLineVar == null) {
            return new String[0];
        }
        String[] values = this.groupLineOrder == 0 ? this.getUniqueGroupValues((short)46) : this.getUniqueGroupValues((short)46, this.groupFillOrder == 1 ? 1 : 2);
        if (!deleteEmpty) {
            return values;
        }
        int n = values.length;
        int nEmpty = 0;
        for (i = 0; i < n; ++i) {
            gval = values[i];
            if (!gval.equalsIgnoreCase("Empty") && !gval.equalsIgnoreCase("None")) continue;
            ++nEmpty;
        }
        if (n == nEmpty) {
            return new String[0];
        }
        String[] gv = new String[n - nEmpty];
        int j = 0;
        for (i = 0; i < n; ++i) {
            gval = values[i];
            if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) continue;
            gv[j++] = values[i];
        }
        return gv;
    }

    public Color[] getGroupFillColors() {
        return this.getGroupColors(true);
    }

    public Color[] getGroupLineColors() {
        return this.getGroupColors(false);
    }

    public Color[] getGroupColors(boolean fill) {
        Color[] colors = new Color[]{};
        if (fill) {
            HashMap ht = this.fillColorEncoder.colorList;
            String[] values = this.getGroupFillValues();
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                String gval = values[i];
                if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) {
                    colors[i] = null;
                    continue;
                }
                if (colors[i] != null) continue;
                colors[i] = this.groupFillIndexVar == null ? (Color)ht.get(gval) : this.getIndexFillColor(this.fillColorEncoder, gval, (ColorAttr)this.fillAttrs);
            }
        } else {
            HashMap ht = this.lineColorEncoder.colorList;
            String[] values = this.getGroupLineValues();
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                String gval = values[i];
                if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) {
                    colors[i] = null;
                    continue;
                }
                if (colors[i] != null) continue;
                colors[i] = this.groupLineIndexVar == null ? (Color)ht.get(gval) : this.getIndexLineColor(this.lineColorEncoder, gval, (ColorAttr)this.outlineAttrs);
            }
        }
        return colors;
    }

    private void updateNumberOfGroupFillsPerCategory() {
        int numCats;
        if (this.groupFillVar == null) {
            return;
        }
        int n = numCats = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        if (numCats == 0) {
            return;
        }
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayFillID = this.model.getColumnName((short)11) + "." + this.model.getColumnName((short)3);
        if (this.isMissingGroupOn()) {
            this.overlayFillID = this.overlayFillID + ".MissingGroup";
        }
        int maxGroups = this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayFillID) != null ? (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayFillID) : 1;
        this.groupFillsPerCategory = new int[numCats];
        for (int i = 0; i < this.xvalueVar.getValueCount(); ++i) {
            this.groupFillsPerCategory[i] = 1;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayFillID, new Integer(maxGroups));
        this.groupFillCategoryLists = this.getGroupFillCategoryLists();
    }

    private void updateNumberOfGroupLinesPerCategory() {
        int numCats;
        if (this.groupLineVar == null) {
            return;
        }
        int n = numCats = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        if (numCats == 0) {
            return;
        }
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayLineID = this.model.getColumnName((short)11) + "." + this.model.getColumnName((short)46);
        if (this.isMissingGroupOn()) {
            this.overlayLineID = this.overlayLineID + ".MissingGroup";
        }
        int maxGroups = this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayLineID) != null ? (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayLineID) : 1;
        this.groupLinesPerCategory = new int[numCats];
        for (int i = 0; i < this.xvalueVar.getValueCount(); ++i) {
            this.groupLinesPerCategory[i] = maxGroups;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayLineID, new Integer(maxGroups));
        this.groupLineCategoryLists = this.getGroupLineCategoryLists();
    }

    private ArrayList[] getGroupFillCategoryLists() {
        int i;
        int nGrp = this.groupFillVar.getUniqueValueCount();
        String[] gvalues = this.getGroupFillValues();
        this.sortEmptyGroups(gvalues);
        this.subToColumnGroupFillCategory = new int[nGrp];
        this.groupFillStringVar.getUniqueValueCount();
        HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
        for (i = 0; i < nGrp; ++i) {
            try {
                if (this.groupFillOrder == 0) {
                    String v = this.groupFillStringVar.uniqueValue.getValue(i);
                    int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                    groupCategory_column = this.removeEmptyGroups(groupCategory_column, v);
                    value2ColumnCategory.put(v, new Integer(groupCategory_column));
                    this.subToColumnGroupFillCategory[i] = groupCategory_column;
                    continue;
                }
                this.subToColumnGroupFillCategory[i] = i;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.xvalueVar == null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < this.groupFillVar.getUniqueValueCount(); ++i) {
                list.add(new Integer(i));
            }
            if (this.groupFillOrder != 0) {
                Collections.sort(list);
            }
            return new ArrayList[]{list};
        }
        int nCat = this.xvalueVar instanceof StringVariable ? ((StringVariable)this.xvalueVar).getUniqueValueCount() : ((NumericVariable)this.xvalueVar).getUniqueValueCount();
        ArrayList[] list = new ArrayList[nCat];
        for (i = 0; i < nCat; ++i) {
            list[i] = new ArrayList();
        }
        IntegerPipe xvalueCategory = this.xvalueVar instanceof NumericVariable ? ((NumericVariable)this.xvalueVar).category : ((StringVariable)this.xvalueVar).category;
        IntegerPipe groupCategory = this.groupFillVar instanceof NumericVariable ? ((NumericVariable)this.groupFillVar).category : ((StringVariable)this.groupFillVar).category;
        String[] gString = this.nEmptyGroupFills > 0 ? this.model.getStringAsClassColumn(3, true) : null;
        int n = this.xvalueVar.getValueCount();
        try {
            for (i = 0; i < n; ++i) {
                Integer IG;
                int xcat = xvalueCategory.getValue(i);
                int gcat = groupCategory.getValue(i);
                if (gString != null) {
                    gcat = this.removeEmptyGroups(gcat, gString[i]);
                }
                if (list[xcat].contains(IG = new Integer(gcat))) continue;
                list[xcat].add(IG);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if (this.groupFillOrder != 0) {
            for (i = 0; i < nCat; ++i) {
                Collections.sort(list[i]);
            }
        }
        return list;
    }

    private ArrayList[] getGroupLineCategoryLists() {
        int i;
        int nGrp = this.groupLineVar.getUniqueValueCount();
        String[] gvalues = this.getGroupLineValues();
        this.sortEmptyGroups(gvalues);
        this.subToColumnGroupLineCategory = new int[nGrp];
        this.groupLineStringVar.getUniqueValueCount();
        HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
        for (i = 0; i < nGrp; ++i) {
            try {
                if (this.groupFillOrder == 0) {
                    String v = this.groupLineStringVar.uniqueValue.getValue(i);
                    int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                    groupCategory_column = this.removeEmptyGroups(groupCategory_column, v);
                    value2ColumnCategory.put(v, new Integer(groupCategory_column));
                    this.subToColumnGroupLineCategory[i] = groupCategory_column;
                    continue;
                }
                this.subToColumnGroupLineCategory[i] = i;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.xvalueVar == null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < this.groupLineVar.getUniqueValueCount(); ++i) {
                list.add(new Integer(i));
            }
            if (this.groupLineOrder != 0) {
                Collections.sort(list);
            }
            return new ArrayList[]{list};
        }
        int nCat = this.xvalueVar instanceof StringVariable ? ((StringVariable)this.xvalueVar).getUniqueValueCount() : ((NumericVariable)this.xvalueVar).getUniqueValueCount();
        ArrayList[] list = new ArrayList[nCat];
        for (i = 0; i < nCat; ++i) {
            list[i] = new ArrayList();
        }
        IntegerPipe xvalueCategory = this.xvalueVar instanceof NumericVariable ? ((NumericVariable)this.xvalueVar).category : ((StringVariable)this.xvalueVar).category;
        IntegerPipe groupCategory = this.groupLineVar instanceof NumericVariable ? ((NumericVariable)this.groupLineVar).category : ((StringVariable)this.groupLineVar).category;
        String[] gString = this.nEmptyGroupLines > 0 ? this.model.getStringAsClassColumn(46, true) : null;
        int n = this.xvalueVar.getValueCount();
        try {
            for (i = 0; i < n; ++i) {
                Integer IG;
                int xcat = xvalueCategory.getValue(i);
                int gcat = groupCategory.getValue(i);
                if (gString != null) {
                    gcat = this.removeEmptyGroups(gcat, gString[i]);
                }
                if (list[xcat].contains(IG = new Integer(gcat))) continue;
                list[xcat].add(IG);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if (this.groupLineOrder != 0) {
            for (i = 0; i < nCat; ++i) {
                Collections.sort(list[i]);
            }
        }
        return list;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    private void sortEmptyGroups(String[] gvalues) {
        String gval;
        int i;
        this.nEmptyGroupFills = 0;
        this.tableEmptyGroupFills = null;
        if (!this.removeEmptyGroupFills) {
            return;
        }
        if (this.groupFillVar == null || gvalues == null) {
            return;
        }
        int n = gvalues.length;
        this.tableEmptyGroupFills = new String[n];
        int iempty = 0;
        for (i = 0; i < n; ++i) {
            gval = gvalues[i];
            if (gval.equalsIgnoreCase("Empty")) continue;
            this.tableEmptyGroupFills[iempty++] = gvalues[i];
        }
        for (i = 0; i < n; ++i) {
            gval = gvalues[i];
            if (!gval.equalsIgnoreCase("Empty")) continue;
            this.tableEmptyGroupFills[iempty++] = gvalues[i];
            ++this.nEmptyGroupFills;
        }
    }

    private int removeEmptyGroups(int gcat, String gval) {
        if (this.groupFillVar == null || this.nEmptyGroupFills == 0) {
            return gcat;
        }
        if (this.tableEmptyGroupFills == null) {
            return gcat;
        }
        int n = this.tableEmptyGroupFills.length;
        for (int i = 0; i < n; ++i) {
            String value = this.tableEmptyGroupFills[i];
            if (!gval.equals(value)) continue;
            gcat = i;
            break;
        }
        return gcat;
    }

    public Insets getPreferredInnerMargin() {
        double xWidth = this.xEncoder.getOutputMax() - this.xEncoder.getOutputMin();
        double axisLength = this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit();
        int nPanel = QCShewhart.getNPanel();
        int left = 0;
        int right = 0;
        double inner = this.radius[0];
        double outer = this.radius[1];
        double preferred = this.getPreferredRadius(axisLength, nPanel, true, outer, inner);
        Insets inset = this.computeOffsets();
        left = inset.left;
        right = inset.right;
        double niceSpace = QCMargins.getStarBetweenOffset();
        outer = axisLength - (double)(left + right);
        outer /= (double)(nPanel - 1);
        outer -= niceSpace;
        inner = this.radius[0] == -1.0 ? (this.starType == AQCStar.StarType.CORONA ? outer / 2.0 : (outer /= 2.0) / 3.0) : this.radius[0];
        QCStarGraphModel graphModel = this.star.getGraphModel();
        double starRadius = graphModel.getRadius();
        if (outer < starRadius) {
            this.setPreferredRadius(outer, inner);
            inset = this.computeOffsets();
        }
        return inset;
    }

    private Insets computeOffsets() {
        double space;
        double d;
        double offset = 0.0;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double omax = map.getOutputMax();
        double omin = map.getOutputMin();
        double imax = map.getInputMax();
        double imin = map.getInputMin();
        double ratio = Math.abs((omax - omin) / (imax - imin));
        double dflt = QCMargins.getAxisOuterY();
        int ichart = this.chart.getChartLevel();
        double xuser = QCShewhart.getUserOffset((byte)1, ichart);
        double yuser = QCShewhart.getUserOffset((byte)2, ichart);
        boolean adjusted = false;
        double x = this.getXMin();
        if (!Double.isNaN(x)) {
            offset = this.getPreferredLeftOffset();
            d = x - imin;
            space = Math.max(d * ratio, 0.0);
            if (space <= offset) {
                d = Math.ceil(offset - space);
                left += (int)d;
            }
            left = (int)((double)left + (xuser == -1.0 ? dflt : xuser));
        }
        if (!Double.isNaN(x = this.getXMax())) {
            offset = this.getPreferredRightOffset();
            d = imax - x;
            space = Math.max(d * ratio, 0.0);
            if (space <= offset) {
                d = Math.ceil(offset - space);
                right += (int)d;
            }
            right = (int)((double)right + (xuser == -1.0 ? dflt : xuser));
        }
        map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        omax = map.getOutputMax();
        omin = map.getOutputMin();
        imax = map.getInputMax();
        imin = map.getInputMin();
        ratio = Math.abs((omax - omin) / (imax - imin));
        double y = this.getYMax();
        if (!Double.isNaN(y)) {
            offset = this.getPreferredTopOffset();
            d = imax - y;
            space = Math.max(d * ratio, 0.0);
            if (space <= offset) {
                d = Math.ceil(offset - space);
                top += (int)d;
                adjusted = true;
            } else {
                adjusted = false;
            }
            if (yuser == -1.0) {
                if (adjusted) {
                    this.chart.setAdjustedTopOffsetOn(true);
                    this.chart.setAdjustedTopOffset(dflt);
                } else {
                    this.chart.setAdjustedTopOffsetOn(false);
                }
                top = (int)((double)top + dflt);
            } else {
                this.chart.setAdjustedTopOffsetOn(true);
                this.chart.setAdjustedTopOffset(dflt);
                top = (int)((double)top + 2.0 * yuser);
            }
        }
        if (!Double.isNaN(y = this.getYMin())) {
            offset = this.getPreferredBottomOffset();
            d = y - imin;
            space = Math.max(d * ratio, 0.0);
            if (space <= offset) {
                d = Math.ceil(offset - space);
                bottom += (int)d;
                adjusted = true;
            } else {
                adjusted = false;
            }
            if (yuser == -1.0) {
                if (adjusted) {
                    this.chart.setAdjustedBottomOffsetOn(true);
                    this.chart.setAdjustedBottomOffset(dflt);
                } else {
                    this.chart.setAdjustedBottomOffsetOn(false);
                }
                bottom = (int)((double)bottom + dflt);
            } else {
                this.chart.setAdjustedBottomOffsetOn(true);
                this.chart.setAdjustedBottomOffset(dflt);
                bottom = (int)((double)bottom + 2.0 * yuser);
            }
        }
        Insets inset = new Insets(top, left, bottom, right);
        return inset;
    }

    private void setPreferredRadius(double outer, double inner) {
        QCStarGraphModel graphModel = this.star.getGraphModel();
        if (graphModel == null) {
            return;
        }
        graphModel.setRadius(outer, inner);
        QCShewhart.setGlyphOffset(outer);
    }

    private double getPreferredRadius(double axisLength, double nTick, boolean saveRadius, double outer, double inner) {
        QCStarGraphModel graphModel = this.star.getGraphModel();
        if (graphModel == null) {
            return 0.0;
        }
        double radius = graphModel.computePreferredRadius(axisLength, nTick, saveRadius, outer, inner);
        return radius;
    }

    private double getXMin() {
        Object o = Variable.getValue((Variable)this.xvalueVar, (int)0, (boolean)false);
        if (!(o instanceof Double)) {
            return Double.NaN;
        }
        double d = (Double)o;
        return d;
    }

    private double getXMax() {
        int nObs = this.xvalueVar.getUniqueValueCount();
        Object o = Variable.getValue((Variable)this.xvalueVar, (int)(nObs - 1), (boolean)false);
        if (!(o instanceof Double)) {
            return Double.NaN;
        }
        double d = (Double)o;
        return d;
    }

    private double getYMin() {
        double min = Double.NaN;
        boolean init = false;
        int nObs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        for (int i = 0; i < nObs; ++i) {
            Object o = Variable.getValue((Variable)this.yvalueVar, (int)i, (boolean)false);
            if (!(o instanceof Double)) continue;
            double value = (Double)o;
            if (!init) {
                min = value;
                init = true;
                continue;
            }
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    private double getYMax() {
        double max = Double.NaN;
        boolean init = false;
        int nObs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        for (int i = 0; i < nObs; ++i) {
            Object o = Variable.getValue((Variable)this.yvalueVar, (int)i, (boolean)false);
            if (!(o instanceof Double)) continue;
            double value = (Double)o;
            if (!init) {
                max = value;
                init = true;
                continue;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private double getMaxReference() {
        if (!this.refs || this.refValues == null) {
            return 0.0;
        }
        int n = this.refValues.length;
        double max = 0.0;
        QCStarCircle[] circles = new QCStarCircle[n];
        for (int i = 0; i < n; ++i) {
            QCStarCircle circle = new QCStarCircle();
            double radius = this.star.getRValue(this.refValues[i]);
            max = Math.max(radius, max);
        }
        return max;
    }

    private int getPreferredLeftOffset() {
        double[] v = this.computeVertices(0);
        if (v == null) {
            return 0;
        }
        double d = Math.abs(v[0]);
        double ref = this.getMaxReference();
        d = Math.max(d, ref);
        return (int)(d + 0.5);
    }

    private int getPreferredRightOffset() {
        int nObs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        double[] v = this.computeVertices(nObs - 1);
        if (v == null) {
            return 0;
        }
        double d = Math.abs(v[1]);
        double ref = this.getMaxReference();
        d = Math.max(d, ref);
        return (int)(d + 0.5);
    }

    private int getPreferredTopOffset() {
        double max = Double.NaN;
        boolean init = false;
        int igrp = 0;
        int nObs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        for (int i = 0; i < nObs; ++i) {
            Object o = Variable.getValue((Variable)this.yvalueVar, (int)i, (boolean)false);
            if (!(o instanceof Double)) continue;
            double value = (Double)o;
            if (!init) {
                igrp = i;
                max = value;
                init = true;
                continue;
            }
            if (!(value > max)) continue;
            igrp = i;
            max = value;
        }
        double[] v = this.computeVertices(igrp);
        if (v == null) {
            return 0;
        }
        double d = Math.abs(v[3]);
        double ref = this.getMaxReference();
        d = Math.max(d, ref);
        return (int)(d + 0.5);
    }

    private int getPreferredBottomOffset() {
        double min = Double.NaN;
        boolean init = false;
        int igrp = 0;
        int nObs = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        for (int i = 0; i < nObs; ++i) {
            Object o = Variable.getValue((Variable)this.yvalueVar, (int)i, (boolean)false);
            if (!(o instanceof Double)) continue;
            double value = (Double)o;
            if (!init) {
                igrp = i;
                min = value;
                init = true;
                continue;
            }
            if (!(value < min)) continue;
            igrp = i;
            min = value;
        }
        double[] v = this.computeVertices(igrp);
        if (v == null) {
            return 0;
        }
        double d = Math.abs(v[2]);
        double ref = this.getMaxReference();
        d = Math.max(d, ref);
        return (int)(d + 0.5);
    }

    private double[] computeVertices(int igrp) {
        QCStarGraphModel graphModel = this.star.getGraphModel();
        if (graphModel == null) {
            return null;
        }
        return graphModel.computeVertices(igrp);
    }

    private void computeVertices() {
        QCStarGraphModel graphModel = this.star.getGraphModel();
        if (graphModel == null) {
            return;
        }
        graphModel.computeVertices();
    }

    private void validateData() {
    }

    private int getValueIndex(double value) {
        NumericPipe np = ((NumericVariable)this.xvalueVar).uniqueValue;
        int num = this.xvalueVar.getUniqueValueCount();
        int index = -1;
        try {
            for (int i = 0; i < num; ++i) {
                if (value != np.getValue(i)) continue;
                return i;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return index;
    }

    private int getValueIndex(String value) {
        StringPipe sp = ((StringVariable)this.xvalueVar).uniqueValue;
        int num = this.xvalueVar.getUniqueValueCount();
        int index = -1;
        try {
            for (int i = 0; i < num; ++i) {
                if (!value.trim().equals(sp.getValue(i).trim())) continue;
                return i;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return index;
    }

    protected void makeElements() {
    }

    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    public boolean isFillOn() {
        return true;
    }

    public double getStarWidth() {
        return this.star.getGraphRadiusOuter();
    }

    public void setStarWidth(double w) {
        this.star.setGraphRadius(w);
    }

    public LineAttrs getOutlineAttrs() {
        return this.outlineAttrs;
    }

    public boolean getFillOn() {
        return this.fillOn;
    }

    public void setRefsOn(boolean b) {
        this.refs = b;
    }

    public boolean getRefsOn() {
        return this.refs;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public void setTransparentFill(boolean b) {
        this.transparentFill = b;
    }

    public FillAttrs getFillAttrs() {
        return this.fillAttrs;
    }

    public LineAttrs getRefsAttrs() {
        return this.refAttrs;
    }

    public LineAttrs getSpokeAttrs() {
        return this.spokeAttrs;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public TextStyle getLegendStyle() {
        return this.legendStyle;
    }

    public void setLabelStyle(TextStyle ts) {
        this.labelStyle = ts;
    }

    public int[] getLinePatterns() {
        if (this.groupFillVar == null || this.lineEncoder == null || this.useOutlinePattern) {
            return new int[]{this.outlineAttrs.getLinePattern()};
        }
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getGroupLineValues();
        int[] patterns = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            DiscreteAttrMapper groupAttrMapper;
            int p;
            String gval = values[i];
            patterns[i] = -1;
            if (this.hasAttrVar("TUKEYGROUP") && (p = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getLinePattern(gval)) >= 0) {
                patterns[i] = p;
            }
            if (patterns[i] >= 0) continue;
            LineAttrs la = this.groupLineIndexVar == null ? (LineAttrs)ht.get(gval) : this.getIndexLineAttrs(this.lineEncoder, gval, this.outlineAttrs);
            patterns[i] = la.getLinePattern();
        }
        return patterns;
    }

    public int[] getLineWidths() {
        return new int[]{this.outlineAttrs.getWidth()};
    }

    public Color[] getLineColors() {
        if (this.lineColorEncoder == null) {
            return new Color[0];
        }
        if (this.groupLineVar == null || this.useOutlineColor) {
            return new Color[]{this.outlineAttrs.getColor()};
        }
        return this.getGroupLineColors();
    }

    public Color[] getFillColors() {
        if (this.fillColorEncoder == null) {
            return new Color[0];
        }
        if (this.fillOn) {
            if (this.groupFillVar == null || this.useFillColor) {
                return new Color[]{this.applyInfillTransparency((ColorAttr)this.fillAttrs)};
            }
            return this.getGroupFillColors();
        }
        return new Color[0];
    }

    public void updateNetworkElements() {
    }

    @Override
    public QCOverlay.QCClipType getClipType() {
        return QCOverlay.QCClipType.OUTER;
    }

    @Override
    public double getPhaseBoxMargin(byte dim) {
        double margin = 0.0;
        if (this.isaPhaseBoxResponse()) {
            switch (dim) {
                case 1: 
                case 2: {
                    margin = this.glyphWidth;
                    margin /= 2.0;
                    break;
                }
                default: {
                    margin = 0.0;
                }
            }
        }
        return margin;
    }

    public boolean hasLegend(int attrType) {
        boolean rc = false;
        switch (attrType) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                rc = true;
            }
        }
        return rc;
    }

    public LegendItem[] getLegendItems(int attrType) {
        LegendItem[] entries = null;
        Color[] fcolor = this.getFillColors();
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        int n2 = 0;
        boolean fill = AQCStar.StarType.fill(this.starType) && this.fillOn;
        boolean testGap = false;
        String betweenGap = "   ";
        String withinGap = " ";
        switch (attrType) {
            case 0: {
                entries = new LegendItem[this.nVertex];
                Font font = this.legendStyle.getFont();
                Color color = this.legendStyle.getColor();
                int style = font.getStyle();
                TextAttrs attr = new TextAttrs();
                attr.setFont(font);
                attr.setColor(color);
                TextAttrs attrItalic = new TextAttrs();
                attrItalic.setFont(font.deriveFont(style + 2));
                attrItalic.setColor(color);
                for (int i = 0; i < this.nVertex; ++i) {
                    Vertex v = this.vertex[i];
                    String label = v.varLabel;
                    label = v.entryValue;
                    LegendItem entry = new LegendItem((ColorAttr)attrItalic, null, label, attr);
                    label = v.entryLabel;
                    if (testGap) {
                        label = i > 0 ? betweenGap + label + withinGap : label + withinGap;
                    }
                    entries[i] = entry;
                    entries[i].setSymbolText(label);
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                String gval;
                int i;
                int n;
                String[] values = this.getGroupLineValues();
                String value = this.getLegendLabel();
                if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
                    String[] stringArray;
                    if (value == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = value;
                    }
                    values = stringArray;
                }
                int n3 = n = values == null ? 0 : values.length;
                if (n == 0) {
                    return null;
                }
                for (i = 0; i < values.length; ++i) {
                    gval = values[i];
                    if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) continue;
                    ++n2;
                }
                lcolor = this.getLineColors();
                entries = new LegendItem[n2];
                int j = 0;
                for (i = 0; i < n; ++i) {
                    int iwidth;
                    gval = values[i];
                    if (gval.equalsIgnoreCase("Empty")) continue;
                    LineAttrs attr = new LineAttrs();
                    Color color = lcolor.length > 0 ? lcolor[i % lcolor.length] : Color.BLACK;
                    attr.setColor(color);
                    int ipattern = pattern.length > 0 ? pattern[i % pattern.length] : 1;
                    attr.setLinePattern(ipattern);
                    int n4 = iwidth = width.length > 0 ? width[i % width.length] : 1;
                    if (fill) {
                        iwidth = 1;
                    }
                    attr.setWidth(iwidth);
                    entries[j] = this.skinType == 0 ? new LegendItem((ColorAttr)attr, null, gval, null) : new LegendItem((ColorAttr)attr, null, gval, null, null, this.skinType);
                    ++j;
                }
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                String gval;
                int i;
                int n;
                String[] values = this.getGroupFillValues();
                String value = this.getLegendLabel();
                if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
                    String[] stringArray;
                    if (value == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = value;
                    }
                    values = stringArray;
                }
                int n5 = n = values == null ? 0 : values.length;
                if (n == 0) {
                    return null;
                }
                for (i = 0; i < values.length; ++i) {
                    gval = values[i];
                    if (gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None")) continue;
                    ++n2;
                }
                entries = new LegendItem[n2];
                if (fcolor.length == 0) {
                    LineAttrs attr = new LineAttrs();
                    int j = 0;
                    for (i = 0; i < n; ++i) {
                        gval = values[i];
                        if (gval.equalsIgnoreCase("Empty")) continue;
                        Color color = lcolor.length > 0 ? lcolor[i % lcolor.length] : Color.BLACK;
                        attr.setColor(color);
                        int ipattern = pattern.length > 0 ? pattern[i % pattern.length] : 1;
                        attr.setLinePattern(ipattern);
                        int iwidth = width.length > 0 ? width[i % width.length] : 1;
                        attr.setWidth(iwidth);
                        entries[i] = this.skinType == 0 ? new LegendItem((ColorAttr)attr, null, gval, null) : new LegendItem((ColorAttr)attr, null, gval, null, null, this.skinType);
                        ++j;
                    }
                    return entries;
                }
                Image legendSkin = this.loadLegendSkinImage();
                Image[] legendPixelBender = this.loadLegendPixelBenderImages();
                FillAttrs attr = null;
                LineAttrs attr2 = null;
                int j = 0;
                for (i = 0; i < n; ++i) {
                    Color color;
                    gval = values[i];
                    if (gval.equalsIgnoreCase("Empty") || (color = fcolor[i % fcolor.length]) == null) continue;
                    attr = new FillAttrs();
                    attr.setColor(color);
                    attr2 = new LineAttrs();
                    attr2.setColor(Color.BLACK);
                    attr2.setLinePattern(1);
                    attr2.setWidth(1);
                    entries[j] = this.skinType == 0 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, gval, null) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, gval, null, legendSkin, this.skinType, legendPixelBender);
                    ++j;
                }
                break;
            }
        }
        return entries;
    }

    private boolean isEmptyGroup(String gval) {
        if (!this.removeEmptyGroupFills) {
            return false;
        }
        if (this.groupFillVar == null) {
            return false;
        }
        return gval.equalsIgnoreCase("Empty") || gval.equalsIgnoreCase("None");
    }

    private Color getIndexLineColor(ColorEncoder encoder, String value, ColorAttr defaultAttr) {
        Color[] cl = encoder.colorArray;
        if (this.groupLinesPerCategory == null) {
            return Color.PINK;
        }
        Integer gCat = (Integer)this.groupLineValue2Category.get(value);
        Color c = null;
        if (gCat != null) {
            int gcat = gCat;
            int obs = this.groupLineVar instanceof StringVariable ? ((StringVariable)this.groupLineVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupLineVar).getFirstOccurringValueIndex(gcat);
            try {
                int idx = (int)((NumericVariable)this.groupLineIndexVar).value.getValue(obs) - 1;
                c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency((Color)cl[idx % cl.length], (double)defaultAttr.getTransparency());
            }
            catch (MissingValueException e) {
                c = this.applyDataTransparency(defaultAttr);
            }
        }
        return c;
    }

    private Color getIndexSpokeColor(ColorEncoder encoder, int obs, ColorAttr defaultAttr) {
        Color c = null;
        if (encoder == null) {
            c = this.applyDataTransparency(defaultAttr);
        } else {
            Color[] cl = encoder.colorArray;
            try {
                int idx = (int)((NumericVariable)this.spokeColorIndexVar).value.getValue(obs) - 1;
                c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency((Color)cl[idx % cl.length], (double)defaultAttr.getTransparency());
            }
            catch (MissingValueException e) {
                c = this.applyDataTransparency(defaultAttr);
            }
        }
        return c;
    }

    private LineAttrs getIndexSpokeLineAttrs(LineEncoder encoder, int obs, LineAttrs defaultAttr) {
        LineAttrs ls = null;
        if (encoder == null) {
            ls = defaultAttr;
        } else {
            LineAttrs[] ll = encoder.styleArray;
            try {
                int idx = (int)((NumericVariable)this.spokeLineIndexVar).value.getValue(obs) - 1;
                ls = ll[idx % ll.length];
            }
            catch (MissingValueException e) {
                ls = defaultAttr;
            }
        }
        return ls;
    }

    private Color getIndexFillColor(ColorEncoder encoder, String value, ColorAttr defaultAttr) {
        Color[] cl = encoder.colorArray;
        if (this.groupFillsPerCategory == null) {
            return Color.PINK;
        }
        Integer gCat = (Integer)this.groupFillValue2Category.get(value);
        Color c = null;
        if (gCat != null) {
            int gcat = gCat;
            int obs = this.groupFillVar instanceof StringVariable ? ((StringVariable)this.groupFillVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupFillVar).getFirstOccurringValueIndex(gcat);
            try {
                int idx = (int)((NumericVariable)this.groupFillIndexVar).value.getValue(obs) - 1;
                c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency((Color)cl[idx % cl.length], (double)defaultAttr.getTransparency());
            }
            catch (MissingValueException e) {
                c = this.applyDataTransparency(defaultAttr);
            }
        }
        return c;
    }

    private LineAttrs getIndexLineAttrs(LineEncoder encoder, String groupValue, LineAttrs defaultAttr) {
        LineAttrs[] ll = encoder.styleArray;
        int gcat = (Integer)this.groupLineValue2Category.get(groupValue);
        int obs = this.groupLineVar instanceof StringVariable ? ((StringVariable)this.groupLineVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupLineVar).getFirstOccurringValueIndex(gcat);
        LineAttrs ls = null;
        try {
            int idx = (int)((NumericVariable)this.groupLineIndexVar).value.getValue(obs) - 1;
            ls = ll[idx % ll.length];
        }
        catch (MissingValueException e) {
            ls = defaultAttr;
        }
        return ls;
    }

    public void setUseFillColor(boolean b) {
        this.useFillColor = b;
    }

    public void setUseOutlineColor(boolean b) {
        this.useOutlineColor = b;
    }

    public LineAttrs getOOCSpokeStyle() {
        return this.oocSpokeAttrs;
    }

    public void setOOCSpokeStyle(LineAttrs aStyle) {
        this.oocSpokeAttrs = aStyle;
    }

    @Override
    public FillAttrs getOOCFillAttrs() {
        return this.oocFillStyle;
    }

    public static class Vertex {
        public String var;
        public String varID;
        public String entryLabel;
        public String entryValue;
        public String varName;
        public String varLabel;
    }
}

