/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.QCShewhartChart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.Format;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QCOverlay
extends Overlay {
    protected CRD model2 = null;
    protected boolean hasOutFill = true;
    protected boolean hasOutline = true;
    protected boolean hasRunsTestHighlight = true;
    protected QCShewhartChart chart = null;
    protected boolean needSubgrpConnect;
    public Rectangle innerAxisBounds = null;
    public Rectangle innerAxisBounds2 = null;
    public Rectangle outerAxisBounds = null;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    protected boolean maximizeInnerMargin = false;
    protected boolean numericX = true;
    protected boolean numericY = true;
    public Variable xvalueVar = null;
    protected NumericVariable phaseVar = null;
    public float infillOpacity = -1.0f;
    public float outfillOpacity = -1.0f;
    public float overlapOpacity = -1.0f;
    protected boolean phaseBreak = false;
    private boolean phaseIndexOn = false;
    protected QCOutlineType oocLineType = QCOutlineType.FALSE;
    protected QCOutfillType oocFillType = QCOutfillType.FALSE;
    protected MarkerAttrs oocMarkerStyle = new MarkerAttrs();
    protected FillAttrs oocFillStyle = new FillAttrs();
    protected LineAttrs oocLineStyle = new LineAttrs();
    protected LineAttrs runsTestStyle = new LineAttrs();
    protected ColorProperty oocMarkerColor = new ColorProperty();
    protected ColorProperty oocFillColor = new ColorProperty();
    protected ColorProperty oocLineColor = new ColorProperty();
    protected FillAttrs backgroundStyle = new FillAttrs();
    protected QCResponseContext context = QCResponseContext.DEADBEEF;
    protected double userInterval = -1.0;
    protected double dataLabelThreshold = Double.NaN;
    protected boolean hideLegendItems = false;
    protected double glyphWidth = 0.0;
    protected double glyphInnerMargin = 0.0;
    protected boolean phaseBoxResponse = false;
    protected boolean qcScaling = true;
    protected boolean subpixelOff = false;
    protected NetworkRoot networkRoot;
    protected Channel channel;
    protected NumericMapper xvalueMapper;
    protected NumericMapper yvalueMapper;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;

    public void setContext(QCResponseContext type) {
        this.context = type;
    }

    public QCResponseContext getContext() {
        return this.context;
    }

    public void draw(Graphics g, boolean highlightDraw) {
        this.draw(g);
    }

    public void draw(Graphics g) {
    }

    public void setChannel(Channel ch) {
        this.channel = ch;
        this.networkRoot = new NetworkRoot(ch);
    }

    public void setEncoder(byte dimension, Encoder encoder) {
    }

    public void setChart(QCShewhartChart o) {
        this.chart = o;
    }

    public QCShewhartChart getChart() {
        return this.chart;
    }

    public DataRange getDataRange(byte dimension) {
        return null;
    }

    public void setPhaseBreak(boolean b) {
        this.phaseBreak = b;
    }

    public boolean getPhaseBreak() {
        return this.phaseBreak;
    }

    public void setOOCLineType(QCOutlineType i) {
        this.oocLineType = i;
    }

    public QCOutlineType getOOCLineType() {
        return this.oocLineType;
    }

    public void setOOCFillType(QCOutfillType i) {
        this.oocFillType = i;
    }

    public QCOutfillType getOOCFillType() {
        return this.oocFillType;
    }

    public LineAttrs getOOCLineStyle() {
        return this.oocLineStyle;
    }

    public void setOOCLineStyle(LineAttrs aStyle) {
        this.oocLineStyle = aStyle;
    }

    public FillAttrs getOOCFillAttrs() {
        return this.oocFillStyle;
    }

    public void setOOCFillAttrs(FillAttrs style) {
        this.oocFillStyle = style;
    }

    public MarkerAttrs getOOCMarkerAttrs() {
        return this.oocMarkerStyle;
    }

    public void setOOCMarkerAttrs(MarkerAttrs style) {
        this.oocMarkerStyle = style;
    }

    public FillAttrs getBackgroundAttrs() {
        return this.backgroundStyle;
    }

    public void setBackgroundAttrs(FillAttrs style) {
        this.backgroundStyle = style;
    }

    public void setInnerRegion(Rectangle inner) {
        this.innerAxisBounds = inner;
    }

    public void setInnerRegion2(Rectangle inner2) {
        this.innerAxisBounds2 = inner2;
    }

    public void setOuterRegion(Rectangle outer) {
        this.outerAxisBounds = outer;
    }

    public void setDrawingArea(Rectangle inner, Rectangle inner2, Rectangle outer) {
        this.innerAxisBounds = inner;
        this.innerAxisBounds2 = inner2;
        this.outerAxisBounds = outer;
    }

    public void setSelect(String varName) {
        if (this.model == null || varName == null || varName.trim().length() == 0) {
            return;
        }
        DataModel m = this.model.getSrcModel();
        RoleColumnMap map = this.model.getSrcMap();
        String varID = StatGraph.getVarID((String)varName);
        if (m.hasColumn(varID)) {
            int col = m.getColumn(varID);
            map.map(787, col);
            this.addRole(this.name, m.getColumnLabel(col));
        }
    }

    protected Variable connectRaw(CRD aModel2, short role) {
        CRD save = this.model;
        this.model = aModel2;
        Variable var = this.model.isAvailable((int)role) ? this.connectRaw(role) : null;
        this.model = save;
        return var;
    }

    protected Variable connectRaw(short role, boolean applyFormat) {
        NumericVectorVariable outVar;
        boolean numeric;
        if (!this.model.isAvailable((int)role)) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel((int)role);
        boolean bl = numeric = this.model.getColumnClass((int)role) == Double.class;
        if (numeric) {
            double[] d = this.model.getDoubleColumn((int)role);
            outVar = new NumericVectorVariable();
            outVar.connectFrom(d);
        } else {
            String[] s = this.model.getStringColumn((int)role);
            outVar = new StringVectorVariable();
            ((StringVectorVariable)outVar).connectFrom(s);
        }
        SASFormat fmt = cmd.getFormat();
        if (applyFormat) {
            if (fmt != null) {
                outVar.setFormat(new GTKFormat((Format)fmt));
            } else if (outVar instanceof NumericVariable) {
                outVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
        } else {
            outVar.setFormat(null);
        }
        outVar.setLabel(this.getLabel(role));
        return outVar;
    }

    ContinuousRange makeContinuousRange(NumericVariable numVar) {
        double min = numVar.getMin();
        double max = numVar.getMax();
        return new ContinuousRange(min, max);
    }

    ContinuousRange makeContinuousRange(NumericVariable numVar, short role, boolean subset) {
        double max;
        double min;
        if (subset && this.model.whereExpression != null) {
            min = numVar.getMin();
            max = numVar.getMax();
        } else {
            min = this.model.getColumnMin(role);
            max = this.model.getColumnMax(role);
        }
        return new ContinuousRange(min, max);
    }

    static DiscreteRange makeDiscreteRange(StringVariable strVar, int num) {
        Object[] vals = new Object[num];
        for (int i = 0; i < num; ++i) {
            try {
                vals[i] = strVar.uniqueValue.getValue(i);
                continue;
            }
            catch (Exception mve) {
                vals[i] = null;
            }
        }
        return new DiscreteRange(vals);
    }

    DiscreteRange makeDiscreteRange(StringVariable strVar, int num, short role, boolean subset) {
        if (subset) {
            return QCOverlay.makeDiscreteRange(strVar, num);
        }
        Object[] vals = this.getUniqueCategoryValues(role, this.missingCategoryOn);
        return new DiscreteRange(vals);
    }

    OrdinalRange makeOrdinalRange(StringVariable strVar, int num, NumericVariable rawVar) {
        String miss;
        rawVar.getUniqueValueCount();
        Object[] vals = new Object[num];
        Object[] dvals = new Double[num];
        String fmtMissing = null;
        for (int i = 0; i < num; ++i) {
            try {
                vals[i] = strVar.uniqueValue.getValue(i);
            }
            catch (Exception mve) {
                vals[i] = null;
            }
            try {
                dvals[i] = new Double(rawVar.uniqueValue.getValue(i));
                continue;
            }
            catch (Exception mve) {
                dvals[i] = null;
                fmtMissing = (String)vals[i];
            }
        }
        String string = miss = StatGraph.includeMissingDiscrete ? StatGraph.missingOption : null;
        if (fmtMissing != null && !fmtMissing.equals(".")) {
            miss = fmtMissing;
        }
        return new OrdinalRange(vals, dvals, miss);
    }

    OrdinalRange makeOrdinalRange(StringVariable strVar, int num, NumericVariable rawVar, short role, boolean subset) {
        String miss;
        if (subset) {
            return this.makeOrdinalRange(strVar, num, rawVar);
        }
        NumericVectorVariable numVar = (NumericVectorVariable)this.connectRaw(role);
        this.applyWhereClause(new Variable[]{numVar});
        num = numVar.getUniqueValueCount();
        Object[] vals = this.getUniqueCategoryValues(role);
        Object[] dvals = new Double[num];
        String fmtMissing = null;
        for (int i = 0; i < num; ++i) {
            try {
                dvals[i] = new Double(numVar.uniqueValue.getValue(i));
                continue;
            }
            catch (Exception mve) {
                dvals[i] = null;
                fmtMissing = vals[i];
            }
        }
        String string = miss = StatGraph.includeMissingDiscrete ? StatGraph.missingOption : null;
        if (fmtMissing != null && !fmtMissing.equals(".")) {
            miss = fmtMissing;
        }
        return new OrdinalRange(vals, dvals, miss);
    }

    public int getSubsettedValueCount(Variable variable, short role, boolean numeric) {
        if (this.model.whereExpression != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            return var.getValueCount();
        }
        return variable.getValueCount();
    }

    public int getSubsettedUniqueValueCount(Variable variable, short role, boolean numeric) {
        if (this.model.whereExpression != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            return var.getUniqueValueCount();
        }
        GTKFormat fmt = variable.getFormat();
        variable.setFormat(null);
        int n = variable.getUniqueValueCount();
        variable.setFormat(fmt);
        return n;
    }

    public double[] getSubsettedDoubleColumn(short role) {
        double[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            NumericVectorVariable var = (NumericVectorVariable)this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)var);
            this.addCRDWhereClause(vp);
            colData = new double[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = var.value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = Double.NaN;
                }
            }
        } else {
            colData = this.model.getDoubleColumn((int)role);
        }
        return colData;
    }

    public String[] getSubsettedStringColumn(short role) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            StringVectorVariable var = (StringVectorVariable)this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = var.value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = null;
                }
            }
        } else {
            colData = this.model.getStringColumn((int)role);
        }
        return colData;
    }

    public String[] getSubsettedDoubleAsClassColumn(short role) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            StringVectorVariable var = (StringVectorVariable)this.connectCategory(role, true);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = var.value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = null;
                }
            }
        } else {
            colData = this.model.getDoubleAsClassColumn((int)role, true);
        }
        return colData;
    }

    public String[] getSubsettedStringAsClassColumn(short role) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            Variable var = this.connectCategory(role, true);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = ((StringVariable)var).value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = StatGraph.missingCharacter;
                }
            }
        } else {
            colData = this.model.getStringAsClassColumn((int)role, true);
        }
        return colData;
    }

    public String[] getSubsettedColumnAsClassColumn(short role, boolean numeric) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    if (numeric) {
                        colData[i] = DataModel.formatNumber((double)((NumericVariable)var).value.getValue(i));
                        continue;
                    }
                    colData[i] = ((StringVariable)var).value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = null;
                }
            }
        } else {
            colData = numeric ? this.model.getDoubleAsClassColumn((int)role) : this.model.getStringAsClassColumn((int)role);
        }
        return colData;
    }

    public QCClipType getClipType() {
        return QCClipType.INNER;
    }

    public boolean overrideGTLRenderingOrder(boolean highlight) {
        return false;
    }

    public boolean isGlyph() {
        return false;
    }

    public boolean isTransparent() {
        return false;
    }

    public void drawInFill(Graphics g, boolean callHighlightDraw) {
    }

    public void drawOutFill(Graphics p, QCLimitsOverlay limits, boolean callHighlightDraw) {
    }

    public void drawOutLine(Graphics p, QCLimitsOverlay limits, boolean callHighlightDraw) {
    }

    public void drawOutline(Graphics p, boolean callHighlightDraw) {
    }

    public void drawRunsTestHighlight(Graphics g) {
    }

    private static String parseInternalRole(Element e, String _internalRole) {
        String elemTag = "";
        for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Role")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String name = child.getNodeValue();
            if (!role.contains(_internalRole)) continue;
            return name;
        }
        return null;
    }

    public boolean hasPhaseIndexVar() {
        return this.phaseIndexOn;
    }

    public boolean createPhaseIndexVar(QCBlockOverlay phase) {
        if (phase == null) {
            this.phaseIndexOn = false;
            return this.phaseIndexOn;
        }
        if (this.xvalueVar == null) {
            this.phaseIndexOn = false;
            return this.phaseIndexOn;
        }
        if (this.model.isAvailable(44)) {
            this.phaseIndexOn = true;
            return this.phaseIndexOn;
        }
        if (this.model.isAvailable(793)) {
            this.phaseVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.phaseVar).connectFrom(this.model.getDoubleColumn(793));
            this.phaseIndexOn = true;
            return this.phaseIndexOn;
        }
        CRD phaseModel = phase.getModel();
        int nPhaseObs = phaseModel.getRowCount();
        NumericVectorVariable startVar = null;
        NumericVectorVariable endVar = null;
        NumericVectorVariable fillVar = null;
        if (!phaseModel.isAvailable(754)) {
            this.phaseIndexOn = false;
            return this.phaseIndexOn;
        }
        ColumnMetadata cmd = (ColumnMetadata)phaseModel.getColumnLabel(754);
        startVar = new NumericVectorVariable();
        startVar.connectFrom(phaseModel.getDoubleColumn(754));
        if (!phaseModel.isAvailable(755)) {
            this.phaseIndexOn = false;
            return this.phaseIndexOn;
        }
        cmd = (ColumnMetadata)phaseModel.getColumnLabel(755);
        endVar = new NumericVectorVariable();
        endVar.connectFrom(phaseModel.getDoubleColumn(755));
        if (phaseModel.isAvailable(770)) {
            cmd = (ColumnMetadata)phaseModel.getColumnLabel(770);
            fillVar = new NumericVectorVariable();
            fillVar.connectFrom(phaseModel.getDoubleColumn(770));
        } else {
            fillVar = null;
        }
        int nObs = this.model.getRowCount();
        double[] index = new double[nObs];
        int fill = -1;
        double[] fillIndex = fillVar == null ? null : new double[nObs];
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex();
        if (igrpLower == -1) {
            igrpLower = 0;
        }
        if (igrpUpper == -1) {
            igrpUpper = nObs - 1;
        }
        if (igrpUpper > nObs) {
            this.phaseIndexOn = false;
            return this.phaseIndexOn;
        }
        Object value = Variable.getValue((Variable)this.xvalueVar, (int)igrpLower, (boolean)false);
        int xmin = ((Double)value).intValue();
        value = Variable.getValue((Variable)this.xvalueVar, (int)igrpUpper, (boolean)false);
        int xmax = ((Double)value).intValue();
        boolean subset = false;
        for (int i = 0; i < nPhaseObs; ++i) {
            int j;
            int b;
            int a;
            value = Variable.getValue((Variable)startVar, (int)i, (boolean)false);
            int start = ((Double)value).intValue();
            value = Variable.getValue((Variable)endVar, (int)i, (boolean)false);
            int end = ((Double)value).intValue();
            if (fillVar != null) {
                value = Variable.getValue((Variable)fillVar, (int)i, (boolean)false);
                fill = ((Double)value).intValue();
            }
            if (subset) {
                if (start > xmax) break;
                if (end < xmin) continue;
                a = start - xmin;
                a = Math.max(a, 0);
                b = end - xmin;
                b = Math.min(b, nObs);
            } else {
                a = start - 1;
                b = end;
            }
            if (a >= nObs - 1) break;
            if (b > nObs - 1) {
                for (j = a; j < nObs; ++j) {
                    index[j] = i + 1;
                    if (fillVar == null) continue;
                    fillIndex[j] = fill;
                }
                break;
            }
            for (j = a; j < b; ++j) {
                index[j] = i + 1;
                if (fillVar == null) continue;
                fillIndex[j] = fill;
            }
        }
        DataModel m = this.model.getSrcModel();
        RoleColumnMap map = this.model.getSrcMap();
        String varID = "PHASEINDEX";
        m.addDoubleColumn(varID, "PhaseIndex", null, 0.0, (double)(nObs - 1), 0, index);
        int col = m.getColumn(varID);
        cmd = (ColumnMetadata)m.getColumnLabel(col);
        String roleName = "GROUPINDEX";
        int role = 44;
        map.map(role, col);
        this.addRole(roleName, cmd);
        this.phaseVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.phaseVar).connectFrom(this.model.getDoubleColumn(role));
        this.phaseIndexOn = true;
        return this.phaseIndexOn;
    }

    public boolean getScaleMarkers() {
        return this.scaleMarkers;
    }

    public void setInterval(double d) {
        this.userInterval = d;
    }

    public double getIntervalWidth(PositionEncoder encoder, boolean estimate) {
        double intvl;
        double d = intvl = this.userInterval != -1.0 ? this.userInterval : this.getMinimumInterval((short)10);
        if (intvl == 0.0) {
            return 0.25 * (encoder.getUpperLimit() - encoder.getLowerLimit());
        }
        double intervalWidth = this.getMaximumIntervalSize(intvl, encoder, estimate);
        QCShewhart.setIntervalWidth(intervalWidth);
        return intervalWidth;
    }

    protected double getMaxOffset(double width) {
        return this.getMaxOffset(width, -1.0, 0.0);
    }

    protected double getMaxOffset(double width, double between) {
        return this.getMaxOffset(width, -1.0, QCMargins.getBlockX());
    }

    protected double getMaxOffset(double interval, double min, double gap) {
        boolean blocks = this.chart.hasBlockOverlay();
        boolean phase = this.chart.hasPhaseOverlay();
        boolean refs = this.chart.hasReferenceOverlay();
        interval -= gap;
        if (blocks || phase || refs) {
            // empty if block
        }
        double phaseBoxOffset = this.chart.getPhaseBoxInnerXOffset();
        double offset = (interval -= phaseBoxOffset) / 2.0;
        offset = Math.max(offset, 0.0);
        double userSize = -1.0;
        offset = userSize > 0.0 ? (userSize > offset ? Math.max(offset, min) : userSize) : Math.max(offset, min);
        offset = Math.floor(offset);
        return offset;
    }

    protected double getGlyphWidth(double glyphOffset) {
        return this.getGlyphWidth(glyphOffset, -1.0);
    }

    protected double getGlyphWidth(double maxOffset, double maxGlyphWidth) {
        double width = 2.0 * maxOffset;
        if (maxGlyphWidth > -1.0) {
            width = Math.min(width, maxGlyphWidth);
        }
        return width;
    }

    public boolean project(double x, double y, double z, double[] r) {
        ContinuousRangeToNumericMapper xMap;
        r[0] = Double.NaN;
        r[1] = Double.NaN;
        r[2] = Double.NaN;
        if (this.xvalueMapper == null || this.yvalueMapper == null || this.yEncoder == null) {
            return false;
        }
        double xValue = Double.NaN;
        double yValue = Double.NaN;
        if (this.xvalueMapper instanceof ContinuousRangeToNumericMapper) {
            xMap = (ContinuousRangeToNumericMapper)this.xvalueMapper;
            xValue = xMap.getValue(x);
        } else if (this.xvalueMapper instanceof StringToNumericMapper) {
            xMap = (StringToNumericMapper)this.xvalueMapper;
            try {
                int i = (int)x;
                if (x == (double)i) {
                    xValue = xMap.getValue(i);
                }
                double dataMin = QCShewhart.getLowerSubgrpIndex(this.model);
                double dataMax = QCShewhart.getUpperSubgrpIndex(this.model);
                double dataRange = dataMax - dataMin;
                double xMin = this.innerAxisBounds.getX();
                double axisWidth = this.innerAxisBounds.getWidth();
                xValue = dataRange == 0.0 ? xMin : (x - dataMin) / dataRange * axisWidth;
            }
            catch (MissingValueException mve) {
                return false;
            }
        } else {
            r[0] = Double.NaN;
            r[1] = Double.NaN;
            r[2] = Double.NaN;
            return false;
        }
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        yValue = yMap.getValue(y);
        double xorigin = this.innerAxisBounds.getX();
        double yorigin = this.outerAxisBounds.getY();
        double yAxisUpper = this.yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yValue;
        r[2] = 0.0;
        return true;
    }

    public boolean uproject(double x, double y, double z, double[] r) {
        ContinuousRangeToNumericMapper xMap;
        r[0] = Double.NaN;
        r[1] = Double.NaN;
        r[2] = Double.NaN;
        if (this.xvalueMapper == null || this.yvalueMapper == null || this.yEncoder == null) {
            return false;
        }
        double xValue = Double.NaN;
        double yValue = Double.NaN;
        if (this.xvalueMapper instanceof ContinuousRangeToNumericMapper) {
            xMap = (ContinuousRangeToNumericMapper)this.xvalueMapper;
            xValue = xMap.getValue(x);
        } else if (this.xvalueMapper instanceof StringToNumericMapper) {
            xMap = (StringToNumericMapper)this.xvalueMapper;
            try {
                int i = (int)x;
                if (x != (double)i) {
                    System.out.println("QCLimitsOverlay/uproject():  int to double error.");
                }
                xValue = xMap.getValue(i);
            }
            catch (MissingValueException mve) {
                return false;
            }
        } else {
            return false;
        }
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        yValue = yMap.getValue(y);
        double xorigin = 0.0;
        double yorigin = 0.0;
        double yAxisUpper = this.yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yValue;
        r[2] = 0.0;
        return true;
    }

    public void setMaximizeInnerMargin(boolean b) {
        this.maximizeInnerMargin = b;
    }

    public boolean getMaximizeInnerMargin() {
        return this.maximizeInnerMargin;
    }

    public void setPhaseBoxResponse(boolean b) {
        this.phaseBoxResponse = b;
    }

    public boolean isaPhaseBoxResponse() {
        return this.phaseBoxResponse;
    }

    public double getPhaseBoxMargin(byte dim) {
        double margin = 0.0;
        if (this.isaPhaseBoxResponse()) {
            switch (dim) {
                case 1: {
                    margin = 0.0;
                    break;
                }
                case 2: {
                    margin = 0.0;
                    break;
                }
                default: {
                    margin = 0.0;
                }
            }
        }
        return margin;
    }

    public void setQCScaling(boolean b) {
        this.qcScaling = b;
    }

    public Color applyInfillTransparency(ColorAttr colorAttr) {
        Color color = colorAttr.getColor();
        double tr = this.infillOpacity == -1.0f ? this.getAttrTransparency(colorAttr) : 1.0 - (double)this.infillOpacity;
        return QCOverlay.applyTransparency((Color)color, (double)tr);
    }

    public Color applyInfillTransparency(Color color, double attrTransparency) {
        double tr = this.infillOpacity == -1.0f ? (attrTransparency < 0.0 ? this.dataTransparency : attrTransparency) : 1.0 - (double)this.infillOpacity;
        return QCOverlay.applyTransparency((Color)color, (double)tr);
    }

    public boolean getProperty(QCDrawProperty property) {
        boolean rc = false;
        switch (property) {
            case OUTFILL: {
                rc = this.hasOutFill;
                break;
            }
            case OUTLINE: {
                rc = this.hasOutline;
                break;
            }
            case RUNSTESTHIGHLIGHT: {
                rc = this.hasRunsTestHighlight;
            }
        }
        return rc;
    }

    public String[] getUniqueGroups(short role) {
        return this.getUniqueGroups(role, 0);
    }

    public String[] getUniqueGroups(short role, int sort) {
        return this.getUniqueGroupValues(role, sort);
    }

    private boolean isColumnAdded(String name, Probe p) {
        Probe.ProbeEntryEnumerator existed = p.enumerate();
        if (existed == null) {
            return false;
        }
        while (existed.hasMoreElements()) {
            Probe.ProbeEntry pe = (Probe.ProbeEntry)existed.nextElement();
            if (!pe.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public double[] getDoubleColumn(int role) {
        return this.model.isAvailable(role) ? this.model.getDoubleColumn(role) : null;
    }

    public String[] getStringColumn(int role) {
        return this.model.isAvailable(role) ? this.model.getStringColumn(role) : null;
    }

    public void setDataLabelThreshold(double d) {
        this.dataLabelThreshold = d;
    }

    public void setHideLegendItems(boolean b) {
        this.hideLegendItems = b;
    }

    public void drawDataLabels(Graphics g, Color wallColor, QCBlockOverlay blockRef) {
    }

    public void switchModels() {
        if (this.model2 != null) {
            CRD save = this.model;
            this.model = this.model2;
            this.model2 = save;
        }
    }

    public void setSubpixelOff(boolean b) {
        this.subpixelOff = b;
    }

    public boolean isSubpixelOff() {
        return this.subpixelOff;
    }

    public static enum QCDrawProperty {
        OUTFILL,
        OUTLINE,
        RUNSTESTHIGHLIGHT;

    }

    public static enum QCResponseContext {
        DEADBEEF,
        Y,
        NMARKERS,
        RUNSTEST,
        HIGHLIGHT,
        GROUP,
        OUTFILL,
        VARYREF,
        BOXMEANS,
        BOXMEANSID,
        BOXPOINTS,
        BOXPOINTSID,
        BOXPOINTSBOX,
        BOXPOINTSJOIN,
        BOXPOINTSJOINID,
        CONNECT,
        CLIP;


        public String toString() {
            return "CONTEXT_" + super.toString();
        }

        public static QCResponseContext fromInteger(int i) {
            return QCResponseContext.fromInteger(i, Y);
        }

        public static QCResponseContext fromInteger(int i, QCResponseContext dflt) {
            QCResponseContext rc;
            switch (i) {
                case 0: {
                    rc = Y;
                    break;
                }
                case 1: {
                    rc = NMARKERS;
                    break;
                }
                case 2: {
                    rc = RUNSTEST;
                    break;
                }
                case 3: {
                    rc = HIGHLIGHT;
                    break;
                }
                case 4: {
                    rc = GROUP;
                    break;
                }
                case 5: {
                    rc = OUTFILL;
                    break;
                }
                case 6: {
                    rc = VARYREF;
                    break;
                }
                case 7: {
                    rc = BOXMEANS;
                    break;
                }
                case 8: {
                    rc = BOXMEANSID;
                    break;
                }
                case 9: {
                    rc = BOXPOINTS;
                    break;
                }
                case 10: {
                    rc = BOXPOINTSID;
                    break;
                }
                case 11: {
                    rc = BOXPOINTSBOX;
                    break;
                }
                case 12: {
                    rc = BOXPOINTSJOIN;
                    break;
                }
                case 13: {
                    rc = BOXPOINTSJOINID;
                    break;
                }
                case 14: {
                    rc = CONNECT;
                    break;
                }
                case 15: {
                    rc = CLIP;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }
    }

    public static enum QCDrawMode {
        DEFAULT,
        OUTER,
        OUTFILL,
        INNER,
        HIGHLIGHT;

    }

    public static enum QCClipType {
        INNER,
        OUTER,
        OUTER_X,
        VMASK;

    }

    public static enum QCOutfillType {
        FALSE,
        TRUE,
        UPPER,
        LOWER;


        public static QCOutfillType fromInteger(int i) {
            return QCOutfillType.fromInteger(i, FALSE);
        }

        public static QCOutfillType fromInteger(int i, QCOutfillType dflt) {
            QCOutfillType rc;
            switch (i) {
                case 0: {
                    rc = FALSE;
                    break;
                }
                case 1: {
                    rc = TRUE;
                    break;
                }
                case 2: {
                    rc = UPPER;
                    break;
                }
                case 3: {
                    rc = LOWER;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }

        public static int toInteger(QCOutfillType type) {
            int rc;
            switch (type) {
                case FALSE: {
                    rc = 0;
                    break;
                }
                case TRUE: {
                    rc = 1;
                    break;
                }
                case UPPER: {
                    rc = 2;
                    break;
                }
                case LOWER: {
                    rc = 3;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            return rc;
        }
    }

    public static enum QCOutlineType {
        FALSE,
        TRUE,
        UPPER,
        LOWER;


        public static QCOutlineType fromInteger(int i) {
            return QCOutlineType.fromInteger(i, FALSE);
        }

        public static QCOutlineType fromInteger(int i, QCOutlineType dflt) {
            QCOutlineType rc;
            switch (i) {
                case 0: {
                    rc = FALSE;
                    break;
                }
                case 1: {
                    rc = TRUE;
                    break;
                }
                case 2: {
                    rc = UPPER;
                    break;
                }
                case 3: {
                    rc = LOWER;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }

        public static int toInteger(QCOutlineType type) {
            int rc;
            switch (type) {
                case FALSE: {
                    rc = 0;
                    break;
                }
                case TRUE: {
                    rc = 1;
                    break;
                }
                case UPPER: {
                    rc = 2;
                    break;
                }
                case LOWER: {
                    rc = 3;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            return rc;
        }
    }
}

