/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCLimitsConnector;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCVMaskConnector;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBoxParmOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimit;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCStylizedText;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVMask;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCZone;
import com.sas.analytics.qc.statgraph.sgchart.overlays.RB;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Vector;

public class QCLimitsOverlay
extends QCOverlay {
    public static final String RB_KEY = "QCLimitsOverlay.";
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private static final int LABELOFFSET = 6;
    public static final int NBANDS = 3;
    public static final int NZONES = 3;
    public static final int NSIGMA = 2;
    private boolean numericFillColor;
    private boolean numericLineColor;
    private boolean numericLine;
    ColorVector infillColorPipe = null;
    BooleanVector infillOnPipe = null;
    private ColorProperty lclLineColor = new ColorProperty();
    private ColorProperty ctlLineColor = new ColorProperty();
    protected ColorProperty uclLineColor = new ColorProperty();
    protected ColorProperty infillColor = new ColorProperty();
    private ColorProperty zoneAFillColor = new ColorProperty();
    private ColorProperty zoneBFillColor = new ColorProperty();
    private ColorProperty zoneCFillColor = new ColorProperty();
    private ColorProperty zoneALineColor = new ColorProperty();
    private ColorProperty zoneBLineColor = new ColorProperty();
    private ColorProperty zoneCLineColor = new ColorProperty();
    private NumericProperty pointX = new NumericProperty();
    private NumericProperty lclLineWidth = new NumericProperty();
    private IntegerProperty lclLinePattern = new IntegerProperty();
    private NumericProperty ctlLineWidth = new NumericProperty();
    private IntegerProperty ctlLinePattern = new IntegerProperty();
    protected NumericProperty uclLineWidth = new NumericProperty();
    protected IntegerProperty uclLinePattern = new IntegerProperty();
    private NumericProperty zoneALineWidth = new NumericProperty();
    private IntegerProperty zoneALinePattern = new IntegerProperty();
    private NumericProperty zoneBLineWidth = new NumericProperty();
    private IntegerProperty zoneBLinePattern = new IntegerProperty();
    private NumericProperty zoneCLineWidth = new NumericProperty();
    private IntegerProperty zoneCLinePattern = new IntegerProperty();
    private LineAttrs joinStyle = new LineAttrs();
    protected ColorEncoder colorEncoder;
    private NumericVectorVariable numericXVar;
    protected boolean fillOn = true;
    private boolean labelsOn = true;
    private boolean sigmaLegendOn = true;
    private double transparency;
    private boolean labelProtected = false;
    private QCLimit[] limits = new QCLimit[3];
    private QCZone[] zones = new QCZone[3];
    private QCVMask vmask = null;
    private boolean zonesOn = false;
    private boolean zoneFill = false;
    private boolean zoneLine = false;
    private boolean zoneLabels = false;
    private boolean zoneValues = false;
    private QCZone.ZoneLabelPos zoneLabelPosition = QCZone.ZoneLabelPos.INNER_LEFT;
    private QCZone.ZoneValuePos zoneValuePosition = QCZone.ZoneValuePos.INNER_LEFT;
    private boolean phaseLimitLabels = false;
    private QCStylizedText[] sigmaLegendText = new QCStylizedText[2];
    protected FillAttrs fillStyle = new FillAttrs();
    protected TextStyle phaseLimitStyle = new TextStyle();
    protected TextStyle zoneLabelStyle = new TextStyle();
    protected DataRange xRange = null;
    protected DataRange fillColorRange = null;
    protected DataRange lineColorRange = null;
    protected DataRange lineRange = null;
    protected DataRange phaseRange = null;
    private NetworkRoot networkOutfill;
    private NetworkRoot networkLimitLabels;
    protected QCLimitScheme schemeType;
    private Vector[] bandData = new Vector[3];
    private boolean debug = false;
    protected boolean debugFill = false;
    private boolean clipExtremes;
    private double clipFactor;
    protected int clipAreaX;
    protected int clipAreaY;
    protected int clipAreaWidth;
    protected int clipAreaHeight;
    private Area infillArea = null;
    protected Area outfillArea = null;
    private Variable fillColorVar = null;
    private Variable lineColorVar = null;
    private Variable lineVar = null;
    private NumericVector nv;
    private QCLimitsConnector limitsConnector;
    private QCVMaskConnector vmaskConnector;
    public boolean selectable = false;

    public QCLimitsOverlay() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.limits[i] = new QCLimit();
        }
        for (i = 0; i < 3; ++i) {
            this.zones[i] = new QCZone();
        }
        for (i = 0; i < 2; ++i) {
            this.sigmaLegendText[i] = new QCStylizedText();
        }
        this.transparency = 0.0;
        this.schemeType = QCLimitScheme.SCHEME_SHEWHART;
        this.infillOpacity = 0.0f;
        this.outfillOpacity = 0.0f;
        this.overlapOpacity = 0.25f;
        this.clipExtremes = false;
        this.clipFactor = 1.2;
    }

    @Override
    public boolean overrideGTLRenderingOrder(boolean highlight) {
        return true;
    }

    public boolean displayLimits() {
        boolean display = false;
        switch (this.schemeType) {
            case SCHEME_SHEWHART: {
                display = this.limits[1].display || this.limits[2].display || this.limits[0].display;
                break;
            }
            case SCHEME_ONESIDED: {
                display = this.limits[0].display;
                break;
            }
            case SCHEME_TWOSIDED: {
                display = this.vmask.display;
            }
        }
        return display;
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.drawInfill(g);
        this.drawLimits(g);
        if (this.labelsOn) {
            this.drawLabels(g);
        }
    }

    public void drawInfill(Object p) {
        this.drawInFill((Graphics)p, false);
    }

    @Override
    public void drawInFill(Graphics p, boolean highlightDraw) {
        if (!this.getInFill()) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                this.drawVMaskInFill(p, highlightDraw);
                break;
            }
            default: {
                this.drawShewhartInFill(p, highlightDraw);
            }
        }
    }

    private void drawVMaskInFill(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        Composite old = g.getComposite();
        float op = highlightDraw ? this.overlapOpacity : 1.0f;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        BooleanProperty fillOn = this.vmaskConnector.fillOn;
        BooleanProperty lineOn = this.vmaskConnector.lineOn;
        boolean limits = lineOn.getValue();
        boolean infill = fillOn.getValue();
        lineOn.setValue(false);
        fillOn.setValue(true);
        this.networkRoot.draw(this.channel, false);
        lineOn.setValue(limits);
        fillOn.setValue(infill);
        g.setComposite(old);
    }

    private void drawShewhartInFill(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        Composite old = g.getComposite();
        float op = highlightDraw ? this.overlapOpacity : this.infillOpacity;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        BooleanProperty fillOn = this.limitsConnector.fillOn;
        BooleanProperty lineOn = this.limitsConnector.lineOn;
        boolean limits = lineOn.getValue();
        boolean infill = fillOn.getValue();
        boolean labels = this.labelsOn;
        lineOn.setValue(false);
        fillOn.setValue(true);
        this.labelsOn = false;
        this.limitsConnector.setPhaseLimitLabels(false);
        this.limitsConnector.setZoneLabels(false);
        this.limitsConnector.setZoneValues(false);
        Area mask = this.getNonMissingAreas();
        if (mask != null) {
            g.setClip(mask);
        }
        if (this.zonesOn) {
            if (this.zoneFill) {
                this.limitsConnector.setPoints(QCLimitsConnector.ZoneFill.ZONE_A_UPPER);
                this.networkRoot.draw(this.channel, false);
                this.limitsConnector.setPoints(QCLimitsConnector.ZoneFill.ZONE_B_UPPER);
                this.networkRoot.draw(this.channel, false);
                this.limitsConnector.setPoints(QCLimitsConnector.ZoneFill.ZONE_C);
                this.networkRoot.draw(this.channel, false);
                this.limitsConnector.setPoints(QCLimitsConnector.ZoneFill.ZONE_B_LOWER);
                this.networkRoot.draw(this.channel, false);
                this.limitsConnector.setPoints(QCLimitsConnector.ZoneFill.ZONE_A_LOWER);
                this.networkRoot.draw(this.channel, false);
            }
        } else {
            this.limitsConnector.setPoints();
            this.networkRoot.draw(this.channel, false);
        }
        lineOn.setValue(limits);
        fillOn.setValue(infill);
        this.labelsOn = labels;
        g.setComposite(old);
        g.setClip(null);
    }

    public void drawPhaseLimits(Object p) {
        this.drawPhaseLimits((Graphics)p, false);
    }

    public void drawPhaseLimits(Graphics p, boolean highlightDraw) {
        if (this.networkRoot == null) {
            return;
        }
        if (!this.phaseLimitLabels) {
            return;
        }
        this.limitsConnector.setPhaseLimitLabels(true);
        if (this.getLimitLineOn(0)) {
            this.limitsConnector.set(QCLimitsConnector.LineType.PHASELIMITS_UCL);
            this.networkRoot.draw(this.channel, false);
        }
        if (this.getLimitLineOn(2)) {
            this.limitsConnector.set(QCLimitsConnector.LineType.PHASELIMITS_CTL);
            this.networkRoot.draw(this.channel, false);
        }
        if (this.getLimitLineOn(1)) {
            this.limitsConnector.set(QCLimitsConnector.LineType.PHASELIMITS_LCL);
            this.networkRoot.draw(this.channel, false);
        }
        this.limitsConnector.setPhaseLimitLabels(false);
    }

    public void drawZoneLabels(Object p) {
        this.drawZoneLabels((Graphics)p, false);
    }

    public void drawZoneLabels(Graphics p, boolean highlightDraw) {
        if (this.networkRoot == null) {
            return;
        }
        if (!this.zoneLabels && !this.zoneValues) {
            return;
        }
        this.limitsConnector.setZoneValuePosition(this.zoneValuePosition);
        this.limitsConnector.setZoneLabels(this.zoneLabels);
        this.limitsConnector.setZoneValues(this.zoneValues);
        Font font = this.zoneLabelStyle.getFont();
        this.channel.glSelect2DFont(font);
        this.networkRoot.draw(this.channel, false);
        this.limitsConnector.setZoneLabels(false);
        this.limitsConnector.setZoneValues(false);
    }

    public void drawLimits(Object p) {
        this.drawLimits((Graphics)p, false);
    }

    public void drawLimits(Graphics p, boolean highlightDraw) {
        if (this.networkRoot == null) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                this.drawVMask(p, highlightDraw);
                break;
            }
            default: {
                this.drawShewhartLimits(p, highlightDraw);
            }
        }
    }

    private void drawVMask(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        Composite old = g.getComposite();
        float op = highlightDraw ? this.overlapOpacity : 1.0f;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        BooleanProperty fo = this.vmaskConnector.fillOn;
        BooleanProperty lo = this.vmaskConnector.lineOn;
        boolean limits = lo.getValue();
        boolean infill = fo.getValue();
        lo.setValue(true);
        fo.setValue(false);
        this.networkRoot.draw(this.channel, false);
        lo.setValue(limits);
        fo.setValue(infill);
        g.setComposite(old);
    }

    private void drawShewhartLimits(Graphics p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        Composite old = g.getComposite();
        float op = highlightDraw ? this.overlapOpacity : 1.0f;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        BooleanProperty fo = this.limitsConnector.fillOn;
        BooleanProperty lo = this.limitsConnector.lineOn;
        boolean limits = lo.getValue();
        boolean infill = fo.getValue();
        boolean labels = this.labelsOn;
        lo.setValue(true);
        fo.setValue(false);
        this.labelsOn = false;
        this.limitsConnector.setPhaseLimitLabels(false);
        if (this.zoneLine) {
            this.limitsConnector.set(QCLimitsConnector.LineType.ZONE_B_UPPER);
            this.networkRoot.draw(this.channel, false);
            this.limitsConnector.set(QCLimitsConnector.LineType.ZONE_C_UPPER);
            this.networkRoot.draw(this.channel, false);
            this.limitsConnector.set(QCLimitsConnector.LineType.ZONE_C_LOWER);
            this.networkRoot.draw(this.channel, false);
            this.limitsConnector.set(QCLimitsConnector.LineType.ZONE_B_LOWER);
            this.networkRoot.draw(this.channel, false);
        }
        if (this.getLimitLineOn(0)) {
            this.limitsConnector.set(QCLimitsConnector.LineType.UCL);
            this.networkRoot.draw(this.channel, false);
        }
        if (this.getLimitLineOn(2)) {
            this.limitsConnector.set(QCLimitsConnector.LineType.CTL);
            this.networkRoot.draw(this.channel, false);
        }
        if (this.getLimitLineOn(1)) {
            this.limitsConnector.set(QCLimitsConnector.LineType.LCL);
            this.networkRoot.draw(this.channel, false);
        }
        lo.setValue(limits);
        fo.setValue(infill);
        this.labelsOn = labels;
        g.setComposite(old);
    }

    private Area getClippingAreas(Graphics p) {
        Area area = new Area();
        GeneralPath polygon = null;
        double originx = this.outerAxisBounds.getX();
        double originy = this.outerAxisBounds.getY();
        double uly = this.outerAxisBounds.y;
        double lry = uly + (double)this.outerAxisBounds.height;
        double ulx = this.outerAxisBounds.x;
        double width = this.outerAxisBounds.width;
        double center = ulx + width / 2.0;
        double dx = width / 8.0;
        ulx = center - dx;
        double lrx = center + dx;
        polygon = new GeneralPath(0, 4);
        polygon.moveTo((float)ulx, (float)uly);
        polygon.lineTo((float)lrx, (float)uly);
        polygon.lineTo((float)lrx, (float)lry);
        polygon.lineTo((float)ulx, (float)lry);
        polygon.closePath();
        Area poly = new Area(polygon);
        area.add(poly);
        if (!QCShewhart.isMultiVariatePlot()) {
            Graphics2D g = (Graphics2D)p;
            g.setClip(null);
            g.setColor(Color.ORANGE);
            g.fillRect(this.outerAxisBounds.x, this.outerAxisBounds.y, this.outerAxisBounds.width, this.outerAxisBounds.height);
            g.setColor(Color.PINK);
            g.fill(polygon);
        }
        return area;
    }

    public void drawNoneClipped(Graphics g) {
        if (this.networkLimitLabels == null) {
            return;
        }
        Channel channel = this.networkLimitLabels.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkLimitLabels.draw(channel, false);
    }

    public void drawLabels(Object p) {
        this.drawLabels(p, false);
    }

    public void drawLabels(Object p, boolean highlightDraw) {
        double d;
        QCStylizedText text;
        Graphics2D g = (Graphics2D)p;
        g.setClip(null);
        double xAxisUpper = this.xEncoder.getUpperLimit();
        double xAxisLower = this.xEncoder.getLowerLimit();
        double xAxisLength = xAxisUpper - xAxisLower;
        double xAxisMax = this.xEncoder.getOutputMax();
        double xAxisMin = this.xEncoder.getOutputMin();
        double xAxisWidth = xAxisMax - xAxisMin;
        double innerMarginLeft = xAxisMin - xAxisLower;
        double innerMarginRight = xAxisUpper - xAxisMax;
        double yAxisUpper = this.yEncoder.getUpperLimit();
        double yAxisLower = this.yEncoder.getLowerLimit();
        double yAxisLength = yAxisUpper - yAxisLower;
        double yAxisMax = this.yEncoder.getOutputMax();
        double yAxisMin = this.yEncoder.getOutputMin();
        double yAxisWidth = yAxisMax - yAxisMin;
        double innerMarginTop = yAxisMin - yAxisLower;
        double innerMarginBottom = yAxisUpper - yAxisMax;
        double offset = 6.0;
        offset = Math.floor(offset * StatGraph.gapScaleFactor + 0.5);
        double xorigin = this.outerAxisBounds.getX();
        double yorigin = this.outerAxisBounds.getY();
        int x = (int)(xorigin + xAxisLength + offset);
        int y = (int)yorigin;
        if (this.sigmaLegendText[0] != null) {
            text = this.sigmaLegendText[0];
            text.setOrigin(x, y);
            text.draw(g);
        }
        if (this.sigmaLegendText[1] != null) {
            text = this.sigmaLegendText[1];
            int height = this.sigmaLegendText[1].getHeight();
            text.setOrigin(x, y + height);
            text.draw(g);
        }
        ContinuousRangeToNumericMapper map = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        if (this.zoneValues && this.zoneValuePosition == QCZone.ZoneValuePos.OUTER_RIGHT) {
            Font font = this.zoneLabelStyle.getFont();
            double height = (double)font.getSize() / 2.0;
            Color color = this.zoneLabelStyle.getColor();
            g.setStroke(new BasicStroke(1.0f));
            g.setFont(font);
            g.setColor(color);
            QCZone zoneA = this.getZone(QCZone.Zone.A);
            QCZone zoneB = this.getZone(QCZone.Zone.B);
            QCZone zoneC = this.getZone(QCZone.Zone.C);
            String label = zoneA.upperLabel;
            if (label != null && label.length() > 0) {
                d = zoneB.upperLimit;
                y = (int)(yorigin + yAxisUpper - map.getValue(d));
                y = (int)((double)y + height);
                g.drawString(label, x, y);
            }
            if ((label = zoneB.upperLabel) != null && label.length() > 0) {
                d = zoneC.upperLimit;
                y = (int)(yorigin + yAxisUpper - map.getValue(d));
                y = (int)((double)y + height);
                g.drawString(label, x, y);
            }
            if ((label = zoneB.lowerLabel) != null && label.length() > 0) {
                d = zoneC.lowerLimit;
                y = (int)(yorigin + yAxisUpper - map.getValue(d));
                y = (int)((double)y + height);
                g.drawString(label, x, y);
            }
            if ((label = zoneA.lowerLabel) != null && label.length() > 0) {
                d = zoneB.lowerLimit;
                y = (int)(yorigin + yAxisUpper - map.getValue(d));
                y = (int)((double)y + height);
                g.drawString(label, x, y);
            }
        }
        if (this.isCurveLabeled()) {
            QCLimit lcl = this.getLimit(1);
            QCLimit ctl = this.getLimit(2);
            QCLimit ucl = this.getLimit(0);
            boolean uclLabelOn = false;
            boolean ctlLabelOn = false;
            boolean lclLabelOn = false;
            if (ucl != null) {
                uclLabelOn = ucl.getLabelOn();
                d = ucl.getLastNonMissingValue();
                if (Double.isNaN(d)) {
                    ucl.setLabel(false);
                } else {
                    text = ucl.text;
                    y = (int)(yorigin + yAxisUpper - map.getValue(d));
                    text.setOrigin(x, y += (int)((double)text.getFontAscent() / 3.0 + 0.5));
                }
            }
            if (ctl != null) {
                ctlLabelOn = ctl.getLabelOn();
                d = ctl.getLastNonMissingValue();
                if (Double.isNaN(d)) {
                    ctl.setLabel(false);
                } else {
                    text = ctl.text;
                    y = (int)(yorigin + yAxisUpper - map.getValue(d));
                    text.setOrigin(x, y += (int)((double)text.getFontAscent() / 3.0 + 0.5));
                }
            }
            if (lcl != null) {
                lclLabelOn = lcl.getLabelOn();
                d = lcl.getLastNonMissingValue();
                if (Double.isNaN(d)) {
                    lcl.setLabel(false);
                } else {
                    text = lcl.text;
                    y = (int)(yorigin + yAxisUpper - map.getValue(d));
                    text.setOrigin(x, y += (int)((double)text.getFontAscent() / 3.0 + 0.5));
                }
            }
            this.avoidCollisions();
            if (ucl != null && ucl.labelOn) {
                ucl.text.draw(g);
                ucl.setLabel(uclLabelOn);
            }
            if (ctl != null && ctl.labelOn) {
                ctl.text.draw(g);
                ctl.setLabel(ctlLabelOn);
            }
            if (lcl != null && lcl.labelOn) {
                lcl.text.draw(g);
                lcl.setLabel(lclLabelOn);
            }
        }
    }

    private void avoidCollisions() {
        double offset;
        double ascent;
        String msg2;
        double height;
        int y;
        QCStylizedText text;
        double yAxisMax;
        double yOrigin = this.outerAxisBounds.getY();
        double yAxisUpper = this.yEncoder.getUpperLimit();
        double yAxisMin = yOrigin + yAxisUpper;
        if (this.sigmaLegendText[1] == null) {
            yAxisMax = yOrigin;
        } else {
            double descent = this.sigmaLegendText[1].getFontDescent();
            yAxisMax = (double)this.sigmaLegendText[1].y + descent;
        }
        double yLabelUpper = yOrigin + yAxisUpper;
        double yLabelLower = yOrigin;
        QCLimit ucl = this.getLimit(0);
        QCLimit ctl = this.getLimit(2);
        QCLimit lcl = this.getLimit(1);
        if (ctl != null && ctl.labelOn) {
            text = ctl.text;
            y = text.y;
            if (y == -1) {
                ctl.labelOn = false;
            } else {
                yLabelLower = y;
                height = text.getHeight();
                yLabelUpper = (double)y - height;
                boolean bl = ctl.labelOn = yLabelUpper > yAxisMax;
            }
            if (!ctl.labelOn) {
                try {
                    msg2 = RB.getStringResource(RB_KEY, "ctlSuppressed.txt");
                    StatGraph.printNote((String)msg2, (boolean)false);
                }
                catch (MissingResourceException msg2) {
                    // empty catch block
                }
            }
        }
        if (ucl != null && ucl.labelOn) {
            text = ucl.text;
            y = text.y;
            if (y == -1) {
                ucl.labelOn = false;
            } else {
                ascent = text.getFontAscent();
                height = text.getHeight();
                offset = ascent / 4.0;
                if (yLabelUpper - yAxisMax >= ascent + offset) {
                    if ((double)y - ascent < yAxisMax) {
                        y = (int)(yAxisMax + offset + ascent);
                    }
                    if ((double)y + offset > yLabelUpper) {
                        y = (int)(yLabelUpper - offset);
                    }
                }
                text.y = y;
                boolean bl = ucl.labelOn = (double)y <= yLabelUpper && (double)y - ascent >= yAxisMax;
            }
            if (!ucl.labelOn) {
                try {
                    msg2 = RB.getStringResource(RB_KEY, "uclSuppressed.txt");
                    StatGraph.printNote((String)msg2, (boolean)false);
                }
                catch (MissingResourceException msg3) {
                    // empty catch block
                }
            }
        }
        if (lcl != null && lcl.labelOn) {
            text = lcl.text;
            y = text.y;
            if (y == -1) {
                lcl.labelOn = false;
            } else {
                ascent = text.getFontAscent();
                height = text.getHeight();
                offset = ascent / 4.0;
                if (yAxisMin - yLabelLower >= ascent + offset) {
                    if ((double)y > yAxisMin) {
                        y = (int)yAxisMin;
                    }
                    if ((double)y - (ascent + offset) < yLabelLower) {
                        y = (int)(yLabelLower + ascent + offset);
                    }
                }
                text.y = y;
                boolean bl = lcl.labelOn = !((double)lcl.text.y - ascent < (double)ctl.text.y);
            }
            if (!lcl.labelOn) {
                try {
                    msg2 = RB.getStringResource(RB_KEY, "lclSuppressed.txt");
                    StatGraph.printNote((String)msg2, (boolean)false);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
    }

    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        QCLimit lcl = this.getLimit(1);
        if (lcl != null) {
            lcl.setModel(aModel);
        }
        QCLimit ctl = this.getLimit(2);
        if (lcl != null) {
            ctl.setModel(aModel);
        }
        QCLimit ucl = this.getLimit(0);
        if (lcl != null) {
            ucl.setModel(aModel);
        }
        this.updateXRange();
        this.updateLimitRange(1);
        this.updateLimitRange(2);
        this.updateLimitRange(0);
        this.updateLineRange();
        this.updateLineColorRange();
        this.updateFillColorRange();
    }

    protected void connectVars() {
        QCLimit limit;
        NumericVariable var;
        int nx = this.model.getRowCount();
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex();
        if (this.model.isAvailable(10)) {
            this.numericX = this.model.getColumnClass(10) == Double.class;
            Variable variable = this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xvalueVar = null;
        }
        if (this.model.isAvailable(752)) {
            var = (NumericVariable)this.connectRaw((short)752);
            limit = this.getLimit(1);
            limit.setXVar(this.xvalueVar);
            limit.setVariable(var);
        }
        if (this.model.isAvailable(753)) {
            var = (NumericVariable)this.connectRaw((short)753);
            limit = this.getLimit(2);
            limit.setXVar(this.xvalueVar);
            limit.setVariable(var);
        }
        if (this.model.isAvailable(751)) {
            var = (NumericVariable)this.connectRaw((short)751);
            limit = this.getLimit(0);
            limit.setXVar(this.xvalueVar);
            limit.setVariable(var);
        }
        if (this.model.isAvailable(787)) {
            var = (NumericVariable)this.connectRaw((short)787);
            Object value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)var, (int)1, (boolean)false) : null;
        }
        this.numericFillColor = false;
        this.fillColorVar = null;
        this.numericLineColor = false;
        this.lineColorVar = null;
        this.numericLine = false;
        this.lineVar = null;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                if (newRange != null) {
                    newRange.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateLimitRange(int iLimit) {
        QCLimit limit = this.limits[iLimit];
        if (!limit.display) {
            return;
        }
        DataRange newRange = null;
        DataRange oldRange = this.getLimitRange(iLimit);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        NumericVariable var = this.getLimitVariable(iLimit);
        short role = this.getRole(iLimit);
        if (var != null) {
            int num = var.getValueCount();
            if (num > 0) {
                newRange = this.makeContinuousRange(var, role, !this.yUnionAllPages);
                newRange.setLabel(var.getLabel());
            }
        } else {
            double d = this.getLimitValue(iLimit);
            if (!Double.isNaN(d)) {
                newRange = new ContinuousRange(d, d);
            }
        }
        this.setFormat(newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.setRange(iLimit, newRange);
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    protected void updatePhaseRange(QCBlockOverlay phase) {
        DataRange newRange = null;
        DataRange oldRange = this.phaseRange;
        if (this.phaseVar == null || !phase.getLegend()) {
            return;
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        short role = this.hasPhaseIndexVar() ? (short)44 : 3;
        int num = this.phaseVar.getValueCount();
        if (num > 0) {
            newRange = this.makeContinuousRange(this.phaseVar, role, false);
            newRange.setLabel(this.phaseVar.getLabel());
        }
        this.setFormat(newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
    }

    protected void updateFillColorRange() {
    }

    protected void updateLineRange() {
    }

    protected void updateLineColorRange() {
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        ContinuousRange cr = null;
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                DataRange uclRange = this.getLimitRange(0);
                DataRange ctlRange = this.getLimitRange(2);
                DataRange lclRange = this.getLimitRange(1);
                if (uclRange == null || ctlRange == null || lclRange == null) {
                    return null;
                }
                double min = ((ContinuousRange)uclRange).getMin();
                double max = ((ContinuousRange)uclRange).getMax();
                cr = new ContinuousRange(min, max);
                cr.union(lclRange);
                cr.union(ctlRange);
                String label = uclRange.getLabel() != null ? uclRange.getLabel() : lclRange.getLabel();
                cr.setLabel(label);
                SASFormat format = uclRange.getFormat() != null ? uclRange.getFormat() : lclRange.getFormat();
                cr.setFormat(format);
                return cr;
            }
            case 4: {
                return this.fillColorRange;
            }
            case 17: {
                return this.lineColorRange;
            }
            case 15: {
                return this.lineRange;
            }
            case 53: {
                return this.getLimitRange(0);
            }
            case 52: {
                return this.getLimitRange(2);
            }
            case 51: {
                return this.getLimitRange(1);
            }
        }
        return null;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17 || dimension == 15) {
            // empty if block
        }
        this.needConnect = true;
    }

    public void addXBBoxes(ArrayList xb, ArrayList x2b) {
    }

    public void setRotateXCurveLabels(boolean overlapped) {
    }

    public void setRotateX2CurveLabels(boolean overlapped) {
    }

    public boolean connectNetwork() {
        if (!this.needConnect) {
            return true;
        }
        if (this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        this.networkRoot.removeAllElements();
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        ValueMap xMap = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(xMap instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (this.xvalueMapper == null || !(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)xMap);
        } else {
            if (!(xMap instanceof StringToNumericMap)) {
                return false;
            }
            if (this.xvalueMapper == null || !(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)xMap);
        }
        this.pointX.connectFrom((NumericPipe)this.xvalueMapper);
        ValueMap yMap = this.yEncoder.getValueMap();
        if (!(yMap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        if (this.yvalueMapper == null || !(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
            this.yvalueMapper = new ContinuousRangeToNumericMapper();
        }
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)yMap);
        Object linePatternMapper = null;
        Object fillColorMapper = null;
        Object lineColorMapper = null;
        Object lineWidthMapper = null;
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                this.buildVMaskConnector();
                break;
            }
            default: {
                this.buildLimitsConnector();
            }
        }
        this.initLimits();
        this.needConnect = false;
        return true;
    }

    private void buildLimitsConnector() {
        ContinuousRangeToNumericMapper yCMapper;
        LineAttrs la;
        ContinuousRangeToNumericMapper uclMapper = null;
        NumericVariable uclVar = this.getLimitVariable(0);
        if (uclVar != null) {
            uclMapper = new ContinuousRangeToNumericMapper();
            uclMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        }
        ContinuousRangeToNumericMapper lclMapper = null;
        NumericVariable lclVar = this.getLimitVariable(1);
        if (lclVar != null) {
            lclMapper = new ContinuousRangeToNumericMapper();
            lclMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        }
        ContinuousRangeToNumericMapper ctlMapper = null;
        NumericVariable ctlVar = this.getLimitVariable(2);
        if (ctlVar != null) {
            ctlMapper = new ContinuousRangeToNumericMapper();
            ctlMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        }
        Object zoneALowerMapper = null;
        Object zoneALowerVar = null;
        Object zoneAUpperMapper = null;
        Object zoneAUpperVar = null;
        Object zoneBLowerMapper = null;
        Object zoneBLowerVar = null;
        Object zoneBUpperMapper = null;
        Object zoneBUpperVar = null;
        Object zoneCLowerMapper = null;
        Object zoneCLowerVar = null;
        Object zoneCUpperMapper = null;
        Object zoneCUpperVar = null;
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        double uclValue = Double.NaN;
        if (uclMapper == null) {
            uclValue = this.getLimitValue(0);
        } else {
            uclMapper.input.connectFrom(uclVar.value);
        }
        double lclValue = Double.NaN;
        if (lclMapper == null) {
            lclValue = this.getLimitValue(1);
        } else {
            lclMapper.input.connectFrom(lclVar.value);
        }
        double ctlValue = Double.NaN;
        if (ctlMapper == null) {
            ctlValue = this.getLimitValue(2);
        } else {
            ctlMapper.input.connectFrom(ctlVar.value);
        }
        double zoneALowerValue = Double.NaN;
        double zoneAUpperValue = Double.NaN;
        double zoneBLowerValue = Double.NaN;
        double zoneBUpperValue = Double.NaN;
        double zoneCLowerValue = Double.NaN;
        double zoneCUpperValue = Double.NaN;
        if (this.zonesOn) {
            QCZone zone = this.getZone(0);
            zoneALowerValue = zone.getLower();
            zoneAUpperValue = zone.getUpper();
            FillAttrs fa = zone.fillStyle;
            la = zone.lineStyle;
            this.zoneAFillColor.setValue(this.applyDataTransparency((ColorAttr)fa));
            this.zoneALineColor.setValue(this.applyDataTransparency((ColorAttr)la));
            this.zoneALineWidth.setValue((double)la.getWidth());
            this.zoneALinePattern.setValue(la.getLinePattern());
            zone = this.getZone(1);
            zoneBLowerValue = zone.getLower();
            zoneBUpperValue = zone.getUpper();
            fa = zone.fillStyle;
            la = zone.lineStyle;
            this.zoneBFillColor.setValue(this.applyDataTransparency((ColorAttr)fa));
            this.zoneBLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
            this.zoneBLineWidth.setValue((double)la.getWidth());
            this.zoneBLinePattern.setValue(la.getLinePattern());
            zone = this.getZone(2);
            zoneCLowerValue = zone.getLower();
            zoneCUpperValue = zone.getUpper();
            fa = zone.fillStyle;
            la = zone.lineStyle;
            this.zoneCFillColor.setValue(this.applyDataTransparency((ColorAttr)fa));
            this.zoneCLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
            this.zoneCLineWidth.setValue((double)la.getWidth());
            this.zoneCLinePattern.setValue(la.getLinePattern());
        }
        la = this.getLimitLineAttrs(0);
        this.lclLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
        this.lclLineWidth.setValue((double)la.getWidth());
        this.lclLinePattern.setValue(la.getLinePattern());
        la = this.getLimitLineAttrs(2);
        this.ctlLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
        this.ctlLineWidth.setValue((double)la.getWidth());
        this.ctlLinePattern.setValue(la.getLinePattern());
        la = this.getLimitLineAttrs(1);
        this.uclLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
        this.uclLineWidth.setValue((double)la.getWidth());
        this.uclLinePattern.setValue(la.getLinePattern());
        this.infillColor.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        boolean skipMissing = true;
        this.limitsConnector = new QCLimitsConnector();
        this.limitsConnector.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        this.limitsConnector.setConnectionOrder(0);
        this.limitsConnector.setSkipMissingOn(skipMissing);
        if (this.xvalueMapper != null) {
            this.limitsConnector.pointX.connectFrom((NumericPipe)this.xvalueMapper);
        } else {
            ContinuousRangeToNumericMapper xCMapper = null;
            xCMapper = new ContinuousRangeToNumericMapper();
            this.nv = new NumericVector();
            double min = ((ContinuousRange)this.xRange).getMin();
            double max = ((ContinuousRange)this.xRange).getMax();
            if (this.numericX) {
                double xmin = this.xEncoder.getLowerLimit();
                double xmax = this.xEncoder.getUpperLimit();
                min = xCMapper.getInverseValue(xmin);
                max = xCMapper.getInverseValue(xmax);
            }
            this.nv.addValue(min);
            this.nv.addValue(max);
            xCMapper.input.connectFrom((NumericPipe)this.nv);
            xCMapper.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
            this.limitsConnector.pointX.connectFrom((NumericPipe)xCMapper);
        }
        if (uclMapper != null) {
            this.limitsConnector.pointUCL.connectFrom((NumericPipe)uclMapper);
        } else {
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(uclValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointUCL.connectFrom((NumericPipe)yCMapper);
        }
        if (lclMapper != null) {
            this.limitsConnector.pointLCL.connectFrom((NumericPipe)lclMapper);
        } else {
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(lclValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointLCL.connectFrom((NumericPipe)yCMapper);
        }
        if (ctlMapper != null) {
            this.limitsConnector.pointCTL.connectFrom((NumericPipe)ctlMapper);
        } else {
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(ctlValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointCTL.connectFrom((NumericPipe)yCMapper);
        }
        if (this.zonesOn) {
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(zoneALowerValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointZoneALower.connectFrom((NumericPipe)yCMapper);
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(zoneAUpperValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointZoneAUpper.connectFrom((NumericPipe)yCMapper);
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(zoneBLowerValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointZoneBLower.connectFrom((NumericPipe)yCMapper);
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(zoneBUpperValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointZoneBUpper.connectFrom((NumericPipe)yCMapper);
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(zoneCLowerValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointZoneCLower.connectFrom((NumericPipe)yCMapper);
            yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(zoneCUpperValue);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.limitsConnector.pointZoneCUpper.connectFrom((NumericPipe)yCMapper);
        }
        this.limitsConnector.zoneAFillColor.connectFrom((ColorPipe)this.zoneAFillColor);
        this.limitsConnector.zoneBFillColor.connectFrom((ColorPipe)this.zoneBFillColor);
        this.limitsConnector.zoneCFillColor.connectFrom((ColorPipe)this.zoneCFillColor);
        this.limitsConnector.zoneALineColor.connectFrom((ColorPipe)this.zoneALineColor);
        this.limitsConnector.zoneBLineColor.connectFrom((ColorPipe)this.zoneBLineColor);
        this.limitsConnector.zoneCLineColor.connectFrom((ColorPipe)this.zoneCLineColor);
        this.limitsConnector.zoneALineWidth.connectFrom((NumericPipe)this.zoneALineWidth);
        this.limitsConnector.zoneBLineWidth.connectFrom((NumericPipe)this.zoneBLineWidth);
        this.limitsConnector.zoneCLineWidth.connectFrom((NumericPipe)this.zoneCLineWidth);
        this.limitsConnector.zoneALinePattern.connectFrom((IntegerPipe)this.zoneALinePattern);
        this.limitsConnector.zoneBLinePattern.connectFrom((IntegerPipe)this.zoneBLinePattern);
        this.limitsConnector.zoneCLinePattern.connectFrom((IntegerPipe)this.zoneCLinePattern);
        this.limitsConnector.lclLineColor.connectFrom((ColorPipe)this.lclLineColor);
        this.limitsConnector.lclLinePattern.connectFrom((IntegerPipe)this.lclLinePattern);
        this.limitsConnector.lclLineWidth.connectFrom((NumericPipe)this.lclLineWidth);
        this.limitsConnector.lclLineOn.setValue(true);
        this.limitsConnector.ctlLineColor.connectFrom((ColorPipe)this.ctlLineColor);
        this.limitsConnector.ctlLinePattern.connectFrom((IntegerPipe)this.ctlLinePattern);
        this.limitsConnector.ctlLineWidth.connectFrom((NumericPipe)this.ctlLineWidth);
        this.limitsConnector.ctlLineOn.setValue(true);
        this.limitsConnector.uclLineColor.connectFrom((ColorPipe)this.uclLineColor);
        this.limitsConnector.uclLinePattern.connectFrom((IntegerPipe)this.uclLinePattern);
        this.limitsConnector.uclLineWidth.connectFrom((NumericPipe)this.uclLineWidth);
        this.limitsConnector.uclLineOn.setValue(true);
        this.limitsConnector.igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        this.limitsConnector.igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        boolean b = this.getLimitLineOn(0);
        this.limitsConnector.setLimitLineOn(0, b);
        b = this.getLimitLineOn(1);
        this.limitsConnector.setLimitLineOn(1, b);
        b = this.getLimitLineOn(2);
        this.limitsConnector.setLimitLineOn(2, b);
        this.limitsConnector.selectEnabled.setValue(this.selectable);
        this.limitsConnector.setUserData(this.probe);
        this.limitsConnector.setSVGRender(StatGraph.VGF);
        this.limitsConnector.setSVGRender(true);
        BBox frame = this.translateAxisBounds(true);
        this.limitsConnector.setFrame(frame);
        if (this.hasPhaseIndexVar()) {
            StringVariable phaseLCLVar;
            StringVariable phaseCTLVar;
            QCBlockOverlay o = this.chart.getRefOverlay();
            this.limitsConnector.numericGroup.connectFrom(this.phaseVar.value);
            this.limitsConnector.setPhaseFrames(o.getRefFillFrames(frame));
            this.limitsConnector.setPhaseRefList(o.getRefList());
            if (!o.blocks.isEmpty()) {
                QCBlockOverlay.Block block = o.blocks.get(0);
                this.limitsConnector.setPhaseEntries(block.entries);
            }
            int ichart = this.chart.getChartLevel();
            o = this.chart.getBlockOverlay(QCBlockOverlay.BlockType.PHASEREF);
            StringVariable phaseUCLVar = o.getPhaseUCLVar(ichart);
            if (phaseUCLVar != null) {
                QCStarLabel phaseUCL = new QCStarLabel();
                phaseUCL.labelsOn.setValue(true);
                phaseUCL.string.connectFrom(phaseUCLVar.value);
                phaseUCL.color.setValue(this.phaseLimitStyle.getColor());
                phaseUCL.setFont(this.phaseLimitStyle.getFont());
                this.limitsConnector.phaseUCL = phaseUCL;
            }
            if ((phaseCTLVar = o.getPhaseCTLVar(ichart)) != null) {
                QCStarLabel phaseCTL = new QCStarLabel();
                phaseCTL.labelsOn.setValue(true);
                phaseCTL.string.connectFrom(phaseCTLVar.value);
                phaseCTL.color.setValue(this.phaseLimitStyle.getColor());
                phaseCTL.setFont(this.phaseLimitStyle.getFont());
                this.limitsConnector.phaseCTL = phaseCTL;
            }
            if ((phaseLCLVar = o.getPhaseLCLVar(ichart)) != null) {
                QCStarLabel phaseLCL = new QCStarLabel();
                phaseLCL.labelsOn.setValue(true);
                phaseLCL.string.connectFrom(phaseLCLVar.value);
                phaseLCL.color.setValue(this.phaseLimitStyle.getColor());
                phaseLCL.setFont(this.phaseLimitStyle.getFont());
                this.limitsConnector.phaseLCL = phaseLCL;
            }
            if (this.infillColorPipe != null) {
                this.limitsConnector.limitFillColor.connectFrom((ColorPipe)this.infillColorPipe);
                this.limitsConnector.limitFillOn.connectFrom((BooleanPipe)this.infillOnPipe);
            } else {
                this.limitsConnector.limitFillColor.connectFrom((ColorPipe)this.infillColor);
                this.limitsConnector.limitFillOn.setValue(this.fillOn);
            }
        } else {
            this.limitsConnector.limitFillColor.connectFrom((ColorPipe)this.infillColor);
            this.limitsConnector.limitFillOn.setValue(this.fillOn);
        }
        QCZone zone = this.getZone(QCZone.Zone.A);
        if (zone != null) {
            if (this.zoneLabels) {
                QCStarLabel label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.label);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneALabel = label;
            }
            if (this.zoneValues) {
                QCStarLabel label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.upperLabel);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneAUpper = label;
                label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.lowerLabel);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneALower = label;
            }
        }
        if ((zone = this.getZone(QCZone.Zone.B)) != null) {
            if (this.zoneLabels) {
                QCStarLabel label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.label);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneBLabel = label;
            }
            if (this.zoneValues) {
                QCStarLabel label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.upperLabel);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneBUpper = label;
                label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.lowerLabel);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneBLower = label;
            }
        }
        if ((zone = this.getZone(QCZone.Zone.C)) != null) {
            if (this.zoneLabels) {
                QCStarLabel label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.label);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneCLabel = label;
            }
            if (this.zoneValues) {
                QCStarLabel label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.upperLabel);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneCUpper = label;
                label = new QCStarLabel();
                label.labelsOn.setValue(true);
                label.string.setValue(zone.lowerLabel);
                label.color.setValue(this.zoneLabelStyle.getColor());
                label.setFont(this.zoneLabelStyle.getFont());
                this.limitsConnector.zoneCLower = label;
            }
        }
        this.networkRoot.addElement((Element)this.limitsConnector);
    }

    private void buildVMaskConnector() {
        ContinuousRangeToNumericMapper xmaskMapper = new ContinuousRangeToNumericMapper();
        ContinuousRangeToNumericMapper ymaskMapper = new ContinuousRangeToNumericMapper();
        xmaskMapper.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
        ymaskMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        NumericVector nx = null;
        NumericVector ny = null;
        this.vmaskConnector = new QCVMaskConnector();
        double xLeft = this.xEncoder.getLowerLimit();
        double xLower = this.numericX ? ((ContinuousRangeToNumericMapper)this.xvalueMapper).getInverseValue(xLeft) : ((ContinuousRange)this.xRange).getMin();
        double xUpper = this.vmask.originX;
        double dx = Math.abs(xUpper - xLower);
        if (dx < 1.0E-4) {
            this.vmaskConnector.setDegenerate(xUpper, xmaskMapper);
        }
        nx = new NumericVector();
        ny = new NumericVector();
        double yValue = this.vmask.getUCL(xLower);
        nx.addValue(xLower);
        ny.addValue(yValue);
        yValue = this.vmask.getUCL(xUpper);
        nx.addValue(xUpper);
        ny.addValue(yValue);
        yValue = this.vmask.getLCL(xUpper);
        nx.addValue(xUpper);
        ny.addValue(yValue);
        yValue = this.vmask.getLCL(xLower);
        nx.addValue(xLower);
        ny.addValue(yValue);
        if (this.numericX) {
            xmaskMapper.input.connectFrom((NumericPipe)nx);
        }
        ymaskMapper.input.connectFrom((NumericPipe)ny);
        this.vmaskConnector.pointX.connectFrom((NumericPipe)xmaskMapper);
        this.vmaskConnector.pointY.connectFrom((NumericPipe)ymaskMapper);
        LineAttrs la = this.getLimitLineAttrs(0);
        this.uclLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
        this.uclLineWidth.setValue((double)la.getWidth());
        this.uclLinePattern.setValue(la.getLinePattern());
        this.infillColor.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        this.vmaskConnector.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        this.vmaskConnector.setConnectionOrder(0);
        this.vmaskConnector.setSkipMissingOn(true);
        this.vmaskConnector.fillOn.setValue(this.fillOn);
        this.vmaskConnector.fillColor.connectFrom((ColorPipe)this.infillColor);
        this.vmaskConnector.color.connectFrom((ColorPipe)this.uclLineColor);
        this.vmaskConnector.linePattern.connectFrom((IntegerPipe)this.uclLinePattern);
        this.vmaskConnector.lineWidth.connectFrom((NumericPipe)this.uclLineWidth);
        boolean b = this.getLimitLineOn(0);
        this.vmaskConnector.lineOn.setValue(b);
        this.vmaskConnector.selectEnabled.setValue(this.selectable);
        this.vmaskConnector.setUserData(this.probe);
        this.vmaskConnector.setSVGRender(StatGraph.VGF);
        this.vmaskConnector.setSVGRender(true);
        BBox frame = this.translateAxisBounds(true);
        this.vmaskConnector.setFrame(frame);
        this.networkRoot.addElement((Element)this.vmaskConnector);
    }

    protected BBox translateAxisBounds(boolean test) {
        double xAxisLower = this.xEncoder.getLowerLimit();
        double xAxisUpper = this.xEncoder.getUpperLimit();
        double yAxisUpper = this.yEncoder.getUpperLimit();
        double yAxisLower = this.yEncoder.getLowerLimit();
        if (test) {
            int justify;
            QCBlockOverlay legend = this.chart.getBlockOverlay(QCBlockOverlay.BlockType.BLOCK);
            double dy = 0.0;
            if (legend != null) {
                dy = legend.getLegendHeight();
                switch (legend.legendPosition) {
                    case MAX: {
                        yAxisUpper -= dy;
                        break;
                    }
                    case MIN: {
                        yAxisLower += dy;
                    }
                }
                justify = legend.getOverlayJustification();
                if (justify == 1) {
                    yAxisUpper -= dy;
                } else if (justify == 2) {
                    yAxisLower += dy;
                }
            }
            if ((legend = this.chart.getBlockOverlay(QCBlockOverlay.BlockType.PHASE)) != null) {
                dy = legend.getLegendHeight();
                switch (legend.legendPosition) {
                    case MAX: {
                        yAxisUpper -= dy;
                        break;
                    }
                    case MIN: {
                        yAxisLower += dy;
                    }
                }
                justify = legend.getOverlayJustification();
                if (justify == 1) {
                    yAxisUpper -= dy;
                } else if (justify == 2) {
                    yAxisLower += dy;
                }
            }
        }
        return new BBox((int)xAxisLower, (int)yAxisLower, (int)xAxisUpper, (int)yAxisUpper);
    }

    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    private void getCurveEndPoints(Object[] xEnds, Object[] yEnds) {
        NumericVariable uclVar;
        NumericVariable ctlVar;
        NumericVariable sortedX;
        double xMin = this.numericX ? ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMin() : 0.0;
        double xMax = this.numericX ? ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMax() : 1.0;
        double yMin = this.numericY ? ((ContinuousRangeToNumericMap)this.yEncoder.getValueMap()).getInputMin() : 0.0;
        double yMax = this.numericY ? ((ContinuousRangeToNumericMap)this.yEncoder.getValueMap()).getInputMax() : 1.0;
        int n = this.xvalueVar.getValueCount();
        NumericVariable sortedUCL = null;
        NumericVariable sortedCTL = null;
        NumericVariable sortedLCL = null;
        if (this.numericX) {
            sortedX = new NumericVariable();
            sortedX.connectFrom((NumericVariable)this.xvalueVar);
        } else {
            sortedX = new StringVariable();
            ((StringVariable)sortedX).connectFrom((StringVariable)this.xvalueVar);
        }
        NumericVariable lclVar = this.getLimitVariable(1);
        if (lclVar != null) {
            sortedLCL = new NumericVariable();
            sortedLCL.connectFrom(lclVar);
        }
        if ((ctlVar = this.getLimitVariable(2)) != null) {
            sortedCTL = new NumericVariable();
            sortedCTL.connectFrom(ctlVar);
        }
        if ((uclVar = this.getLimitVariable(0)) != null) {
            sortedUCL = new NumericVariable();
            sortedUCL.connectFrom(uclVar);
        }
        if (this.numericX) {
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)sortedX);
            if (sortedLCL != null) {
                vp.addVariable((Variable)sortedLCL);
            }
            if (sortedCTL != null) {
                vp.addVariable((Variable)sortedCTL);
            }
            if (sortedUCL != null) {
                vp.addVariable((Variable)sortedUCL);
            }
            vp.setSort((Variable)sortedX, 1);
        }
        sortedX.getValueCount();
        boolean lcl = false;
        boolean ctl = false;
        boolean ucl = false;
        for (int j = n - 1; j >= 0; --j) {
            block20: {
                try {
                    double d;
                    if (!lcl && this.isDataInsideViewport(j, (Variable)sortedX, (Variable)sortedLCL, xMin, xMax, yMin, yMax)) {
                        xEnds[1] = this.numericX ? new Double(sortedX.value.getValue(j)) : ((StringVariable)sortedX).value.getValue(j);
                        if (lclVar != null) {
                            yEnds[1] = new Double(sortedLCL.value.getValue(j));
                        } else {
                            d = this.getLimitValue(1);
                            yEnds[1] = new Double(d);
                        }
                        lcl = true;
                    }
                    if (!ctl && this.isDataInsideViewport(j, (Variable)sortedX, (Variable)sortedCTL, xMin, xMax, yMin, yMax)) {
                        xEnds[2] = this.numericX ? new Double(sortedX.value.getValue(j)) : ((StringVariable)sortedX).value.getValue(j);
                        if (ctlVar != null) {
                            yEnds[2] = new Double(sortedCTL.value.getValue(j));
                        } else {
                            d = this.getLimitValue(2);
                            yEnds[2] = new Double(d);
                        }
                        ctl = true;
                    }
                    if (ucl || !this.isDataInsideViewport(j, (Variable)sortedX, (Variable)sortedUCL, xMin, xMax, yMin, yMax)) break block20;
                    xEnds[0] = this.numericX ? new Double(sortedX.value.getValue(j)) : ((StringVariable)sortedX).value.getValue(j);
                    if (uclVar != null) {
                        yEnds[0] = new Double(sortedUCL.value.getValue(j));
                    } else {
                        d = this.getLimitValue(0);
                        yEnds[0] = new Double(d);
                    }
                    ucl = true;
                }
                catch (MissingValueException mve) {
                    continue;
                }
            }
            if (lcl && ctl && ucl) break;
        }
    }

    private boolean isDataInsideViewport(int j, Variable x, Variable y, double xMin, double xMax, double yMin, double yMax) {
        double delta = 1.0E-6;
        boolean xIn = true;
        boolean yIn = true;
        try {
            if (x != null && x instanceof NumericVariable && (((NumericVariable)x).value.getValue(j) > xMax + delta || ((NumericVariable)x).value.getValue(j) < xMin - delta)) {
                xIn = false;
            }
            if (y != null && y instanceof NumericVariable && (((NumericVariable)y).value.getValue(j) > yMax + delta || ((NumericVariable)y).value.getValue(j) < yMin - delta)) {
                yIn = false;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return xIn && yIn;
    }

    public double getPreferredOffset(byte dimension) {
        double width = this.joinStyle.getWidth() * 2 - 1;
        double top = (int)Math.round(5.0 * StatGraph.getGapScaleFactor());
        return 2.0 * Math.max(width, 5.0);
    }

    public Insets getPreferredOuterMargin() {
        return this.isCurveLabeled() ? this.getLabelMargin() : zeroInsets;
    }

    private Insets getLabelMargin() {
        boolean zoneLabels;
        int width;
        int top = 0;
        int right = 0;
        double offset = 6.0;
        offset = Math.floor(offset * StatGraph.gapScaleFactor + 0.5);
        if (this.sigmaLegendOn) {
            if (this.sigmaLegendText[0] != null) {
                top = (int)((double)this.sigmaLegendText[0].getBoundsAscent() + 0.5);
                width = this.sigmaLegendText[0].getWidth() + (int)offset;
                right = Math.max(right, width);
            }
            if (this.sigmaLegendText[1] != null) {
                width = this.sigmaLegendText[1].getWidth() + (int)offset;
                right = Math.max(right, width);
            }
        }
        QCLimit limit = this.getLimit(0);
        if (limit.labelOn && limit.text != null) {
            width = limit.text.getWidth() + (int)offset;
            right = Math.max(right, width);
        }
        limit = this.getLimit(2);
        if (limit.labelOn && limit.text != null) {
            width = limit.text.getWidth() + (int)offset;
            right = Math.max(right, width);
        }
        limit = this.getLimit(1);
        if (limit.labelOn && limit.text != null) {
            width = limit.text.getWidth() + (int)offset;
            right = Math.max(right, width);
        }
        boolean bl = zoneLabels = this.zoneValues && this.zoneValuePosition == QCZone.ZoneValuePos.OUTER_RIGHT;
        if (zoneLabels) {
            Rectangle2D r;
            Font font = this.zoneLabelStyle.getFont();
            FontRenderContext frc = new FontRenderContext(null, false, false);
            QCZone zoneA = this.getZone(QCZone.Zone.A);
            QCZone zoneB = this.getZone(QCZone.Zone.B);
            QCZone zoneC = this.getZone(QCZone.Zone.C);
            String label = zoneA.upperLabel;
            if (label != null && label.length() > 0) {
                r = font.getStringBounds(label, frc);
                width = (int)r.getWidth();
                right = Math.max(right, width);
            }
            if ((label = zoneB.upperLabel) != null && label.length() > 0) {
                r = font.getStringBounds(label, frc);
                width = (int)r.getWidth();
                right = Math.max(right, width);
            }
            if ((label = zoneC.upperLabel) != null && label.length() > 0) {
                r = font.getStringBounds(label, frc);
                width = (int)r.getWidth();
                right = Math.max(right, width);
            }
            if ((label = zoneA.lowerLabel) != null && label.length() > 0) {
                r = font.getStringBounds(label, frc);
                width = (int)r.getWidth();
                right = Math.max(right, width);
            }
            if ((label = zoneB.lowerLabel) != null && label.length() > 0) {
                r = font.getStringBounds(label, frc);
                width = (int)r.getWidth();
                right = Math.max(right, width);
            }
            if ((label = zoneC.lowerLabel) != null && label.length() > 0) {
                r = font.getStringBounds(label, frc);
                width = (int)r.getWidth();
                right = Math.max(right, width);
            }
        }
        Insets labelMargin = new Insets(top, 0, 0, right);
        return labelMargin;
    }

    public int getPreferredMarginTop() {
        int top = this.sigmaLegendOn && this.sigmaLegendText[0] != null ? (int)((double)this.sigmaLegendText[0].getBoundsAscent() + 0.5) : 0;
        return top;
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public void setTransparency(double d) {
        this.transparency = d;
    }

    public void setInFill(boolean fill) {
        this.fillOn = fill;
    }

    public boolean getInFill() {
        return this.fillOn;
    }

    public boolean isCurveLabeled() {
        return true;
    }

    public boolean isProtectedLine() {
        return this.labelProtected;
    }

    public void setProtectedLine(boolean b) {
        this.labelProtected = b;
    }

    public void setJoinStyle(LineAttrs style) {
        this.joinStyle = style;
    }

    public void setUnicodeStyle(TextStyle style) {
        this.limits[1].setUnicodeStyle(style);
        this.limits[2].setUnicodeStyle(style);
        this.limits[0].setUnicodeStyle(style);
        this.sigmaLegendText[0].setUnicodeStyle(style);
        this.sigmaLegendText[1].setUnicodeStyle(style);
    }

    public LineAttrs getJoinStyle() {
        return this.joinStyle;
    }

    public QCLimit getLimit(int iLimit) {
        return this.limits[iLimit];
    }

    public double getLimit(int iLimit, int igrp) {
        return this.limits[iLimit].getValue(igrp);
    }

    public void setLimitDisplay(int iLimit, boolean on) {
        this.limits[iLimit].display = on;
        this.limits[iLimit].lineOn = on;
        this.limits[iLimit].labelOn = on;
    }

    public void setLimitLineOn(int iLimit, boolean on) {
        this.limits[iLimit].display = on;
        this.limits[iLimit].lineOn = on;
    }

    public void setPhaseLimitLabelsOn(boolean on) {
        this.phaseLimitLabels = on;
    }

    public boolean getPhaseLimitLabels() {
        return this.phaseLimitLabels;
    }

    public void setZoneLabelsOn(boolean on) {
        this.zoneLabels = on;
    }

    public boolean getZoneLabels() {
        return this.zoneLabels;
    }

    public void setZoneValuesOn(boolean on) {
        this.zoneValues = on;
    }

    public boolean getZoneValues() {
        return this.zoneValues;
    }

    public void setLimitLabelOn(int iLimit, boolean on) {
        this.limits[iLimit].display = on;
        this.limits[iLimit].labelOn = on ? this.limits[iLimit].lineOn : false;
    }

    public void setLimitText(int iLimit, String s, Vector attrs) {
        QCLimit limit = this.getLimit(iLimit);
        QCStylizedText text = limit.text;
        text.ibar2 = s.indexOf("\u033f");
        text.label = s;
        text.labelAttributes = attrs;
        text.build();
        limit.labelOn = s != null && s.length() != 0 && !s.equals("");
    }

    public void setLimitText(int iLimit, String s) {
        QCLimit limit = this.getLimit(iLimit);
        QCStylizedText text = limit.text;
        text.ibar2 = s.indexOf("\u033f");
        text.label = s;
        text.labelAttributes = null;
        text.build();
        limit.labelOn = s != null && s.length() != 0 && !s.equals("");
    }

    public boolean getLimitLineOn() {
        return this.getLimitLineOn(1);
    }

    public boolean getLimitLineOn(int iLimit) {
        boolean rc;
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                rc = true;
                break;
            }
            default: {
                rc = this.limits[iLimit].lineOn;
            }
        }
        return rc;
    }

    public boolean getLimitLabelOn(int iLimit) {
        return this.limits[iLimit].labelOn;
    }

    public QCStylizedText getLimitText(int iLimit) {
        return this.limits[iLimit].text;
    }

    public void setSigmaText(int iLine, String s, Vector attrs) {
        if (iLine >= 0 && iLine < 2) {
            this.sigmaLegendText[iLine].label = s;
            this.sigmaLegendText[iLine].labelAttributes = attrs;
        }
    }

    public QCStylizedText[] getSigmaText() {
        return this.sigmaLegendText;
    }

    public void setZoneLine(boolean b) {
        this.zoneLine = b;
        if (b) {
            this.zonesOn = true;
        }
    }

    public boolean zoneLine() {
        return this.zoneLine;
    }

    public void setZoneFill(boolean b) {
        this.zoneFill = b;
        if (b) {
            this.zonesOn = true;
        }
    }

    public boolean zoneFill() {
        return this.zoneFill;
    }

    public void setZone(char zone, double upperLimit, double lowerLimit, String label, QCZone.ZoneLabelPos labelPosition, QCZone.ZoneValuePos valuePosition, String upperLabel, String lowerLabel) {
        QCZone z = this.getZone(zone);
        z.init(zone, upperLimit, lowerLimit, label, labelPosition, valuePosition, upperLabel, lowerLabel);
        this.zoneLabelPosition = labelPosition;
        this.zoneValuePosition = valuePosition;
    }

    public QCZone getZone(char zone) {
        int i = QCZone.getZoneIndex(zone);
        return this.zones[i];
    }

    public QCZone getZone(QCZone.Zone type) {
        QCZone z = null;
        switch (type) {
            case A: {
                z = this.zones[0];
                break;
            }
            case B: {
                z = this.zones[1];
                break;
            }
            case C: {
                z = this.zones[2];
            }
        }
        return z;
    }

    public QCZone getZone(int i) {
        return this.zones[i];
    }

    public FillAttrs getLimitFillAttrs() {
        return this.fillStyle;
    }

    public void setLimitFillAttrs(FillAttrs style) {
        this.fillStyle = style;
    }

    public LineAttrs getLimitLineAttrs() {
        return this.getLimitLineAttrs(1);
    }

    public LineAttrs getLimitLineAttrs(int iLimit) {
        return this.limits[iLimit].lineStyle;
    }

    public void setLimitLineAttrs(int iLimit, LineAttrs style) {
        this.limits[iLimit].lineStyle = style;
    }

    public TextStyle getLimitLabelStyle() {
        return this.getLimitLabelStyle(1);
    }

    public TextStyle getLimitLabelStyle(int iLimit) {
        return this.limits[iLimit].text.textStyle;
    }

    public void setLimitLabelStyle(int iLimit, TextStyle style) {
        this.limits[iLimit].text.textStyle = style;
    }

    public void setXsymStyle(int iLimit, TextStyle style) {
        this.limits[iLimit].text.xsymStyle = style;
    }

    public void setBar2Style(int iLimit, TextStyle style) {
        this.limits[iLimit].text.bar2Style = style;
    }

    public void setVarID(int iLimit, String varID) {
        this.limits[iLimit].varID = varID;
    }

    public void setLimitVariable(int iLimit, NumericVariable var) {
        this.limits[iLimit].var = var;
    }

    public String getVarID(int iLimit) {
        return this.limits[iLimit].varID;
    }

    public NumericVariable getLimitVariable(int iLimit) {
        return this.limits[iLimit].var;
    }

    public void setLimitValue(int iLimit, double d) {
        this.limits[iLimit].fixed = true;
        this.limits[iLimit].value = d;
        if (Double.isNaN(d)) {
            this.limits[iLimit].display = false;
        }
    }

    public double getLimitValue(int iLimit) {
        double d = Double.NaN;
        switch (this.schemeType) {
            case SCHEME_SHEWHART: {
                d = this.limits[iLimit].value;
                break;
            }
            case SCHEME_ONESIDED: {
                switch (iLimit) {
                    case 0: {
                        d = this.limits[iLimit].value;
                        break;
                    }
                    case 1: {
                        d = this.yvalueMapper == null ? Double.NaN : ((ContinuousRangeToNumericMapper)this.yvalueMapper).getInputMin();
                        break;
                    }
                    case 2: {
                        d = Double.NaN;
                    }
                }
                break;
            }
            case SCHEME_TWOSIDED: {
                d = Double.NaN;
            }
        }
        return d;
    }

    public void setRange(int iLimit, DataRange range) {
        this.limits[iLimit].range = range;
    }

    public DataRange getLimitRange(int iLimit) {
        return this.limits[iLimit].range;
    }

    public void setRole(int iLimit, short role) {
        this.limits[iLimit].role = role;
    }

    public short getRole(int iLimit) {
        return this.limits[iLimit].role;
    }

    public boolean isConstant(int iLimit) {
        return this.limits[iLimit].fixed;
    }

    public FillAttrs getZoneFillAttrs(char zone) {
        int i = QCZone.getZoneIndex(zone);
        return this.zones[i].fillStyle;
    }

    public FillAttrs getZoneFillAttrs(int iZone) {
        return this.zones[iZone].fillStyle;
    }

    public void setZoneFillAttrs(char zone, FillAttrs style) {
        int iZone = QCZone.getZoneIndex(zone);
        this.zones[iZone].fillStyle = style;
    }

    public LineAttrs getZoneLineAttrs(char zone) {
        int iZone = QCZone.getZoneIndex(zone);
        return this.zones[iZone].lineStyle;
    }

    public LineAttrs getZoneLineAttrs(int iZone) {
        return this.zones[iZone].lineStyle;
    }

    public void setZoneLineAttrs(char zone, LineAttrs style) {
        int iZone = QCZone.getZoneIndex(zone);
        this.zones[iZone].lineStyle = style;
    }

    public TextStyle getZoneTextStyle(char zone) {
        int iZone = QCZone.getZoneIndex(zone);
        return this.zones[iZone].textStyle;
    }

    public TextStyle getZoneTextStyle(int iZone) {
        return this.zones[iZone].textStyle;
    }

    public void setZoneTextStyle(char zone, TextStyle style) {
        int iZone = QCZone.getZoneIndex(zone);
        this.zones[iZone].textStyle = style;
    }

    public void setZoneTextStyle(int iZone, TextStyle style) {
        this.zones[iZone].textStyle = style;
    }

    public TextStyle getSigmaLegendTextStyle() {
        return null;
    }

    public void setSigmaLegendTextStyle(TextStyle style) {
        for (int i = 0; i < 2; ++i) {
            TextStyle ts = this.sigmaLegendText[i].textStyle;
            ts.setColor(style.getColor());
            ts.setFont(style.getFont());
        }
    }

    public LineAttrs getOutLineAttrs() {
        return this.oocLineStyle;
    }

    public void setOutLineAttrs(LineAttrs style) {
        this.oocLineStyle = style;
    }

    @Override
    public FillAttrs getOOCFillAttrs() {
        return this.oocFillStyle;
    }

    @Override
    public void setOOCFillAttrs(FillAttrs style) {
        this.oocFillStyle = style;
    }

    public void setSigmaLegendOn(boolean on) {
        this.sigmaLegendOn = on;
    }

    public boolean isSigmaLegendOn() {
        return this.sigmaLegendOn;
    }

    public Area getInfillArea(boolean outLineLower, boolean outLineUpper) {
        return this.infillArea == null ? this.getInfillArea(outLineLower, outLineUpper, true, true, false) : this.infillArea;
    }

    private Area getInfillArea(boolean outLineLower, boolean outLineUpper, boolean maskMissingPhases, boolean useAxisOffsets, boolean useExtendedRange) {
        return this.getInfillArea(null, outLineLower, outLineUpper, maskMissingPhases, useAxisOffsets, useExtendedRange);
    }

    private Area getInfillArea(Rectangle r, boolean outLineLower, boolean outLineUpper, boolean maskMissingPhases, boolean useAxisOffsets, boolean useExtendedRange) {
        Area area = null;
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                area = this.getVMaskInfillArea(r, maskMissingPhases, useAxisOffsets);
                break;
            }
            default: {
                area = this.getShewhartInfillArea(r, outLineLower, outLineUpper, maskMissingPhases, useAxisOffsets, useExtendedRange);
            }
        }
        return area;
    }

    private Area getVMaskInfillArea(Rectangle r, boolean maskMissingPhases, boolean useAxisOffsets) {
        Area area = null;
        GeneralPath polygon = null;
        boolean screenCoordinates = true;
        if (!this.vmask.getScreenCoordinates(this)) {
            return null;
        }
        polygon = new GeneralPath(0, 4);
        Point2D.Double pt = this.vmask.getVMaskUL(screenCoordinates);
        polygon.moveTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 0: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        pt = this.vmask.getVMaskUR(screenCoordinates);
        polygon.lineTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 1: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        pt = this.vmask.getVMaskLR(screenCoordinates);
        polygon.lineTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 2: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        pt = this.vmask.getVMaskLL(screenCoordinates);
        polygon.lineTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 3: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        polygon.closePath();
        area = new Area(polygon);
        return area;
    }

    private Area getShewhartInfillArea(Rectangle r, boolean outLineLower, boolean outLineUpper, boolean maskMissingPhases, boolean useAxisOffsets, boolean useExtendedRange) {
        double[] temp = new double[3];
        Area area = new Area();
        GeneralPath polygon = null;
        int xLeft = this.innerAxisBounds.x;
        int xRight = xLeft + this.innerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int height = yBottom - yTop + 1;
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        int offset = 0;
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean phaseLegend = QCShewhart.getPhaseLegend();
        int nPhases = 1;
        Vector<QCBlockOverlay.BlockEntry> indices = null;
        int[] refList = null;
        boolean phaseLimits = false;
        if (o != null) {
            nPhases = o.getPhaseIndicesN();
            indices = o.getPhaseIndices();
            refList = o.getPhaseBoundaries();
            phaseLimits = o.usePhaseLimits();
        }
        if (nPhases == 0) {
            nPhases = 1;
            indices = null;
            refList = null;
            phaseLimits = false;
        }
        boolean displayLower = this.getLimitLineOn(1);
        boolean displayUpper = this.getLimitLineOn(0);
        QCLimit ucl = this.limits[0];
        QCLimit lcl = this.limits[1];
        for (int iPhase = 0; iPhase < nPhases; ++iPhase) {
            float fy;
            float fx;
            double y;
            int i;
            double[][] pLine;
            int iLast;
            int nLower;
            int nUpper;
            Area poly;
            int dx;
            double x;
            int j;
            QCBlockOverlay.BlockEntry entry;
            if (phaseLimits) {
                entry = indices.get(iPhase);
                if (!entry.limits) {
                    int x2;
                    int x1;
                    if (!maskMissingPhases) continue;
                    if (iPhase == 0) {
                        x1 = xLeft;
                    } else {
                        j = useExtendedRange ? refList[iPhase] + 1 : refList[iPhase];
                        x = this.getSubgrp(j);
                        this.project(x, 0.0, 0.0, temp);
                        dx = glyphOffset + blockOffset;
                        x1 = (int)temp[0] - dx;
                    }
                    if (iPhase == nPhases - 1) {
                        x2 = xRight;
                    } else {
                        j = useExtendedRange ? refList[iPhase + 1] + 1 : refList[iPhase + 1];
                        x = this.getSubgrp(j);
                        this.project(x, 0.0, 0.0, temp);
                        dx = glyphOffset + blockOffset;
                        x2 = (int)temp[0] - dx;
                    }
                    int width = x2 - x1 + 1;
                    poly = new Area(new Rectangle(x1, yTop, width, height));
                    area.add(poly);
                    continue;
                }
                nUpper = ucl.phaseDataN[iPhase];
                nLower = lcl.phaseDataN[iPhase];
            } else {
                entry = null;
                nUpper = ucl.dataN;
                nLower = lcl.dataN;
            }
            if (!outLineLower) {
                nLower = 2;
            }
            if (!outLineUpper) {
                nUpper = 2;
            }
            if (nUpper == 0 && nLower == 0) continue;
            polygon = new GeneralPath(0, nUpper + nLower + 4);
            if (displayUpper && outLineUpper) {
                boolean valid = false;
                iLast = -1;
                double[][] dArray = pLine = phaseLimits ? ucl.phaseData[iPhase] : ucl.data;
                if (pLine != null) {
                    for (i = 0; i < nUpper; ++i) {
                        x = pLine[i][0];
                        y = pLine[i][1];
                        if (Double.isNaN(y)) continue;
                        this.project(x, y, 0.0, temp);
                        valid = true;
                        iLast = i;
                        if (iPhase == 0 && i == 0) {
                            fx = xLeft;
                            fy = (float)temp[1];
                            polygon.moveTo(fx, fy);
                        } else {
                            dx = i == 0 ? glyphOffset + blockOffset : offset;
                            fx = (float)temp[0] - (float)dx;
                            fy = (float)temp[1];
                            polygon.moveTo(fx, fy);
                        }
                        ++i;
                        break;
                    }
                    if (!valid) {
                        this.project(pLine[0][0], 0.0, 0.0, temp);
                        if (iPhase == 0) {
                            fx = xLeft;
                        } else {
                            dx = glyphOffset + blockOffset;
                            fx = (float)temp[0] - (float)dx;
                        }
                        float phaseLeft = fx;
                        if (iPhase == nPhases - 1) {
                            fx = xRight;
                        } else if (phaseLimits) {
                            j = useExtendedRange ? refList[iPhase + 1] + 1 : refList[iPhase + 1];
                            x = this.getSubgrp(j);
                            this.project(x, 0.0, 0.0, temp);
                            dx = glyphOffset + blockOffset;
                            fx = (float)temp[0] - (float)dx;
                        }
                        float phaseRight = fx;
                        polygon.moveTo(phaseLeft, yTop);
                        polygon.lineTo(phaseRight, yTop);
                        polygon.lineTo(phaseRight, yBottom);
                        polygon.lineTo(phaseLeft, yBottom);
                        polygon.closePath();
                        poly = new Area(polygon);
                        area.add(poly);
                        continue;
                    }
                    while (i < nUpper) {
                        x = pLine[i][0];
                        y = pLine[i][1];
                        if (!Double.isNaN(y)) {
                            this.project(x, y, 0.0, temp);
                            dx = i == 0 ? blockOffset : offset;
                            fx = (float)temp[0] - (float)dx;
                            fy = (float)temp[1];
                            polygon.lineTo(fx, fy);
                            iLast = i;
                        }
                        ++i;
                    }
                    if (iPhase == nPhases - 1) {
                        if (iLast >= 0 && iLast == nUpper - 1) {
                            fx = xRight;
                            fy = (float)temp[1];
                            polygon.lineTo(fx, fy);
                        }
                    } else if (phaseLimits && iLast >= 0 && iLast == nUpper - 1) {
                        j = useExtendedRange ? refList[iPhase + 1] + 1 : refList[iPhase + 1];
                        x = this.getSubgrp(j);
                        y = pLine[iLast][1];
                        this.project(x, y, 0.0, temp);
                        dx = glyphOffset + blockOffset;
                        fx = (float)temp[0] - (float)dx;
                        fy = (float)temp[1];
                        polygon.lineTo(fx, fy);
                    }
                }
            } else {
                polygon.moveTo(xLeft, yTop);
                polygon.lineTo(xRight, yTop);
            }
            if (displayLower && outLineLower) {
                double[][] dArray = pLine = phaseLimits ? lcl.phaseData[iPhase] : lcl.data;
                if (pLine != null) {
                    for (i = nLower - 1; i >= 0; --i) {
                        x = pLine[i][0];
                        y = pLine[i][1];
                        if (Double.isNaN(y)) continue;
                        if (iPhase == nPhases - 1 && i == nLower - 1) {
                            this.project(x, y, 0.0, temp);
                            fx = xRight;
                            fy = (float)temp[1];
                            polygon.lineTo(fx, fy);
                            break;
                        }
                        if (!phaseLimits || i != nLower - 1) break;
                        j = useExtendedRange ? refList[iPhase + 1] + 1 : refList[iPhase + 1];
                        x = this.getSubgrp(j);
                        this.project(x, y, 0.0, temp);
                        dx = glyphOffset + blockOffset;
                        fx = (float)temp[0] - (float)dx;
                        fy = (float)temp[1];
                        polygon.lineTo(fx, fy);
                        break;
                    }
                    iLast = -1;
                    while (i >= 0) {
                        x = pLine[i][0];
                        y = pLine[i][1];
                        if (!Double.isNaN(y)) {
                            this.project(x, y, 0.0, temp);
                            dx = i == 0 ? glyphOffset + blockOffset : offset;
                            fx = (float)temp[0] - (float)dx;
                            fy = (float)temp[1];
                            polygon.lineTo(fx, fy);
                            iLast = i;
                        }
                        --i;
                    }
                    if (iPhase == 0 && iLast == 0) {
                        fx = xLeft;
                        fy = (float)temp[1];
                        polygon.lineTo(fx, fy);
                    }
                    polygon.closePath();
                }
            } else {
                polygon.lineTo(xRight, yBottom);
                polygon.lineTo(xLeft, yBottom);
                polygon.closePath();
            }
            poly = new Area(polygon);
            area.add(poly);
        }
        return area;
    }

    public Area getOutfillArea() {
        return this.outfillArea == null ? this.getOutfillArea(true, true) : this.outfillArea;
    }

    private Area getOutfillArea(boolean maskMissingPhases, boolean useAxisOffsets) {
        if (this.outfillArea != null) {
            return this.outfillArea;
        }
        Area area = null;
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                area = this.getVMaskOutfillArea(maskMissingPhases, useAxisOffsets);
                break;
            }
            default: {
                area = this.getShewhartOutfillArea(maskMissingPhases, useAxisOffsets);
            }
        }
        this.outfillArea = area;
        return area;
    }

    private Area getVMaskOutfillArea(boolean maskMissingPhases, boolean useAxisOffsets) {
        Area area = null;
        GeneralPath polygon = null;
        if (!this.vmask.getScreenCoordinates(this)) {
            return null;
        }
        double xLeft = this.innerAxisBounds.x;
        double xRight = xLeft + (double)this.innerAxisBounds.width;
        double yTop = useAxisOffsets ? (double)this.outerAxisBounds.y : (double)this.innerAxisBounds.y;
        double yBottom = yTop + (double)(useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        double[] temp = new double[3];
        boolean screenCoordinates = true;
        this.project(this.vmask.originX, this.vmask.originY, 0.0, temp);
        double xOrigin = temp[0];
        double vUpper = this.vmask.getVMaskUL(screenCoordinates).getY();
        double vOriginUpper = this.vmask.getVMaskUR(screenCoordinates).getY();
        double vLower = this.vmask.getVMaskLL(screenCoordinates).getY();
        double vOriginLower = this.vmask.getVMaskLR(screenCoordinates).getY();
        polygon = new GeneralPath(0, 8);
        if (vOriginUpper < yTop) {
            polygon.moveTo(xRight, yTop);
            polygon.lineTo(xOrigin, yTop);
        } else if (vUpper < yTop) {
            polygon.moveTo(xRight, vUpper);
            polygon.lineTo(xLeft, vUpper);
            polygon.lineTo(xOrigin, vOriginUpper);
        } else {
            polygon.moveTo(xRight, yTop);
            polygon.lineTo(xLeft, yTop);
            polygon.lineTo(xLeft, vUpper);
            polygon.lineTo(xOrigin, vOriginUpper);
        }
        if (vOriginLower > yBottom) {
            polygon.lineTo(xOrigin, yBottom);
            polygon.lineTo(xRight, yBottom);
        } else if (vLower > yBottom) {
            polygon.lineTo(xOrigin, vOriginLower);
            polygon.lineTo(xLeft, vLower);
            polygon.lineTo(xRight, vLower);
        } else {
            polygon.lineTo(xOrigin, vOriginLower);
            polygon.lineTo(xLeft, vLower);
            polygon.lineTo(xLeft, yBottom);
            polygon.lineTo(xRight, yBottom);
        }
        polygon.closePath();
        area = new Area(polygon);
        return area;
    }

    private Area getShewhartOutfillArea(boolean maskMissingPhases, boolean useAxisOffsets) {
        boolean phaseLimits;
        int[] refList;
        Vector<QCBlockOverlay.BlockEntry> indices;
        int nPhases;
        double[] temp = new double[3];
        Area area = new Area();
        GeneralPath polygon = null;
        int xLeft = this.outerAxisBounds.x;
        int xRight = xLeft + this.outerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        int offset = 0;
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean phaseLegend = QCShewhart.getPhaseLegend();
        if (phaseLegend) {
            nPhases = o.getPhaseIndicesN();
            indices = o.getPhaseIndices();
            refList = o.getPhaseBoundaries();
            phaseLimits = indices != null && refList != null;
        } else {
            nPhases = 1;
            indices = null;
            refList = null;
            phaseLimits = false;
        }
        boolean useExtendedRange = true;
        QCLimit ucl = this.limits[0];
        QCLimit lcl = this.limits[1];
        for (int iPhase = 0; iPhase < nPhases; ++iPhase) {
            Area poly;
            int j;
            int dx;
            double y;
            double x;
            int i;
            float xLast;
            float xFirst;
            boolean valid;
            double[][] pLine;
            int nLower;
            int nUpper;
            QCBlockOverlay.BlockEntry entry;
            if (phaseLimits) {
                entry = indices.get(iPhase);
                if (!entry.limits) continue;
                nUpper = ucl.phaseDataN[iPhase];
                nLower = lcl.phaseDataN[iPhase];
            } else {
                entry = null;
                nUpper = ucl.dataN;
                nLower = lcl.dataN;
            }
            if (nUpper == 0 && nLower == 0) continue;
            double[][] dArray = pLine = phaseLimits ? ucl.phaseData[iPhase] : ucl.data;
            if (pLine != null && ucl.lineOn) {
                valid = false;
                polygon = new GeneralPath(0, nUpper + 4);
                xFirst = 0.0f;
                xLast = 0.0f;
                for (i = 0; i < nUpper; ++i) {
                    x = pLine[i][0];
                    y = pLine[i][1];
                    if (Double.isNaN(y)) continue;
                    this.project(x, y, 0.0, temp);
                    valid = true;
                    if (iPhase == 0) {
                        xFirst = xLeft;
                        polygon.moveTo(xFirst, (float)temp[1]);
                    } else {
                        dx = i == 0 ? glyphOffset + blockOffset : offset;
                        xFirst = (float)temp[0] - (float)dx;
                        polygon.moveTo(xFirst, (float)temp[1]);
                    }
                    ++i;
                    break;
                }
                if (valid) {
                    while (i < nUpper) {
                        x = pLine[i][0];
                        y = pLine[i][1];
                        if (!Double.isNaN(y)) {
                            this.project(x, y, 0.0, temp);
                            dx = i == 0 ? blockOffset : offset;
                            xLast = (float)temp[0] - (float)dx;
                            polygon.lineTo(xLast, (float)temp[1]);
                        }
                        ++i;
                    }
                    if (iPhase == nPhases - 1) {
                        xLast = xRight;
                        polygon.lineTo(xLast, (float)temp[1]);
                    } else if (phaseLimits) {
                        j = useExtendedRange ? refList[iPhase + 1] + 1 : refList[iPhase + 1];
                        x = this.getSubgrp(j);
                        y = pLine[i - 1][1];
                        this.project(x, y, 0.0, temp);
                        dx = glyphOffset + blockOffset;
                        xLast = (float)temp[0] - (float)dx;
                        polygon.lineTo((float)temp[0] - (float)dx, (float)temp[1]);
                    }
                    polygon.lineTo(xLast, yTop);
                    polygon.lineTo(xFirst, yTop);
                    polygon.closePath();
                    poly = new Area(polygon);
                    area.add(poly);
                }
            }
            double[][] dArray2 = pLine = phaseLimits ? lcl.phaseData[iPhase] : lcl.data;
            if (pLine == null || !lcl.lineOn) continue;
            valid = false;
            polygon = new GeneralPath(0, nLower + 4);
            xFirst = 0.0f;
            xLast = 0.0f;
            for (i = 0; i < nLower; ++i) {
                x = pLine[i][0];
                y = pLine[i][1];
                if (Double.isNaN(y)) continue;
                this.project(x, y, 0.0, temp);
                valid = true;
                if (iPhase == 0) {
                    xFirst = xLeft;
                    polygon.moveTo(xFirst, (float)temp[1]);
                } else {
                    dx = i == 0 ? glyphOffset + blockOffset : offset;
                    xFirst = (float)temp[0] - (float)dx;
                    polygon.moveTo(xFirst, (float)temp[1]);
                }
                ++i;
                break;
            }
            if (!valid) continue;
            while (i < nLower) {
                x = pLine[i][0];
                y = pLine[i][1];
                if (!Double.isNaN(y)) {
                    this.project(x, y, 0.0, temp);
                    dx = i == 0 ? blockOffset : offset;
                    xLast = (float)temp[0] - (float)dx;
                    polygon.lineTo(xLast, (float)temp[1]);
                }
                ++i;
            }
            if (iPhase == nPhases - 1) {
                xLast = xRight;
                polygon.lineTo(xLast, (float)temp[1]);
            } else if (phaseLimits) {
                j = useExtendedRange ? refList[iPhase + 1] + 1 : refList[iPhase + 1];
                x = this.getSubgrp(j);
                y = pLine[i - 1][1];
                this.project(x, y, 0.0, temp);
                dx = glyphOffset + blockOffset;
                xLast = (float)temp[0] - (float)dx;
                polygon.lineTo(xLast, (float)temp[1]);
            }
            polygon.lineTo(xLast, yBottom);
            polygon.lineTo(xFirst, yBottom);
            polygon.closePath();
            poly = new Area(polygon);
            area.add(poly);
        }
        return area;
    }

    public Area getMissingAreas() {
        boolean phaseLimits;
        Area area = null;
        int iBand = 0;
        double[] temp = new double[3];
        boolean useAxisOffsets = false;
        double xLeft = this.innerAxisBounds.x;
        double xRight = xLeft + (double)this.innerAxisBounds.width;
        double yTop = useAxisOffsets ? (double)this.outerAxisBounds.y : (double)this.innerAxisBounds.y;
        double yBottom = yTop + (double)(useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        boolean offset = false;
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean bl = phaseLimits = o != null && o.usePhaseLimits();
        if (!phaseLimits) {
            Rectangle r = new Rectangle(this.innerAxisBounds);
            int height = r.height;
            int nPts = this.limits[iBand].dataN;
            double[][] pLine = this.limits[iBand].data;
            int i = 0;
            double x = pLine[i][0];
            double y = pLine[i][1];
            boolean blank = false;
            for (i = 0; i < nPts; ++i) {
                x = pLine[i][0];
                y = pLine[i][1];
                this.project(x, y, 0.0, temp);
                if (blank ? Double.isNaN(temp[1]) : !Double.isNaN(temp[1])) continue;
                double dx = (double)offset;
                float fx = (float)(temp[0] - dx);
                float fy = (float)temp[1];
                if (blank) {
                    r.width = (int)(fx - (float)r.x);
                    if (area == null) {
                        area = new Area();
                    }
                    area.add(new Area(r));
                    blank = false;
                    continue;
                }
                r = new Rectangle();
                r.x = (int)fx;
                r.y = (int)yTop;
                r.height = height;
                blank = true;
            }
        }
        return area;
    }

    public Area getNonMissingAreas() {
        boolean phaseLimits;
        Area area = null;
        int iBand = 0;
        double[] temp = new double[3];
        boolean useAxisOffsets = false;
        double xLeft = this.outerAxisBounds.x;
        double xRight = xLeft + (double)this.outerAxisBounds.width;
        double yTop = useAxisOffsets ? (double)this.outerAxisBounds.y : (double)this.innerAxisBounds.y;
        double yBottom = yTop + (double)(useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int height = this.innerAxisBounds.height;
        switch (this.schemeType) {
            case SCHEME_ONESIDED: 
            case SCHEME_SHEWHART: {
                break;
            }
            case SCHEME_TWOSIDED: {
                int dfltTopOffset = QCShewhart.getDefaultAxisOffset(QCShewhart.MarginOffsetType.OFFSET_YMAX);
                int dfltBottomOffset = QCShewhart.getDefaultAxisOffset(QCShewhart.MarginOffsetType.OFFSET_YMIN);
                yTop += (double)dfltTopOffset;
                height -= dfltTopOffset + dfltBottomOffset;
            }
        }
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        boolean offset = false;
        double[][] pLine = this.limits[iBand].data;
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean bl = phaseLimits = o != null && o.usePhaseLimits();
        if (!phaseLimits && pLine != null) {
            Rectangle r;
            int nPts = this.limits[iBand].dataN;
            int i = 0;
            double x = pLine[i][0];
            double y = pLine[i][1];
            boolean blank = Double.isNaN(y);
            for (i = 0; i < nPts; ++i) {
                x = pLine[i][0];
                y = pLine[i][1];
                this.project(x, y, 0.0, temp);
                double dx = (double)offset;
                float fx = (float)(temp[0] - dx);
                float fy = (float)temp[1];
                if (Double.isNaN(temp[1])) {
                    if (blank) continue;
                    if (area == null) {
                        area = new Area();
                    }
                    r = new Rectangle();
                    r.x = (int)xLeft;
                    r.y = (int)yTop;
                    r.width = (int)(fx - (float)r.x);
                    r.height = height;
                    area.add(new Area(r));
                    blank = true;
                    continue;
                }
                if (blank) {
                    xLeft = fx;
                }
                blank = false;
            }
            if (area != null && !blank) {
                r = new Rectangle();
                r.x = (int)xLeft;
                r.y = (int)yTop;
                r.width = (int)(xRight - (double)r.x);
                r.height = height;
                area.add(new Area(r));
            }
        }
        return area;
    }

    public Area getMaskingArea(Graphics p, int iBand) {
        Area area = null;
        Graphics2D g = (Graphics2D)p;
        if (this.needConnect && !this.connectNetwork()) {
            return null;
        }
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                area = this.getVMaskMaskingArea(g, iBand);
                break;
            }
            default: {
                area = this.getShewhartMaskingArea(g, iBand);
            }
        }
        return area;
    }

    private Area getVMaskMaskingArea(Graphics2D g, int iBand) {
        Point2D pt;
        Area area = null;
        Area poly = null;
        GeneralPath polygon = null;
        boolean useAxisOffsets = true;
        boolean useExtendedRange = true;
        double[] temp = new double[3];
        int xLeft = this.outerAxisBounds.x;
        int xRight = xLeft + this.outerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int yFrame = iBand == 0 ? yTop : yBottom;
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        boolean offset = false;
        boolean screenCoordinates = true;
        if (!this.vmask.getScreenCoordinates(this)) {
            return null;
        }
        area = new Area();
        polygon = new GeneralPath(0, 4);
        polygon.moveTo(xLeft, yFrame);
        if (this.debugFill) {
            pt = polygon.getCurrentPoint();
            System.out.println("Mask 0: " + (int)pt.getX() + ", " + (int)pt.getY());
        }
        if (iBand == 0) {
            pt = this.vmask.getVMaskUL(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 1: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
            pt = this.vmask.getVMaskUR(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 2: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
        } else {
            pt = this.vmask.getVMaskLL(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 1: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
            pt = this.vmask.getVMaskLR(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 2: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
        }
        pt = polygon.getCurrentPoint();
        polygon.lineTo(pt.getX(), (double)yFrame);
        if (this.debugFill) {
            pt = polygon.getCurrentPoint();
            System.out.println("Mask 3: " + (int)pt.getX() + ", " + (int)pt.getY());
        }
        polygon.closePath();
        poly = new Area(polygon);
        area.add(poly);
        if (this.debugFill) {
            System.out.println("\n");
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.PINK);
            g.setClip(null);
            g.fill(area);
        }
        return area;
    }

    private Area getShewhartMaskingArea(Graphics2D g, int iBand) {
        QCLimit limit = this.limits[iBand];
        if (!limit.lineOn) {
            return null;
        }
        int nUpper = 0;
        int nLower = 0;
        double[][] pLine = null;
        double[] temp = new double[3];
        Area area = new Area();
        GeneralPath polygon = null;
        boolean useAxisOffsets = true;
        int xLeft = this.innerAxisBounds.x;
        int xRight = xLeft + this.innerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int yFrame = iBand == 0 ? yTop : yBottom;
        int blockOffset = QCShewhart.getAdjustedBlockOffset();
        int offset = 0;
        Vector<QCBlockOverlay.BlockEntry> indices = null;
        int[] refList = null;
        int nPhases = 1;
        boolean phaseLimits = false;
        boolean phaseBreak = false;
        boolean fixed = limit.fixed;
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        double xl = this.getSubgrp(igrpLower);
        double xr = this.getSubgrp(igrpUpper);
        double yl = 0.0;
        double yr = 0.0;
        switch (iBand) {
            case 0: {
                yl = this.getLimit(0, igrpLower);
                this.project(0.0, yl, 0.0, temp);
                yl = temp[1];
                yr = this.getLimit(0, igrpUpper);
                this.project(0.0, yr, 0.0, temp);
                yr = temp[1];
                break;
            }
            case 1: {
                yl = this.getLimit(1, igrpLower);
                this.project(0.0, yl, 0.0, temp);
                yl = temp[1];
                yr = this.getLimit(1, igrpUpper);
                this.project(0.0, yr, 0.0, temp);
                yr = temp[1];
            }
        }
        if (fixed) {
            if (iBand == 0 || iBand == 1) {
                this.project(0.0, limit.value, 0.0, temp);
                polygon = new GeneralPath(0, 5);
                polygon.moveTo(xRight, yFrame);
                polygon.lineTo(xRight, (float)temp[1]);
                polygon.lineTo(xLeft, (float)temp[1]);
                polygon.lineTo(xLeft, yFrame);
                polygon.closePath();
                Area poly = new Area(polygon);
                area.add(poly);
                if (this.debugFill) {
                    System.out.println("Mask 0: " + xRight + ", " + yFrame);
                    System.out.println("Mask 1: " + xRight + ", " + (int)temp[1]);
                    System.out.println("Mask 2: " + xLeft + ", " + (int)temp[1]);
                    System.out.println("Mask 3: " + xLeft + ", " + yFrame);
                    if (this.debugFill) {
                        StatGraph.printNote((String)"The PINK area defines the CLIPPING area above the UCL", (boolean)false);
                        StatGraph.printNote((String)"The upper outfill areas are the RED areas that intersect with the PINK areas", (boolean)false);
                        StatGraph.printNote((String)" ", (boolean)false);
                        StatGraph.printNote((String)"The GRAY area defines the CLIPPING area below the LCL", (boolean)false);
                        StatGraph.printNote((String)"The lower outfill areas are the GREEN areas that intersect with the GRAY areas", (boolean)false);
                        StatGraph.printNote((String)" ", (boolean)false);
                    }
                    g.setColor(iBand == 0 ? Color.PINK : Color.GRAY);
                    g.setClip(null);
                    g.fill(poly);
                }
            } else {
                area = null;
            }
            return area;
        }
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean phaseLegend = QCShewhart.getPhaseLegend();
        nPhases = 1;
        indices = null;
        refList = null;
        phaseLimits = false;
        if (o != null) {
            nPhases = o.getPhaseIndicesN();
            indices = o.getPhaseIndices();
            refList = o.getPhaseBoundaries();
            phaseLimits = o.usePhaseLimits();
        }
        if (nPhases == 0) {
            nPhases = 1;
            indices = null;
            refList = null;
            phaseLimits = false;
        }
        boolean useExtendedRange = QCShewhart.useExtendedRange();
        int iLast = -1;
        double lastX = 0.0;
        double lastY = 0.0;
        for (int iPhase = 0; iPhase < nPhases; ++iPhase) {
            int i;
            Area poly;
            double y;
            double x;
            int j;
            int dx;
            boolean phaseFixed = false;
            if (phaseLimits) {
                QCBlockOverlay.BlockEntry entry = indices.get(iPhase);
                if (!entry.limits) continue;
                if (iBand == 0) {
                    phaseFixed = limit.phaseFixed[iPhase];
                    nUpper = limit.phaseDataN[iPhase];
                    pLine = limit.phaseData[iPhase];
                    nLower = 2;
                } else if (iBand == 1) {
                    phaseFixed = limit.phaseFixed[iPhase];
                    nLower = limit.phaseDataN[iPhase];
                    pLine = limit.phaseData[iPhase];
                    nUpper = 2;
                } else {
                    pLine = null;
                }
            } else {
                nUpper = iBand == 0 ? limit.dataN : 2;
                nLower = iBand == 1 ? limit.dataN : 2;
                pLine = limit.data;
            }
            if (pLine == null) continue;
            if (phaseFixed) {
                float rightEdge;
                float leftEdge;
                polygon = new GeneralPath(0, 5);
                dx = blockOffset;
                if (iPhase == 0) {
                    leftEdge = xLeft;
                } else {
                    j = refList[iPhase];
                    x = this.getSubgrp(j);
                    this.project(x, 0.0, 0.0, temp);
                    leftEdge = (float)(temp[0] - (double)dx);
                }
                if (iPhase == nPhases - 1) {
                    rightEdge = xRight;
                } else {
                    j = refList[iPhase + 1];
                    x = this.getSubgrp(j);
                    this.project(x, 0.0, 0.0, temp);
                    rightEdge = (float)(temp[0] - (double)dx);
                    try {
                        float test = (float)this.pointX.getValue(j);
                        rightEdge = (test -= (float)dx) + (float)xLeft;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                y = limit.phaseValue[iPhase];
                this.project(0.0, y, 0.0, temp);
                polygon.moveTo(leftEdge, yFrame);
                polygon.moveTo(rightEdge, yFrame);
                polygon.lineTo(rightEdge, (float)temp[1]);
                polygon.lineTo(leftEdge, (float)temp[1]);
                polygon.lineTo(leftEdge, yFrame);
                polygon.closePath();
                poly = new Area(polygon);
                area.add(poly);
                if (!this.debugFill) continue;
                System.out.println("Mask 0: " + (int)rightEdge + ", " + yFrame);
                System.out.println("Mask 1: " + (int)rightEdge + ", " + (int)temp[1]);
                System.out.println("Mask 2: " + (int)leftEdge + ", " + (int)temp[1]);
                System.out.println("Mask 3: " + (int)leftEdge + ", " + yFrame);
                if (this.debugFill) {
                    StatGraph.printNote((String)"The PINK area defines the CLIPPING area above the UCL", (boolean)false);
                    StatGraph.printNote((String)"The upper outfill areas are the RED areas that intersect with the PINK areas", (boolean)false);
                    StatGraph.printNote((String)" ", (boolean)false);
                    StatGraph.printNote((String)"The GRAY area defines the CLIPPING area below the LCL", (boolean)false);
                    StatGraph.printNote((String)"The lower outfill areas are the GREEN areas that intersect with the GRAY areas", (boolean)false);
                    StatGraph.printNote((String)" ", (boolean)false);
                }
                g.setColor(iBand == 0 ? Color.PINK : Color.GRAY);
                g.setClip(null);
                g.fill(poly);
                continue;
            }
            boolean valid = false;
            int nPlot = iBand == 0 ? nUpper : nLower;
            polygon = new GeneralPath(0, nUpper + nLower + 4);
            if (this.debugFill && nPhases > 1) {
                System.out.println("getShewhartMaskingArea" + (iBand == 0 ? " Upper" : " Lower"));
                System.out.println("Phase: " + iPhase);
            }
            int jj = 0;
            iLast = -1;
            lastX = 0.0;
            lastY = 0.0;
            x = 0.0;
            for (i = 0; i < nPlot; ++i) {
                x = pLine[i][0];
                y = pLine[i][1];
                if (Double.isNaN(y)) continue;
                this.project(x, y, 0.0, temp);
                if (temp[0] < (double)xLeft || temp[0] > (double)xRight) continue;
                valid = true;
                if (iPhase == 0) {
                    if (x > xl) {
                        polygon.moveTo(xLeft, yFrame);
                        polygon.lineTo((double)xLeft, yl);
                        polygon.lineTo(temp[0], temp[1]);
                    } else {
                        polygon.moveTo(xLeft, yFrame);
                        polygon.lineTo((double)xLeft, temp[1]);
                    }
                    lastX = this.innerAxisBounds.x;
                    lastY = temp[1];
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + xLeft + ", " + yFrame);
                    }
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + xLeft + ", " + (int)temp[1]);
                    }
                    if (this.debugFill) {
                        BasicStroke basic = new BasicStroke(1.0f);
                        g.setColor(iPhase % 2 == 0 ? Color.RED : Color.GREEN);
                        g.setStroke(basic);
                        g.drawLine((int)temp[0], yTop, (int)temp[0], yBottom);
                    }
                } else {
                    dx = i == 0 ? blockOffset : offset;
                    polygon.moveTo((float)temp[0] - (float)dx, yFrame);
                    polygon.lineTo((float)temp[0] - (float)dx, (float)temp[1]);
                    lastX = temp[0] - (double)dx;
                    lastY = temp[1];
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + (int)(temp[0] - (double)dx) + ", " + yFrame);
                    }
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + (int)(temp[0] - (double)dx) + ", " + (int)temp[1]);
                    }
                    if (this.debugFill) {
                        BasicStroke basic = new BasicStroke(1.0f);
                        g.setColor(iPhase % 2 == 0 ? Color.RED : Color.GREEN);
                        g.setStroke(basic);
                        g.drawLine((int)temp[0], yTop, (int)temp[0], yBottom);
                    }
                }
                iLast = i;
                break;
            }
            if (!valid || iLast == -1) continue;
            ++i;
            while (i < nPlot) {
                x = pLine[i][0];
                y = pLine[i][1];
                if (!Double.isNaN(y)) {
                    this.project(x, y, 0.0, temp);
                    if (!(temp[0] < (double)xLeft) && !(temp[0] > (double)xRight)) {
                        dx = i == 0 ? blockOffset : offset;
                        polygon.lineTo((float)temp[0] - (float)dx, (float)temp[1]);
                        iLast = i;
                        lastX = temp[0] - (double)dx;
                        lastY = temp[1];
                        if (this.debugFill) {
                            System.out.println(jj++ + ": " + (int)(temp[0] - (double)dx) + ", " + (int)temp[1]);
                        }
                        if (this.debugFill) {
                            BasicStroke basic = new BasicStroke(1.0f);
                            g.setColor(iPhase % 2 == 0 ? Color.RED : Color.GREEN);
                            g.setStroke(basic);
                            g.drawLine((int)temp[0], yTop, (int)temp[0], yBottom);
                        }
                    }
                }
                ++i;
            }
            if (iPhase == nPhases - 1) {
                if (x < xr) {
                    polygon.lineTo((double)xRight, yr);
                }
                polygon.lineTo((double)xRight, temp[1]);
                polygon.lineTo(xRight, yFrame);
                if (this.debugFill) {
                    System.out.println(jj++ + ": " + xRight + ", " + (int)temp[1]);
                }
                if (this.debugFill) {
                    System.out.println(jj++ + ": " + xRight + ", " + yFrame);
                }
            } else if (phaseLimits) {
                if (phaseBreak) {
                    dx = i == 0 ? blockOffset : offset;
                    polygon.lineTo((float)temp[0] - (float)dx, yFrame);
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + (int)(temp[0] - (double)dx) + ", " + yFrame);
                    }
                    if (this.debugFill) {
                        BasicStroke basic = new BasicStroke(1.0f);
                        g.setColor(iPhase % 2 == 0 ? Color.RED : Color.GREEN);
                        g.setStroke(basic);
                        g.drawLine((int)temp[0], yTop, (int)temp[0], yBottom);
                    }
                } else {
                    j = refList[iPhase + 1];
                    x = this.getSubgrp(j);
                    y = pLine[iLast][1];
                    this.project(x, y, 0.0, temp);
                    if (temp[0] < (double)xLeft || temp[0] > (double)xRight) continue;
                    dx = blockOffset;
                    polygon.lineTo((float)temp[0] - (float)dx, (float)temp[1]);
                    polygon.lineTo((float)temp[0] - (float)dx, yFrame);
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + (int)(temp[0] - (double)dx) + ", " + (int)temp[1]);
                    }
                    if (this.debugFill) {
                        System.out.println(jj++ + ": " + (int)(temp[0] - (double)dx) + ", " + yFrame);
                    }
                    if (this.debugFill) {
                        BasicStroke basic = new BasicStroke(1.0f);
                        g.setColor(iPhase % 2 == 0 ? Color.RED : Color.GREEN);
                        g.setStroke(basic);
                        g.drawLine((int)temp[0], yTop, (int)temp[0], yBottom);
                    }
                }
            }
            if (this.debugFill) {
                System.out.println("\n");
            }
            polygon.closePath();
            poly = new Area(polygon);
            area.add(poly);
        }
        return area;
    }

    private void getShewhartClippingAreas(int area) {
        System.out.println("\ngetShewhartClippingAreas still under development\n");
        QCLimit ucl = this.limits[0];
        QCLimit lcl = this.limits[1];
        if (!ucl.lineOn || !lcl.lineOn) {
            return;
        }
        int nUpper = 0;
        int nLower = 0;
        double[][] pUpper = null;
        double[][] pLower = null;
        double[] tUpper = new double[3];
        double[] tLower = new double[3];
        Rectangle upper = new Rectangle();
        Rectangle lower = new Rectangle();
        Rectangle inner = new Rectangle();
        Graphics2D g = QCShewhart.getGraphics2D();
        Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.PINK, Color.MAGENTA, Color.ORANGE, Color.DARK_GRAY, Color.LIGHT_GRAY};
        int icol = -1;
        g.setStroke(new BasicStroke(1.0f));
        boolean useAxisOffsets = true;
        int xLeft = this.innerAxisBounds.x;
        int xRight = xLeft + this.innerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        int offset = 0;
        Vector<QCBlockOverlay.BlockEntry> indices = null;
        int[] refList = null;
        int nPhases = 1;
        boolean phaseLimits = false;
        boolean phaseBreak = false;
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean phaseLegend = QCShewhart.getPhaseLegend();
        if (phaseLegend) {
            indices = o.getPhaseIndices();
            refList = o.getPhaseBoundaries();
            nPhases = o.getPhaseIndicesN();
            phaseLimits = indices != null && refList != null;
        }
        boolean useExtendedRange = QCShewhart.useExtendedRange();
        block10: for (int iPhase = 0; iPhase < nPhases; ++iPhase) {
            int width;
            int dx;
            double yl;
            double xl;
            double yu;
            double xu;
            int i;
            if (phaseLimits) {
                QCBlockOverlay.BlockEntry entry = indices.get(iPhase);
                if (!entry.limits) continue;
                nUpper = ucl.phaseDataN[iPhase];
                pUpper = ucl.phaseData[iPhase];
                nLower = lcl.phaseDataN[iPhase];
                pLower = lcl.phaseData[iPhase];
            } else {
                nUpper = ucl.dataN;
                pUpper = ucl.data;
                nLower = lcl.dataN;
                pLower = lcl.data;
            }
            if (pUpper == null || pLower == null) continue;
            boolean valid = false;
            int nPlot = nUpper;
            int iLast = nPlot - 1;
            for (i = 0; i < nPlot; ++i) {
                xu = pUpper[i][0];
                yu = pUpper[i][1];
                xl = pLower[i][0];
                yl = pLower[i][1];
                if (Double.isNaN(yu) || this.project(xu, yu, 0.0, tUpper) || tUpper[0] < (double)xLeft || tUpper[0] > (double)xRight || Double.isNaN(yl) || this.project(xl, yl, 0.0, tLower) || tLower[0] < (double)xLeft || tLower[0] > (double)xRight) continue;
                valid = true;
                if (iPhase == 0) {
                    upper.x = xLeft;
                    lower.x = xLeft;
                    inner.x = xLeft;
                } else {
                    dx = i == 0 ? glyphOffset + blockOffset : offset;
                    upper.x = (int)(tUpper[0] - (double)dx);
                    lower.x = (int)(tUpper[0] - (double)dx);
                    inner.x = (int)(tUpper[0] - (double)dx);
                }
                ++i;
                break;
            }
            if (!valid) continue;
            int j = area;
            int xPrev = -1;
            while (i < nPlot) {
                xu = pUpper[i][0];
                yu = pUpper[i][1];
                xl = pLower[i][0];
                yl = pLower[i][1];
                if (!(Double.isNaN(yu) || this.project(xu, yu, 0.0, tUpper) || tUpper[0] < (double)xLeft || tUpper[0] > (double)xRight || Double.isNaN(yl) || this.project(xl, yl, 0.0, tLower) || tLower[0] < (double)xLeft || tLower[0] > (double)xRight || (width = (int)tUpper[0] - (dx = i == 0 ? blockOffset : offset)) == upper.x)) {
                    upper.y = yTop;
                    upper.height = (int)tUpper[1];
                    upper.width = width -= upper.x;
                    lower.y = (int)tLower[1];
                    lower.height = yBottom - lower.y;
                    lower.width = width;
                    inner.y = upper.y + upper.height;
                    inner.height = lower.y - (upper.y + upper.height);
                    inner.width = width;
                    icol = j++ % colors.length;
                    g.setColor(colors[icol]);
                    switch (area) {
                        case 1: {
                            g.fillRect(upper.x, upper.y, upper.width, upper.height);
                            break;
                        }
                        case 2: {
                            g.fillRect(lower.x, lower.y, lower.width, lower.height);
                            break;
                        }
                        case 3: {
                            g.fillRect(inner.x, inner.y, inner.width, inner.height);
                        }
                    }
                    upper.x = xPrev = (int)tUpper[0] - dx;
                    lower.x = xPrev;
                    inner.x = xPrev;
                }
                ++i;
            }
            if (iPhase == nPhases - 1) {
                width = xRight - upper.x;
                upper.y = yTop;
                upper.height = (int)tUpper[1];
                upper.width = width;
                lower.y = (int)tLower[1];
                lower.height = yBottom - lower.y;
                lower.width = width;
                inner.y = upper.y + upper.height;
                inner.height = lower.y - (upper.y + upper.height);
                inner.width = width;
            } else if (phaseLimits) {
                if (phaseBreak) {
                    dx = i == 0 ? blockOffset : offset;
                    width = (int)tUpper[0] - dx;
                    upper.y = yTop;
                    upper.height = (int)tUpper[1];
                    upper.width = width -= upper.x;
                    lower.y = (int)tLower[1];
                    lower.height = yBottom - lower.y;
                    lower.width = width;
                    inner.y = upper.y + upper.height;
                    inner.height = lower.y - (upper.y + upper.height);
                    inner.width = width;
                } else {
                    j = refList[iPhase + 1];
                    xu = this.getSubgrp(j);
                    yu = pUpper[iLast][1];
                    xl = this.getSubgrp(j);
                    yl = pLower[iLast][1];
                    if (Double.isNaN(yu) || this.project(xu, yu, 0.0, tUpper) || tUpper[0] < (double)xLeft || tUpper[0] > (double)xRight || Double.isNaN(yl) || this.project(xl, yl, 0.0, tLower) || tLower[0] < (double)xLeft || tLower[0] > (double)xRight) continue;
                    dx = glyphOffset + blockOffset;
                    width = (int)tUpper[0] - dx;
                    upper.y = yTop;
                    upper.height = (int)tUpper[1];
                    upper.width = width -= upper.x;
                    lower.y = (int)tLower[1];
                    lower.height = yBottom - lower.y;
                    lower.width = width;
                    inner.y = upper.y + upper.height;
                    inner.height = lower.y - (upper.y + upper.height);
                    inner.width = width;
                }
            }
            ++icol;
            g.setColor(colors[icol %= colors.length]);
            switch (area) {
                case 1: {
                    g.fillRect(upper.x, upper.y, upper.width, upper.height);
                    continue block10;
                }
                case 2: {
                    g.fillRect(lower.x, lower.y, lower.width, lower.height);
                    continue block10;
                }
                case 3: {
                    g.fillRect(inner.x, inner.y, inner.width, inner.height);
                }
            }
        }
    }

    public GeneralPath[] getPolygonAreas(QCOverlay response, int iBand, boolean fill) {
        int yFrame;
        int nObs;
        double[] temp = new double[3];
        GeneralPath[] areas = null;
        GeneralPath polygon = null;
        boolean clipExtremes = false;
        double clipFactor = 1.2;
        CRD sm = response.getModel();
        int nPts = nObs = sm.getRowCount();
        nPts = QCShewhart.getNPts();
        double[] y = response.getDoubleColumn(792);
        if (y == null) {
            y = response.getDoubleColumn(11);
        }
        boolean useAxisOffsets = true;
        int xLeft = this.innerAxisBounds.x;
        int xRight = xLeft + this.innerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        switch (iBand) {
            case 0: {
                yFrame = yBottom;
                break;
            }
            case 1: {
                yFrame = yTop;
                break;
            }
            default: {
                return null;
            }
        }
        QCBlockOverlay o = this.chart.getRefOverlay();
        boolean phaseLimits = o != null && o.usePhaseLimits();
        boolean phaseBreak = response.getPhaseBreak();
        if (phaseLimits) {
            Vector<QCBlockOverlay.BlockEntry> indices = o.getPhaseIndices();
            int nPhase = o.getPhaseIndicesN();
            areas = new GeneralPath[nPhase];
            for (int iPhase = 0; iPhase < nPhase; ++iPhase) {
                double d;
                int i;
                QCBlockOverlay.BlockEntry entry = indices.get(iPhase);
                if (entry.last <= 0) continue;
                int first = Math.max(entry.first, 0);
                int last = entry.last - 1;
                last = phaseBreak ? last : (QCShewhart.isConnectedAcrossPages() ? 1 + last + 1 : last);
                last = Math.min(last, nPts - 1);
                boolean valid = false;
                int n = last - first + 1;
                polygon = new GeneralPath(0, n + 2);
                for (i = first; i <= last; ++i) {
                    double d2 = d = clipExtremes ? QCLimitsOverlay.clipResponse(i) : y[i];
                    if (Double.isNaN(d)) continue;
                    this.project(this.getSubgrp(i), d, 0.0, temp);
                    if (fill) {
                        polygon.moveTo((float)temp[0], yFrame);
                        polygon.lineTo((float)temp[0], (float)temp[1]);
                        break;
                    }
                    polygon.moveTo((float)temp[0], (float)temp[1]);
                    break;
                }
                ++i;
                while (i <= last) {
                    double d3 = d = clipExtremes ? QCLimitsOverlay.clipResponse(i) : y[i];
                    if (!Double.isNaN(d)) {
                        this.project(this.getSubgrp(i), d, 0.0, temp);
                        polygon.lineTo((float)temp[0], (float)temp[1]);
                        valid = true;
                    }
                    ++i;
                }
                if (!valid) continue;
                if (fill) {
                    polygon.lineTo((float)temp[0], yFrame);
                    polygon.closePath();
                }
                areas[iPhase] = polygon;
            }
        } else {
            double d;
            int i;
            int first = 0;
            int last = nPts - 1;
            boolean valid = false;
            areas = new GeneralPath[1];
            polygon = new GeneralPath(0, nPts + 2);
            for (i = first; i <= last; ++i) {
                double d4 = d = clipExtremes ? QCLimitsOverlay.clipResponse(i) : y[i];
                if (Double.isNaN(d)) continue;
                boolean oocPrev = true;
                boolean ooc = true;
                boolean oocNext = true;
                if (!oocPrev && !ooc && !oocNext) break;
                valid = true;
                this.project(this.getSubgrp(i), d, 0.0, temp);
                if (fill) {
                    polygon.moveTo((float)temp[0], yFrame);
                    polygon.lineTo((float)temp[0], (float)temp[1]);
                    break;
                }
                polygon.moveTo((float)temp[0], (float)temp[1]);
                break;
            }
            if (valid) {
                ++i;
                while (i <= last) {
                    double d5 = d = clipExtremes ? QCLimitsOverlay.clipResponse(i) : y[i];
                    if (!Double.isNaN(d)) {
                        this.project(this.getSubgrp(i), d, 0.0, temp);
                        polygon.lineTo((float)temp[0], (float)temp[1]);
                        valid = true;
                    }
                    ++i;
                }
                if (valid) {
                    if (fill) {
                        polygon.lineTo((float)temp[0], yFrame);
                        polygon.closePath();
                    }
                    if (this.debugFill) {
                        PathIterator pi = polygon.getPathIterator(null);
                        float[] seg = new float[6];
                        int segType = 0;
                        int iseg = 0;
                        while (!pi.isDone()) {
                            segType = pi.currentSegment(seg);
                            switch (segType) {
                                case 0: 
                                case 1: {
                                    System.out.println("Polygon " + iseg + ": " + (int)seg[0] + ", " + (int)seg[1]);
                                    ++iseg;
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                default: {
                                    throw new Error();
                                }
                            }
                            pi.next();
                        }
                    }
                    areas[0] = polygon;
                }
            }
        }
        QCShewhart.applySubsetList();
        return areas;
    }

    public double getYScale() {
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        return 0.0;
    }

    @Override
    public boolean project(double x, double y, double z, double[] r) {
        double xValue;
        ContinuousRangeToNumericMapper xMap;
        if (this.xvalueMapper instanceof ContinuousRangeToNumericMapper) {
            xMap = (ContinuousRangeToNumericMapper)this.xvalueMapper;
            xValue = xMap.getValue(x);
        } else if (this.xvalueMapper instanceof StringToNumericMapper) {
            xMap = (StringToNumericMapper)this.xvalueMapper;
            try {
                int i = (int)x;
                if (x == (double)i) {
                    xValue = xMap.getValue(i);
                }
                double dataMin = QCShewhart.getLowerSubgrpIndex(this.model);
                double dataMax = QCShewhart.getUpperSubgrpIndex(this.model);
                double dataRange = dataMax - dataMin;
                double xMin = this.innerAxisBounds.getX();
                double axisWidth = this.innerAxisBounds.getWidth();
                xValue = dataRange == 0.0 ? xMin : (x - dataMin) / dataRange * axisWidth;
            }
            catch (MissingValueException mve) {
                return false;
            }
        } else {
            r[0] = Double.NaN;
            r[1] = Double.NaN;
            r[2] = Double.NaN;
            return false;
        }
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        double yValue = yMap.getValue(y);
        double xorigin = this.innerAxisBounds.getX();
        double yorigin = this.outerAxisBounds.getY();
        double yAxisUpper = this.yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yValue;
        r[2] = 0.0;
        return true;
    }

    @Override
    public boolean uproject(double x, double y, double z, double[] r) {
        double xValue;
        ContinuousRangeToNumericMapper xMap;
        if (this.xvalueMapper instanceof ContinuousRangeToNumericMapper) {
            xMap = (ContinuousRangeToNumericMapper)this.xvalueMapper;
            xValue = xMap.getValue(x);
        } else if (this.xvalueMapper instanceof StringToNumericMapper) {
            xMap = (StringToNumericMapper)this.xvalueMapper;
            try {
                int i = (int)x;
                if (x != (double)i) {
                    System.out.println("QCLimitsOverlay/uproject():  int to double error.");
                }
                xValue = xMap.getValue(i);
            }
            catch (MissingValueException mve) {
                return false;
            }
        } else {
            r[0] = Double.NaN;
            r[1] = Double.NaN;
            r[2] = Double.NaN;
            return false;
        }
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        double xorigin = 0.0;
        double yorigin = 0.0;
        double yAxisUpper = this.yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yMap.getValue(y);
        r[2] = 0.0;
        return true;
    }

    private double getSubgrp(double igrp) {
        return this.getSubgrp((int)igrp);
    }

    private double getSubgrp(long igrp) {
        return this.getSubgrp((int)igrp);
    }

    private double getSubgrp(int igrp) {
        int n = this.model.getRowCount();
        if (igrp < 0 || igrp >= n) {
            return Double.NaN;
        }
        double subgrp = this.model.isAvailable(10) ? (this.numericX ? this.model.getDoubleColumn(10)[igrp] : (double)igrp) : (double)igrp;
        return subgrp;
    }

    public static double clipResponse(double y) {
        double d = y;
        return d;
    }

    private void initLimits() {
        QCBlockOverlay o = this.chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        boolean phaseLimits = this.limits != null && o != null && o.usePhaseLimits();
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                this.vmask.computeDataMask(this.xvalueMapper);
                break;
            }
            default: {
                if (phaseLimits) {
                    this.initPhaseBand(0, o);
                    this.initPhaseBand(1, o);
                    this.initPhaseBand(2, o);
                    break;
                }
                this.initBand(0);
                this.initBand(1);
                this.initBand(2);
            }
        }
    }

    private void initPhaseBand(int iBand, QCBlockOverlay phase) {
        QCBlockOverlay o = this.chart.getRefOverlay();
        QCLimit limit = this.limits[iBand];
        Vector<QCBlockOverlay.BlockEntry> indices = phase.getPhaseIndices();
        int nIndices = phase.getPhaseIndicesN();
        limit.phaseData = new double[nIndices][][];
        limit.phaseDataN = new int[nIndices];
        limit.phaseFixed = new boolean[nIndices];
        limit.phaseValue = new double[nIndices];
        boolean consolidate = true;
        boolean fixedPhaseLimit = false;
        String[] phaseUCL = o.getStringColumn(771);
        String[] phaseCTL = o.getStringColumn(772);
        String[] phaseLCL = o.getStringColumn(773);
        for (int iIndex = 0; iIndex < nIndices; ++iIndex) {
            QCBlockOverlay.BlockEntry entry = indices.get(iIndex);
            if (entry.limits) {
                int first = entry.first;
                int last = entry.last - 1;
                int nData = this.initBand(iBand, first, last, consolidate);
                boolean bl = fixedPhaseLimit = !Double.isNaN(limit.phaseTest);
                if (fixedPhaseLimit) {
                    limit.phaseFixed[iIndex] = true;
                    limit.phaseValue[iIndex] = limit.phaseTest;
                } else {
                    limit.phaseFixed[iIndex] = false;
                    limit.phaseValue[iIndex] = Double.NaN;
                }
                limit.phaseData[iIndex] = new double[nData][2];
                limit.phaseDataN[iIndex] = nData;
                for (int i = 0; i < nData; ++i) {
                    double x = limit.data[i][0];
                    double y = limit.data[i][1];
                    limit.phaseData[iIndex][i][0] = x;
                    limit.phaseData[iIndex][i][1] = y;
                }
                limit.data = null;
                limit.dataN = 0;
                continue;
            }
            limit.phaseData[iIndex] = null;
            limit.phaseDataN[iIndex] = 0;
        }
    }

    private int initBand(int iBand) {
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        boolean consolidate = false;
        int n = this.initBand(iBand, igrpLower, igrpUpper, consolidate);
        return n;
    }

    public void initLastNonMissingIndex() {
        int i = this.getLastNonMissingIndex(0);
        i = this.getLastNonMissingIndex(1);
        i = this.getLastNonMissingIndex(2);
    }

    private int getLastNonMissingIndex(int iBand) {
        QCLimit limit = this.limits[iBand];
        if (!limit.display || !limit.lineOn && !this.fillOn) {
            limit.labelOn = false;
            return -1;
        }
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        int lastNonMissingIndex = -1;
        double lastNonMissingValue = Double.NaN;
        if (limit.fixed) {
            lastNonMissingIndex = igrpUpper;
            lastNonMissingValue = limit.value;
        } else {
            double[] values = this.model.getDoubleColumn((int)limit.role);
            if (igrpLower == igrpUpper) {
                lastNonMissingIndex = igrpUpper;
                lastNonMissingValue = values[igrpUpper];
            } else {
                for (int i = igrpUpper; i >= igrpLower; --i) {
                    double x = this.getSubgrp(i);
                    double y = values[i];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    lastNonMissingIndex = i;
                    lastNonMissingValue = y;
                    break;
                }
            }
        }
        limit.lastNonMissingIndex = lastNonMissingIndex;
        limit.lastNonMissingValue = lastNonMissingValue;
        if (lastNonMissingIndex == -1) {
            limit.labelOn = false;
        }
        return lastNonMissingIndex;
    }

    private int initBand(int iBand, int first, int last, boolean consolidate) {
        int j;
        boolean step;
        QCLimit limit = this.limits[iBand];
        boolean fixed = limit.fixed;
        limit.model = this.model;
        limit.data = null;
        limit.dataN = 0;
        limit.values = fixed ? null : this.model.getDoubleColumn((int)limit.role);
        limit.phaseTest = Double.NaN;
        if (!limit.display || !limit.lineOn && !this.fillOn) {
            return 0;
        }
        int nObs = this.model.getRowCount();
        if (first == -1) {
            first = 0;
        } else {
            first = Math.min(nObs - 1, first);
            first = Math.max(0, first);
        }
        if (last == -1) {
            last = nObs - 1;
        } else {
            last = Math.min(nObs - 1, last);
            last = Math.max(0, last);
        }
        int nSubgrp = last - first + 1;
        int nPts = fixed ? 2 : 2 * nSubgrp;
        boolean bl = step = !fixed;
        if (nPts == 0) {
            return 0;
        }
        double[][] pLine = new double[nPts][2];
        if (pLine == null) {
            return 0;
        }
        if (fixed) {
            limit.phaseTest = limit.value;
            j = 0;
            pLine[j][0] = this.getSubgrp(first);
            pLine[j][1] = limit.value;
            pLine[++j][0] = this.getSubgrp(last);
            pLine[j][1] = limit.value;
            ++j;
        } else {
            double[] d = this.model.getDoubleColumn((int)limit.role);
            if (nSubgrp == 1) {
                limit.phaseTest = limit.value;
                j = 0;
                pLine[j][0] = this.getSubgrp(first);
                pLine[j][1] = d[first];
                pLine[++j][0] = this.getSubgrp(last);
                pLine[j][1] = d[last];
                ++j;
            } else {
                QCLimitStepType stepType = QCLimitStepType.ALIGN_CENTER;
                double[] prev = new double[2];
                int i = first;
                double x = this.getSubgrp(i);
                double y = d[i];
                if (Double.isNaN(y)) {
                    this.phaseBreak = true;
                }
                j = 0;
                pLine[j][0] = x;
                pLine[j][1] = y;
                limit.phaseTest = y;
                ++i;
                ++j;
                while (i <= last) {
                    prev[0] = x;
                    prev[1] = y;
                    x = this.getSubgrp(i);
                    y = d[i];
                    if (Double.isNaN(y)) {
                        this.phaseBreak = true;
                    }
                    if (step) {
                        if (consolidate && y == prev[1]) {
                            pLine[j][0] = x;
                            pLine[j][1] = y;
                            ++j;
                        } else {
                            limit.phaseTest = Double.NaN;
                            switch (stepType) {
                                case ALIGN_CENTER: {
                                    double half;
                                    pLine[j][0] = half = (prev[0] + x) / 2.0;
                                    pLine[j][1] = prev[1];
                                    pLine[++j][0] = half;
                                    pLine[j][1] = y;
                                    ++j;
                                    break;
                                }
                                case ALIGN_RIGHT: {
                                    pLine[j][0] = x;
                                    pLine[j][1] = prev[1];
                                    pLine[++j][0] = x;
                                    pLine[j][1] = y;
                                    ++j;
                                    break;
                                }
                                case ALIGN_LEFT: {
                                    pLine[j][0] = prev[0];
                                    pLine[j][1] = prev[1];
                                    pLine[++j][0] = prev[0];
                                    pLine[j][1] = y;
                                    ++j;
                                }
                            }
                            if (i == last) {
                                pLine[j][0] = x;
                                pLine[j][1] = y;
                                ++j;
                            }
                        }
                    } else {
                        pLine[j][0] = x;
                        pLine[j][1] = y;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        limit.data = pLine;
        limit.dataN = j;
        return j;
    }

    private boolean isOOC(double y, int iBand, int igrp) {
        boolean ooc = false;
        switch (iBand) {
            case 0: {
                QCLimit ucl = this.limits[0];
                double u = ucl.getValue(igrp);
                if (Double.isNaN(u) || !(y > u)) break;
                ooc = true;
                break;
            }
            case 1: {
                QCLimit lcl = this.limits[1];
                double l = lcl.getValue(igrp);
                if (Double.isNaN(l) || !(y < l)) break;
                ooc = true;
                break;
            }
        }
        return ooc;
    }

    public boolean isOutOfControl(QCOverlay response) {
        boolean ooc = false;
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                ooc = this.isVMaskOutOfControl(response);
                break;
            }
            default: {
                ooc = this.isShewhartOutOfControl(response);
            }
        }
        return ooc;
    }

    private boolean isShewhartOutOfControl(QCOverlay response) {
        CRD rm = response.getModel();
        int nObs = rm.getRowCount();
        int nPts = QCShewhart.getNPts();
        String rmName = rm.getSrcModel().name;
        int rmNObs = rm.getSrcModel().getRowCount();
        String lmName = this.model.getSrcModel().name;
        int lmNObs = this.model.getSrcModel().getRowCount();
        QCLimit lcl = this.limits[1];
        QCLimit ucl = this.limits[0];
        if (!rmName.equalsIgnoreCase(lmName) || rmNObs != lmNObs) {
            boolean varying;
            boolean bl = varying = !lcl.fixed() || !ucl.fixed();
            if (varying) {
                return true;
            }
        }
        boolean ooc = false;
        double[] valuesOOC = null;
        double[] dArray = valuesOOC = rm.isAvailable(796) ? rm.getDoubleColumn(796) : null;
        if (valuesOOC == null) {
            return false;
        }
        double[] x = response.getDoubleColumn(10);
        double[] y = response.getDoubleColumn(11);
        int first = 0;
        int last = nObs;
        for (int i = first; i < last; ++i) {
            double d = y[i];
            if (Double.isNaN(d)) continue;
            if (valuesOOC == null) {
                double l = lcl.getValue(i);
                if (!Double.isNaN(l) && d < l) {
                    ooc = true;
                    break;
                }
                double u = ucl.getValue(i);
                if (Double.isNaN(u) || !(d > u)) continue;
                ooc = true;
                break;
            }
            if (valuesOOC[i] == 0.0) continue;
            ooc = true;
            break;
        }
        QCShewhart.resetNPts();
        return ooc;
    }

    private boolean isVMaskOutOfControl(QCOverlay response) {
        CRD rm = response.getModel();
        int nObs = rm.getRowCount();
        int nPts = QCShewhart.getNPts();
        boolean ooc = false;
        double[] valuesOOC = null;
        double[] dArray = valuesOOC = rm.isAvailable(796) ? rm.getDoubleColumn(796) : null;
        if (valuesOOC != null || !(response instanceof QCBoxParmOverlay)) {
            // empty if block
        }
        double[] x = response.getDoubleColumn(10);
        double[] y = response.getDoubleColumn(11);
        int first = 0;
        int last = nObs;
        for (int i = first; i < last; ++i) {
            double d = y[i];
            if (Double.isNaN(d)) continue;
            if (valuesOOC == null) {
                double l = this.vmask.getLCL(x[i]);
                if (!Double.isNaN(l) && d < l) {
                    ooc = true;
                    break;
                }
                double u = this.vmask.getUCL(x[i]);
                if (Double.isNaN(u) || !(d > u)) continue;
                ooc = true;
                break;
            }
            if (valuesOOC[i] == 0.0) continue;
            ooc = true;
            break;
        }
        QCShewhart.resetNPts();
        return ooc;
    }

    public void setSchemeType(QCLimitScheme type) {
        this.schemeType = type;
    }

    public void setSchemeType(String scheme) {
        this.schemeType = QCLimitScheme.fromString(scheme);
    }

    public QCLimitScheme getSchemeType() {
        return this.schemeType;
    }

    public QCVMask getVMask() {
        return this.vmask;
    }

    public void setVMask(QCVMask vm, QCLimitScheme type) {
        this.vmask = vm;
        this.vmask.schemeType = type;
        this.schemeType = type;
    }

    @Override
    public QCOverlay.QCClipType getClipType() {
        QCOverlay.QCClipType rc;
        switch (this.schemeType) {
            case SCHEME_TWOSIDED: {
                rc = QCOverlay.QCClipType.VMASK;
                break;
            }
            default: {
                rc = QCOverlay.QCClipType.OUTER;
            }
        }
        return rc;
    }

    @Override
    public void setDrawingArea(Rectangle inner, Rectangle inner2, Rectangle outer) {
        super.setDrawingArea(inner, inner2, outer);
        if (this.vmask != null) {
            int x = this.outerAxisBounds.x;
            int width = this.outerAxisBounds.width;
            int y = this.outerAxisBounds.y + this.innerAxisBounds.y;
            int height = this.innerAxisBounds.height;
            Rectangle r = new Rectangle(x, y, width, height);
            this.vmask.setDrawingArea(r);
        }
    }

    public TextStyle getPhaseLimitStyle() {
        return this.phaseLimitStyle;
    }

    public void setPhaseLimitStyle(TextStyle ts) {
        this.phaseLimitStyle = ts;
    }

    public TextStyle getZoneLabelStyle() {
        return this.zoneLabelStyle;
    }

    public void setZoneLabelStyle(TextStyle ts) {
        this.zoneLabelStyle = ts;
    }

    public Color getInfillColor() {
        Color infill = this.applyDataTransparency((ColorAttr)this.fillStyle);
        return infill;
    }

    public void createInfillColorPipe() {
        if (this.colorEncoder == null) {
            return;
        }
        double[] fillIndex = this.model.getDoubleColumn(770);
        if (fillIndex == null) {
            return;
        }
        Color defaultColor = this.fillStyle.getColor();
        Color backgroundColor = this.backgroundStyle.getColor();
        Color[] cl = this.colorEncoder.colorArray;
        int ncolor = cl.length;
        if (this.infillColorPipe == null) {
            this.infillColorPipe = new ColorVector();
        }
        if (this.infillOnPipe == null) {
            this.infillOnPipe = new BooleanVector();
        }
        int nObs = this.model.getRowCount();
        block3: for (int i = 0; i < nObs; ++i) {
            int j = (int)fillIndex[i];
            switch (j) {
                case -99: 
                case -98: {
                    this.infillColorPipe.addValue(backgroundColor);
                    this.infillOnPipe.addValue(false);
                    continue block3;
                }
                default: {
                    j %= ncolor;
                    this.infillColorPipe.addValue(defaultColor);
                    this.infillOnPipe.addValue(true);
                }
            }
        }
    }

    private static enum QCLimitStepType {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT;

    }

    public static enum QCLimitScheme {
        SCHEME_SHEWHART,
        SCHEME_ONESIDED,
        SCHEME_TWOSIDED;


        public static QCLimitScheme fromString(String scheme) {
            return QCLimitScheme.fromString(scheme, SCHEME_SHEWHART);
        }

        public static QCLimitScheme fromString(String scheme, QCLimitScheme dflt) {
            QCLimitScheme rc = scheme.equalsIgnoreCase("One-Sided") ? SCHEME_ONESIDED : (scheme.equalsIgnoreCase("Two-Sided") ? SCHEME_TWOSIDED : SCHEME_SHEWHART);
            return rc;
        }

        public static String toString(QCLimitScheme type) {
            String rc = null;
            switch (type) {
                case SCHEME_ONESIDED: {
                    rc = "One-Sided";
                    break;
                }
                case SCHEME_TWOSIDED: {
                    rc = "Two-Sided";
                    break;
                }
                case SCHEME_SHEWHART: {
                    rc = "Shewhart";
                }
            }
            return rc;
        }
    }
}

