/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVaryLine;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class QCVaryLineConnector
extends LineConnector {
    public static final byte LINE = 0;
    public static final byte STEP_ = 1;
    public static final byte STEP_RIGHT = 2;
    public static final byte STEP_CENTER = 3;
    protected Color myColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;
    protected int phaseIndex = -1;
    protected Vector<QCBlockOverlay.BlockEntry> phaseEntries = null;
    protected BBox frame = null;
    protected BBox[] phaseFrames = null;
    protected int[] refList = null;
    protected int currentPhase;
    protected boolean outOfRangeMin = false;
    protected boolean outOfRangeMax = false;
    protected boolean extendXMin = false;
    protected double extremeXMin;
    protected boolean extendXMax = false;
    protected double extremeXMax;
    private double phasePointX;
    private double phasePointY;
    private double phasePointZ;
    private boolean lineBreak = false;
    public NumericProperty pointY = new NumericProperty((PropertyContainer)this, true);
    public final ColorProperty lineColor = new ColorProperty((PropertyContainer)this, true);
    public NumericProperty lineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty linePattern = new IntegerProperty((PropertyContainer)this, true);
    protected boolean SVGRender;
    public QCVaryLine.LabelPos labelPosition = QCVaryLine.LabelPos.INNER_LEFT;
    public boolean labelAbove = true;
    public RasterLabel label = null;
    public boolean lineOn = true;
    public boolean labelOn = false;

    public QCVaryLineConnector() {
        this.multipleGroup = true;
        this.SVGRender = false;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    public void init(AInitAction initAction) {
        super.init(initAction);
        this.endPointX = Double.NaN;
        this.endPointY = Double.NaN;
        this.phasePointX = Double.NaN;
        this.phasePointY = Double.NaN;
        this.phasePointZ = Double.NaN;
    }

    public void setFrame(BBox frame) {
        this.frame = frame;
    }

    public void setPhaseIndex(int index) {
        this.phaseIndex = index;
    }

    public void setPhaseEntries(Vector<QCBlockOverlay.BlockEntry> entries) {
        this.phaseEntries = entries;
    }

    public void setPhaseFrames(BBox[] frames) {
        this.phaseFrames = frames;
    }

    public void setPhaseRefList(int[] refs) {
        this.refList = refs;
    }

    public void setLineBreak(boolean b) {
        this.lineBreak = b;
    }

    private boolean applyPhaseBoundary(Vector aLine) {
        int nRef;
        this.currentPhase = -1;
        int n = nRef = this.refList == null ? 0 : this.refList.length;
        if (nRef < 1 || this.phaseFrames == null) {
            if (this.frame == null) {
                return false;
            }
            this.extremeXMin = this.frame.getULX();
            this.extremeXMax = this.frame.getLRX();
            return true;
        }
        int iPhase = -1;
        int iIndex = -1;
        int nPhase = this.phaseEntries.size();
        int nFrame = this.phaseFrames.length;
        int index = (Integer)aLine.elementAt(0);
        for (int i = 0; i < nPhase; ++i) {
            QCBlockOverlay.BlockEntry entry = this.phaseEntries.get(i);
            if (entry.first > index || index >= entry.last) continue;
            iPhase = i;
            iIndex = entry.level;
            break;
        }
        BBox[] phase = this.phaseFrames;
        if (iPhase == -1 || iPhase >= nPhase || phase[iPhase] == null) {
            this.extremeXMin = this.frame.getULX();
            this.extremeXMax = this.frame.getLRX();
            return false;
        }
        double ulx = phase[iPhase].getULX();
        double lrx = phase[iPhase].getLRX();
        this.extremeXMin = Math.max(ulx, this.frame.getULX());
        this.extremeXMax = Math.min(lrx, this.frame.getLRX());
        this.currentPhase = iIndex;
        return true;
    }

    private int stripMissing(Vector aLine, boolean min) {
        int intersectionCount = aLine.size();
        int rc = min ? 0 : intersectionCount;
        boolean ignore = false;
        if (ignore) {
            return rc;
        }
        double y = Double.NaN;
        for (int i = 0; i < intersectionCount; ++i) {
            int k = min ? i : intersectionCount - (i + 1);
            int index = (Integer)aLine.elementAt(k);
            try {
                y = this.pointY.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (Double.isNaN(y)) continue;
            rc = min ? k : k + 1;
            break;
        }
        return rc;
    }

    private void drawPolyline(ABuildAction buildAction, Vector aLine) {
        boolean debug;
        boolean drawLabel;
        double z;
        double y2;
        double y1;
        double x2;
        double x1;
        boolean drawLine;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        double rightBeginPtX = -1.0;
        double rightBeginPtY = -1.0;
        double rightEndPtX = -1.0;
        double rightEndPtY = -1.0;
        double rightPtZ = Double.NaN;
        int index = -1;
        int intersectionCount = aLine.size();
        int indexInit = this.stripMissing(aLine, true);
        int indexTerm = this.stripMissing(aLine, false);
        boolean validPoint = false;
        boolean extraPoint = false;
        boolean extend = true;
        this.beginPointX = Double.NaN;
        this.beginPointY = Double.NaN;
        this.beginPointZ = Double.NaN;
        this.endPointX = Double.NaN;
        this.endPointY = Double.NaN;
        this.endPointZ = Double.NaN;
        double yInnerLeft = Double.NaN;
        double yInnerRight = Double.NaN;
        boolean rightPt = true;
        this.outOfRangeMin = false;
        this.outOfRangeMax = false;
        boolean useLine = this.phaseIndex == -1 || this.phaseIndex == this.currentPhase;
        boolean bl = drawLine = this.lineOn && useLine;
        if (drawLine) {
            channel.glBegin(1);
        }
        if (indexInit > 0) {
            try {
                index = (Integer)aLine.elementAt(indexInit - 1);
                this.beginPointX = this.pointX.getValue(index);
                index = (Integer)aLine.elementAt(indexInit);
                this.endPointX = this.pointX.getValue(index);
                this.beginPointX = (this.beginPointX + this.endPointX) / 2.0;
                this.beginPointY = this.pointY.getValue(index);
                this.beginPointZ = this.pointZ.getValue(index);
                x1 = this.beginPointX;
                x2 = this.endPointX;
                y1 = this.beginPointY;
                y2 = this.beginPointY;
                z = this.beginPointZ;
                if (Double.isNaN(yInnerLeft)) {
                    yInnerLeft = this.beginPointY;
                }
                yInnerRight = this.beginPointY;
                if (drawLine) {
                    channel.glVertex(x1, y1, z);
                    channel.glVertex(x2, y2, z);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        boolean degenerate = true;
        for (int j = indexInit; (j < indexTerm || extraPoint) && !this.outOfRangeMax; ++j) {
            if (!extraPoint) {
                index = (Integer)aLine.elementAt(j);
            }
            degenerate = false;
            if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ)) {
                try {
                    this.beginPointX = this.pointX.getValue(index);
                    this.beginPointY = this.pointY.getValue(index);
                    this.beginPointZ = this.pointZ.getValue(index);
                    if (Double.isNaN(yInnerLeft)) {
                        yInnerLeft = this.beginPointY;
                    }
                    yInnerRight = this.beginPointY;
                }
                catch (MissingValueException mve) {
                    continue;
                }
                if (!extend || !(this.beginPointX > this.extremeXMin) || indexInit != 0) continue;
                extraPoint = true;
                extend = false;
                if (!(Double.isNaN(this.phasePointX) || Double.isNaN(this.phasePointY) || Double.isNaN(this.phasePointZ))) {
                    x1 = this.phasePointX;
                    y1 = this.phasePointY;
                    z = this.phasePointZ;
                    if (!this.lineBreak && drawLine) {
                        channel.glVertex(x1, y1, z);
                    }
                    this.phasePointX = Double.NaN;
                    this.phasePointY = Double.NaN;
                    this.phasePointZ = Double.NaN;
                    this.extremeXMin = x1;
                }
                this.endPointX = this.beginPointX;
                this.endPointY = this.beginPointY;
                this.endPointZ = this.beginPointZ;
                this.beginPointX = this.extremeXMin;
            }
            rightPt = false;
            try {
                if (!extraPoint) {
                    this.endPointX = this.pointX.getValue(index);
                    this.endPointY = this.pointY.getValue(index);
                    this.endPointZ = this.pointZ.getValue(index);
                } else {
                    extraPoint = false;
                }
                if (this.endPointX < this.extremeXMin) continue;
                if (this.beginPointX < this.extremeXMin) {
                    this.outOfRangeMin = true;
                    this.beginPointX = this.extremeXMin;
                    this.beginPointY = this.endPointY;
                }
                if (this.endPointX > this.extremeXMax) {
                    rightPt = true;
                    this.outOfRangeMax = true;
                    this.endPointX = Math.min(this.endPointX, this.extremeXMax);
                    this.endPointY = this.beginPointY;
                } else if (this.endPointX < this.extremeXMax && j == intersectionCount - 1) {
                    rightPt = true;
                    extraPoint = true;
                }
                rightBeginPtX = this.beginPointX;
                rightBeginPtY = this.beginPointY;
                rightEndPtX = this.endPointX;
                rightEndPtY = this.endPointY;
                rightPtZ = this.beginPointZ;
                x1 = this.beginPointX;
                x2 = this.endPointX;
                y1 = this.beginPointY;
                y2 = this.endPointY;
                z = this.beginPointZ;
                validPoint = true;
                if (this.outOfRangeMin) {
                    if (drawLine) {
                        channel.glVertex(x1, y1, z);
                        channel.glVertex(x2, y2, z);
                    }
                } else if (this.outOfRangeMax) {
                    this.endPointY = rightEndPtY;
                    if (drawLine) {
                        channel.glVertex(x1, y1, z);
                        channel.glVertex(x2, y2, z);
                    }
                } else if (drawLine) {
                    channel.glVertex(x1, y1, z);
                    if (y1 != y2) {
                        double cx = (x1 + x2) * 0.5;
                        channel.glVertex(cx, y1, z);
                        if (this.lineBreak) {
                            channel.glEnd();
                            channel.glBegin(1);
                        }
                        channel.glVertex(cx, y2, z);
                    }
                    channel.glVertex(x2, y2, z);
                }
                this.outOfRangeMin = false;
                this.outOfRangeMax = false;
                this.beginPointX = this.endPointX;
                this.beginPointY = this.endPointY;
                this.beginPointZ = this.endPointZ;
                if (extraPoint) {
                    this.endPointX = this.extremeXMax;
                    this.endPointY = this.beginPointY;
                    this.endPointZ = this.beginPointZ;
                }
                if (Double.isNaN(yInnerLeft)) {
                    yInnerLeft = this.endPointY;
                }
                yInnerRight = this.endPointY;
                continue;
            }
            catch (MissingValueException mve) {
                rightBeginPtX = this.beginPointX;
                rightBeginPtY = this.beginPointY;
                rightEndPtX = this.extremeXMax;
                rightEndPtY = this.beginPointY;
                rightPtZ = this.beginPointZ;
                if (!this.skipMissing) continue;
                this.beginPointX = Double.NaN;
                this.beginPointY = Double.NaN;
                this.beginPointZ = Double.NaN;
                if (!drawLine) continue;
                channel.glEnd();
                channel.glBegin(1);
            }
        }
        if (degenerate) {
            try {
                index = (Integer)aLine.elementAt(indexInit);
                x1 = this.extremeXMin;
                x2 = this.extremeXMax;
                y2 = y1 = this.pointY.getValue(index);
                z = this.pointZ.getValue(index);
                if (drawLine) {
                    channel.glVertex(x1, y1, z);
                    channel.glVertex(x2, y2, z);
                }
                rightEndPtX = x2;
                if (Double.isNaN(yInnerLeft)) {
                    yInnerLeft = y1;
                }
                yInnerRight = y1;
            }
            catch (MissingValueException mve) {}
        } else if (indexTerm < intersectionCount) {
            try {
                this.beginPointX = this.endPointX;
                index = (Integer)aLine.elementAt(indexTerm);
                this.endPointX = (this.pointX.getValue(index) + this.beginPointX) / 2.0;
                x1 = this.beginPointX;
                x2 = this.endPointX;
                y1 = this.endPointY;
                y2 = this.endPointY;
                z = this.endPointZ;
                if (drawLine) {
                    channel.glVertex(x1, y1, z);
                    channel.glVertex(x2, y2, z);
                }
            }
            catch (MissingValueException mve) {}
        } else {
            if (!rightPt && drawLine) {
                channel.glVertex(rightBeginPtX, rightBeginPtY, rightPtZ);
                channel.glVertex(rightEndPtX, rightEndPtY, rightPtZ);
            }
            if (!validPoint) {
                this.phasePointX = Double.NaN;
                this.phasePointY = Double.NaN;
                this.phasePointZ = Double.NaN;
            } else if (!this.lineBreak) {
                this.phasePointX = this.extremeXMax;
                this.phasePointY = this.endPointY;
                this.phasePointZ = this.endPointZ;
            }
        }
        if (drawLine) {
            channel.glEnd();
        }
        boolean hasLabel = this.label == null || this.label.string == null || this.label.string.getValue() == null ? false : this.label.string.getValue().length() > 0;
        boolean useLabel = this.phaseIndex == -1 || this.phaseIndex == this.currentPhase;
        boolean bl2 = drawLabel = this.labelOn && hasLabel && useLabel;
        if (drawLabel) {
            double y;
            double x;
            String str = this.label.string.getValue();
            String fontName = this.label.fontName.getValue();
            int fontStyle = this.label.fontStyle.getValue();
            int fontSize = this.label.fontSize.getValue();
            Font labelFont = FontManager.getFont((String)fontName, (int)fontStyle, (int)fontSize);
            FontMetrics fm = StatGraph.getFontMetrics((Font)labelFont);
            channel.glAlignment(0, 2);
            channel.glSelect2DFont(labelFont);
            Graphics2D g = (Graphics2D)StatGraph.getGraphics();
            Rectangle2D bbox = fm.getStringBounds(str, g);
            double width = bbox.getWidth();
            double height = bbox.getHeight();
            int yoffset = QCMargins.getBlockX();
            int xoffset = QCMargins.getDefaultX();
            switch (this.labelPosition) {
                default: {
                    x = this.extremeXMin + (double)xoffset;
                    y = this.labelAbove ? yInnerLeft + (double)yoffset : yInnerLeft - ((double)yoffset + height);
                    break;
                }
                case INNER_RIGHT: {
                    x = this.extremeXMin - (double)xoffset;
                    x -= width;
                    y = this.labelAbove ? yInnerRight + (double)yoffset : yInnerRight - ((double)yoffset + height);
                    break;
                }
                case OUTER_RIGHT: {
                    x = this.extremeXMin + (double)xoffset;
                    y = yInnerRight - height / 2.0;
                }
            }
            z = 0.0;
            this.label.coordX.setValue(x);
            this.label.coordY.setValue(y);
            this.label.coordZ.setValue(z);
            RasterLabel test = new RasterLabel();
            test.coordX.setValue(x);
            test.coordY.setValue(y);
            test.coordZ.setValue(z);
            test.string.setValue(this.label.string.getValue());
            test.color.setValue(this.label.color.getValue());
            test.fontName.setValue(fontName);
            test.fontSize.setValue(fontSize);
            test.fontStyle.setValue(fontStyle);
            try {
                this.label.render(buildAction);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if ((debug = false) && this.currentPhase > 0) {
            channel.glPolygonMode(2);
            channel.glBegin(1);
            channel.glLineWidth(1.0f);
            channel.glColor(Color.RED);
            channel.glVertex(this.extremeXMin, this.frame.getULY(), this.phasePointZ);
            channel.glVertex(this.extremeXMin, this.frame.getLRY(), this.phasePointZ);
            channel.glEnd();
            channel.glLineWidth(this.myLineWidth);
            channel.glColor(this.myColor);
        }
    }

    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        this.stipplePattern = group.getStipplePattern();
        this.stippleFactor = group.getStippleFactor();
        this.myLineWidth = (float)group.getLineWidth();
        this.myColor = group.getLineColor();
        for (int i = 0; i < polyLineCount; ++i) {
            Vector line = group.getPolyline(i);
            if (line == null) continue;
            this.outOfRangeMin = false;
            this.outOfRangeMax = false;
            int intersectionCount = line.size();
            if (intersectionCount < 1 || !this.applyPhaseBoundary(line)) continue;
            this.drawPolyline(buildAction, line);
        }
    }
}

