/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCLimitsConnector;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

public class QCVMaskConnector
extends AQCLimitsConnector {
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;
    private boolean degenerate = false;
    private BBox frame = null;
    private double degenerateX;
    private ContinuousRangeToNumericMapper xMapper = null;
    public final BooleanProperty lineOn = new BooleanProperty((PropertyContainer)this, true);
    protected boolean SVGRender;

    public QCVMaskConnector() {
        super((ATransform)new Transform());
        this.multipleGroup = true;
        this.SVGRender = false;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    private void drawFilled(ABuildAction buildAction, Vector aBand) {
        double adj;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        ArrayList<Vec3d> vertices = new ArrayList<Vec3d>();
        double d = adj = this.SVGRender ? 0.0 : 1.0;
        if (this.degenerate) {
            channel.glPolygonMode(3);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            double x = this.xMapper.getValue(this.degenerateX);
            channel.glVertex(x, this.frame.getULY(), 0.0);
            channel.glVertex(x, this.frame.getLRY(), 0.0);
            x = this.frame.getULX();
            channel.glVertex(x, this.frame.getLRY(), 0.0);
            channel.glVertex(x, this.frame.getULY(), 0.0);
            channel.glEnd();
        } else {
            int n;
            Vec3d v;
            int indexInit = this.stripMissing(aBand, true);
            int indexTerm = this.stripMissing(aBand, false);
            for (int j = indexInit; j < indexTerm; ++j) {
                int index = (Integer)aBand.elementAt(j);
                try {
                    double x = this.pointX.getValue(index);
                    double y = this.pointY.getValue(index);
                    double z = this.pointZ.getValue(index);
                    v = new Vec3d(x, y, z);
                    vertices.add(v);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            int n2 = n = vertices == null ? 0 : vertices.size();
            if (n > 0) {
                channel.glPolygonMode(3);
                channel.glBegin(2);
                channel.glNormal(0.0, 0.0, 1.0);
                for (int i = 0; i < n; ++i) {
                    v = (Vec3d)vertices.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                channel.glEnd();
            }
        }
    }

    private int stripMissing(Vector aBand, boolean min) {
        int intersectionCount = aBand.size();
        int rc = min ? 0 : intersectionCount;
        boolean ignore = false;
        if (ignore) {
            return rc;
        }
        double y = Double.NaN;
        for (int i = 0; i < intersectionCount; ++i) {
            int k = min ? i : intersectionCount - (i + 1);
            int index = (Integer)aBand.elementAt(k);
            if (this.lineOn.getValue()) {
                try {
                    y = this.pointY.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (Double.isNaN(y)) continue;
            rc = min ? k : k + 1;
            break;
        }
        return rc;
    }

    private void drawPolyline(ABuildAction buildAction, Vector aBand) {
        double adj;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        ArrayList<Vec3d> vertices = new ArrayList<Vec3d>();
        double d = adj = this.SVGRender ? 0.0 : 1.0;
        if (this.degenerate) {
            channel.glBegin(1);
            channel.glNormal(0.0, 0.0, 1.0);
            double x = this.xMapper.getValue(this.degenerateX);
            channel.glVertex(x, this.frame.getULY(), 0.0);
            channel.glVertex(x, this.frame.getLRY(), 0.0);
            channel.glEnd();
        } else {
            int n;
            Vec3d v;
            int indexInit = this.stripMissing(aBand, true);
            int indexTerm = this.stripMissing(aBand, false);
            for (int j = indexInit; j < indexTerm; ++j) {
                int index = (Integer)aBand.elementAt(j);
                try {
                    double x = this.pointX.getValue(index);
                    double y = this.pointY.getValue(index);
                    double z = this.pointZ.getValue(index);
                    v = new Vec3d(x, y, z);
                    vertices.add(v);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            int n2 = n = vertices == null ? 0 : vertices.size();
            if (n > 0) {
                channel.glBegin(1);
                channel.glNormal(0.0, 0.0, 1.0);
                for (int i = 0; i < n; ++i) {
                    v = (Vec3d)vertices.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                channel.glEnd();
            }
        }
    }

    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        this.stipplePattern = group.getStipplePattern();
        this.stippleFactor = group.getStippleFactor();
        this.myLineWidth = (float)group.getLineWidth();
        this.myColor = group.getLineColor();
        this.myFillColor = group.getFillColor();
        for (int i = 0; i < polyLineCount; ++i) {
            int intersectionCount;
            Vector band = group.getPolyline(i);
            if (band == null || (intersectionCount = band.size()) < 1) continue;
            if (fillOn) {
                this.drawFilled(buildAction, band);
                continue;
            }
            this.drawPolyline(buildAction, band);
        }
    }

    public void setDegenerate(double d, ContinuousRangeToNumericMapper xMapper) {
        this.degenerate = true;
        this.degenerateX = d;
        this.xMapper = xMapper;
    }

    public void setFrame(BBox bbox) {
        this.frame = bbox;
    }
}

