/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarDataModel;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import java.awt.Font;
import java.awt.FontMetrics;

public class QCStarGraphModel {
    public static final int JUSTIFY_HORIZONTAL = 1;
    public static final int JUSTIFY_VERTICAL = 2;
    public static final int JUSTIFY_OFFSETX = 3;
    public static final int JUSTIFY_OFFSETY = 4;
    private QCStar star;
    protected QCStarDataModel dataModel;
    protected NumericMapper subgrpMapper;
    protected NumericMapper processMapper;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected double radiusOut;
    protected double radiusIn;
    protected double radiusDif;
    protected double radiusMid;
    protected double radiusBD;
    protected double aspect = 1.0;
    protected int nVertex;
    protected int nObs;
    protected int nObsLabel;
    public double startDegrees;
    private double startRadians;
    private double sigmaMult = Double.NaN;
    private double[] radians;
    private double[] circles;
    private double[] cValues;
    private boolean[] vOut;
    private double vMinOverall = Double.NaN;
    private double vMaxOverall = Double.NaN;
    private double[] compVX;
    private double[] compVY;
    private double[] compCX;
    private double[] compCY;
    protected double[][] vx;
    protected double[][] vy;
    protected double[][] cx;
    protected double[][] cy;
    protected double[][] lx;
    protected double[][] ly;
    protected double vxMin = 0.0;
    protected double vxMax = 0.0;
    protected double vyMin = 0.0;
    protected double vyMax = 0.0;
    protected double[] testx;
    protected double[] testy;
    protected Variable xtestVar;
    protected Variable ytestVar;
    protected Variable[] vxVar;
    protected Variable[] vyVar;
    protected Variable[] cxVar;
    protected Variable[] cyVar;
    protected Variable[] lxVar;
    protected Variable[] lyVar;
    protected double labelWidthMax;
    protected double[] labelWidth;
    protected double[] labelHeight;
    protected boolean[][] labelDisplay;
    protected boolean outOfBounds;
    protected int[] justifyHorizontal;
    protected int[] justifyVertical;
    protected int[] justifyOffsetX;
    protected int[] justifyOffsetY;
    protected TextStyle labelStyle;
    protected ColorVector spokeColorList = null;
    protected NumericVector spokePatternList = null;
    protected IntegerVector spokeStipplePattern;
    protected IntegerVector spokeStippleFactor;

    public void setDataModel(QCStarDataModel model) {
        this.dataModel = model;
    }

    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            this.yEncoder = (PositionEncoder)encoder;
        }
    }

    public void setView(QCStar in) {
        this.star = in;
    }

    public void setSubgrpMapper(NumericMapper mapper) {
        this.subgrpMapper = mapper;
    }

    public void setResponseMapper(NumericMapper mapper) {
        this.processMapper = mapper;
    }

    public void build() {
        if (this.dataModel == null || !this.dataModel.hasVertices()) {
            return;
        }
        this.init();
        Font f = this.labelStyle.getFont();
        FontMetrics fm = StatGraph.getFontMetrics((Font)f);
        double height = fm.getHeight();
        this.labelWidthMax = 0.0;
        Variable[] vars = this.dataModel.getVertexVars();
        for (int i = 0; i < this.nVertex; ++i) {
            String str = vars[i].getLabel();
            this.labelWidth[i] = fm.stringWidth(str);
            this.labelHeight[i] = height;
            this.labelWidthMax = Math.max(this.labelWidth[i], this.labelWidthMax);
        }
    }

    public void init() {
        int i;
        int dx = 4;
        double fuzz = 0.001;
        this.nObsLabel = this.nObs = this.dataModel.getNObs();
        this.nVertex = this.dataModel.getNVertices();
        this.radians = new double[this.nVertex];
        this.compVX = new double[this.nVertex];
        this.compVY = new double[this.nVertex];
        this.compCX = new double[this.nVertex];
        this.compCY = new double[this.nVertex];
        this.justifyHorizontal = new int[this.nVertex];
        this.justifyVertical = new int[this.nVertex];
        this.justifyOffsetX = new int[this.nVertex];
        this.justifyOffsetY = new int[this.nVertex];
        this.startRadians = Math.toRadians(this.startDegrees);
        double halfAngle = Math.PI / (double)this.nVertex;
        for (i = 0; i < this.nVertex; ++i) {
            this.radians[i] = this.startRadians + Math.PI * 2 * (double)i / (double)this.nVertex;
            double d = this.compVX[i] = Math.sin(this.radians[i]);
            d = this.compVY[i] = Math.cos(this.radians[i]);
            d = this.compCX[i] = Math.sin(this.radians[i] + halfAngle);
            d = this.compCY[i] = Math.cos(this.radians[i] + halfAngle);
            int n = this.compVX[i] > fuzz ? 0 : (this.justifyHorizontal[i] = this.compVX[i] < -fuzz ? 2 : 1);
            this.justifyVertical[i] = this.compVY[i] > fuzz ? 3 : (this.compVY[i] < -fuzz ? 0 : 1);
            this.justifyOffsetX[i] = 0;
            this.justifyOffsetY[i] = 0;
            if (this.justifyVertical[i] != 1) continue;
            this.justifyOffsetX[i] = this.justifyHorizontal[i] == 0 ? dx : (this.justifyHorizontal[i] == 2 ? -dx : 0);
        }
        this.vMinOverall = Double.MAX_VALUE;
        this.vMaxOverall = Double.MIN_VALUE;
        this.outOfBounds = false;
        this.labelWidth = new double[this.nVertex];
        this.labelHeight = new double[this.nVertex];
        this.labelDisplay = new boolean[this.nObs][this.nVertex];
        this.vx = new double[this.nVertex][this.nObs];
        this.vy = new double[this.nVertex][this.nObs];
        this.cx = new double[this.nVertex][this.nObs];
        this.cy = new double[this.nVertex][this.nObs];
        this.lx = new double[this.nVertex][this.nObsLabel];
        this.ly = new double[this.nVertex][this.nObsLabel];
        this.vxVar = new Variable[this.nVertex];
        this.vyVar = new Variable[this.nVertex];
        this.cxVar = new Variable[this.nVertex];
        this.cyVar = new Variable[this.nVertex];
        this.lxVar = new Variable[this.nVertex];
        this.lyVar = new Variable[this.nVertex];
        for (i = 0; i < this.nVertex; ++i) {
            this.vxVar[i] = new NumericVectorVariable();
            this.vyVar[i] = new NumericVectorVariable();
            this.cxVar[i] = new NumericVectorVariable();
            this.cyVar[i] = new NumericVectorVariable();
            this.lxVar[i] = new NumericVectorVariable();
            this.lyVar[i] = new NumericVectorVariable();
            ((NumericVectorVariable)this.vxVar[i]).connectFrom(this.vx[i]);
            ((NumericVectorVariable)this.vyVar[i]).connectFrom(this.vy[i]);
            ((NumericVectorVariable)this.cxVar[i]).connectFrom(this.cx[i]);
            ((NumericVectorVariable)this.cyVar[i]).connectFrom(this.cy[i]);
            ((NumericVectorVariable)this.lxVar[i]).connectFrom(this.lx[i]);
            ((NumericVectorVariable)this.lyVar[i]).connectFrom(this.ly[i]);
        }
        this.initTest();
    }

    private void initTest() {
        this.testx = new double[this.nObsLabel];
        this.testy = new double[this.nObsLabel];
        this.xtestVar = new NumericVectorVariable();
        this.ytestVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.xtestVar).connectFrom(this.testx);
        ((NumericVectorVariable)this.ytestVar).connectFrom(this.testy);
    }

    public void buildJ2D() {
        if (this.dataModel == null || !this.dataModel.hasVertices()) {
            return;
        }
        this.computeVertices();
        boolean testRadius = this.star.labelsOn.getValue();
        testRadius = false;
        if (testRadius) {
            double x;
            double width;
            int obs;
            int i = (int)this.star.labelType.getValue();
            QCStarLabel.StarLabel labelType = QCStarLabel.StarLabel.fromInteger(i);
            boolean labelFirst = labelType == QCStarLabel.StarLabel.ALL || labelType == QCStarLabel.StarLabel.FIRST;
            boolean labelLast = labelType == QCStarLabel.StarLabel.ALL;
            double axisLength = this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit();
            double xWidth = this.xEncoder.getOutputMax() - this.xEncoder.getOutputMin();
            double innerMarginLeft = this.xEncoder.getOutputMin() - this.xEncoder.getLowerLimit();
            double innerMarginRight = this.xEncoder.getUpperLimit() - this.xEncoder.getOutputMax();
            double radius = this.radiusOut;
            boolean recomputeRadius = false;
            labelFirst = true;
            labelLast = false;
            if (labelFirst) {
                obs = 0;
                block10: for (i = 0; i < this.nVertex; ++i) {
                    switch (this.justifyHorizontal[i]) {
                        case 0: {
                            continue block10;
                        }
                        case 2: {
                            width = this.labelWidth[i] - (double)this.justifyOffsetX[i];
                            x = this.lx[i][obs];
                            x -= width;
                            if (!(Math.abs(x) > innerMarginLeft)) continue block10;
                            width = innerMarginLeft - width;
                            radius = Math.min(radius, width);
                            recomputeRadius = true;
                            continue block10;
                        }
                        case 1: {
                            width = this.labelWidth[i] / 2.0;
                            x = this.lx[i][obs];
                            x -= width;
                            if (!(x > innerMarginLeft)) continue block10;
                            width = innerMarginLeft - width;
                            radius = Math.min(radius, width);
                            recomputeRadius = true;
                        }
                    }
                }
            }
            if (labelLast) {
                obs = this.nObs - 1;
                block11: for (i = 0; i < this.nVertex; ++i) {
                    switch (this.justifyHorizontal[i]) {
                        case 0: {
                            width = this.labelWidth[i] + (double)this.justifyOffsetX[i];
                            x = this.lx[i][obs];
                            x += width;
                            if (!(x > innerMarginRight)) continue block11;
                            width = innerMarginRight - width;
                            radius = Math.min(radius, width);
                            recomputeRadius = true;
                            continue block11;
                        }
                        case 2: {
                            continue block11;
                        }
                        case 1: {
                            width = this.labelWidth[i] / 2.0;
                            x = this.lx[i][obs];
                            x += width;
                            if (!(x > innerMarginRight)) continue block11;
                            width = innerMarginRight - width;
                            radius = Math.min(radius, width);
                            recomputeRadius = true;
                        }
                    }
                }
            }
            if (recomputeRadius) {
                radius = Math.max(0.0, radius);
                this.dataModel.setRadiusOut(radius);
                for (i = 0; i < this.nObs; ++i) {
                    this.computeVertices(i);
                }
            }
        }
    }

    public void computeVertices() {
        if (this.dataModel == null || !this.dataModel.hasVertices()) {
            return;
        }
        this.vxMin = 0.0;
        this.vxMax = 0.0;
        this.vyMin = 0.0;
        this.vyMax = 0.0;
        for (int i = 0; i < this.nObs; ++i) {
            double[] d = this.computeVertices(i);
            this.vxMin = Math.min(d[0], this.vxMin);
            this.vxMax = Math.max(d[1], this.vxMax);
            this.vyMin = Math.min(d[2], this.vyMin);
            this.vyMax = Math.max(d[3], this.vyMax);
        }
    }

    public double[] computeVertices(int igrp) {
        AQCStar.StarType starType = this.star.getStarType();
        double[] vertices = this.dataModel.getVertices(igrp);
        double x0 = 0.0;
        double y0 = 0.0;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        double[] d = new double[4];
        int i = (int)this.star.labelType.getValue();
        QCStarLabel.StarLabel labelType = QCStarLabel.StarLabel.fromInteger(i);
        boolean labelFirst = labelType == QCStarLabel.StarLabel.ALL || labelType == QCStarLabel.StarLabel.FIRST;
        boolean labelLast = labelType == QCStarLabel.StarLabel.ALL;
        for (int j = 0; j < this.nVertex; ++j) {
            double rValue;
            double v = vertices[j];
            if (v == 0.0) {
                rValue = this.radiusIn;
            } else {
                rValue = this.radiusIn + this.radiusDif * v;
                rValue = Math.min(rValue, this.radiusBD);
            }
            double d2 = x0 + this.compVX[j] * rValue;
            this.vx[j][igrp] = d2;
            double dx = d2;
            double d3 = y0 + this.compVY[j] * rValue * this.aspect;
            this.vy[j][igrp] = d3;
            double dy = d3;
            rValue = 0.25 * this.radiusOut;
            this.cx[j][igrp] = x0 + this.compCX[j] * rValue;
            this.cy[j][igrp] = y0 + this.compCY[j] * rValue * this.aspect;
            if (igrp < this.nObsLabel) {
                boolean labelDraw;
                if (starType == AQCStar.StarType.SPOKE && v <= 0.0) {
                    rValue = this.radiusIn;
                    dx = x0 + this.compVX[j] * rValue;
                    dy = y0 + this.compVY[j] * rValue * this.aspect;
                }
                this.lx[j][igrp] = dx + (double)this.justifyOffsetX[j];
                this.ly[j][igrp] = dy + (double)this.justifyOffsetY[j];
                switch (labelType) {
                    case FIRST: {
                        labelDraw = igrp == 0;
                        break;
                    }
                    case ALL: {
                        labelDraw = true;
                        break;
                    }
                    case LOW: {
                        labelDraw = this.dataModel.getVLow(igrp, j);
                        break;
                    }
                    case HIGH: {
                        labelDraw = this.dataModel.getVHigh(igrp, j);
                        break;
                    }
                    case OUT: {
                        labelDraw = this.dataModel.getVOut(igrp, j);
                        break;
                    }
                    default: {
                        labelDraw = false;
                    }
                }
                double width = this.labelWidth[j];
                if (labelDraw) {
                    switch (this.justifyHorizontal[j]) {
                        case 0: {
                            dx += (double)this.justifyOffsetX[j] + width;
                            break;
                        }
                        case 2: {
                            dx -= (double)(-this.justifyOffsetX[j]) + width;
                            break;
                        }
                        case 1: {
                            dx = igrp == 0 ? dx - ((double)this.justifyOffsetX[j] + width / 2.0) : dx + ((double)this.justifyOffsetX[j] + width / 2.0);
                        }
                    }
                    double height = this.labelHeight[j];
                    switch (this.justifyVertical[j]) {
                        case 0: {
                            dy -= (double)this.justifyOffsetY[j] + height;
                            break;
                        }
                        case 3: {
                            dy += (double)this.justifyOffsetY[j] + height;
                            break;
                        }
                        case 1: {
                            dy += (double)this.justifyOffsetY[j] + height / 2.0;
                        }
                    }
                }
            }
            xmin = Math.min(xmin, dx);
            xmax = Math.max(xmax, dx);
            ymin = Math.min(ymin, dy);
            ymax = Math.max(ymax, dy);
        }
        d[0] = xmin;
        d[1] = xmax;
        d[2] = ymin;
        d[3] = ymax;
        return d;
    }

    private void computeVertex(int i, int j, double[] out) {
        double rValue;
        double v = this.dataModel.getVertices(i)[j];
        if (v == 0.0) {
            rValue = this.radiusIn;
        } else {
            rValue = this.radiusIn + this.radiusDif * v;
            rValue = Math.min(rValue, this.radiusBD);
        }
        double x0 = 0.0;
        double y0 = 0.0;
        out[0] = x0 + this.compVX[j] * rValue;
        out[1] = y0 + this.compVY[j] * rValue * this.aspect;
    }

    public void computeVertex(int i, double rValue, double[] out) {
        rValue = Math.min(rValue, this.radiusBD);
        double x0 = 0.0;
        double y0 = 0.0;
        out[0] = x0 + this.compVX[i] * rValue;
        out[1] = y0 + this.compVY[i] * rValue * this.aspect;
    }

    public double getVXMin() {
        return this.vxMin;
    }

    public double getVXMax() {
        return this.vxMax;
    }

    public double getVYMin() {
        return this.vyMin;
    }

    public double getVYMax() {
        return this.vyMax;
    }

    private double computeRValue(double stdValue) {
        double rValue;
        if (stdValue == 0.0) {
            rValue = this.radiusIn + this.radiusDif * stdValue;
            rValue = Math.min(rValue, this.radiusBD);
        } else {
            rValue = this.radiusIn + this.radiusDif * stdValue;
            rValue = Math.min(rValue, this.radiusBD);
        }
        return rValue;
    }

    public double getRValue(double value) {
        return this.computeRValue(value);
    }

    public double[] getVertexX(int obs) {
        if (this.vx == null) {
            return null;
        }
        if (obs >= this.nObs) {
            return null;
        }
        double[] x = new double[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            x[i] = this.vx[i][obs];
        }
        return x;
    }

    public double[] getVertexY(int obs) {
        if (this.vy == null) {
            return null;
        }
        if (obs >= this.nObs) {
            return null;
        }
        double[] y = new double[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            y[i] = this.vy[i][obs];
        }
        return y;
    }

    public double[] getCoronaX(int obs) {
        boolean corona;
        AQCStar.StarType starType = this.star.getStarType();
        boolean bl = corona = starType == AQCStar.StarType.CORONA && this.cx != null && this.cy != null;
        if (!corona) {
            return null;
        }
        if (obs >= this.nObs) {
            return null;
        }
        double[] x = new double[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            x[i] = this.cx[i][obs];
        }
        return x;
    }

    public double[] getCoronaY(int obs) {
        boolean corona;
        AQCStar.StarType starType = this.star.getStarType();
        boolean bl = corona = starType == AQCStar.StarType.CORONA && this.cx != null && this.cy != null;
        if (!corona) {
            return null;
        }
        if (obs >= this.nObs) {
            return null;
        }
        double[] y = new double[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            y[i] = this.cy[i][obs];
        }
        return y;
    }

    public double[] getLabelX(int obs) {
        if (this.lx == null) {
            return null;
        }
        if (obs >= this.nObsLabel) {
            return null;
        }
        double[] x = new double[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            x[i] = this.lx[i][obs];
        }
        return x;
    }

    public double[] getLabelY(int obs) {
        if (this.ly == null) {
            return null;
        }
        if (obs >= this.nObsLabel) {
            return null;
        }
        double[] y = new double[this.nVertex];
        for (int i = 0; i < this.nVertex; ++i) {
            y[i] = this.ly[i][obs];
        }
        return y;
    }

    public Variable[] getVertexXVars() {
        return this.vxVar;
    }

    public Variable getVertexXVar(int i) {
        return this.vxVar[i];
    }

    public Variable[] getVertexYVars() {
        return this.vyVar;
    }

    public Variable getVertexYVar(int i) {
        return this.vyVar[i];
    }

    public Variable[] getLabelXVars() {
        return this.lxVar;
    }

    public Variable getLabelXVar(int i) {
        return this.lxVar[i];
    }

    public Variable[] getLabelYVars() {
        return this.lyVar;
    }

    public Variable getLabelYVar(int i) {
        return this.lyVar[i];
    }

    public Variable[] getCoronaXVars() {
        return this.cxVar;
    }

    public Variable getCoronaXVar(int i) {
        return this.cxVar[i];
    }

    public Variable[] getCoronaYVars() {
        return this.cyVar;
    }

    public Variable getCoronaYVar(int i) {
        return this.cyVar[i];
    }

    public int[] getJustification(int type) {
        int[] j = null;
        switch (type) {
            case 1: {
                j = this.justifyHorizontal;
                break;
            }
            case 2: {
                j = this.justifyVertical;
                break;
            }
            case 3: {
                j = this.justifyOffsetX;
                break;
            }
            case 4: {
                j = this.justifyOffsetY;
            }
        }
        return j;
    }

    public double computePreferredRadius(double axisLength, double nTick, boolean saveRadius, double outer, double inner) {
        double radius;
        double margin;
        double total;
        double vx;
        double width;
        double rValue;
        double[] v;
        double bd;
        double dif;
        double in;
        double out;
        boolean computed;
        AQCStar.StarType starType = this.star.getStarType();
        double ninc = nTick;
        double xinc = axisLength / ninc;
        if (outer == -1.0) {
            computed = true;
            out = xinc / 2.0;
            in = inner == -1.0 ? (starType == AQCStar.StarType.CORONA ? out / 2.0 : out / 3.0) : inner;
            dif = out - in;
            bd = out * 2.0;
        } else {
            computed = false;
            out = this.radiusOut;
            in = inner == -1.0 ? this.radiusIn : inner;
            dif = this.radiusDif;
            bd = this.radiusBD;
        }
        int i = (int)this.star.labelType.getValue();
        QCStarLabel.StarLabel labelType = QCStarLabel.StarLabel.fromInteger(i);
        boolean labelFirst = labelType == QCStarLabel.StarLabel.ALL || labelType == QCStarLabel.StarLabel.FIRST;
        boolean labelLast = labelType == QCStarLabel.StarLabel.ALL;
        double labelWidthLeft = 0.0;
        double maxWidthLeft = 0.0;
        int iLeft = 0;
        int igrpLower = this.star.getLowerSubgrpIndex();
        int igrpUpper = this.star.getUpperSubgrpIndex();
        if (igrpLower == -1) {
            igrpLower = 0;
        }
        if (igrpUpper == -1) {
            igrpUpper = this.nObs - 1;
        }
        if (QCShewhart.isSubsetted()) {
            ++igrpLower;
            --igrpUpper;
        }
        if (labelFirst) {
            v = this.dataModel.getVertices(igrpLower);
            block10: for (i = 0; i < this.nVertex; ++i) {
                rValue = in + dif * v[i];
                rValue = Math.min(rValue, bd);
                switch (this.justifyHorizontal[i]) {
                    case 0: {
                        continue block10;
                    }
                    case 2: {
                        width = this.labelWidth[i] - (double)this.justifyOffsetX[i];
                        vx = this.compVX[i];
                        total = rValue * Math.abs(vx) + width;
                        if (!(total > maxWidthLeft)) continue block10;
                        iLeft = i;
                        labelWidthLeft = width;
                        maxWidthLeft = total;
                        continue block10;
                    }
                    case 1: {
                        width = this.labelWidth[i] / 2.0;
                        vx = this.compVX[i];
                        total = rValue * Math.abs(vx) + width;
                        if (!(total > maxWidthLeft)) continue block10;
                        iLeft = i;
                        labelWidthLeft = width;
                        maxWidthLeft = total;
                    }
                }
            }
        } else {
            labelWidthLeft = maxWidthLeft = out;
            double maxVX = this.compVX[0];
            for (i = 0; i < this.nVertex; ++i) {
                vx = this.compVX[i];
                if (vx > 0.0 || !(vx < maxVX)) continue;
                iLeft = i;
                maxVX = vx;
            }
        }
        double labelWidthRight = 0.0;
        double maxWidthRight = 0.0;
        int iRight = 0;
        if (labelLast) {
            v = this.dataModel.getVertices(igrpUpper);
            block12: for (i = 0; i < this.nVertex; ++i) {
                rValue = in + dif * v[i];
                rValue = Math.min(rValue, bd);
                switch (this.justifyHorizontal[i]) {
                    case 2: {
                        continue block12;
                    }
                    case 0: {
                        width = this.labelWidth[i] + (double)this.justifyOffsetX[i];
                        vx = this.compVX[i];
                        total = rValue * Math.abs(vx) + width;
                        if (!(total > maxWidthRight)) continue block12;
                        iRight = i;
                        labelWidthRight = width;
                        maxWidthRight = total;
                        continue block12;
                    }
                    case 1: {
                        width = this.labelWidth[i] / 2.0;
                        vx = this.compVX[i];
                        total = rValue * Math.abs(vx) + width;
                        if (!(total > maxWidthRight)) continue block12;
                        iRight = i;
                        labelWidthRight = width;
                        maxWidthRight = total;
                    }
                }
            }
        } else {
            labelWidthRight = maxWidthRight = out;
            double maxVX = this.compVX[0];
            for (i = 0; i < this.nVertex; ++i) {
                vx = this.compVX[i];
                if (vx < 0.0 || !(vx > maxVX)) continue;
                iRight = i;
                maxVX = vx;
            }
        }
        double niceSpace = QCMargins.getStarBetweenOffset();
        boolean symmetricMargins = true;
        boolean bdClip = false;
        if (!symmetricMargins) {
            width = labelWidthLeft + labelWidthRight;
            xinc = axisLength - width;
            double vxLeft = Math.abs(this.compVX[iLeft]);
            double vxRight = Math.abs(this.compVX[iRight]);
            xinc /= vxLeft + (nTick - 1.0) + vxRight;
            margin = 0.0;
            radius = 0.0;
        } else if (maxWidthLeft > maxWidthRight) {
            margin = maxWidthLeft;
            radius = (axisLength - 2.0 * margin) / (nTick - 1.0) / 2.0;
            double d = out = outer == -1.0 ? (radius -= niceSpace) : this.radiusOut;
            in = inner == -1.0 ? (starType == AQCStar.StarType.CORONA ? out / 2.0 : out / 3.0) : inner;
            dif = out - in;
            bd = out * 2.0;
            if (bdClip) {
                v = this.dataModel.getVertices(igrpLower);
                double vLeft = v[iLeft];
                double vxLeft = Math.abs(this.compVX[iLeft]);
                bd = xinc / vLeft;
                rValue = in + dif * vLeft;
                rValue = Math.min(rValue, bd);
                total = rValue * vxLeft;
                radius = total - niceSpace;
                double d2 = out = outer == -1.0 ? radius : this.radiusOut;
                in = inner == -1.0 ? (starType == AQCStar.StarType.CORONA ? out / 2.0 : out / 3.0) : inner;
                dif = out - in;
                bd = out * 2.0;
            }
        } else {
            margin = maxWidthRight;
            radius = (axisLength - 2.0 * margin) / (nTick - 1.0) / 2.0;
            double d = out = outer == -1.0 ? (radius -= niceSpace) : this.radiusOut;
            in = inner == -1.0 ? (starType == AQCStar.StarType.CORONA ? out / 2.0 : out / 3.0) : inner;
            dif = out - in;
            bd = out * 2.0;
            if (bdClip) {
                v = this.dataModel.getVertices(igrpUpper);
                double vRight = v[iRight];
                double vxRight = Math.abs(this.compVX[iRight]);
                bd = xinc / vRight;
                rValue = this.radiusIn + this.radiusDif * vRight;
                rValue = Math.min(rValue, this.radiusBD);
                total = rValue * vxRight;
                radius = total - niceSpace;
                double d3 = out = outer == -1.0 ? radius : this.radiusOut;
                in = inner == -1.0 ? (starType == AQCStar.StarType.CORONA ? out / 2.0 : out / 3.0) : inner;
                dif = out - in;
                bd = out * 2.0;
            }
        }
        if (saveRadius) {
            this.setRadius(computed ? radius : out, in);
            QCShewhart.setGlyphOffset(radius);
        }
        return margin;
    }

    public void setLabelStyle(TextStyle style) {
        this.labelStyle = style;
    }

    public double getLabelWidthMax() {
        return this.labelWidthMax;
    }

    public void setRadius(double outer, double inner) {
        this.setRadiusOut(outer, inner);
    }

    public void setRadiusOut(double outer, double inner) {
        AQCStar.StarType starType = this.star.getStarType();
        this.radiusOut = outer;
        this.radiusIn = inner == -1.0 ? (starType == AQCStar.StarType.CORONA ? this.radiusOut / 2.0 : this.radiusOut / 3.0) : inner;
        this.radiusDif = this.radiusOut - this.radiusIn;
        this.radiusMid = (this.radiusIn + this.radiusOut) / 2.0;
        this.radiusBD = this.radiusOut * 2.0;
    }

    public double getRadius() {
        return this.radiusOut;
    }

    public void setRadiusInner(double r) {
        this.radiusIn = r;
    }

    public double getRadiusInner() {
        return this.radiusIn;
    }

    public void setRadiusOuter(double r) {
        this.radiusOut = r;
    }

    public double getRadiusOuter() {
        return this.radiusOut;
    }

    public void setRadiusMid(double r) {
        this.radiusMid = r;
    }

    public double getRadiusMid() {
        return this.radiusMid;
    }

    public void setRadiusDif(double r) {
        this.radiusDif = r;
    }

    public double getRadiusDif() {
        return this.radiusDif;
    }

    public void setRadiusClip(double r) {
        this.radiusBD = r;
    }

    public double getRadiusClip() {
        return this.radiusBD;
    }
}

