/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarGraphModel;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Variable;

public class QCStarDataModel {
    private QCStar star;
    private QCStarGraphModel graphModel;
    private Variable[] vertexVars;
    private Variable yVar;
    private int nVertex;
    private int nObs;
    private boolean[][] vLow;
    private boolean[][] vHigh;
    private boolean[][] vOut;
    private double[][] v;
    private double[][] rValue;
    protected double radiusOut;
    protected double radiusIn;
    protected double radiusDif;
    protected double radiusMid;
    protected double radiusBD;

    public QCStarDataModel() {
    }

    public QCStarDataModel(QCStarGraphModel model) {
        this.graphModel = model;
    }

    public void setView(QCStar in) {
        this.star = in;
    }

    public void setY(Variable y) {
        this.yVar = y;
    }

    public Variable getY() {
        return this.yVar;
    }

    public void setVertexVars(Variable[] vars) {
        this.nObs = vars[0].getValueCount();
        this.nVertex = vars.length;
        this.vertexVars = vars;
    }

    public boolean build() {
        this.readVertices();
        return true;
    }

    private void readVertices() {
        this.v = new double[this.nObs][this.nVertex];
        this.rValue = new double[this.nObs][this.nVertex];
        this.vLow = new boolean[this.nObs][this.nVertex];
        this.vHigh = new boolean[this.nObs][this.nVertex];
        this.vOut = new boolean[this.nObs][this.nVertex];
        for (int i = 0; i < this.nObs; ++i) {
            for (int j = 0; j < this.nVertex; ++j) {
                double d;
                NumericVectorVariable var = (NumericVectorVariable)this.vertexVars[j];
                try {
                    d = var.value.getValue(i);
                }
                catch (MissingValueException mve) {
                    d = mve.getMissingValue().getDoubleValue();
                }
                this.v[i][j] = d;
                this.vLow[i][j] = d < 0.0;
                this.vHigh[i][j] = d > 1.0;
                this.vOut[i][j] = d < 0.0 || d > 1.0;
                d = this.radiusIn + this.radiusDif * d;
                this.rValue[i][j] = d = Math.min(d, this.radiusBD);
            }
        }
    }

    public boolean hasVertices() {
        return this.v != null && this.nVertex != 0;
    }

    public double[][] getVertices() {
        return this.v;
    }

    public double[] getVertices(int i) {
        return this.v[i];
    }

    public Variable[] getVertexVars() {
        return this.vertexVars;
    }

    public void setGraphModel(QCStarGraphModel model) {
        this.graphModel = model;
    }

    public int getNVertices() {
        return this.nVertex;
    }

    public int getNObs() {
        return this.nObs;
    }

    public boolean getVLow(int igrp, int ivertex) {
        return this.vLow[igrp][ivertex];
    }

    public boolean[] getVLow(int igrp) {
        return this.vLow[igrp];
    }

    public boolean[][] getVLow() {
        return this.vLow;
    }

    public boolean getVHigh(int igrp, int ivertex) {
        return this.vHigh[igrp][ivertex];
    }

    public boolean[] getVHigh(int igrp) {
        return this.vHigh[igrp];
    }

    public boolean[][] getVHigh() {
        return this.vHigh;
    }

    public boolean getVOut(int igrp, int ivertex) {
        return this.vOut[igrp][ivertex];
    }

    public boolean[] getVOut(int igrp) {
        return this.vOut[igrp];
    }

    public boolean[][] getVOut() {
        return this.vOut;
    }

    public double[] getRValue(int igrp) {
        return this.rValue[igrp];
    }

    public double getRValue(int igrp, int ivertex) {
        return this.rValue[igrp][ivertex];
    }

    public void setRadius(double r) {
        this.setRadiusOut(r);
    }

    public double getRadius() {
        return this.radiusOut;
    }

    public void setRadiusOut(double r) {
        this.radiusOut = r;
        this.radiusIn = this.star.type == AQCStar.StarType.CORONA ? this.radiusOut / 2.0 : this.radiusOut / 3.0;
        this.radiusDif = this.radiusOut - this.radiusIn;
        this.radiusMid = (this.radiusIn + this.radiusOut) / 2.0;
        this.radiusBD = this.radiusOut * 2.0;
    }

    public void setRadiusInner(double r) {
        this.radiusIn = r;
    }

    public double getRadiusInner() {
        return this.radiusIn;
    }

    public void setRadiusOuter(double r) {
        this.radiusOut = r;
    }

    public double getRadiusOuter() {
        return this.radiusOut;
    }

    public void setRadiusClip(double r) {
        this.radiusBD = r;
    }

    public double getRadiusClip() {
        return this.radiusBD;
    }

    public void setRadiusMid(double r) {
        this.radiusMid = r;
    }

    public double getRadiusMid() {
        return this.radiusMid;
    }

    public void setRadiusDif(double r) {
        this.radiusDif = r;
    }

    public double getRadiusDif() {
        return this.radiusDif;
    }
}

