/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.QCShewhartChart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCLineConnector;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarCircle;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class QCStar
extends AQCStar {
    public QCStarCircle[] refs;
    public QCStarLabel[] labels;
    public QCLineConnector connect;
    public boolean useColorAlpha;
    public float infillOpacity;

    public QCStar(AQCStar.StarType type) {
        super((ATransform)new Transform());
        this.type = type;
        this.dataModel.setView(this);
        this.graphModel.setView(this);
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean starOn;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel ch = ba.getChannel();
        int index = ba.getValueIndex();
        if (this.igrpLower != -1 && index < this.igrpLower) {
            return;
        }
        if (this.igrpUpper != -1 && index > this.igrpUpper) {
            return;
        }
        QCShewhartChart chart = QCShewhart.getCurrentChart();
        boolean bl = starOn = this.edgeOn.getValue(index) || this.spokesOn.getValue(index) || this.fillOn.getValue(index);
        if (starOn) {
            double[] vx = this.graphModel.getVertexX(index);
            double[] vy = this.graphModel.getVertexY(index);
            double[] cx = this.graphModel.getCoronaX(index);
            double[] cy = this.graphModel.getCoronaY(index);
            Color cFill = null;
            if (this.outfillOn.getValue(index)) {
                NumericVectorVariable yVar = (NumericVectorVariable)this.dataModel.getY();
                double y = yVar.value.getValue(index);
                cFill = chart.isResponseOOC(y, index) ? this.outfillColor.getValue(index) : this.color.getValue(index);
            } else {
                cFill = this.color.getValue(index);
            }
            if (cFill != null && this.useColorAlpha) {
                int alpha = (int)(255.0 * (double)this.infillOpacity);
                cFill = new Color(cFill.getRed(), cFill.getGreen(), cFill.getBlue(), alpha);
            }
            int nVertex = this.graphModel.nVertex;
            ColorVector cSpoke = this.graphModel.spokeColorList;
            Color cSpokeOut = this.outspokeColor.getValue(index);
            Color cEdge = this.edgeColor.getValue(index);
            Color cFillOut = this.outfillColor.getValue(index);
            IntegerVector spokeStipplePattern = this.graphModel.spokeStipplePattern;
            IntegerVector spokeStippleFactor = this.graphModel.spokeStippleFactor;
            int oocstipplePattern = this.getOOCStipplePattern();
            int oocstippleFactor = this.getOOCStippleFactor();
            if (cFillOut != null && this.useColorAlpha) {
                int alpha = (int)(255.0 * (double)this.infillOpacity);
                cFillOut = new Color(cFillOut.getRed(), cFillOut.getGreen(), cFillOut.getBlue(), alpha);
            }
            this.drawStar(ba, this.xCenter.getValue(index), this.yCenter.getValue(index), vx, vy, cx, cy, cFill, cEdge, cSpoke, cFillOut, cSpokeOut, (float)this.lineWidth.getValue(index), spokeStipplePattern, spokeStippleFactor, oocstipplePattern, oocstippleFactor, this.edgeOn.getValue(index), this.spokesOn.getValue(index), this.spokeOutOn.getValue(index), this.fillOn.getValue(index));
        }
        if (this.labelsOn.getValue(index)) {
            this.drawLabels(ba);
        }
    }

    private void drawStar(BuildAction ba, double xCenter, double yCenter, double[] vx, double[] vy, double[] cx, double[] cy, Color color, Color edgeColor, ColorVector spokeColorList, Color outColor, Color outspokeColor, float lineWidth, IntegerVector spokeStipplePatternList, IntegerVector spokeStippleFactorList, int oocstipplePattern, int oocstippleFactor, boolean edgeOn, boolean spokesOn, boolean outSpokeOn, boolean fillOn) throws MissingValueException {
        int i;
        Channel ch = ba.getChannel();
        int index = ba.getValueIndex();
        int nVertex = this.graphModel.nVertex;
        boolean corona = cx != null && cy != null;
        boolean edgeStippleOn = this.stippleFactor > 0;
        boolean spokeStippleOn = false;
        ch.glPushAttrib(0);
        ch.setLineJoinStyle(2);
        ch.setLineCapStyle(1);
        if (fillOn && color != null) {
            ch.glColor(color);
            ch.glBegin(2);
            ch.glNormal(0.0, 0.0, 1.0);
            for (i = 0; i < nVertex; ++i) {
                ch.glVertex(xCenter + vx[i], yCenter + vy[i], 0.0);
                if (!corona) continue;
                ch.glVertex(xCenter + cx[i], yCenter + cy[i], 0.0);
            }
            ch.glEnd();
        }
        if (this.refsOn.getValue(index)) {
            this.drawRefs(ba);
        }
        if (spokesOn) {
            double width = this.spokeWidth.getValue();
            double innerpx = this.graphModel.getRadiusInner();
            double outerpx = this.graphModel.getRadiusOuter();
            double inner = this.dataModel.getRadiusInner();
            double outer = this.dataModel.getRadiusOuter();
            double[] temp = new double[3];
            ch.glLineWidth((float)width);
            for (i = 0; i < nVertex; ++i) {
                Color spokeColor = spokeColorList == null ? edgeColor : spokeColorList.getValue(i);
                int spokeStippleFactor = spokeStippleFactorList.getValue(i);
                int spokeStipplePattern = spokeStipplePatternList.getValue(i);
                spokeStippleOn = spokeStippleFactor > 0;
                this.graphModel.computeVertex(i, innerpx, temp);
                double xi = xCenter + temp[0];
                double yi = yCenter + temp[1];
                double rValue = this.dataModel.getRValue(index, i);
                if (outSpokeOn) {
                    if (rValue < inner) {
                        ch.glBegin(1);
                        ch.glColor(outspokeColor);
                        if (spokeStippleOn) {
                            ch.glEnable(6);
                            ch.glLineStipple(oocstippleFactor, (int)((short)oocstipplePattern));
                        }
                        if (this.type == AQCStar.StarType.SPOKE) {
                            ch.glVertex(xi, yi);
                        } else {
                            ch.glVertex(xCenter, yCenter);
                        }
                        ch.glVertex(xCenter + vx[i], yCenter + vy[i]);
                        ch.glEnd();
                        if (!spokeStippleOn) continue;
                        ch.glDisable(6);
                        continue;
                    }
                    if (rValue > outer) {
                        this.graphModel.computeVertex(i, outerpx, temp);
                        double xo = xCenter + temp[0];
                        double yo = yCenter + temp[1];
                        ch.glBegin(1);
                        ch.glColor(spokeColor);
                        if (this.type == AQCStar.StarType.SPOKE) {
                            ch.glVertex(xi, yi);
                        } else {
                            ch.glVertex(xCenter, yCenter);
                        }
                        ch.glVertex(xo, yo);
                        ch.glEnd();
                        ch.glBegin(1);
                        ch.glColor(outspokeColor);
                        if (spokeStippleOn) {
                            ch.glEnable(6);
                            ch.glLineStipple(oocstippleFactor, (int)((short)oocstipplePattern));
                        }
                        ch.glVertex(xo, yo);
                        ch.glVertex(xCenter + vx[i], yCenter + vy[i]);
                        ch.glEnd();
                        if (!spokeStippleOn) continue;
                        ch.glDisable(6);
                        continue;
                    }
                    ch.glBegin(1);
                    ch.glColor(spokeColor);
                    if (spokeStippleOn) {
                        ch.glEnable(6);
                        ch.glLineStipple(spokeStippleFactor, (int)((short)spokeStipplePattern));
                    }
                    if (this.type == AQCStar.StarType.SPOKE) {
                        ch.glVertex(xi, yi);
                    } else {
                        ch.glVertex(xCenter, yCenter);
                    }
                    ch.glVertex(xCenter + vx[i], yCenter + vy[i]);
                    ch.glEnd();
                    if (!spokeStippleOn) continue;
                    ch.glDisable(6);
                    continue;
                }
                ch.glBegin(1);
                ch.glColor(spokeColor);
                if (spokeStippleOn) {
                    ch.glEnable(6);
                    ch.glLineStipple(spokeStippleFactor, (int)((short)spokeStipplePattern));
                }
                if (this.type == AQCStar.StarType.SPOKE) {
                    ch.glVertex(xi, yi);
                } else {
                    ch.glVertex(xCenter, yCenter);
                }
                ch.glVertex(xCenter + vx[i], yCenter + vy[i]);
                ch.glEnd();
                if (!spokeStippleOn) continue;
                ch.glDisable(6);
            }
        }
        if (edgeOn && edgeColor != null) {
            ch.glColor(edgeColor);
            ch.glLineWidth(lineWidth);
            if (edgeStippleOn) {
                ch.glEnable(6);
                ch.glLineStipple(this.stippleFactor, (int)((short)this.stipplePattern));
            }
            ch.glBegin(1);
            ch.glNormal(0.0, 0.0, 1.0);
            for (i = 0; i < nVertex; ++i) {
                ch.glVertex(xCenter + vx[i], yCenter + vy[i], 0.0);
                if (!corona) continue;
                ch.glVertex(xCenter + cx[i], yCenter + cy[i], 0.0);
            }
            ch.glVertex(xCenter + vx[0], yCenter + vy[0], 0.0);
            ch.glEnd();
            if (edgeStippleOn) {
                ch.glDisable(6);
            }
        }
        ch.glPopAttrib();
    }

    private void drawRefs(BuildAction ba) throws MissingValueException {
        Channel ch = ba.getChannel();
        int index = ba.getValueIndex();
        ch.glPushAttrib(0);
        for (QCStarCircle ref : this.refs) {
            if (ref == null) continue;
            ref.render((ABuildAction)ba);
        }
        ch.glPopAttrib();
    }

    private void drawLabels(BuildAction ba) throws MissingValueException {
        Channel ch = ba.getChannel();
        int index = ba.getValueIndex();
        int i = (int)this.labelType.getValue(index);
        QCStarLabel.StarLabel type = QCStarLabel.StarLabel.fromInteger(i);
        if (this.labels == null || type == QCStarLabel.StarLabel.NONE || type == QCStarLabel.StarLabel.DEFAULT) {
            return;
        }
        ch.glPushAttrib(0);
        int nVertex = this.graphModel.nVertex;
        boolean draw = false;
        for (i = 0; i < nVertex; ++i) {
            QCStarLabel label = this.labels[i];
            if (label == null) continue;
            switch (type) {
                case FIRST: {
                    draw = index == 0;
                    break;
                }
                case ALL: {
                    draw = true;
                    break;
                }
                case LOW: {
                    draw = this.dataModel.getVLow(index, i);
                    break;
                }
                case HIGH: {
                    draw = this.dataModel.getVHigh(index, i);
                    break;
                }
                case OUT: {
                    draw = this.dataModel.getVOut(index, i);
                    break;
                }
                default: {
                    draw = false;
                }
            }
            if (!draw) continue;
            label.render((ABuildAction)ba);
        }
        ch.glPopAttrib();
    }

    public void updateGraphModel() {
        this.graphModel.build();
    }

    public void setY(Variable y) {
        this.dataModel.setY(y);
    }

    public void setVertexVars(Variable[] vars) {
        this.dataModel.setVertexVars(vars);
    }

    public void setSubgrpMapper(NumericMapper mapper) {
        this.graphModel.setSubgrpMapper(mapper);
    }

    public void setResponseMapper(NumericMapper mapper) {
        this.graphModel.setResponseMapper(mapper);
    }

    public void setEncoder(byte dimension, Encoder encoder) {
        this.graphModel.setEncoder(dimension, encoder);
    }

    public void init() {
        this.graphModel.init();
    }

    public void setLabelStyle(TextStyle style) {
        this.graphModel.labelStyle = style;
    }

    public void setSpokeColors(ColorVector v) {
        this.graphModel.spokeColorList = v;
    }

    public void setSpokePatterns(NumericVector v) {
        this.graphModel.spokePatternList = v;
    }

    public void setSpokeStipplePatterns(IntegerVector v) {
        this.graphModel.spokeStipplePattern = v;
    }

    public void setSpokeStippleFactors(IntegerVector v) {
        this.graphModel.spokeStippleFactor = v;
    }
}

